# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetResourceTypesResult',
    'AwaitableGetResourceTypesResult',
    'get_resource_types',
    'get_resource_types_output',
]

@pulumi.output_type
class GetResourceTypesResult:
    """
    A collection of values returned by getResourceTypes.
    """
    def __init__(__self__, id=None, ids=None, output_file=None, product=None, types=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if product and not isinstance(product, str):
            raise TypeError("Expected argument 'product' to be a str")
        pulumi.set(__self__, "product", product)
        if types and not isinstance(types, list):
            raise TypeError("Expected argument 'types' to be a list")
        pulumi.set(__self__, "types", types)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Resource Type IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def product(self) -> _builtins.str:
        """
        Product Code.
        """
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter
    def types(self) -> Sequence['outputs.GetResourceTypesTypeResult']:
        """
        A list of Resource Type Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "types")


class AwaitableGetResourceTypesResult(GetResourceTypesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceTypesResult(
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            product=self.product,
            types=self.types)


def get_resource_types(ids: Optional[Sequence[_builtins.str]] = None,
                       output_file: Optional[_builtins.str] = None,
                       product: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceTypesResult:
    """
    This data source provides Cloud Control Resource Type available to the user.[What is Resource Type](https://next.api.aliyun.com/document/cloudcontrol/2022-08-30/GetResourceType)

    > **NOTE:** Available since v1.241.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.cloudcontrol.get_resource_types(product="VPC",
        ids=["VSwitch"])
    ```


    :param Sequence[_builtins.str] ids: A list of Resource Type IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str product: Product Code.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['product'] = product
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cloudcontrol/getResourceTypes:getResourceTypes', __args__, opts=opts, typ=GetResourceTypesResult).value

    return AwaitableGetResourceTypesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        product=pulumi.get(__ret__, 'product'),
        types=pulumi.get(__ret__, 'types'))
def get_resource_types_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                              output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              product: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceTypesResult]:
    """
    This data source provides Cloud Control Resource Type available to the user.[What is Resource Type](https://next.api.aliyun.com/document/cloudcontrol/2022-08-30/GetResourceType)

    > **NOTE:** Available since v1.241.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.cloudcontrol.get_resource_types(product="VPC",
        ids=["VSwitch"])
    ```


    :param Sequence[_builtins.str] ids: A list of Resource Type IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str product: Product Code.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['product'] = product
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cloudcontrol/getResourceTypes:getResourceTypes', __args__, opts=opts, typ=GetResourceTypesResult)
    return __ret__.apply(lambda __response__: GetResourceTypesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        product=pulumi.get(__response__, 'product'),
        types=pulumi.get(__response__, 'types')))
