# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVpcFirewallCensResult',
    'AwaitableGetVpcFirewallCensResult',
    'get_vpc_firewall_cens',
    'get_vpc_firewall_cens_output',
]

@pulumi.output_type
class GetVpcFirewallCensResult:
    """
    A collection of values returned by getVpcFirewallCens.
    """
    def __init__(__self__, cen_id=None, cens=None, id=None, ids=None, lang=None, member_uid=None, network_instance_id=None, output_file=None, page_number=None, page_size=None, status=None, vpc_firewall_id=None, vpc_firewall_name=None):
        if cen_id and not isinstance(cen_id, str):
            raise TypeError("Expected argument 'cen_id' to be a str")
        pulumi.set(__self__, "cen_id", cen_id)
        if cens and not isinstance(cens, list):
            raise TypeError("Expected argument 'cens' to be a list")
        pulumi.set(__self__, "cens", cens)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if lang and not isinstance(lang, str):
            raise TypeError("Expected argument 'lang' to be a str")
        pulumi.set(__self__, "lang", lang)
        if member_uid and not isinstance(member_uid, str):
            raise TypeError("Expected argument 'member_uid' to be a str")
        pulumi.set(__self__, "member_uid", member_uid)
        if network_instance_id and not isinstance(network_instance_id, str):
            raise TypeError("Expected argument 'network_instance_id' to be a str")
        pulumi.set(__self__, "network_instance_id", network_instance_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vpc_firewall_id and not isinstance(vpc_firewall_id, str):
            raise TypeError("Expected argument 'vpc_firewall_id' to be a str")
        pulumi.set(__self__, "vpc_firewall_id", vpc_firewall_id)
        if vpc_firewall_name and not isinstance(vpc_firewall_name, str):
            raise TypeError("Expected argument 'vpc_firewall_name' to be a str")
        pulumi.set(__self__, "vpc_firewall_name", vpc_firewall_name)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[_builtins.str]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter
    def cens(self) -> Sequence['outputs.GetVpcFirewallCensCenResult']:
        """
        A list of Vpc Firewall Cen Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "cens")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Vpc Firewall Cen IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter(name="memberUid")
    def member_uid(self) -> Optional[_builtins.str]:
        """
        The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
        """
        return pulumi.get(self, "member_uid")

    @_builtins.property
    @pulumi.getter(name="networkInstanceId")
    def network_instance_id(self) -> Optional[_builtins.str]:
        """
        The ID of the VPC instance that created the VPC firewall.
        """
        return pulumi.get(self, "network_instance_id")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Firewall switch status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcFirewallId")
    def vpc_firewall_id(self) -> Optional[_builtins.str]:
        """
        VPC firewall ID
        """
        return pulumi.get(self, "vpc_firewall_id")

    @_builtins.property
    @pulumi.getter(name="vpcFirewallName")
    def vpc_firewall_name(self) -> Optional[_builtins.str]:
        """
        The name of the VPC firewall instance.
        """
        return pulumi.get(self, "vpc_firewall_name")


class AwaitableGetVpcFirewallCensResult(GetVpcFirewallCensResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcFirewallCensResult(
            cen_id=self.cen_id,
            cens=self.cens,
            id=self.id,
            ids=self.ids,
            lang=self.lang,
            member_uid=self.member_uid,
            network_instance_id=self.network_instance_id,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            status=self.status,
            vpc_firewall_id=self.vpc_firewall_id,
            vpc_firewall_name=self.vpc_firewall_name)


def get_vpc_firewall_cens(cen_id: Optional[_builtins.str] = None,
                          ids: Optional[Sequence[_builtins.str]] = None,
                          lang: Optional[_builtins.str] = None,
                          member_uid: Optional[_builtins.str] = None,
                          network_instance_id: Optional[_builtins.str] = None,
                          output_file: Optional[_builtins.str] = None,
                          page_number: Optional[_builtins.int] = None,
                          page_size: Optional[_builtins.int] = None,
                          status: Optional[_builtins.str] = None,
                          vpc_firewall_id: Optional[_builtins.str] = None,
                          vpc_firewall_name: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcFirewallCensResult:
    """
    This data source provides Cloud Firewall Vpc Firewall Cen available to the user.[What is Vpc Firewall Cen](https://www.alibabacloud.com/help/en/cloud-firewall/latest/describevpcfirewallcenlist)

    > **NOTE:** Available since v1.194.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cloudfirewall.get_vpc_firewall_cens(ids=[default_alicloud_cloud_firewall_vpc_firewall_cen["id"]],
        cen_id="cen-cjok7uyb5w2b27573v",
        member_uid="1415189284827022",
        status="closed",
        vpc_firewall_name="tf-test")
    pulumi.export("alicloudCloudFirewallVpcFirewallCenExampleId", default.cens[0].id)
    ```


    :param _builtins.str cen_id: The ID of the CEN instance.
    :param Sequence[_builtins.str] ids: A list of Vpc Firewall Cen IDs.
    :param _builtins.str lang: The language type of the requested and received messages. Value:-**zh** (default): Chinese.-**en**: English.
    :param _builtins.str member_uid: The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
    :param _builtins.str network_instance_id: The ID of the VPC instance that created the VPC firewall.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: Firewall switch status
    :param _builtins.str vpc_firewall_id: VPC firewall ID
    :param _builtins.str vpc_firewall_name: The name of the VPC firewall instance.
    """
    __args__ = dict()
    __args__['cenId'] = cen_id
    __args__['ids'] = ids
    __args__['lang'] = lang
    __args__['memberUid'] = member_uid
    __args__['networkInstanceId'] = network_instance_id
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['status'] = status
    __args__['vpcFirewallId'] = vpc_firewall_id
    __args__['vpcFirewallName'] = vpc_firewall_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cloudfirewall/getVpcFirewallCens:getVpcFirewallCens', __args__, opts=opts, typ=GetVpcFirewallCensResult).value

    return AwaitableGetVpcFirewallCensResult(
        cen_id=pulumi.get(__ret__, 'cen_id'),
        cens=pulumi.get(__ret__, 'cens'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        lang=pulumi.get(__ret__, 'lang'),
        member_uid=pulumi.get(__ret__, 'member_uid'),
        network_instance_id=pulumi.get(__ret__, 'network_instance_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        status=pulumi.get(__ret__, 'status'),
        vpc_firewall_id=pulumi.get(__ret__, 'vpc_firewall_id'),
        vpc_firewall_name=pulumi.get(__ret__, 'vpc_firewall_name'))
def get_vpc_firewall_cens_output(cen_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 lang: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 member_uid: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 network_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                 page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                 status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 vpc_firewall_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 vpc_firewall_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcFirewallCensResult]:
    """
    This data source provides Cloud Firewall Vpc Firewall Cen available to the user.[What is Vpc Firewall Cen](https://www.alibabacloud.com/help/en/cloud-firewall/latest/describevpcfirewallcenlist)

    > **NOTE:** Available since v1.194.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cloudfirewall.get_vpc_firewall_cens(ids=[default_alicloud_cloud_firewall_vpc_firewall_cen["id"]],
        cen_id="cen-cjok7uyb5w2b27573v",
        member_uid="1415189284827022",
        status="closed",
        vpc_firewall_name="tf-test")
    pulumi.export("alicloudCloudFirewallVpcFirewallCenExampleId", default.cens[0].id)
    ```


    :param _builtins.str cen_id: The ID of the CEN instance.
    :param Sequence[_builtins.str] ids: A list of Vpc Firewall Cen IDs.
    :param _builtins.str lang: The language type of the requested and received messages. Value:-**zh** (default): Chinese.-**en**: English.
    :param _builtins.str member_uid: The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
    :param _builtins.str network_instance_id: The ID of the VPC instance that created the VPC firewall.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: Firewall switch status
    :param _builtins.str vpc_firewall_id: VPC firewall ID
    :param _builtins.str vpc_firewall_name: The name of the VPC firewall instance.
    """
    __args__ = dict()
    __args__['cenId'] = cen_id
    __args__['ids'] = ids
    __args__['lang'] = lang
    __args__['memberUid'] = member_uid
    __args__['networkInstanceId'] = network_instance_id
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['status'] = status
    __args__['vpcFirewallId'] = vpc_firewall_id
    __args__['vpcFirewallName'] = vpc_firewall_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cloudfirewall/getVpcFirewallCens:getVpcFirewallCens', __args__, opts=opts, typ=GetVpcFirewallCensResult)
    return __ret__.apply(lambda __response__: GetVpcFirewallCensResult(
        cen_id=pulumi.get(__response__, 'cen_id'),
        cens=pulumi.get(__response__, 'cens'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        lang=pulumi.get(__response__, 'lang'),
        member_uid=pulumi.get(__response__, 'member_uid'),
        network_instance_id=pulumi.get(__response__, 'network_instance_id'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        status=pulumi.get(__response__, 'status'),
        vpc_firewall_id=pulumi.get(__response__, 'vpc_firewall_id'),
        vpc_firewall_name=pulumi.get(__response__, 'vpc_firewall_name')))
