# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NatFirewallArgs', 'NatFirewall']

@pulumi.input_type
class NatFirewallArgs:
    def __init__(__self__, *,
                 nat_gateway_id: pulumi.Input[_builtins.str],
                 nat_route_entry_lists: pulumi.Input[Sequence[pulumi.Input['NatFirewallNatRouteEntryListArgs']]],
                 proxy_name: pulumi.Input[_builtins.str],
                 region_no: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 firewall_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 strict_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 vswitch_auto: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NatFirewall resource.
        :param pulumi.Input[_builtins.str] nat_gateway_id: NAT gateway ID.
        :param pulumi.Input[Sequence[pulumi.Input['NatFirewallNatRouteEntryListArgs']]] nat_route_entry_lists: The list of routes to be switched by the NAT gateway. See `nat_route_entry_list` below.
        :param pulumi.Input[_builtins.str] proxy_name: NAT firewall name.
        :param pulumi.Input[_builtins.str] region_no: Region.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC instance.
        :param pulumi.Input[_builtins.str] firewall_switch: Safety protection switch. Value:-**open**: open-**close**: close.
        :param pulumi.Input[_builtins.str] lang: Lang.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.int] strict_mode: Whether strict mode is enabled 1-Enable strict mode 0-Disable strict mode.
        :param pulumi.Input[_builtins.str] vswitch_auto: Whether to use switch automatic mode. Value: **true**: Use automatic mode: **false**: Use manual mode.
        :param pulumi.Input[_builtins.str] vswitch_cidr: The network segment of the virtual switch. Required for Switch automatic mode.
        :param pulumi.Input[_builtins.str] vswitch_id: The switch ID. Required for switch manual mode.
        """
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "nat_route_entry_lists", nat_route_entry_lists)
        pulumi.set(__self__, "proxy_name", proxy_name)
        pulumi.set(__self__, "region_no", region_no)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if firewall_switch is not None:
            pulumi.set(__self__, "firewall_switch", firewall_switch)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if strict_mode is not None:
            pulumi.set(__self__, "strict_mode", strict_mode)
        if vswitch_auto is not None:
            pulumi.set(__self__, "vswitch_auto", vswitch_auto)
        if vswitch_cidr is not None:
            pulumi.set(__self__, "vswitch_cidr", vswitch_cidr)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        NAT gateway ID.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nat_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="natRouteEntryLists")
    def nat_route_entry_lists(self) -> pulumi.Input[Sequence[pulumi.Input['NatFirewallNatRouteEntryListArgs']]]:
        """
        The list of routes to be switched by the NAT gateway. See `nat_route_entry_list` below.
        """
        return pulumi.get(self, "nat_route_entry_lists")

    @nat_route_entry_lists.setter
    def nat_route_entry_lists(self, value: pulumi.Input[Sequence[pulumi.Input['NatFirewallNatRouteEntryListArgs']]]):
        pulumi.set(self, "nat_route_entry_lists", value)

    @_builtins.property
    @pulumi.getter(name="proxyName")
    def proxy_name(self) -> pulumi.Input[_builtins.str]:
        """
        NAT firewall name.
        """
        return pulumi.get(self, "proxy_name")

    @proxy_name.setter
    def proxy_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "proxy_name", value)

    @_builtins.property
    @pulumi.getter(name="regionNo")
    def region_no(self) -> pulumi.Input[_builtins.str]:
        """
        Region.
        """
        return pulumi.get(self, "region_no")

    @region_no.setter
    def region_no(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region_no", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VPC instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="firewallSwitch")
    def firewall_switch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Safety protection switch. Value:-**open**: open-**close**: close.
        """
        return pulumi.get(self, "firewall_switch")

    @firewall_switch.setter
    def firewall_switch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firewall_switch", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Lang.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="strictMode")
    def strict_mode(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Whether strict mode is enabled 1-Enable strict mode 0-Disable strict mode.
        """
        return pulumi.get(self, "strict_mode")

    @strict_mode.setter
    def strict_mode(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "strict_mode", value)

    @_builtins.property
    @pulumi.getter(name="vswitchAuto")
    def vswitch_auto(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to use switch automatic mode. Value: **true**: Use automatic mode: **false**: Use manual mode.
        """
        return pulumi.get(self, "vswitch_auto")

    @vswitch_auto.setter
    def vswitch_auto(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_auto", value)

    @_builtins.property
    @pulumi.getter(name="vswitchCidr")
    def vswitch_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network segment of the virtual switch. Required for Switch automatic mode.
        """
        return pulumi.get(self, "vswitch_cidr")

    @vswitch_cidr.setter
    def vswitch_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_cidr", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The switch ID. Required for switch manual mode.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.input_type
class _NatFirewallState:
    def __init__(__self__, *,
                 firewall_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_route_entry_lists: Optional[pulumi.Input[Sequence[pulumi.Input['NatFirewallNatRouteEntryListArgs']]]] = None,
                 proxy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_no: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 strict_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_auto: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NatFirewall resources.
        :param pulumi.Input[_builtins.str] firewall_switch: Safety protection switch. Value:-**open**: open-**close**: close.
        :param pulumi.Input[_builtins.str] lang: Lang.
        :param pulumi.Input[_builtins.str] nat_gateway_id: NAT gateway ID.
        :param pulumi.Input[Sequence[pulumi.Input['NatFirewallNatRouteEntryListArgs']]] nat_route_entry_lists: The list of routes to be switched by the NAT gateway. See `nat_route_entry_list` below.
        :param pulumi.Input[_builtins.str] proxy_name: NAT firewall name.
        :param pulumi.Input[_builtins.str] region_no: Region.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.int] strict_mode: Whether strict mode is enabled 1-Enable strict mode 0-Disable strict mode.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC instance.
        :param pulumi.Input[_builtins.str] vswitch_auto: Whether to use switch automatic mode. Value: **true**: Use automatic mode: **false**: Use manual mode.
        :param pulumi.Input[_builtins.str] vswitch_cidr: The network segment of the virtual switch. Required for Switch automatic mode.
        :param pulumi.Input[_builtins.str] vswitch_id: The switch ID. Required for switch manual mode.
        """
        if firewall_switch is not None:
            pulumi.set(__self__, "firewall_switch", firewall_switch)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if nat_gateway_id is not None:
            pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if nat_route_entry_lists is not None:
            pulumi.set(__self__, "nat_route_entry_lists", nat_route_entry_lists)
        if proxy_name is not None:
            pulumi.set(__self__, "proxy_name", proxy_name)
        if region_no is not None:
            pulumi.set(__self__, "region_no", region_no)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if strict_mode is not None:
            pulumi.set(__self__, "strict_mode", strict_mode)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_auto is not None:
            pulumi.set(__self__, "vswitch_auto", vswitch_auto)
        if vswitch_cidr is not None:
            pulumi.set(__self__, "vswitch_cidr", vswitch_cidr)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="firewallSwitch")
    def firewall_switch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Safety protection switch. Value:-**open**: open-**close**: close.
        """
        return pulumi.get(self, "firewall_switch")

    @firewall_switch.setter
    def firewall_switch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firewall_switch", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Lang.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        NAT gateway ID.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="natRouteEntryLists")
    def nat_route_entry_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NatFirewallNatRouteEntryListArgs']]]]:
        """
        The list of routes to be switched by the NAT gateway. See `nat_route_entry_list` below.
        """
        return pulumi.get(self, "nat_route_entry_lists")

    @nat_route_entry_lists.setter
    def nat_route_entry_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NatFirewallNatRouteEntryListArgs']]]]):
        pulumi.set(self, "nat_route_entry_lists", value)

    @_builtins.property
    @pulumi.getter(name="proxyName")
    def proxy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        NAT firewall name.
        """
        return pulumi.get(self, "proxy_name")

    @proxy_name.setter
    def proxy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_name", value)

    @_builtins.property
    @pulumi.getter(name="regionNo")
    def region_no(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region.
        """
        return pulumi.get(self, "region_no")

    @region_no.setter
    def region_no(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_no", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="strictMode")
    def strict_mode(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Whether strict mode is enabled 1-Enable strict mode 0-Disable strict mode.
        """
        return pulumi.get(self, "strict_mode")

    @strict_mode.setter
    def strict_mode(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "strict_mode", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchAuto")
    def vswitch_auto(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to use switch automatic mode. Value: **true**: Use automatic mode: **false**: Use manual mode.
        """
        return pulumi.get(self, "vswitch_auto")

    @vswitch_auto.setter
    def vswitch_auto(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_auto", value)

    @_builtins.property
    @pulumi.getter(name="vswitchCidr")
    def vswitch_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network segment of the virtual switch. Required for Switch automatic mode.
        """
        return pulumi.get(self, "vswitch_cidr")

    @vswitch_cidr.setter
    def vswitch_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_cidr", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The switch ID. Required for switch manual mode.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:cloudfirewall/natFirewall:NatFirewall")
class NatFirewall(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 firewall_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_route_entry_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NatFirewallNatRouteEntryListArgs', 'NatFirewallNatRouteEntryListArgsDict']]]]] = None,
                 proxy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_no: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 strict_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_auto: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Firewall Nat Firewall resource.

        For information about Cloud Firewall Nat Firewall and how to use it, see [What is Nat Firewall](https://www.alibabacloud.com/help/zh/cloud-firewall/developer-reference/api-cloudfw-2017-12-07-createsecurityproxy).

        > **NOTE:** Available since v1.224.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        defaultik_z0g_d = alicloud.vpc.Network("defaultikZ0gD",
            cidr_block="172.16.0.0/12",
            vpc_name=name)
        defaultp4_o7qi = alicloud.vpc.Switch("defaultp4O7qi",
            vpc_id=defaultik_z0g_d.id,
            cidr_block="172.16.6.0/24",
            vswitch_name=name,
            zone_id=default.zones[0].id)
        default2i_r_zp_c = alicloud.vpc.NatGateway("default2iRZpC",
            eip_bind_mode="MULTI_BINDED",
            vpc_id=defaultik_z0g_d.id,
            nat_gateway_name=name,
            payment_type="PayAsYouGo",
            vswitch_id=defaultp4_o7qi.id,
            nat_type="Enhanced",
            network_type="internet")
        defaultyi_rwgs = alicloud.ecs.EipAddress("defaultyiRwgs", address_name=name)
        defaults2_m_tu_o = alicloud.ecs.EipAssociation("defaults2MTuO",
            instance_id=default2i_r_zp_c.id,
            allocation_id=defaultyi_rwgs.id,
            mode="NAT",
            instance_type="Nat")
        default_ake43g = alicloud.vpc.SnatEntry("defaultAKE43g",
            snat_ip=defaultyi_rwgs.ip_address,
            snat_table_id=default2i_r_zp_c.snat_table_ids,
            source_vswitch_id=defaultp4_o7qi.id)
        default_nat_firewall = alicloud.cloudfirewall.NatFirewall("default",
            nat_gateway_id=default2i_r_zp_c.id,
            nat_route_entry_lists=[{
                "nexthop_type": "NatGateway",
                "route_table_id": defaultik_z0g_d.route_table_id,
                "nexthop_id": default2i_r_zp_c.id,
                "destination_cidr": "0.0.0.0/0",
            }],
            firewall_switch="close",
            vswitch_auto="true",
            status="closed",
            region_no="cn-shenzhen",
            lang="zh",
            proxy_name="CFW-example",
            vswitch_id=default_ake43g.source_vswitch_id,
            strict_mode=0,
            vpc_id=defaultik_z0g_d.id,
            vswitch_cidr="172.16.5.0/24")
        ```

        ## Import

        Cloud Firewall Nat Firewall can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudfirewall/natFirewall:NatFirewall example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] firewall_switch: Safety protection switch. Value:-**open**: open-**close**: close.
        :param pulumi.Input[_builtins.str] lang: Lang.
        :param pulumi.Input[_builtins.str] nat_gateway_id: NAT gateway ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NatFirewallNatRouteEntryListArgs', 'NatFirewallNatRouteEntryListArgsDict']]]] nat_route_entry_lists: The list of routes to be switched by the NAT gateway. See `nat_route_entry_list` below.
        :param pulumi.Input[_builtins.str] proxy_name: NAT firewall name.
        :param pulumi.Input[_builtins.str] region_no: Region.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.int] strict_mode: Whether strict mode is enabled 1-Enable strict mode 0-Disable strict mode.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC instance.
        :param pulumi.Input[_builtins.str] vswitch_auto: Whether to use switch automatic mode. Value: **true**: Use automatic mode: **false**: Use manual mode.
        :param pulumi.Input[_builtins.str] vswitch_cidr: The network segment of the virtual switch. Required for Switch automatic mode.
        :param pulumi.Input[_builtins.str] vswitch_id: The switch ID. Required for switch manual mode.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NatFirewallArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Firewall Nat Firewall resource.

        For information about Cloud Firewall Nat Firewall and how to use it, see [What is Nat Firewall](https://www.alibabacloud.com/help/zh/cloud-firewall/developer-reference/api-cloudfw-2017-12-07-createsecurityproxy).

        > **NOTE:** Available since v1.224.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        defaultik_z0g_d = alicloud.vpc.Network("defaultikZ0gD",
            cidr_block="172.16.0.0/12",
            vpc_name=name)
        defaultp4_o7qi = alicloud.vpc.Switch("defaultp4O7qi",
            vpc_id=defaultik_z0g_d.id,
            cidr_block="172.16.6.0/24",
            vswitch_name=name,
            zone_id=default.zones[0].id)
        default2i_r_zp_c = alicloud.vpc.NatGateway("default2iRZpC",
            eip_bind_mode="MULTI_BINDED",
            vpc_id=defaultik_z0g_d.id,
            nat_gateway_name=name,
            payment_type="PayAsYouGo",
            vswitch_id=defaultp4_o7qi.id,
            nat_type="Enhanced",
            network_type="internet")
        defaultyi_rwgs = alicloud.ecs.EipAddress("defaultyiRwgs", address_name=name)
        defaults2_m_tu_o = alicloud.ecs.EipAssociation("defaults2MTuO",
            instance_id=default2i_r_zp_c.id,
            allocation_id=defaultyi_rwgs.id,
            mode="NAT",
            instance_type="Nat")
        default_ake43g = alicloud.vpc.SnatEntry("defaultAKE43g",
            snat_ip=defaultyi_rwgs.ip_address,
            snat_table_id=default2i_r_zp_c.snat_table_ids,
            source_vswitch_id=defaultp4_o7qi.id)
        default_nat_firewall = alicloud.cloudfirewall.NatFirewall("default",
            nat_gateway_id=default2i_r_zp_c.id,
            nat_route_entry_lists=[{
                "nexthop_type": "NatGateway",
                "route_table_id": defaultik_z0g_d.route_table_id,
                "nexthop_id": default2i_r_zp_c.id,
                "destination_cidr": "0.0.0.0/0",
            }],
            firewall_switch="close",
            vswitch_auto="true",
            status="closed",
            region_no="cn-shenzhen",
            lang="zh",
            proxy_name="CFW-example",
            vswitch_id=default_ake43g.source_vswitch_id,
            strict_mode=0,
            vpc_id=defaultik_z0g_d.id,
            vswitch_cidr="172.16.5.0/24")
        ```

        ## Import

        Cloud Firewall Nat Firewall can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudfirewall/natFirewall:NatFirewall example <id>
        ```

        :param str resource_name: The name of the resource.
        :param NatFirewallArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NatFirewallArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 firewall_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_route_entry_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NatFirewallNatRouteEntryListArgs', 'NatFirewallNatRouteEntryListArgsDict']]]]] = None,
                 proxy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_no: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 strict_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_auto: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NatFirewallArgs.__new__(NatFirewallArgs)

            __props__.__dict__["firewall_switch"] = firewall_switch
            __props__.__dict__["lang"] = lang
            if nat_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'nat_gateway_id'")
            __props__.__dict__["nat_gateway_id"] = nat_gateway_id
            if nat_route_entry_lists is None and not opts.urn:
                raise TypeError("Missing required property 'nat_route_entry_lists'")
            __props__.__dict__["nat_route_entry_lists"] = nat_route_entry_lists
            if proxy_name is None and not opts.urn:
                raise TypeError("Missing required property 'proxy_name'")
            __props__.__dict__["proxy_name"] = proxy_name
            if region_no is None and not opts.urn:
                raise TypeError("Missing required property 'region_no'")
            __props__.__dict__["region_no"] = region_no
            __props__.__dict__["status"] = status
            __props__.__dict__["strict_mode"] = strict_mode
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_auto"] = vswitch_auto
            __props__.__dict__["vswitch_cidr"] = vswitch_cidr
            __props__.__dict__["vswitch_id"] = vswitch_id
        super(NatFirewall, __self__).__init__(
            'alicloud:cloudfirewall/natFirewall:NatFirewall',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            firewall_switch: Optional[pulumi.Input[_builtins.str]] = None,
            lang: Optional[pulumi.Input[_builtins.str]] = None,
            nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            nat_route_entry_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NatFirewallNatRouteEntryListArgs', 'NatFirewallNatRouteEntryListArgsDict']]]]] = None,
            proxy_name: Optional[pulumi.Input[_builtins.str]] = None,
            region_no: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            strict_mode: Optional[pulumi.Input[_builtins.int]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_auto: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NatFirewall':
        """
        Get an existing NatFirewall resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] firewall_switch: Safety protection switch. Value:-**open**: open-**close**: close.
        :param pulumi.Input[_builtins.str] lang: Lang.
        :param pulumi.Input[_builtins.str] nat_gateway_id: NAT gateway ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NatFirewallNatRouteEntryListArgs', 'NatFirewallNatRouteEntryListArgsDict']]]] nat_route_entry_lists: The list of routes to be switched by the NAT gateway. See `nat_route_entry_list` below.
        :param pulumi.Input[_builtins.str] proxy_name: NAT firewall name.
        :param pulumi.Input[_builtins.str] region_no: Region.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.int] strict_mode: Whether strict mode is enabled 1-Enable strict mode 0-Disable strict mode.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC instance.
        :param pulumi.Input[_builtins.str] vswitch_auto: Whether to use switch automatic mode. Value: **true**: Use automatic mode: **false**: Use manual mode.
        :param pulumi.Input[_builtins.str] vswitch_cidr: The network segment of the virtual switch. Required for Switch automatic mode.
        :param pulumi.Input[_builtins.str] vswitch_id: The switch ID. Required for switch manual mode.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NatFirewallState.__new__(_NatFirewallState)

        __props__.__dict__["firewall_switch"] = firewall_switch
        __props__.__dict__["lang"] = lang
        __props__.__dict__["nat_gateway_id"] = nat_gateway_id
        __props__.__dict__["nat_route_entry_lists"] = nat_route_entry_lists
        __props__.__dict__["proxy_name"] = proxy_name
        __props__.__dict__["region_no"] = region_no
        __props__.__dict__["status"] = status
        __props__.__dict__["strict_mode"] = strict_mode
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_auto"] = vswitch_auto
        __props__.__dict__["vswitch_cidr"] = vswitch_cidr
        __props__.__dict__["vswitch_id"] = vswitch_id
        return NatFirewall(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="firewallSwitch")
    def firewall_switch(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Safety protection switch. Value:-**open**: open-**close**: close.
        """
        return pulumi.get(self, "firewall_switch")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Lang.
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        NAT gateway ID.
        """
        return pulumi.get(self, "nat_gateway_id")

    @_builtins.property
    @pulumi.getter(name="natRouteEntryLists")
    def nat_route_entry_lists(self) -> pulumi.Output[Sequence['outputs.NatFirewallNatRouteEntryList']]:
        """
        The list of routes to be switched by the NAT gateway. See `nat_route_entry_list` below.
        """
        return pulumi.get(self, "nat_route_entry_lists")

    @_builtins.property
    @pulumi.getter(name="proxyName")
    def proxy_name(self) -> pulumi.Output[_builtins.str]:
        """
        NAT firewall name.
        """
        return pulumi.get(self, "proxy_name")

    @_builtins.property
    @pulumi.getter(name="regionNo")
    def region_no(self) -> pulumi.Output[_builtins.str]:
        """
        Region.
        """
        return pulumi.get(self, "region_no")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="strictMode")
    def strict_mode(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Whether strict mode is enabled 1-Enable strict mode 0-Disable strict mode.
        """
        return pulumi.get(self, "strict_mode")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC instance.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchAuto")
    def vswitch_auto(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to use switch automatic mode. Value: **true**: Use automatic mode: **false**: Use manual mode.
        """
        return pulumi.get(self, "vswitch_auto")

    @_builtins.property
    @pulumi.getter(name="vswitchCidr")
    def vswitch_cidr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The network segment of the virtual switch. Required for Switch automatic mode.
        """
        return pulumi.get(self, "vswitch_cidr")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The switch ID. Required for switch manual mode.
        """
        return pulumi.get(self, "vswitch_id")

