# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GatewayArgs', 'Gateway']

@pulumi.input_type
class GatewayArgs:
    def __init__(__self__, *,
                 gateway_name: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 storage_bundle_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_class: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 reason_detail: Optional[pulumi.Input[_builtins.str]] = None,
                 reason_type: Optional[pulumi.Input[_builtins.str]] = None,
                 release_after_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Gateway resource.
        :param pulumi.Input[_builtins.str] gateway_name: The name of the gateway. The name must be `1` to `60` characters in length and can contain letters, digits, periods (.), underscores (_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[_builtins.str] location: The location of the gateway. Valid values: `Cloud`, `On_Premise`.
        :param pulumi.Input[_builtins.str] storage_bundle_id: The ID of the gateway cluster.
        :param pulumi.Input[_builtins.str] type: The type of the gateway. Valid values: `File`, `Iscsi`.
        :param pulumi.Input[_builtins.str] description: The description of the gateway.
        :param pulumi.Input[_builtins.str] gateway_class: The specification of the gateway. Valid values: `Basic`, `Standard`, `Enhanced`, `Advanced`. **NOTE:** If `location` is set to `Cloud`, `gateway_class` is required. Otherwise, `gateway_class` will be ignored. If `payment_type` is set to `Subscription`, `gateway_class` cannot be modified.
        :param pulumi.Input[_builtins.str] payment_type: The Payment type of gateway. Valid values: `PayAsYouGo`, `Subscription`. **NOTE:** From version 1.233.0, `payment_type` can be set to `Subscription`.
        :param pulumi.Input[_builtins.int] public_network_bandwidth: The public bandwidth of the gateway. Default value: `5`. Valid values: `5` to `200`. **NOTE:** `public_network_bandwidth` is only valid when `location` is `Cloud`. If `payment_type` is set to `Subscription`, `public_network_bandwidth` cannot be modified.
        :param pulumi.Input[_builtins.str] reason_detail: The detailed reason why you want to delete the gateway.
        :param pulumi.Input[_builtins.str] reason_type: The type of the reason why you want to delete the gateway.
        :param pulumi.Input[_builtins.bool] release_after_expiration: Specifies whether to release the gateway after the subscription expires. Valid values:
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the VSwitch. **NOTE:** If `location` is set to `Cloud`, `vswitch_id` is required. Otherwise, `vswitch_id` will be ignored.
        """
        pulumi.set(__self__, "gateway_name", gateway_name)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "storage_bundle_id", storage_bundle_id)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gateway_class is not None:
            pulumi.set(__self__, "gateway_class", gateway_class)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if public_network_bandwidth is not None:
            pulumi.set(__self__, "public_network_bandwidth", public_network_bandwidth)
        if reason_detail is not None:
            pulumi.set(__self__, "reason_detail", reason_detail)
        if reason_type is not None:
            pulumi.set(__self__, "reason_type", reason_type)
        if release_after_expiration is not None:
            pulumi.set(__self__, "release_after_expiration", release_after_expiration)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the gateway. The name must be `1` to `60` characters in length and can contain letters, digits, periods (.), underscores (_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "gateway_name")

    @gateway_name.setter
    def gateway_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gateway_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the gateway. Valid values: `Cloud`, `On_Premise`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="storageBundleId")
    def storage_bundle_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the gateway cluster.
        """
        return pulumi.get(self, "storage_bundle_id")

    @storage_bundle_id.setter
    def storage_bundle_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_bundle_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the gateway. Valid values: `File`, `Iscsi`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="gatewayClass")
    def gateway_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specification of the gateway. Valid values: `Basic`, `Standard`, `Enhanced`, `Advanced`. **NOTE:** If `location` is set to `Cloud`, `gateway_class` is required. Otherwise, `gateway_class` will be ignored. If `payment_type` is set to `Subscription`, `gateway_class` cannot be modified.
        """
        return pulumi.get(self, "gateway_class")

    @gateway_class.setter
    def gateway_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_class", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Payment type of gateway. Valid values: `PayAsYouGo`, `Subscription`. **NOTE:** From version 1.233.0, `payment_type` can be set to `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkBandwidth")
    def public_network_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The public bandwidth of the gateway. Default value: `5`. Valid values: `5` to `200`. **NOTE:** `public_network_bandwidth` is only valid when `location` is `Cloud`. If `payment_type` is set to `Subscription`, `public_network_bandwidth` cannot be modified.
        """
        return pulumi.get(self, "public_network_bandwidth")

    @public_network_bandwidth.setter
    def public_network_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "public_network_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="reasonDetail")
    def reason_detail(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The detailed reason why you want to delete the gateway.
        """
        return pulumi.get(self, "reason_detail")

    @reason_detail.setter
    def reason_detail(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reason_detail", value)

    @_builtins.property
    @pulumi.getter(name="reasonType")
    def reason_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the reason why you want to delete the gateway.
        """
        return pulumi.get(self, "reason_type")

    @reason_type.setter
    def reason_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reason_type", value)

    @_builtins.property
    @pulumi.getter(name="releaseAfterExpiration")
    def release_after_expiration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to release the gateway after the subscription expires. Valid values:
        """
        return pulumi.get(self, "release_after_expiration")

    @release_after_expiration.setter
    def release_after_expiration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "release_after_expiration", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VSwitch. **NOTE:** If `location` is set to `Cloud`, `vswitch_id` is required. Otherwise, `vswitch_id` will be ignored.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.input_type
class _GatewayState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_class: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 reason_detail: Optional[pulumi.Input[_builtins.str]] = None,
                 reason_type: Optional[pulumi.Input[_builtins.str]] = None,
                 release_after_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_bundle_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Gateway resources.
        :param pulumi.Input[_builtins.str] description: The description of the gateway.
        :param pulumi.Input[_builtins.str] gateway_class: The specification of the gateway. Valid values: `Basic`, `Standard`, `Enhanced`, `Advanced`. **NOTE:** If `location` is set to `Cloud`, `gateway_class` is required. Otherwise, `gateway_class` will be ignored. If `payment_type` is set to `Subscription`, `gateway_class` cannot be modified.
        :param pulumi.Input[_builtins.str] gateway_name: The name of the gateway. The name must be `1` to `60` characters in length and can contain letters, digits, periods (.), underscores (_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[_builtins.str] location: The location of the gateway. Valid values: `Cloud`, `On_Premise`.
        :param pulumi.Input[_builtins.str] payment_type: The Payment type of gateway. Valid values: `PayAsYouGo`, `Subscription`. **NOTE:** From version 1.233.0, `payment_type` can be set to `Subscription`.
        :param pulumi.Input[_builtins.int] public_network_bandwidth: The public bandwidth of the gateway. Default value: `5`. Valid values: `5` to `200`. **NOTE:** `public_network_bandwidth` is only valid when `location` is `Cloud`. If `payment_type` is set to `Subscription`, `public_network_bandwidth` cannot be modified.
        :param pulumi.Input[_builtins.str] reason_detail: The detailed reason why you want to delete the gateway.
        :param pulumi.Input[_builtins.str] reason_type: The type of the reason why you want to delete the gateway.
        :param pulumi.Input[_builtins.bool] release_after_expiration: Specifies whether to release the gateway after the subscription expires. Valid values:
        :param pulumi.Input[_builtins.str] status: The status of the Gateway.
        :param pulumi.Input[_builtins.str] storage_bundle_id: The ID of the gateway cluster.
        :param pulumi.Input[_builtins.str] type: The type of the gateway. Valid values: `File`, `Iscsi`.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the VSwitch. **NOTE:** If `location` is set to `Cloud`, `vswitch_id` is required. Otherwise, `vswitch_id` will be ignored.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gateway_class is not None:
            pulumi.set(__self__, "gateway_class", gateway_class)
        if gateway_name is not None:
            pulumi.set(__self__, "gateway_name", gateway_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if public_network_bandwidth is not None:
            pulumi.set(__self__, "public_network_bandwidth", public_network_bandwidth)
        if reason_detail is not None:
            pulumi.set(__self__, "reason_detail", reason_detail)
        if reason_type is not None:
            pulumi.set(__self__, "reason_type", reason_type)
        if release_after_expiration is not None:
            pulumi.set(__self__, "release_after_expiration", release_after_expiration)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_bundle_id is not None:
            pulumi.set(__self__, "storage_bundle_id", storage_bundle_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="gatewayClass")
    def gateway_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specification of the gateway. Valid values: `Basic`, `Standard`, `Enhanced`, `Advanced`. **NOTE:** If `location` is set to `Cloud`, `gateway_class` is required. Otherwise, `gateway_class` will be ignored. If `payment_type` is set to `Subscription`, `gateway_class` cannot be modified.
        """
        return pulumi.get(self, "gateway_class")

    @gateway_class.setter
    def gateway_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_class", value)

    @_builtins.property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the gateway. The name must be `1` to `60` characters in length and can contain letters, digits, periods (.), underscores (_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "gateway_name")

    @gateway_name.setter
    def gateway_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the gateway. Valid values: `Cloud`, `On_Premise`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Payment type of gateway. Valid values: `PayAsYouGo`, `Subscription`. **NOTE:** From version 1.233.0, `payment_type` can be set to `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkBandwidth")
    def public_network_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The public bandwidth of the gateway. Default value: `5`. Valid values: `5` to `200`. **NOTE:** `public_network_bandwidth` is only valid when `location` is `Cloud`. If `payment_type` is set to `Subscription`, `public_network_bandwidth` cannot be modified.
        """
        return pulumi.get(self, "public_network_bandwidth")

    @public_network_bandwidth.setter
    def public_network_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "public_network_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="reasonDetail")
    def reason_detail(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The detailed reason why you want to delete the gateway.
        """
        return pulumi.get(self, "reason_detail")

    @reason_detail.setter
    def reason_detail(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reason_detail", value)

    @_builtins.property
    @pulumi.getter(name="reasonType")
    def reason_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the reason why you want to delete the gateway.
        """
        return pulumi.get(self, "reason_type")

    @reason_type.setter
    def reason_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reason_type", value)

    @_builtins.property
    @pulumi.getter(name="releaseAfterExpiration")
    def release_after_expiration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to release the gateway after the subscription expires. Valid values:
        """
        return pulumi.get(self, "release_after_expiration")

    @release_after_expiration.setter
    def release_after_expiration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "release_after_expiration", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Gateway.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageBundleId")
    def storage_bundle_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the gateway cluster.
        """
        return pulumi.get(self, "storage_bundle_id")

    @storage_bundle_id.setter
    def storage_bundle_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_bundle_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the gateway. Valid values: `File`, `Iscsi`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VSwitch. **NOTE:** If `location` is set to `Cloud`, `vswitch_id` is required. Otherwise, `vswitch_id` will be ignored.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:cloudstoragegateway/gateway:Gateway")
class Gateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_class: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 reason_detail: Optional[pulumi.Input[_builtins.str]] = None,
                 reason_type: Optional[pulumi.Input[_builtins.str]] = None,
                 release_after_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_bundle_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Storage Gateway Gateway resource.

        For information about Cloud Storage Gateway Gateway and how to use it, see [What is Gateway](https://www.alibabacloud.com/help/en/csg/developer-reference/api-mnz46x).

        > **NOTE:** Available since v1.132.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones()
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_storage_bundle = alicloud.cloudstoragegateway.StorageBundle("default", storage_bundle_name=f"{name}-{default_integer['result']}")
        default_network = alicloud.vpc.Network("default",
            vpc_name=f"{name}-{default_integer['result']}",
            cidr_block="192.168.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=f"{name}-{default_integer['result']}",
            vpc_id=default_network.id,
            cidr_block="192.168.192.0/24",
            zone_id=default.zones[0].id)
        default_gateway = alicloud.cloudstoragegateway.Gateway("default",
            storage_bundle_id=default_storage_bundle.id,
            type="File",
            location="Cloud",
            gateway_name=name,
            gateway_class="Standard",
            vswitch_id=default_switch.id,
            public_network_bandwidth=50,
            payment_type="PayAsYouGo",
            description=name)
        ```

        ## Import

        Cloud Storage Gateway Gateway can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudstoragegateway/gateway:Gateway example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the gateway.
        :param pulumi.Input[_builtins.str] gateway_class: The specification of the gateway. Valid values: `Basic`, `Standard`, `Enhanced`, `Advanced`. **NOTE:** If `location` is set to `Cloud`, `gateway_class` is required. Otherwise, `gateway_class` will be ignored. If `payment_type` is set to `Subscription`, `gateway_class` cannot be modified.
        :param pulumi.Input[_builtins.str] gateway_name: The name of the gateway. The name must be `1` to `60` characters in length and can contain letters, digits, periods (.), underscores (_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[_builtins.str] location: The location of the gateway. Valid values: `Cloud`, `On_Premise`.
        :param pulumi.Input[_builtins.str] payment_type: The Payment type of gateway. Valid values: `PayAsYouGo`, `Subscription`. **NOTE:** From version 1.233.0, `payment_type` can be set to `Subscription`.
        :param pulumi.Input[_builtins.int] public_network_bandwidth: The public bandwidth of the gateway. Default value: `5`. Valid values: `5` to `200`. **NOTE:** `public_network_bandwidth` is only valid when `location` is `Cloud`. If `payment_type` is set to `Subscription`, `public_network_bandwidth` cannot be modified.
        :param pulumi.Input[_builtins.str] reason_detail: The detailed reason why you want to delete the gateway.
        :param pulumi.Input[_builtins.str] reason_type: The type of the reason why you want to delete the gateway.
        :param pulumi.Input[_builtins.bool] release_after_expiration: Specifies whether to release the gateway after the subscription expires. Valid values:
        :param pulumi.Input[_builtins.str] storage_bundle_id: The ID of the gateway cluster.
        :param pulumi.Input[_builtins.str] type: The type of the gateway. Valid values: `File`, `Iscsi`.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the VSwitch. **NOTE:** If `location` is set to `Cloud`, `vswitch_id` is required. Otherwise, `vswitch_id` will be ignored.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Storage Gateway Gateway resource.

        For information about Cloud Storage Gateway Gateway and how to use it, see [What is Gateway](https://www.alibabacloud.com/help/en/csg/developer-reference/api-mnz46x).

        > **NOTE:** Available since v1.132.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones()
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_storage_bundle = alicloud.cloudstoragegateway.StorageBundle("default", storage_bundle_name=f"{name}-{default_integer['result']}")
        default_network = alicloud.vpc.Network("default",
            vpc_name=f"{name}-{default_integer['result']}",
            cidr_block="192.168.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=f"{name}-{default_integer['result']}",
            vpc_id=default_network.id,
            cidr_block="192.168.192.0/24",
            zone_id=default.zones[0].id)
        default_gateway = alicloud.cloudstoragegateway.Gateway("default",
            storage_bundle_id=default_storage_bundle.id,
            type="File",
            location="Cloud",
            gateway_name=name,
            gateway_class="Standard",
            vswitch_id=default_switch.id,
            public_network_bandwidth=50,
            payment_type="PayAsYouGo",
            description=name)
        ```

        ## Import

        Cloud Storage Gateway Gateway can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudstoragegateway/gateway:Gateway example <id>
        ```

        :param str resource_name: The name of the resource.
        :param GatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_class: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 reason_detail: Optional[pulumi.Input[_builtins.str]] = None,
                 reason_type: Optional[pulumi.Input[_builtins.str]] = None,
                 release_after_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_bundle_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayArgs.__new__(GatewayArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["gateway_class"] = gateway_class
            if gateway_name is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_name'")
            __props__.__dict__["gateway_name"] = gateway_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["public_network_bandwidth"] = public_network_bandwidth
            __props__.__dict__["reason_detail"] = reason_detail
            __props__.__dict__["reason_type"] = reason_type
            __props__.__dict__["release_after_expiration"] = release_after_expiration
            if storage_bundle_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_bundle_id'")
            __props__.__dict__["storage_bundle_id"] = storage_bundle_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["status"] = None
        super(Gateway, __self__).__init__(
            'alicloud:cloudstoragegateway/gateway:Gateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_class: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            reason_detail: Optional[pulumi.Input[_builtins.str]] = None,
            reason_type: Optional[pulumi.Input[_builtins.str]] = None,
            release_after_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_bundle_id: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Gateway':
        """
        Get an existing Gateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the gateway.
        :param pulumi.Input[_builtins.str] gateway_class: The specification of the gateway. Valid values: `Basic`, `Standard`, `Enhanced`, `Advanced`. **NOTE:** If `location` is set to `Cloud`, `gateway_class` is required. Otherwise, `gateway_class` will be ignored. If `payment_type` is set to `Subscription`, `gateway_class` cannot be modified.
        :param pulumi.Input[_builtins.str] gateway_name: The name of the gateway. The name must be `1` to `60` characters in length and can contain letters, digits, periods (.), underscores (_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[_builtins.str] location: The location of the gateway. Valid values: `Cloud`, `On_Premise`.
        :param pulumi.Input[_builtins.str] payment_type: The Payment type of gateway. Valid values: `PayAsYouGo`, `Subscription`. **NOTE:** From version 1.233.0, `payment_type` can be set to `Subscription`.
        :param pulumi.Input[_builtins.int] public_network_bandwidth: The public bandwidth of the gateway. Default value: `5`. Valid values: `5` to `200`. **NOTE:** `public_network_bandwidth` is only valid when `location` is `Cloud`. If `payment_type` is set to `Subscription`, `public_network_bandwidth` cannot be modified.
        :param pulumi.Input[_builtins.str] reason_detail: The detailed reason why you want to delete the gateway.
        :param pulumi.Input[_builtins.str] reason_type: The type of the reason why you want to delete the gateway.
        :param pulumi.Input[_builtins.bool] release_after_expiration: Specifies whether to release the gateway after the subscription expires. Valid values:
        :param pulumi.Input[_builtins.str] status: The status of the Gateway.
        :param pulumi.Input[_builtins.str] storage_bundle_id: The ID of the gateway cluster.
        :param pulumi.Input[_builtins.str] type: The type of the gateway. Valid values: `File`, `Iscsi`.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the VSwitch. **NOTE:** If `location` is set to `Cloud`, `vswitch_id` is required. Otherwise, `vswitch_id` will be ignored.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayState.__new__(_GatewayState)

        __props__.__dict__["description"] = description
        __props__.__dict__["gateway_class"] = gateway_class
        __props__.__dict__["gateway_name"] = gateway_name
        __props__.__dict__["location"] = location
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["public_network_bandwidth"] = public_network_bandwidth
        __props__.__dict__["reason_detail"] = reason_detail
        __props__.__dict__["reason_type"] = reason_type
        __props__.__dict__["release_after_expiration"] = release_after_expiration
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_bundle_id"] = storage_bundle_id
        __props__.__dict__["type"] = type
        __props__.__dict__["vswitch_id"] = vswitch_id
        return Gateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the gateway.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="gatewayClass")
    def gateway_class(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The specification of the gateway. Valid values: `Basic`, `Standard`, `Enhanced`, `Advanced`. **NOTE:** If `location` is set to `Cloud`, `gateway_class` is required. Otherwise, `gateway_class` will be ignored. If `payment_type` is set to `Subscription`, `gateway_class` cannot be modified.
        """
        return pulumi.get(self, "gateway_class")

    @_builtins.property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the gateway. The name must be `1` to `60` characters in length and can contain letters, digits, periods (.), underscores (_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "gateway_name")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the gateway. Valid values: `Cloud`, `On_Premise`.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Payment type of gateway. Valid values: `PayAsYouGo`, `Subscription`. **NOTE:** From version 1.233.0, `payment_type` can be set to `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="publicNetworkBandwidth")
    def public_network_bandwidth(self) -> pulumi.Output[_builtins.int]:
        """
        The public bandwidth of the gateway. Default value: `5`. Valid values: `5` to `200`. **NOTE:** `public_network_bandwidth` is only valid when `location` is `Cloud`. If `payment_type` is set to `Subscription`, `public_network_bandwidth` cannot be modified.
        """
        return pulumi.get(self, "public_network_bandwidth")

    @_builtins.property
    @pulumi.getter(name="reasonDetail")
    def reason_detail(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The detailed reason why you want to delete the gateway.
        """
        return pulumi.get(self, "reason_detail")

    @_builtins.property
    @pulumi.getter(name="reasonType")
    def reason_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the reason why you want to delete the gateway.
        """
        return pulumi.get(self, "reason_type")

    @_builtins.property
    @pulumi.getter(name="releaseAfterExpiration")
    def release_after_expiration(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to release the gateway after the subscription expires. Valid values:
        """
        return pulumi.get(self, "release_after_expiration")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Gateway.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageBundleId")
    def storage_bundle_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the gateway cluster.
        """
        return pulumi.get(self, "storage_bundle_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the gateway. Valid values: `File`, `Iscsi`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the VSwitch. **NOTE:** If `location` is set to `Cloud`, `vswitch_id` is required. Otherwise, `vswitch_id` will be ignored.
        """
        return pulumi.get(self, "vswitch_id")

