# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetGatewayCacheDisksResult',
    'AwaitableGetGatewayCacheDisksResult',
    'get_gateway_cache_disks',
    'get_gateway_cache_disks_output',
]

@pulumi.output_type
class GetGatewayCacheDisksResult:
    """
    A collection of values returned by getGatewayCacheDisks.
    """
    def __init__(__self__, disks=None, gateway_id=None, id=None, ids=None, output_file=None, status=None):
        if disks and not isinstance(disks, list):
            raise TypeError("Expected argument 'disks' to be a list")
        pulumi.set(__self__, "disks", disks)
        if gateway_id and not isinstance(gateway_id, str):
            raise TypeError("Expected argument 'gateway_id' to be a str")
        pulumi.set(__self__, "gateway_id", gateway_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, int):
            raise TypeError("Expected argument 'status' to be a int")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Sequence['outputs.GetGatewayCacheDisksDiskResult']:
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> _builtins.str:
        return pulumi.get(self, "gateway_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "status")


class AwaitableGetGatewayCacheDisksResult(GetGatewayCacheDisksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGatewayCacheDisksResult(
            disks=self.disks,
            gateway_id=self.gateway_id,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            status=self.status)


def get_gateway_cache_disks(gateway_id: Optional[_builtins.str] = None,
                            ids: Optional[Sequence[_builtins.str]] = None,
                            output_file: Optional[_builtins.str] = None,
                            status: Optional[_builtins.int] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGatewayCacheDisksResult:
    """
    This data source provides the Cloud Storage Gateway Gateway Cache Disks of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.144.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.cloudstoragegateway.get_gateway_cache_disks(gateway_id="example_value",
        ids=[
            "example_value-1",
            "example_value-2",
        ])
    pulumi.export("cloudStorageGatewayGatewayCacheDiskId1", ids.disks[0].id)
    status = alicloud.cloudstoragegateway.get_gateway_cache_disks(gateway_id="example_value",
        ids=[
            "example_value-1",
            "example_value-2",
        ],
        status=0)
    pulumi.export("cloudStorageGatewayGatewayCacheDiskId2", status.disks[0].id)
    ```


    :param _builtins.str gateway_id: The ID of the gateway.
    :param Sequence[_builtins.str] ids: A list of Gateway Cache Disk IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.int status: The status of the resource. Valid values: `0`, `1`, `2`. `0`: Normal. `1`: Is about to expire. `2`: Has expired.
    """
    __args__ = dict()
    __args__['gatewayId'] = gateway_id
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cloudstoragegateway/getGatewayCacheDisks:getGatewayCacheDisks', __args__, opts=opts, typ=GetGatewayCacheDisksResult).value

    return AwaitableGetGatewayCacheDisksResult(
        disks=pulumi.get(__ret__, 'disks'),
        gateway_id=pulumi.get(__ret__, 'gateway_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'))
def get_gateway_cache_disks_output(gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                   output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   status: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGatewayCacheDisksResult]:
    """
    This data source provides the Cloud Storage Gateway Gateway Cache Disks of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.144.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.cloudstoragegateway.get_gateway_cache_disks(gateway_id="example_value",
        ids=[
            "example_value-1",
            "example_value-2",
        ])
    pulumi.export("cloudStorageGatewayGatewayCacheDiskId1", ids.disks[0].id)
    status = alicloud.cloudstoragegateway.get_gateway_cache_disks(gateway_id="example_value",
        ids=[
            "example_value-1",
            "example_value-2",
        ],
        status=0)
    pulumi.export("cloudStorageGatewayGatewayCacheDiskId2", status.disks[0].id)
    ```


    :param _builtins.str gateway_id: The ID of the gateway.
    :param Sequence[_builtins.str] ids: A list of Gateway Cache Disk IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.int status: The status of the resource. Valid values: `0`, `1`, `2`. `0`: Normal. `1`: Is about to expire. `2`: Has expired.
    """
    __args__ = dict()
    __args__['gatewayId'] = gateway_id
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cloudstoragegateway/getGatewayCacheDisks:getGatewayCacheDisks', __args__, opts=opts, typ=GetGatewayCacheDisksResult)
    return __ret__.apply(lambda __response__: GetGatewayCacheDisksResult(
        disks=pulumi.get(__response__, 'disks'),
        gateway_id=pulumi.get(__response__, 'gateway_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        status=pulumi.get(__response__, 'status')))
