# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetExpressSyncsSyncResult',
    'GetGatewayBlockVolumesVolumeResult',
    'GetGatewayCacheDisksDiskResult',
    'GetGatewayFileSharesShareResult',
    'GetGatewaySmbUsersUserResult',
    'GetGatewaysGatewayResult',
    'GetStocksStockResult',
    'GetStorageBundlesBundleResult',
]

@pulumi.output_type
class GetExpressSyncsSyncResult(dict):
    def __init__(__self__, *,
                 bucket_name: _builtins.str,
                 bucket_prefix: _builtins.str,
                 bucket_region: _builtins.str,
                 description: _builtins.str,
                 express_sync_id: _builtins.str,
                 express_sync_name: _builtins.str,
                 id: _builtins.str,
                 mns_topic: _builtins.str):
        """
        :param _builtins.str bucket_name: The name of the OSS Bucket.
        :param _builtins.str bucket_prefix: The prefix of the OSS Bucket.
        :param _builtins.str bucket_region: The region of the OSS Bucket.
        :param _builtins.str description: The description of the Express Sync.
        :param _builtins.str express_sync_id: The ID of the Express Sync.
        :param _builtins.str express_sync_name: The name of the Express Sync.
        :param _builtins.str mns_topic: The name of the message topic (Topic) corresponding to the Express Sync in the Alibaba Cloud Message Service MNS.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        pulumi.set(__self__, "bucket_region", bucket_region)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "express_sync_id", express_sync_id)
        pulumi.set(__self__, "express_sync_name", express_sync_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mns_topic", mns_topic)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        The name of the OSS Bucket.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> _builtins.str:
        """
        The prefix of the OSS Bucket.
        """
        return pulumi.get(self, "bucket_prefix")

    @_builtins.property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> _builtins.str:
        """
        The region of the OSS Bucket.
        """
        return pulumi.get(self, "bucket_region")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Express Sync.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expressSyncId")
    def express_sync_id(self) -> _builtins.str:
        """
        The ID of the Express Sync.
        """
        return pulumi.get(self, "express_sync_id")

    @_builtins.property
    @pulumi.getter(name="expressSyncName")
    def express_sync_name(self) -> _builtins.str:
        """
        The name of the Express Sync.
        """
        return pulumi.get(self, "express_sync_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="mnsTopic")
    def mns_topic(self) -> _builtins.str:
        """
        The name of the message topic (Topic) corresponding to the Express Sync in the Alibaba Cloud Message Service MNS.
        """
        return pulumi.get(self, "mns_topic")


@pulumi.output_type
class GetGatewayBlockVolumesVolumeResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 cache_mode: _builtins.str,
                 chap_enabled: _builtins.bool,
                 chap_in_user: _builtins.str,
                 chunk_size: _builtins.int,
                 disk_id: _builtins.str,
                 disk_type: _builtins.str,
                 enabled: _builtins.bool,
                 gateway_block_volume_name: _builtins.str,
                 gateway_id: _builtins.str,
                 id: _builtins.str,
                 index_id: _builtins.str,
                 local_path: _builtins.str,
                 lun_id: _builtins.int,
                 oss_bucket_name: _builtins.str,
                 oss_bucket_ssl: _builtins.bool,
                 oss_endpoint: _builtins.str,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 size: _builtins.int,
                 state: _builtins.str,
                 status: _builtins.int,
                 target: _builtins.str,
                 total_download: _builtins.int,
                 total_upload: _builtins.int,
                 volume_state: _builtins.int):
        """
        :param _builtins.str address: The IP ADDRESS.
        :param _builtins.str cache_mode: The Block volume set mode to cache mode. Valid values: `Cache`, `WriteThrough`.
        :param _builtins.bool chap_enabled: Whether to enable iSCSI access of CHAP authentication, which currently supports both CHAP inbound authentication.  Default value: `false`.
        :param _builtins.str chap_in_user: The Inbound CHAP user.**NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
        :param _builtins.int chunk_size: The Block volume storage allocation unit.  Valid values: `8192`, `16384`, `32768`, `65536`, `131072`. Default value: `32768`. Unit: `Byte`.
        :param _builtins.str disk_id: The cache disk ID.
        :param _builtins.str disk_type: The cache disk type.
        :param _builtins.bool enabled: Whether to enable Volume.
        :param _builtins.str gateway_block_volume_name: The Block volume name.  The name must be 1 to 32 characters in length, and can contain lowercase letters, numbers.
        :param _builtins.str gateway_id: The Gateway ID.
        :param _builtins.str id: The ID of the Gateway Block Volume. The value formats as `<gateway_id>:<index_id>`.
        :param _builtins.str index_id: The ID of the index.
        :param _builtins.str local_path: CThe Cache disk to local path. **NOTE:**  When the `cache_mode` is  `Cache` is,The `chap_in_password` is valid.
        :param _builtins.int lun_id: The Lun identifier.
        :param _builtins.str oss_bucket_name: The name of the OSS Bucket.
        :param _builtins.bool oss_bucket_ssl: Whether to enable SSL access your OSS Buckets. Default value: `true`.
        :param _builtins.str oss_endpoint: The endpoint of the OSS Bucket.
        :param _builtins.int port: The Port.
        :param _builtins.str protocol: The Protocol.
        :param _builtins.int size: The Volume size.
        :param _builtins.str state: The Buffer status.
        :param _builtins.int status: The status of volume.
        :param _builtins.str target: The target.
        :param _builtins.int total_download: The total amount of downloaded data. Unit: `B`.
        :param _builtins.int total_upload: The total amount of uploaded data. Unit: `B`.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "cache_mode", cache_mode)
        pulumi.set(__self__, "chap_enabled", chap_enabled)
        pulumi.set(__self__, "chap_in_user", chap_in_user)
        pulumi.set(__self__, "chunk_size", chunk_size)
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "gateway_block_volume_name", gateway_block_volume_name)
        pulumi.set(__self__, "gateway_id", gateway_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "index_id", index_id)
        pulumi.set(__self__, "local_path", local_path)
        pulumi.set(__self__, "lun_id", lun_id)
        pulumi.set(__self__, "oss_bucket_name", oss_bucket_name)
        pulumi.set(__self__, "oss_bucket_ssl", oss_bucket_ssl)
        pulumi.set(__self__, "oss_endpoint", oss_endpoint)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "total_download", total_download)
        pulumi.set(__self__, "total_upload", total_upload)
        pulumi.set(__self__, "volume_state", volume_state)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The IP ADDRESS.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="cacheMode")
    def cache_mode(self) -> _builtins.str:
        """
        The Block volume set mode to cache mode. Valid values: `Cache`, `WriteThrough`.
        """
        return pulumi.get(self, "cache_mode")

    @_builtins.property
    @pulumi.getter(name="chapEnabled")
    def chap_enabled(self) -> _builtins.bool:
        """
        Whether to enable iSCSI access of CHAP authentication, which currently supports both CHAP inbound authentication.  Default value: `false`.
        """
        return pulumi.get(self, "chap_enabled")

    @_builtins.property
    @pulumi.getter(name="chapInUser")
    def chap_in_user(self) -> _builtins.str:
        """
        The Inbound CHAP user.**NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
        """
        return pulumi.get(self, "chap_in_user")

    @_builtins.property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> _builtins.int:
        """
        The Block volume storage allocation unit.  Valid values: `8192`, `16384`, `32768`, `65536`, `131072`. Default value: `32768`. Unit: `Byte`.
        """
        return pulumi.get(self, "chunk_size")

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> _builtins.str:
        """
        The cache disk ID.
        """
        return pulumi.get(self, "disk_id")

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> _builtins.str:
        """
        The cache disk type.
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether to enable Volume.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="gatewayBlockVolumeName")
    def gateway_block_volume_name(self) -> _builtins.str:
        """
        The Block volume name.  The name must be 1 to 32 characters in length, and can contain lowercase letters, numbers.
        """
        return pulumi.get(self, "gateway_block_volume_name")

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> _builtins.str:
        """
        The Gateway ID.
        """
        return pulumi.get(self, "gateway_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Gateway Block Volume. The value formats as `<gateway_id>:<index_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="indexId")
    def index_id(self) -> _builtins.str:
        """
        The ID of the index.
        """
        return pulumi.get(self, "index_id")

    @_builtins.property
    @pulumi.getter(name="localPath")
    def local_path(self) -> _builtins.str:
        """
        CThe Cache disk to local path. **NOTE:**  When the `cache_mode` is  `Cache` is,The `chap_in_password` is valid.
        """
        return pulumi.get(self, "local_path")

    @_builtins.property
    @pulumi.getter(name="lunId")
    def lun_id(self) -> _builtins.int:
        """
        The Lun identifier.
        """
        return pulumi.get(self, "lun_id")

    @_builtins.property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> _builtins.str:
        """
        The name of the OSS Bucket.
        """
        return pulumi.get(self, "oss_bucket_name")

    @_builtins.property
    @pulumi.getter(name="ossBucketSsl")
    def oss_bucket_ssl(self) -> _builtins.bool:
        """
        Whether to enable SSL access your OSS Buckets. Default value: `true`.
        """
        return pulumi.get(self, "oss_bucket_ssl")

    @_builtins.property
    @pulumi.getter(name="ossEndpoint")
    def oss_endpoint(self) -> _builtins.str:
        """
        The endpoint of the OSS Bucket.
        """
        return pulumi.get(self, "oss_endpoint")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The Port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The Protocol.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        The Volume size.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The Buffer status.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.int:
        """
        The status of volume.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.str:
        """
        The target.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter(name="totalDownload")
    def total_download(self) -> _builtins.int:
        """
        The total amount of downloaded data. Unit: `B`.
        """
        return pulumi.get(self, "total_download")

    @_builtins.property
    @pulumi.getter(name="totalUpload")
    def total_upload(self) -> _builtins.int:
        """
        The total amount of uploaded data. Unit: `B`.
        """
        return pulumi.get(self, "total_upload")

    @_builtins.property
    @pulumi.getter(name="volumeState")
    def volume_state(self) -> _builtins.int:
        return pulumi.get(self, "volume_state")


@pulumi.output_type
class GetGatewayCacheDisksDiskResult(dict):
    def __init__(__self__, *,
                 cache_disk_category: _builtins.str,
                 cache_disk_size_in_gb: _builtins.int,
                 cache_id: _builtins.str,
                 expired_time: _builtins.int,
                 gateway_id: _builtins.str,
                 id: _builtins.str,
                 iops: _builtins.int,
                 is_used: _builtins.bool,
                 local_file_path: _builtins.str,
                 renew_url: _builtins.str,
                 status: _builtins.int):
        """
        :param _builtins.str cache_disk_category: The category of eht cache disk.
        :param _builtins.int cache_disk_size_in_gb: The size of the cache disk.
        :param _builtins.str cache_id: The ID of the cache disk.
        :param _builtins.int expired_time: The expiration time. Time stamp in seconds (s).
        :param _builtins.str gateway_id: The ID of the gateway.
        :param _builtins.str id: The ID of the Gateway Cache Disk.
        :param _builtins.int iops: Per second of the input output.
        :param _builtins.bool is_used: Whether it is used.
        :param _builtins.str local_file_path: The cache disk inside the device name.
        :param _builtins.str renew_url: A renewal link of the cache disk.
        :param _builtins.int status: The status of the resource.
        """
        pulumi.set(__self__, "cache_disk_category", cache_disk_category)
        pulumi.set(__self__, "cache_disk_size_in_gb", cache_disk_size_in_gb)
        pulumi.set(__self__, "cache_id", cache_id)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "gateway_id", gateway_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "iops", iops)
        pulumi.set(__self__, "is_used", is_used)
        pulumi.set(__self__, "local_file_path", local_file_path)
        pulumi.set(__self__, "renew_url", renew_url)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="cacheDiskCategory")
    def cache_disk_category(self) -> _builtins.str:
        """
        The category of eht cache disk.
        """
        return pulumi.get(self, "cache_disk_category")

    @_builtins.property
    @pulumi.getter(name="cacheDiskSizeInGb")
    def cache_disk_size_in_gb(self) -> _builtins.int:
        """
        The size of the cache disk.
        """
        return pulumi.get(self, "cache_disk_size_in_gb")

    @_builtins.property
    @pulumi.getter(name="cacheId")
    def cache_id(self) -> _builtins.str:
        """
        The ID of the cache disk.
        """
        return pulumi.get(self, "cache_id")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.int:
        """
        The expiration time. Time stamp in seconds (s).
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> _builtins.str:
        """
        The ID of the gateway.
        """
        return pulumi.get(self, "gateway_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Gateway Cache Disk.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def iops(self) -> _builtins.int:
        """
        Per second of the input output.
        """
        return pulumi.get(self, "iops")

    @_builtins.property
    @pulumi.getter(name="isUsed")
    def is_used(self) -> _builtins.bool:
        """
        Whether it is used.
        """
        return pulumi.get(self, "is_used")

    @_builtins.property
    @pulumi.getter(name="localFilePath")
    def local_file_path(self) -> _builtins.str:
        """
        The cache disk inside the device name.
        """
        return pulumi.get(self, "local_file_path")

    @_builtins.property
    @pulumi.getter(name="renewUrl")
    def renew_url(self) -> _builtins.str:
        """
        A renewal link of the cache disk.
        """
        return pulumi.get(self, "renew_url")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.int:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetGatewayFileSharesShareResult(dict):
    def __init__(__self__, *,
                 access_based_enumeration: _builtins.bool,
                 address: _builtins.str,
                 backend_limit: _builtins.int,
                 browsable: _builtins.bool,
                 bucket_infos: _builtins.str,
                 buckets_stub: _builtins.bool,
                 bypass_cache_read: _builtins.bool,
                 cache_mode: _builtins.str,
                 client_side_cmk: _builtins.str,
                 client_side_encryption: _builtins.bool,
                 direct_io: _builtins.bool,
                 disk_id: _builtins.str,
                 disk_type: _builtins.str,
                 download_limit: _builtins.int,
                 enabled: _builtins.bool,
                 express_sync_id: _builtins.str,
                 fast_reclaim: _builtins.bool,
                 fe_limit: _builtins.int,
                 file_num_limit: _builtins.str,
                 fs_size_limit: _builtins.str,
                 gateway_file_share_name: _builtins.str,
                 gateway_id: _builtins.str,
                 id: _builtins.str,
                 ignore_delete: _builtins.bool,
                 in_place: _builtins.bool,
                 in_rate: _builtins.str,
                 index_id: _builtins.str,
                 kms_rotate_period: _builtins.int,
                 lag_period: _builtins.str,
                 local_path: _builtins.str,
                 mns_health: _builtins.str,
                 nfs_v4_optimization: _builtins.bool,
                 obsolete_buckets: _builtins.str,
                 oss_bucket_name: _builtins.str,
                 oss_bucket_ssl: _builtins.bool,
                 oss_endpoint: _builtins.str,
                 oss_health: _builtins.str,
                 oss_used: _builtins.str,
                 out_rate: _builtins.str,
                 partial_sync_paths: _builtins.str,
                 path_prefix: _builtins.str,
                 polling_interval: _builtins.int,
                 protocol: _builtins.str,
                 remaining_meta_space: _builtins.str,
                 remote_sync: _builtins.bool,
                 remote_sync_download: _builtins.bool,
                 ro_client_list: _builtins.str,
                 ro_user_list: _builtins.str,
                 rw_client_list: _builtins.str,
                 rw_user_list: _builtins.str,
                 server_side_cmk: _builtins.str,
                 server_side_encryption: _builtins.bool,
                 size: _builtins.str,
                 squash: _builtins.str,
                 state: _builtins.str,
                 support_archive: _builtins.bool,
                 sync_progress: _builtins.int,
                 total_download: _builtins.str,
                 total_upload: _builtins.str,
                 transfer_acceleration: _builtins.bool,
                 used: _builtins.str,
                 windows_acl: _builtins.bool):
        """
        :param _builtins.bool access_based_enumeration: The set up gateway file share Server Message Block (SMB) protocol, whether to enable Windows ABE, the prime minister, need windowsAcl parameter is set to true in the entry into force of. Default value: `false`. **NOTE:** Gateway version >= 1.0.45 above support.
        :param _builtins.str address: Share the private IP address of the RDS instance.
        :param _builtins.int backend_limit: The set up gateway file share Max upload speed. Unit: `MB/s`, `0` means unlimited. Value range: `0` ~ `1280`. Default value: `0`. **NOTE:** at the same time if you have to limit the maximum write speed, maximum upload speed is no less than the maximum write speed.
        :param _builtins.bool browsable: The set up gateway file share Server Message Block (SMB) protocol whether browsable (that is, in the network neighborhood of whether you can find). The parameters in the NFS protocol not valid under. Default value: `true`.
        :param _builtins.str bucket_infos: Multi-Bucket information.
        :param _builtins.bool buckets_stub: Whether there are multiple buckets.
        :param _builtins.bool bypass_cache_read: Direct reading OSS of the gateway file share.
        :param _builtins.str cache_mode: The cache mode of the gateway file share. Value range: Cache: cached mode. Sync: replication mode are available.
        :param _builtins.str client_side_cmk: File share is enabled to client-side encryption, the encryption by the use of the KMS key. **NOTE:** note: This KMS key must be the gateway and is in the same Region.
        :param _builtins.bool client_side_encryption: Whether to enabled to client-side encryption of the gateway file share. Default value: `false`. **NOTE:** need to contact us open whitelist before you can the settings, and only supports enhanced more than online gateway, at the same time, server-side encryption and to client-side encryption can not simultaneously configuration.
        :param _builtins.bool direct_io: Whether directio (direct I/O data transfer) is enabled for file share. Default: `false`.
        :param _builtins.str disk_id: The ID of the disk.
        :param _builtins.str disk_type: The cache disk type. Valid values: `cloud_efficiency`: Ultra cloud disk. `cloud_ssd`:SSD cloud disk.
        :param _builtins.int download_limit: The set up gateway file share maximum download speed. Unit: `MB/s`. `0` means unlimited. Value range: `0` ~ `1280`. **NOTE:** only in copy mode and enable download file data can be set. only when the shared opens the reverse synchronization or acceded to by the speed synchronization Group when, this parameter will not take effect. Gateway version >= 1.3.0 above support.
        :param _builtins.bool enabled: Shared whether the changes take effect.
        :param _builtins.str express_sync_id: Speed synchronization group ID.
        :param _builtins.bool fast_reclaim: The set up gateway file share whether to enable Upload optimization, which is suitable for data pure backup migration scenarios. Default value: `false`. **NOTE:** Gateway version >= 1.0.39 above support.
        :param _builtins.int fe_limit: The set up gateway file share and the maximum write speed. Unit: `MB/s`, `0` means unlimited. Value range: `0` ~ `1280`. Default value: `0`.
        :param _builtins.str file_num_limit: Supported by the file system file number.
        :param _builtins.str fs_size_limit: File system capacity. Unit: `B`.
        :param _builtins.str gateway_file_share_name: The name of the file share. Length from `1` to `255` characters can contain lowercase letters, digits, (.), (_) Or (-), at the same time, must start with a lowercase letter.
        :param _builtins.str gateway_id: The ID of the gateway.
        :param _builtins.str id: The ID of the Gateway File Share.
        :param _builtins.bool ignore_delete: Whether to ignore deleted of the gateway file share. After the opening of the Gateway side delete file or delete cloud (OSS) corresponding to the file. Default value: `false`. **NOTE:** Gateway version >= 1.0.40 above support.
        :param _builtins.bool in_place: Whether debris optimization of the gateway file share. Default value: `false`.
        :param _builtins.str in_rate: Cache growth. Unit: `B/s`.
        :param _builtins.str index_id: The ID of the file share.
        :param _builtins.int kms_rotate_period: File share is enabled to client-side encryption, key rotation period of time. Seconds. 0 represents no rotation. Rotation of the value range: `3600` ~ `86400`. Default value: `0`.
        :param _builtins.str lag_period: The synchronization delay, I.e. gateway local cache sync to Alibaba Cloud Object Storage Service (oss) of the delay time. Unit: `Seconds`. Value range: `5` ~ `120`. Default value: `5`. **NOTE:** Gateway version >= 1.0.40 above support.
        :param _builtins.str local_path: The cache disk inside the device name.
        :param _builtins.str mns_health: The messages from the queue health types. Valid values: `TopicAndQueueFailure`: A Message Queuing message theme can be accessed during the black hole period. `TopicFailure`: a message theme can be accessed during the black hole period. `MNSFullSyncInit`: full synchronization wait. `MNSFullSyncing`: full synchronization in progress. `QueueFailure`: a message queue can be accessed during the black hole period. `MNSNotEnabled`: Top speed synchronization is not enabled. `MNSHealthy`: sync fine.
        :param _builtins.bool nfs_v4_optimization: The set up gateway file share NFS protocol, whether to enable NFS v4 optimization improve Mount Upload efficiency. Default value: `false`. **NOTE:** turns on after I will not support NFS v3 mount the filesystem on a. Gateway version >= 1.2.0 above support.
        :param _builtins.str obsolete_buckets: Multi-Bucket, removing the Bucket.
        :param _builtins.str oss_bucket_name: The name of the Bucket.
        :param _builtins.bool oss_bucket_ssl: Whether they are using SSL connect to OSS Bucket.
        :param _builtins.str oss_endpoint: The set up gateway file share corresponds to the Object Storage SERVICE (OSS), Bucket Endpoint. **NOTE:** distinguish between intranet and internet Endpoint. We recommend that if the OSS Bucket and the gateway is in the same Region is use the RDS intranet IP Endpoint:oss-cn-hangzhou-internal.aliyuncs.com.
        :param _builtins.str oss_health: The OSS Bucket of type. Valid values: `BucketHealthy`: OSS connectivity. `BucketAccessDenied`: OBJECT STORAGE Service (OSS) access to an exception. `BucketMiscFailure`: OBJECT STORAGE Service (OSS) access to additional exception. `BucketNetworkFailure`: OBJECT STORAGE Service (OSS) access network an exception. `BucketNotExist`: OSS Bucket does not exist. `Nothing returns`: We may not have ever known existed.
        :param _builtins.str oss_used: For a cloud-based data is. Unit: `B`.
        :param _builtins.str out_rate: Upload speed. Unit: `B/s`.
        :param _builtins.str partial_sync_paths: In part mode, the directory path group JSON format.
        :param _builtins.str path_prefix: The prefix of the OSS.
        :param _builtins.int polling_interval: The reverse synchronization time intervals of the gateway file share. Value range: `15` ~ `36000`. **NOTE:** in copy mode + reverse synchronization is enabled Download file data, value range: `3600` ~ `36000`.
        :param _builtins.str protocol: Share types. Valid values: `SMB`, `NFS`.
        :param _builtins.str remaining_meta_space: You can use the metadata space. Unit: `B`.
        :param _builtins.bool remote_sync: Whether to enable reverse synchronization of the gateway file share. Default value: `false`.
        :param _builtins.bool remote_sync_download: Copy mode, whether to download the file data. Default value: `false`. **NOTE:** only when the shared opens the reverse synchronization or acceded to by the speed synchronization group, this parameter will not take effect.
        :param _builtins.str ro_client_list: The read-only client list. When Protocol NFS is returned when the status is.
        :param _builtins.str ro_user_list: The read-only client list. When Protocol for Server Message Block (SMB) to go back to.
        :param _builtins.str rw_client_list: Read and write the client list. When Protocol NFS is returned when the status is.
        :param _builtins.str rw_user_list: Read-write user list. When Protocol for Server Message Block (SMB) to go back to.
        :param _builtins.str server_side_cmk: File share is enabled server-side encryption, encryption used by the KMS key.
        :param _builtins.bool server_side_encryption: If the OSS Bucket side encryption.
        :param _builtins.str size: The caching capacity. Unit: `B`.
        :param _builtins.str squash: The set up gateway file share NFS protocol user mapping. Valid values: `none`, `root_squash`, `all_squash`, `all_anonymous`. Default value: `none`.
        :param _builtins.str state: File synchronization types. Valid values: `clean`, `dirty`. `clean`: synchronization is complete. `dirty`: synchronization has not been completed.
        :param _builtins.bool support_archive: Whether to support the archive transparent read.
        :param _builtins.int sync_progress: Full synchronization progress. When the share has been added for a synchronization group, the return parameters are valid, that shared full synchronization progress (0~100). `-2`: indicates that share the Gateway version does not support this feature. `-1`: the share does not occur full synchronization.
        :param _builtins.str total_download: The OSS Bucket to the Gateway total downloads. Unit: `B`.
        :param _builtins.str total_upload: The OSS Bucket to the Gateway total Upload amount. Unit: `B`.
        :param _builtins.bool transfer_acceleration: The set up gateway file share whether to enable transmission acceleration needs corresponding OSS Bucket enabled transport acceleration. **NOTE:** Gateway version >= 1.3.0 above support.
        :param _builtins.str used: Used cache. Unit: `B`.
        :param _builtins.bool windows_acl: The set up gateway file share Server Message Block (SMB) protocol, whether to enable by Windows access list (requires AD domain) the permissions control. Default value: `false`. **NOTE:** Gateway version >= 1.0.45 above support.
        """
        pulumi.set(__self__, "access_based_enumeration", access_based_enumeration)
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "backend_limit", backend_limit)
        pulumi.set(__self__, "browsable", browsable)
        pulumi.set(__self__, "bucket_infos", bucket_infos)
        pulumi.set(__self__, "buckets_stub", buckets_stub)
        pulumi.set(__self__, "bypass_cache_read", bypass_cache_read)
        pulumi.set(__self__, "cache_mode", cache_mode)
        pulumi.set(__self__, "client_side_cmk", client_side_cmk)
        pulumi.set(__self__, "client_side_encryption", client_side_encryption)
        pulumi.set(__self__, "direct_io", direct_io)
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "download_limit", download_limit)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "express_sync_id", express_sync_id)
        pulumi.set(__self__, "fast_reclaim", fast_reclaim)
        pulumi.set(__self__, "fe_limit", fe_limit)
        pulumi.set(__self__, "file_num_limit", file_num_limit)
        pulumi.set(__self__, "fs_size_limit", fs_size_limit)
        pulumi.set(__self__, "gateway_file_share_name", gateway_file_share_name)
        pulumi.set(__self__, "gateway_id", gateway_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ignore_delete", ignore_delete)
        pulumi.set(__self__, "in_place", in_place)
        pulumi.set(__self__, "in_rate", in_rate)
        pulumi.set(__self__, "index_id", index_id)
        pulumi.set(__self__, "kms_rotate_period", kms_rotate_period)
        pulumi.set(__self__, "lag_period", lag_period)
        pulumi.set(__self__, "local_path", local_path)
        pulumi.set(__self__, "mns_health", mns_health)
        pulumi.set(__self__, "nfs_v4_optimization", nfs_v4_optimization)
        pulumi.set(__self__, "obsolete_buckets", obsolete_buckets)
        pulumi.set(__self__, "oss_bucket_name", oss_bucket_name)
        pulumi.set(__self__, "oss_bucket_ssl", oss_bucket_ssl)
        pulumi.set(__self__, "oss_endpoint", oss_endpoint)
        pulumi.set(__self__, "oss_health", oss_health)
        pulumi.set(__self__, "oss_used", oss_used)
        pulumi.set(__self__, "out_rate", out_rate)
        pulumi.set(__self__, "partial_sync_paths", partial_sync_paths)
        pulumi.set(__self__, "path_prefix", path_prefix)
        pulumi.set(__self__, "polling_interval", polling_interval)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "remaining_meta_space", remaining_meta_space)
        pulumi.set(__self__, "remote_sync", remote_sync)
        pulumi.set(__self__, "remote_sync_download", remote_sync_download)
        pulumi.set(__self__, "ro_client_list", ro_client_list)
        pulumi.set(__self__, "ro_user_list", ro_user_list)
        pulumi.set(__self__, "rw_client_list", rw_client_list)
        pulumi.set(__self__, "rw_user_list", rw_user_list)
        pulumi.set(__self__, "server_side_cmk", server_side_cmk)
        pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "squash", squash)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "support_archive", support_archive)
        pulumi.set(__self__, "sync_progress", sync_progress)
        pulumi.set(__self__, "total_download", total_download)
        pulumi.set(__self__, "total_upload", total_upload)
        pulumi.set(__self__, "transfer_acceleration", transfer_acceleration)
        pulumi.set(__self__, "used", used)
        pulumi.set(__self__, "windows_acl", windows_acl)

    @_builtins.property
    @pulumi.getter(name="accessBasedEnumeration")
    def access_based_enumeration(self) -> _builtins.bool:
        """
        The set up gateway file share Server Message Block (SMB) protocol, whether to enable Windows ABE, the prime minister, need windowsAcl parameter is set to true in the entry into force of. Default value: `false`. **NOTE:** Gateway version >= 1.0.45 above support.
        """
        return pulumi.get(self, "access_based_enumeration")

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        Share the private IP address of the RDS instance.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="backendLimit")
    def backend_limit(self) -> _builtins.int:
        """
        The set up gateway file share Max upload speed. Unit: `MB/s`, `0` means unlimited. Value range: `0` ~ `1280`. Default value: `0`. **NOTE:** at the same time if you have to limit the maximum write speed, maximum upload speed is no less than the maximum write speed.
        """
        return pulumi.get(self, "backend_limit")

    @_builtins.property
    @pulumi.getter
    def browsable(self) -> _builtins.bool:
        """
        The set up gateway file share Server Message Block (SMB) protocol whether browsable (that is, in the network neighborhood of whether you can find). The parameters in the NFS protocol not valid under. Default value: `true`.
        """
        return pulumi.get(self, "browsable")

    @_builtins.property
    @pulumi.getter(name="bucketInfos")
    def bucket_infos(self) -> _builtins.str:
        """
        Multi-Bucket information.
        """
        return pulumi.get(self, "bucket_infos")

    @_builtins.property
    @pulumi.getter(name="bucketsStub")
    def buckets_stub(self) -> _builtins.bool:
        """
        Whether there are multiple buckets.
        """
        return pulumi.get(self, "buckets_stub")

    @_builtins.property
    @pulumi.getter(name="bypassCacheRead")
    def bypass_cache_read(self) -> _builtins.bool:
        """
        Direct reading OSS of the gateway file share.
        """
        return pulumi.get(self, "bypass_cache_read")

    @_builtins.property
    @pulumi.getter(name="cacheMode")
    def cache_mode(self) -> _builtins.str:
        """
        The cache mode of the gateway file share. Value range: Cache: cached mode. Sync: replication mode are available.
        """
        return pulumi.get(self, "cache_mode")

    @_builtins.property
    @pulumi.getter(name="clientSideCmk")
    def client_side_cmk(self) -> _builtins.str:
        """
        File share is enabled to client-side encryption, the encryption by the use of the KMS key. **NOTE:** note: This KMS key must be the gateway and is in the same Region.
        """
        return pulumi.get(self, "client_side_cmk")

    @_builtins.property
    @pulumi.getter(name="clientSideEncryption")
    def client_side_encryption(self) -> _builtins.bool:
        """
        Whether to enabled to client-side encryption of the gateway file share. Default value: `false`. **NOTE:** need to contact us open whitelist before you can the settings, and only supports enhanced more than online gateway, at the same time, server-side encryption and to client-side encryption can not simultaneously configuration.
        """
        return pulumi.get(self, "client_side_encryption")

    @_builtins.property
    @pulumi.getter(name="directIo")
    def direct_io(self) -> _builtins.bool:
        """
        Whether directio (direct I/O data transfer) is enabled for file share. Default: `false`.
        """
        return pulumi.get(self, "direct_io")

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> _builtins.str:
        """
        The ID of the disk.
        """
        return pulumi.get(self, "disk_id")

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> _builtins.str:
        """
        The cache disk type. Valid values: `cloud_efficiency`: Ultra cloud disk. `cloud_ssd`:SSD cloud disk.
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter(name="downloadLimit")
    def download_limit(self) -> _builtins.int:
        """
        The set up gateway file share maximum download speed. Unit: `MB/s`. `0` means unlimited. Value range: `0` ~ `1280`. **NOTE:** only in copy mode and enable download file data can be set. only when the shared opens the reverse synchronization or acceded to by the speed synchronization Group when, this parameter will not take effect. Gateway version >= 1.3.0 above support.
        """
        return pulumi.get(self, "download_limit")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Shared whether the changes take effect.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="expressSyncId")
    def express_sync_id(self) -> _builtins.str:
        """
        Speed synchronization group ID.
        """
        return pulumi.get(self, "express_sync_id")

    @_builtins.property
    @pulumi.getter(name="fastReclaim")
    def fast_reclaim(self) -> _builtins.bool:
        """
        The set up gateway file share whether to enable Upload optimization, which is suitable for data pure backup migration scenarios. Default value: `false`. **NOTE:** Gateway version >= 1.0.39 above support.
        """
        return pulumi.get(self, "fast_reclaim")

    @_builtins.property
    @pulumi.getter(name="feLimit")
    def fe_limit(self) -> _builtins.int:
        """
        The set up gateway file share and the maximum write speed. Unit: `MB/s`, `0` means unlimited. Value range: `0` ~ `1280`. Default value: `0`.
        """
        return pulumi.get(self, "fe_limit")

    @_builtins.property
    @pulumi.getter(name="fileNumLimit")
    def file_num_limit(self) -> _builtins.str:
        """
        Supported by the file system file number.
        """
        return pulumi.get(self, "file_num_limit")

    @_builtins.property
    @pulumi.getter(name="fsSizeLimit")
    def fs_size_limit(self) -> _builtins.str:
        """
        File system capacity. Unit: `B`.
        """
        return pulumi.get(self, "fs_size_limit")

    @_builtins.property
    @pulumi.getter(name="gatewayFileShareName")
    def gateway_file_share_name(self) -> _builtins.str:
        """
        The name of the file share. Length from `1` to `255` characters can contain lowercase letters, digits, (.), (_) Or (-), at the same time, must start with a lowercase letter.
        """
        return pulumi.get(self, "gateway_file_share_name")

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> _builtins.str:
        """
        The ID of the gateway.
        """
        return pulumi.get(self, "gateway_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Gateway File Share.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ignoreDelete")
    def ignore_delete(self) -> _builtins.bool:
        """
        Whether to ignore deleted of the gateway file share. After the opening of the Gateway side delete file or delete cloud (OSS) corresponding to the file. Default value: `false`. **NOTE:** Gateway version >= 1.0.40 above support.
        """
        return pulumi.get(self, "ignore_delete")

    @_builtins.property
    @pulumi.getter(name="inPlace")
    def in_place(self) -> _builtins.bool:
        """
        Whether debris optimization of the gateway file share. Default value: `false`.
        """
        return pulumi.get(self, "in_place")

    @_builtins.property
    @pulumi.getter(name="inRate")
    def in_rate(self) -> _builtins.str:
        """
        Cache growth. Unit: `B/s`.
        """
        return pulumi.get(self, "in_rate")

    @_builtins.property
    @pulumi.getter(name="indexId")
    def index_id(self) -> _builtins.str:
        """
        The ID of the file share.
        """
        return pulumi.get(self, "index_id")

    @_builtins.property
    @pulumi.getter(name="kmsRotatePeriod")
    def kms_rotate_period(self) -> _builtins.int:
        """
        File share is enabled to client-side encryption, key rotation period of time. Seconds. 0 represents no rotation. Rotation of the value range: `3600` ~ `86400`. Default value: `0`.
        """
        return pulumi.get(self, "kms_rotate_period")

    @_builtins.property
    @pulumi.getter(name="lagPeriod")
    def lag_period(self) -> _builtins.str:
        """
        The synchronization delay, I.e. gateway local cache sync to Alibaba Cloud Object Storage Service (oss) of the delay time. Unit: `Seconds`. Value range: `5` ~ `120`. Default value: `5`. **NOTE:** Gateway version >= 1.0.40 above support.
        """
        return pulumi.get(self, "lag_period")

    @_builtins.property
    @pulumi.getter(name="localPath")
    def local_path(self) -> _builtins.str:
        """
        The cache disk inside the device name.
        """
        return pulumi.get(self, "local_path")

    @_builtins.property
    @pulumi.getter(name="mnsHealth")
    def mns_health(self) -> _builtins.str:
        """
        The messages from the queue health types. Valid values: `TopicAndQueueFailure`: A Message Queuing message theme can be accessed during the black hole period. `TopicFailure`: a message theme can be accessed during the black hole period. `MNSFullSyncInit`: full synchronization wait. `MNSFullSyncing`: full synchronization in progress. `QueueFailure`: a message queue can be accessed during the black hole period. `MNSNotEnabled`: Top speed synchronization is not enabled. `MNSHealthy`: sync fine.
        """
        return pulumi.get(self, "mns_health")

    @_builtins.property
    @pulumi.getter(name="nfsV4Optimization")
    def nfs_v4_optimization(self) -> _builtins.bool:
        """
        The set up gateway file share NFS protocol, whether to enable NFS v4 optimization improve Mount Upload efficiency. Default value: `false`. **NOTE:** turns on after I will not support NFS v3 mount the filesystem on a. Gateway version >= 1.2.0 above support.
        """
        return pulumi.get(self, "nfs_v4_optimization")

    @_builtins.property
    @pulumi.getter(name="obsoleteBuckets")
    def obsolete_buckets(self) -> _builtins.str:
        """
        Multi-Bucket, removing the Bucket.
        """
        return pulumi.get(self, "obsolete_buckets")

    @_builtins.property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> _builtins.str:
        """
        The name of the Bucket.
        """
        return pulumi.get(self, "oss_bucket_name")

    @_builtins.property
    @pulumi.getter(name="ossBucketSsl")
    def oss_bucket_ssl(self) -> _builtins.bool:
        """
        Whether they are using SSL connect to OSS Bucket.
        """
        return pulumi.get(self, "oss_bucket_ssl")

    @_builtins.property
    @pulumi.getter(name="ossEndpoint")
    def oss_endpoint(self) -> _builtins.str:
        """
        The set up gateway file share corresponds to the Object Storage SERVICE (OSS), Bucket Endpoint. **NOTE:** distinguish between intranet and internet Endpoint. We recommend that if the OSS Bucket and the gateway is in the same Region is use the RDS intranet IP Endpoint:oss-cn-hangzhou-internal.aliyuncs.com.
        """
        return pulumi.get(self, "oss_endpoint")

    @_builtins.property
    @pulumi.getter(name="ossHealth")
    def oss_health(self) -> _builtins.str:
        """
        The OSS Bucket of type. Valid values: `BucketHealthy`: OSS connectivity. `BucketAccessDenied`: OBJECT STORAGE Service (OSS) access to an exception. `BucketMiscFailure`: OBJECT STORAGE Service (OSS) access to additional exception. `BucketNetworkFailure`: OBJECT STORAGE Service (OSS) access network an exception. `BucketNotExist`: OSS Bucket does not exist. `Nothing returns`: We may not have ever known existed.
        """
        return pulumi.get(self, "oss_health")

    @_builtins.property
    @pulumi.getter(name="ossUsed")
    def oss_used(self) -> _builtins.str:
        """
        For a cloud-based data is. Unit: `B`.
        """
        return pulumi.get(self, "oss_used")

    @_builtins.property
    @pulumi.getter(name="outRate")
    def out_rate(self) -> _builtins.str:
        """
        Upload speed. Unit: `B/s`.
        """
        return pulumi.get(self, "out_rate")

    @_builtins.property
    @pulumi.getter(name="partialSyncPaths")
    def partial_sync_paths(self) -> _builtins.str:
        """
        In part mode, the directory path group JSON format.
        """
        return pulumi.get(self, "partial_sync_paths")

    @_builtins.property
    @pulumi.getter(name="pathPrefix")
    def path_prefix(self) -> _builtins.str:
        """
        The prefix of the OSS.
        """
        return pulumi.get(self, "path_prefix")

    @_builtins.property
    @pulumi.getter(name="pollingInterval")
    def polling_interval(self) -> _builtins.int:
        """
        The reverse synchronization time intervals of the gateway file share. Value range: `15` ~ `36000`. **NOTE:** in copy mode + reverse synchronization is enabled Download file data, value range: `3600` ~ `36000`.
        """
        return pulumi.get(self, "polling_interval")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Share types. Valid values: `SMB`, `NFS`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="remainingMetaSpace")
    def remaining_meta_space(self) -> _builtins.str:
        """
        You can use the metadata space. Unit: `B`.
        """
        return pulumi.get(self, "remaining_meta_space")

    @_builtins.property
    @pulumi.getter(name="remoteSync")
    def remote_sync(self) -> _builtins.bool:
        """
        Whether to enable reverse synchronization of the gateway file share. Default value: `false`.
        """
        return pulumi.get(self, "remote_sync")

    @_builtins.property
    @pulumi.getter(name="remoteSyncDownload")
    def remote_sync_download(self) -> _builtins.bool:
        """
        Copy mode, whether to download the file data. Default value: `false`. **NOTE:** only when the shared opens the reverse synchronization or acceded to by the speed synchronization group, this parameter will not take effect.
        """
        return pulumi.get(self, "remote_sync_download")

    @_builtins.property
    @pulumi.getter(name="roClientList")
    def ro_client_list(self) -> _builtins.str:
        """
        The read-only client list. When Protocol NFS is returned when the status is.
        """
        return pulumi.get(self, "ro_client_list")

    @_builtins.property
    @pulumi.getter(name="roUserList")
    def ro_user_list(self) -> _builtins.str:
        """
        The read-only client list. When Protocol for Server Message Block (SMB) to go back to.
        """
        return pulumi.get(self, "ro_user_list")

    @_builtins.property
    @pulumi.getter(name="rwClientList")
    def rw_client_list(self) -> _builtins.str:
        """
        Read and write the client list. When Protocol NFS is returned when the status is.
        """
        return pulumi.get(self, "rw_client_list")

    @_builtins.property
    @pulumi.getter(name="rwUserList")
    def rw_user_list(self) -> _builtins.str:
        """
        Read-write user list. When Protocol for Server Message Block (SMB) to go back to.
        """
        return pulumi.get(self, "rw_user_list")

    @_builtins.property
    @pulumi.getter(name="serverSideCmk")
    def server_side_cmk(self) -> _builtins.str:
        """
        File share is enabled server-side encryption, encryption used by the KMS key.
        """
        return pulumi.get(self, "server_side_cmk")

    @_builtins.property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> _builtins.bool:
        """
        If the OSS Bucket side encryption.
        """
        return pulumi.get(self, "server_side_encryption")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.str:
        """
        The caching capacity. Unit: `B`.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def squash(self) -> _builtins.str:
        """
        The set up gateway file share NFS protocol user mapping. Valid values: `none`, `root_squash`, `all_squash`, `all_anonymous`. Default value: `none`.
        """
        return pulumi.get(self, "squash")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        File synchronization types. Valid values: `clean`, `dirty`. `clean`: synchronization is complete. `dirty`: synchronization has not been completed.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="supportArchive")
    def support_archive(self) -> _builtins.bool:
        """
        Whether to support the archive transparent read.
        """
        return pulumi.get(self, "support_archive")

    @_builtins.property
    @pulumi.getter(name="syncProgress")
    def sync_progress(self) -> _builtins.int:
        """
        Full synchronization progress. When the share has been added for a synchronization group, the return parameters are valid, that shared full synchronization progress (0~100). `-2`: indicates that share the Gateway version does not support this feature. `-1`: the share does not occur full synchronization.
        """
        return pulumi.get(self, "sync_progress")

    @_builtins.property
    @pulumi.getter(name="totalDownload")
    def total_download(self) -> _builtins.str:
        """
        The OSS Bucket to the Gateway total downloads. Unit: `B`.
        """
        return pulumi.get(self, "total_download")

    @_builtins.property
    @pulumi.getter(name="totalUpload")
    def total_upload(self) -> _builtins.str:
        """
        The OSS Bucket to the Gateway total Upload amount. Unit: `B`.
        """
        return pulumi.get(self, "total_upload")

    @_builtins.property
    @pulumi.getter(name="transferAcceleration")
    def transfer_acceleration(self) -> _builtins.bool:
        """
        The set up gateway file share whether to enable transmission acceleration needs corresponding OSS Bucket enabled transport acceleration. **NOTE:** Gateway version >= 1.3.0 above support.
        """
        return pulumi.get(self, "transfer_acceleration")

    @_builtins.property
    @pulumi.getter
    def used(self) -> _builtins.str:
        """
        Used cache. Unit: `B`.
        """
        return pulumi.get(self, "used")

    @_builtins.property
    @pulumi.getter(name="windowsAcl")
    def windows_acl(self) -> _builtins.bool:
        """
        The set up gateway file share Server Message Block (SMB) protocol, whether to enable by Windows access list (requires AD domain) the permissions control. Default value: `false`. **NOTE:** Gateway version >= 1.0.45 above support.
        """
        return pulumi.get(self, "windows_acl")


@pulumi.output_type
class GetGatewaySmbUsersUserResult(dict):
    def __init__(__self__, *,
                 gateway_id: _builtins.str,
                 id: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str gateway_id: The Gateway ID.
        :param _builtins.str id: The ID of the Gateway SMB User.
        :param _builtins.str username: The username of the Gateway SMB User.
        """
        pulumi.set(__self__, "gateway_id", gateway_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> _builtins.str:
        """
        The Gateway ID.
        """
        return pulumi.get(self, "gateway_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Gateway SMB User.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username of the Gateway SMB User.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetGatewaysGatewayResult(dict):
    def __init__(__self__, *,
                 activated_time: _builtins.str,
                 buy_url: _builtins.str,
                 category: _builtins.str,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 ecs_instance_id: _builtins.str,
                 expire_status: _builtins.int,
                 expired_time: _builtins.str,
                 gateway_class: _builtins.str,
                 gateway_id: _builtins.str,
                 gateway_name: _builtins.str,
                 gateway_version: _builtins.str,
                 id: _builtins.str,
                 inner_ip: _builtins.str,
                 ip: _builtins.str,
                 is_release_after_expiration: _builtins.bool,
                 location: _builtins.str,
                 payment_type: _builtins.str,
                 public_network_bandwidth: _builtins.int,
                 renew_url: _builtins.str,
                 status: _builtins.str,
                 storage_bundle_id: _builtins.str,
                 task_id: _builtins.str,
                 type: _builtins.str,
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str):
        """
        :param _builtins.str activated_time: gateway .
        :param _builtins.str category: gateway category.
        :param _builtins.str create_time: gateway created timestamp in second format.
        :param _builtins.str description: gateway description.
        :param _builtins.str ecs_instance_id: gateway ecs instance id.
        :param _builtins.int expire_status: gateway expiration status.
        :param _builtins.str expired_time: gateway expiration timestamp in second format.
        :param _builtins.str gateway_class: gateway class.
        :param _builtins.str gateway_id: gateway id.
        :param _builtins.str gateway_name: gateway name.
        :param _builtins.str gateway_version: gateway version.
        :param _builtins.str id: The ID of the Gateway.
        :param _builtins.str inner_ip: gateway service ip.
        :param _builtins.str ip: gateway public ip.
        :param _builtins.bool is_release_after_expiration: whether subscription gateway is released after expiration or not.
        :param _builtins.str location: gateway location.
        :param _builtins.str payment_type: gateway payment type. The Payment type of gateway. The valid value: `PayAsYouGo`, `Subscription`.
        :param _builtins.int public_network_bandwidth: gateway public network bandwidth.
        :param _builtins.str status: gateway status.
        :param _builtins.str storage_bundle_id: storage bundle id.
        :param _builtins.str task_id: gateway task id.
        :param _builtins.str type: gateway type.
        :param _builtins.str vpc_id: gateway vpc id.
        :param _builtins.str vswitch_id: The vswitch id.
        """
        pulumi.set(__self__, "activated_time", activated_time)
        pulumi.set(__self__, "buy_url", buy_url)
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "ecs_instance_id", ecs_instance_id)
        pulumi.set(__self__, "expire_status", expire_status)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "gateway_class", gateway_class)
        pulumi.set(__self__, "gateway_id", gateway_id)
        pulumi.set(__self__, "gateway_name", gateway_name)
        pulumi.set(__self__, "gateway_version", gateway_version)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "inner_ip", inner_ip)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "is_release_after_expiration", is_release_after_expiration)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "public_network_bandwidth", public_network_bandwidth)
        pulumi.set(__self__, "renew_url", renew_url)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage_bundle_id", storage_bundle_id)
        pulumi.set(__self__, "task_id", task_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="activatedTime")
    def activated_time(self) -> _builtins.str:
        """
        gateway .
        """
        return pulumi.get(self, "activated_time")

    @_builtins.property
    @pulumi.getter(name="buyUrl")
    def buy_url(self) -> _builtins.str:
        return pulumi.get(self, "buy_url")

    @_builtins.property
    @pulumi.getter
    def category(self) -> _builtins.str:
        """
        gateway category.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        gateway created timestamp in second format.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        gateway description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ecsInstanceId")
    def ecs_instance_id(self) -> _builtins.str:
        """
        gateway ecs instance id.
        """
        return pulumi.get(self, "ecs_instance_id")

    @_builtins.property
    @pulumi.getter(name="expireStatus")
    def expire_status(self) -> _builtins.int:
        """
        gateway expiration status.
        """
        return pulumi.get(self, "expire_status")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.str:
        """
        gateway expiration timestamp in second format.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="gatewayClass")
    def gateway_class(self) -> _builtins.str:
        """
        gateway class.
        """
        return pulumi.get(self, "gateway_class")

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> _builtins.str:
        """
        gateway id.
        """
        return pulumi.get(self, "gateway_id")

    @_builtins.property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> _builtins.str:
        """
        gateway name.
        """
        return pulumi.get(self, "gateway_name")

    @_builtins.property
    @pulumi.getter(name="gatewayVersion")
    def gateway_version(self) -> _builtins.str:
        """
        gateway version.
        """
        return pulumi.get(self, "gateway_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Gateway.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="innerIp")
    def inner_ip(self) -> _builtins.str:
        """
        gateway service ip.
        """
        return pulumi.get(self, "inner_ip")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        gateway public ip.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="isReleaseAfterExpiration")
    def is_release_after_expiration(self) -> _builtins.bool:
        """
        whether subscription gateway is released after expiration or not.
        """
        return pulumi.get(self, "is_release_after_expiration")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        gateway location.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        gateway payment type. The Payment type of gateway. The valid value: `PayAsYouGo`, `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="publicNetworkBandwidth")
    def public_network_bandwidth(self) -> _builtins.int:
        """
        gateway public network bandwidth.
        """
        return pulumi.get(self, "public_network_bandwidth")

    @_builtins.property
    @pulumi.getter(name="renewUrl")
    def renew_url(self) -> _builtins.str:
        return pulumi.get(self, "renew_url")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        gateway status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageBundleId")
    def storage_bundle_id(self) -> _builtins.str:
        """
        storage bundle id.
        """
        return pulumi.get(self, "storage_bundle_id")

    @_builtins.property
    @pulumi.getter(name="taskId")
    def task_id(self) -> _builtins.str:
        """
        gateway task id.
        """
        return pulumi.get(self, "task_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        gateway type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        gateway vpc id.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetStocksStockResult(dict):
    def __init__(__self__, *,
                 available_gateway_classes: Sequence[_builtins.str],
                 zone_id: _builtins.str):
        """
        :param Sequence[_builtins.str] available_gateway_classes: A list of available gateway class in this Zone ID.
        :param _builtins.str zone_id: The Zone ID.
        """
        pulumi.set(__self__, "available_gateway_classes", available_gateway_classes)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="availableGatewayClasses")
    def available_gateway_classes(self) -> Sequence[_builtins.str]:
        """
        A list of available gateway class in this Zone ID.
        """
        return pulumi.get(self, "available_gateway_classes")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The Zone ID.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetStorageBundlesBundleResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 location: _builtins.str,
                 storage_bundle_id: _builtins.str,
                 storage_bundle_name: _builtins.str):
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "storage_bundle_id", storage_bundle_id)
        pulumi.set(__self__, "storage_bundle_name", storage_bundle_name)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="storageBundleId")
    def storage_bundle_id(self) -> _builtins.str:
        return pulumi.get(self, "storage_bundle_id")

    @_builtins.property
    @pulumi.getter(name="storageBundleName")
    def storage_bundle_name(self) -> _builtins.str:
        return pulumi.get(self, "storage_bundle_name")


