# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegistryEnterpriseInstanceArgs', 'RegistryEnterpriseInstance']

@pulumi.input_type
class RegistryEnterpriseInstanceArgs:
    def __init__(__self__, *,
                 instance_name: pulumi.Input[_builtins.str],
                 instance_type: pulumi.Input[_builtins.str],
                 payment_type: pulumi.Input[_builtins.str],
                 custom_oss_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 default_oss_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 image_scanner: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RegistryEnterpriseInstance resource.
        :param pulumi.Input[_builtins.str] instance_name: InstanceName
        :param pulumi.Input[_builtins.str] instance_type: The Value configuration of the Group 1 attribute of Container Mirror Service Enterprise Edition. Valid values:
               - `Basic`: Basic instance
               - `Standard`: Standard instance
               - `Advanced`: Advanced Edition Instance
        :param pulumi.Input[_builtins.str] payment_type: Payment type, value:
               - Subscription: Prepaid.
        :param pulumi.Input[_builtins.str] custom_oss_bucket: Custom OSS Bucket name
        :param pulumi.Input[_builtins.str] default_oss_bucket: Whether to use the default OSS Bucket. Value:
        :param pulumi.Input[_builtins.str] image_scanner: The security scan engine used by the Enterprise Edition of Container Image Service. Value:
               - `ACR`: Uses the Trivy scan engine provided by default.
               - `SAS`: uses the enhanced cloud security scan engine.
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[_builtins.str] password: Login password, 8-32 digits, must contain at least two letters, symbols, or numbers
        :param pulumi.Input[_builtins.int] period: Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
               
               > **NOTE:**  must be set when creating a prepaid instance.
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal cycle, in months.
               
               > **NOTE:**  When `RenewalStatus` is set to `AutoRenewal`, it must be set.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status, value:
               - AutoRenewal: automatic renewal.
               - ManualRenewal: manual renewal.
               
               Default ManualRenewal.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "payment_type", payment_type)
        if custom_oss_bucket is not None:
            pulumi.set(__self__, "custom_oss_bucket", custom_oss_bucket)
        if default_oss_bucket is not None:
            pulumi.set(__self__, "default_oss_bucket", default_oss_bucket)
        if image_scanner is not None:
            pulumi.set(__self__, "image_scanner", image_scanner)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[_builtins.str]:
        """
        InstanceName
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        The Value configuration of the Group 1 attribute of Container Mirror Service Enterprise Edition. Valid values:
        - `Basic`: Basic instance
        - `Standard`: Standard instance
        - `Advanced`: Advanced Edition Instance
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        Payment type, value:
        - Subscription: Prepaid.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="customOssBucket")
    def custom_oss_bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom OSS Bucket name
        """
        return pulumi.get(self, "custom_oss_bucket")

    @custom_oss_bucket.setter
    def custom_oss_bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_oss_bucket", value)

    @_builtins.property
    @pulumi.getter(name="defaultOssBucket")
    def default_oss_bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to use the default OSS Bucket. Value:
        """
        return pulumi.get(self, "default_oss_bucket")

    @default_oss_bucket.setter
    def default_oss_bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_oss_bucket", value)

    @_builtins.property
    @pulumi.getter(name="imageScanner")
    def image_scanner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security scan engine used by the Enterprise Edition of Container Image Service. Value:
        - `ACR`: Uses the Trivy scan engine provided by default.
        - `SAS`: uses the enhanced cloud security scan engine.
        """
        return pulumi.get(self, "image_scanner")

    @image_scanner.setter
    def image_scanner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_scanner", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Login password, 8-32 digits, must contain at least two letters, symbols, or numbers
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.

        > **NOTE:**  must be set when creating a prepaid instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Automatic renewal cycle, in months.

        > **NOTE:**  When `RenewalStatus` is set to `AutoRenewal`, it must be set.
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_period", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic renewal status, value:
        - AutoRenewal: automatic renewal.
        - ManualRenewal: manual renewal.

        Default ManualRenewal.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)


@pulumi.input_type
class _RegistryEnterpriseInstanceState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 created_time: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_oss_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 default_oss_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 image_scanner: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryEnterpriseInstanceInstanceEndpointArgs']]]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegistryEnterpriseInstance resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] created_time: . Field 'created_time' has been deprecated from provider version 1.235.0. New field 'create_time' instead.
        :param pulumi.Input[_builtins.str] custom_oss_bucket: Custom OSS Bucket name
        :param pulumi.Input[_builtins.str] default_oss_bucket: Whether to use the default OSS Bucket. Value:
        :param pulumi.Input[_builtins.str] end_time: Expiration Time
        :param pulumi.Input[_builtins.str] image_scanner: The security scan engine used by the Enterprise Edition of Container Image Service. Value:
               - `ACR`: Uses the Trivy scan engine provided by default.
               - `SAS`: uses the enhanced cloud security scan engine.
        :param pulumi.Input[Sequence[pulumi.Input['RegistryEnterpriseInstanceInstanceEndpointArgs']]] instance_endpoints: (Available since v1.240.0) Instance Network Access Endpoint List
        :param pulumi.Input[_builtins.str] instance_name: InstanceName
        :param pulumi.Input[_builtins.str] instance_type: The Value configuration of the Group 1 attribute of Container Mirror Service Enterprise Edition. Valid values:
               - `Basic`: Basic instance
               - `Standard`: Standard instance
               - `Advanced`: Advanced Edition Instance
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[_builtins.str] password: Login password, 8-32 digits, must contain at least two letters, symbols, or numbers
        :param pulumi.Input[_builtins.str] payment_type: Payment type, value:
               - Subscription: Prepaid.
        :param pulumi.Input[_builtins.int] period: Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
               
               > **NOTE:**  must be set when creating a prepaid instance.
        :param pulumi.Input[_builtins.str] region_id: RegionId
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal cycle, in months.
               
               > **NOTE:**  When `RenewalStatus` is set to `AutoRenewal`, it must be set.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status, value:
               - AutoRenewal: automatic renewal.
               - ManualRenewal: manual renewal.
               
               Default ManualRenewal.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] status: Instance Status
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if created_time is not None:
            warnings.warn("""Field 'created_time' has been deprecated since provider version 1.235.0. New field 'create_time' instead.""", DeprecationWarning)
            pulumi.log.warn("""created_time is deprecated: Field 'created_time' has been deprecated since provider version 1.235.0. New field 'create_time' instead.""")
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if custom_oss_bucket is not None:
            pulumi.set(__self__, "custom_oss_bucket", custom_oss_bucket)
        if default_oss_bucket is not None:
            pulumi.set(__self__, "default_oss_bucket", default_oss_bucket)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if image_scanner is not None:
            pulumi.set(__self__, "image_scanner", image_scanner)
        if instance_endpoints is not None:
            pulumi.set(__self__, "instance_endpoints", instance_endpoints)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="createdTime")
    @_utilities.deprecated("""Field 'created_time' has been deprecated since provider version 1.235.0. New field 'create_time' instead.""")
    def created_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'created_time' has been deprecated from provider version 1.235.0. New field 'create_time' instead.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_time", value)

    @_builtins.property
    @pulumi.getter(name="customOssBucket")
    def custom_oss_bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom OSS Bucket name
        """
        return pulumi.get(self, "custom_oss_bucket")

    @custom_oss_bucket.setter
    def custom_oss_bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_oss_bucket", value)

    @_builtins.property
    @pulumi.getter(name="defaultOssBucket")
    def default_oss_bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to use the default OSS Bucket. Value:
        """
        return pulumi.get(self, "default_oss_bucket")

    @default_oss_bucket.setter
    def default_oss_bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_oss_bucket", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Expiration Time
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="imageScanner")
    def image_scanner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security scan engine used by the Enterprise Edition of Container Image Service. Value:
        - `ACR`: Uses the Trivy scan engine provided by default.
        - `SAS`: uses the enhanced cloud security scan engine.
        """
        return pulumi.get(self, "image_scanner")

    @image_scanner.setter
    def image_scanner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_scanner", value)

    @_builtins.property
    @pulumi.getter(name="instanceEndpoints")
    def instance_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegistryEnterpriseInstanceInstanceEndpointArgs']]]]:
        """
        (Available since v1.240.0) Instance Network Access Endpoint List
        """
        return pulumi.get(self, "instance_endpoints")

    @instance_endpoints.setter
    def instance_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryEnterpriseInstanceInstanceEndpointArgs']]]]):
        pulumi.set(self, "instance_endpoints", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        InstanceName
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Value configuration of the Group 1 attribute of Container Mirror Service Enterprise Edition. Valid values:
        - `Basic`: Basic instance
        - `Standard`: Standard instance
        - `Advanced`: Advanced Edition Instance
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Login password, 8-32 digits, must contain at least two letters, symbols, or numbers
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Payment type, value:
        - Subscription: Prepaid.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.

        > **NOTE:**  must be set when creating a prepaid instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RegionId
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Automatic renewal cycle, in months.

        > **NOTE:**  When `RenewalStatus` is set to `AutoRenewal`, it must be set.
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_period", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic renewal status, value:
        - AutoRenewal: automatic renewal.
        - ManualRenewal: manual renewal.

        Default ManualRenewal.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance Status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:cr/registryEnterpriseInstance:RegistryEnterpriseInstance")
class RegistryEnterpriseInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_oss_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 default_oss_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 image_scanner: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a CR Instance resource.

        For information about Container Registry Enterprise Edition instances and how to use it, see [Create a Instance](https://www.alibabacloud.com/help/en/doc-detail/208144.htm)

        > **NOTE:** Available since v1.124.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000000,
            max=99999999)
        default_registry_enterprise_instance = alicloud.cr.RegistryEnterpriseInstance("default",
            payment_type="Subscription",
            period=1,
            renew_period=1,
            renewal_status="AutoRenewal",
            instance_type="Advanced",
            instance_name=f"{name}-{default['result']}")
        ```

        ## Import

        CR Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cr/registryEnterpriseInstance:RegistryEnterpriseInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_oss_bucket: Custom OSS Bucket name
        :param pulumi.Input[_builtins.str] default_oss_bucket: Whether to use the default OSS Bucket. Value:
        :param pulumi.Input[_builtins.str] image_scanner: The security scan engine used by the Enterprise Edition of Container Image Service. Value:
               - `ACR`: Uses the Trivy scan engine provided by default.
               - `SAS`: uses the enhanced cloud security scan engine.
        :param pulumi.Input[_builtins.str] instance_name: InstanceName
        :param pulumi.Input[_builtins.str] instance_type: The Value configuration of the Group 1 attribute of Container Mirror Service Enterprise Edition. Valid values:
               - `Basic`: Basic instance
               - `Standard`: Standard instance
               - `Advanced`: Advanced Edition Instance
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[_builtins.str] password: Login password, 8-32 digits, must contain at least two letters, symbols, or numbers
        :param pulumi.Input[_builtins.str] payment_type: Payment type, value:
               - Subscription: Prepaid.
        :param pulumi.Input[_builtins.int] period: Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
               
               > **NOTE:**  must be set when creating a prepaid instance.
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal cycle, in months.
               
               > **NOTE:**  When `RenewalStatus` is set to `AutoRenewal`, it must be set.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status, value:
               - AutoRenewal: automatic renewal.
               - ManualRenewal: manual renewal.
               
               Default ManualRenewal.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegistryEnterpriseInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CR Instance resource.

        For information about Container Registry Enterprise Edition instances and how to use it, see [Create a Instance](https://www.alibabacloud.com/help/en/doc-detail/208144.htm)

        > **NOTE:** Available since v1.124.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000000,
            max=99999999)
        default_registry_enterprise_instance = alicloud.cr.RegistryEnterpriseInstance("default",
            payment_type="Subscription",
            period=1,
            renew_period=1,
            renewal_status="AutoRenewal",
            instance_type="Advanced",
            instance_name=f"{name}-{default['result']}")
        ```

        ## Import

        CR Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cr/registryEnterpriseInstance:RegistryEnterpriseInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param RegistryEnterpriseInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegistryEnterpriseInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_oss_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 default_oss_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 image_scanner: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegistryEnterpriseInstanceArgs.__new__(RegistryEnterpriseInstanceArgs)

            __props__.__dict__["custom_oss_bucket"] = custom_oss_bucket
            __props__.__dict__["default_oss_bucket"] = default_oss_bucket
            __props__.__dict__["image_scanner"] = image_scanner
            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
            __props__.__dict__["kms_encryption_context"] = kms_encryption_context
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["renew_period"] = renew_period
            __props__.__dict__["renewal_status"] = renewal_status
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["end_time"] = None
            __props__.__dict__["instance_endpoints"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RegistryEnterpriseInstance, __self__).__init__(
            'alicloud:cr/registryEnterpriseInstance:RegistryEnterpriseInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            created_time: Optional[pulumi.Input[_builtins.str]] = None,
            custom_oss_bucket: Optional[pulumi.Input[_builtins.str]] = None,
            default_oss_bucket: Optional[pulumi.Input[_builtins.str]] = None,
            end_time: Optional[pulumi.Input[_builtins.str]] = None,
            image_scanner: Optional[pulumi.Input[_builtins.str]] = None,
            instance_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegistryEnterpriseInstanceInstanceEndpointArgs', 'RegistryEnterpriseInstanceInstanceEndpointArgsDict']]]]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
            kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            renew_period: Optional[pulumi.Input[_builtins.int]] = None,
            renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'RegistryEnterpriseInstance':
        """
        Get an existing RegistryEnterpriseInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] created_time: . Field 'created_time' has been deprecated from provider version 1.235.0. New field 'create_time' instead.
        :param pulumi.Input[_builtins.str] custom_oss_bucket: Custom OSS Bucket name
        :param pulumi.Input[_builtins.str] default_oss_bucket: Whether to use the default OSS Bucket. Value:
        :param pulumi.Input[_builtins.str] end_time: Expiration Time
        :param pulumi.Input[_builtins.str] image_scanner: The security scan engine used by the Enterprise Edition of Container Image Service. Value:
               - `ACR`: Uses the Trivy scan engine provided by default.
               - `SAS`: uses the enhanced cloud security scan engine.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegistryEnterpriseInstanceInstanceEndpointArgs', 'RegistryEnterpriseInstanceInstanceEndpointArgsDict']]]] instance_endpoints: (Available since v1.240.0) Instance Network Access Endpoint List
        :param pulumi.Input[_builtins.str] instance_name: InstanceName
        :param pulumi.Input[_builtins.str] instance_type: The Value configuration of the Group 1 attribute of Container Mirror Service Enterprise Edition. Valid values:
               - `Basic`: Basic instance
               - `Standard`: Standard instance
               - `Advanced`: Advanced Edition Instance
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[_builtins.str] password: Login password, 8-32 digits, must contain at least two letters, symbols, or numbers
        :param pulumi.Input[_builtins.str] payment_type: Payment type, value:
               - Subscription: Prepaid.
        :param pulumi.Input[_builtins.int] period: Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
               
               > **NOTE:**  must be set when creating a prepaid instance.
        :param pulumi.Input[_builtins.str] region_id: RegionId
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal cycle, in months.
               
               > **NOTE:**  When `RenewalStatus` is set to `AutoRenewal`, it must be set.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status, value:
               - AutoRenewal: automatic renewal.
               - ManualRenewal: manual renewal.
               
               Default ManualRenewal.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] status: Instance Status
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegistryEnterpriseInstanceState.__new__(_RegistryEnterpriseInstanceState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["custom_oss_bucket"] = custom_oss_bucket
        __props__.__dict__["default_oss_bucket"] = default_oss_bucket
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["image_scanner"] = image_scanner
        __props__.__dict__["instance_endpoints"] = instance_endpoints
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
        __props__.__dict__["kms_encryption_context"] = kms_encryption_context
        __props__.__dict__["password"] = password
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["renew_period"] = renew_period
        __props__.__dict__["renewal_status"] = renewal_status
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        return RegistryEnterpriseInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    @_utilities.deprecated("""Field 'created_time' has been deprecated since provider version 1.235.0. New field 'create_time' instead.""")
    def created_time(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'created_time' has been deprecated from provider version 1.235.0. New field 'create_time' instead.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter(name="customOssBucket")
    def custom_oss_bucket(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom OSS Bucket name
        """
        return pulumi.get(self, "custom_oss_bucket")

    @_builtins.property
    @pulumi.getter(name="defaultOssBucket")
    def default_oss_bucket(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to use the default OSS Bucket. Value:
        """
        return pulumi.get(self, "default_oss_bucket")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[_builtins.str]:
        """
        Expiration Time
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="imageScanner")
    def image_scanner(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The security scan engine used by the Enterprise Edition of Container Image Service. Value:
        - `ACR`: Uses the Trivy scan engine provided by default.
        - `SAS`: uses the enhanced cloud security scan engine.
        """
        return pulumi.get(self, "image_scanner")

    @_builtins.property
    @pulumi.getter(name="instanceEndpoints")
    def instance_endpoints(self) -> pulumi.Output[Sequence['outputs.RegistryEnterpriseInstanceInstanceEndpoint']]:
        """
        (Available since v1.240.0) Instance Network Access Endpoint List
        """
        return pulumi.get(self, "instance_endpoints")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        InstanceName
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The Value configuration of the Group 1 attribute of Container Mirror Service Enterprise Edition. Valid values:
        - `Basic`: Basic instance
        - `Standard`: Standard instance
        - `Advanced`: Advanced Edition Instance
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Login password, 8-32 digits, must contain at least two letters, symbols, or numbers
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        Payment type, value:
        - Subscription: Prepaid.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.

        > **NOTE:**  must be set when creating a prepaid instance.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        RegionId
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Automatic renewal cycle, in months.

        > **NOTE:**  When `RenewalStatus` is set to `AutoRenewal`, it must be set.
        """
        return pulumi.get(self, "renew_period")

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> pulumi.Output[_builtins.str]:
        """
        Automatic renewal status, value:
        - AutoRenewal: automatic renewal.
        - ManualRenewal: manual renewal.

        Default ManualRenewal.
        """
        return pulumi.get(self, "renewal_status")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Instance Status
        """
        return pulumi.get(self, "status")

