# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RegistryEnterpriseRepoArgs', 'RegistryEnterpriseRepo']

@pulumi.input_type
class RegistryEnterpriseRepoArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 namespace: pulumi.Input[_builtins.str],
                 repo_type: pulumi.Input[_builtins.str],
                 summary: pulumi.Input[_builtins.str],
                 detail: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RegistryEnterpriseRepo resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Container Registry Enterprise Edition instance.
        :param pulumi.Input[_builtins.str] namespace: The name of the namespace to which the image repository belongs.
        :param pulumi.Input[_builtins.str] repo_type: The type of the repository. Valid values:
               - `PUBLIC`: The repository is a public repository.
               - `PRIVATE`: The repository is a private repository.
        :param pulumi.Input[_builtins.str] summary: The summary about the repository.
        :param pulumi.Input[_builtins.str] detail: The description of the repository.
        :param pulumi.Input[_builtins.str] name: The name of the image repository.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "repo_type", repo_type)
        pulumi.set(__self__, "summary", summary)
        if detail is not None:
            pulumi.set(__self__, "detail", detail)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the namespace to which the image repository belongs.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the repository. Valid values:
        - `PUBLIC`: The repository is a public repository.
        - `PRIVATE`: The repository is a private repository.
        """
        return pulumi.get(self, "repo_type")

    @repo_type.setter
    def repo_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repo_type", value)

    @_builtins.property
    @pulumi.getter
    def summary(self) -> pulumi.Input[_builtins.str]:
        """
        The summary about the repository.
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "summary", value)

    @_builtins.property
    @pulumi.getter
    def detail(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the repository.
        """
        return pulumi.get(self, "detail")

    @detail.setter
    def detail(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detail", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the image repository.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RegistryEnterpriseRepoState:
    def __init__(__self__, *,
                 detail: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_type: Optional[pulumi.Input[_builtins.str]] = None,
                 summary: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegistryEnterpriseRepo resources.
        :param pulumi.Input[_builtins.str] detail: The description of the repository.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Container Registry Enterprise Edition instance.
        :param pulumi.Input[_builtins.str] name: The name of the image repository.
        :param pulumi.Input[_builtins.str] namespace: The name of the namespace to which the image repository belongs.
        :param pulumi.Input[_builtins.str] repo_id: The ID of the repository.
        :param pulumi.Input[_builtins.str] repo_type: The type of the repository. Valid values:
               - `PUBLIC`: The repository is a public repository.
               - `PRIVATE`: The repository is a private repository.
        :param pulumi.Input[_builtins.str] summary: The summary about the repository.
        """
        if detail is not None:
            pulumi.set(__self__, "detail", detail)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if repo_id is not None:
            pulumi.set(__self__, "repo_id", repo_id)
        if repo_type is not None:
            pulumi.set(__self__, "repo_type", repo_type)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)

    @_builtins.property
    @pulumi.getter
    def detail(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the repository.
        """
        return pulumi.get(self, "detail")

    @detail.setter
    def detail(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detail", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the image repository.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the namespace to which the image repository belongs.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the repository.
        """
        return pulumi.get(self, "repo_id")

    @repo_id.setter
    def repo_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repo_id", value)

    @_builtins.property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the repository. Valid values:
        - `PUBLIC`: The repository is a public repository.
        - `PRIVATE`: The repository is a private repository.
        """
        return pulumi.get(self, "repo_type")

    @repo_type.setter
    def repo_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repo_type", value)

    @_builtins.property
    @pulumi.getter
    def summary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The summary about the repository.
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "summary", value)


@pulumi.type_token("alicloud:cs/registryEnterpriseRepo:RegistryEnterpriseRepo")
class RegistryEnterpriseRepo(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 detail: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_type: Optional[pulumi.Input[_builtins.str]] = None,
                 summary: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Container Registry Enterprise Edition Repository resource.

        For information about Container Registry Enterprise Edition Repository and how to use it, see [What is Repository](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createrepository)

        > **NOTE:** Available since v1.86.0.

        > **NOTE:** You need to set your registry password in Container Registry Enterprise Edition console before use this resource.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000000,
            max=99999999)
        default_registry_enterprise_instance = alicloud.cr.RegistryEnterpriseInstance("default",
            payment_type="Subscription",
            period=1,
            renew_period=0,
            renewal_status="ManualRenewal",
            instance_type="Advanced",
            instance_name=f"{name}-{default['result']}")
        default_registry_enterprise_namespace = alicloud.cs.RegistryEnterpriseNamespace("default",
            instance_id=default_registry_enterprise_instance.id,
            name=f"{name}-{default['result']}",
            auto_create=False,
            default_visibility="PUBLIC")
        example = alicloud.cs.RegistryEnterpriseRepo("example",
            instance_id=default_registry_enterprise_instance.id,
            namespace=default_registry_enterprise_namespace.name,
            name=f"{name}-{default['result']}",
            repo_type="PUBLIC",
            summary="this is summary of my new repo",
            detail="this is a public repo")
        ```

        ## Import

        Container Registry Enterprise Edition Repository can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cs/registryEnterpriseRepo:RegistryEnterpriseRepo example <instance_id>:<namespace>:<name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] detail: The description of the repository.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Container Registry Enterprise Edition instance.
        :param pulumi.Input[_builtins.str] name: The name of the image repository.
        :param pulumi.Input[_builtins.str] namespace: The name of the namespace to which the image repository belongs.
        :param pulumi.Input[_builtins.str] repo_type: The type of the repository. Valid values:
               - `PUBLIC`: The repository is a public repository.
               - `PRIVATE`: The repository is a private repository.
        :param pulumi.Input[_builtins.str] summary: The summary about the repository.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegistryEnterpriseRepoArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Container Registry Enterprise Edition Repository resource.

        For information about Container Registry Enterprise Edition Repository and how to use it, see [What is Repository](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createrepository)

        > **NOTE:** Available since v1.86.0.

        > **NOTE:** You need to set your registry password in Container Registry Enterprise Edition console before use this resource.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000000,
            max=99999999)
        default_registry_enterprise_instance = alicloud.cr.RegistryEnterpriseInstance("default",
            payment_type="Subscription",
            period=1,
            renew_period=0,
            renewal_status="ManualRenewal",
            instance_type="Advanced",
            instance_name=f"{name}-{default['result']}")
        default_registry_enterprise_namespace = alicloud.cs.RegistryEnterpriseNamespace("default",
            instance_id=default_registry_enterprise_instance.id,
            name=f"{name}-{default['result']}",
            auto_create=False,
            default_visibility="PUBLIC")
        example = alicloud.cs.RegistryEnterpriseRepo("example",
            instance_id=default_registry_enterprise_instance.id,
            namespace=default_registry_enterprise_namespace.name,
            name=f"{name}-{default['result']}",
            repo_type="PUBLIC",
            summary="this is summary of my new repo",
            detail="this is a public repo")
        ```

        ## Import

        Container Registry Enterprise Edition Repository can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cs/registryEnterpriseRepo:RegistryEnterpriseRepo example <instance_id>:<namespace>:<name>
        ```

        :param str resource_name: The name of the resource.
        :param RegistryEnterpriseRepoArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegistryEnterpriseRepoArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 detail: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_type: Optional[pulumi.Input[_builtins.str]] = None,
                 summary: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegistryEnterpriseRepoArgs.__new__(RegistryEnterpriseRepoArgs)

            __props__.__dict__["detail"] = detail
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            if repo_type is None and not opts.urn:
                raise TypeError("Missing required property 'repo_type'")
            __props__.__dict__["repo_type"] = repo_type
            if summary is None and not opts.urn:
                raise TypeError("Missing required property 'summary'")
            __props__.__dict__["summary"] = summary
            __props__.__dict__["repo_id"] = None
        super(RegistryEnterpriseRepo, __self__).__init__(
            'alicloud:cs/registryEnterpriseRepo:RegistryEnterpriseRepo',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            detail: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            repo_id: Optional[pulumi.Input[_builtins.str]] = None,
            repo_type: Optional[pulumi.Input[_builtins.str]] = None,
            summary: Optional[pulumi.Input[_builtins.str]] = None) -> 'RegistryEnterpriseRepo':
        """
        Get an existing RegistryEnterpriseRepo resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] detail: The description of the repository.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Container Registry Enterprise Edition instance.
        :param pulumi.Input[_builtins.str] name: The name of the image repository.
        :param pulumi.Input[_builtins.str] namespace: The name of the namespace to which the image repository belongs.
        :param pulumi.Input[_builtins.str] repo_id: The ID of the repository.
        :param pulumi.Input[_builtins.str] repo_type: The type of the repository. Valid values:
               - `PUBLIC`: The repository is a public repository.
               - `PRIVATE`: The repository is a private repository.
        :param pulumi.Input[_builtins.str] summary: The summary about the repository.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegistryEnterpriseRepoState.__new__(_RegistryEnterpriseRepoState)

        __props__.__dict__["detail"] = detail
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["repo_id"] = repo_id
        __props__.__dict__["repo_type"] = repo_type
        __props__.__dict__["summary"] = summary
        return RegistryEnterpriseRepo(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def detail(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the repository.
        """
        return pulumi.get(self, "detail")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the image repository.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the namespace to which the image repository belongs.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the repository.
        """
        return pulumi.get(self, "repo_id")

    @_builtins.property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the repository. Valid values:
        - `PUBLIC`: The repository is a public repository.
        - `PRIVATE`: The repository is a private repository.
        """
        return pulumi.get(self, "repo_type")

    @_builtins.property
    @pulumi.getter
    def summary(self) -> pulumi.Output[_builtins.str]:
        """
        The summary about the repository.
        """
        return pulumi.get(self, "summary")

