# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceAttachmentArgs', 'InstanceAttachment']

@pulumi.input_type
class InstanceAttachmentArgs:
    def __init__(__self__, *,
                 ecs_id: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a InstanceAttachment resource.
        :param pulumi.Input[_builtins.str] ecs_id: The ID of the ECS instance.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Database File System.
        """
        pulumi.set(__self__, "ecs_id", ecs_id)
        pulumi.set(__self__, "instance_id", instance_id)

    @_builtins.property
    @pulumi.getter(name="ecsId")
    def ecs_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the ECS instance.
        """
        return pulumi.get(self, "ecs_id")

    @ecs_id.setter
    def ecs_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ecs_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Database File System.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)


@pulumi.input_type
class _InstanceAttachmentState:
    def __init__(__self__, *,
                 ecs_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceAttachment resources.
        :param pulumi.Input[_builtins.str] ecs_id: The ID of the ECS instance.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Database File System.
        :param pulumi.Input[_builtins.str] status: The status of Instance Attachment.
        """
        if ecs_id is not None:
            pulumi.set(__self__, "ecs_id", ecs_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="ecsId")
    def ecs_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the ECS instance.
        """
        return pulumi.get(self, "ecs_id")

    @ecs_id.setter
    def ecs_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ecs_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Database File System.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of Instance Attachment.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:databasefilesystem/instanceAttachment:InstanceAttachment")
class InstanceAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ecs_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Database File System (DBFS) Instance Attachment resource.

        For information about Database File System (DBFS) Instance Attachment and how to use it, see [What is Snapshot](https://help.aliyun.com/zh/dbfs/developer-reference/api-dbfs-2020-04-18-attachdbfs).

        > **NOTE:** Available since v1.156.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        zone_id = "cn-hangzhou-i"
        default = alicloud.databasefilesystem.get_instances()
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=zone_id,
            instance_type_family="ecs.g7se")
        default_get_images = alicloud.ecs.get_images(instance_type=default_get_instance_types.instance_types[0].id,
            name_regex="^aliyun_2_19",
            owners="system")
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id=zone_id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_get_networks.ids[0])
        default_instance = alicloud.ecs.Instance("default",
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            security_groups=[__item.id for __item in [default_security_group]],
            internet_charge_type="PayByTraffic",
            internet_max_bandwidth_out=10,
            availability_zone=default_get_instance_types.instance_types[0].availability_zones[0],
            instance_charge_type="PostPaid",
            system_disk_category="cloud_essd",
            vswitch_id=default_get_switches.ids[0],
            instance_name=name)
        default_instance_attachment = alicloud.databasefilesystem.InstanceAttachment("default",
            instance_id=default.instances[0].id,
            ecs_id=default_instance.id)
        ```

        ## Import

        Database File System (DBFS) Instance Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:databasefilesystem/instanceAttachment:InstanceAttachment example <instance_id>:<ecs_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ecs_id: The ID of the ECS instance.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Database File System.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Database File System (DBFS) Instance Attachment resource.

        For information about Database File System (DBFS) Instance Attachment and how to use it, see [What is Snapshot](https://help.aliyun.com/zh/dbfs/developer-reference/api-dbfs-2020-04-18-attachdbfs).

        > **NOTE:** Available since v1.156.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        zone_id = "cn-hangzhou-i"
        default = alicloud.databasefilesystem.get_instances()
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=zone_id,
            instance_type_family="ecs.g7se")
        default_get_images = alicloud.ecs.get_images(instance_type=default_get_instance_types.instance_types[0].id,
            name_regex="^aliyun_2_19",
            owners="system")
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id=zone_id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_get_networks.ids[0])
        default_instance = alicloud.ecs.Instance("default",
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            security_groups=[__item.id for __item in [default_security_group]],
            internet_charge_type="PayByTraffic",
            internet_max_bandwidth_out=10,
            availability_zone=default_get_instance_types.instance_types[0].availability_zones[0],
            instance_charge_type="PostPaid",
            system_disk_category="cloud_essd",
            vswitch_id=default_get_switches.ids[0],
            instance_name=name)
        default_instance_attachment = alicloud.databasefilesystem.InstanceAttachment("default",
            instance_id=default.instances[0].id,
            ecs_id=default_instance.id)
        ```

        ## Import

        Database File System (DBFS) Instance Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:databasefilesystem/instanceAttachment:InstanceAttachment example <instance_id>:<ecs_id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ecs_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceAttachmentArgs.__new__(InstanceAttachmentArgs)

            if ecs_id is None and not opts.urn:
                raise TypeError("Missing required property 'ecs_id'")
            __props__.__dict__["ecs_id"] = ecs_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["status"] = None
        super(InstanceAttachment, __self__).__init__(
            'alicloud:databasefilesystem/instanceAttachment:InstanceAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ecs_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'InstanceAttachment':
        """
        Get an existing InstanceAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ecs_id: The ID of the ECS instance.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Database File System.
        :param pulumi.Input[_builtins.str] status: The status of Instance Attachment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceAttachmentState.__new__(_InstanceAttachmentState)

        __props__.__dict__["ecs_id"] = ecs_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["status"] = status
        return InstanceAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="ecsId")
    def ecs_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the ECS instance.
        """
        return pulumi.get(self, "ecs_id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Database File System.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of Instance Attachment.
        """
        return pulumi.get(self, "status")

