# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DataSourceSharedRuleArgs', 'DataSourceSharedRule']

@pulumi.input_type
class DataSourceSharedRuleArgs:
    def __init__(__self__, *,
                 data_source_id: pulumi.Input[_builtins.int],
                 env_type: pulumi.Input[_builtins.str],
                 target_project_id: pulumi.Input[_builtins.int],
                 shared_user: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DataSourceSharedRule resource.
        :param pulumi.Input[_builtins.int] data_source_id: The ID of the data source, that is, the unique identifier of the data source.
        :param pulumi.Input[_builtins.str] env_type: The environment type of the data source shared to the target project, such as Dev (Development Environment) and Prod (production environment).
        :param pulumi.Input[_builtins.int] target_project_id: The ID of the project to which the data source is shared.
        :param pulumi.Input[_builtins.str] shared_user: The target user of the data source permission policy, which is null to share to the project.
        """
        pulumi.set(__self__, "data_source_id", data_source_id)
        pulumi.set(__self__, "env_type", env_type)
        pulumi.set(__self__, "target_project_id", target_project_id)
        if shared_user is not None:
            pulumi.set(__self__, "shared_user", shared_user)

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the data source, that is, the unique identifier of the data source.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "data_source_id", value)

    @_builtins.property
    @pulumi.getter(name="envType")
    def env_type(self) -> pulumi.Input[_builtins.str]:
        """
        The environment type of the data source shared to the target project, such as Dev (Development Environment) and Prod (production environment).
        """
        return pulumi.get(self, "env_type")

    @env_type.setter
    def env_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "env_type", value)

    @_builtins.property
    @pulumi.getter(name="targetProjectId")
    def target_project_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the project to which the data source is shared.
        """
        return pulumi.get(self, "target_project_id")

    @target_project_id.setter
    def target_project_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "target_project_id", value)

    @_builtins.property
    @pulumi.getter(name="sharedUser")
    def shared_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target user of the data source permission policy, which is null to share to the project.
        """
        return pulumi.get(self, "shared_user")

    @shared_user.setter
    def shared_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_user", value)


@pulumi.input_type
class _DataSourceSharedRuleState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.int]] = None,
                 data_source_shared_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 env_type: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_user: Optional[pulumi.Input[_builtins.str]] = None,
                 target_project_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering DataSourceSharedRule resources.
        :param pulumi.Input[_builtins.int] create_time: The creation time of the data source sharing rule.
        :param pulumi.Input[_builtins.int] data_source_id: The ID of the data source, that is, the unique identifier of the data source.
        :param pulumi.Input[_builtins.str] data_source_shared_rule_id: The data source sharing rule ID, that is, the unique identifier of the data source sharing rule.
        :param pulumi.Input[_builtins.str] env_type: The environment type of the data source shared to the target project, such as Dev (Development Environment) and Prod (production environment).
        :param pulumi.Input[_builtins.str] shared_user: The target user of the data source permission policy, which is null to share to the project.
        :param pulumi.Input[_builtins.int] target_project_id: The ID of the project to which the data source is shared.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_source_id is not None:
            pulumi.set(__self__, "data_source_id", data_source_id)
        if data_source_shared_rule_id is not None:
            pulumi.set(__self__, "data_source_shared_rule_id", data_source_shared_rule_id)
        if env_type is not None:
            pulumi.set(__self__, "env_type", env_type)
        if shared_user is not None:
            pulumi.set(__self__, "shared_user", shared_user)
        if target_project_id is not None:
            pulumi.set(__self__, "target_project_id", target_project_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The creation time of the data source sharing rule.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the data source, that is, the unique identifier of the data source.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_source_id", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceSharedRuleId")
    def data_source_shared_rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data source sharing rule ID, that is, the unique identifier of the data source sharing rule.
        """
        return pulumi.get(self, "data_source_shared_rule_id")

    @data_source_shared_rule_id.setter
    def data_source_shared_rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_shared_rule_id", value)

    @_builtins.property
    @pulumi.getter(name="envType")
    def env_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The environment type of the data source shared to the target project, such as Dev (Development Environment) and Prod (production environment).
        """
        return pulumi.get(self, "env_type")

    @env_type.setter
    def env_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "env_type", value)

    @_builtins.property
    @pulumi.getter(name="sharedUser")
    def shared_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target user of the data source permission policy, which is null to share to the project.
        """
        return pulumi.get(self, "shared_user")

    @shared_user.setter
    def shared_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_user", value)

    @_builtins.property
    @pulumi.getter(name="targetProjectId")
    def target_project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the project to which the data source is shared.
        """
        return pulumi.get(self, "target_project_id")

    @target_project_id.setter
    def target_project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "target_project_id", value)


@pulumi.type_token("alicloud:dataworks/dataSourceSharedRule:DataSourceSharedRule")
class DataSourceSharedRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.int]] = None,
                 env_type: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_user: Optional[pulumi.Input[_builtins.str]] = None,
                 target_project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Data Works Data Source Shared Rule resource.

        Data source sharing rule, which expresses A data source, from space A to space B (A user).

        For information about Data Works Data Source Shared Rule and how to use it, see [What is Data Source Shared Rule](https://www.alibabacloud.com/help/en/dataworks/developer-reference/api-dataworks-public-2024-05-18-createdatasourcesharedrule).

        > **NOTE:** Available since v1.237.0.

        ## Import

        Data Works Data Source Shared Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dataworks/dataSourceSharedRule:DataSourceSharedRule example <data_source_id>:<data_source_shared_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] data_source_id: The ID of the data source, that is, the unique identifier of the data source.
        :param pulumi.Input[_builtins.str] env_type: The environment type of the data source shared to the target project, such as Dev (Development Environment) and Prod (production environment).
        :param pulumi.Input[_builtins.str] shared_user: The target user of the data source permission policy, which is null to share to the project.
        :param pulumi.Input[_builtins.int] target_project_id: The ID of the project to which the data source is shared.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataSourceSharedRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Data Works Data Source Shared Rule resource.

        Data source sharing rule, which expresses A data source, from space A to space B (A user).

        For information about Data Works Data Source Shared Rule and how to use it, see [What is Data Source Shared Rule](https://www.alibabacloud.com/help/en/dataworks/developer-reference/api-dataworks-public-2024-05-18-createdatasourcesharedrule).

        > **NOTE:** Available since v1.237.0.

        ## Import

        Data Works Data Source Shared Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dataworks/dataSourceSharedRule:DataSourceSharedRule example <data_source_id>:<data_source_shared_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param DataSourceSharedRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataSourceSharedRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.int]] = None,
                 env_type: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_user: Optional[pulumi.Input[_builtins.str]] = None,
                 target_project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataSourceSharedRuleArgs.__new__(DataSourceSharedRuleArgs)

            if data_source_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_source_id'")
            __props__.__dict__["data_source_id"] = data_source_id
            if env_type is None and not opts.urn:
                raise TypeError("Missing required property 'env_type'")
            __props__.__dict__["env_type"] = env_type
            __props__.__dict__["shared_user"] = shared_user
            if target_project_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_project_id'")
            __props__.__dict__["target_project_id"] = target_project_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["data_source_shared_rule_id"] = None
        super(DataSourceSharedRule, __self__).__init__(
            'alicloud:dataworks/dataSourceSharedRule:DataSourceSharedRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            data_source_id: Optional[pulumi.Input[_builtins.int]] = None,
            data_source_shared_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
            env_type: Optional[pulumi.Input[_builtins.str]] = None,
            shared_user: Optional[pulumi.Input[_builtins.str]] = None,
            target_project_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'DataSourceSharedRule':
        """
        Get an existing DataSourceSharedRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] create_time: The creation time of the data source sharing rule.
        :param pulumi.Input[_builtins.int] data_source_id: The ID of the data source, that is, the unique identifier of the data source.
        :param pulumi.Input[_builtins.str] data_source_shared_rule_id: The data source sharing rule ID, that is, the unique identifier of the data source sharing rule.
        :param pulumi.Input[_builtins.str] env_type: The environment type of the data source shared to the target project, such as Dev (Development Environment) and Prod (production environment).
        :param pulumi.Input[_builtins.str] shared_user: The target user of the data source permission policy, which is null to share to the project.
        :param pulumi.Input[_builtins.int] target_project_id: The ID of the project to which the data source is shared.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataSourceSharedRuleState.__new__(_DataSourceSharedRuleState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_source_id"] = data_source_id
        __props__.__dict__["data_source_shared_rule_id"] = data_source_shared_rule_id
        __props__.__dict__["env_type"] = env_type
        __props__.__dict__["shared_user"] = shared_user
        __props__.__dict__["target_project_id"] = target_project_id
        return DataSourceSharedRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        """
        The creation time of the data source sharing rule.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the data source, that is, the unique identifier of the data source.
        """
        return pulumi.get(self, "data_source_id")

    @_builtins.property
    @pulumi.getter(name="dataSourceSharedRuleId")
    def data_source_shared_rule_id(self) -> pulumi.Output[_builtins.str]:
        """
        The data source sharing rule ID, that is, the unique identifier of the data source sharing rule.
        """
        return pulumi.get(self, "data_source_shared_rule_id")

    @_builtins.property
    @pulumi.getter(name="envType")
    def env_type(self) -> pulumi.Output[_builtins.str]:
        """
        The environment type of the data source shared to the target project, such as Dev (Development Environment) and Prod (production environment).
        """
        return pulumi.get(self, "env_type")

    @_builtins.property
    @pulumi.getter(name="sharedUser")
    def shared_user(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The target user of the data source permission policy, which is null to share to the project.
        """
        return pulumi.get(self, "shared_user")

    @_builtins.property
    @pulumi.getter(name="targetProjectId")
    def target_project_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the project to which the data source is shared.
        """
        return pulumi.get(self, "target_project_id")

