# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DiJobArgs', 'DiJob']

@pulumi.input_type
class DiJobArgs:
    def __init__(__self__, *,
                 destination_data_source_settings: pulumi.Input[Sequence[pulumi.Input['DiJobDestinationDataSourceSettingArgs']]],
                 destination_data_source_type: pulumi.Input[_builtins.str],
                 job_name: pulumi.Input[_builtins.str],
                 migration_type: pulumi.Input[_builtins.str],
                 resource_settings: pulumi.Input['DiJobResourceSettingsArgs'],
                 source_data_source_settings: pulumi.Input[Sequence[pulumi.Input['DiJobSourceDataSourceSettingArgs']]],
                 source_data_source_type: pulumi.Input[_builtins.str],
                 table_mappings: pulumi.Input[Sequence[pulumi.Input['DiJobTableMappingArgs']]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 job_settings: Optional[pulumi.Input['DiJobJobSettingsArgs']] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 transformation_rules: Optional[pulumi.Input[Sequence[pulumi.Input['DiJobTransformationRuleArgs']]]] = None):
        """
        The set of arguments for constructing a DiJob resource.
        :param pulumi.Input[Sequence[pulumi.Input['DiJobDestinationDataSourceSettingArgs']]] destination_data_source_settings: Destination data source See `destination_data_source_settings` below.
        :param pulumi.Input[_builtins.str] destination_data_source_type: The type of the target data source. Enumerated values: Hologres and Hive.
        :param pulumi.Input[_builtins.str] job_name: Task Name.
        :param pulumi.Input[_builtins.str] migration_type: Synchronization type, optional enumeration values are:
               
               Fulllandrealtimeincremental (full and real-time incremental)
               
               RealtimeIncremental
               
               Full
               
               Offflineincremental
               
               FullAndOfflineIncremental (full amount + offline increment)
        :param pulumi.Input['DiJobResourceSettingsArgs'] resource_settings: Resource Group Properties See `resource_settings` below.
        :param pulumi.Input[Sequence[pulumi.Input['DiJobSourceDataSourceSettingArgs']]] source_data_source_settings: Source data source setting List See `source_data_source_settings` below.
        :param pulumi.Input[_builtins.str] source_data_source_type: The type of the source data source. The enumerated value is MySQL.
        :param pulumi.Input[Sequence[pulumi.Input['DiJobTableMappingArgs']]] table_mappings: Synchronize object transformation mapping list See `table_mappings` below.
        :param pulumi.Input[_builtins.str] description: Description of the integration task
        :param pulumi.Input['DiJobJobSettingsArgs'] job_settings: The dimension settings of the synchronization task, including the DDL processing policy, the source and destination column data type mapping policy, and the task runtime parameters. See `job_settings` below.
        :param pulumi.Input[_builtins.int] project_id: Project Id
        :param pulumi.Input[Sequence[pulumi.Input['DiJobTransformationRuleArgs']]] transformation_rules: Definition list of synchronization object conversion rules See `transformation_rules` below.
        """
        pulumi.set(__self__, "destination_data_source_settings", destination_data_source_settings)
        pulumi.set(__self__, "destination_data_source_type", destination_data_source_type)
        pulumi.set(__self__, "job_name", job_name)
        pulumi.set(__self__, "migration_type", migration_type)
        pulumi.set(__self__, "resource_settings", resource_settings)
        pulumi.set(__self__, "source_data_source_settings", source_data_source_settings)
        pulumi.set(__self__, "source_data_source_type", source_data_source_type)
        pulumi.set(__self__, "table_mappings", table_mappings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if job_settings is not None:
            pulumi.set(__self__, "job_settings", job_settings)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if transformation_rules is not None:
            pulumi.set(__self__, "transformation_rules", transformation_rules)

    @_builtins.property
    @pulumi.getter(name="destinationDataSourceSettings")
    def destination_data_source_settings(self) -> pulumi.Input[Sequence[pulumi.Input['DiJobDestinationDataSourceSettingArgs']]]:
        """
        Destination data source See `destination_data_source_settings` below.
        """
        return pulumi.get(self, "destination_data_source_settings")

    @destination_data_source_settings.setter
    def destination_data_source_settings(self, value: pulumi.Input[Sequence[pulumi.Input['DiJobDestinationDataSourceSettingArgs']]]):
        pulumi.set(self, "destination_data_source_settings", value)

    @_builtins.property
    @pulumi.getter(name="destinationDataSourceType")
    def destination_data_source_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the target data source. Enumerated values: Hologres and Hive.
        """
        return pulumi.get(self, "destination_data_source_type")

    @destination_data_source_type.setter
    def destination_data_source_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_data_source_type", value)

    @_builtins.property
    @pulumi.getter(name="jobName")
    def job_name(self) -> pulumi.Input[_builtins.str]:
        """
        Task Name.
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "job_name", value)

    @_builtins.property
    @pulumi.getter(name="migrationType")
    def migration_type(self) -> pulumi.Input[_builtins.str]:
        """
        Synchronization type, optional enumeration values are:

        Fulllandrealtimeincremental (full and real-time incremental)

        RealtimeIncremental

        Full

        Offflineincremental

        FullAndOfflineIncremental (full amount + offline increment)
        """
        return pulumi.get(self, "migration_type")

    @migration_type.setter
    def migration_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "migration_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceSettings")
    def resource_settings(self) -> pulumi.Input['DiJobResourceSettingsArgs']:
        """
        Resource Group Properties See `resource_settings` below.
        """
        return pulumi.get(self, "resource_settings")

    @resource_settings.setter
    def resource_settings(self, value: pulumi.Input['DiJobResourceSettingsArgs']):
        pulumi.set(self, "resource_settings", value)

    @_builtins.property
    @pulumi.getter(name="sourceDataSourceSettings")
    def source_data_source_settings(self) -> pulumi.Input[Sequence[pulumi.Input['DiJobSourceDataSourceSettingArgs']]]:
        """
        Source data source setting List See `source_data_source_settings` below.
        """
        return pulumi.get(self, "source_data_source_settings")

    @source_data_source_settings.setter
    def source_data_source_settings(self, value: pulumi.Input[Sequence[pulumi.Input['DiJobSourceDataSourceSettingArgs']]]):
        pulumi.set(self, "source_data_source_settings", value)

    @_builtins.property
    @pulumi.getter(name="sourceDataSourceType")
    def source_data_source_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the source data source. The enumerated value is MySQL.
        """
        return pulumi.get(self, "source_data_source_type")

    @source_data_source_type.setter
    def source_data_source_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_data_source_type", value)

    @_builtins.property
    @pulumi.getter(name="tableMappings")
    def table_mappings(self) -> pulumi.Input[Sequence[pulumi.Input['DiJobTableMappingArgs']]]:
        """
        Synchronize object transformation mapping list See `table_mappings` below.
        """
        return pulumi.get(self, "table_mappings")

    @table_mappings.setter
    def table_mappings(self, value: pulumi.Input[Sequence[pulumi.Input['DiJobTableMappingArgs']]]):
        pulumi.set(self, "table_mappings", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the integration task
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="jobSettings")
    def job_settings(self) -> Optional[pulumi.Input['DiJobJobSettingsArgs']]:
        """
        The dimension settings of the synchronization task, including the DDL processing policy, the source and destination column data type mapping policy, and the task runtime parameters. See `job_settings` below.
        """
        return pulumi.get(self, "job_settings")

    @job_settings.setter
    def job_settings(self, value: Optional[pulumi.Input['DiJobJobSettingsArgs']]):
        pulumi.set(self, "job_settings", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Project Id
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="transformationRules")
    def transformation_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiJobTransformationRuleArgs']]]]:
        """
        Definition list of synchronization object conversion rules See `transformation_rules` below.
        """
        return pulumi.get(self, "transformation_rules")

    @transformation_rules.setter
    def transformation_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiJobTransformationRuleArgs']]]]):
        pulumi.set(self, "transformation_rules", value)


@pulumi.input_type
class _DiJobState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_data_source_settings: Optional[pulumi.Input[Sequence[pulumi.Input['DiJobDestinationDataSourceSettingArgs']]]] = None,
                 destination_data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 di_job_id: Optional[pulumi.Input[_builtins.int]] = None,
                 job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 job_settings: Optional[pulumi.Input['DiJobJobSettingsArgs']] = None,
                 migration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_settings: Optional[pulumi.Input['DiJobResourceSettingsArgs']] = None,
                 source_data_source_settings: Optional[pulumi.Input[Sequence[pulumi.Input['DiJobSourceDataSourceSettingArgs']]]] = None,
                 source_data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 table_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['DiJobTableMappingArgs']]]] = None,
                 transformation_rules: Optional[pulumi.Input[Sequence[pulumi.Input['DiJobTransformationRuleArgs']]]] = None):
        """
        Input properties used for looking up and filtering DiJob resources.
        :param pulumi.Input[_builtins.str] description: Description of the integration task
        :param pulumi.Input[Sequence[pulumi.Input['DiJobDestinationDataSourceSettingArgs']]] destination_data_source_settings: Destination data source See `destination_data_source_settings` below.
        :param pulumi.Input[_builtins.str] destination_data_source_type: The type of the target data source. Enumerated values: Hologres and Hive.
        :param pulumi.Input[_builtins.int] di_job_id: Integration Task Id
        :param pulumi.Input[_builtins.str] job_name: Task Name.
        :param pulumi.Input['DiJobJobSettingsArgs'] job_settings: The dimension settings of the synchronization task, including the DDL processing policy, the source and destination column data type mapping policy, and the task runtime parameters. See `job_settings` below.
        :param pulumi.Input[_builtins.str] migration_type: Synchronization type, optional enumeration values are:
               
               Fulllandrealtimeincremental (full and real-time incremental)
               
               RealtimeIncremental
               
               Full
               
               Offflineincremental
               
               FullAndOfflineIncremental (full amount + offline increment)
        :param pulumi.Input[_builtins.int] project_id: Project Id
        :param pulumi.Input['DiJobResourceSettingsArgs'] resource_settings: Resource Group Properties See `resource_settings` below.
        :param pulumi.Input[Sequence[pulumi.Input['DiJobSourceDataSourceSettingArgs']]] source_data_source_settings: Source data source setting List See `source_data_source_settings` below.
        :param pulumi.Input[_builtins.str] source_data_source_type: The type of the source data source. The enumerated value is MySQL.
        :param pulumi.Input[Sequence[pulumi.Input['DiJobTableMappingArgs']]] table_mappings: Synchronize object transformation mapping list See `table_mappings` below.
        :param pulumi.Input[Sequence[pulumi.Input['DiJobTransformationRuleArgs']]] transformation_rules: Definition list of synchronization object conversion rules See `transformation_rules` below.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_data_source_settings is not None:
            pulumi.set(__self__, "destination_data_source_settings", destination_data_source_settings)
        if destination_data_source_type is not None:
            pulumi.set(__self__, "destination_data_source_type", destination_data_source_type)
        if di_job_id is not None:
            pulumi.set(__self__, "di_job_id", di_job_id)
        if job_name is not None:
            pulumi.set(__self__, "job_name", job_name)
        if job_settings is not None:
            pulumi.set(__self__, "job_settings", job_settings)
        if migration_type is not None:
            pulumi.set(__self__, "migration_type", migration_type)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if resource_settings is not None:
            pulumi.set(__self__, "resource_settings", resource_settings)
        if source_data_source_settings is not None:
            pulumi.set(__self__, "source_data_source_settings", source_data_source_settings)
        if source_data_source_type is not None:
            pulumi.set(__self__, "source_data_source_type", source_data_source_type)
        if table_mappings is not None:
            pulumi.set(__self__, "table_mappings", table_mappings)
        if transformation_rules is not None:
            pulumi.set(__self__, "transformation_rules", transformation_rules)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the integration task
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationDataSourceSettings")
    def destination_data_source_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiJobDestinationDataSourceSettingArgs']]]]:
        """
        Destination data source See `destination_data_source_settings` below.
        """
        return pulumi.get(self, "destination_data_source_settings")

    @destination_data_source_settings.setter
    def destination_data_source_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiJobDestinationDataSourceSettingArgs']]]]):
        pulumi.set(self, "destination_data_source_settings", value)

    @_builtins.property
    @pulumi.getter(name="destinationDataSourceType")
    def destination_data_source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the target data source. Enumerated values: Hologres and Hive.
        """
        return pulumi.get(self, "destination_data_source_type")

    @destination_data_source_type.setter
    def destination_data_source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_data_source_type", value)

    @_builtins.property
    @pulumi.getter(name="diJobId")
    def di_job_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Integration Task Id
        """
        return pulumi.get(self, "di_job_id")

    @di_job_id.setter
    def di_job_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "di_job_id", value)

    @_builtins.property
    @pulumi.getter(name="jobName")
    def job_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Task Name.
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_name", value)

    @_builtins.property
    @pulumi.getter(name="jobSettings")
    def job_settings(self) -> Optional[pulumi.Input['DiJobJobSettingsArgs']]:
        """
        The dimension settings of the synchronization task, including the DDL processing policy, the source and destination column data type mapping policy, and the task runtime parameters. See `job_settings` below.
        """
        return pulumi.get(self, "job_settings")

    @job_settings.setter
    def job_settings(self, value: Optional[pulumi.Input['DiJobJobSettingsArgs']]):
        pulumi.set(self, "job_settings", value)

    @_builtins.property
    @pulumi.getter(name="migrationType")
    def migration_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Synchronization type, optional enumeration values are:

        Fulllandrealtimeincremental (full and real-time incremental)

        RealtimeIncremental

        Full

        Offflineincremental

        FullAndOfflineIncremental (full amount + offline increment)
        """
        return pulumi.get(self, "migration_type")

    @migration_type.setter
    def migration_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "migration_type", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Project Id
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceSettings")
    def resource_settings(self) -> Optional[pulumi.Input['DiJobResourceSettingsArgs']]:
        """
        Resource Group Properties See `resource_settings` below.
        """
        return pulumi.get(self, "resource_settings")

    @resource_settings.setter
    def resource_settings(self, value: Optional[pulumi.Input['DiJobResourceSettingsArgs']]):
        pulumi.set(self, "resource_settings", value)

    @_builtins.property
    @pulumi.getter(name="sourceDataSourceSettings")
    def source_data_source_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiJobSourceDataSourceSettingArgs']]]]:
        """
        Source data source setting List See `source_data_source_settings` below.
        """
        return pulumi.get(self, "source_data_source_settings")

    @source_data_source_settings.setter
    def source_data_source_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiJobSourceDataSourceSettingArgs']]]]):
        pulumi.set(self, "source_data_source_settings", value)

    @_builtins.property
    @pulumi.getter(name="sourceDataSourceType")
    def source_data_source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the source data source. The enumerated value is MySQL.
        """
        return pulumi.get(self, "source_data_source_type")

    @source_data_source_type.setter
    def source_data_source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_data_source_type", value)

    @_builtins.property
    @pulumi.getter(name="tableMappings")
    def table_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiJobTableMappingArgs']]]]:
        """
        Synchronize object transformation mapping list See `table_mappings` below.
        """
        return pulumi.get(self, "table_mappings")

    @table_mappings.setter
    def table_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiJobTableMappingArgs']]]]):
        pulumi.set(self, "table_mappings", value)

    @_builtins.property
    @pulumi.getter(name="transformationRules")
    def transformation_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiJobTransformationRuleArgs']]]]:
        """
        Definition list of synchronization object conversion rules See `transformation_rules` below.
        """
        return pulumi.get(self, "transformation_rules")

    @transformation_rules.setter
    def transformation_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiJobTransformationRuleArgs']]]]):
        pulumi.set(self, "transformation_rules", value)


@pulumi.type_token("alicloud:dataworks/diJob:DiJob")
class DiJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_data_source_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiJobDestinationDataSourceSettingArgs', 'DiJobDestinationDataSourceSettingArgsDict']]]]] = None,
                 destination_data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 job_settings: Optional[pulumi.Input[Union['DiJobJobSettingsArgs', 'DiJobJobSettingsArgsDict']]] = None,
                 migration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_settings: Optional[pulumi.Input[Union['DiJobResourceSettingsArgs', 'DiJobResourceSettingsArgsDict']]] = None,
                 source_data_source_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiJobSourceDataSourceSettingArgs', 'DiJobSourceDataSourceSettingArgsDict']]]]] = None,
                 source_data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 table_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiJobTableMappingArgs', 'DiJobTableMappingArgsDict']]]]] = None,
                 transformation_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiJobTransformationRuleArgs', 'DiJobTransformationRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Data Works Di Job resource.

        Data Integration Tasks.

        For information about Data Works Di Job and how to use it, see [What is Di Job](https://www.alibabacloud.com/help/en/dataworks/developer-reference/api-dataworks-public-2024-05-18-createdijob).

        > **NOTE:** Available since v1.241.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default_mmhl8_u = alicloud.dataworks.Project("defaultMMHL8U",
            project_name=name,
            display_name=name,
            description=name,
            pai_task_enabled=True)
        default = alicloud.dataworks.DiJob("default",
            description=name,
            project_id=default_mmhl8_u.id,
            job_name="zhenyuan_example_case",
            migration_type="api_FullAndRealtimeIncremental",
            source_data_source_settings=[{
                "data_source_name": "dw_mysql",
                "data_source_properties": {
                    "encoding": "utf-8",
                    "timezone": "Asia/Shanghai",
                },
            }],
            destination_data_source_type="Hologres",
            table_mappings=[{
                "source_object_selection_rules": [
                    {
                        "action": "Include",
                        "expression": "dw_mysql",
                        "expression_type": "Exact",
                        "object_type": "Datasource",
                    },
                    {
                        "action": "Include",
                        "expression": "example_db1",
                        "expression_type": "Exact",
                        "object_type": "Database",
                    },
                    {
                        "action": "Include",
                        "expression": "lsc_example01",
                        "expression_type": "Exact",
                        "object_type": "Table",
                    },
                ],
                "transformation_rules": [{
                    "rule_name": "my_table_rename_rule",
                    "rule_action_type": "Rename",
                    "rule_target_type": "Table",
                }],
            }],
            source_data_source_type="MySQL",
            resource_settings={
                "offline_resource_settings": {
                    "requested_cu": 2,
                    "resource_group_identifier": "S_res_group_524257424564736_1716799673667",
                },
                "realtime_resource_settings": {
                    "requested_cu": 2,
                    "resource_group_identifier": "S_res_group_524257424564736_1716799673667",
                },
                "schedule_resource_settings": {
                    "requested_cu": 2,
                    "resource_group_identifier": "S_res_group_524257424564736_1716799673667",
                },
            },
            transformation_rules=[{
                "rule_action_type": "Rename",
                "rule_expression": "{\\"expression\\":\\"table2\\"}",
                "rule_name": "my_table_rename_rule",
                "rule_target_type": "Table",
            }],
            destination_data_source_settings=[{
                "data_source_name": "dw_example_holo",
            }],
            job_settings={
                "column_data_type_settings": [{
                    "destination_data_type": "bigint",
                    "source_data_type": "longtext",
                }],
                "ddl_handling_settings": [{
                    "action": "Ignore",
                    "type": "CreateTable",
                }],
                "runtime_settings": [{
                    "name": "runtime.realtime.concurrent",
                    "value": "1",
                }],
                "channel_settings": "1",
                "cycle_schedule_settings": {
                    "cycle_migration_type": "2",
                    "schedule_parameters": "3",
                },
            })
        ```

        ## Import

        Data Works Di Job can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dataworks/diJob:DiJob example <project_id>:<di_job_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the integration task
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiJobDestinationDataSourceSettingArgs', 'DiJobDestinationDataSourceSettingArgsDict']]]] destination_data_source_settings: Destination data source See `destination_data_source_settings` below.
        :param pulumi.Input[_builtins.str] destination_data_source_type: The type of the target data source. Enumerated values: Hologres and Hive.
        :param pulumi.Input[_builtins.str] job_name: Task Name.
        :param pulumi.Input[Union['DiJobJobSettingsArgs', 'DiJobJobSettingsArgsDict']] job_settings: The dimension settings of the synchronization task, including the DDL processing policy, the source and destination column data type mapping policy, and the task runtime parameters. See `job_settings` below.
        :param pulumi.Input[_builtins.str] migration_type: Synchronization type, optional enumeration values are:
               
               Fulllandrealtimeincremental (full and real-time incremental)
               
               RealtimeIncremental
               
               Full
               
               Offflineincremental
               
               FullAndOfflineIncremental (full amount + offline increment)
        :param pulumi.Input[_builtins.int] project_id: Project Id
        :param pulumi.Input[Union['DiJobResourceSettingsArgs', 'DiJobResourceSettingsArgsDict']] resource_settings: Resource Group Properties See `resource_settings` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiJobSourceDataSourceSettingArgs', 'DiJobSourceDataSourceSettingArgsDict']]]] source_data_source_settings: Source data source setting List See `source_data_source_settings` below.
        :param pulumi.Input[_builtins.str] source_data_source_type: The type of the source data source. The enumerated value is MySQL.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiJobTableMappingArgs', 'DiJobTableMappingArgsDict']]]] table_mappings: Synchronize object transformation mapping list See `table_mappings` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiJobTransformationRuleArgs', 'DiJobTransformationRuleArgsDict']]]] transformation_rules: Definition list of synchronization object conversion rules See `transformation_rules` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DiJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Data Works Di Job resource.

        Data Integration Tasks.

        For information about Data Works Di Job and how to use it, see [What is Di Job](https://www.alibabacloud.com/help/en/dataworks/developer-reference/api-dataworks-public-2024-05-18-createdijob).

        > **NOTE:** Available since v1.241.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default_mmhl8_u = alicloud.dataworks.Project("defaultMMHL8U",
            project_name=name,
            display_name=name,
            description=name,
            pai_task_enabled=True)
        default = alicloud.dataworks.DiJob("default",
            description=name,
            project_id=default_mmhl8_u.id,
            job_name="zhenyuan_example_case",
            migration_type="api_FullAndRealtimeIncremental",
            source_data_source_settings=[{
                "data_source_name": "dw_mysql",
                "data_source_properties": {
                    "encoding": "utf-8",
                    "timezone": "Asia/Shanghai",
                },
            }],
            destination_data_source_type="Hologres",
            table_mappings=[{
                "source_object_selection_rules": [
                    {
                        "action": "Include",
                        "expression": "dw_mysql",
                        "expression_type": "Exact",
                        "object_type": "Datasource",
                    },
                    {
                        "action": "Include",
                        "expression": "example_db1",
                        "expression_type": "Exact",
                        "object_type": "Database",
                    },
                    {
                        "action": "Include",
                        "expression": "lsc_example01",
                        "expression_type": "Exact",
                        "object_type": "Table",
                    },
                ],
                "transformation_rules": [{
                    "rule_name": "my_table_rename_rule",
                    "rule_action_type": "Rename",
                    "rule_target_type": "Table",
                }],
            }],
            source_data_source_type="MySQL",
            resource_settings={
                "offline_resource_settings": {
                    "requested_cu": 2,
                    "resource_group_identifier": "S_res_group_524257424564736_1716799673667",
                },
                "realtime_resource_settings": {
                    "requested_cu": 2,
                    "resource_group_identifier": "S_res_group_524257424564736_1716799673667",
                },
                "schedule_resource_settings": {
                    "requested_cu": 2,
                    "resource_group_identifier": "S_res_group_524257424564736_1716799673667",
                },
            },
            transformation_rules=[{
                "rule_action_type": "Rename",
                "rule_expression": "{\\"expression\\":\\"table2\\"}",
                "rule_name": "my_table_rename_rule",
                "rule_target_type": "Table",
            }],
            destination_data_source_settings=[{
                "data_source_name": "dw_example_holo",
            }],
            job_settings={
                "column_data_type_settings": [{
                    "destination_data_type": "bigint",
                    "source_data_type": "longtext",
                }],
                "ddl_handling_settings": [{
                    "action": "Ignore",
                    "type": "CreateTable",
                }],
                "runtime_settings": [{
                    "name": "runtime.realtime.concurrent",
                    "value": "1",
                }],
                "channel_settings": "1",
                "cycle_schedule_settings": {
                    "cycle_migration_type": "2",
                    "schedule_parameters": "3",
                },
            })
        ```

        ## Import

        Data Works Di Job can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dataworks/diJob:DiJob example <project_id>:<di_job_id>
        ```

        :param str resource_name: The name of the resource.
        :param DiJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_data_source_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiJobDestinationDataSourceSettingArgs', 'DiJobDestinationDataSourceSettingArgsDict']]]]] = None,
                 destination_data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 job_settings: Optional[pulumi.Input[Union['DiJobJobSettingsArgs', 'DiJobJobSettingsArgsDict']]] = None,
                 migration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_settings: Optional[pulumi.Input[Union['DiJobResourceSettingsArgs', 'DiJobResourceSettingsArgsDict']]] = None,
                 source_data_source_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiJobSourceDataSourceSettingArgs', 'DiJobSourceDataSourceSettingArgsDict']]]]] = None,
                 source_data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 table_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiJobTableMappingArgs', 'DiJobTableMappingArgsDict']]]]] = None,
                 transformation_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiJobTransformationRuleArgs', 'DiJobTransformationRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiJobArgs.__new__(DiJobArgs)

            __props__.__dict__["description"] = description
            if destination_data_source_settings is None and not opts.urn:
                raise TypeError("Missing required property 'destination_data_source_settings'")
            __props__.__dict__["destination_data_source_settings"] = destination_data_source_settings
            if destination_data_source_type is None and not opts.urn:
                raise TypeError("Missing required property 'destination_data_source_type'")
            __props__.__dict__["destination_data_source_type"] = destination_data_source_type
            if job_name is None and not opts.urn:
                raise TypeError("Missing required property 'job_name'")
            __props__.__dict__["job_name"] = job_name
            __props__.__dict__["job_settings"] = job_settings
            if migration_type is None and not opts.urn:
                raise TypeError("Missing required property 'migration_type'")
            __props__.__dict__["migration_type"] = migration_type
            __props__.__dict__["project_id"] = project_id
            if resource_settings is None and not opts.urn:
                raise TypeError("Missing required property 'resource_settings'")
            __props__.__dict__["resource_settings"] = resource_settings
            if source_data_source_settings is None and not opts.urn:
                raise TypeError("Missing required property 'source_data_source_settings'")
            __props__.__dict__["source_data_source_settings"] = source_data_source_settings
            if source_data_source_type is None and not opts.urn:
                raise TypeError("Missing required property 'source_data_source_type'")
            __props__.__dict__["source_data_source_type"] = source_data_source_type
            if table_mappings is None and not opts.urn:
                raise TypeError("Missing required property 'table_mappings'")
            __props__.__dict__["table_mappings"] = table_mappings
            __props__.__dict__["transformation_rules"] = transformation_rules
            __props__.__dict__["di_job_id"] = None
        super(DiJob, __self__).__init__(
            'alicloud:dataworks/diJob:DiJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_data_source_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiJobDestinationDataSourceSettingArgs', 'DiJobDestinationDataSourceSettingArgsDict']]]]] = None,
            destination_data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
            di_job_id: Optional[pulumi.Input[_builtins.int]] = None,
            job_name: Optional[pulumi.Input[_builtins.str]] = None,
            job_settings: Optional[pulumi.Input[Union['DiJobJobSettingsArgs', 'DiJobJobSettingsArgsDict']]] = None,
            migration_type: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.int]] = None,
            resource_settings: Optional[pulumi.Input[Union['DiJobResourceSettingsArgs', 'DiJobResourceSettingsArgsDict']]] = None,
            source_data_source_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiJobSourceDataSourceSettingArgs', 'DiJobSourceDataSourceSettingArgsDict']]]]] = None,
            source_data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
            table_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiJobTableMappingArgs', 'DiJobTableMappingArgsDict']]]]] = None,
            transformation_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiJobTransformationRuleArgs', 'DiJobTransformationRuleArgsDict']]]]] = None) -> 'DiJob':
        """
        Get an existing DiJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the integration task
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiJobDestinationDataSourceSettingArgs', 'DiJobDestinationDataSourceSettingArgsDict']]]] destination_data_source_settings: Destination data source See `destination_data_source_settings` below.
        :param pulumi.Input[_builtins.str] destination_data_source_type: The type of the target data source. Enumerated values: Hologres and Hive.
        :param pulumi.Input[_builtins.int] di_job_id: Integration Task Id
        :param pulumi.Input[_builtins.str] job_name: Task Name.
        :param pulumi.Input[Union['DiJobJobSettingsArgs', 'DiJobJobSettingsArgsDict']] job_settings: The dimension settings of the synchronization task, including the DDL processing policy, the source and destination column data type mapping policy, and the task runtime parameters. See `job_settings` below.
        :param pulumi.Input[_builtins.str] migration_type: Synchronization type, optional enumeration values are:
               
               Fulllandrealtimeincremental (full and real-time incremental)
               
               RealtimeIncremental
               
               Full
               
               Offflineincremental
               
               FullAndOfflineIncremental (full amount + offline increment)
        :param pulumi.Input[_builtins.int] project_id: Project Id
        :param pulumi.Input[Union['DiJobResourceSettingsArgs', 'DiJobResourceSettingsArgsDict']] resource_settings: Resource Group Properties See `resource_settings` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiJobSourceDataSourceSettingArgs', 'DiJobSourceDataSourceSettingArgsDict']]]] source_data_source_settings: Source data source setting List See `source_data_source_settings` below.
        :param pulumi.Input[_builtins.str] source_data_source_type: The type of the source data source. The enumerated value is MySQL.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiJobTableMappingArgs', 'DiJobTableMappingArgsDict']]]] table_mappings: Synchronize object transformation mapping list See `table_mappings` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiJobTransformationRuleArgs', 'DiJobTransformationRuleArgsDict']]]] transformation_rules: Definition list of synchronization object conversion rules See `transformation_rules` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiJobState.__new__(_DiJobState)

        __props__.__dict__["description"] = description
        __props__.__dict__["destination_data_source_settings"] = destination_data_source_settings
        __props__.__dict__["destination_data_source_type"] = destination_data_source_type
        __props__.__dict__["di_job_id"] = di_job_id
        __props__.__dict__["job_name"] = job_name
        __props__.__dict__["job_settings"] = job_settings
        __props__.__dict__["migration_type"] = migration_type
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["resource_settings"] = resource_settings
        __props__.__dict__["source_data_source_settings"] = source_data_source_settings
        __props__.__dict__["source_data_source_type"] = source_data_source_type
        __props__.__dict__["table_mappings"] = table_mappings
        __props__.__dict__["transformation_rules"] = transformation_rules
        return DiJob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the integration task
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationDataSourceSettings")
    def destination_data_source_settings(self) -> pulumi.Output[Sequence['outputs.DiJobDestinationDataSourceSetting']]:
        """
        Destination data source See `destination_data_source_settings` below.
        """
        return pulumi.get(self, "destination_data_source_settings")

    @_builtins.property
    @pulumi.getter(name="destinationDataSourceType")
    def destination_data_source_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the target data source. Enumerated values: Hologres and Hive.
        """
        return pulumi.get(self, "destination_data_source_type")

    @_builtins.property
    @pulumi.getter(name="diJobId")
    def di_job_id(self) -> pulumi.Output[_builtins.int]:
        """
        Integration Task Id
        """
        return pulumi.get(self, "di_job_id")

    @_builtins.property
    @pulumi.getter(name="jobName")
    def job_name(self) -> pulumi.Output[_builtins.str]:
        """
        Task Name.
        """
        return pulumi.get(self, "job_name")

    @_builtins.property
    @pulumi.getter(name="jobSettings")
    def job_settings(self) -> pulumi.Output[Optional['outputs.DiJobJobSettings']]:
        """
        The dimension settings of the synchronization task, including the DDL processing policy, the source and destination column data type mapping policy, and the task runtime parameters. See `job_settings` below.
        """
        return pulumi.get(self, "job_settings")

    @_builtins.property
    @pulumi.getter(name="migrationType")
    def migration_type(self) -> pulumi.Output[_builtins.str]:
        """
        Synchronization type, optional enumeration values are:

        Fulllandrealtimeincremental (full and real-time incremental)

        RealtimeIncremental

        Full

        Offflineincremental

        FullAndOfflineIncremental (full amount + offline increment)
        """
        return pulumi.get(self, "migration_type")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.int]:
        """
        Project Id
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="resourceSettings")
    def resource_settings(self) -> pulumi.Output['outputs.DiJobResourceSettings']:
        """
        Resource Group Properties See `resource_settings` below.
        """
        return pulumi.get(self, "resource_settings")

    @_builtins.property
    @pulumi.getter(name="sourceDataSourceSettings")
    def source_data_source_settings(self) -> pulumi.Output[Sequence['outputs.DiJobSourceDataSourceSetting']]:
        """
        Source data source setting List See `source_data_source_settings` below.
        """
        return pulumi.get(self, "source_data_source_settings")

    @_builtins.property
    @pulumi.getter(name="sourceDataSourceType")
    def source_data_source_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the source data source. The enumerated value is MySQL.
        """
        return pulumi.get(self, "source_data_source_type")

    @_builtins.property
    @pulumi.getter(name="tableMappings")
    def table_mappings(self) -> pulumi.Output[Sequence['outputs.DiJobTableMapping']]:
        """
        Synchronize object transformation mapping list See `table_mappings` below.
        """
        return pulumi.get(self, "table_mappings")

    @_builtins.property
    @pulumi.getter(name="transformationRules")
    def transformation_rules(self) -> pulumi.Output[Optional[Sequence['outputs.DiJobTransformationRule']]]:
        """
        Definition list of synchronization object conversion rules See `transformation_rules` below.
        """
        return pulumi.get(self, "transformation_rules")

