# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectMemberArgs', 'ProjectMember']

@pulumi.input_type
class ProjectMemberArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.int],
                 user_id: pulumi.Input[_builtins.str],
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectMemberRoleArgs']]]] = None):
        """
        The set of arguments for constructing a ProjectMember resource.
        :param pulumi.Input[_builtins.int] project_id: Project ID
        :param pulumi.Input[_builtins.str] user_id: The user ID of the member.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectMemberRoleArgs']]] roles: List of roles owned by members. See `roles` below.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "user_id", user_id)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.int]:
        """
        Project ID
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[_builtins.str]:
        """
        The user ID of the member.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectMemberRoleArgs']]]]:
        """
        List of roles owned by members. See `roles` below.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectMemberRoleArgs']]]]):
        pulumi.set(self, "roles", value)


@pulumi.input_type
class _ProjectMemberState:
    def __init__(__self__, *,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectMemberRoleArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProjectMember resources.
        :param pulumi.Input[_builtins.int] project_id: Project ID
        :param pulumi.Input[Sequence[pulumi.Input['ProjectMemberRoleArgs']]] roles: List of roles owned by members. See `roles` below.
        :param pulumi.Input[_builtins.str] status: The status of the user in project
        :param pulumi.Input[_builtins.str] user_id: The user ID of the member.
        """
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Project ID
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectMemberRoleArgs']]]]:
        """
        List of roles owned by members. See `roles` below.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectMemberRoleArgs']]]]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the user in project
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user ID of the member.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("alicloud:dataworks/projectMember:ProjectMember")
class ProjectMember(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectMemberRoleArgs', 'ProjectMemberRoleArgsDict']]]]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Data Works Project Member resource.

        For information about Data Works Project Member and how to use it, see [What is Project Member](https://www.alibabacloud.com/help/en/dataworks/developer-reference/api-dataworks-public-2024-05-18-createprojectmember).

        > **NOTE:** Available since v1.237.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        admin_code = config.get("adminCode")
        if admin_code is None:
            admin_code = "role_project_admin"
        name = config.get("name")
        if name is None:
            name = "tf_example"
        randint = random.index.Integer("randint",
            max=999,
            min=1)
        default_kc_tr_b2 = alicloud.ram.User("defaultKCTrB2",
            display_name=f"{name}{randint['id']}",
            name=f"{name}{randint['id']}")
        default = alicloud.resourcemanager.get_resource_groups()
        default_qe_rfv_u = alicloud.dataworks.Project("defaultQeRfvU",
            status="Available",
            description="tf_desc",
            project_name=f"{name}{randint['id']}",
            pai_task_enabled=False,
            display_name="tf_new_api_display",
            dev_role_disabled=True,
            dev_environment_enabled=False,
            resource_group_id=default.ids[0])
        default_project_member = alicloud.dataworks.ProjectMember("default",
            user_id=default_kc_tr_b2.id,
            project_id=default_qe_rfv_u.id,
            roles=[{
                "code": admin_code,
            }])
        ```

        ## Import

        Data Works Project Member can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dataworks/projectMember:ProjectMember example <project_id>:<user_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] project_id: Project ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectMemberRoleArgs', 'ProjectMemberRoleArgsDict']]]] roles: List of roles owned by members. See `roles` below.
        :param pulumi.Input[_builtins.str] user_id: The user ID of the member.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectMemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Data Works Project Member resource.

        For information about Data Works Project Member and how to use it, see [What is Project Member](https://www.alibabacloud.com/help/en/dataworks/developer-reference/api-dataworks-public-2024-05-18-createprojectmember).

        > **NOTE:** Available since v1.237.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        admin_code = config.get("adminCode")
        if admin_code is None:
            admin_code = "role_project_admin"
        name = config.get("name")
        if name is None:
            name = "tf_example"
        randint = random.index.Integer("randint",
            max=999,
            min=1)
        default_kc_tr_b2 = alicloud.ram.User("defaultKCTrB2",
            display_name=f"{name}{randint['id']}",
            name=f"{name}{randint['id']}")
        default = alicloud.resourcemanager.get_resource_groups()
        default_qe_rfv_u = alicloud.dataworks.Project("defaultQeRfvU",
            status="Available",
            description="tf_desc",
            project_name=f"{name}{randint['id']}",
            pai_task_enabled=False,
            display_name="tf_new_api_display",
            dev_role_disabled=True,
            dev_environment_enabled=False,
            resource_group_id=default.ids[0])
        default_project_member = alicloud.dataworks.ProjectMember("default",
            user_id=default_kc_tr_b2.id,
            project_id=default_qe_rfv_u.id,
            roles=[{
                "code": admin_code,
            }])
        ```

        ## Import

        Data Works Project Member can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dataworks/projectMember:ProjectMember example <project_id>:<user_id>
        ```

        :param str resource_name: The name of the resource.
        :param ProjectMemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectMemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectMemberRoleArgs', 'ProjectMemberRoleArgsDict']]]]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectMemberArgs.__new__(ProjectMemberArgs)

            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["roles"] = roles
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["status"] = None
        super(ProjectMember, __self__).__init__(
            'alicloud:dataworks/projectMember:ProjectMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            project_id: Optional[pulumi.Input[_builtins.int]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectMemberRoleArgs', 'ProjectMemberRoleArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProjectMember':
        """
        Get an existing ProjectMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] project_id: Project ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectMemberRoleArgs', 'ProjectMemberRoleArgsDict']]]] roles: List of roles owned by members. See `roles` below.
        :param pulumi.Input[_builtins.str] status: The status of the user in project
        :param pulumi.Input[_builtins.str] user_id: The user ID of the member.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectMemberState.__new__(_ProjectMemberState)

        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["roles"] = roles
        __props__.__dict__["status"] = status
        __props__.__dict__["user_id"] = user_id
        return ProjectMember(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.int]:
        """
        Project ID
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectMemberRole']]]:
        """
        List of roles owned by members. See `roles` below.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the user in project
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.str]:
        """
        The user ID of the member.
        """
        return pulumi.get(self, "user_id")

