# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainResourceArgs', 'DomainResource']

@pulumi.input_type
class DomainResourceArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[_builtins.str],
                 instance_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 proxy_types: pulumi.Input[Sequence[pulumi.Input['DomainResourceProxyTypeArgs']]],
                 real_servers: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 rs_type: pulumi.Input[_builtins.int],
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_region: Optional[pulumi.Input[_builtins.str]] = None,
                 https_ext: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a DomainResource resource.
        :param pulumi.Input[_builtins.str] domain: The domain name for which you want to configure the Static Page Caching policy.
               
               > **NOTE:**  You can call the [DescribeDomains](https://www.alibabacloud.com/help/en/doc-detail/91724.html) operation to query all the domain names that are added to Anti-DDoS Pro or Anti-DDoS Premium.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_ids: InstanceIds
        :param pulumi.Input[Sequence[pulumi.Input['DomainResourceProxyTypeArgs']]] proxy_types: Protocol type and port number information. See `proxy_types` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] real_servers: Server address information of the source station.
        :param pulumi.Input[_builtins.int] rs_type: The address type of the origin server. Valid values:
        :param pulumi.Input[_builtins.str] cert: The private key of the certificate that you want to associate. This parameter must be used together with the CertName and Cert parameters.
               
               > **NOTE:**   If you specify a value for the CertName, Cert, and Key parameters, you do not need to specify a value for the CertId parameter.
        :param pulumi.Input[_builtins.str] cert_identifier: The name of the certificate.
               
               > **NOTE:**   You can specify the name of the certificate that you want to associate. From version 1.249.0, `cert_identifier` is in the "CertificateID-RegionId" format. For example, if the ID of the certificateId is `123`, and the region ID is `cn-hangzhou`, the value of the `cert_identifier` is `123-cn-hangzhou`.
        :param pulumi.Input[_builtins.str] cert_name: The public key of the certificate that you want to associate. This parameter must be used together with the CertName and Key parameters.
               
               > **NOTE:**   If you specify a value for the CertName, Cert, and Key parameters, you do not need to specify a value for the CertId parameter.
        :param pulumi.Input[_builtins.str] cert_region: The region of the certificate. `cn-hangzhou` and `ap-southeast-1` are supported. The default value is `cn-hangzhou`.
        :param pulumi.Input[_builtins.str] https_ext: The advanced HTTPS settings. This parameter takes effect only when the value of the `ProxyType` parameter includes `https`. The value is a string that consists of a JSON struct. The JSON struct contains the following fields:
               
               - `Http2https`: specifies whether to turn on Enforce HTTPS Routing. This field is optional and must be an integer. Valid values: `0` and `1`. The value 0 indicates that Enforce HTTPS Routing is turned off. The value 1 indicates that Enforce HTTPS Routing is turned on. The default value is 0.
               
               If your website supports both HTTP and HTTPS, this feature meets your business requirements. If you enable this feature, all HTTP requests to access the website are redirected to HTTPS requests on the standard port 443.
               
               - `Https2http`: specifies whether to turn on Enable HTTP. This field is optional and must be an integer. Valid values: `0` and `1`. The value 0 indicates that Enable HTTP is turned off. The value 1 indicates that Enable HTTP is turned on. The default value is 0.
               
               If your website does not support HTTPS, this feature meets your business requirements If this feature is enabled, all HTTPS requests are redirected to HTTP requests and forwarded to origin servers. This feature can redirect WebSockets requests to WebSocket requests. Requests are redirected over the standard port 80.
               
               - `Http2`: specifies whether to turn on Enable HTTP/2. This field is optional. Data type: integer. Valid values: `0` and `1`. The value 0 indicates that Enable HTTP/2 is turned off. The value 1 indicates that Enable HTTP/2 is turned on. The default value is 0.
               
               After you turn on the switch, HTTP/2 is used.
        :param pulumi.Input[_builtins.str] key: The globally unique ID of the certificate. The value is in the "Certificate ID-cn-hangzhou" format. For example, if the ID of the certificate is 123, the value of the CertIdentifier parameter is 123-cn-hangzhou.
               
               > **NOTE:**   You can specify only one of this parameter and the CertId parameter.
        :param pulumi.Input[_builtins.bool] ocsp_enabled: Specifies whether to enable the OCSP feature. Valid values:
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "instance_ids", instance_ids)
        pulumi.set(__self__, "proxy_types", proxy_types)
        pulumi.set(__self__, "real_servers", real_servers)
        pulumi.set(__self__, "rs_type", rs_type)
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if cert_identifier is not None:
            pulumi.set(__self__, "cert_identifier", cert_identifier)
        if cert_name is not None:
            pulumi.set(__self__, "cert_name", cert_name)
        if cert_region is not None:
            pulumi.set(__self__, "cert_region", cert_region)
        if https_ext is not None:
            pulumi.set(__self__, "https_ext", https_ext)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if ocsp_enabled is not None:
            pulumi.set(__self__, "ocsp_enabled", ocsp_enabled)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        The domain name for which you want to configure the Static Page Caching policy.

        > **NOTE:**  You can call the [DescribeDomains](https://www.alibabacloud.com/help/en/doc-detail/91724.html) operation to query all the domain names that are added to Anti-DDoS Pro or Anti-DDoS Premium.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        InstanceIds
        """
        return pulumi.get(self, "instance_ids")

    @instance_ids.setter
    def instance_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "instance_ids", value)

    @_builtins.property
    @pulumi.getter(name="proxyTypes")
    def proxy_types(self) -> pulumi.Input[Sequence[pulumi.Input['DomainResourceProxyTypeArgs']]]:
        """
        Protocol type and port number information. See `proxy_types` below.
        """
        return pulumi.get(self, "proxy_types")

    @proxy_types.setter
    def proxy_types(self, value: pulumi.Input[Sequence[pulumi.Input['DomainResourceProxyTypeArgs']]]):
        pulumi.set(self, "proxy_types", value)

    @_builtins.property
    @pulumi.getter(name="realServers")
    def real_servers(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Server address information of the source station.
        """
        return pulumi.get(self, "real_servers")

    @real_servers.setter
    def real_servers(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "real_servers", value)

    @_builtins.property
    @pulumi.getter(name="rsType")
    def rs_type(self) -> pulumi.Input[_builtins.int]:
        """
        The address type of the origin server. Valid values:
        """
        return pulumi.get(self, "rs_type")

    @rs_type.setter
    def rs_type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "rs_type", value)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key of the certificate that you want to associate. This parameter must be used together with the CertName and Cert parameters.

        > **NOTE:**   If you specify a value for the CertName, Cert, and Key parameters, you do not need to specify a value for the CertId parameter.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert", value)

    @_builtins.property
    @pulumi.getter(name="certIdentifier")
    def cert_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the certificate.

        > **NOTE:**   You can specify the name of the certificate that you want to associate. From version 1.249.0, `cert_identifier` is in the "CertificateID-RegionId" format. For example, if the ID of the certificateId is `123`, and the region ID is `cn-hangzhou`, the value of the `cert_identifier` is `123-cn-hangzhou`.
        """
        return pulumi.get(self, "cert_identifier")

    @cert_identifier.setter
    def cert_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_identifier", value)

    @_builtins.property
    @pulumi.getter(name="certName")
    def cert_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public key of the certificate that you want to associate. This parameter must be used together with the CertName and Key parameters.

        > **NOTE:**   If you specify a value for the CertName, Cert, and Key parameters, you do not need to specify a value for the CertId parameter.
        """
        return pulumi.get(self, "cert_name")

    @cert_name.setter
    def cert_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_name", value)

    @_builtins.property
    @pulumi.getter(name="certRegion")
    def cert_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the certificate. `cn-hangzhou` and `ap-southeast-1` are supported. The default value is `cn-hangzhou`.
        """
        return pulumi.get(self, "cert_region")

    @cert_region.setter
    def cert_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_region", value)

    @_builtins.property
    @pulumi.getter(name="httpsExt")
    def https_ext(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The advanced HTTPS settings. This parameter takes effect only when the value of the `ProxyType` parameter includes `https`. The value is a string that consists of a JSON struct. The JSON struct contains the following fields:

        - `Http2https`: specifies whether to turn on Enforce HTTPS Routing. This field is optional and must be an integer. Valid values: `0` and `1`. The value 0 indicates that Enforce HTTPS Routing is turned off. The value 1 indicates that Enforce HTTPS Routing is turned on. The default value is 0.

        If your website supports both HTTP and HTTPS, this feature meets your business requirements. If you enable this feature, all HTTP requests to access the website are redirected to HTTPS requests on the standard port 443.

        - `Https2http`: specifies whether to turn on Enable HTTP. This field is optional and must be an integer. Valid values: `0` and `1`. The value 0 indicates that Enable HTTP is turned off. The value 1 indicates that Enable HTTP is turned on. The default value is 0.

        If your website does not support HTTPS, this feature meets your business requirements If this feature is enabled, all HTTPS requests are redirected to HTTP requests and forwarded to origin servers. This feature can redirect WebSockets requests to WebSocket requests. Requests are redirected over the standard port 80.

        - `Http2`: specifies whether to turn on Enable HTTP/2. This field is optional. Data type: integer. Valid values: `0` and `1`. The value 0 indicates that Enable HTTP/2 is turned off. The value 1 indicates that Enable HTTP/2 is turned on. The default value is 0.

        After you turn on the switch, HTTP/2 is used.
        """
        return pulumi.get(self, "https_ext")

    @https_ext.setter
    def https_ext(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https_ext", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The globally unique ID of the certificate. The value is in the "Certificate ID-cn-hangzhou" format. For example, if the ID of the certificate is 123, the value of the CertIdentifier parameter is 123-cn-hangzhou.

        > **NOTE:**   You can specify only one of this parameter and the CertId parameter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="ocspEnabled")
    def ocsp_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the OCSP feature. Valid values:
        """
        return pulumi.get(self, "ocsp_enabled")

    @ocsp_enabled.setter
    def ocsp_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ocsp_enabled", value)


@pulumi.input_type
class _DomainResourceState:
    def __init__(__self__, *,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_region: Optional[pulumi.Input[_builtins.str]] = None,
                 cname: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 https_ext: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 proxy_types: Optional[pulumi.Input[Sequence[pulumi.Input['DomainResourceProxyTypeArgs']]]] = None,
                 real_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rs_type: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering DomainResource resources.
        :param pulumi.Input[_builtins.str] cert: The private key of the certificate that you want to associate. This parameter must be used together with the CertName and Cert parameters.
               
               > **NOTE:**   If you specify a value for the CertName, Cert, and Key parameters, you do not need to specify a value for the CertId parameter.
        :param pulumi.Input[_builtins.str] cert_identifier: The name of the certificate.
               
               > **NOTE:**   You can specify the name of the certificate that you want to associate. From version 1.249.0, `cert_identifier` is in the "CertificateID-RegionId" format. For example, if the ID of the certificateId is `123`, and the region ID is `cn-hangzhou`, the value of the `cert_identifier` is `123-cn-hangzhou`.
        :param pulumi.Input[_builtins.str] cert_name: The public key of the certificate that you want to associate. This parameter must be used together with the CertName and Key parameters.
               
               > **NOTE:**   If you specify a value for the CertName, Cert, and Key parameters, you do not need to specify a value for the CertId parameter.
        :param pulumi.Input[_builtins.str] cert_region: The region of the certificate. `cn-hangzhou` and `ap-southeast-1` are supported. The default value is `cn-hangzhou`.
        :param pulumi.Input[_builtins.str] cname: The CNAME address to query.
        :param pulumi.Input[_builtins.str] domain: The domain name for which you want to configure the Static Page Caching policy.
               
               > **NOTE:**  You can call the [DescribeDomains](https://www.alibabacloud.com/help/en/doc-detail/91724.html) operation to query all the domain names that are added to Anti-DDoS Pro or Anti-DDoS Premium.
        :param pulumi.Input[_builtins.str] https_ext: The advanced HTTPS settings. This parameter takes effect only when the value of the `ProxyType` parameter includes `https`. The value is a string that consists of a JSON struct. The JSON struct contains the following fields:
               
               - `Http2https`: specifies whether to turn on Enforce HTTPS Routing. This field is optional and must be an integer. Valid values: `0` and `1`. The value 0 indicates that Enforce HTTPS Routing is turned off. The value 1 indicates that Enforce HTTPS Routing is turned on. The default value is 0.
               
               If your website supports both HTTP and HTTPS, this feature meets your business requirements. If you enable this feature, all HTTP requests to access the website are redirected to HTTPS requests on the standard port 443.
               
               - `Https2http`: specifies whether to turn on Enable HTTP. This field is optional and must be an integer. Valid values: `0` and `1`. The value 0 indicates that Enable HTTP is turned off. The value 1 indicates that Enable HTTP is turned on. The default value is 0.
               
               If your website does not support HTTPS, this feature meets your business requirements If this feature is enabled, all HTTPS requests are redirected to HTTP requests and forwarded to origin servers. This feature can redirect WebSockets requests to WebSocket requests. Requests are redirected over the standard port 80.
               
               - `Http2`: specifies whether to turn on Enable HTTP/2. This field is optional. Data type: integer. Valid values: `0` and `1`. The value 0 indicates that Enable HTTP/2 is turned off. The value 1 indicates that Enable HTTP/2 is turned on. The default value is 0.
               
               After you turn on the switch, HTTP/2 is used.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_ids: InstanceIds
        :param pulumi.Input[_builtins.str] key: The globally unique ID of the certificate. The value is in the "Certificate ID-cn-hangzhou" format. For example, if the ID of the certificate is 123, the value of the CertIdentifier parameter is 123-cn-hangzhou.
               
               > **NOTE:**   You can specify only one of this parameter and the CertId parameter.
        :param pulumi.Input[_builtins.bool] ocsp_enabled: Specifies whether to enable the OCSP feature. Valid values:
        :param pulumi.Input[Sequence[pulumi.Input['DomainResourceProxyTypeArgs']]] proxy_types: Protocol type and port number information. See `proxy_types` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] real_servers: Server address information of the source station.
        :param pulumi.Input[_builtins.int] rs_type: The address type of the origin server. Valid values:
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if cert_identifier is not None:
            pulumi.set(__self__, "cert_identifier", cert_identifier)
        if cert_name is not None:
            pulumi.set(__self__, "cert_name", cert_name)
        if cert_region is not None:
            pulumi.set(__self__, "cert_region", cert_region)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if https_ext is not None:
            pulumi.set(__self__, "https_ext", https_ext)
        if instance_ids is not None:
            pulumi.set(__self__, "instance_ids", instance_ids)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if ocsp_enabled is not None:
            pulumi.set(__self__, "ocsp_enabled", ocsp_enabled)
        if proxy_types is not None:
            pulumi.set(__self__, "proxy_types", proxy_types)
        if real_servers is not None:
            pulumi.set(__self__, "real_servers", real_servers)
        if rs_type is not None:
            pulumi.set(__self__, "rs_type", rs_type)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key of the certificate that you want to associate. This parameter must be used together with the CertName and Cert parameters.

        > **NOTE:**   If you specify a value for the CertName, Cert, and Key parameters, you do not need to specify a value for the CertId parameter.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert", value)

    @_builtins.property
    @pulumi.getter(name="certIdentifier")
    def cert_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the certificate.

        > **NOTE:**   You can specify the name of the certificate that you want to associate. From version 1.249.0, `cert_identifier` is in the "CertificateID-RegionId" format. For example, if the ID of the certificateId is `123`, and the region ID is `cn-hangzhou`, the value of the `cert_identifier` is `123-cn-hangzhou`.
        """
        return pulumi.get(self, "cert_identifier")

    @cert_identifier.setter
    def cert_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_identifier", value)

    @_builtins.property
    @pulumi.getter(name="certName")
    def cert_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public key of the certificate that you want to associate. This parameter must be used together with the CertName and Key parameters.

        > **NOTE:**   If you specify a value for the CertName, Cert, and Key parameters, you do not need to specify a value for the CertId parameter.
        """
        return pulumi.get(self, "cert_name")

    @cert_name.setter
    def cert_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_name", value)

    @_builtins.property
    @pulumi.getter(name="certRegion")
    def cert_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the certificate. `cn-hangzhou` and `ap-southeast-1` are supported. The default value is `cn-hangzhou`.
        """
        return pulumi.get(self, "cert_region")

    @cert_region.setter
    def cert_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_region", value)

    @_builtins.property
    @pulumi.getter
    def cname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CNAME address to query.
        """
        return pulumi.get(self, "cname")

    @cname.setter
    def cname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cname", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name for which you want to configure the Static Page Caching policy.

        > **NOTE:**  You can call the [DescribeDomains](https://www.alibabacloud.com/help/en/doc-detail/91724.html) operation to query all the domain names that are added to Anti-DDoS Pro or Anti-DDoS Premium.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="httpsExt")
    def https_ext(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The advanced HTTPS settings. This parameter takes effect only when the value of the `ProxyType` parameter includes `https`. The value is a string that consists of a JSON struct. The JSON struct contains the following fields:

        - `Http2https`: specifies whether to turn on Enforce HTTPS Routing. This field is optional and must be an integer. Valid values: `0` and `1`. The value 0 indicates that Enforce HTTPS Routing is turned off. The value 1 indicates that Enforce HTTPS Routing is turned on. The default value is 0.

        If your website supports both HTTP and HTTPS, this feature meets your business requirements. If you enable this feature, all HTTP requests to access the website are redirected to HTTPS requests on the standard port 443.

        - `Https2http`: specifies whether to turn on Enable HTTP. This field is optional and must be an integer. Valid values: `0` and `1`. The value 0 indicates that Enable HTTP is turned off. The value 1 indicates that Enable HTTP is turned on. The default value is 0.

        If your website does not support HTTPS, this feature meets your business requirements If this feature is enabled, all HTTPS requests are redirected to HTTP requests and forwarded to origin servers. This feature can redirect WebSockets requests to WebSocket requests. Requests are redirected over the standard port 80.

        - `Http2`: specifies whether to turn on Enable HTTP/2. This field is optional. Data type: integer. Valid values: `0` and `1`. The value 0 indicates that Enable HTTP/2 is turned off. The value 1 indicates that Enable HTTP/2 is turned on. The default value is 0.

        After you turn on the switch, HTTP/2 is used.
        """
        return pulumi.get(self, "https_ext")

    @https_ext.setter
    def https_ext(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https_ext", value)

    @_builtins.property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        InstanceIds
        """
        return pulumi.get(self, "instance_ids")

    @instance_ids.setter
    def instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instance_ids", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The globally unique ID of the certificate. The value is in the "Certificate ID-cn-hangzhou" format. For example, if the ID of the certificate is 123, the value of the CertIdentifier parameter is 123-cn-hangzhou.

        > **NOTE:**   You can specify only one of this parameter and the CertId parameter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="ocspEnabled")
    def ocsp_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the OCSP feature. Valid values:
        """
        return pulumi.get(self, "ocsp_enabled")

    @ocsp_enabled.setter
    def ocsp_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ocsp_enabled", value)

    @_builtins.property
    @pulumi.getter(name="proxyTypes")
    def proxy_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainResourceProxyTypeArgs']]]]:
        """
        Protocol type and port number information. See `proxy_types` below.
        """
        return pulumi.get(self, "proxy_types")

    @proxy_types.setter
    def proxy_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainResourceProxyTypeArgs']]]]):
        pulumi.set(self, "proxy_types", value)

    @_builtins.property
    @pulumi.getter(name="realServers")
    def real_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Server address information of the source station.
        """
        return pulumi.get(self, "real_servers")

    @real_servers.setter
    def real_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "real_servers", value)

    @_builtins.property
    @pulumi.getter(name="rsType")
    def rs_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The address type of the origin server. Valid values:
        """
        return pulumi.get(self, "rs_type")

    @rs_type.setter
    def rs_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rs_type", value)


@pulumi.type_token("alicloud:ddos/domainResource:DomainResource")
class DomainResource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_region: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 https_ext: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 proxy_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainResourceProxyTypeArgs', 'DomainResourceProxyTypeArgsDict']]]]] = None,
                 real_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rs_type: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Ddos Coo Domain Resource resource.

        For information about Ddos Coo Domain Resource and how to use it, see [What is Domain Resource](https://www.alibabacloud.com/help/en/anti-ddos/anti-ddos-pro-and-premium/developer-reference/api-ddoscoo-2020-01-01-createdomainresource).

        > **NOTE:** Available since v1.123.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        domain = config.get("domain")
        if domain is None:
            domain = "tf-example.alibaba.com"
        default = alicloud.ddos.DdosCooInstance("default",
            name=name,
            bandwidth="30",
            base_bandwidth="30",
            service_bandwidth="100",
            port_count="50",
            domain_count="50",
            period=1,
            product_type="ddoscoo")
        default_domain_resource = alicloud.ddos.DomainResource("default",
            domain=domain,
            rs_type=0,
            instance_ids=[default.id],
            real_servers=["177.167.32.11"],
            https_ext=\"\"\"    {
            "Http2": 1,
            "Http2https": 0,
            "Https2http": 0
          }
        \"\"\",
            proxy_types=[{
                "proxy_ports": [443],
                "proxy_type": "https",
            }])
        ```

        ## Import

        Ddos Coo Domain Resource can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ddos/domainResource:DomainResource example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cert: The private key of the certificate that you want to associate. This parameter must be used together with the CertName and Cert parameters.
               
               > **NOTE:**   If you specify a value for the CertName, Cert, and Key parameters, you do not need to specify a value for the CertId parameter.
        :param pulumi.Input[_builtins.str] cert_identifier: The name of the certificate.
               
               > **NOTE:**   You can specify the name of the certificate that you want to associate. From version 1.249.0, `cert_identifier` is in the "CertificateID-RegionId" format. For example, if the ID of the certificateId is `123`, and the region ID is `cn-hangzhou`, the value of the `cert_identifier` is `123-cn-hangzhou`.
        :param pulumi.Input[_builtins.str] cert_name: The public key of the certificate that you want to associate. This parameter must be used together with the CertName and Key parameters.
               
               > **NOTE:**   If you specify a value for the CertName, Cert, and Key parameters, you do not need to specify a value for the CertId parameter.
        :param pulumi.Input[_builtins.str] cert_region: The region of the certificate. `cn-hangzhou` and `ap-southeast-1` are supported. The default value is `cn-hangzhou`.
        :param pulumi.Input[_builtins.str] domain: The domain name for which you want to configure the Static Page Caching policy.
               
               > **NOTE:**  You can call the [DescribeDomains](https://www.alibabacloud.com/help/en/doc-detail/91724.html) operation to query all the domain names that are added to Anti-DDoS Pro or Anti-DDoS Premium.
        :param pulumi.Input[_builtins.str] https_ext: The advanced HTTPS settings. This parameter takes effect only when the value of the `ProxyType` parameter includes `https`. The value is a string that consists of a JSON struct. The JSON struct contains the following fields:
               
               - `Http2https`: specifies whether to turn on Enforce HTTPS Routing. This field is optional and must be an integer. Valid values: `0` and `1`. The value 0 indicates that Enforce HTTPS Routing is turned off. The value 1 indicates that Enforce HTTPS Routing is turned on. The default value is 0.
               
               If your website supports both HTTP and HTTPS, this feature meets your business requirements. If you enable this feature, all HTTP requests to access the website are redirected to HTTPS requests on the standard port 443.
               
               - `Https2http`: specifies whether to turn on Enable HTTP. This field is optional and must be an integer. Valid values: `0` and `1`. The value 0 indicates that Enable HTTP is turned off. The value 1 indicates that Enable HTTP is turned on. The default value is 0.
               
               If your website does not support HTTPS, this feature meets your business requirements If this feature is enabled, all HTTPS requests are redirected to HTTP requests and forwarded to origin servers. This feature can redirect WebSockets requests to WebSocket requests. Requests are redirected over the standard port 80.
               
               - `Http2`: specifies whether to turn on Enable HTTP/2. This field is optional. Data type: integer. Valid values: `0` and `1`. The value 0 indicates that Enable HTTP/2 is turned off. The value 1 indicates that Enable HTTP/2 is turned on. The default value is 0.
               
               After you turn on the switch, HTTP/2 is used.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_ids: InstanceIds
        :param pulumi.Input[_builtins.str] key: The globally unique ID of the certificate. The value is in the "Certificate ID-cn-hangzhou" format. For example, if the ID of the certificate is 123, the value of the CertIdentifier parameter is 123-cn-hangzhou.
               
               > **NOTE:**   You can specify only one of this parameter and the CertId parameter.
        :param pulumi.Input[_builtins.bool] ocsp_enabled: Specifies whether to enable the OCSP feature. Valid values:
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainResourceProxyTypeArgs', 'DomainResourceProxyTypeArgsDict']]]] proxy_types: Protocol type and port number information. See `proxy_types` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] real_servers: Server address information of the source station.
        :param pulumi.Input[_builtins.int] rs_type: The address type of the origin server. Valid values:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainResourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Ddos Coo Domain Resource resource.

        For information about Ddos Coo Domain Resource and how to use it, see [What is Domain Resource](https://www.alibabacloud.com/help/en/anti-ddos/anti-ddos-pro-and-premium/developer-reference/api-ddoscoo-2020-01-01-createdomainresource).

        > **NOTE:** Available since v1.123.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        domain = config.get("domain")
        if domain is None:
            domain = "tf-example.alibaba.com"
        default = alicloud.ddos.DdosCooInstance("default",
            name=name,
            bandwidth="30",
            base_bandwidth="30",
            service_bandwidth="100",
            port_count="50",
            domain_count="50",
            period=1,
            product_type="ddoscoo")
        default_domain_resource = alicloud.ddos.DomainResource("default",
            domain=domain,
            rs_type=0,
            instance_ids=[default.id],
            real_servers=["177.167.32.11"],
            https_ext=\"\"\"    {
            "Http2": 1,
            "Http2https": 0,
            "Https2http": 0
          }
        \"\"\",
            proxy_types=[{
                "proxy_ports": [443],
                "proxy_type": "https",
            }])
        ```

        ## Import

        Ddos Coo Domain Resource can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ddos/domainResource:DomainResource example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DomainResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_region: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 https_ext: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 proxy_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainResourceProxyTypeArgs', 'DomainResourceProxyTypeArgsDict']]]]] = None,
                 real_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rs_type: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainResourceArgs.__new__(DomainResourceArgs)

            __props__.__dict__["cert"] = None if cert is None else pulumi.Output.secret(cert)
            __props__.__dict__["cert_identifier"] = cert_identifier
            __props__.__dict__["cert_name"] = cert_name
            __props__.__dict__["cert_region"] = None if cert_region is None else pulumi.Output.secret(cert_region)
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            __props__.__dict__["https_ext"] = https_ext
            if instance_ids is None and not opts.urn:
                raise TypeError("Missing required property 'instance_ids'")
            __props__.__dict__["instance_ids"] = instance_ids
            __props__.__dict__["key"] = None if key is None else pulumi.Output.secret(key)
            __props__.__dict__["ocsp_enabled"] = ocsp_enabled
            if proxy_types is None and not opts.urn:
                raise TypeError("Missing required property 'proxy_types'")
            __props__.__dict__["proxy_types"] = proxy_types
            if real_servers is None and not opts.urn:
                raise TypeError("Missing required property 'real_servers'")
            __props__.__dict__["real_servers"] = real_servers
            if rs_type is None and not opts.urn:
                raise TypeError("Missing required property 'rs_type'")
            __props__.__dict__["rs_type"] = rs_type
            __props__.__dict__["cname"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["cert", "certRegion", "key"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DomainResource, __self__).__init__(
            'alicloud:ddos/domainResource:DomainResource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cert: Optional[pulumi.Input[_builtins.str]] = None,
            cert_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            cert_name: Optional[pulumi.Input[_builtins.str]] = None,
            cert_region: Optional[pulumi.Input[_builtins.str]] = None,
            cname: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            https_ext: Optional[pulumi.Input[_builtins.str]] = None,
            instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            ocsp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            proxy_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainResourceProxyTypeArgs', 'DomainResourceProxyTypeArgsDict']]]]] = None,
            real_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            rs_type: Optional[pulumi.Input[_builtins.int]] = None) -> 'DomainResource':
        """
        Get an existing DomainResource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cert: The private key of the certificate that you want to associate. This parameter must be used together with the CertName and Cert parameters.
               
               > **NOTE:**   If you specify a value for the CertName, Cert, and Key parameters, you do not need to specify a value for the CertId parameter.
        :param pulumi.Input[_builtins.str] cert_identifier: The name of the certificate.
               
               > **NOTE:**   You can specify the name of the certificate that you want to associate. From version 1.249.0, `cert_identifier` is in the "CertificateID-RegionId" format. For example, if the ID of the certificateId is `123`, and the region ID is `cn-hangzhou`, the value of the `cert_identifier` is `123-cn-hangzhou`.
        :param pulumi.Input[_builtins.str] cert_name: The public key of the certificate that you want to associate. This parameter must be used together with the CertName and Key parameters.
               
               > **NOTE:**   If you specify a value for the CertName, Cert, and Key parameters, you do not need to specify a value for the CertId parameter.
        :param pulumi.Input[_builtins.str] cert_region: The region of the certificate. `cn-hangzhou` and `ap-southeast-1` are supported. The default value is `cn-hangzhou`.
        :param pulumi.Input[_builtins.str] cname: The CNAME address to query.
        :param pulumi.Input[_builtins.str] domain: The domain name for which you want to configure the Static Page Caching policy.
               
               > **NOTE:**  You can call the [DescribeDomains](https://www.alibabacloud.com/help/en/doc-detail/91724.html) operation to query all the domain names that are added to Anti-DDoS Pro or Anti-DDoS Premium.
        :param pulumi.Input[_builtins.str] https_ext: The advanced HTTPS settings. This parameter takes effect only when the value of the `ProxyType` parameter includes `https`. The value is a string that consists of a JSON struct. The JSON struct contains the following fields:
               
               - `Http2https`: specifies whether to turn on Enforce HTTPS Routing. This field is optional and must be an integer. Valid values: `0` and `1`. The value 0 indicates that Enforce HTTPS Routing is turned off. The value 1 indicates that Enforce HTTPS Routing is turned on. The default value is 0.
               
               If your website supports both HTTP and HTTPS, this feature meets your business requirements. If you enable this feature, all HTTP requests to access the website are redirected to HTTPS requests on the standard port 443.
               
               - `Https2http`: specifies whether to turn on Enable HTTP. This field is optional and must be an integer. Valid values: `0` and `1`. The value 0 indicates that Enable HTTP is turned off. The value 1 indicates that Enable HTTP is turned on. The default value is 0.
               
               If your website does not support HTTPS, this feature meets your business requirements If this feature is enabled, all HTTPS requests are redirected to HTTP requests and forwarded to origin servers. This feature can redirect WebSockets requests to WebSocket requests. Requests are redirected over the standard port 80.
               
               - `Http2`: specifies whether to turn on Enable HTTP/2. This field is optional. Data type: integer. Valid values: `0` and `1`. The value 0 indicates that Enable HTTP/2 is turned off. The value 1 indicates that Enable HTTP/2 is turned on. The default value is 0.
               
               After you turn on the switch, HTTP/2 is used.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_ids: InstanceIds
        :param pulumi.Input[_builtins.str] key: The globally unique ID of the certificate. The value is in the "Certificate ID-cn-hangzhou" format. For example, if the ID of the certificate is 123, the value of the CertIdentifier parameter is 123-cn-hangzhou.
               
               > **NOTE:**   You can specify only one of this parameter and the CertId parameter.
        :param pulumi.Input[_builtins.bool] ocsp_enabled: Specifies whether to enable the OCSP feature. Valid values:
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainResourceProxyTypeArgs', 'DomainResourceProxyTypeArgsDict']]]] proxy_types: Protocol type and port number information. See `proxy_types` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] real_servers: Server address information of the source station.
        :param pulumi.Input[_builtins.int] rs_type: The address type of the origin server. Valid values:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainResourceState.__new__(_DomainResourceState)

        __props__.__dict__["cert"] = cert
        __props__.__dict__["cert_identifier"] = cert_identifier
        __props__.__dict__["cert_name"] = cert_name
        __props__.__dict__["cert_region"] = cert_region
        __props__.__dict__["cname"] = cname
        __props__.__dict__["domain"] = domain
        __props__.__dict__["https_ext"] = https_ext
        __props__.__dict__["instance_ids"] = instance_ids
        __props__.__dict__["key"] = key
        __props__.__dict__["ocsp_enabled"] = ocsp_enabled
        __props__.__dict__["proxy_types"] = proxy_types
        __props__.__dict__["real_servers"] = real_servers
        __props__.__dict__["rs_type"] = rs_type
        return DomainResource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The private key of the certificate that you want to associate. This parameter must be used together with the CertName and Cert parameters.

        > **NOTE:**   If you specify a value for the CertName, Cert, and Key parameters, you do not need to specify a value for the CertId parameter.
        """
        return pulumi.get(self, "cert")

    @_builtins.property
    @pulumi.getter(name="certIdentifier")
    def cert_identifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the certificate.

        > **NOTE:**   You can specify the name of the certificate that you want to associate. From version 1.249.0, `cert_identifier` is in the "CertificateID-RegionId" format. For example, if the ID of the certificateId is `123`, and the region ID is `cn-hangzhou`, the value of the `cert_identifier` is `123-cn-hangzhou`.
        """
        return pulumi.get(self, "cert_identifier")

    @_builtins.property
    @pulumi.getter(name="certName")
    def cert_name(self) -> pulumi.Output[_builtins.str]:
        """
        The public key of the certificate that you want to associate. This parameter must be used together with the CertName and Key parameters.

        > **NOTE:**   If you specify a value for the CertName, Cert, and Key parameters, you do not need to specify a value for the CertId parameter.
        """
        return pulumi.get(self, "cert_name")

    @_builtins.property
    @pulumi.getter(name="certRegion")
    def cert_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region of the certificate. `cn-hangzhou` and `ap-southeast-1` are supported. The default value is `cn-hangzhou`.
        """
        return pulumi.get(self, "cert_region")

    @_builtins.property
    @pulumi.getter
    def cname(self) -> pulumi.Output[_builtins.str]:
        """
        The CNAME address to query.
        """
        return pulumi.get(self, "cname")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name for which you want to configure the Static Page Caching policy.

        > **NOTE:**  You can call the [DescribeDomains](https://www.alibabacloud.com/help/en/doc-detail/91724.html) operation to query all the domain names that are added to Anti-DDoS Pro or Anti-DDoS Premium.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="httpsExt")
    def https_ext(self) -> pulumi.Output[_builtins.str]:
        """
        The advanced HTTPS settings. This parameter takes effect only when the value of the `ProxyType` parameter includes `https`. The value is a string that consists of a JSON struct. The JSON struct contains the following fields:

        - `Http2https`: specifies whether to turn on Enforce HTTPS Routing. This field is optional and must be an integer. Valid values: `0` and `1`. The value 0 indicates that Enforce HTTPS Routing is turned off. The value 1 indicates that Enforce HTTPS Routing is turned on. The default value is 0.

        If your website supports both HTTP and HTTPS, this feature meets your business requirements. If you enable this feature, all HTTP requests to access the website are redirected to HTTPS requests on the standard port 443.

        - `Https2http`: specifies whether to turn on Enable HTTP. This field is optional and must be an integer. Valid values: `0` and `1`. The value 0 indicates that Enable HTTP is turned off. The value 1 indicates that Enable HTTP is turned on. The default value is 0.

        If your website does not support HTTPS, this feature meets your business requirements If this feature is enabled, all HTTPS requests are redirected to HTTP requests and forwarded to origin servers. This feature can redirect WebSockets requests to WebSocket requests. Requests are redirected over the standard port 80.

        - `Http2`: specifies whether to turn on Enable HTTP/2. This field is optional. Data type: integer. Valid values: `0` and `1`. The value 0 indicates that Enable HTTP/2 is turned off. The value 1 indicates that Enable HTTP/2 is turned on. The default value is 0.

        After you turn on the switch, HTTP/2 is used.
        """
        return pulumi.get(self, "https_ext")

    @_builtins.property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        InstanceIds
        """
        return pulumi.get(self, "instance_ids")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The globally unique ID of the certificate. The value is in the "Certificate ID-cn-hangzhou" format. For example, if the ID of the certificate is 123, the value of the CertIdentifier parameter is 123-cn-hangzhou.

        > **NOTE:**   You can specify only one of this parameter and the CertId parameter.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="ocspEnabled")
    def ocsp_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the OCSP feature. Valid values:
        """
        return pulumi.get(self, "ocsp_enabled")

    @_builtins.property
    @pulumi.getter(name="proxyTypes")
    def proxy_types(self) -> pulumi.Output[Sequence['outputs.DomainResourceProxyType']]:
        """
        Protocol type and port number information. See `proxy_types` below.
        """
        return pulumi.get(self, "proxy_types")

    @_builtins.property
    @pulumi.getter(name="realServers")
    def real_servers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Server address information of the source station.
        """
        return pulumi.get(self, "real_servers")

    @_builtins.property
    @pulumi.getter(name="rsType")
    def rs_type(self) -> pulumi.Output[_builtins.int]:
        """
        The address type of the origin server. Valid values:
        """
        return pulumi.get(self, "rs_type")

