# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MountPointArgs', 'MountPoint']

@pulumi.input_type
class MountPointArgs:
    def __init__(__self__, *,
                 access_group_id: pulumi.Input[_builtins.str],
                 file_system_id: pulumi.Input[_builtins.str],
                 network_type: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 alias_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MountPoint resource.
        :param pulumi.Input[_builtins.str] access_group_id: The id of the permission group associated with the Mount point, which is used to set the access permissions of the Mount point.
        :param pulumi.Input[_builtins.str] file_system_id: Unique file system identifier, used to retrieve specified file system resources.
        :param pulumi.Input[_builtins.str] network_type: The network type of the Mount point.  Only VPC (VPC) is supported.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC. Specifies the VPC environment to which the mount point belongs.
        :param pulumi.Input[_builtins.str] vswitch_id: VSwitch ID, which specifies the VSwitch resource used to create the mount point.
        :param pulumi.Input[_builtins.str] alias_prefix: The mount point alias prefix, which specifies the mount point alias prefix.
        :param pulumi.Input[_builtins.str] description: The description of the Mount point.  No more than 32 characters in length.
        :param pulumi.Input[_builtins.str] status: Mount point status. Value: Inactive: Disable mount points Active: Activate the mount point.
        """
        pulumi.set(__self__, "access_group_id", access_group_id)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if alias_prefix is not None:
            pulumi.set(__self__, "alias_prefix", alias_prefix)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accessGroupId")
    def access_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the permission group associated with the Mount point, which is used to set the access permissions of the Mount point.
        """
        return pulumi.get(self, "access_group_id")

    @access_group_id.setter
    def access_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_group_id", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique file system identifier, used to retrieve specified file system resources.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Input[_builtins.str]:
        """
        The network type of the Mount point.  Only VPC (VPC) is supported.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VPC. Specifies the VPC environment to which the mount point belongs.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        VSwitch ID, which specifies the VSwitch resource used to create the mount point.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="aliasPrefix")
    def alias_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mount point alias prefix, which specifies the mount point alias prefix.
        """
        return pulumi.get(self, "alias_prefix")

    @alias_prefix.setter
    def alias_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias_prefix", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Mount point.  No more than 32 characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mount point status. Value: Inactive: Disable mount points Active: Activate the mount point.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _MountPointState:
    def __init__(__self__, *,
                 access_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 alias_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MountPoint resources.
        :param pulumi.Input[_builtins.str] access_group_id: The id of the permission group associated with the Mount point, which is used to set the access permissions of the Mount point.
        :param pulumi.Input[_builtins.str] alias_prefix: The mount point alias prefix, which specifies the mount point alias prefix.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the Mount point resource.
        :param pulumi.Input[_builtins.str] description: The description of the Mount point.  No more than 32 characters in length.
        :param pulumi.Input[_builtins.str] file_system_id: Unique file system identifier, used to retrieve specified file system resources.
        :param pulumi.Input[_builtins.str] mount_point_id: The unique identifier of the Mount point, which is used to retrieve the specified mount point resources.
        :param pulumi.Input[_builtins.str] network_type: The network type of the Mount point.  Only VPC (VPC) is supported.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.242.0) The region ID of the Mount Point.
        :param pulumi.Input[_builtins.str] status: Mount point status. Value: Inactive: Disable mount points Active: Activate the mount point.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC. Specifies the VPC environment to which the mount point belongs.
        :param pulumi.Input[_builtins.str] vswitch_id: VSwitch ID, which specifies the VSwitch resource used to create the mount point.
        """
        if access_group_id is not None:
            pulumi.set(__self__, "access_group_id", access_group_id)
        if alias_prefix is not None:
            pulumi.set(__self__, "alias_prefix", alias_prefix)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if mount_point_id is not None:
            pulumi.set(__self__, "mount_point_id", mount_point_id)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="accessGroupId")
    def access_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the permission group associated with the Mount point, which is used to set the access permissions of the Mount point.
        """
        return pulumi.get(self, "access_group_id")

    @access_group_id.setter
    def access_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_group_id", value)

    @_builtins.property
    @pulumi.getter(name="aliasPrefix")
    def alias_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mount point alias prefix, which specifies the mount point alias prefix.
        """
        return pulumi.get(self, "alias_prefix")

    @alias_prefix.setter
    def alias_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias_prefix", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the Mount point resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Mount point.  No more than 32 characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique file system identifier, used to retrieve specified file system resources.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="mountPointId")
    def mount_point_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the Mount point, which is used to retrieve the specified mount point resources.
        """
        return pulumi.get(self, "mount_point_id")

    @mount_point_id.setter
    def mount_point_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount_point_id", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the Mount point.  Only VPC (VPC) is supported.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.242.0) The region ID of the Mount Point.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mount point status. Value: Inactive: Disable mount points Active: Activate the mount point.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC. Specifies the VPC environment to which the mount point belongs.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VSwitch ID, which specifies the VSwitch resource used to create the mount point.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:dfs/mountPoint:MountPoint")
class MountPoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 alias_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Apsara File Storage for HDFS (DFS) Mount Point resource.

        For information about Apsara File Storage for HDFS (DFS) Mount Point and how to use it, see [What is Mount Point](https://www.alibabacloud.com/help/en/aibaba-cloud-storage-services/latest/apsara-file-storage-for-hdfs).

        > **NOTE:** Available since v1.140.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default.id,
            zone_id="cn-hangzhou-e")
        default_file_system = alicloud.dfs.FileSystem("default",
            storage_type="STANDARD",
            zone_id="cn-hangzhou-e",
            protocol_type="PANGU",
            description=name,
            file_system_name=name,
            throughput_mode="Provisioned",
            space_capacity=1024,
            provisioned_throughput_in_mi_bps=512)
        default_access_group = alicloud.dfs.AccessGroup("default",
            access_group_name=name,
            description=name,
            network_type="VPC")
        default_mount_point = alicloud.dfs.MountPoint("default",
            description=name,
            vpc_id=default.id,
            file_system_id=default_file_system.id,
            access_group_id=default_access_group.id,
            network_type="VPC",
            vswitch_id=default_switch.id)
        ```

        ## Import

        Apsara File Storage for HDFS (DFS) Mount Point can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dfs/mountPoint:MountPoint example <file_system_id>:<mount_point_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_group_id: The id of the permission group associated with the Mount point, which is used to set the access permissions of the Mount point.
        :param pulumi.Input[_builtins.str] alias_prefix: The mount point alias prefix, which specifies the mount point alias prefix.
        :param pulumi.Input[_builtins.str] description: The description of the Mount point.  No more than 32 characters in length.
        :param pulumi.Input[_builtins.str] file_system_id: Unique file system identifier, used to retrieve specified file system resources.
        :param pulumi.Input[_builtins.str] network_type: The network type of the Mount point.  Only VPC (VPC) is supported.
        :param pulumi.Input[_builtins.str] status: Mount point status. Value: Inactive: Disable mount points Active: Activate the mount point.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC. Specifies the VPC environment to which the mount point belongs.
        :param pulumi.Input[_builtins.str] vswitch_id: VSwitch ID, which specifies the VSwitch resource used to create the mount point.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MountPointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Apsara File Storage for HDFS (DFS) Mount Point resource.

        For information about Apsara File Storage for HDFS (DFS) Mount Point and how to use it, see [What is Mount Point](https://www.alibabacloud.com/help/en/aibaba-cloud-storage-services/latest/apsara-file-storage-for-hdfs).

        > **NOTE:** Available since v1.140.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default.id,
            zone_id="cn-hangzhou-e")
        default_file_system = alicloud.dfs.FileSystem("default",
            storage_type="STANDARD",
            zone_id="cn-hangzhou-e",
            protocol_type="PANGU",
            description=name,
            file_system_name=name,
            throughput_mode="Provisioned",
            space_capacity=1024,
            provisioned_throughput_in_mi_bps=512)
        default_access_group = alicloud.dfs.AccessGroup("default",
            access_group_name=name,
            description=name,
            network_type="VPC")
        default_mount_point = alicloud.dfs.MountPoint("default",
            description=name,
            vpc_id=default.id,
            file_system_id=default_file_system.id,
            access_group_id=default_access_group.id,
            network_type="VPC",
            vswitch_id=default_switch.id)
        ```

        ## Import

        Apsara File Storage for HDFS (DFS) Mount Point can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dfs/mountPoint:MountPoint example <file_system_id>:<mount_point_id>
        ```

        :param str resource_name: The name of the resource.
        :param MountPointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MountPointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 alias_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MountPointArgs.__new__(MountPointArgs)

            if access_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'access_group_id'")
            __props__.__dict__["access_group_id"] = access_group_id
            __props__.__dict__["alias_prefix"] = alias_prefix
            __props__.__dict__["description"] = description
            if file_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_id'")
            __props__.__dict__["file_system_id"] = file_system_id
            if network_type is None and not opts.urn:
                raise TypeError("Missing required property 'network_type'")
            __props__.__dict__["network_type"] = network_type
            __props__.__dict__["status"] = status
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["mount_point_id"] = None
            __props__.__dict__["region_id"] = None
        super(MountPoint, __self__).__init__(
            'alicloud:dfs/mountPoint:MountPoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            alias_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
            mount_point_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_type: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'MountPoint':
        """
        Get an existing MountPoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_group_id: The id of the permission group associated with the Mount point, which is used to set the access permissions of the Mount point.
        :param pulumi.Input[_builtins.str] alias_prefix: The mount point alias prefix, which specifies the mount point alias prefix.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the Mount point resource.
        :param pulumi.Input[_builtins.str] description: The description of the Mount point.  No more than 32 characters in length.
        :param pulumi.Input[_builtins.str] file_system_id: Unique file system identifier, used to retrieve specified file system resources.
        :param pulumi.Input[_builtins.str] mount_point_id: The unique identifier of the Mount point, which is used to retrieve the specified mount point resources.
        :param pulumi.Input[_builtins.str] network_type: The network type of the Mount point.  Only VPC (VPC) is supported.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.242.0) The region ID of the Mount Point.
        :param pulumi.Input[_builtins.str] status: Mount point status. Value: Inactive: Disable mount points Active: Activate the mount point.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC. Specifies the VPC environment to which the mount point belongs.
        :param pulumi.Input[_builtins.str] vswitch_id: VSwitch ID, which specifies the VSwitch resource used to create the mount point.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MountPointState.__new__(_MountPointState)

        __props__.__dict__["access_group_id"] = access_group_id
        __props__.__dict__["alias_prefix"] = alias_prefix
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["file_system_id"] = file_system_id
        __props__.__dict__["mount_point_id"] = mount_point_id
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        return MountPoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessGroupId")
    def access_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the permission group associated with the Mount point, which is used to set the access permissions of the Mount point.
        """
        return pulumi.get(self, "access_group_id")

    @_builtins.property
    @pulumi.getter(name="aliasPrefix")
    def alias_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The mount point alias prefix, which specifies the mount point alias prefix.
        """
        return pulumi.get(self, "alias_prefix")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the Mount point resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Mount point.  No more than 32 characters in length.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique file system identifier, used to retrieve specified file system resources.
        """
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter(name="mountPointId")
    def mount_point_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the Mount point, which is used to retrieve the specified mount point resources.
        """
        return pulumi.get(self, "mount_point_id")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[_builtins.str]:
        """
        The network type of the Mount point.  Only VPC (VPC) is supported.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.242.0) The region ID of the Mount Point.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Mount point status. Value: Inactive: Disable mount points Active: Activate the mount point.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC. Specifies the VPC environment to which the mount point belongs.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        VSwitch ID, which specifies the VSwitch resource used to create the mount point.
        """
        return pulumi.get(self, "vswitch_id")

