# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ClientInstanceAttachmentArgs', 'ClientInstanceAttachment']

@pulumi.input_type
class ClientInstanceAttachmentArgs:
    def __init__(__self__, *,
                 client_instance_id: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 ei_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ClientInstanceAttachment resource.
        :param pulumi.Input[_builtins.str] client_instance_id: The ID of the ECS or ECI instance bound to the EAIS instance.
        :param pulumi.Input[_builtins.str] instance_id: The EAIS instance ID.
        :param pulumi.Input[_builtins.str] category: EAIS instance category, valid values: `eais`, `ei`, default is `eais`.
        :param pulumi.Input[_builtins.str] ei_instance_type: The Ei instance specification, which is used to filter matching specifications for updating.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        pulumi.set(__self__, "client_instance_id", client_instance_id)
        pulumi.set(__self__, "instance_id", instance_id)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if ei_instance_type is not None:
            pulumi.set(__self__, "ei_instance_type", ei_instance_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="clientInstanceId")
    def client_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the ECS or ECI instance bound to the EAIS instance.
        """
        return pulumi.get(self, "client_instance_id")

    @client_instance_id.setter
    def client_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The EAIS instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        EAIS instance category, valid values: `eais`, `ei`, default is `eais`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="eiInstanceType")
    def ei_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Ei instance specification, which is used to filter matching specifications for updating.
        """
        return pulumi.get(self, "ei_instance_type")

    @ei_instance_type.setter
    def ei_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ei_instance_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _ClientInstanceAttachmentState:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 client_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 ei_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ClientInstanceAttachment resources.
        :param pulumi.Input[_builtins.str] category: EAIS instance category, valid values: `eais`, `ei`, default is `eais`.
        :param pulumi.Input[_builtins.str] client_instance_id: The ID of the ECS or ECI instance bound to the EAIS instance.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] ei_instance_type: The Ei instance specification, which is used to filter matching specifications for updating.
        :param pulumi.Input[_builtins.str] instance_id: The EAIS instance ID.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if client_instance_id is not None:
            pulumi.set(__self__, "client_instance_id", client_instance_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if ei_instance_type is not None:
            pulumi.set(__self__, "ei_instance_type", ei_instance_type)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        EAIS instance category, valid values: `eais`, `ei`, default is `eais`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="clientInstanceId")
    def client_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the ECS or ECI instance bound to the EAIS instance.
        """
        return pulumi.get(self, "client_instance_id")

    @client_instance_id.setter
    def client_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="eiInstanceType")
    def ei_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Ei instance specification, which is used to filter matching specifications for updating.
        """
        return pulumi.get(self, "ei_instance_type")

    @ei_instance_type.setter
    def ei_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ei_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EAIS instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:eais/clientInstanceAttachment:ClientInstanceAttachment")
class ClientInstanceAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 client_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ei_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        EAIS Client Instance Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eais/clientInstanceAttachment:ClientInstanceAttachment example <instance_id>:<client_instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category: EAIS instance category, valid values: `eais`, `ei`, default is `eais`.
        :param pulumi.Input[_builtins.str] client_instance_id: The ID of the ECS or ECI instance bound to the EAIS instance.
        :param pulumi.Input[_builtins.str] ei_instance_type: The Ei instance specification, which is used to filter matching specifications for updating.
        :param pulumi.Input[_builtins.str] instance_id: The EAIS instance ID.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClientInstanceAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        EAIS Client Instance Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eais/clientInstanceAttachment:ClientInstanceAttachment example <instance_id>:<client_instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param ClientInstanceAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClientInstanceAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 client_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ei_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClientInstanceAttachmentArgs.__new__(ClientInstanceAttachmentArgs)

            __props__.__dict__["category"] = category
            if client_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_instance_id'")
            __props__.__dict__["client_instance_id"] = client_instance_id
            __props__.__dict__["ei_instance_type"] = ei_instance_type
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["status"] = status
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
        super(ClientInstanceAttachment, __self__).__init__(
            'alicloud:eais/clientInstanceAttachment:ClientInstanceAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            client_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            ei_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'ClientInstanceAttachment':
        """
        Get an existing ClientInstanceAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category: EAIS instance category, valid values: `eais`, `ei`, default is `eais`.
        :param pulumi.Input[_builtins.str] client_instance_id: The ID of the ECS or ECI instance bound to the EAIS instance.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] ei_instance_type: The Ei instance specification, which is used to filter matching specifications for updating.
        :param pulumi.Input[_builtins.str] instance_id: The EAIS instance ID.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClientInstanceAttachmentState.__new__(_ClientInstanceAttachmentState)

        __props__.__dict__["category"] = category
        __props__.__dict__["client_instance_id"] = client_instance_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["ei_instance_type"] = ei_instance_type
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["status"] = status
        return ClientInstanceAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        EAIS instance category, valid values: `eais`, `ei`, default is `eais`.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="clientInstanceId")
    def client_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the ECS or ECI instance bound to the EAIS instance.
        """
        return pulumi.get(self, "client_instance_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="eiInstanceType")
    def ei_instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The Ei instance specification, which is used to filter matching specifications for updating.
        """
        return pulumi.get(self, "ei_instance_type")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The EAIS instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

