# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DiskReplicaGroupArgs', 'DiskReplicaGroup']

@pulumi.input_type
class DiskReplicaGroupArgs:
    def __init__(__self__, *,
                 destination_region_id: pulumi.Input[_builtins.str],
                 destination_zone_id: pulumi.Input[_builtins.str],
                 source_region_id: pulumi.Input[_builtins.str],
                 source_zone_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_replica_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 one_shot: Optional[pulumi.Input[_builtins.bool]] = None,
                 pair_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse_replicate: Optional[pulumi.Input[_builtins.bool]] = None,
                 rpo: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DiskReplicaGroup resource.
        :param pulumi.Input[_builtins.str] destination_region_id: The ID of the region to which the disaster recovery site belongs.
        :param pulumi.Input[_builtins.str] destination_zone_id: The ID of the zone to which the disaster recovery site belongs.
        :param pulumi.Input[_builtins.str] source_region_id: The ID of the region to which the production site belongs.
        :param pulumi.Input[_builtins.str] source_zone_id: The ID of the zone to which the production site belongs.
        :param pulumi.Input[_builtins.str] description: The description of the consistent replication group.
        :param pulumi.Input[_builtins.str] disk_replica_group_name: Consistent replication group name.
        :param pulumi.Input[_builtins.str] group_name: . Field 'group_name' has been deprecated from provider version 1.245.0. New field 'disk_replica_group_name' instead.
        :param pulumi.Input[_builtins.bool] one_shot: Whether to synchronize immediately. Value range:
               - true: Start data synchronization immediately.
               - false: Data Synchronization starts after the RPO time period.
               
               Default value: false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pair_ids: List of replication pair IDs contained in a consistent replication group.
        :param pulumi.Input[_builtins.str] resource_group_id: resource group ID of enterprise
        :param pulumi.Input[_builtins.bool] reverse_replicate: Specifies whether to enable the reverse replication sub-feature. Valid values: true and false. Default value: true.
        :param pulumi.Input[_builtins.int] rpo: The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        :param pulumi.Input[_builtins.str] status: The status of the consistent replication group. Possible values:
               - invalid: invalid. This state indicates that there is an exception to the replication pair in the consistent replication group.
               - creating: creating.
               - created: created.
               - create_failed: creation failed.
               - manual_syncing: in a single synchronization. If it is the first single synchronization, this status is also displayed in the synchronization.
               - syncing: synchronization. This state is the first time data is copied asynchronously between the master and slave disks.
               - normal: normal. When data replication is completed within the current cycle of asynchronous replication, it will be in this state.
               - stopping: stopping.
               - stopped: stopped.
               - stop_failed: Stop failed.
               - Failover: failover.
               - Failed: failover completed.
               - failover_failed: failover failed.
               - Reprotection: In reverse copy operation.
               - reprotect_failed: reverse replication failed.
               - deleting: deleting.
               - delete_failed: delete failed.
               - deleted: deleted.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        pulumi.set(__self__, "destination_region_id", destination_region_id)
        pulumi.set(__self__, "destination_zone_id", destination_zone_id)
        pulumi.set(__self__, "source_region_id", source_region_id)
        pulumi.set(__self__, "source_zone_id", source_zone_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_replica_group_name is not None:
            pulumi.set(__self__, "disk_replica_group_name", disk_replica_group_name)
        if group_name is not None:
            warnings.warn("""Field 'group_name' has been deprecated since provider version 1.245.0. New field 'disk_replica_group_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""group_name is deprecated: Field 'group_name' has been deprecated since provider version 1.245.0. New field 'disk_replica_group_name' instead.""")
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if one_shot is not None:
            pulumi.set(__self__, "one_shot", one_shot)
        if pair_ids is not None:
            pulumi.set(__self__, "pair_ids", pair_ids)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if reverse_replicate is not None:
            pulumi.set(__self__, "reverse_replicate", reverse_replicate)
        if rpo is not None:
            pulumi.set(__self__, "rpo", rpo)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="destinationRegionId")
    def destination_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the region to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_region_id")

    @destination_region_id.setter
    def destination_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_region_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationZoneId")
    def destination_zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the zone to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_zone_id")

    @destination_zone_id.setter
    def destination_zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceRegionId")
    def source_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the region to which the production site belongs.
        """
        return pulumi.get(self, "source_region_id")

    @source_region_id.setter
    def source_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_region_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceZoneId")
    def source_zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the zone to which the production site belongs.
        """
        return pulumi.get(self, "source_zone_id")

    @source_zone_id.setter
    def source_zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_zone_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the consistent replication group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskReplicaGroupName")
    def disk_replica_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Consistent replication group name.
        """
        return pulumi.get(self, "disk_replica_group_name")

    @disk_replica_group_name.setter
    def disk_replica_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_replica_group_name", value)

    @_builtins.property
    @pulumi.getter(name="groupName")
    @_utilities.deprecated("""Field 'group_name' has been deprecated since provider version 1.245.0. New field 'disk_replica_group_name' instead.""")
    def group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'group_name' has been deprecated from provider version 1.245.0. New field 'disk_replica_group_name' instead.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter(name="oneShot")
    def one_shot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to synchronize immediately. Value range:
        - true: Start data synchronization immediately.
        - false: Data Synchronization starts after the RPO time period.

        Default value: false.
        """
        return pulumi.get(self, "one_shot")

    @one_shot.setter
    def one_shot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "one_shot", value)

    @_builtins.property
    @pulumi.getter(name="pairIds")
    def pair_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of replication pair IDs contained in a consistent replication group.
        """
        return pulumi.get(self, "pair_ids")

    @pair_ids.setter
    def pair_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pair_ids", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        resource group ID of enterprise
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="reverseReplicate")
    def reverse_replicate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the reverse replication sub-feature. Valid values: true and false. Default value: true.
        """
        return pulumi.get(self, "reverse_replicate")

    @reverse_replicate.setter
    def reverse_replicate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reverse_replicate", value)

    @_builtins.property
    @pulumi.getter
    def rpo(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        """
        return pulumi.get(self, "rpo")

    @rpo.setter
    def rpo(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rpo", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the consistent replication group. Possible values:
        - invalid: invalid. This state indicates that there is an exception to the replication pair in the consistent replication group.
        - creating: creating.
        - created: created.
        - create_failed: creation failed.
        - manual_syncing: in a single synchronization. If it is the first single synchronization, this status is also displayed in the synchronization.
        - syncing: synchronization. This state is the first time data is copied asynchronously between the master and slave disks.
        - normal: normal. When data replication is completed within the current cycle of asynchronous replication, it will be in this state.
        - stopping: stopping.
        - stopped: stopped.
        - stop_failed: Stop failed.
        - Failover: failover.
        - Failed: failover completed.
        - failover_failed: failover failed.
        - Reprotection: In reverse copy operation.
        - reprotect_failed: reverse replication failed.
        - deleting: deleting.
        - delete_failed: delete failed.
        - deleted: deleted.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DiskReplicaGroupState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_replica_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 one_shot: Optional[pulumi.Input[_builtins.bool]] = None,
                 pair_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse_replicate: Optional[pulumi.Input[_builtins.bool]] = None,
                 rpo: Optional[pulumi.Input[_builtins.int]] = None,
                 source_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DiskReplicaGroup resources.
        :param pulumi.Input[_builtins.str] description: The description of the consistent replication group.
        :param pulumi.Input[_builtins.str] destination_region_id: The ID of the region to which the disaster recovery site belongs.
        :param pulumi.Input[_builtins.str] destination_zone_id: The ID of the zone to which the disaster recovery site belongs.
        :param pulumi.Input[_builtins.str] disk_replica_group_name: Consistent replication group name.
        :param pulumi.Input[_builtins.str] group_name: . Field 'group_name' has been deprecated from provider version 1.245.0. New field 'disk_replica_group_name' instead.
        :param pulumi.Input[_builtins.bool] one_shot: Whether to synchronize immediately. Value range:
               - true: Start data synchronization immediately.
               - false: Data Synchronization starts after the RPO time period.
               
               Default value: false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pair_ids: List of replication pair IDs contained in a consistent replication group.
        :param pulumi.Input[_builtins.str] resource_group_id: resource group ID of enterprise
        :param pulumi.Input[_builtins.bool] reverse_replicate: Specifies whether to enable the reverse replication sub-feature. Valid values: true and false. Default value: true.
        :param pulumi.Input[_builtins.int] rpo: The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        :param pulumi.Input[_builtins.str] source_region_id: The ID of the region to which the production site belongs.
        :param pulumi.Input[_builtins.str] source_zone_id: The ID of the zone to which the production site belongs.
        :param pulumi.Input[_builtins.str] status: The status of the consistent replication group. Possible values:
               - invalid: invalid. This state indicates that there is an exception to the replication pair in the consistent replication group.
               - creating: creating.
               - created: created.
               - create_failed: creation failed.
               - manual_syncing: in a single synchronization. If it is the first single synchronization, this status is also displayed in the synchronization.
               - syncing: synchronization. This state is the first time data is copied asynchronously between the master and slave disks.
               - normal: normal. When data replication is completed within the current cycle of asynchronous replication, it will be in this state.
               - stopping: stopping.
               - stopped: stopped.
               - stop_failed: Stop failed.
               - Failover: failover.
               - Failed: failover completed.
               - failover_failed: failover failed.
               - Reprotection: In reverse copy operation.
               - reprotect_failed: reverse replication failed.
               - deleting: deleting.
               - delete_failed: delete failed.
               - deleted: deleted.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_region_id is not None:
            pulumi.set(__self__, "destination_region_id", destination_region_id)
        if destination_zone_id is not None:
            pulumi.set(__self__, "destination_zone_id", destination_zone_id)
        if disk_replica_group_name is not None:
            pulumi.set(__self__, "disk_replica_group_name", disk_replica_group_name)
        if group_name is not None:
            warnings.warn("""Field 'group_name' has been deprecated since provider version 1.245.0. New field 'disk_replica_group_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""group_name is deprecated: Field 'group_name' has been deprecated since provider version 1.245.0. New field 'disk_replica_group_name' instead.""")
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if one_shot is not None:
            pulumi.set(__self__, "one_shot", one_shot)
        if pair_ids is not None:
            pulumi.set(__self__, "pair_ids", pair_ids)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if reverse_replicate is not None:
            pulumi.set(__self__, "reverse_replicate", reverse_replicate)
        if rpo is not None:
            pulumi.set(__self__, "rpo", rpo)
        if source_region_id is not None:
            pulumi.set(__self__, "source_region_id", source_region_id)
        if source_zone_id is not None:
            pulumi.set(__self__, "source_zone_id", source_zone_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the consistent replication group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationRegionId")
    def destination_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_region_id")

    @destination_region_id.setter
    def destination_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_region_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationZoneId")
    def destination_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the zone to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_zone_id")

    @destination_zone_id.setter
    def destination_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="diskReplicaGroupName")
    def disk_replica_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Consistent replication group name.
        """
        return pulumi.get(self, "disk_replica_group_name")

    @disk_replica_group_name.setter
    def disk_replica_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_replica_group_name", value)

    @_builtins.property
    @pulumi.getter(name="groupName")
    @_utilities.deprecated("""Field 'group_name' has been deprecated since provider version 1.245.0. New field 'disk_replica_group_name' instead.""")
    def group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'group_name' has been deprecated from provider version 1.245.0. New field 'disk_replica_group_name' instead.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter(name="oneShot")
    def one_shot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to synchronize immediately. Value range:
        - true: Start data synchronization immediately.
        - false: Data Synchronization starts after the RPO time period.

        Default value: false.
        """
        return pulumi.get(self, "one_shot")

    @one_shot.setter
    def one_shot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "one_shot", value)

    @_builtins.property
    @pulumi.getter(name="pairIds")
    def pair_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of replication pair IDs contained in a consistent replication group.
        """
        return pulumi.get(self, "pair_ids")

    @pair_ids.setter
    def pair_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pair_ids", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        resource group ID of enterprise
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="reverseReplicate")
    def reverse_replicate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the reverse replication sub-feature. Valid values: true and false. Default value: true.
        """
        return pulumi.get(self, "reverse_replicate")

    @reverse_replicate.setter
    def reverse_replicate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reverse_replicate", value)

    @_builtins.property
    @pulumi.getter
    def rpo(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        """
        return pulumi.get(self, "rpo")

    @rpo.setter
    def rpo(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rpo", value)

    @_builtins.property
    @pulumi.getter(name="sourceRegionId")
    def source_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region to which the production site belongs.
        """
        return pulumi.get(self, "source_region_id")

    @source_region_id.setter
    def source_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_region_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceZoneId")
    def source_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the zone to which the production site belongs.
        """
        return pulumi.get(self, "source_zone_id")

    @source_zone_id.setter
    def source_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_zone_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the consistent replication group. Possible values:
        - invalid: invalid. This state indicates that there is an exception to the replication pair in the consistent replication group.
        - creating: creating.
        - created: created.
        - create_failed: creation failed.
        - manual_syncing: in a single synchronization. If it is the first single synchronization, this status is also displayed in the synchronization.
        - syncing: synchronization. This state is the first time data is copied asynchronously between the master and slave disks.
        - normal: normal. When data replication is completed within the current cycle of asynchronous replication, it will be in this state.
        - stopping: stopping.
        - stopped: stopped.
        - stop_failed: Stop failed.
        - Failover: failover.
        - Failed: failover completed.
        - failover_failed: failover failed.
        - Reprotection: In reverse copy operation.
        - reprotect_failed: reverse replication failed.
        - deleting: deleting.
        - delete_failed: delete failed.
        - deleted: deleted.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:ebs/diskReplicaGroup:DiskReplicaGroup")
class DiskReplicaGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_replica_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 one_shot: Optional[pulumi.Input[_builtins.bool]] = None,
                 pair_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse_replicate: Optional[pulumi.Input[_builtins.bool]] = None,
                 rpo: Optional[pulumi.Input[_builtins.int]] = None,
                 source_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Elastic Block Storage(EBS) Disk Replica Group resource.

        consistent replica group.

        For information about Elastic Block Storage(EBS) Disk Replica Group and how to use it, see [What is Disk Replica Group](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/creatediskreplicagroup).

        > **NOTE:** Available since v1.187.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_regions(current=True)
        default_get_regions = alicloud.ebs.get_regions(region_id=default.regions[0].id)
        default_disk_replica_group = alicloud.ebs.DiskReplicaGroup("default",
            source_region_id=default.regions[0].id,
            source_zone_id=default_get_regions.regions[0].zones[0].zone_id,
            destination_region_id=default.regions[0].id,
            destination_zone_id=default_get_regions.regions[0].zones[1].zone_id,
            group_name=name,
            description=name,
            rpo=900)
        ```

        ## Import

        Elastic Block Storage(EBS) Disk Replica Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ebs/diskReplicaGroup:DiskReplicaGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the consistent replication group.
        :param pulumi.Input[_builtins.str] destination_region_id: The ID of the region to which the disaster recovery site belongs.
        :param pulumi.Input[_builtins.str] destination_zone_id: The ID of the zone to which the disaster recovery site belongs.
        :param pulumi.Input[_builtins.str] disk_replica_group_name: Consistent replication group name.
        :param pulumi.Input[_builtins.str] group_name: . Field 'group_name' has been deprecated from provider version 1.245.0. New field 'disk_replica_group_name' instead.
        :param pulumi.Input[_builtins.bool] one_shot: Whether to synchronize immediately. Value range:
               - true: Start data synchronization immediately.
               - false: Data Synchronization starts after the RPO time period.
               
               Default value: false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pair_ids: List of replication pair IDs contained in a consistent replication group.
        :param pulumi.Input[_builtins.str] resource_group_id: resource group ID of enterprise
        :param pulumi.Input[_builtins.bool] reverse_replicate: Specifies whether to enable the reverse replication sub-feature. Valid values: true and false. Default value: true.
        :param pulumi.Input[_builtins.int] rpo: The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        :param pulumi.Input[_builtins.str] source_region_id: The ID of the region to which the production site belongs.
        :param pulumi.Input[_builtins.str] source_zone_id: The ID of the zone to which the production site belongs.
        :param pulumi.Input[_builtins.str] status: The status of the consistent replication group. Possible values:
               - invalid: invalid. This state indicates that there is an exception to the replication pair in the consistent replication group.
               - creating: creating.
               - created: created.
               - create_failed: creation failed.
               - manual_syncing: in a single synchronization. If it is the first single synchronization, this status is also displayed in the synchronization.
               - syncing: synchronization. This state is the first time data is copied asynchronously between the master and slave disks.
               - normal: normal. When data replication is completed within the current cycle of asynchronous replication, it will be in this state.
               - stopping: stopping.
               - stopped: stopped.
               - stop_failed: Stop failed.
               - Failover: failover.
               - Failed: failover completed.
               - failover_failed: failover failed.
               - Reprotection: In reverse copy operation.
               - reprotect_failed: reverse replication failed.
               - deleting: deleting.
               - delete_failed: delete failed.
               - deleted: deleted.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DiskReplicaGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Elastic Block Storage(EBS) Disk Replica Group resource.

        consistent replica group.

        For information about Elastic Block Storage(EBS) Disk Replica Group and how to use it, see [What is Disk Replica Group](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/creatediskreplicagroup).

        > **NOTE:** Available since v1.187.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_regions(current=True)
        default_get_regions = alicloud.ebs.get_regions(region_id=default.regions[0].id)
        default_disk_replica_group = alicloud.ebs.DiskReplicaGroup("default",
            source_region_id=default.regions[0].id,
            source_zone_id=default_get_regions.regions[0].zones[0].zone_id,
            destination_region_id=default.regions[0].id,
            destination_zone_id=default_get_regions.regions[0].zones[1].zone_id,
            group_name=name,
            description=name,
            rpo=900)
        ```

        ## Import

        Elastic Block Storage(EBS) Disk Replica Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ebs/diskReplicaGroup:DiskReplicaGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DiskReplicaGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiskReplicaGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_replica_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 one_shot: Optional[pulumi.Input[_builtins.bool]] = None,
                 pair_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse_replicate: Optional[pulumi.Input[_builtins.bool]] = None,
                 rpo: Optional[pulumi.Input[_builtins.int]] = None,
                 source_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiskReplicaGroupArgs.__new__(DiskReplicaGroupArgs)

            __props__.__dict__["description"] = description
            if destination_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'destination_region_id'")
            __props__.__dict__["destination_region_id"] = destination_region_id
            if destination_zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'destination_zone_id'")
            __props__.__dict__["destination_zone_id"] = destination_zone_id
            __props__.__dict__["disk_replica_group_name"] = disk_replica_group_name
            __props__.__dict__["group_name"] = group_name
            __props__.__dict__["one_shot"] = one_shot
            __props__.__dict__["pair_ids"] = pair_ids
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["reverse_replicate"] = reverse_replicate
            __props__.__dict__["rpo"] = rpo
            if source_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_region_id'")
            __props__.__dict__["source_region_id"] = source_region_id
            if source_zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_zone_id'")
            __props__.__dict__["source_zone_id"] = source_zone_id
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
        super(DiskReplicaGroup, __self__).__init__(
            'alicloud:ebs/diskReplicaGroup:DiskReplicaGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            destination_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            disk_replica_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            group_name: Optional[pulumi.Input[_builtins.str]] = None,
            one_shot: Optional[pulumi.Input[_builtins.bool]] = None,
            pair_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            reverse_replicate: Optional[pulumi.Input[_builtins.bool]] = None,
            rpo: Optional[pulumi.Input[_builtins.int]] = None,
            source_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'DiskReplicaGroup':
        """
        Get an existing DiskReplicaGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the consistent replication group.
        :param pulumi.Input[_builtins.str] destination_region_id: The ID of the region to which the disaster recovery site belongs.
        :param pulumi.Input[_builtins.str] destination_zone_id: The ID of the zone to which the disaster recovery site belongs.
        :param pulumi.Input[_builtins.str] disk_replica_group_name: Consistent replication group name.
        :param pulumi.Input[_builtins.str] group_name: . Field 'group_name' has been deprecated from provider version 1.245.0. New field 'disk_replica_group_name' instead.
        :param pulumi.Input[_builtins.bool] one_shot: Whether to synchronize immediately. Value range:
               - true: Start data synchronization immediately.
               - false: Data Synchronization starts after the RPO time period.
               
               Default value: false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pair_ids: List of replication pair IDs contained in a consistent replication group.
        :param pulumi.Input[_builtins.str] resource_group_id: resource group ID of enterprise
        :param pulumi.Input[_builtins.bool] reverse_replicate: Specifies whether to enable the reverse replication sub-feature. Valid values: true and false. Default value: true.
        :param pulumi.Input[_builtins.int] rpo: The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        :param pulumi.Input[_builtins.str] source_region_id: The ID of the region to which the production site belongs.
        :param pulumi.Input[_builtins.str] source_zone_id: The ID of the zone to which the production site belongs.
        :param pulumi.Input[_builtins.str] status: The status of the consistent replication group. Possible values:
               - invalid: invalid. This state indicates that there is an exception to the replication pair in the consistent replication group.
               - creating: creating.
               - created: created.
               - create_failed: creation failed.
               - manual_syncing: in a single synchronization. If it is the first single synchronization, this status is also displayed in the synchronization.
               - syncing: synchronization. This state is the first time data is copied asynchronously between the master and slave disks.
               - normal: normal. When data replication is completed within the current cycle of asynchronous replication, it will be in this state.
               - stopping: stopping.
               - stopped: stopped.
               - stop_failed: Stop failed.
               - Failover: failover.
               - Failed: failover completed.
               - failover_failed: failover failed.
               - Reprotection: In reverse copy operation.
               - reprotect_failed: reverse replication failed.
               - deleting: deleting.
               - delete_failed: delete failed.
               - deleted: deleted.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiskReplicaGroupState.__new__(_DiskReplicaGroupState)

        __props__.__dict__["description"] = description
        __props__.__dict__["destination_region_id"] = destination_region_id
        __props__.__dict__["destination_zone_id"] = destination_zone_id
        __props__.__dict__["disk_replica_group_name"] = disk_replica_group_name
        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["one_shot"] = one_shot
        __props__.__dict__["pair_ids"] = pair_ids
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["reverse_replicate"] = reverse_replicate
        __props__.__dict__["rpo"] = rpo
        __props__.__dict__["source_region_id"] = source_region_id
        __props__.__dict__["source_zone_id"] = source_zone_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return DiskReplicaGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the consistent replication group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationRegionId")
    def destination_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_region_id")

    @_builtins.property
    @pulumi.getter(name="destinationZoneId")
    def destination_zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the zone to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_zone_id")

    @_builtins.property
    @pulumi.getter(name="diskReplicaGroupName")
    def disk_replica_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Consistent replication group name.
        """
        return pulumi.get(self, "disk_replica_group_name")

    @_builtins.property
    @pulumi.getter(name="groupName")
    @_utilities.deprecated("""Field 'group_name' has been deprecated since provider version 1.245.0. New field 'disk_replica_group_name' instead.""")
    def group_name(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'group_name' has been deprecated from provider version 1.245.0. New field 'disk_replica_group_name' instead.
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter(name="oneShot")
    def one_shot(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to synchronize immediately. Value range:
        - true: Start data synchronization immediately.
        - false: Data Synchronization starts after the RPO time period.

        Default value: false.
        """
        return pulumi.get(self, "one_shot")

    @_builtins.property
    @pulumi.getter(name="pairIds")
    def pair_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of replication pair IDs contained in a consistent replication group.
        """
        return pulumi.get(self, "pair_ids")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        resource group ID of enterprise
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="reverseReplicate")
    def reverse_replicate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the reverse replication sub-feature. Valid values: true and false. Default value: true.
        """
        return pulumi.get(self, "reverse_replicate")

    @_builtins.property
    @pulumi.getter
    def rpo(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        """
        return pulumi.get(self, "rpo")

    @_builtins.property
    @pulumi.getter(name="sourceRegionId")
    def source_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region to which the production site belongs.
        """
        return pulumi.get(self, "source_region_id")

    @_builtins.property
    @pulumi.getter(name="sourceZoneId")
    def source_zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the zone to which the production site belongs.
        """
        return pulumi.get(self, "source_zone_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the consistent replication group. Possible values:
        - invalid: invalid. This state indicates that there is an exception to the replication pair in the consistent replication group.
        - creating: creating.
        - created: created.
        - create_failed: creation failed.
        - manual_syncing: in a single synchronization. If it is the first single synchronization, this status is also displayed in the synchronization.
        - syncing: synchronization. This state is the first time data is copied asynchronously between the master and slave disks.
        - normal: normal. When data replication is completed within the current cycle of asynchronous replication, it will be in this state.
        - stopping: stopping.
        - stopped: stopped.
        - stop_failed: Stop failed.
        - Failover: failover.
        - Failed: failover completed.
        - failover_failed: failover failed.
        - Reprotection: In reverse copy operation.
        - reprotect_failed: reverse replication failed.
        - deleting: deleting.
        - delete_failed: delete failed.
        - deleted: deleted.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "tags")

