# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SolutionInstanceArgs', 'SolutionInstance']

@pulumi.input_type
class SolutionInstanceArgs:
    def __init__(__self__, *,
                 solution_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['SolutionInstanceParameterArgs']]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 solution_instance_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SolutionInstance resource.
        :param pulumi.Input[_builtins.str] solution_id: Solution ID.
        :param pulumi.Input[_builtins.str] description: Solution Instance Description.
        :param pulumi.Input[Sequence[pulumi.Input['SolutionInstanceParameterArgs']]] parameters: Solution Instance Creation Parameters. See `parameters` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] solution_instance_name: Solution Instance Name.
        """
        pulumi.set(__self__, "solution_id", solution_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if solution_instance_name is not None:
            pulumi.set(__self__, "solution_instance_name", solution_instance_name)

    @_builtins.property
    @pulumi.getter(name="solutionId")
    def solution_id(self) -> pulumi.Input[_builtins.str]:
        """
        Solution ID.
        """
        return pulumi.get(self, "solution_id")

    @solution_id.setter
    def solution_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "solution_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Solution Instance Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SolutionInstanceParameterArgs']]]]:
        """
        Solution Instance Creation Parameters. See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SolutionInstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="solutionInstanceName")
    def solution_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Solution Instance Name.
        """
        return pulumi.get(self, "solution_instance_name")

    @solution_instance_name.setter
    def solution_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "solution_instance_name", value)


@pulumi.input_type
class _SolutionInstanceState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['SolutionInstanceParameterArgs']]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 solution_id: Optional[pulumi.Input[_builtins.str]] = None,
                 solution_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SolutionInstance resources.
        :param pulumi.Input[_builtins.str] create_time: Solution Instance Creation Time.
        :param pulumi.Input[_builtins.str] description: Solution Instance Description.
        :param pulumi.Input[Sequence[pulumi.Input['SolutionInstanceParameterArgs']]] parameters: Solution Instance Creation Parameters. See `parameters` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] solution_id: Solution ID.
        :param pulumi.Input[_builtins.str] solution_instance_name: Solution Instance Name.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if solution_id is not None:
            pulumi.set(__self__, "solution_id", solution_id)
        if solution_instance_name is not None:
            pulumi.set(__self__, "solution_instance_name", solution_instance_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Solution Instance Creation Time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Solution Instance Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SolutionInstanceParameterArgs']]]]:
        """
        Solution Instance Creation Parameters. See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SolutionInstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="solutionId")
    def solution_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Solution ID.
        """
        return pulumi.get(self, "solution_id")

    @solution_id.setter
    def solution_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "solution_id", value)

    @_builtins.property
    @pulumi.getter(name="solutionInstanceName")
    def solution_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Solution Instance Name.
        """
        return pulumi.get(self, "solution_instance_name")

    @solution_instance_name.setter
    def solution_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "solution_instance_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:ebs/solutionInstance:SolutionInstance")
class SolutionInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SolutionInstanceParameterArgs', 'SolutionInstanceParameterArgsDict']]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 solution_id: Optional[pulumi.Input[_builtins.str]] = None,
                 solution_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a EBS Solution Instance resource.

        For information about EBS Solution Instance and how to use it, see [What is Solution Instance](https://www.alibabacloud.com/help/en/).

        > **NOTE:** Available since v1.216.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        zone_id = config.get("zoneId")
        if zone_id is None:
            zone_id = "cn-shanghai-l"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-shanghai"
        default = alicloud.resourcemanager.get_resource_groups()
        default_solution_instance = alicloud.ebs.SolutionInstance("default",
            solution_instance_name=name,
            resource_group_id=default.ids[0],
            description="description",
            solution_id="mysql",
            parameters=[
                {
                    "parameter_key": "zoneId",
                    "parameter_value": zone_id,
                },
                {
                    "parameter_key": "ecsType",
                    "parameter_value": "ecs.c6.large",
                },
                {
                    "parameter_key": "ecsImageId",
                    "parameter_value": "CentOS_7",
                },
                {
                    "parameter_key": "internetMaxBandwidthOut",
                    "parameter_value": "100",
                },
                {
                    "parameter_key": "internetChargeType",
                    "parameter_value": "PayByTraffic",
                },
                {
                    "parameter_key": "ecsPassword",
                    "parameter_value": "Ebs12345",
                },
                {
                    "parameter_key": "sysDiskType",
                    "parameter_value": "cloud_essd",
                },
                {
                    "parameter_key": "sysDiskPerformance",
                    "parameter_value": "PL0",
                },
                {
                    "parameter_key": "sysDiskSize",
                    "parameter_value": "40",
                },
                {
                    "parameter_key": "dataDiskType",
                    "parameter_value": "cloud_essd",
                },
                {
                    "parameter_key": "dataDiskPerformance",
                    "parameter_value": "PL0",
                },
                {
                    "parameter_key": "dataDiskSize",
                    "parameter_value": "40",
                },
                {
                    "parameter_key": "mysqlVersion",
                    "parameter_value": "MySQL80",
                },
                {
                    "parameter_key": "mysqlUser",
                    "parameter_value": "root",
                },
                {
                    "parameter_key": "mysqlPassword",
                    "parameter_value": "Ebs12345",
                },
            ])
        ```

        ## Import

        EBS Solution Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ebs/solutionInstance:SolutionInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Solution Instance Description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SolutionInstanceParameterArgs', 'SolutionInstanceParameterArgsDict']]]] parameters: Solution Instance Creation Parameters. See `parameters` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] solution_id: Solution ID.
        :param pulumi.Input[_builtins.str] solution_instance_name: Solution Instance Name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SolutionInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a EBS Solution Instance resource.

        For information about EBS Solution Instance and how to use it, see [What is Solution Instance](https://www.alibabacloud.com/help/en/).

        > **NOTE:** Available since v1.216.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        zone_id = config.get("zoneId")
        if zone_id is None:
            zone_id = "cn-shanghai-l"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-shanghai"
        default = alicloud.resourcemanager.get_resource_groups()
        default_solution_instance = alicloud.ebs.SolutionInstance("default",
            solution_instance_name=name,
            resource_group_id=default.ids[0],
            description="description",
            solution_id="mysql",
            parameters=[
                {
                    "parameter_key": "zoneId",
                    "parameter_value": zone_id,
                },
                {
                    "parameter_key": "ecsType",
                    "parameter_value": "ecs.c6.large",
                },
                {
                    "parameter_key": "ecsImageId",
                    "parameter_value": "CentOS_7",
                },
                {
                    "parameter_key": "internetMaxBandwidthOut",
                    "parameter_value": "100",
                },
                {
                    "parameter_key": "internetChargeType",
                    "parameter_value": "PayByTraffic",
                },
                {
                    "parameter_key": "ecsPassword",
                    "parameter_value": "Ebs12345",
                },
                {
                    "parameter_key": "sysDiskType",
                    "parameter_value": "cloud_essd",
                },
                {
                    "parameter_key": "sysDiskPerformance",
                    "parameter_value": "PL0",
                },
                {
                    "parameter_key": "sysDiskSize",
                    "parameter_value": "40",
                },
                {
                    "parameter_key": "dataDiskType",
                    "parameter_value": "cloud_essd",
                },
                {
                    "parameter_key": "dataDiskPerformance",
                    "parameter_value": "PL0",
                },
                {
                    "parameter_key": "dataDiskSize",
                    "parameter_value": "40",
                },
                {
                    "parameter_key": "mysqlVersion",
                    "parameter_value": "MySQL80",
                },
                {
                    "parameter_key": "mysqlUser",
                    "parameter_value": "root",
                },
                {
                    "parameter_key": "mysqlPassword",
                    "parameter_value": "Ebs12345",
                },
            ])
        ```

        ## Import

        EBS Solution Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ebs/solutionInstance:SolutionInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param SolutionInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SolutionInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SolutionInstanceParameterArgs', 'SolutionInstanceParameterArgsDict']]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 solution_id: Optional[pulumi.Input[_builtins.str]] = None,
                 solution_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SolutionInstanceArgs.__new__(SolutionInstanceArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["resource_group_id"] = resource_group_id
            if solution_id is None and not opts.urn:
                raise TypeError("Missing required property 'solution_id'")
            __props__.__dict__["solution_id"] = solution_id
            __props__.__dict__["solution_instance_name"] = solution_instance_name
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(SolutionInstance, __self__).__init__(
            'alicloud:ebs/solutionInstance:SolutionInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SolutionInstanceParameterArgs', 'SolutionInstanceParameterArgsDict']]]]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            solution_id: Optional[pulumi.Input[_builtins.str]] = None,
            solution_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'SolutionInstance':
        """
        Get an existing SolutionInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Solution Instance Creation Time.
        :param pulumi.Input[_builtins.str] description: Solution Instance Description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SolutionInstanceParameterArgs', 'SolutionInstanceParameterArgsDict']]]] parameters: Solution Instance Creation Parameters. See `parameters` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] solution_id: Solution ID.
        :param pulumi.Input[_builtins.str] solution_instance_name: Solution Instance Name.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SolutionInstanceState.__new__(_SolutionInstanceState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["solution_id"] = solution_id
        __props__.__dict__["solution_instance_name"] = solution_instance_name
        __props__.__dict__["status"] = status
        return SolutionInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Solution Instance Creation Time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Solution Instance Description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Sequence['outputs.SolutionInstanceParameter']]]:
        """
        Solution Instance Creation Parameters. See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="solutionId")
    def solution_id(self) -> pulumi.Output[_builtins.str]:
        """
        Solution ID.
        """
        return pulumi.get(self, "solution_id")

    @_builtins.property
    @pulumi.getter(name="solutionInstanceName")
    def solution_instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        Solution Instance Name.
        """
        return pulumi.get(self, "solution_instance_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

