# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EcsImageComponentArgs', 'EcsImageComponent']

@pulumi.input_type
class EcsImageComponentArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[_builtins.str],
                 component_type: Optional[pulumi.Input[_builtins.str]] = None,
                 component_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 image_component_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a EcsImageComponent resource.
        :param pulumi.Input[_builtins.str] content: Component content. Consists of multiple commands. The maximum number of commands cannot exceed 127. Details of supported commands and command formats,
        :param pulumi.Input[_builtins.str] component_type: The component type. Supports mirrored build components and test components.
               
               Value range:
               - Build
               - Test
               
               Default value: Build.
               
               > **NOTE:**  Build components can only be used in build templates and test components can only be used in test templates.
        :param pulumi.Input[_builtins.str] component_version: The component version number, which is used in conjunction with the component name, is in the format of major.minor.patch and is a non-negative integer.
               
               Default value:(x +1).0.0, where x is the maximum major version of the current component.
        :param pulumi.Input[_builtins.str] description: Description information. It must be 2 to 256 characters in length and cannot start with http:// or https.
        :param pulumi.Input[_builtins.str] image_component_name: The component name. It must be 2 to 128 characters in length and start with an uppercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-length colons (:), underscores (_), half-length periods (.), or dashes (-).
               
               > **NOTE:**  When 'Name' is not set, the 'ImageComponentId' return value is used by default.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the enterprise resource group to which the created image component belongs.
        :param pulumi.Input[_builtins.str] system_type: The operating system supported by the component.
               
               Value range:
               - Linux
               - Windows
               
               Default value: Linux.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: List of label key-value pairs.
        """
        pulumi.set(__self__, "content", content)
        if component_type is not None:
            pulumi.set(__self__, "component_type", component_type)
        if component_version is not None:
            pulumi.set(__self__, "component_version", component_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image_component_name is not None:
            pulumi.set(__self__, "image_component_name", image_component_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if system_type is not None:
            pulumi.set(__self__, "system_type", system_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Input[_builtins.str]:
        """
        Component content. Consists of multiple commands. The maximum number of commands cannot exceed 127. Details of supported commands and command formats,
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="componentType")
    def component_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The component type. Supports mirrored build components and test components.

        Value range:
        - Build
        - Test

        Default value: Build.

        > **NOTE:**  Build components can only be used in build templates and test components can only be used in test templates.
        """
        return pulumi.get(self, "component_type")

    @component_type.setter
    def component_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "component_type", value)

    @_builtins.property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The component version number, which is used in conjunction with the component name, is in the format of major.minor.patch and is a non-negative integer.

        Default value:(x +1).0.0, where x is the maximum major version of the current component.
        """
        return pulumi.get(self, "component_version")

    @component_version.setter
    def component_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "component_version", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description information. It must be 2 to 256 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="imageComponentName")
    def image_component_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The component name. It must be 2 to 128 characters in length and start with an uppercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-length colons (:), underscores (_), half-length periods (.), or dashes (-).

        > **NOTE:**  When 'Name' is not set, the 'ImageComponentId' return value is used by default.
        """
        return pulumi.get(self, "image_component_name")

    @image_component_name.setter
    def image_component_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_component_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the enterprise resource group to which the created image component belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="systemType")
    def system_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operating system supported by the component.

        Value range:
        - Linux
        - Windows

        Default value: Linux.
        """
        return pulumi.get(self, "system_type")

    @system_type.setter
    def system_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        List of label key-value pairs.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _EcsImageComponentState:
    def __init__(__self__, *,
                 component_type: Optional[pulumi.Input[_builtins.str]] = None,
                 component_version: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 image_component_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering EcsImageComponent resources.
        :param pulumi.Input[_builtins.str] component_type: The component type. Supports mirrored build components and test components.
               
               Value range:
               - Build
               - Test
               
               Default value: Build.
               
               > **NOTE:**  Build components can only be used in build templates and test components can only be used in test templates.
        :param pulumi.Input[_builtins.str] component_version: The component version number, which is used in conjunction with the component name, is in the format of major.minor.patch and is a non-negative integer.
               
               Default value:(x +1).0.0, where x is the maximum major version of the current component.
        :param pulumi.Input[_builtins.str] content: Component content. Consists of multiple commands. The maximum number of commands cannot exceed 127. Details of supported commands and command formats,
        :param pulumi.Input[_builtins.str] create_time: Component creation time.
        :param pulumi.Input[_builtins.str] description: Description information. It must be 2 to 256 characters in length and cannot start with http:// or https.
        :param pulumi.Input[_builtins.str] image_component_name: The component name. It must be 2 to 128 characters in length and start with an uppercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-length colons (:), underscores (_), half-length periods (.), or dashes (-).
               
               > **NOTE:**  When 'Name' is not set, the 'ImageComponentId' return value is used by default.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the enterprise resource group to which the created image component belongs.
        :param pulumi.Input[_builtins.str] system_type: The operating system supported by the component.
               
               Value range:
               - Linux
               - Windows
               
               Default value: Linux.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: List of label key-value pairs.
        """
        if component_type is not None:
            pulumi.set(__self__, "component_type", component_type)
        if component_version is not None:
            pulumi.set(__self__, "component_version", component_version)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image_component_name is not None:
            pulumi.set(__self__, "image_component_name", image_component_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if system_type is not None:
            pulumi.set(__self__, "system_type", system_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="componentType")
    def component_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The component type. Supports mirrored build components and test components.

        Value range:
        - Build
        - Test

        Default value: Build.

        > **NOTE:**  Build components can only be used in build templates and test components can only be used in test templates.
        """
        return pulumi.get(self, "component_type")

    @component_type.setter
    def component_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "component_type", value)

    @_builtins.property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The component version number, which is used in conjunction with the component name, is in the format of major.minor.patch and is a non-negative integer.

        Default value:(x +1).0.0, where x is the maximum major version of the current component.
        """
        return pulumi.get(self, "component_version")

    @component_version.setter
    def component_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "component_version", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Component content. Consists of multiple commands. The maximum number of commands cannot exceed 127. Details of supported commands and command formats,
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Component creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description information. It must be 2 to 256 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="imageComponentName")
    def image_component_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The component name. It must be 2 to 128 characters in length and start with an uppercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-length colons (:), underscores (_), half-length periods (.), or dashes (-).

        > **NOTE:**  When 'Name' is not set, the 'ImageComponentId' return value is used by default.
        """
        return pulumi.get(self, "image_component_name")

    @image_component_name.setter
    def image_component_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_component_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the enterprise resource group to which the created image component belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="systemType")
    def system_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operating system supported by the component.

        Value range:
        - Linux
        - Windows

        Default value: Linux.
        """
        return pulumi.get(self, "system_type")

    @system_type.setter
    def system_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        List of label key-value pairs.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:ecs/ecsImageComponent:EcsImageComponent")
class EcsImageComponent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 component_type: Optional[pulumi.Input[_builtins.str]] = None,
                 component_version: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 image_component_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a ECS Image Component resource.

        For information about ECS Image Component and how to use it, see [What is Image Component](https://www.alibabacloud.com/help/en/doc-detail/200424.htm).

        > **NOTE:** Available since v1.159.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.resourcemanager.get_resource_groups(name_regex="default")
        example = alicloud.ecs.EcsImageComponent("example",
            component_type="Build",
            content="RUN yum update -y",
            description="example_value",
            image_component_name="example_value",
            resource_group_id=default.groups[0].id,
            system_type="Linux",
            tags={
                "Created": "TF",
            })
        ```

        ## Import

        ECS Image Component can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/ecsImageComponent:EcsImageComponent example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] component_type: The component type. Supports mirrored build components and test components.
               
               Value range:
               - Build
               - Test
               
               Default value: Build.
               
               > **NOTE:**  Build components can only be used in build templates and test components can only be used in test templates.
        :param pulumi.Input[_builtins.str] component_version: The component version number, which is used in conjunction with the component name, is in the format of major.minor.patch and is a non-negative integer.
               
               Default value:(x +1).0.0, where x is the maximum major version of the current component.
        :param pulumi.Input[_builtins.str] content: Component content. Consists of multiple commands. The maximum number of commands cannot exceed 127. Details of supported commands and command formats,
        :param pulumi.Input[_builtins.str] description: Description information. It must be 2 to 256 characters in length and cannot start with http:// or https.
        :param pulumi.Input[_builtins.str] image_component_name: The component name. It must be 2 to 128 characters in length and start with an uppercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-length colons (:), underscores (_), half-length periods (.), or dashes (-).
               
               > **NOTE:**  When 'Name' is not set, the 'ImageComponentId' return value is used by default.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the enterprise resource group to which the created image component belongs.
        :param pulumi.Input[_builtins.str] system_type: The operating system supported by the component.
               
               Value range:
               - Linux
               - Windows
               
               Default value: Linux.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: List of label key-value pairs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EcsImageComponentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECS Image Component resource.

        For information about ECS Image Component and how to use it, see [What is Image Component](https://www.alibabacloud.com/help/en/doc-detail/200424.htm).

        > **NOTE:** Available since v1.159.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.resourcemanager.get_resource_groups(name_regex="default")
        example = alicloud.ecs.EcsImageComponent("example",
            component_type="Build",
            content="RUN yum update -y",
            description="example_value",
            image_component_name="example_value",
            resource_group_id=default.groups[0].id,
            system_type="Linux",
            tags={
                "Created": "TF",
            })
        ```

        ## Import

        ECS Image Component can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/ecsImageComponent:EcsImageComponent example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EcsImageComponentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EcsImageComponentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 component_type: Optional[pulumi.Input[_builtins.str]] = None,
                 component_version: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 image_component_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EcsImageComponentArgs.__new__(EcsImageComponentArgs)

            __props__.__dict__["component_type"] = component_type
            __props__.__dict__["component_version"] = component_version
            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            __props__.__dict__["description"] = description
            __props__.__dict__["image_component_name"] = image_component_name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["system_type"] = system_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
        super(EcsImageComponent, __self__).__init__(
            'alicloud:ecs/ecsImageComponent:EcsImageComponent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            component_type: Optional[pulumi.Input[_builtins.str]] = None,
            component_version: Optional[pulumi.Input[_builtins.str]] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            image_component_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            system_type: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'EcsImageComponent':
        """
        Get an existing EcsImageComponent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] component_type: The component type. Supports mirrored build components and test components.
               
               Value range:
               - Build
               - Test
               
               Default value: Build.
               
               > **NOTE:**  Build components can only be used in build templates and test components can only be used in test templates.
        :param pulumi.Input[_builtins.str] component_version: The component version number, which is used in conjunction with the component name, is in the format of major.minor.patch and is a non-negative integer.
               
               Default value:(x +1).0.0, where x is the maximum major version of the current component.
        :param pulumi.Input[_builtins.str] content: Component content. Consists of multiple commands. The maximum number of commands cannot exceed 127. Details of supported commands and command formats,
        :param pulumi.Input[_builtins.str] create_time: Component creation time.
        :param pulumi.Input[_builtins.str] description: Description information. It must be 2 to 256 characters in length and cannot start with http:// or https.
        :param pulumi.Input[_builtins.str] image_component_name: The component name. It must be 2 to 128 characters in length and start with an uppercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-length colons (:), underscores (_), half-length periods (.), or dashes (-).
               
               > **NOTE:**  When 'Name' is not set, the 'ImageComponentId' return value is used by default.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the enterprise resource group to which the created image component belongs.
        :param pulumi.Input[_builtins.str] system_type: The operating system supported by the component.
               
               Value range:
               - Linux
               - Windows
               
               Default value: Linux.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: List of label key-value pairs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EcsImageComponentState.__new__(_EcsImageComponentState)

        __props__.__dict__["component_type"] = component_type
        __props__.__dict__["component_version"] = component_version
        __props__.__dict__["content"] = content
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["image_component_name"] = image_component_name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["system_type"] = system_type
        __props__.__dict__["tags"] = tags
        return EcsImageComponent(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="componentType")
    def component_type(self) -> pulumi.Output[_builtins.str]:
        """
        The component type. Supports mirrored build components and test components.

        Value range:
        - Build
        - Test

        Default value: Build.

        > **NOTE:**  Build components can only be used in build templates and test components can only be used in test templates.
        """
        return pulumi.get(self, "component_type")

    @_builtins.property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> pulumi.Output[_builtins.str]:
        """
        The component version number, which is used in conjunction with the component name, is in the format of major.minor.patch and is a non-negative integer.

        Default value:(x +1).0.0, where x is the maximum major version of the current component.
        """
        return pulumi.get(self, "component_version")

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[_builtins.str]:
        """
        Component content. Consists of multiple commands. The maximum number of commands cannot exceed 127. Details of supported commands and command formats,
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Component creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description information. It must be 2 to 256 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="imageComponentName")
    def image_component_name(self) -> pulumi.Output[_builtins.str]:
        """
        The component name. It must be 2 to 128 characters in length and start with an uppercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-length colons (:), underscores (_), half-length periods (.), or dashes (-).

        > **NOTE:**  When 'Name' is not set, the 'ImageComponentId' return value is used by default.
        """
        return pulumi.get(self, "image_component_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the enterprise resource group to which the created image component belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="systemType")
    def system_type(self) -> pulumi.Output[_builtins.str]:
        """
        The operating system supported by the component.

        Value range:
        - Linux
        - Windows

        Default value: Linux.
        """
        return pulumi.get(self, "system_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        List of label key-value pairs.
        """
        return pulumi.get(self, "tags")

