# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EcsNetworkInterfacePermissionArgs', 'EcsNetworkInterfacePermission']

@pulumi.input_type
class EcsNetworkInterfacePermissionArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 network_interface_id: pulumi.Input[_builtins.str],
                 permission: pulumi.Input[_builtins.str],
                 force: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a EcsNetworkInterfacePermission resource.
        :param pulumi.Input[_builtins.str] account_id: Alibaba Cloud Partner (Certified ISV) account ID or individual user ID.
        :param pulumi.Input[_builtins.str] network_interface_id: The ID of the network interface.
        :param pulumi.Input[_builtins.str] permission: The permissions of the Network Interface. Valid values: `InstanceAttach`. `InstanceAttach`: Allows authorized users to mount your ENI to the other ECS instance. The ECS instance must be in the same zone as the ENI.
        :param pulumi.Input[_builtins.bool] force: Whether to force deletion of Network Interface Permission. Default value: `true`.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "permission", permission)
        if force is not None:
            pulumi.set(__self__, "force", force)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Alibaba Cloud Partner (Certified ISV) account ID or individual user ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the network interface.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_interface_id", value)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> pulumi.Input[_builtins.str]:
        """
        The permissions of the Network Interface. Valid values: `InstanceAttach`. `InstanceAttach`: Allows authorized users to mount your ENI to the other ECS instance. The ECS instance must be in the same zone as the ENI.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "permission", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to force deletion of Network Interface Permission. Default value: `true`.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)


@pulumi.input_type
class _EcsNetworkInterfacePermissionState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 permission: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EcsNetworkInterfacePermission resources.
        :param pulumi.Input[_builtins.str] account_id: Alibaba Cloud Partner (Certified ISV) account ID or individual user ID.
        :param pulumi.Input[_builtins.bool] force: Whether to force deletion of Network Interface Permission. Default value: `true`.
        :param pulumi.Input[_builtins.str] network_interface_id: The ID of the network interface.
        :param pulumi.Input[_builtins.str] permission: The permissions of the Network Interface. Valid values: `InstanceAttach`. `InstanceAttach`: Allows authorized users to mount your ENI to the other ECS instance. The ECS instance must be in the same zone as the ENI.
        :param pulumi.Input[_builtins.str] status: The Status of the Network Interface Permissions. Valid values: `Pending`, `Granted`, `Revoking`, `Revoked`.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alibaba Cloud Partner (Certified ISV) account ID or individual user ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to force deletion of Network Interface Permission. Default value: `true`.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the network interface.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_interface_id", value)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The permissions of the Network Interface. Valid values: `InstanceAttach`. `InstanceAttach`: Allows authorized users to mount your ENI to the other ECS instance. The ECS instance must be in the same zone as the ENI.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permission", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Status of the Network Interface Permissions. Valid values: `Pending`, `Granted`, `Revoking`, `Revoked`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:ecs/ecsNetworkInterfacePermission:EcsNetworkInterfacePermission")
class EcsNetworkInterfacePermission(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 permission: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ECS Network Interface Permission resource.

        For information about ECS Network Interface Permission and how to use it, see [What is Network Interface Permission](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/elastic-network-interfaces-overview).

        > **NOTE:** Available since v1.166.0.

        ## Import

        ECS Network Interface Permission can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/ecsNetworkInterfacePermission:EcsNetworkInterfacePermission example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Alibaba Cloud Partner (Certified ISV) account ID or individual user ID.
        :param pulumi.Input[_builtins.bool] force: Whether to force deletion of Network Interface Permission. Default value: `true`.
        :param pulumi.Input[_builtins.str] network_interface_id: The ID of the network interface.
        :param pulumi.Input[_builtins.str] permission: The permissions of the Network Interface. Valid values: `InstanceAttach`. `InstanceAttach`: Allows authorized users to mount your ENI to the other ECS instance. The ECS instance must be in the same zone as the ENI.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EcsNetworkInterfacePermissionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECS Network Interface Permission resource.

        For information about ECS Network Interface Permission and how to use it, see [What is Network Interface Permission](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/elastic-network-interfaces-overview).

        > **NOTE:** Available since v1.166.0.

        ## Import

        ECS Network Interface Permission can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/ecsNetworkInterfacePermission:EcsNetworkInterfacePermission example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EcsNetworkInterfacePermissionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EcsNetworkInterfacePermissionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 permission: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EcsNetworkInterfacePermissionArgs.__new__(EcsNetworkInterfacePermissionArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["force"] = force
            if network_interface_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_interface_id'")
            __props__.__dict__["network_interface_id"] = network_interface_id
            if permission is None and not opts.urn:
                raise TypeError("Missing required property 'permission'")
            __props__.__dict__["permission"] = permission
            __props__.__dict__["status"] = None
        super(EcsNetworkInterfacePermission, __self__).__init__(
            'alicloud:ecs/ecsNetworkInterfacePermission:EcsNetworkInterfacePermission',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            force: Optional[pulumi.Input[_builtins.bool]] = None,
            network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
            permission: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'EcsNetworkInterfacePermission':
        """
        Get an existing EcsNetworkInterfacePermission resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Alibaba Cloud Partner (Certified ISV) account ID or individual user ID.
        :param pulumi.Input[_builtins.bool] force: Whether to force deletion of Network Interface Permission. Default value: `true`.
        :param pulumi.Input[_builtins.str] network_interface_id: The ID of the network interface.
        :param pulumi.Input[_builtins.str] permission: The permissions of the Network Interface. Valid values: `InstanceAttach`. `InstanceAttach`: Allows authorized users to mount your ENI to the other ECS instance. The ECS instance must be in the same zone as the ENI.
        :param pulumi.Input[_builtins.str] status: The Status of the Network Interface Permissions. Valid values: `Pending`, `Granted`, `Revoking`, `Revoked`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EcsNetworkInterfacePermissionState.__new__(_EcsNetworkInterfacePermissionState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["force"] = force
        __props__.__dict__["network_interface_id"] = network_interface_id
        __props__.__dict__["permission"] = permission
        __props__.__dict__["status"] = status
        return EcsNetworkInterfacePermission(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Alibaba Cloud Partner (Certified ISV) account ID or individual user ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to force deletion of Network Interface Permission. Default value: `true`.
        """
        return pulumi.get(self, "force")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the network interface.
        """
        return pulumi.get(self, "network_interface_id")

    @_builtins.property
    @pulumi.getter
    def permission(self) -> pulumi.Output[_builtins.str]:
        """
        The permissions of the Network Interface. Valid values: `InstanceAttach`. `InstanceAttach`: Allows authorized users to mount your ENI to the other ECS instance. The ECS instance must be in the same zone as the ENI.
        """
        return pulumi.get(self, "permission")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The Status of the Network Interface Permissions. Valid values: `Pending`, `Granted`, `Revoking`, `Revoked`.
        """
        return pulumi.get(self, "status")

