# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EipAddressArgs', 'EipAddress']

@pulumi.input_type
class EipAddressArgs:
    def __init__(__self__, *,
                 activity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 address_name: Optional[pulumi.Input[_builtins.str]] = None,
                 allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 high_definition_monitor_log_status: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 log_project: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 netmode: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EipAddress resource.
        :param pulumi.Input[_builtins.str] activity_id: The promotion code. This parameter is not required.
        :param pulumi.Input[_builtins.str] address_name: The EIP name.
               
               The name must be 1 to 128 characters in length and start with a letter, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-).
               
               > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
        :param pulumi.Input[_builtins.str] allocation_id: The ID of the EIP instance.
        :param pulumi.Input[_builtins.bool] auto_pay: Specifies whether to enable automatic payment. Valid values:
        :param pulumi.Input[_builtins.str] bandwidth: The maximum bandwidth of the specified EIP. Unit: Mbit/s.
               - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByBandwidth`, valid values for `bandwidth` are `1` to `500`.
               - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByTraffic`, valid values for `bandwidth` are `1` to `200`.
               - When `payment_type` is set to `Subscription`, valid values for `bandwidth` are `1` to `1000`.
               
               Default value: `5` Mbit /s.
        :param pulumi.Input[_builtins.bool] deletion_protection: Specifies whether to enable deletion protection. Valid values:
        :param pulumi.Input[_builtins.str] description: The description of the EIP.
               
               The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
               
               > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
        :param pulumi.Input[_builtins.str] high_definition_monitor_log_status: The status of fine-grained monitoring. Valid values:
               - `ON`
               - `OFF`
        :param pulumi.Input[_builtins.str] instance_charge_type: . Field 'instance_charge_type' has been deprecated from provider version 1.126.0. New field 'payment_type' instead.
        :param pulumi.Input[_builtins.str] internet_charge_type: The metering method of the EIP. Valid values:
               - `PayByBandwidth` (default): pay-by-bandwidth.
               - `PayByTraffic`: pay-by-data-transfer.
               
               When `payment_type` is set to `Subscription`, you must set `internet_charge_type` to `PayByBandwidth`.
               
               When `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
        :param pulumi.Input[_builtins.str] ip_address: The IP address of the EIP. Supports a maximum of 50 EIPs.
        :param pulumi.Input[_builtins.str] isp: The line type. Valid values:
               - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
               - `BGP_PRO`: BGP (Multi-ISP) Pro line The BGP (Multi-ISP) Pro line is supported in the China (Hong Kong), Singapore, Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.
               
               For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see the "Line types" section of [What is EIP?](https://www.alibabacloud.com/help/en/doc-detail/32321.html)
               
               If you are allowed to use single-ISP bandwidth, you can also choose one of the following values:
               - `ChinaTelecom`
               - `ChinaUnicom`
               - `ChinaMobile`
               - `ChinaTelecom_L2`
               - `ChinaUnicom_L2`
               - `ChinaMobile_L2`
               
               If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
        :param pulumi.Input[_builtins.str] log_project: The name of the Simple Log Service (SLS) project.
        :param pulumi.Input[_builtins.str] log_store: The name of the Logstore.
        :param pulumi.Input[_builtins.str] mode: The association mode. Valid values:
               - `NAT` (default): NAT mode
               - `MULTI_BINDED`: multi-EIP-to-ENI mode
               - `BINDED`: cut-network interface controller mode
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.126.0. New field 'address_name' instead.
        :param pulumi.Input[_builtins.str] netmode: The network type. By default, this value is set to `public`, which specifies the public network type.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the EIP. Valid values:
               - `Subscription`: subscription
               - `PayAsYouGo` (default): pay-as-you-go
               
               If `payment_type` is set to `Subscription`, set `internet_charge_type` to `PayByBandwidth`. If `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
        :param pulumi.Input[_builtins.int] period: Duration of purchase. When the value of `pricing_cycle` is `Month`, the value range of `period` is `1` to `9`. When the value of `pricing_cycle` is `Year`, the value range of `period` is `1` to `5`. If the value of the `payment_type` parameter is `Subscription`, this parameter is required. If the value of the `payment_type` parameter is `PayAsYouGo`, this parameter is left blank.
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the subscription EIP. Valid values:
               - `Month` (default)
               - `Year`
               
               If `payment_type` is set to `Subscription`, this parameter is required. If `payment_type` is set to `PayAsYouGo`, this parameter is not required.
        :param pulumi.Input[_builtins.str] public_ip_address_pool_id: The ID of the IP address pool. The EIP is allocated from the IP address pool. By default, the IP address pool feature is unavailable. To use the IP address pool, apply for the privilege in the Quota Center console. For more information, see the "Request a quota increase in the Quota Center console" section in [Manage EIP quotas](https://www.alibabacloud.com/help/en/doc-detail/108213.html).
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which you want to move the resource.
               
               > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_protection_types: Security protection level.
               - When the return is empty, the basic DDoS protection is specified.
               - When `antidos_enhanced` is returned, it indicates DDoS protection (enhanced version).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] zone: The zone of the EIP. When the service type of the IP address pool specified by `PublicIpAddressPoolId` is CloudBox, the default value is the zone of the IP address pool. For more information, see [ListPublicIpAddressPools](https://www.alibabacloud.com/help/en/doc-detail/429433.html). 
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if activity_id is not None:
            pulumi.set(__self__, "activity_id", activity_id)
        if address_name is not None:
            pulumi.set(__self__, "address_name", address_name)
        if allocation_id is not None:
            pulumi.set(__self__, "allocation_id", allocation_id)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if high_definition_monitor_log_status is not None:
            pulumi.set(__self__, "high_definition_monitor_log_status", high_definition_monitor_log_status)
        if instance_charge_type is not None:
            warnings.warn("""Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""", DeprecationWarning)
            pulumi.log.warn("""instance_charge_type is deprecated: Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""")
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if log_project is not None:
            pulumi.set(__self__, "log_project", log_project)
        if log_store is not None:
            pulumi.set(__self__, "log_store", log_store)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if netmode is not None:
            pulumi.set(__self__, "netmode", netmode)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if public_ip_address_pool_id is not None:
            pulumi.set(__self__, "public_ip_address_pool_id", public_ip_address_pool_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_protection_types is not None:
            pulumi.set(__self__, "security_protection_types", security_protection_types)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="activityId")
    def activity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The promotion code. This parameter is not required.
        """
        return pulumi.get(self, "activity_id")

    @activity_id.setter
    def activity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "activity_id", value)

    @_builtins.property
    @pulumi.getter(name="addressName")
    def address_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EIP name.

        The name must be 1 to 128 characters in length and start with a letter, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-).

        > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
        """
        return pulumi.get(self, "address_name")

    @address_name.setter
    def address_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_name", value)

    @_builtins.property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the EIP instance.
        """
        return pulumi.get(self, "allocation_id")

    @allocation_id.setter
    def allocation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allocation_id", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable automatic payment. Valid values:
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum bandwidth of the specified EIP. Unit: Mbit/s.
        - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByBandwidth`, valid values for `bandwidth` are `1` to `500`.
        - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByTraffic`, valid values for `bandwidth` are `1` to `200`.
        - When `payment_type` is set to `Subscription`, valid values for `bandwidth` are `1` to `1000`.

        Default value: `5` Mbit /s.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable deletion protection. Valid values:
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the EIP.

        The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.

        > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="highDefinitionMonitorLogStatus")
    def high_definition_monitor_log_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of fine-grained monitoring. Valid values:
        - `ON`
        - `OFF`
        """
        return pulumi.get(self, "high_definition_monitor_log_status")

    @high_definition_monitor_log_status.setter
    def high_definition_monitor_log_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "high_definition_monitor_log_status", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    @_utilities.deprecated("""Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'instance_charge_type' has been deprecated from provider version 1.126.0. New field 'payment_type' instead.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The metering method of the EIP. Valid values:
        - `PayByBandwidth` (default): pay-by-bandwidth.
        - `PayByTraffic`: pay-by-data-transfer.

        When `payment_type` is set to `Subscription`, you must set `internet_charge_type` to `PayByBandwidth`.

        When `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the EIP. Supports a maximum of 50 EIPs.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The line type. Valid values:
        - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
        - `BGP_PRO`: BGP (Multi-ISP) Pro line The BGP (Multi-ISP) Pro line is supported in the China (Hong Kong), Singapore, Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.

        For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see the "Line types" section of [What is EIP?](https://www.alibabacloud.com/help/en/doc-detail/32321.html)

        If you are allowed to use single-ISP bandwidth, you can also choose one of the following values:
        - `ChinaTelecom`
        - `ChinaUnicom`
        - `ChinaMobile`
        - `ChinaTelecom_L2`
        - `ChinaUnicom_L2`
        - `ChinaMobile_L2`

        If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isp", value)

    @_builtins.property
    @pulumi.getter(name="logProject")
    def log_project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Simple Log Service (SLS) project.
        """
        return pulumi.get(self, "log_project")

    @log_project.setter
    def log_project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_project", value)

    @_builtins.property
    @pulumi.getter(name="logStore")
    def log_store(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Logstore.
        """
        return pulumi.get(self, "log_store")

    @log_store.setter
    def log_store(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_store", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The association mode. Valid values:
        - `NAT` (default): NAT mode
        - `MULTI_BINDED`: multi-EIP-to-ENI mode
        - `BINDED`: cut-network interface controller mode
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.126.0. New field 'address_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def netmode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type. By default, this value is set to `public`, which specifies the public network type.
        """
        return pulumi.get(self, "netmode")

    @netmode.setter
    def netmode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "netmode", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the EIP. Valid values:
        - `Subscription`: subscription
        - `PayAsYouGo` (default): pay-as-you-go

        If `payment_type` is set to `Subscription`, set `internet_charge_type` to `PayByBandwidth`. If `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration of purchase. When the value of `pricing_cycle` is `Month`, the value range of `period` is `1` to `9`. When the value of `pricing_cycle` is `Year`, the value range of `period` is `1` to `5`. If the value of the `payment_type` parameter is `Subscription`, this parameter is required. If the value of the `payment_type` parameter is `PayAsYouGo`, this parameter is left blank.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing cycle of the subscription EIP. Valid values:
        - `Month` (default)
        - `Year`

        If `payment_type` is set to `Subscription`, this parameter is required. If `payment_type` is set to `PayAsYouGo`, this parameter is not required.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="publicIpAddressPoolId")
    def public_ip_address_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IP address pool. The EIP is allocated from the IP address pool. By default, the IP address pool feature is unavailable. To use the IP address pool, apply for the privilege in the Quota Center console. For more information, see the "Request a quota increase in the Quota Center console" section in [Manage EIP quotas](https://www.alibabacloud.com/help/en/doc-detail/108213.html).
        """
        return pulumi.get(self, "public_ip_address_pool_id")

    @public_ip_address_pool_id.setter
    def public_ip_address_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_address_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which you want to move the resource.

        > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityProtectionTypes")
    def security_protection_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Security protection level.
        - When the return is empty, the basic DDoS protection is specified.
        - When `antidos_enhanced` is returned, it indicates DDoS protection (enhanced version).
        """
        return pulumi.get(self, "security_protection_types")

    @security_protection_types.setter
    def security_protection_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_protection_types", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone of the EIP. When the service type of the IP address pool specified by `PublicIpAddressPoolId` is CloudBox, the default value is the zone of the IP address pool. For more information, see [ListPublicIpAddressPools](https://www.alibabacloud.com/help/en/doc-detail/429433.html). 

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _EipAddressState:
    def __init__(__self__, *,
                 activity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 address_name: Optional[pulumi.Input[_builtins.str]] = None,
                 allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 high_definition_monitor_log_status: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 log_project: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 netmode: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EipAddress resources.
        :param pulumi.Input[_builtins.str] activity_id: The promotion code. This parameter is not required.
        :param pulumi.Input[_builtins.str] address_name: The EIP name.
               
               The name must be 1 to 128 characters in length and start with a letter, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-).
               
               > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
        :param pulumi.Input[_builtins.str] allocation_id: The ID of the EIP instance.
        :param pulumi.Input[_builtins.bool] auto_pay: Specifies whether to enable automatic payment. Valid values:
        :param pulumi.Input[_builtins.str] bandwidth: The maximum bandwidth of the specified EIP. Unit: Mbit/s.
               - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByBandwidth`, valid values for `bandwidth` are `1` to `500`.
               - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByTraffic`, valid values for `bandwidth` are `1` to `200`.
               - When `payment_type` is set to `Subscription`, valid values for `bandwidth` are `1` to `1000`.
               
               Default value: `5` Mbit /s.
        :param pulumi.Input[_builtins.str] create_time: The time when the EIP was created.
        :param pulumi.Input[_builtins.bool] deletion_protection: Specifies whether to enable deletion protection. Valid values:
        :param pulumi.Input[_builtins.str] description: The description of the EIP.
               
               The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
               
               > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
        :param pulumi.Input[_builtins.str] high_definition_monitor_log_status: The status of fine-grained monitoring. Valid values:
               - `ON`
               - `OFF`
        :param pulumi.Input[_builtins.str] instance_charge_type: . Field 'instance_charge_type' has been deprecated from provider version 1.126.0. New field 'payment_type' instead.
        :param pulumi.Input[_builtins.str] internet_charge_type: The metering method of the EIP. Valid values:
               - `PayByBandwidth` (default): pay-by-bandwidth.
               - `PayByTraffic`: pay-by-data-transfer.
               
               When `payment_type` is set to `Subscription`, you must set `internet_charge_type` to `PayByBandwidth`.
               
               When `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
        :param pulumi.Input[_builtins.str] ip_address: The IP address of the EIP. Supports a maximum of 50 EIPs.
        :param pulumi.Input[_builtins.str] isp: The line type. Valid values:
               - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
               - `BGP_PRO`: BGP (Multi-ISP) Pro line The BGP (Multi-ISP) Pro line is supported in the China (Hong Kong), Singapore, Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.
               
               For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see the "Line types" section of [What is EIP?](https://www.alibabacloud.com/help/en/doc-detail/32321.html)
               
               If you are allowed to use single-ISP bandwidth, you can also choose one of the following values:
               - `ChinaTelecom`
               - `ChinaUnicom`
               - `ChinaMobile`
               - `ChinaTelecom_L2`
               - `ChinaUnicom_L2`
               - `ChinaMobile_L2`
               
               If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
        :param pulumi.Input[_builtins.str] log_project: The name of the Simple Log Service (SLS) project.
        :param pulumi.Input[_builtins.str] log_store: The name of the Logstore.
        :param pulumi.Input[_builtins.str] mode: The association mode. Valid values:
               - `NAT` (default): NAT mode
               - `MULTI_BINDED`: multi-EIP-to-ENI mode
               - `BINDED`: cut-network interface controller mode
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.126.0. New field 'address_name' instead.
        :param pulumi.Input[_builtins.str] netmode: The network type. By default, this value is set to `public`, which specifies the public network type.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the EIP. Valid values:
               - `Subscription`: subscription
               - `PayAsYouGo` (default): pay-as-you-go
               
               If `payment_type` is set to `Subscription`, set `internet_charge_type` to `PayByBandwidth`. If `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
        :param pulumi.Input[_builtins.int] period: Duration of purchase. When the value of `pricing_cycle` is `Month`, the value range of `period` is `1` to `9`. When the value of `pricing_cycle` is `Year`, the value range of `period` is `1` to `5`. If the value of the `payment_type` parameter is `Subscription`, this parameter is required. If the value of the `payment_type` parameter is `PayAsYouGo`, this parameter is left blank.
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the subscription EIP. Valid values:
               - `Month` (default)
               - `Year`
               
               If `payment_type` is set to `Subscription`, this parameter is required. If `payment_type` is set to `PayAsYouGo`, this parameter is not required.
        :param pulumi.Input[_builtins.str] public_ip_address_pool_id: The ID of the IP address pool. The EIP is allocated from the IP address pool. By default, the IP address pool feature is unavailable. To use the IP address pool, apply for the privilege in the Quota Center console. For more information, see the "Request a quota increase in the Quota Center console" section in [Manage EIP quotas](https://www.alibabacloud.com/help/en/doc-detail/108213.html).
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which you want to move the resource.
               
               > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_protection_types: Security protection level.
               - When the return is empty, the basic DDoS protection is specified.
               - When `antidos_enhanced` is returned, it indicates DDoS protection (enhanced version).
        :param pulumi.Input[_builtins.str] status: The state of the EIP.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] zone: The zone of the EIP. When the service type of the IP address pool specified by `PublicIpAddressPoolId` is CloudBox, the default value is the zone of the IP address pool. For more information, see [ListPublicIpAddressPools](https://www.alibabacloud.com/help/en/doc-detail/429433.html). 
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if activity_id is not None:
            pulumi.set(__self__, "activity_id", activity_id)
        if address_name is not None:
            pulumi.set(__self__, "address_name", address_name)
        if allocation_id is not None:
            pulumi.set(__self__, "allocation_id", allocation_id)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if high_definition_monitor_log_status is not None:
            pulumi.set(__self__, "high_definition_monitor_log_status", high_definition_monitor_log_status)
        if instance_charge_type is not None:
            warnings.warn("""Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""", DeprecationWarning)
            pulumi.log.warn("""instance_charge_type is deprecated: Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""")
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if log_project is not None:
            pulumi.set(__self__, "log_project", log_project)
        if log_store is not None:
            pulumi.set(__self__, "log_store", log_store)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if netmode is not None:
            pulumi.set(__self__, "netmode", netmode)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if public_ip_address_pool_id is not None:
            pulumi.set(__self__, "public_ip_address_pool_id", public_ip_address_pool_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_protection_types is not None:
            pulumi.set(__self__, "security_protection_types", security_protection_types)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="activityId")
    def activity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The promotion code. This parameter is not required.
        """
        return pulumi.get(self, "activity_id")

    @activity_id.setter
    def activity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "activity_id", value)

    @_builtins.property
    @pulumi.getter(name="addressName")
    def address_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EIP name.

        The name must be 1 to 128 characters in length and start with a letter, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-).

        > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
        """
        return pulumi.get(self, "address_name")

    @address_name.setter
    def address_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_name", value)

    @_builtins.property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the EIP instance.
        """
        return pulumi.get(self, "allocation_id")

    @allocation_id.setter
    def allocation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allocation_id", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable automatic payment. Valid values:
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum bandwidth of the specified EIP. Unit: Mbit/s.
        - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByBandwidth`, valid values for `bandwidth` are `1` to `500`.
        - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByTraffic`, valid values for `bandwidth` are `1` to `200`.
        - When `payment_type` is set to `Subscription`, valid values for `bandwidth` are `1` to `1000`.

        Default value: `5` Mbit /s.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the EIP was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable deletion protection. Valid values:
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the EIP.

        The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.

        > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="highDefinitionMonitorLogStatus")
    def high_definition_monitor_log_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of fine-grained monitoring. Valid values:
        - `ON`
        - `OFF`
        """
        return pulumi.get(self, "high_definition_monitor_log_status")

    @high_definition_monitor_log_status.setter
    def high_definition_monitor_log_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "high_definition_monitor_log_status", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    @_utilities.deprecated("""Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'instance_charge_type' has been deprecated from provider version 1.126.0. New field 'payment_type' instead.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The metering method of the EIP. Valid values:
        - `PayByBandwidth` (default): pay-by-bandwidth.
        - `PayByTraffic`: pay-by-data-transfer.

        When `payment_type` is set to `Subscription`, you must set `internet_charge_type` to `PayByBandwidth`.

        When `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the EIP. Supports a maximum of 50 EIPs.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The line type. Valid values:
        - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
        - `BGP_PRO`: BGP (Multi-ISP) Pro line The BGP (Multi-ISP) Pro line is supported in the China (Hong Kong), Singapore, Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.

        For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see the "Line types" section of [What is EIP?](https://www.alibabacloud.com/help/en/doc-detail/32321.html)

        If you are allowed to use single-ISP bandwidth, you can also choose one of the following values:
        - `ChinaTelecom`
        - `ChinaUnicom`
        - `ChinaMobile`
        - `ChinaTelecom_L2`
        - `ChinaUnicom_L2`
        - `ChinaMobile_L2`

        If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isp", value)

    @_builtins.property
    @pulumi.getter(name="logProject")
    def log_project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Simple Log Service (SLS) project.
        """
        return pulumi.get(self, "log_project")

    @log_project.setter
    def log_project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_project", value)

    @_builtins.property
    @pulumi.getter(name="logStore")
    def log_store(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Logstore.
        """
        return pulumi.get(self, "log_store")

    @log_store.setter
    def log_store(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_store", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The association mode. Valid values:
        - `NAT` (default): NAT mode
        - `MULTI_BINDED`: multi-EIP-to-ENI mode
        - `BINDED`: cut-network interface controller mode
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.126.0. New field 'address_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def netmode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type. By default, this value is set to `public`, which specifies the public network type.
        """
        return pulumi.get(self, "netmode")

    @netmode.setter
    def netmode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "netmode", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the EIP. Valid values:
        - `Subscription`: subscription
        - `PayAsYouGo` (default): pay-as-you-go

        If `payment_type` is set to `Subscription`, set `internet_charge_type` to `PayByBandwidth`. If `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration of purchase. When the value of `pricing_cycle` is `Month`, the value range of `period` is `1` to `9`. When the value of `pricing_cycle` is `Year`, the value range of `period` is `1` to `5`. If the value of the `payment_type` parameter is `Subscription`, this parameter is required. If the value of the `payment_type` parameter is `PayAsYouGo`, this parameter is left blank.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing cycle of the subscription EIP. Valid values:
        - `Month` (default)
        - `Year`

        If `payment_type` is set to `Subscription`, this parameter is required. If `payment_type` is set to `PayAsYouGo`, this parameter is not required.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="publicIpAddressPoolId")
    def public_ip_address_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IP address pool. The EIP is allocated from the IP address pool. By default, the IP address pool feature is unavailable. To use the IP address pool, apply for the privilege in the Quota Center console. For more information, see the "Request a quota increase in the Quota Center console" section in [Manage EIP quotas](https://www.alibabacloud.com/help/en/doc-detail/108213.html).
        """
        return pulumi.get(self, "public_ip_address_pool_id")

    @public_ip_address_pool_id.setter
    def public_ip_address_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_address_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which you want to move the resource.

        > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityProtectionTypes")
    def security_protection_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Security protection level.
        - When the return is empty, the basic DDoS protection is specified.
        - When `antidos_enhanced` is returned, it indicates DDoS protection (enhanced version).
        """
        return pulumi.get(self, "security_protection_types")

    @security_protection_types.setter
    def security_protection_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_protection_types", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the EIP.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone of the EIP. When the service type of the IP address pool specified by `PublicIpAddressPoolId` is CloudBox, the default value is the zone of the IP address pool. For more information, see [ListPublicIpAddressPools](https://www.alibabacloud.com/help/en/doc-detail/429433.html). 

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("alicloud:ecs/eipAddress:EipAddress")
class EipAddress(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 address_name: Optional[pulumi.Input[_builtins.str]] = None,
                 allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 high_definition_monitor_log_status: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 log_project: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 netmode: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        EIP Address can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/eipAddress:EipAddress example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] activity_id: The promotion code. This parameter is not required.
        :param pulumi.Input[_builtins.str] address_name: The EIP name.
               
               The name must be 1 to 128 characters in length and start with a letter, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-).
               
               > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
        :param pulumi.Input[_builtins.str] allocation_id: The ID of the EIP instance.
        :param pulumi.Input[_builtins.bool] auto_pay: Specifies whether to enable automatic payment. Valid values:
        :param pulumi.Input[_builtins.str] bandwidth: The maximum bandwidth of the specified EIP. Unit: Mbit/s.
               - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByBandwidth`, valid values for `bandwidth` are `1` to `500`.
               - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByTraffic`, valid values for `bandwidth` are `1` to `200`.
               - When `payment_type` is set to `Subscription`, valid values for `bandwidth` are `1` to `1000`.
               
               Default value: `5` Mbit /s.
        :param pulumi.Input[_builtins.bool] deletion_protection: Specifies whether to enable deletion protection. Valid values:
        :param pulumi.Input[_builtins.str] description: The description of the EIP.
               
               The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
               
               > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
        :param pulumi.Input[_builtins.str] high_definition_monitor_log_status: The status of fine-grained monitoring. Valid values:
               - `ON`
               - `OFF`
        :param pulumi.Input[_builtins.str] instance_charge_type: . Field 'instance_charge_type' has been deprecated from provider version 1.126.0. New field 'payment_type' instead.
        :param pulumi.Input[_builtins.str] internet_charge_type: The metering method of the EIP. Valid values:
               - `PayByBandwidth` (default): pay-by-bandwidth.
               - `PayByTraffic`: pay-by-data-transfer.
               
               When `payment_type` is set to `Subscription`, you must set `internet_charge_type` to `PayByBandwidth`.
               
               When `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
        :param pulumi.Input[_builtins.str] ip_address: The IP address of the EIP. Supports a maximum of 50 EIPs.
        :param pulumi.Input[_builtins.str] isp: The line type. Valid values:
               - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
               - `BGP_PRO`: BGP (Multi-ISP) Pro line The BGP (Multi-ISP) Pro line is supported in the China (Hong Kong), Singapore, Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.
               
               For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see the "Line types" section of [What is EIP?](https://www.alibabacloud.com/help/en/doc-detail/32321.html)
               
               If you are allowed to use single-ISP bandwidth, you can also choose one of the following values:
               - `ChinaTelecom`
               - `ChinaUnicom`
               - `ChinaMobile`
               - `ChinaTelecom_L2`
               - `ChinaUnicom_L2`
               - `ChinaMobile_L2`
               
               If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
        :param pulumi.Input[_builtins.str] log_project: The name of the Simple Log Service (SLS) project.
        :param pulumi.Input[_builtins.str] log_store: The name of the Logstore.
        :param pulumi.Input[_builtins.str] mode: The association mode. Valid values:
               - `NAT` (default): NAT mode
               - `MULTI_BINDED`: multi-EIP-to-ENI mode
               - `BINDED`: cut-network interface controller mode
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.126.0. New field 'address_name' instead.
        :param pulumi.Input[_builtins.str] netmode: The network type. By default, this value is set to `public`, which specifies the public network type.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the EIP. Valid values:
               - `Subscription`: subscription
               - `PayAsYouGo` (default): pay-as-you-go
               
               If `payment_type` is set to `Subscription`, set `internet_charge_type` to `PayByBandwidth`. If `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
        :param pulumi.Input[_builtins.int] period: Duration of purchase. When the value of `pricing_cycle` is `Month`, the value range of `period` is `1` to `9`. When the value of `pricing_cycle` is `Year`, the value range of `period` is `1` to `5`. If the value of the `payment_type` parameter is `Subscription`, this parameter is required. If the value of the `payment_type` parameter is `PayAsYouGo`, this parameter is left blank.
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the subscription EIP. Valid values:
               - `Month` (default)
               - `Year`
               
               If `payment_type` is set to `Subscription`, this parameter is required. If `payment_type` is set to `PayAsYouGo`, this parameter is not required.
        :param pulumi.Input[_builtins.str] public_ip_address_pool_id: The ID of the IP address pool. The EIP is allocated from the IP address pool. By default, the IP address pool feature is unavailable. To use the IP address pool, apply for the privilege in the Quota Center console. For more information, see the "Request a quota increase in the Quota Center console" section in [Manage EIP quotas](https://www.alibabacloud.com/help/en/doc-detail/108213.html).
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which you want to move the resource.
               
               > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_protection_types: Security protection level.
               - When the return is empty, the basic DDoS protection is specified.
               - When `antidos_enhanced` is returned, it indicates DDoS protection (enhanced version).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] zone: The zone of the EIP. When the service type of the IP address pool specified by `PublicIpAddressPoolId` is CloudBox, the default value is the zone of the IP address pool. For more information, see [ListPublicIpAddressPools](https://www.alibabacloud.com/help/en/doc-detail/429433.html). 
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EipAddressArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        EIP Address can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/eipAddress:EipAddress example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EipAddressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EipAddressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 address_name: Optional[pulumi.Input[_builtins.str]] = None,
                 allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 high_definition_monitor_log_status: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 log_project: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 netmode: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EipAddressArgs.__new__(EipAddressArgs)

            __props__.__dict__["activity_id"] = activity_id
            __props__.__dict__["address_name"] = address_name
            __props__.__dict__["allocation_id"] = allocation_id
            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["high_definition_monitor_log_status"] = high_definition_monitor_log_status
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["isp"] = isp
            __props__.__dict__["log_project"] = log_project
            __props__.__dict__["log_store"] = log_store
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            __props__.__dict__["netmode"] = netmode
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["pricing_cycle"] = pricing_cycle
            __props__.__dict__["public_ip_address_pool_id"] = public_ip_address_pool_id
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["security_protection_types"] = security_protection_types
            __props__.__dict__["tags"] = tags
            __props__.__dict__["zone"] = zone
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(EipAddress, __self__).__init__(
            'alicloud:ecs/eipAddress:EipAddress',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activity_id: Optional[pulumi.Input[_builtins.str]] = None,
            address_name: Optional[pulumi.Input[_builtins.str]] = None,
            allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
            auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
            bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            high_definition_monitor_log_status: Optional[pulumi.Input[_builtins.str]] = None,
            instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            isp: Optional[pulumi.Input[_builtins.str]] = None,
            log_project: Optional[pulumi.Input[_builtins.str]] = None,
            log_store: Optional[pulumi.Input[_builtins.str]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            netmode: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'EipAddress':
        """
        Get an existing EipAddress resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] activity_id: The promotion code. This parameter is not required.
        :param pulumi.Input[_builtins.str] address_name: The EIP name.
               
               The name must be 1 to 128 characters in length and start with a letter, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-).
               
               > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
        :param pulumi.Input[_builtins.str] allocation_id: The ID of the EIP instance.
        :param pulumi.Input[_builtins.bool] auto_pay: Specifies whether to enable automatic payment. Valid values:
        :param pulumi.Input[_builtins.str] bandwidth: The maximum bandwidth of the specified EIP. Unit: Mbit/s.
               - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByBandwidth`, valid values for `bandwidth` are `1` to `500`.
               - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByTraffic`, valid values for `bandwidth` are `1` to `200`.
               - When `payment_type` is set to `Subscription`, valid values for `bandwidth` are `1` to `1000`.
               
               Default value: `5` Mbit /s.
        :param pulumi.Input[_builtins.str] create_time: The time when the EIP was created.
        :param pulumi.Input[_builtins.bool] deletion_protection: Specifies whether to enable deletion protection. Valid values:
        :param pulumi.Input[_builtins.str] description: The description of the EIP.
               
               The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
               
               > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
        :param pulumi.Input[_builtins.str] high_definition_monitor_log_status: The status of fine-grained monitoring. Valid values:
               - `ON`
               - `OFF`
        :param pulumi.Input[_builtins.str] instance_charge_type: . Field 'instance_charge_type' has been deprecated from provider version 1.126.0. New field 'payment_type' instead.
        :param pulumi.Input[_builtins.str] internet_charge_type: The metering method of the EIP. Valid values:
               - `PayByBandwidth` (default): pay-by-bandwidth.
               - `PayByTraffic`: pay-by-data-transfer.
               
               When `payment_type` is set to `Subscription`, you must set `internet_charge_type` to `PayByBandwidth`.
               
               When `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
        :param pulumi.Input[_builtins.str] ip_address: The IP address of the EIP. Supports a maximum of 50 EIPs.
        :param pulumi.Input[_builtins.str] isp: The line type. Valid values:
               - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
               - `BGP_PRO`: BGP (Multi-ISP) Pro line The BGP (Multi-ISP) Pro line is supported in the China (Hong Kong), Singapore, Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.
               
               For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see the "Line types" section of [What is EIP?](https://www.alibabacloud.com/help/en/doc-detail/32321.html)
               
               If you are allowed to use single-ISP bandwidth, you can also choose one of the following values:
               - `ChinaTelecom`
               - `ChinaUnicom`
               - `ChinaMobile`
               - `ChinaTelecom_L2`
               - `ChinaUnicom_L2`
               - `ChinaMobile_L2`
               
               If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
        :param pulumi.Input[_builtins.str] log_project: The name of the Simple Log Service (SLS) project.
        :param pulumi.Input[_builtins.str] log_store: The name of the Logstore.
        :param pulumi.Input[_builtins.str] mode: The association mode. Valid values:
               - `NAT` (default): NAT mode
               - `MULTI_BINDED`: multi-EIP-to-ENI mode
               - `BINDED`: cut-network interface controller mode
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.126.0. New field 'address_name' instead.
        :param pulumi.Input[_builtins.str] netmode: The network type. By default, this value is set to `public`, which specifies the public network type.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the EIP. Valid values:
               - `Subscription`: subscription
               - `PayAsYouGo` (default): pay-as-you-go
               
               If `payment_type` is set to `Subscription`, set `internet_charge_type` to `PayByBandwidth`. If `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
        :param pulumi.Input[_builtins.int] period: Duration of purchase. When the value of `pricing_cycle` is `Month`, the value range of `period` is `1` to `9`. When the value of `pricing_cycle` is `Year`, the value range of `period` is `1` to `5`. If the value of the `payment_type` parameter is `Subscription`, this parameter is required. If the value of the `payment_type` parameter is `PayAsYouGo`, this parameter is left blank.
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the subscription EIP. Valid values:
               - `Month` (default)
               - `Year`
               
               If `payment_type` is set to `Subscription`, this parameter is required. If `payment_type` is set to `PayAsYouGo`, this parameter is not required.
        :param pulumi.Input[_builtins.str] public_ip_address_pool_id: The ID of the IP address pool. The EIP is allocated from the IP address pool. By default, the IP address pool feature is unavailable. To use the IP address pool, apply for the privilege in the Quota Center console. For more information, see the "Request a quota increase in the Quota Center console" section in [Manage EIP quotas](https://www.alibabacloud.com/help/en/doc-detail/108213.html).
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which you want to move the resource.
               
               > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_protection_types: Security protection level.
               - When the return is empty, the basic DDoS protection is specified.
               - When `antidos_enhanced` is returned, it indicates DDoS protection (enhanced version).
        :param pulumi.Input[_builtins.str] status: The state of the EIP.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] zone: The zone of the EIP. When the service type of the IP address pool specified by `PublicIpAddressPoolId` is CloudBox, the default value is the zone of the IP address pool. For more information, see [ListPublicIpAddressPools](https://www.alibabacloud.com/help/en/doc-detail/429433.html). 
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EipAddressState.__new__(_EipAddressState)

        __props__.__dict__["activity_id"] = activity_id
        __props__.__dict__["address_name"] = address_name
        __props__.__dict__["allocation_id"] = allocation_id
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["high_definition_monitor_log_status"] = high_definition_monitor_log_status
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["isp"] = isp
        __props__.__dict__["log_project"] = log_project
        __props__.__dict__["log_store"] = log_store
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["netmode"] = netmode
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["pricing_cycle"] = pricing_cycle
        __props__.__dict__["public_ip_address_pool_id"] = public_ip_address_pool_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_protection_types"] = security_protection_types
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["zone"] = zone
        return EipAddress(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activityId")
    def activity_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The promotion code. This parameter is not required.
        """
        return pulumi.get(self, "activity_id")

    @_builtins.property
    @pulumi.getter(name="addressName")
    def address_name(self) -> pulumi.Output[_builtins.str]:
        """
        The EIP name.

        The name must be 1 to 128 characters in length and start with a letter, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-).

        > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
        """
        return pulumi.get(self, "address_name")

    @_builtins.property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the EIP instance.
        """
        return pulumi.get(self, "allocation_id")

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable automatic payment. Valid values:
        """
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[_builtins.str]:
        """
        The maximum bandwidth of the specified EIP. Unit: Mbit/s.
        - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByBandwidth`, valid values for `bandwidth` are `1` to `500`.
        - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByTraffic`, valid values for `bandwidth` are `1` to `200`.
        - When `payment_type` is set to `Subscription`, valid values for `bandwidth` are `1` to `1000`.

        Default value: `5` Mbit /s.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the EIP was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable deletion protection. Valid values:
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the EIP.

        The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.

        > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="highDefinitionMonitorLogStatus")
    def high_definition_monitor_log_status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of fine-grained monitoring. Valid values:
        - `ON`
        - `OFF`
        """
        return pulumi.get(self, "high_definition_monitor_log_status")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    @_utilities.deprecated("""Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""")
    def instance_charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'instance_charge_type' has been deprecated from provider version 1.126.0. New field 'payment_type' instead.
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        The metering method of the EIP. Valid values:
        - `PayByBandwidth` (default): pay-by-bandwidth.
        - `PayByTraffic`: pay-by-data-transfer.

        When `payment_type` is set to `Subscription`, you must set `internet_charge_type` to `PayByBandwidth`.

        When `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address of the EIP. Supports a maximum of 50 EIPs.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def isp(self) -> pulumi.Output[_builtins.str]:
        """
        The line type. Valid values:
        - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
        - `BGP_PRO`: BGP (Multi-ISP) Pro line The BGP (Multi-ISP) Pro line is supported in the China (Hong Kong), Singapore, Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.

        For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see the "Line types" section of [What is EIP?](https://www.alibabacloud.com/help/en/doc-detail/32321.html)

        If you are allowed to use single-ISP bandwidth, you can also choose one of the following values:
        - `ChinaTelecom`
        - `ChinaUnicom`
        - `ChinaMobile`
        - `ChinaTelecom_L2`
        - `ChinaUnicom_L2`
        - `ChinaMobile_L2`

        If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
        """
        return pulumi.get(self, "isp")

    @_builtins.property
    @pulumi.getter(name="logProject")
    def log_project(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the Simple Log Service (SLS) project.
        """
        return pulumi.get(self, "log_project")

    @_builtins.property
    @pulumi.getter(name="logStore")
    def log_store(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the Logstore.
        """
        return pulumi.get(self, "log_store")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[_builtins.str]:
        """
        The association mode. Valid values:
        - `NAT` (default): NAT mode
        - `MULTI_BINDED`: multi-EIP-to-ENI mode
        - `BINDED`: cut-network interface controller mode
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'name' has been deprecated from provider version 1.126.0. New field 'address_name' instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def netmode(self) -> pulumi.Output[_builtins.str]:
        """
        The network type. By default, this value is set to `public`, which specifies the public network type.
        """
        return pulumi.get(self, "netmode")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The billing method of the EIP. Valid values:
        - `Subscription`: subscription
        - `PayAsYouGo` (default): pay-as-you-go

        If `payment_type` is set to `Subscription`, set `internet_charge_type` to `PayByBandwidth`. If `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Duration of purchase. When the value of `pricing_cycle` is `Month`, the value range of `period` is `1` to `9`. When the value of `pricing_cycle` is `Year`, the value range of `period` is `1` to `5`. If the value of the `payment_type` parameter is `Subscription`, this parameter is required. If the value of the `payment_type` parameter is `PayAsYouGo`, this parameter is left blank.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The billing cycle of the subscription EIP. Valid values:
        - `Month` (default)
        - `Year`

        If `payment_type` is set to `Subscription`, this parameter is required. If `payment_type` is set to `PayAsYouGo`, this parameter is not required.
        """
        return pulumi.get(self, "pricing_cycle")

    @_builtins.property
    @pulumi.getter(name="publicIpAddressPoolId")
    def public_ip_address_pool_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the IP address pool. The EIP is allocated from the IP address pool. By default, the IP address pool feature is unavailable. To use the IP address pool, apply for the privilege in the Quota Center console. For more information, see the "Request a quota increase in the Quota Center console" section in [Manage EIP quotas](https://www.alibabacloud.com/help/en/doc-detail/108213.html).
        """
        return pulumi.get(self, "public_ip_address_pool_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group to which you want to move the resource.

        > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="securityProtectionTypes")
    def security_protection_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Security protection level.
        - When the return is empty, the basic DDoS protection is specified.
        - When `antidos_enhanced` is returned, it indicates DDoS protection (enhanced version).
        """
        return pulumi.get(self, "security_protection_types")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the EIP.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        The zone of the EIP. When the service type of the IP address pool specified by `PublicIpAddressPoolId` is CloudBox, the default value is the zone of the IP address pool. For more information, see [ListPublicIpAddressPools](https://www.alibabacloud.com/help/en/doc-detail/429433.html). 

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "zone")

