# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EipAssociationArgs', 'EipAssociation']

@pulumi.input_type
class EipAssociationArgs:
    def __init__(__self__, *,
                 allocation_id: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EipAssociation resource.
        :param pulumi.Input[_builtins.str] allocation_id: The ID of the EIP instance.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance with which you want to associate the EIP. You can enter the ID of a NAT gateway, CLB instance, ECS instance, secondary ENI, HAVIP, or IP address.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to disassociate the EIP from a NAT gateway if a DNAT or SNAT entry is added to the NAT gateway. Valid values:
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance with which you want to associate the EIP. Valid values:
               - `Nat`: NAT gateway
               - `SlbInstance`: CLB instance
               - `EcsInstance` (default): ECS instance
               - `NetworkInterface`: secondary ENI
               - `HaVip`: HAVIP
               - `IpAddress`: IP address
               
               > **NOTE:**   The default value is `EcsInstance`. If the instance with which you want to associate the EIP is not an ECS instance, this parameter is required.
        :param pulumi.Input[_builtins.str] mode: The association mode. Valid values:
               - `NAT` (default): NAT mode
               - `MULTI_BINDED`: multi-EIP-to-ENI mode
               - `BINDED`: cut-network interface controller mode
               
               > **NOTE:**   This parameter is required only when `instance_type` is set to `NetworkInterface`.
        :param pulumi.Input[_builtins.str] private_ip_address: The IP address in the CIDR block of the vSwitch.
               
               If you leave this parameter empty, the system allocates a private IP address based on the VPC ID and vSwitch ID.
               
               > **NOTE:**   This parameter is required if `instance_type` is set to `IpAddress`, which indicates that the EIP is to be associated with an IP address.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC in which an IPv4 gateway is created. The VPC and the EIP must be in the same region.
               
               When you associate an EIP with an IP address, the system can enable the IP address to access the Internet based on VPC route configurations.
               
               > **NOTE:**   This parameter is required if `instance_type` is set to `IpAddress`, which indicates that the EIP is to be associated with an IP address.
        """
        pulumi.set(__self__, "allocation_id", allocation_id)
        pulumi.set(__self__, "instance_id", instance_id)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the EIP instance.
        """
        return pulumi.get(self, "allocation_id")

    @allocation_id.setter
    def allocation_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "allocation_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the instance with which you want to associate the EIP. You can enter the ID of a NAT gateway, CLB instance, ECS instance, secondary ENI, HAVIP, or IP address.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to disassociate the EIP from a NAT gateway if a DNAT or SNAT entry is added to the NAT gateway. Valid values:
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the instance with which you want to associate the EIP. Valid values:
        - `Nat`: NAT gateway
        - `SlbInstance`: CLB instance
        - `EcsInstance` (default): ECS instance
        - `NetworkInterface`: secondary ENI
        - `HaVip`: HAVIP
        - `IpAddress`: IP address

        > **NOTE:**   The default value is `EcsInstance`. If the instance with which you want to associate the EIP is not an ECS instance, this parameter is required.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The association mode. Valid values:
        - `NAT` (default): NAT mode
        - `MULTI_BINDED`: multi-EIP-to-ENI mode
        - `BINDED`: cut-network interface controller mode

        > **NOTE:**   This parameter is required only when `instance_type` is set to `NetworkInterface`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address in the CIDR block of the vSwitch.

        If you leave this parameter empty, the system allocates a private IP address based on the VPC ID and vSwitch ID.

        > **NOTE:**   This parameter is required if `instance_type` is set to `IpAddress`, which indicates that the EIP is to be associated with an IP address.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC in which an IPv4 gateway is created. The VPC and the EIP must be in the same region.

        When you associate an EIP with an IP address, the system can enable the IP address to access the Internet based on VPC route configurations.

        > **NOTE:**   This parameter is required if `instance_type` is set to `IpAddress`, which indicates that the EIP is to be associated with an IP address.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _EipAssociationState:
    def __init__(__self__, *,
                 allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EipAssociation resources.
        :param pulumi.Input[_builtins.str] allocation_id: The ID of the EIP instance.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to disassociate the EIP from a NAT gateway if a DNAT or SNAT entry is added to the NAT gateway. Valid values:
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance with which you want to associate the EIP. You can enter the ID of a NAT gateway, CLB instance, ECS instance, secondary ENI, HAVIP, or IP address.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance with which you want to associate the EIP. Valid values:
               - `Nat`: NAT gateway
               - `SlbInstance`: CLB instance
               - `EcsInstance` (default): ECS instance
               - `NetworkInterface`: secondary ENI
               - `HaVip`: HAVIP
               - `IpAddress`: IP address
               
               > **NOTE:**   The default value is `EcsInstance`. If the instance with which you want to associate the EIP is not an ECS instance, this parameter is required.
        :param pulumi.Input[_builtins.str] mode: The association mode. Valid values:
               - `NAT` (default): NAT mode
               - `MULTI_BINDED`: multi-EIP-to-ENI mode
               - `BINDED`: cut-network interface controller mode
               
               > **NOTE:**   This parameter is required only when `instance_type` is set to `NetworkInterface`.
        :param pulumi.Input[_builtins.str] private_ip_address: The IP address in the CIDR block of the vSwitch.
               
               If you leave this parameter empty, the system allocates a private IP address based on the VPC ID and vSwitch ID.
               
               > **NOTE:**   This parameter is required if `instance_type` is set to `IpAddress`, which indicates that the EIP is to be associated with an IP address.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC in which an IPv4 gateway is created. The VPC and the EIP must be in the same region.
               
               When you associate an EIP with an IP address, the system can enable the IP address to access the Internet based on VPC route configurations.
               
               > **NOTE:**   This parameter is required if `instance_type` is set to `IpAddress`, which indicates that the EIP is to be associated with an IP address.
        """
        if allocation_id is not None:
            pulumi.set(__self__, "allocation_id", allocation_id)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the EIP instance.
        """
        return pulumi.get(self, "allocation_id")

    @allocation_id.setter
    def allocation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allocation_id", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to disassociate the EIP from a NAT gateway if a DNAT or SNAT entry is added to the NAT gateway. Valid values:
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance with which you want to associate the EIP. You can enter the ID of a NAT gateway, CLB instance, ECS instance, secondary ENI, HAVIP, or IP address.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the instance with which you want to associate the EIP. Valid values:
        - `Nat`: NAT gateway
        - `SlbInstance`: CLB instance
        - `EcsInstance` (default): ECS instance
        - `NetworkInterface`: secondary ENI
        - `HaVip`: HAVIP
        - `IpAddress`: IP address

        > **NOTE:**   The default value is `EcsInstance`. If the instance with which you want to associate the EIP is not an ECS instance, this parameter is required.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The association mode. Valid values:
        - `NAT` (default): NAT mode
        - `MULTI_BINDED`: multi-EIP-to-ENI mode
        - `BINDED`: cut-network interface controller mode

        > **NOTE:**   This parameter is required only when `instance_type` is set to `NetworkInterface`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address in the CIDR block of the vSwitch.

        If you leave this parameter empty, the system allocates a private IP address based on the VPC ID and vSwitch ID.

        > **NOTE:**   This parameter is required if `instance_type` is set to `IpAddress`, which indicates that the EIP is to be associated with an IP address.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC in which an IPv4 gateway is created. The VPC and the EIP must be in the same region.

        When you associate an EIP with an IP address, the system can enable the IP address to access the Internet based on VPC route configurations.

        > **NOTE:**   This parameter is required if `instance_type` is set to `IpAddress`, which indicates that the EIP is to be associated with an IP address.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("alicloud:ecs/eipAssociation:EipAssociation")
class EipAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a EIP Association resource.

        > **NOTE:** `ecs.EipAssociation` is useful in scenarios where EIPs are either
         pre-existing or distributed to customers or users and therefore cannot be changed.

        > **NOTE:** From version 1.7.1, the resource support to associate EIP to SLB Instance or Nat Gateway.

        > **NOTE:** One EIP can only be associated with ECS or SLB instance which in the VPC.

        For information about EIP Association and how to use it, see [What is Association](https://www.alibabacloud.com/help/en/vpc/developer-reference/api-vpc-2016-04-28-associateeipaddress).

        > **NOTE:** Available since v1.117.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        example = alicloud.get_zones(available_resource_creation="Instance")
        example_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=example.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        example_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            owners="system")
        example_network = alicloud.vpc.Network("example",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        example_switch = alicloud.vpc.Switch("example",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=example_network.id,
            zone_id=example.zones[0].id)
        example_security_group = alicloud.ecs.SecurityGroup("example",
            name=name,
            vpc_id=example_network.id)
        example_instance = alicloud.ecs.Instance("example",
            availability_zone=example.zones[0].id,
            instance_name=name,
            image_id=example_get_images.images[0].id,
            instance_type=example_get_instance_types.instance_types[0].id,
            security_groups=[example_security_group.id],
            vswitch_id=example_switch.id,
            tags={
                "Created": "TF",
                "For": "example",
            })
        example_eip_address = alicloud.ecs.EipAddress("example", address_name=name)
        example_eip_association = alicloud.ecs.EipAssociation("example",
            allocation_id=example_eip_address.id,
            instance_id=example_instance.id)
        ```

        ## Import

        EIP Association can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/eipAssociation:EipAssociation example <allocation_id>:<instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] allocation_id: The ID of the EIP instance.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to disassociate the EIP from a NAT gateway if a DNAT or SNAT entry is added to the NAT gateway. Valid values:
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance with which you want to associate the EIP. You can enter the ID of a NAT gateway, CLB instance, ECS instance, secondary ENI, HAVIP, or IP address.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance with which you want to associate the EIP. Valid values:
               - `Nat`: NAT gateway
               - `SlbInstance`: CLB instance
               - `EcsInstance` (default): ECS instance
               - `NetworkInterface`: secondary ENI
               - `HaVip`: HAVIP
               - `IpAddress`: IP address
               
               > **NOTE:**   The default value is `EcsInstance`. If the instance with which you want to associate the EIP is not an ECS instance, this parameter is required.
        :param pulumi.Input[_builtins.str] mode: The association mode. Valid values:
               - `NAT` (default): NAT mode
               - `MULTI_BINDED`: multi-EIP-to-ENI mode
               - `BINDED`: cut-network interface controller mode
               
               > **NOTE:**   This parameter is required only when `instance_type` is set to `NetworkInterface`.
        :param pulumi.Input[_builtins.str] private_ip_address: The IP address in the CIDR block of the vSwitch.
               
               If you leave this parameter empty, the system allocates a private IP address based on the VPC ID and vSwitch ID.
               
               > **NOTE:**   This parameter is required if `instance_type` is set to `IpAddress`, which indicates that the EIP is to be associated with an IP address.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC in which an IPv4 gateway is created. The VPC and the EIP must be in the same region.
               
               When you associate an EIP with an IP address, the system can enable the IP address to access the Internet based on VPC route configurations.
               
               > **NOTE:**   This parameter is required if `instance_type` is set to `IpAddress`, which indicates that the EIP is to be associated with an IP address.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EipAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a EIP Association resource.

        > **NOTE:** `ecs.EipAssociation` is useful in scenarios where EIPs are either
         pre-existing or distributed to customers or users and therefore cannot be changed.

        > **NOTE:** From version 1.7.1, the resource support to associate EIP to SLB Instance or Nat Gateway.

        > **NOTE:** One EIP can only be associated with ECS or SLB instance which in the VPC.

        For information about EIP Association and how to use it, see [What is Association](https://www.alibabacloud.com/help/en/vpc/developer-reference/api-vpc-2016-04-28-associateeipaddress).

        > **NOTE:** Available since v1.117.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        example = alicloud.get_zones(available_resource_creation="Instance")
        example_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=example.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        example_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            owners="system")
        example_network = alicloud.vpc.Network("example",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        example_switch = alicloud.vpc.Switch("example",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=example_network.id,
            zone_id=example.zones[0].id)
        example_security_group = alicloud.ecs.SecurityGroup("example",
            name=name,
            vpc_id=example_network.id)
        example_instance = alicloud.ecs.Instance("example",
            availability_zone=example.zones[0].id,
            instance_name=name,
            image_id=example_get_images.images[0].id,
            instance_type=example_get_instance_types.instance_types[0].id,
            security_groups=[example_security_group.id],
            vswitch_id=example_switch.id,
            tags={
                "Created": "TF",
                "For": "example",
            })
        example_eip_address = alicloud.ecs.EipAddress("example", address_name=name)
        example_eip_association = alicloud.ecs.EipAssociation("example",
            allocation_id=example_eip_address.id,
            instance_id=example_instance.id)
        ```

        ## Import

        EIP Association can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/eipAssociation:EipAssociation example <allocation_id>:<instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param EipAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EipAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EipAssociationArgs.__new__(EipAssociationArgs)

            if allocation_id is None and not opts.urn:
                raise TypeError("Missing required property 'allocation_id'")
            __props__.__dict__["allocation_id"] = allocation_id
            __props__.__dict__["force"] = force
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["mode"] = mode
            __props__.__dict__["private_ip_address"] = private_ip_address
            __props__.__dict__["vpc_id"] = vpc_id
        super(EipAssociation, __self__).__init__(
            'alicloud:ecs/eipAssociation:EipAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
            force: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'EipAssociation':
        """
        Get an existing EipAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] allocation_id: The ID of the EIP instance.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to disassociate the EIP from a NAT gateway if a DNAT or SNAT entry is added to the NAT gateway. Valid values:
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance with which you want to associate the EIP. You can enter the ID of a NAT gateway, CLB instance, ECS instance, secondary ENI, HAVIP, or IP address.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance with which you want to associate the EIP. Valid values:
               - `Nat`: NAT gateway
               - `SlbInstance`: CLB instance
               - `EcsInstance` (default): ECS instance
               - `NetworkInterface`: secondary ENI
               - `HaVip`: HAVIP
               - `IpAddress`: IP address
               
               > **NOTE:**   The default value is `EcsInstance`. If the instance with which you want to associate the EIP is not an ECS instance, this parameter is required.
        :param pulumi.Input[_builtins.str] mode: The association mode. Valid values:
               - `NAT` (default): NAT mode
               - `MULTI_BINDED`: multi-EIP-to-ENI mode
               - `BINDED`: cut-network interface controller mode
               
               > **NOTE:**   This parameter is required only when `instance_type` is set to `NetworkInterface`.
        :param pulumi.Input[_builtins.str] private_ip_address: The IP address in the CIDR block of the vSwitch.
               
               If you leave this parameter empty, the system allocates a private IP address based on the VPC ID and vSwitch ID.
               
               > **NOTE:**   This parameter is required if `instance_type` is set to `IpAddress`, which indicates that the EIP is to be associated with an IP address.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC in which an IPv4 gateway is created. The VPC and the EIP must be in the same region.
               
               When you associate an EIP with an IP address, the system can enable the IP address to access the Internet based on VPC route configurations.
               
               > **NOTE:**   This parameter is required if `instance_type` is set to `IpAddress`, which indicates that the EIP is to be associated with an IP address.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EipAssociationState.__new__(_EipAssociationState)

        __props__.__dict__["allocation_id"] = allocation_id
        __props__.__dict__["force"] = force
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["mode"] = mode
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["vpc_id"] = vpc_id
        return EipAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the EIP instance.
        """
        return pulumi.get(self, "allocation_id")

    @_builtins.property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to disassociate the EIP from a NAT gateway if a DNAT or SNAT entry is added to the NAT gateway. Valid values:
        """
        return pulumi.get(self, "force")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the instance with which you want to associate the EIP. You can enter the ID of a NAT gateway, CLB instance, ECS instance, secondary ENI, HAVIP, or IP address.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the instance with which you want to associate the EIP. Valid values:
        - `Nat`: NAT gateway
        - `SlbInstance`: CLB instance
        - `EcsInstance` (default): ECS instance
        - `NetworkInterface`: secondary ENI
        - `HaVip`: HAVIP
        - `IpAddress`: IP address

        > **NOTE:**   The default value is `EcsInstance`. If the instance with which you want to associate the EIP is not an ECS instance, this parameter is required.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[_builtins.str]:
        """
        The association mode. Valid values:
        - `NAT` (default): NAT mode
        - `MULTI_BINDED`: multi-EIP-to-ENI mode
        - `BINDED`: cut-network interface controller mode

        > **NOTE:**   This parameter is required only when `instance_type` is set to `NetworkInterface`.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IP address in the CIDR block of the vSwitch.

        If you leave this parameter empty, the system allocates a private IP address based on the VPC ID and vSwitch ID.

        > **NOTE:**   This parameter is required if `instance_type` is set to `IpAddress`, which indicates that the EIP is to be associated with an IP address.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the VPC in which an IPv4 gateway is created. The VPC and the EIP must be in the same region.

        When you associate an EIP with an IP address, the system can enable the IP address to access the Internet based on VPC route configurations.

        > **NOTE:**   This parameter is required if `instance_type` is set to `IpAddress`, which indicates that the EIP is to be associated with an IP address.
        """
        return pulumi.get(self, "vpc_id")

