# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEcsLaunchTemplatesResult',
    'AwaitableGetEcsLaunchTemplatesResult',
    'get_ecs_launch_templates',
    'get_ecs_launch_templates_output',
]

@pulumi.output_type
class GetEcsLaunchTemplatesResult:
    """
    A collection of values returned by getEcsLaunchTemplates.
    """
    def __init__(__self__, enable_details=None, id=None, ids=None, launch_template_name=None, name_regex=None, names=None, output_file=None, template_resource_group_id=None, template_tags=None, templates=None):
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if launch_template_name and not isinstance(launch_template_name, str):
            raise TypeError("Expected argument 'launch_template_name' to be a str")
        pulumi.set(__self__, "launch_template_name", launch_template_name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if template_resource_group_id and not isinstance(template_resource_group_id, str):
            raise TypeError("Expected argument 'template_resource_group_id' to be a str")
        pulumi.set(__self__, "template_resource_group_id", template_resource_group_id)
        if template_tags and not isinstance(template_tags, dict):
            raise TypeError("Expected argument 'template_tags' to be a dict")
        pulumi.set(__self__, "template_tags", template_tags)
        if templates and not isinstance(templates, list):
            raise TypeError("Expected argument 'templates' to be a list")
        pulumi.set(__self__, "templates", templates)

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[_builtins.str]:
        """
        The name of the Launch Template.
        """
        return pulumi.get(self, "launch_template_name")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Launch Template names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="templateResourceGroupId")
    def template_resource_group_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "template_resource_group_id")

    @_builtins.property
    @pulumi.getter(name="templateTags")
    def template_tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The tags of the launch template.
        > **NOTE:** Except for the fields `id`, `launch_template_id`, `launch_template_name`, `default_version_number`, `latest_version_number`, `created_by`, `modified_time`, `resource_group_id`, `template_tags`, all other fields take effect only if `enable_details` is set to `true`.
        """
        return pulumi.get(self, "template_tags")

    @_builtins.property
    @pulumi.getter
    def templates(self) -> Sequence['outputs.GetEcsLaunchTemplatesTemplateResult']:
        """
        A list of Ecs Launch Templates. Each element contains the following attributes:
        """
        return pulumi.get(self, "templates")


class AwaitableGetEcsLaunchTemplatesResult(GetEcsLaunchTemplatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEcsLaunchTemplatesResult(
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            launch_template_name=self.launch_template_name,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            template_resource_group_id=self.template_resource_group_id,
            template_tags=self.template_tags,
            templates=self.templates)


def get_ecs_launch_templates(enable_details: Optional[_builtins.bool] = None,
                             ids: Optional[Sequence[_builtins.str]] = None,
                             launch_template_name: Optional[_builtins.str] = None,
                             name_regex: Optional[_builtins.str] = None,
                             output_file: Optional[_builtins.str] = None,
                             template_resource_group_id: Optional[_builtins.str] = None,
                             template_tags: Optional[Mapping[str, _builtins.str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEcsLaunchTemplatesResult:
    """
    This data source provides the Ecs Launch Templates of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.120.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.get_zones(available_disk_category="cloud_efficiency",
        available_resource_creation="VSwitch")
    default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id)
    default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
        owners="system")
    default_network = alicloud.vpc.Network("default",
        vpc_name="terraform-example",
        cidr_block="172.17.3.0/24")
    default_switch = alicloud.vpc.Switch("default",
        vswitch_name="terraform-example",
        cidr_block="172.17.3.0/24",
        vpc_id=default_network.id,
        zone_id=default.zones[0].id)
    default_security_group = alicloud.ecs.SecurityGroup("default",
        name="terraform-example",
        vpc_id=default_network.id)
    default_ecs_launch_template = alicloud.ecs.EcsLaunchTemplate("default",
        launch_template_name="terraform-example",
        description="terraform-example",
        image_id=default_get_images.images[0].id,
        host_name="terraform-example",
        instance_charge_type="PrePaid",
        instance_name="terraform-example",
        instance_type=default_get_instance_types.instance_types[0].id,
        internet_charge_type="PayByBandwidth",
        internet_max_bandwidth_in=5,
        internet_max_bandwidth_out=5,
        io_optimized="optimized",
        key_pair_name="key_pair_name",
        ram_role_name="ram_role_name",
        network_type="vpc",
        security_enhancement_strategy="Active",
        spot_price_limit=5,
        spot_strategy="SpotWithPriceLimit",
        security_group_ids=[default_security_group.id],
        system_disk={
            "category": "cloud_ssd",
            "description": "Test For Terraform",
            "name": "terraform-example",
            "size": 40,
            "delete_with_instance": False,
        },
        user_data="xxxxxxx",
        vswitch_id=default_switch.id,
        vpc_id=default_network.id,
        zone_id=default.zones[0].id,
        template_tags={
            "Create": "Terraform",
            "For": "example",
        },
        network_interfaces={
            "name": "eth0",
            "description": "hello1",
            "primary_ip": "10.0.0.2",
            "security_group_id": default_security_group.id,
            "vswitch_id": default_switch.id,
        },
        data_disks=[
            {
                "name": "disk1",
                "description": "description",
                "delete_with_instance": True,
                "category": "cloud",
                "encrypted": False,
                "performance_level": "PL0",
                "size": 20,
            },
            {
                "name": "disk2",
                "description": "description2",
                "delete_with_instance": True,
                "category": "cloud",
                "encrypted": False,
                "performance_level": "PL0",
                "size": 20,
            },
        ])
    ids = alicloud.ecs.get_ecs_launch_templates_output(ids=[default_ecs_launch_template.id])
    pulumi.export("ecsLaunchTemplateId0", ids.templates[0].id)
    ```


    :param _builtins.bool enable_details: Whether to query the detailed list of resource attributes. Default value: `false`.
    :param Sequence[_builtins.str] ids: A list of Launch Template IDs.
    :param _builtins.str launch_template_name: The name of the launch template.
    :param _builtins.str name_regex: A regex string to filter results by Launch Template name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str template_resource_group_id: The ID of the Resource Group.
    :param Mapping[str, _builtins.str] template_tags: The tags of the launch template.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['launchTemplateName'] = launch_template_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['templateResourceGroupId'] = template_resource_group_id
    __args__['templateTags'] = template_tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ecs/getEcsLaunchTemplates:getEcsLaunchTemplates', __args__, opts=opts, typ=GetEcsLaunchTemplatesResult).value

    return AwaitableGetEcsLaunchTemplatesResult(
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        launch_template_name=pulumi.get(__ret__, 'launch_template_name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        template_resource_group_id=pulumi.get(__ret__, 'template_resource_group_id'),
        template_tags=pulumi.get(__ret__, 'template_tags'),
        templates=pulumi.get(__ret__, 'templates'))
def get_ecs_launch_templates_output(enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                    ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                    launch_template_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    template_resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    template_tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEcsLaunchTemplatesResult]:
    """
    This data source provides the Ecs Launch Templates of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.120.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.get_zones(available_disk_category="cloud_efficiency",
        available_resource_creation="VSwitch")
    default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id)
    default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
        owners="system")
    default_network = alicloud.vpc.Network("default",
        vpc_name="terraform-example",
        cidr_block="172.17.3.0/24")
    default_switch = alicloud.vpc.Switch("default",
        vswitch_name="terraform-example",
        cidr_block="172.17.3.0/24",
        vpc_id=default_network.id,
        zone_id=default.zones[0].id)
    default_security_group = alicloud.ecs.SecurityGroup("default",
        name="terraform-example",
        vpc_id=default_network.id)
    default_ecs_launch_template = alicloud.ecs.EcsLaunchTemplate("default",
        launch_template_name="terraform-example",
        description="terraform-example",
        image_id=default_get_images.images[0].id,
        host_name="terraform-example",
        instance_charge_type="PrePaid",
        instance_name="terraform-example",
        instance_type=default_get_instance_types.instance_types[0].id,
        internet_charge_type="PayByBandwidth",
        internet_max_bandwidth_in=5,
        internet_max_bandwidth_out=5,
        io_optimized="optimized",
        key_pair_name="key_pair_name",
        ram_role_name="ram_role_name",
        network_type="vpc",
        security_enhancement_strategy="Active",
        spot_price_limit=5,
        spot_strategy="SpotWithPriceLimit",
        security_group_ids=[default_security_group.id],
        system_disk={
            "category": "cloud_ssd",
            "description": "Test For Terraform",
            "name": "terraform-example",
            "size": 40,
            "delete_with_instance": False,
        },
        user_data="xxxxxxx",
        vswitch_id=default_switch.id,
        vpc_id=default_network.id,
        zone_id=default.zones[0].id,
        template_tags={
            "Create": "Terraform",
            "For": "example",
        },
        network_interfaces={
            "name": "eth0",
            "description": "hello1",
            "primary_ip": "10.0.0.2",
            "security_group_id": default_security_group.id,
            "vswitch_id": default_switch.id,
        },
        data_disks=[
            {
                "name": "disk1",
                "description": "description",
                "delete_with_instance": True,
                "category": "cloud",
                "encrypted": False,
                "performance_level": "PL0",
                "size": 20,
            },
            {
                "name": "disk2",
                "description": "description2",
                "delete_with_instance": True,
                "category": "cloud",
                "encrypted": False,
                "performance_level": "PL0",
                "size": 20,
            },
        ])
    ids = alicloud.ecs.get_ecs_launch_templates_output(ids=[default_ecs_launch_template.id])
    pulumi.export("ecsLaunchTemplateId0", ids.templates[0].id)
    ```


    :param _builtins.bool enable_details: Whether to query the detailed list of resource attributes. Default value: `false`.
    :param Sequence[_builtins.str] ids: A list of Launch Template IDs.
    :param _builtins.str launch_template_name: The name of the launch template.
    :param _builtins.str name_regex: A regex string to filter results by Launch Template name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str template_resource_group_id: The ID of the Resource Group.
    :param Mapping[str, _builtins.str] template_tags: The tags of the launch template.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['launchTemplateName'] = launch_template_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['templateResourceGroupId'] = template_resource_group_id
    __args__['templateTags'] = template_tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ecs/getEcsLaunchTemplates:getEcsLaunchTemplates', __args__, opts=opts, typ=GetEcsLaunchTemplatesResult)
    return __ret__.apply(lambda __response__: GetEcsLaunchTemplatesResult(
        enable_details=pulumi.get(__response__, 'enable_details'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        launch_template_name=pulumi.get(__response__, 'launch_template_name'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        template_resource_group_id=pulumi.get(__response__, 'template_resource_group_id'),
        template_tags=pulumi.get(__response__, 'template_tags'),
        templates=pulumi.get(__response__, 'templates')))
