# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEcsPrefixListsResult',
    'AwaitableGetEcsPrefixListsResult',
    'get_ecs_prefix_lists',
    'get_ecs_prefix_lists_output',
]

@pulumi.output_type
class GetEcsPrefixListsResult:
    """
    A collection of values returned by getEcsPrefixLists.
    """
    def __init__(__self__, address_family=None, enable_details=None, id=None, ids=None, lists=None, name_regex=None, names=None, output_file=None):
        if address_family and not isinstance(address_family, str):
            raise TypeError("Expected argument 'address_family' to be a str")
        pulumi.set(__self__, "address_family", address_family)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if lists and not isinstance(lists, list):
            raise TypeError("Expected argument 'lists' to be a list")
        pulumi.set(__self__, "lists", lists)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "address_family")

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def lists(self) -> Sequence['outputs.GetEcsPrefixListsListResult']:
        return pulumi.get(self, "lists")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetEcsPrefixListsResult(GetEcsPrefixListsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEcsPrefixListsResult(
            address_family=self.address_family,
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            lists=self.lists,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file)


def get_ecs_prefix_lists(address_family: Optional[_builtins.str] = None,
                         enable_details: Optional[_builtins.bool] = None,
                         ids: Optional[Sequence[_builtins.str]] = None,
                         name_regex: Optional[_builtins.str] = None,
                         output_file: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEcsPrefixListsResult:
    """
    This data source provides the Ecs Prefix Lists of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.152.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.ecs.get_ecs_prefix_lists(ids=["E2RY53-xxxx"],
        name_regex="tf-testAcc")
    pulumi.export("outputId", example.lists[0].id)
    ```


    :param _builtins.str address_family: The address family of the prefix list. Valid values: `IPv4`,`IPv6`. This parameter is empty by default, which indicates that all prefix lists are to be queried.
    :param Sequence[_builtins.str] ids: A list of Prefix List IDs.
    :param _builtins.str name_regex: A regex string to filter results by `prefix_list_name`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['addressFamily'] = address_family
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ecs/getEcsPrefixLists:getEcsPrefixLists', __args__, opts=opts, typ=GetEcsPrefixListsResult).value

    return AwaitableGetEcsPrefixListsResult(
        address_family=pulumi.get(__ret__, 'address_family'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        lists=pulumi.get(__ret__, 'lists'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_ecs_prefix_lists_output(address_family: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEcsPrefixListsResult]:
    """
    This data source provides the Ecs Prefix Lists of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.152.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.ecs.get_ecs_prefix_lists(ids=["E2RY53-xxxx"],
        name_regex="tf-testAcc")
    pulumi.export("outputId", example.lists[0].id)
    ```


    :param _builtins.str address_family: The address family of the prefix list. Valid values: `IPv4`,`IPv6`. This parameter is empty by default, which indicates that all prefix lists are to be queried.
    :param Sequence[_builtins.str] ids: A list of Prefix List IDs.
    :param _builtins.str name_regex: A regex string to filter results by `prefix_list_name`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['addressFamily'] = address_family
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ecs/getEcsPrefixLists:getEcsPrefixLists', __args__, opts=opts, typ=GetEcsPrefixListsResult)
    return __ret__.apply(lambda __response__: GetEcsPrefixListsResult(
        address_family=pulumi.get(__response__, 'address_family'),
        enable_details=pulumi.get(__response__, 'enable_details'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        lists=pulumi.get(__response__, 'lists'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file')))
