# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstanceTypeFamiliesResult',
    'AwaitableGetInstanceTypeFamiliesResult',
    'get_instance_type_families',
    'get_instance_type_families_output',
]

@pulumi.output_type
class GetInstanceTypeFamiliesResult:
    """
    A collection of values returned by getInstanceTypeFamilies.
    """
    def __init__(__self__, families=None, generation=None, id=None, ids=None, instance_charge_type=None, output_file=None, spot_strategy=None, zone_id=None):
        if families and not isinstance(families, list):
            raise TypeError("Expected argument 'families' to be a list")
        pulumi.set(__self__, "families", families)
        if generation and not isinstance(generation, str):
            raise TypeError("Expected argument 'generation' to be a str")
        pulumi.set(__self__, "generation", generation)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instance_charge_type and not isinstance(instance_charge_type, str):
            raise TypeError("Expected argument 'instance_charge_type' to be a str")
        pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if spot_strategy and not isinstance(spot_strategy, str):
            raise TypeError("Expected argument 'spot_strategy' to be a str")
        pulumi.set(__self__, "spot_strategy", spot_strategy)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def families(self) -> Sequence['outputs.GetInstanceTypeFamiliesFamilyResult']:
        return pulumi.get(self, "families")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> Optional[_builtins.str]:
        """
        The generation of the instance type family.
        """
        return pulumi.get(self, "generation")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of instance type family IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "spot_strategy")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "zone_id")


class AwaitableGetInstanceTypeFamiliesResult(GetInstanceTypeFamiliesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceTypeFamiliesResult(
            families=self.families,
            generation=self.generation,
            id=self.id,
            ids=self.ids,
            instance_charge_type=self.instance_charge_type,
            output_file=self.output_file,
            spot_strategy=self.spot_strategy,
            zone_id=self.zone_id)


def get_instance_type_families(generation: Optional[_builtins.str] = None,
                               instance_charge_type: Optional[_builtins.str] = None,
                               output_file: Optional[_builtins.str] = None,
                               spot_strategy: Optional[_builtins.str] = None,
                               zone_id: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceTypeFamiliesResult:
    """
    This data source provides the ECS instance type families of Alibaba Cloud.

    > **NOTE:** Available in 1.54.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.ecs.get_instance_type_families(instance_charge_type="PrePaid")
    pulumi.export("firstInstanceTypeFamilyId", default.families[0].id)
    pulumi.export("instanceIds", default.ids)
    ```


    :param _builtins.str generation: The generation of the instance type family, Valid values: `ecs-1`, `ecs-2`, `ecs-3`, `ecs-4`, `ecs-5`, `ecs-6`. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.htm).
    :param _builtins.str instance_charge_type: Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str spot_strategy: Filter the results by ECS spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
    :param _builtins.str zone_id: The Zone to launch the instance.
    """
    __args__ = dict()
    __args__['generation'] = generation
    __args__['instanceChargeType'] = instance_charge_type
    __args__['outputFile'] = output_file
    __args__['spotStrategy'] = spot_strategy
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ecs/getInstanceTypeFamilies:getInstanceTypeFamilies', __args__, opts=opts, typ=GetInstanceTypeFamiliesResult).value

    return AwaitableGetInstanceTypeFamiliesResult(
        families=pulumi.get(__ret__, 'families'),
        generation=pulumi.get(__ret__, 'generation'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instance_charge_type=pulumi.get(__ret__, 'instance_charge_type'),
        output_file=pulumi.get(__ret__, 'output_file'),
        spot_strategy=pulumi.get(__ret__, 'spot_strategy'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_instance_type_families_output(generation: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      instance_charge_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      spot_strategy: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstanceTypeFamiliesResult]:
    """
    This data source provides the ECS instance type families of Alibaba Cloud.

    > **NOTE:** Available in 1.54.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.ecs.get_instance_type_families(instance_charge_type="PrePaid")
    pulumi.export("firstInstanceTypeFamilyId", default.families[0].id)
    pulumi.export("instanceIds", default.ids)
    ```


    :param _builtins.str generation: The generation of the instance type family, Valid values: `ecs-1`, `ecs-2`, `ecs-3`, `ecs-4`, `ecs-5`, `ecs-6`. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.htm).
    :param _builtins.str instance_charge_type: Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str spot_strategy: Filter the results by ECS spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
    :param _builtins.str zone_id: The Zone to launch the instance.
    """
    __args__ = dict()
    __args__['generation'] = generation
    __args__['instanceChargeType'] = instance_charge_type
    __args__['outputFile'] = output_file
    __args__['spotStrategy'] = spot_strategy
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ecs/getInstanceTypeFamilies:getInstanceTypeFamilies', __args__, opts=opts, typ=GetInstanceTypeFamiliesResult)
    return __ret__.apply(lambda __response__: GetInstanceTypeFamiliesResult(
        families=pulumi.get(__response__, 'families'),
        generation=pulumi.get(__response__, 'generation'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        instance_charge_type=pulumi.get(__response__, 'instance_charge_type'),
        output_file=pulumi.get(__response__, 'output_file'),
        spot_strategy=pulumi.get(__response__, 'spot_strategy'),
        zone_id=pulumi.get(__response__, 'zone_id')))
