# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RamRoleAttachmentArgs', 'RamRoleAttachment']

@pulumi.input_type
class RamRoleAttachmentArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 ram_role_name: pulumi.Input[_builtins.str],
                 policy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RamRoleAttachment resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] ram_role_name: The name of the instance RAM role.
        :param pulumi.Input[_builtins.str] policy: The additional policy. When you attach an instance RAM role to instances, you can specify an additional policy to further limit the permissions of the role.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "ram_role_name", ram_role_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the instance RAM role.
        """
        return pulumi.get(self, "ram_role_name")

    @ram_role_name.setter
    def ram_role_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ram_role_name", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The additional policy. When you attach an instance RAM role to instances, you can specify an additional policy to further limit the permissions of the role.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)


@pulumi.input_type
class _RamRoleAttachmentState:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RamRoleAttachment resources.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] policy: The additional policy. When you attach an instance RAM role to instances, you can specify an additional policy to further limit the permissions of the role.
        :param pulumi.Input[_builtins.str] ram_role_name: The name of the instance RAM role.
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if ram_role_name is not None:
            pulumi.set(__self__, "ram_role_name", ram_role_name)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The additional policy. When you attach an instance RAM role to instances, you can specify an additional policy to further limit the permissions of the role.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance RAM role.
        """
        return pulumi.get(self, "ram_role_name")

    @ram_role_name.setter
    def ram_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ram_role_name", value)


@pulumi.type_token("alicloud:ecs/ramRoleAttachment:RamRoleAttachment")
class RamRoleAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ECS Ram Role Attachment resource.

        Mount RAM role.

        For information about ECS Ram Role Attachment and how to use it, see [What is Ram Role Attachment](https://next.api.alibabacloud.com/document/Ecs/2014-05-26/AttachInstanceRamRole).

        > **NOTE:** Available since v1.250.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_get_images = alicloud.ecs.get_images(most_recent=True,
            owners="system")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            image_id=default_get_images.images[0].id)
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_role = alicloud.ram.Role("default",
            name=f"{name}-{default_integer['result']}",
            document=\"\"\"\\x09\\x09{
        \\x09\\x09\\x09"Statement": [
        \\x09\\x09\\x09\\x09{
        \\x09\\x09\\x09\\x09\\x09"Action": "sts:AssumeRole",
        \\x09\\x09\\x09\\x09\\x09"Effect": "Allow",
        \\x09\\x09\\x09\\x09\\x09"Principal": {
        \\x09\\x09\\x09\\x09\\x09\\x09"Service": [
        \\x09\\x09\\x09\\x09\\x09\\x09\\x09"ecs.aliyuncs.com"
        \\x09\\x09\\x09\\x09\\x09\\x09]
        \\x09\\x09\\x09\\x09\\x09}
        \\x09\\x09\\x09\\x09}
        \\x09\\x09  \\x09],
        \\x09\\x09\\x09"Version": "1"
        \\x09\\x09}
        \"\"\",
            force=True)
        default_network = alicloud.vpc.Network("default",
            vpc_name=f"{name}-{default_integer['result']}",
            cidr_block="192.168.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=f"{name}-{default_integer['result']}",
            vpc_id=default_network.id,
            cidr_block="192.168.192.0/24",
            zone_id=default.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("default",
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            security_groups=[__item.id for __item in [default_security_group]],
            internet_charge_type="PayByTraffic",
            internet_max_bandwidth_out=10,
            availability_zone=default_get_instance_types.instance_types[0].availability_zones[0],
            instance_charge_type="PostPaid",
            system_disk_category="cloud_efficiency",
            vswitch_id=default_switch.id,
            instance_name=f"{name}-{default_integer['result']}")
        default_ram_role_attachment = alicloud.ecs.RamRoleAttachment("default",
            ram_role_name=default_role.id,
            instance_id=default_instance.id)
        ```

        ## Import

        ECS Ram Role Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/ramRoleAttachment:RamRoleAttachment example <instance_id>:<ram_role_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] policy: The additional policy. When you attach an instance RAM role to instances, you can specify an additional policy to further limit the permissions of the role.
        :param pulumi.Input[_builtins.str] ram_role_name: The name of the instance RAM role.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RamRoleAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECS Ram Role Attachment resource.

        Mount RAM role.

        For information about ECS Ram Role Attachment and how to use it, see [What is Ram Role Attachment](https://next.api.alibabacloud.com/document/Ecs/2014-05-26/AttachInstanceRamRole).

        > **NOTE:** Available since v1.250.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_get_images = alicloud.ecs.get_images(most_recent=True,
            owners="system")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            image_id=default_get_images.images[0].id)
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_role = alicloud.ram.Role("default",
            name=f"{name}-{default_integer['result']}",
            document=\"\"\"\\x09\\x09{
        \\x09\\x09\\x09"Statement": [
        \\x09\\x09\\x09\\x09{
        \\x09\\x09\\x09\\x09\\x09"Action": "sts:AssumeRole",
        \\x09\\x09\\x09\\x09\\x09"Effect": "Allow",
        \\x09\\x09\\x09\\x09\\x09"Principal": {
        \\x09\\x09\\x09\\x09\\x09\\x09"Service": [
        \\x09\\x09\\x09\\x09\\x09\\x09\\x09"ecs.aliyuncs.com"
        \\x09\\x09\\x09\\x09\\x09\\x09]
        \\x09\\x09\\x09\\x09\\x09}
        \\x09\\x09\\x09\\x09}
        \\x09\\x09  \\x09],
        \\x09\\x09\\x09"Version": "1"
        \\x09\\x09}
        \"\"\",
            force=True)
        default_network = alicloud.vpc.Network("default",
            vpc_name=f"{name}-{default_integer['result']}",
            cidr_block="192.168.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=f"{name}-{default_integer['result']}",
            vpc_id=default_network.id,
            cidr_block="192.168.192.0/24",
            zone_id=default.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("default",
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            security_groups=[__item.id for __item in [default_security_group]],
            internet_charge_type="PayByTraffic",
            internet_max_bandwidth_out=10,
            availability_zone=default_get_instance_types.instance_types[0].availability_zones[0],
            instance_charge_type="PostPaid",
            system_disk_category="cloud_efficiency",
            vswitch_id=default_switch.id,
            instance_name=f"{name}-{default_integer['result']}")
        default_ram_role_attachment = alicloud.ecs.RamRoleAttachment("default",
            ram_role_name=default_role.id,
            instance_id=default_instance.id)
        ```

        ## Import

        ECS Ram Role Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/ramRoleAttachment:RamRoleAttachment example <instance_id>:<ram_role_name>
        ```

        :param str resource_name: The name of the resource.
        :param RamRoleAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RamRoleAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RamRoleAttachmentArgs.__new__(RamRoleAttachmentArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["policy"] = policy
            if ram_role_name is None and not opts.urn:
                raise TypeError("Missing required property 'ram_role_name'")
            __props__.__dict__["ram_role_name"] = ram_role_name
        super(RamRoleAttachment, __self__).__init__(
            'alicloud:ecs/ramRoleAttachment:RamRoleAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            policy: Optional[pulumi.Input[_builtins.str]] = None,
            ram_role_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'RamRoleAttachment':
        """
        Get an existing RamRoleAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] policy: The additional policy. When you attach an instance RAM role to instances, you can specify an additional policy to further limit the permissions of the role.
        :param pulumi.Input[_builtins.str] ram_role_name: The name of the instance RAM role.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RamRoleAttachmentState.__new__(_RamRoleAttachmentState)

        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["policy"] = policy
        __props__.__dict__["ram_role_name"] = ram_role_name
        return RamRoleAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The additional policy. When you attach an instance RAM role to instances, you can specify an additional policy to further limit the permissions of the role.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the instance RAM role.
        """
        return pulumi.get(self, "ram_role_name")

