# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AdConnectorOfficeSiteArgs', 'AdConnectorOfficeSite']

@pulumi.input_type
class AdConnectorOfficeSiteArgs:
    def __init__(__self__, *,
                 ad_connector_office_site_name: pulumi.Input[_builtins.str],
                 cen_id: pulumi.Input[_builtins.str],
                 cidr_block: pulumi.Input[_builtins.str],
                 dns_addresses: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 domain_name: pulumi.Input[_builtins.str],
                 ad_hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 cen_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desktop_access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_password: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_admin_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 mfa_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.int]] = None,
                 sub_domain_dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sub_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 verify_code: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AdConnectorOfficeSite resource.
        :param pulumi.Input[_builtins.str] ad_connector_office_site_name: The name of the workspace. The name must be 2 to 255 characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] cidr_block: Workspace Corresponds to the Security Office Network of IPv4 Segment.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_addresses: The IP address N of the DNS server of the enterprise AD system. You can specify only one IP address.
        :param pulumi.Input[_builtins.str] domain_name: The domain name of the enterprise AD system. You can register each domain name only once.
        :param pulumi.Input[_builtins.str] ad_hostname: The ad hostname.
        :param pulumi.Input[_builtins.int] bandwidth: The maximum public bandwidth value. Valid values: 0 to 200. If you do not specify this parameter or you set this parameter to 0, Internet access is disabled.
        :param pulumi.Input[_builtins.str] cen_owner_id: The cen owner id.
        :param pulumi.Input[_builtins.str] desktop_access_type: The method that you use to connect to cloud desktops. **Note:** The VPC connection method is provided by Alibaba Cloud PrivateLink. You are not charged for PrivateLink. When you set this parameter to VPC or Any, PrivateLink is automatically activated. Default value: `INTERNET`. Valid values:
               - `INTERNET`: connects clients to cloud desktops only over the Internet.
               - `VPC`: connects clients to cloud desktops only over a VPC.
               - `ANY`: connects clients to cloud desktops over the Internet or a VPC. You can select a connection method when you use a client to connect to the cloud desktop.
        :param pulumi.Input[_builtins.str] domain_password: The password of the domain administrator. The password can be up to 64 characters in length.
        :param pulumi.Input[_builtins.str] domain_user_name: The username of the domain administrator. The username can be up to 64 characters in length.
        :param pulumi.Input[_builtins.bool] enable_admin_access: Specifies whether to grant the permissions of the local administrator to the desktop users. Default value: true.
        :param pulumi.Input[_builtins.bool] enable_internet_access: Specifies whether to enable Internet access.
        :param pulumi.Input[_builtins.bool] mfa_enabled: Specifies whether to enable multi-factor authentication (MFA).
        :param pulumi.Input[_builtins.str] protocol_type: The protocol type. Valid values: `ASP`, `HDX`.
        :param pulumi.Input[_builtins.int] specification: The AD Connector specifications. Valid values: `1`, `2`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sub_domain_dns_addresses: The DNS address N of the enterprise AD subdomain. If you specify a value for the `sub_domain_name` parameter but you do not specify a value for this parameter, the DNS address of the subdomain is the same as the DNS address of the parent domain.
        :param pulumi.Input[_builtins.str] sub_domain_name: The domain name of the enterprise AD subdomain.
        :param pulumi.Input[_builtins.str] verify_code: The verification code. If the CEN instance that you specify for the CenId parameter belongs to another Alibaba Cloud account, you must call the SendVerifyCode operation to obtain the verification code.
        """
        pulumi.set(__self__, "ad_connector_office_site_name", ad_connector_office_site_name)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "dns_addresses", dns_addresses)
        pulumi.set(__self__, "domain_name", domain_name)
        if ad_hostname is not None:
            pulumi.set(__self__, "ad_hostname", ad_hostname)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if cen_owner_id is not None:
            pulumi.set(__self__, "cen_owner_id", cen_owner_id)
        if desktop_access_type is not None:
            pulumi.set(__self__, "desktop_access_type", desktop_access_type)
        if domain_password is not None:
            pulumi.set(__self__, "domain_password", domain_password)
        if domain_user_name is not None:
            pulumi.set(__self__, "domain_user_name", domain_user_name)
        if enable_admin_access is not None:
            pulumi.set(__self__, "enable_admin_access", enable_admin_access)
        if enable_internet_access is not None:
            pulumi.set(__self__, "enable_internet_access", enable_internet_access)
        if mfa_enabled is not None:
            pulumi.set(__self__, "mfa_enabled", mfa_enabled)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)
        if specification is not None:
            pulumi.set(__self__, "specification", specification)
        if sub_domain_dns_addresses is not None:
            pulumi.set(__self__, "sub_domain_dns_addresses", sub_domain_dns_addresses)
        if sub_domain_name is not None:
            pulumi.set(__self__, "sub_domain_name", sub_domain_name)
        if verify_code is not None:
            pulumi.set(__self__, "verify_code", verify_code)

    @_builtins.property
    @pulumi.getter(name="adConnectorOfficeSiteName")
    def ad_connector_office_site_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the workspace. The name must be 2 to 255 characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain digits, colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "ad_connector_office_site_name")

    @ad_connector_office_site_name.setter
    def ad_connector_office_site_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ad_connector_office_site_name", value)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Input[_builtins.str]:
        """
        Workspace Corresponds to the Security Office Network of IPv4 Segment.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="dnsAddresses")
    def dns_addresses(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The IP address N of the DNS server of the enterprise AD system. You can specify only one IP address.
        """
        return pulumi.get(self, "dns_addresses")

    @dns_addresses.setter
    def dns_addresses(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "dns_addresses", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[_builtins.str]:
        """
        The domain name of the enterprise AD system. You can register each domain name only once.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="adHostname")
    def ad_hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ad hostname.
        """
        return pulumi.get(self, "ad_hostname")

    @ad_hostname.setter
    def ad_hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ad_hostname", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum public bandwidth value. Valid values: 0 to 200. If you do not specify this parameter or you set this parameter to 0, Internet access is disabled.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="cenOwnerId")
    def cen_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cen owner id.
        """
        return pulumi.get(self, "cen_owner_id")

    @cen_owner_id.setter
    def cen_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="desktopAccessType")
    def desktop_access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method that you use to connect to cloud desktops. **Note:** The VPC connection method is provided by Alibaba Cloud PrivateLink. You are not charged for PrivateLink. When you set this parameter to VPC or Any, PrivateLink is automatically activated. Default value: `INTERNET`. Valid values:
        - `INTERNET`: connects clients to cloud desktops only over the Internet.
        - `VPC`: connects clients to cloud desktops only over a VPC.
        - `ANY`: connects clients to cloud desktops over the Internet or a VPC. You can select a connection method when you use a client to connect to the cloud desktop.
        """
        return pulumi.get(self, "desktop_access_type")

    @desktop_access_type.setter
    def desktop_access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desktop_access_type", value)

    @_builtins.property
    @pulumi.getter(name="domainPassword")
    def domain_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the domain administrator. The password can be up to 64 characters in length.
        """
        return pulumi.get(self, "domain_password")

    @domain_password.setter
    def domain_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_password", value)

    @_builtins.property
    @pulumi.getter(name="domainUserName")
    def domain_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the domain administrator. The username can be up to 64 characters in length.
        """
        return pulumi.get(self, "domain_user_name")

    @domain_user_name.setter
    def domain_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_user_name", value)

    @_builtins.property
    @pulumi.getter(name="enableAdminAccess")
    def enable_admin_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to grant the permissions of the local administrator to the desktop users. Default value: true.
        """
        return pulumi.get(self, "enable_admin_access")

    @enable_admin_access.setter
    def enable_admin_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_admin_access", value)

    @_builtins.property
    @pulumi.getter(name="enableInternetAccess")
    def enable_internet_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable Internet access.
        """
        return pulumi.get(self, "enable_internet_access")

    @enable_internet_access.setter
    def enable_internet_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_internet_access", value)

    @_builtins.property
    @pulumi.getter(name="mfaEnabled")
    def mfa_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable multi-factor authentication (MFA).
        """
        return pulumi.get(self, "mfa_enabled")

    @mfa_enabled.setter
    def mfa_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mfa_enabled", value)

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol type. Valid values: `ASP`, `HDX`.
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol_type", value)

    @_builtins.property
    @pulumi.getter
    def specification(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The AD Connector specifications. Valid values: `1`, `2`.
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "specification", value)

    @_builtins.property
    @pulumi.getter(name="subDomainDnsAddresses")
    def sub_domain_dns_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The DNS address N of the enterprise AD subdomain. If you specify a value for the `sub_domain_name` parameter but you do not specify a value for this parameter, the DNS address of the subdomain is the same as the DNS address of the parent domain.
        """
        return pulumi.get(self, "sub_domain_dns_addresses")

    @sub_domain_dns_addresses.setter
    def sub_domain_dns_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sub_domain_dns_addresses", value)

    @_builtins.property
    @pulumi.getter(name="subDomainName")
    def sub_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name of the enterprise AD subdomain.
        """
        return pulumi.get(self, "sub_domain_name")

    @sub_domain_name.setter
    def sub_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="verifyCode")
    def verify_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The verification code. If the CEN instance that you specify for the CenId parameter belongs to another Alibaba Cloud account, you must call the SendVerifyCode operation to obtain the verification code.
        """
        return pulumi.get(self, "verify_code")

    @verify_code.setter
    def verify_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "verify_code", value)


@pulumi.input_type
class _AdConnectorOfficeSiteState:
    def __init__(__self__, *,
                 ad_connector_office_site_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ad_hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 desktop_access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_password: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_admin_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 mfa_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_domain_dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sub_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 verify_code: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AdConnectorOfficeSite resources.
        :param pulumi.Input[_builtins.str] ad_connector_office_site_name: The name of the workspace. The name must be 2 to 255 characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] ad_hostname: The ad hostname.
        :param pulumi.Input[_builtins.int] bandwidth: The maximum public bandwidth value. Valid values: 0 to 200. If you do not specify this parameter or you set this parameter to 0, Internet access is disabled.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] cen_owner_id: The cen owner id.
        :param pulumi.Input[_builtins.str] cidr_block: Workspace Corresponds to the Security Office Network of IPv4 Segment.
        :param pulumi.Input[_builtins.str] desktop_access_type: The method that you use to connect to cloud desktops. **Note:** The VPC connection method is provided by Alibaba Cloud PrivateLink. You are not charged for PrivateLink. When you set this parameter to VPC or Any, PrivateLink is automatically activated. Default value: `INTERNET`. Valid values:
               - `INTERNET`: connects clients to cloud desktops only over the Internet.
               - `VPC`: connects clients to cloud desktops only over a VPC.
               - `ANY`: connects clients to cloud desktops over the Internet or a VPC. You can select a connection method when you use a client to connect to the cloud desktop.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_addresses: The IP address N of the DNS server of the enterprise AD system. You can specify only one IP address.
        :param pulumi.Input[_builtins.str] domain_name: The domain name of the enterprise AD system. You can register each domain name only once.
        :param pulumi.Input[_builtins.str] domain_password: The password of the domain administrator. The password can be up to 64 characters in length.
        :param pulumi.Input[_builtins.str] domain_user_name: The username of the domain administrator. The username can be up to 64 characters in length.
        :param pulumi.Input[_builtins.bool] enable_admin_access: Specifies whether to grant the permissions of the local administrator to the desktop users. Default value: true.
        :param pulumi.Input[_builtins.bool] enable_internet_access: Specifies whether to enable Internet access.
        :param pulumi.Input[_builtins.bool] mfa_enabled: Specifies whether to enable multi-factor authentication (MFA).
        :param pulumi.Input[_builtins.str] protocol_type: The protocol type. Valid values: `ASP`, `HDX`.
        :param pulumi.Input[_builtins.int] specification: The AD Connector specifications. Valid values: `1`, `2`.
        :param pulumi.Input[_builtins.str] status: The resource State.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sub_domain_dns_addresses: The DNS address N of the enterprise AD subdomain. If you specify a value for the `sub_domain_name` parameter but you do not specify a value for this parameter, the DNS address of the subdomain is the same as the DNS address of the parent domain.
        :param pulumi.Input[_builtins.str] sub_domain_name: The domain name of the enterprise AD subdomain.
        :param pulumi.Input[_builtins.str] verify_code: The verification code. If the CEN instance that you specify for the CenId parameter belongs to another Alibaba Cloud account, you must call the SendVerifyCode operation to obtain the verification code.
        """
        if ad_connector_office_site_name is not None:
            pulumi.set(__self__, "ad_connector_office_site_name", ad_connector_office_site_name)
        if ad_hostname is not None:
            pulumi.set(__self__, "ad_hostname", ad_hostname)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if cen_owner_id is not None:
            pulumi.set(__self__, "cen_owner_id", cen_owner_id)
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if desktop_access_type is not None:
            pulumi.set(__self__, "desktop_access_type", desktop_access_type)
        if dns_addresses is not None:
            pulumi.set(__self__, "dns_addresses", dns_addresses)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if domain_password is not None:
            pulumi.set(__self__, "domain_password", domain_password)
        if domain_user_name is not None:
            pulumi.set(__self__, "domain_user_name", domain_user_name)
        if enable_admin_access is not None:
            pulumi.set(__self__, "enable_admin_access", enable_admin_access)
        if enable_internet_access is not None:
            pulumi.set(__self__, "enable_internet_access", enable_internet_access)
        if mfa_enabled is not None:
            pulumi.set(__self__, "mfa_enabled", mfa_enabled)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)
        if specification is not None:
            pulumi.set(__self__, "specification", specification)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sub_domain_dns_addresses is not None:
            pulumi.set(__self__, "sub_domain_dns_addresses", sub_domain_dns_addresses)
        if sub_domain_name is not None:
            pulumi.set(__self__, "sub_domain_name", sub_domain_name)
        if verify_code is not None:
            pulumi.set(__self__, "verify_code", verify_code)

    @_builtins.property
    @pulumi.getter(name="adConnectorOfficeSiteName")
    def ad_connector_office_site_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the workspace. The name must be 2 to 255 characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain digits, colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "ad_connector_office_site_name")

    @ad_connector_office_site_name.setter
    def ad_connector_office_site_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ad_connector_office_site_name", value)

    @_builtins.property
    @pulumi.getter(name="adHostname")
    def ad_hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ad hostname.
        """
        return pulumi.get(self, "ad_hostname")

    @ad_hostname.setter
    def ad_hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ad_hostname", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum public bandwidth value. Valid values: 0 to 200. If you do not specify this parameter or you set this parameter to 0, Internet access is disabled.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="cenOwnerId")
    def cen_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cen owner id.
        """
        return pulumi.get(self, "cen_owner_id")

    @cen_owner_id.setter
    def cen_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace Corresponds to the Security Office Network of IPv4 Segment.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="desktopAccessType")
    def desktop_access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method that you use to connect to cloud desktops. **Note:** The VPC connection method is provided by Alibaba Cloud PrivateLink. You are not charged for PrivateLink. When you set this parameter to VPC or Any, PrivateLink is automatically activated. Default value: `INTERNET`. Valid values:
        - `INTERNET`: connects clients to cloud desktops only over the Internet.
        - `VPC`: connects clients to cloud desktops only over a VPC.
        - `ANY`: connects clients to cloud desktops over the Internet or a VPC. You can select a connection method when you use a client to connect to the cloud desktop.
        """
        return pulumi.get(self, "desktop_access_type")

    @desktop_access_type.setter
    def desktop_access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desktop_access_type", value)

    @_builtins.property
    @pulumi.getter(name="dnsAddresses")
    def dns_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IP address N of the DNS server of the enterprise AD system. You can specify only one IP address.
        """
        return pulumi.get(self, "dns_addresses")

    @dns_addresses.setter
    def dns_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_addresses", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name of the enterprise AD system. You can register each domain name only once.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="domainPassword")
    def domain_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the domain administrator. The password can be up to 64 characters in length.
        """
        return pulumi.get(self, "domain_password")

    @domain_password.setter
    def domain_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_password", value)

    @_builtins.property
    @pulumi.getter(name="domainUserName")
    def domain_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the domain administrator. The username can be up to 64 characters in length.
        """
        return pulumi.get(self, "domain_user_name")

    @domain_user_name.setter
    def domain_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_user_name", value)

    @_builtins.property
    @pulumi.getter(name="enableAdminAccess")
    def enable_admin_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to grant the permissions of the local administrator to the desktop users. Default value: true.
        """
        return pulumi.get(self, "enable_admin_access")

    @enable_admin_access.setter
    def enable_admin_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_admin_access", value)

    @_builtins.property
    @pulumi.getter(name="enableInternetAccess")
    def enable_internet_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable Internet access.
        """
        return pulumi.get(self, "enable_internet_access")

    @enable_internet_access.setter
    def enable_internet_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_internet_access", value)

    @_builtins.property
    @pulumi.getter(name="mfaEnabled")
    def mfa_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable multi-factor authentication (MFA).
        """
        return pulumi.get(self, "mfa_enabled")

    @mfa_enabled.setter
    def mfa_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mfa_enabled", value)

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol type. Valid values: `ASP`, `HDX`.
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol_type", value)

    @_builtins.property
    @pulumi.getter
    def specification(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The AD Connector specifications. Valid values: `1`, `2`.
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "specification", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource State.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subDomainDnsAddresses")
    def sub_domain_dns_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The DNS address N of the enterprise AD subdomain. If you specify a value for the `sub_domain_name` parameter but you do not specify a value for this parameter, the DNS address of the subdomain is the same as the DNS address of the parent domain.
        """
        return pulumi.get(self, "sub_domain_dns_addresses")

    @sub_domain_dns_addresses.setter
    def sub_domain_dns_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sub_domain_dns_addresses", value)

    @_builtins.property
    @pulumi.getter(name="subDomainName")
    def sub_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name of the enterprise AD subdomain.
        """
        return pulumi.get(self, "sub_domain_name")

    @sub_domain_name.setter
    def sub_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="verifyCode")
    def verify_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The verification code. If the CEN instance that you specify for the CenId parameter belongs to another Alibaba Cloud account, you must call the SendVerifyCode operation to obtain the verification code.
        """
        return pulumi.get(self, "verify_code")

    @verify_code.setter
    def verify_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "verify_code", value)


@pulumi.type_token("alicloud:eds/adConnectorOfficeSite:AdConnectorOfficeSite")
class AdConnectorOfficeSite(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ad_connector_office_site_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ad_hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 desktop_access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_password: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_admin_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 mfa_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.int]] = None,
                 sub_domain_dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sub_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 verify_code: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ECD Ad Connector Office Site resource.

        For information about ECD Ad Connector Office Site and how to use it, see [What is Ad Connector Office Site](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createadconnectorofficesite).

        > **NOTE:** Available since v1.176.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.cen.Instance("default",
            cen_instance_name=name,
            protection_level="REDUCED")
        default_ad_connector_office_site = alicloud.eds.AdConnectorOfficeSite("default",
            ad_connector_office_site_name=name,
            bandwidth=100,
            cen_id=default.id,
            cidr_block="10.0.0.0/12",
            desktop_access_type="INTERNET",
            dns_addresses=["127.0.0.2"],
            domain_name="corp.example.com",
            domain_password="Example1234",
            domain_user_name="sAMAccountName",
            enable_admin_access=False,
            enable_internet_access=False,
            mfa_enabled=False,
            sub_domain_dns_addresses=["127.0.0.3"],
            sub_domain_name="child.example.com")
        ```

        ## Import

        ECD Ad Connector Office Site can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eds/adConnectorOfficeSite:AdConnectorOfficeSite example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ad_connector_office_site_name: The name of the workspace. The name must be 2 to 255 characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] ad_hostname: The ad hostname.
        :param pulumi.Input[_builtins.int] bandwidth: The maximum public bandwidth value. Valid values: 0 to 200. If you do not specify this parameter or you set this parameter to 0, Internet access is disabled.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] cen_owner_id: The cen owner id.
        :param pulumi.Input[_builtins.str] cidr_block: Workspace Corresponds to the Security Office Network of IPv4 Segment.
        :param pulumi.Input[_builtins.str] desktop_access_type: The method that you use to connect to cloud desktops. **Note:** The VPC connection method is provided by Alibaba Cloud PrivateLink. You are not charged for PrivateLink. When you set this parameter to VPC or Any, PrivateLink is automatically activated. Default value: `INTERNET`. Valid values:
               - `INTERNET`: connects clients to cloud desktops only over the Internet.
               - `VPC`: connects clients to cloud desktops only over a VPC.
               - `ANY`: connects clients to cloud desktops over the Internet or a VPC. You can select a connection method when you use a client to connect to the cloud desktop.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_addresses: The IP address N of the DNS server of the enterprise AD system. You can specify only one IP address.
        :param pulumi.Input[_builtins.str] domain_name: The domain name of the enterprise AD system. You can register each domain name only once.
        :param pulumi.Input[_builtins.str] domain_password: The password of the domain administrator. The password can be up to 64 characters in length.
        :param pulumi.Input[_builtins.str] domain_user_name: The username of the domain administrator. The username can be up to 64 characters in length.
        :param pulumi.Input[_builtins.bool] enable_admin_access: Specifies whether to grant the permissions of the local administrator to the desktop users. Default value: true.
        :param pulumi.Input[_builtins.bool] enable_internet_access: Specifies whether to enable Internet access.
        :param pulumi.Input[_builtins.bool] mfa_enabled: Specifies whether to enable multi-factor authentication (MFA).
        :param pulumi.Input[_builtins.str] protocol_type: The protocol type. Valid values: `ASP`, `HDX`.
        :param pulumi.Input[_builtins.int] specification: The AD Connector specifications. Valid values: `1`, `2`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sub_domain_dns_addresses: The DNS address N of the enterprise AD subdomain. If you specify a value for the `sub_domain_name` parameter but you do not specify a value for this parameter, the DNS address of the subdomain is the same as the DNS address of the parent domain.
        :param pulumi.Input[_builtins.str] sub_domain_name: The domain name of the enterprise AD subdomain.
        :param pulumi.Input[_builtins.str] verify_code: The verification code. If the CEN instance that you specify for the CenId parameter belongs to another Alibaba Cloud account, you must call the SendVerifyCode operation to obtain the verification code.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AdConnectorOfficeSiteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECD Ad Connector Office Site resource.

        For information about ECD Ad Connector Office Site and how to use it, see [What is Ad Connector Office Site](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createadconnectorofficesite).

        > **NOTE:** Available since v1.176.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.cen.Instance("default",
            cen_instance_name=name,
            protection_level="REDUCED")
        default_ad_connector_office_site = alicloud.eds.AdConnectorOfficeSite("default",
            ad_connector_office_site_name=name,
            bandwidth=100,
            cen_id=default.id,
            cidr_block="10.0.0.0/12",
            desktop_access_type="INTERNET",
            dns_addresses=["127.0.0.2"],
            domain_name="corp.example.com",
            domain_password="Example1234",
            domain_user_name="sAMAccountName",
            enable_admin_access=False,
            enable_internet_access=False,
            mfa_enabled=False,
            sub_domain_dns_addresses=["127.0.0.3"],
            sub_domain_name="child.example.com")
        ```

        ## Import

        ECD Ad Connector Office Site can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eds/adConnectorOfficeSite:AdConnectorOfficeSite example <id>
        ```

        :param str resource_name: The name of the resource.
        :param AdConnectorOfficeSiteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AdConnectorOfficeSiteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ad_connector_office_site_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ad_hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 desktop_access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_password: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_admin_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 mfa_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.int]] = None,
                 sub_domain_dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sub_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 verify_code: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AdConnectorOfficeSiteArgs.__new__(AdConnectorOfficeSiteArgs)

            if ad_connector_office_site_name is None and not opts.urn:
                raise TypeError("Missing required property 'ad_connector_office_site_name'")
            __props__.__dict__["ad_connector_office_site_name"] = ad_connector_office_site_name
            __props__.__dict__["ad_hostname"] = ad_hostname
            __props__.__dict__["bandwidth"] = bandwidth
            if cen_id is None and not opts.urn:
                raise TypeError("Missing required property 'cen_id'")
            __props__.__dict__["cen_id"] = cen_id
            __props__.__dict__["cen_owner_id"] = cen_owner_id
            if cidr_block is None and not opts.urn:
                raise TypeError("Missing required property 'cidr_block'")
            __props__.__dict__["cidr_block"] = cidr_block
            __props__.__dict__["desktop_access_type"] = desktop_access_type
            if dns_addresses is None and not opts.urn:
                raise TypeError("Missing required property 'dns_addresses'")
            __props__.__dict__["dns_addresses"] = dns_addresses
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["domain_password"] = None if domain_password is None else pulumi.Output.secret(domain_password)
            __props__.__dict__["domain_user_name"] = domain_user_name
            __props__.__dict__["enable_admin_access"] = enable_admin_access
            __props__.__dict__["enable_internet_access"] = enable_internet_access
            __props__.__dict__["mfa_enabled"] = mfa_enabled
            __props__.__dict__["protocol_type"] = protocol_type
            __props__.__dict__["specification"] = specification
            __props__.__dict__["sub_domain_dns_addresses"] = sub_domain_dns_addresses
            __props__.__dict__["sub_domain_name"] = sub_domain_name
            __props__.__dict__["verify_code"] = verify_code
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["domainPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AdConnectorOfficeSite, __self__).__init__(
            'alicloud:eds/adConnectorOfficeSite:AdConnectorOfficeSite',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ad_connector_office_site_name: Optional[pulumi.Input[_builtins.str]] = None,
            ad_hostname: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            cen_id: Optional[pulumi.Input[_builtins.str]] = None,
            cen_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
            cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
            desktop_access_type: Optional[pulumi.Input[_builtins.str]] = None,
            dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            domain_password: Optional[pulumi.Input[_builtins.str]] = None,
            domain_user_name: Optional[pulumi.Input[_builtins.str]] = None,
            enable_admin_access: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
            mfa_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
            specification: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            sub_domain_dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sub_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            verify_code: Optional[pulumi.Input[_builtins.str]] = None) -> 'AdConnectorOfficeSite':
        """
        Get an existing AdConnectorOfficeSite resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ad_connector_office_site_name: The name of the workspace. The name must be 2 to 255 characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] ad_hostname: The ad hostname.
        :param pulumi.Input[_builtins.int] bandwidth: The maximum public bandwidth value. Valid values: 0 to 200. If you do not specify this parameter or you set this parameter to 0, Internet access is disabled.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] cen_owner_id: The cen owner id.
        :param pulumi.Input[_builtins.str] cidr_block: Workspace Corresponds to the Security Office Network of IPv4 Segment.
        :param pulumi.Input[_builtins.str] desktop_access_type: The method that you use to connect to cloud desktops. **Note:** The VPC connection method is provided by Alibaba Cloud PrivateLink. You are not charged for PrivateLink. When you set this parameter to VPC or Any, PrivateLink is automatically activated. Default value: `INTERNET`. Valid values:
               - `INTERNET`: connects clients to cloud desktops only over the Internet.
               - `VPC`: connects clients to cloud desktops only over a VPC.
               - `ANY`: connects clients to cloud desktops over the Internet or a VPC. You can select a connection method when you use a client to connect to the cloud desktop.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_addresses: The IP address N of the DNS server of the enterprise AD system. You can specify only one IP address.
        :param pulumi.Input[_builtins.str] domain_name: The domain name of the enterprise AD system. You can register each domain name only once.
        :param pulumi.Input[_builtins.str] domain_password: The password of the domain administrator. The password can be up to 64 characters in length.
        :param pulumi.Input[_builtins.str] domain_user_name: The username of the domain administrator. The username can be up to 64 characters in length.
        :param pulumi.Input[_builtins.bool] enable_admin_access: Specifies whether to grant the permissions of the local administrator to the desktop users. Default value: true.
        :param pulumi.Input[_builtins.bool] enable_internet_access: Specifies whether to enable Internet access.
        :param pulumi.Input[_builtins.bool] mfa_enabled: Specifies whether to enable multi-factor authentication (MFA).
        :param pulumi.Input[_builtins.str] protocol_type: The protocol type. Valid values: `ASP`, `HDX`.
        :param pulumi.Input[_builtins.int] specification: The AD Connector specifications. Valid values: `1`, `2`.
        :param pulumi.Input[_builtins.str] status: The resource State.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sub_domain_dns_addresses: The DNS address N of the enterprise AD subdomain. If you specify a value for the `sub_domain_name` parameter but you do not specify a value for this parameter, the DNS address of the subdomain is the same as the DNS address of the parent domain.
        :param pulumi.Input[_builtins.str] sub_domain_name: The domain name of the enterprise AD subdomain.
        :param pulumi.Input[_builtins.str] verify_code: The verification code. If the CEN instance that you specify for the CenId parameter belongs to another Alibaba Cloud account, you must call the SendVerifyCode operation to obtain the verification code.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AdConnectorOfficeSiteState.__new__(_AdConnectorOfficeSiteState)

        __props__.__dict__["ad_connector_office_site_name"] = ad_connector_office_site_name
        __props__.__dict__["ad_hostname"] = ad_hostname
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["cen_id"] = cen_id
        __props__.__dict__["cen_owner_id"] = cen_owner_id
        __props__.__dict__["cidr_block"] = cidr_block
        __props__.__dict__["desktop_access_type"] = desktop_access_type
        __props__.__dict__["dns_addresses"] = dns_addresses
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["domain_password"] = domain_password
        __props__.__dict__["domain_user_name"] = domain_user_name
        __props__.__dict__["enable_admin_access"] = enable_admin_access
        __props__.__dict__["enable_internet_access"] = enable_internet_access
        __props__.__dict__["mfa_enabled"] = mfa_enabled
        __props__.__dict__["protocol_type"] = protocol_type
        __props__.__dict__["specification"] = specification
        __props__.__dict__["status"] = status
        __props__.__dict__["sub_domain_dns_addresses"] = sub_domain_dns_addresses
        __props__.__dict__["sub_domain_name"] = sub_domain_name
        __props__.__dict__["verify_code"] = verify_code
        return AdConnectorOfficeSite(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adConnectorOfficeSiteName")
    def ad_connector_office_site_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the workspace. The name must be 2 to 255 characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain digits, colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "ad_connector_office_site_name")

    @_builtins.property
    @pulumi.getter(name="adHostname")
    def ad_hostname(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ad hostname.
        """
        return pulumi.get(self, "ad_hostname")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum public bandwidth value. Valid values: 0 to 200. If you do not specify this parameter or you set this parameter to 0, Internet access is disabled.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="cenOwnerId")
    def cen_owner_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The cen owner id.
        """
        return pulumi.get(self, "cen_owner_id")

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Output[_builtins.str]:
        """
        Workspace Corresponds to the Security Office Network of IPv4 Segment.
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter(name="desktopAccessType")
    def desktop_access_type(self) -> pulumi.Output[_builtins.str]:
        """
        The method that you use to connect to cloud desktops. **Note:** The VPC connection method is provided by Alibaba Cloud PrivateLink. You are not charged for PrivateLink. When you set this parameter to VPC or Any, PrivateLink is automatically activated. Default value: `INTERNET`. Valid values:
        - `INTERNET`: connects clients to cloud desktops only over the Internet.
        - `VPC`: connects clients to cloud desktops only over a VPC.
        - `ANY`: connects clients to cloud desktops over the Internet or a VPC. You can select a connection method when you use a client to connect to the cloud desktop.
        """
        return pulumi.get(self, "desktop_access_type")

    @_builtins.property
    @pulumi.getter(name="dnsAddresses")
    def dns_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The IP address N of the DNS server of the enterprise AD system. You can specify only one IP address.
        """
        return pulumi.get(self, "dns_addresses")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name of the enterprise AD system. You can register each domain name only once.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="domainPassword")
    def domain_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of the domain administrator. The password can be up to 64 characters in length.
        """
        return pulumi.get(self, "domain_password")

    @_builtins.property
    @pulumi.getter(name="domainUserName")
    def domain_user_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The username of the domain administrator. The username can be up to 64 characters in length.
        """
        return pulumi.get(self, "domain_user_name")

    @_builtins.property
    @pulumi.getter(name="enableAdminAccess")
    def enable_admin_access(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to grant the permissions of the local administrator to the desktop users. Default value: true.
        """
        return pulumi.get(self, "enable_admin_access")

    @_builtins.property
    @pulumi.getter(name="enableInternetAccess")
    def enable_internet_access(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable Internet access.
        """
        return pulumi.get(self, "enable_internet_access")

    @_builtins.property
    @pulumi.getter(name="mfaEnabled")
    def mfa_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable multi-factor authentication (MFA).
        """
        return pulumi.get(self, "mfa_enabled")

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The protocol type. Valid values: `ASP`, `HDX`.
        """
        return pulumi.get(self, "protocol_type")

    @_builtins.property
    @pulumi.getter
    def specification(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The AD Connector specifications. Valid values: `1`, `2`.
        """
        return pulumi.get(self, "specification")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The resource State.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subDomainDnsAddresses")
    def sub_domain_dns_addresses(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The DNS address N of the enterprise AD subdomain. If you specify a value for the `sub_domain_name` parameter but you do not specify a value for this parameter, the DNS address of the subdomain is the same as the DNS address of the parent domain.
        """
        return pulumi.get(self, "sub_domain_dns_addresses")

    @_builtins.property
    @pulumi.getter(name="subDomainName")
    def sub_domain_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The domain name of the enterprise AD subdomain.
        """
        return pulumi.get(self, "sub_domain_name")

    @_builtins.property
    @pulumi.getter(name="verifyCode")
    def verify_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The verification code. If the CEN instance that you specify for the CenId parameter belongs to another Alibaba Cloud account, you must call the SendVerifyCode operation to obtain the verification code.
        """
        return pulumi.get(self, "verify_code")

