# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkPackageArgs', 'NetworkPackage']

@pulumi.input_type
class NetworkPackageArgs:
    def __init__(__self__, *,
                 bandwidth: pulumi.Input[_builtins.int],
                 office_site_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a NetworkPackage resource.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth of package public network bandwidth peak. Valid values: 1~200. Unit:Mbps.
        :param pulumi.Input[_builtins.str] office_site_id: The ID of office site.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "office_site_id", office_site_id)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Input[_builtins.int]:
        """
        The bandwidth of package public network bandwidth peak. Valid values: 1~200. Unit:Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="officeSiteId")
    def office_site_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of office site.
        """
        return pulumi.get(self, "office_site_id")

    @office_site_id.setter
    def office_site_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "office_site_id", value)


@pulumi.input_type
class _NetworkPackageState:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 office_site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkPackage resources.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth of package public network bandwidth peak. Valid values: 1~200. Unit:Mbps.
        :param pulumi.Input[_builtins.str] internet_charge_type: The internet charge type  of  package.
        :param pulumi.Input[_builtins.str] office_site_id: The ID of office site.
        :param pulumi.Input[_builtins.str] status: The status of network package. Valid values: `Creating`, `InUse`, `Releasing`,`Released`.
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if office_site_id is not None:
            pulumi.set(__self__, "office_site_id", office_site_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth of package public network bandwidth peak. Valid values: 1~200. Unit:Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internet charge type  of  package.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="officeSiteId")
    def office_site_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of office site.
        """
        return pulumi.get(self, "office_site_id")

    @office_site_id.setter
    def office_site_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "office_site_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of network package. Valid values: `Creating`, `InUse`, `Releasing`,`Released`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:eds/networkPackage:NetworkPackage")
class NetworkPackage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 office_site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ECD Network Package resource.

        For information about ECD Network Package and how to use it, see [What is Network Package](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createnetworkpackage).

        > **NOTE:** Available since v1.142.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_simple_office_site = alicloud.eds.SimpleOfficeSite("default",
            cidr_block="172.16.0.0/12",
            enable_admin_access=True,
            desktop_access_type="Internet",
            office_site_name=f"terraform-example-{default['result']}")
        default_network_package = alicloud.eds.NetworkPackage("default",
            bandwidth=10,
            office_site_id=default_simple_office_site.id)
        ```

        ## Import

        ECD Network Package can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eds/networkPackage:NetworkPackage example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth of package public network bandwidth peak. Valid values: 1~200. Unit:Mbps.
        :param pulumi.Input[_builtins.str] office_site_id: The ID of office site.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkPackageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECD Network Package resource.

        For information about ECD Network Package and how to use it, see [What is Network Package](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createnetworkpackage).

        > **NOTE:** Available since v1.142.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_simple_office_site = alicloud.eds.SimpleOfficeSite("default",
            cidr_block="172.16.0.0/12",
            enable_admin_access=True,
            desktop_access_type="Internet",
            office_site_name=f"terraform-example-{default['result']}")
        default_network_package = alicloud.eds.NetworkPackage("default",
            bandwidth=10,
            office_site_id=default_simple_office_site.id)
        ```

        ## Import

        ECD Network Package can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eds/networkPackage:NetworkPackage example <id>
        ```

        :param str resource_name: The name of the resource.
        :param NetworkPackageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkPackageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 office_site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkPackageArgs.__new__(NetworkPackageArgs)

            if bandwidth is None and not opts.urn:
                raise TypeError("Missing required property 'bandwidth'")
            __props__.__dict__["bandwidth"] = bandwidth
            if office_site_id is None and not opts.urn:
                raise TypeError("Missing required property 'office_site_id'")
            __props__.__dict__["office_site_id"] = office_site_id
            __props__.__dict__["internet_charge_type"] = None
            __props__.__dict__["status"] = None
        super(NetworkPackage, __self__).__init__(
            'alicloud:eds/networkPackage:NetworkPackage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            office_site_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkPackage':
        """
        Get an existing NetworkPackage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth of package public network bandwidth peak. Valid values: 1~200. Unit:Mbps.
        :param pulumi.Input[_builtins.str] internet_charge_type: The internet charge type  of  package.
        :param pulumi.Input[_builtins.str] office_site_id: The ID of office site.
        :param pulumi.Input[_builtins.str] status: The status of network package. Valid values: `Creating`, `InUse`, `Releasing`,`Released`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkPackageState.__new__(_NetworkPackageState)

        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["office_site_id"] = office_site_id
        __props__.__dict__["status"] = status
        return NetworkPackage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[_builtins.int]:
        """
        The bandwidth of package public network bandwidth peak. Valid values: 1~200. Unit:Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        The internet charge type  of  package.
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="officeSiteId")
    def office_site_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of office site.
        """
        return pulumi.get(self, "office_site_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of network package. Valid values: `Creating`, `InUse`, `Releasing`,`Released`.
        """
        return pulumi.get(self, "status")

