# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSubnetsResult',
    'AwaitableGetSubnetsResult',
    'get_subnets',
    'get_subnets_output',
]

@pulumi.output_type
class GetSubnetsResult:
    """
    A collection of values returned by getSubnets.
    """
    def __init__(__self__, id=None, ids=None, name_regex=None, names=None, output_file=None, page_number=None, page_size=None, resource_group_id=None, status=None, subnet_id=None, subnet_name=None, subnets=None, type=None, vpd_id=None, zone_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if subnet_name and not isinstance(subnet_name, str):
            raise TypeError("Expected argument 'subnet_name' to be a str")
        pulumi.set(__self__, "subnet_name", subnet_name)
        if subnets and not isinstance(subnets, list):
            raise TypeError("Expected argument 'subnets' to be a list")
        pulumi.set(__self__, "subnets", subnets)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vpd_id and not isinstance(vpd_id, str):
            raise TypeError("Expected argument 'vpd_id' to be a str")
        pulumi.set(__self__, "vpd_id", vpd_id)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of name of Subnets.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        """
        Resource Group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        The Eflo subnet ID.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> Optional[_builtins.str]:
        """
        The Subnet name.
        """
        return pulumi.get(self, "subnet_name")

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Sequence['outputs.GetSubnetsSubnetResult']:
        """
        A list of Subnet Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "subnets")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Eflo subnet usage type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vpdId")
    def vpd_id(self) -> Optional[_builtins.str]:
        """
        Eflo VPD ID.
        """
        return pulumi.get(self, "vpd_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        """
        The zone ID of the resource.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetSubnetsResult(GetSubnetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubnetsResult(
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            resource_group_id=self.resource_group_id,
            status=self.status,
            subnet_id=self.subnet_id,
            subnet_name=self.subnet_name,
            subnets=self.subnets,
            type=self.type,
            vpd_id=self.vpd_id,
            zone_id=self.zone_id)


def get_subnets(ids: Optional[Sequence[_builtins.str]] = None,
                name_regex: Optional[_builtins.str] = None,
                output_file: Optional[_builtins.str] = None,
                page_number: Optional[_builtins.int] = None,
                page_size: Optional[_builtins.int] = None,
                resource_group_id: Optional[_builtins.str] = None,
                status: Optional[_builtins.str] = None,
                subnet_id: Optional[_builtins.str] = None,
                subnet_name: Optional[_builtins.str] = None,
                type: Optional[_builtins.str] = None,
                vpd_id: Optional[_builtins.str] = None,
                zone_id: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubnetsResult:
    """
    This data source provides Eflo Subnet available to the user.[What is Subnet](https://help.aliyun.com/document_detail/604977.html)

    > **NOTE:** Available in 1.204.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.eflo.get_subnets(name_regex=default_alicloud_eflo_subnet["name"],
        subnet_name="SubnetTestForTerraform",
        vpd_id=vpd_id,
        zone_id=zone_id)
    pulumi.export("alicloudEfloSubnetExampleId", default.subnets[0].id)
    ```


    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: Resource Group ID.
    :param _builtins.str status: The status of the resource.
    :param _builtins.str subnet_id: Primary key ID.
    :param _builtins.str subnet_name: The Subnet name.
    :param _builtins.str type: Eflo subnet usage type, optional value: 
           - General type is not filled in
           - OOB:OOB type
           - LB: LB type
    :param _builtins.str vpd_id: The Eflo VPD ID.
    :param _builtins.str zone_id: The zone ID of the resource.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['resourceGroupId'] = resource_group_id
    __args__['status'] = status
    __args__['subnetId'] = subnet_id
    __args__['subnetName'] = subnet_name
    __args__['type'] = type
    __args__['vpdId'] = vpd_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:eflo/getSubnets:getSubnets', __args__, opts=opts, typ=GetSubnetsResult).value

    return AwaitableGetSubnetsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        status=pulumi.get(__ret__, 'status'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        subnet_name=pulumi.get(__ret__, 'subnet_name'),
        subnets=pulumi.get(__ret__, 'subnets'),
        type=pulumi.get(__ret__, 'type'),
        vpd_id=pulumi.get(__ret__, 'vpd_id'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_subnets_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                       name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       subnet_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       subnet_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       vpd_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubnetsResult]:
    """
    This data source provides Eflo Subnet available to the user.[What is Subnet](https://help.aliyun.com/document_detail/604977.html)

    > **NOTE:** Available in 1.204.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.eflo.get_subnets(name_regex=default_alicloud_eflo_subnet["name"],
        subnet_name="SubnetTestForTerraform",
        vpd_id=vpd_id,
        zone_id=zone_id)
    pulumi.export("alicloudEfloSubnetExampleId", default.subnets[0].id)
    ```


    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: Resource Group ID.
    :param _builtins.str status: The status of the resource.
    :param _builtins.str subnet_id: Primary key ID.
    :param _builtins.str subnet_name: The Subnet name.
    :param _builtins.str type: Eflo subnet usage type, optional value: 
           - General type is not filled in
           - OOB:OOB type
           - LB: LB type
    :param _builtins.str vpd_id: The Eflo VPD ID.
    :param _builtins.str zone_id: The zone ID of the resource.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['resourceGroupId'] = resource_group_id
    __args__['status'] = status
    __args__['subnetId'] = subnet_id
    __args__['subnetName'] = subnet_name
    __args__['type'] = type
    __args__['vpdId'] = vpd_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:eflo/getSubnets:getSubnets', __args__, opts=opts, typ=GetSubnetsResult)
    return __ret__.apply(lambda __response__: GetSubnetsResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        status=pulumi.get(__response__, 'status'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        subnet_name=pulumi.get(__response__, 'subnet_name'),
        subnets=pulumi.get(__response__, 'subnets'),
        type=pulumi.get(__response__, 'type'),
        vpd_id=pulumi.get(__response__, 'vpd_id'),
        zone_id=pulumi.get(__response__, 'zone_id')))
