# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InvocationArgs', 'Invocation']

@pulumi.input_type
class InvocationArgs:
    def __init__(__self__, *,
                 command_content: Optional[pulumi.Input[_builtins.str]] = None,
                 command_id: Optional[pulumi.Input[_builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_parameter: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 launcher: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 repeat_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 termination_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 working_dir: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Invocation resource.
        :param pulumi.Input[_builtins.str] command_content: The command content. You need to pay attention:
               - Specify the parameter 'EnableParameter = true' to enable the custom parameter feature in the command content.
               - Define custom parameters in the form of {{}} inclusion, and spaces and line breaks before and after the parameter name in '{{}}' are ignored.
               - The number of custom parameters cannot exceed 20.
               - Custom parameter names can a-zA-Z0-9 a combination of-_. Other characters are not supported. Parameter names are not case-sensitive.
               - A single custom parameter name cannot exceed 64 bytes.
        :param pulumi.Input[_builtins.str] command_id: Command ID
        :param pulumi.Input[_builtins.str] content_encoding: The encoding of the script content. Value range:
               - PlainText: no encoding, using PlainText transmission.
               - Base64:Base64 encoding.
               
               Default value: PlainText. If you fill it randomly or wrongly, the value will be treated as a PlainText.
        :param pulumi.Input[_builtins.str] description: The command description.
        :param pulumi.Input[_builtins.bool] enable_parameter: Whether custom parameters are included in the command.
               Default value: false.
        :param pulumi.Input[_builtins.str] frequency: The execution time of the scheduled execution command. Currently, three scheduled execution methods are supported: fixed interval execution (based on Rate expression), only once at a specified time, and timed execution based on clock (based on Cron expression).
               - Fixed time interval execution: Based on the Rate expression, the command is executed at the set time interval. Time intervals can be selected by seconds (s), minutes (m), hours (h), and days (d), which is suitable for scenarios where tasks are executed at fixed time intervals. The format is rate( ). If the execution is performed every 5 minutes, the format is rate(5m). Executing with a fixed time interval has the following limitations:
               - The set time interval is no more than 7 days and no less than 60 seconds, and must be greater than the timeout period of the scheduled task.
               - The execution interval is based only on a fixed frequency, independent of the time the task actually takes to execute. For example, if the command is executed every 5 minutes and the task takes 2 minutes to complete, the next round will be executed 3 minutes after the task is completed.
               - The task is not executed immediately when it is created. For example, if a command is executed every 5 minutes, the command is not executed immediately when a task is created, but is executed 5 minutes after the task is created.
               - Execute only once at the specified time: Execute the command once according to the set time zone and execution time point. The format is at(yyyy-MM-dd HH:mm:ss ), that is, at (year-month-day time: minute: Second ). If you do not specify a time zone, the default is the UTC time zone. Time zones can be in the following three formats: the full name of the time zone, such as Asia/Shanghai (China/Shanghai time), America/los_angles (United States/Los Angeles time), and so on. The offset of the time zone relative to Greenwich Mean Time: E.G. GMT +8:00 (East Zone 8), GMT-7 (West Zone 7), etc. When using the GMT format, the hour bit does not support adding leading zeros. Time zone abbreviation: Only UTC (Coordinated Universal Time) is supported.
               If it is specified to be executed once 13:15:30 June 06, 2022, China/Shanghai time, the format is at (Asia/Shanghai, 2022-06-06 13:15:30); If it is specified to be executed once 13:15:30 June 06, 2022, the format is at(2022-06-06 13:15:30 GMT-7:00).
               - Timing based on clock (based on Cron expression): Based on Cron expression, commands are executed according to the set timing task. The format is        , that is,  . In the specified time zone, calculate the execution time of the scheduled task based on the Cron expression and execute it. If no time zone is specified, the default time zone is the internal time zone of the scheduled task instance. For more information about Cron expressions, see Cron Expressions. Time zones support the following three forms:
               - Full time zone name: such as Asia/Shanghai (China/Shanghai time), America/los_angles (US/Los Angeles time), etc.
               - The offset of the time zone relative to Greenwich Mean Time: E.G. GMT +8:00 (East Zone 8), GMT-7 (West Zone 7), etc. When using the GMT format, the hour bit does not support adding leading zeros.
               - Time zone abbreviation: Only UTC (Coordinated Universal Time) is supported.
               
               For example, in China/Shanghai time, the command will be executed once every day at 10:15 am in 2022 in the format 0 15 10? * * 2022 Asia/Shanghai; In the eastern 8th District time, it will be executed every half hour from 10:00 a.m. to 11:30 a.m. every day in 2022, in the format of 0 0/30 10-11 * *? 2022 GMT +8:00; In UTC time, starting from 2022, it will be executed every 5 minutes from 14:00 P.M. to 14:55 p. M. Every two years in October, in the format of 0 0/5 14*10? 2022/2 UTC.
        :param pulumi.Input[_builtins.str] launcher: The bootstrapper for script execution. The length cannot exceed 1KB.
        :param pulumi.Input[_builtins.str] name: The command name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_id_lists: A list of nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: When the command contains custom parameters, the key-value pair of the custom parameters passed in when the command is executed. For example, if the command content is 'echo {{name}}', the key-value pair'{"name":"Jack"}'can be passed through the 'Parameter' parameter'. The custom parameter will automatically replace the variable value 'name' to get a new command that actually executes 'echo Jack '.
               
               The number of custom parameters ranges from 0 to 10, and you need to pay attention:
               - The key is not allowed to be an empty string and supports a maximum of 64 characters.
               - The value is allowed to be an empty string.
               - After the custom parameters and the original command content are encoded in Base64, if the command is saved, the size of the command content after Base64 encoding cannot exceed 18KB. If the command is not saved, the size of the command content after Base64 encoding cannot exceed 24KB. You can set whether to keep the command through 'KeepCommand.
               - The set of custom parameter names must be a subset of the parameter set defined when the command is created. For parameters that are not passed in, you can use an empty string instead.
               
               The default value is empty, which means that the parameter is unset and the custom parameter is disabled.
        :param pulumi.Input[_builtins.str] repeat_mode: Sets the way the command is executed. Value range:
               - Once: Execute the command immediately.
               - Period: executes the command regularly. When the value of this parameter is 'Period', the 'Frequency' parameter must also be specified.
               - NextRebootOnly: Automatically execute the command when the instance is next started.
               - EveryReboot: The command is automatically executed every time the instance is started.
               
               Default:
               - When the'frequency' parameter is not specified, the default value is'once '.
               - When the'frequency' parameter is specified, regardless of whether the parameter value has been set or not, it will be processed according to'period.
        :param pulumi.Input[_builtins.str] termination_mode: The mode when the task is stopped (manually stopped or execution time-out interrupted). Possible values:
               Process: Stops the current script Process.
               ProcessTree: Stops the current process tree (the script process and the collection of all child processes it created)
        :param pulumi.Input[_builtins.int] timeout: The timeout period for command execution. Unit: seconds. A timeout occurs when a command cannot be run due to a process, a missing module, or a missing cloud assistant Agent. After the timeout, the command process is forcibly terminated. Default value: 60.
        :param pulumi.Input[_builtins.str] username: The name of the user who executed the command in the instance. The length must not exceed 255 characters.
               The instance of the Linux system. By default, the root user runs commands.
        :param pulumi.Input[_builtins.str] working_dir: You can customize the command execution path. The default path is as follows:
               Linux instance: the execution path is in the/home directory of the root user by default.
        """
        if command_content is not None:
            pulumi.set(__self__, "command_content", command_content)
        if command_id is not None:
            pulumi.set(__self__, "command_id", command_id)
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_parameter is not None:
            pulumi.set(__self__, "enable_parameter", enable_parameter)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if launcher is not None:
            pulumi.set(__self__, "launcher", launcher)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_id_lists is not None:
            pulumi.set(__self__, "node_id_lists", node_id_lists)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if repeat_mode is not None:
            pulumi.set(__self__, "repeat_mode", repeat_mode)
        if termination_mode is not None:
            pulumi.set(__self__, "termination_mode", termination_mode)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter(name="commandContent")
    def command_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The command content. You need to pay attention:
        - Specify the parameter 'EnableParameter = true' to enable the custom parameter feature in the command content.
        - Define custom parameters in the form of {{}} inclusion, and spaces and line breaks before and after the parameter name in '{{}}' are ignored.
        - The number of custom parameters cannot exceed 20.
        - Custom parameter names can a-zA-Z0-9 a combination of-_. Other characters are not supported. Parameter names are not case-sensitive.
        - A single custom parameter name cannot exceed 64 bytes.
        """
        return pulumi.get(self, "command_content")

    @command_content.setter
    def command_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "command_content", value)

    @_builtins.property
    @pulumi.getter(name="commandId")
    def command_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Command ID
        """
        return pulumi.get(self, "command_id")

    @command_id.setter
    def command_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "command_id", value)

    @_builtins.property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encoding of the script content. Value range:
        - PlainText: no encoding, using PlainText transmission.
        - Base64:Base64 encoding.

        Default value: PlainText. If you fill it randomly or wrongly, the value will be treated as a PlainText.
        """
        return pulumi.get(self, "content_encoding")

    @content_encoding.setter
    def content_encoding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_encoding", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The command description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableParameter")
    def enable_parameter(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether custom parameters are included in the command.
        Default value: false.
        """
        return pulumi.get(self, "enable_parameter")

    @enable_parameter.setter
    def enable_parameter(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_parameter", value)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The execution time of the scheduled execution command. Currently, three scheduled execution methods are supported: fixed interval execution (based on Rate expression), only once at a specified time, and timed execution based on clock (based on Cron expression).
        - Fixed time interval execution: Based on the Rate expression, the command is executed at the set time interval. Time intervals can be selected by seconds (s), minutes (m), hours (h), and days (d), which is suitable for scenarios where tasks are executed at fixed time intervals. The format is rate( ). If the execution is performed every 5 minutes, the format is rate(5m). Executing with a fixed time interval has the following limitations:
        - The set time interval is no more than 7 days and no less than 60 seconds, and must be greater than the timeout period of the scheduled task.
        - The execution interval is based only on a fixed frequency, independent of the time the task actually takes to execute. For example, if the command is executed every 5 minutes and the task takes 2 minutes to complete, the next round will be executed 3 minutes after the task is completed.
        - The task is not executed immediately when it is created. For example, if a command is executed every 5 minutes, the command is not executed immediately when a task is created, but is executed 5 minutes after the task is created.
        - Execute only once at the specified time: Execute the command once according to the set time zone and execution time point. The format is at(yyyy-MM-dd HH:mm:ss ), that is, at (year-month-day time: minute: Second ). If you do not specify a time zone, the default is the UTC time zone. Time zones can be in the following three formats: the full name of the time zone, such as Asia/Shanghai (China/Shanghai time), America/los_angles (United States/Los Angeles time), and so on. The offset of the time zone relative to Greenwich Mean Time: E.G. GMT +8:00 (East Zone 8), GMT-7 (West Zone 7), etc. When using the GMT format, the hour bit does not support adding leading zeros. Time zone abbreviation: Only UTC (Coordinated Universal Time) is supported.
        If it is specified to be executed once 13:15:30 June 06, 2022, China/Shanghai time, the format is at (Asia/Shanghai, 2022-06-06 13:15:30); If it is specified to be executed once 13:15:30 June 06, 2022, the format is at(2022-06-06 13:15:30 GMT-7:00).
        - Timing based on clock (based on Cron expression): Based on Cron expression, commands are executed according to the set timing task. The format is        , that is,  . In the specified time zone, calculate the execution time of the scheduled task based on the Cron expression and execute it. If no time zone is specified, the default time zone is the internal time zone of the scheduled task instance. For more information about Cron expressions, see Cron Expressions. Time zones support the following three forms:
        - Full time zone name: such as Asia/Shanghai (China/Shanghai time), America/los_angles (US/Los Angeles time), etc.
        - The offset of the time zone relative to Greenwich Mean Time: E.G. GMT +8:00 (East Zone 8), GMT-7 (West Zone 7), etc. When using the GMT format, the hour bit does not support adding leading zeros.
        - Time zone abbreviation: Only UTC (Coordinated Universal Time) is supported.

        For example, in China/Shanghai time, the command will be executed once every day at 10:15 am in 2022 in the format 0 15 10? * * 2022 Asia/Shanghai; In the eastern 8th District time, it will be executed every half hour from 10:00 a.m. to 11:30 a.m. every day in 2022, in the format of 0 0/30 10-11 * *? 2022 GMT +8:00; In UTC time, starting from 2022, it will be executed every 5 minutes from 14:00 P.M. to 14:55 p. M. Every two years in October, in the format of 0 0/5 14*10? 2022/2 UTC.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter
    def launcher(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bootstrapper for script execution. The length cannot exceed 1KB.
        """
        return pulumi.get(self, "launcher")

    @launcher.setter
    def launcher(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launcher", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The command name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeIdLists")
    def node_id_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of nodes.
        """
        return pulumi.get(self, "node_id_lists")

    @node_id_lists.setter
    def node_id_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_id_lists", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        When the command contains custom parameters, the key-value pair of the custom parameters passed in when the command is executed. For example, if the command content is 'echo {{name}}', the key-value pair'{"name":"Jack"}'can be passed through the 'Parameter' parameter'. The custom parameter will automatically replace the variable value 'name' to get a new command that actually executes 'echo Jack '.

        The number of custom parameters ranges from 0 to 10, and you need to pay attention:
        - The key is not allowed to be an empty string and supports a maximum of 64 characters.
        - The value is allowed to be an empty string.
        - After the custom parameters and the original command content are encoded in Base64, if the command is saved, the size of the command content after Base64 encoding cannot exceed 18KB. If the command is not saved, the size of the command content after Base64 encoding cannot exceed 24KB. You can set whether to keep the command through 'KeepCommand.
        - The set of custom parameter names must be a subset of the parameter set defined when the command is created. For parameters that are not passed in, you can use an empty string instead.

        The default value is empty, which means that the parameter is unset and the custom parameter is disabled.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="repeatMode")
    def repeat_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the way the command is executed. Value range:
        - Once: Execute the command immediately.
        - Period: executes the command regularly. When the value of this parameter is 'Period', the 'Frequency' parameter must also be specified.
        - NextRebootOnly: Automatically execute the command when the instance is next started.
        - EveryReboot: The command is automatically executed every time the instance is started.

        Default:
        - When the'frequency' parameter is not specified, the default value is'once '.
        - When the'frequency' parameter is specified, regardless of whether the parameter value has been set or not, it will be processed according to'period.
        """
        return pulumi.get(self, "repeat_mode")

    @repeat_mode.setter
    def repeat_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repeat_mode", value)

    @_builtins.property
    @pulumi.getter(name="terminationMode")
    def termination_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode when the task is stopped (manually stopped or execution time-out interrupted). Possible values:
        Process: Stops the current script Process.
        ProcessTree: Stops the current process tree (the script process and the collection of all child processes it created)
        """
        return pulumi.get(self, "termination_mode")

    @termination_mode.setter
    def termination_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "termination_mode", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout period for command execution. Unit: seconds. A timeout occurs when a command cannot be run due to a process, a missing module, or a missing cloud assistant Agent. After the timeout, the command process is forcibly terminated. Default value: 60.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the user who executed the command in the instance. The length must not exceed 255 characters.
        The instance of the Linux system. By default, the root user runs commands.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        You can customize the command execution path. The default path is as follows:
        Linux instance: the execution path is in the/home directory of the root user by default.
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "working_dir", value)


@pulumi.input_type
class _InvocationState:
    def __init__(__self__, *,
                 command_content: Optional[pulumi.Input[_builtins.str]] = None,
                 command_id: Optional[pulumi.Input[_builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_parameter: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 launcher: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 repeat_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 termination_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 working_dir: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Invocation resources.
        :param pulumi.Input[_builtins.str] command_content: The command content. You need to pay attention:
               - Specify the parameter 'EnableParameter = true' to enable the custom parameter feature in the command content.
               - Define custom parameters in the form of {{}} inclusion, and spaces and line breaks before and after the parameter name in '{{}}' are ignored.
               - The number of custom parameters cannot exceed 20.
               - Custom parameter names can a-zA-Z0-9 a combination of-_. Other characters are not supported. Parameter names are not case-sensitive.
               - A single custom parameter name cannot exceed 64 bytes.
        :param pulumi.Input[_builtins.str] command_id: Command ID
        :param pulumi.Input[_builtins.str] content_encoding: The encoding of the script content. Value range:
               - PlainText: no encoding, using PlainText transmission.
               - Base64:Base64 encoding.
               
               Default value: PlainText. If you fill it randomly or wrongly, the value will be treated as a PlainText.
        :param pulumi.Input[_builtins.str] description: The command description.
        :param pulumi.Input[_builtins.bool] enable_parameter: Whether custom parameters are included in the command.
               Default value: false.
        :param pulumi.Input[_builtins.str] frequency: The execution time of the scheduled execution command. Currently, three scheduled execution methods are supported: fixed interval execution (based on Rate expression), only once at a specified time, and timed execution based on clock (based on Cron expression).
               - Fixed time interval execution: Based on the Rate expression, the command is executed at the set time interval. Time intervals can be selected by seconds (s), minutes (m), hours (h), and days (d), which is suitable for scenarios where tasks are executed at fixed time intervals. The format is rate( ). If the execution is performed every 5 minutes, the format is rate(5m). Executing with a fixed time interval has the following limitations:
               - The set time interval is no more than 7 days and no less than 60 seconds, and must be greater than the timeout period of the scheduled task.
               - The execution interval is based only on a fixed frequency, independent of the time the task actually takes to execute. For example, if the command is executed every 5 minutes and the task takes 2 minutes to complete, the next round will be executed 3 minutes after the task is completed.
               - The task is not executed immediately when it is created. For example, if a command is executed every 5 minutes, the command is not executed immediately when a task is created, but is executed 5 minutes after the task is created.
               - Execute only once at the specified time: Execute the command once according to the set time zone and execution time point. The format is at(yyyy-MM-dd HH:mm:ss ), that is, at (year-month-day time: minute: Second ). If you do not specify a time zone, the default is the UTC time zone. Time zones can be in the following three formats: the full name of the time zone, such as Asia/Shanghai (China/Shanghai time), America/los_angles (United States/Los Angeles time), and so on. The offset of the time zone relative to Greenwich Mean Time: E.G. GMT +8:00 (East Zone 8), GMT-7 (West Zone 7), etc. When using the GMT format, the hour bit does not support adding leading zeros. Time zone abbreviation: Only UTC (Coordinated Universal Time) is supported.
               If it is specified to be executed once 13:15:30 June 06, 2022, China/Shanghai time, the format is at (Asia/Shanghai, 2022-06-06 13:15:30); If it is specified to be executed once 13:15:30 June 06, 2022, the format is at(2022-06-06 13:15:30 GMT-7:00).
               - Timing based on clock (based on Cron expression): Based on Cron expression, commands are executed according to the set timing task. The format is        , that is,  . In the specified time zone, calculate the execution time of the scheduled task based on the Cron expression and execute it. If no time zone is specified, the default time zone is the internal time zone of the scheduled task instance. For more information about Cron expressions, see Cron Expressions. Time zones support the following three forms:
               - Full time zone name: such as Asia/Shanghai (China/Shanghai time), America/los_angles (US/Los Angeles time), etc.
               - The offset of the time zone relative to Greenwich Mean Time: E.G. GMT +8:00 (East Zone 8), GMT-7 (West Zone 7), etc. When using the GMT format, the hour bit does not support adding leading zeros.
               - Time zone abbreviation: Only UTC (Coordinated Universal Time) is supported.
               
               For example, in China/Shanghai time, the command will be executed once every day at 10:15 am in 2022 in the format 0 15 10? * * 2022 Asia/Shanghai; In the eastern 8th District time, it will be executed every half hour from 10:00 a.m. to 11:30 a.m. every day in 2022, in the format of 0 0/30 10-11 * *? 2022 GMT +8:00; In UTC time, starting from 2022, it will be executed every 5 minutes from 14:00 P.M. to 14:55 p. M. Every two years in October, in the format of 0 0/5 14*10? 2022/2 UTC.
        :param pulumi.Input[_builtins.str] launcher: The bootstrapper for script execution. The length cannot exceed 1KB.
        :param pulumi.Input[_builtins.str] name: The command name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_id_lists: A list of nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: When the command contains custom parameters, the key-value pair of the custom parameters passed in when the command is executed. For example, if the command content is 'echo {{name}}', the key-value pair'{"name":"Jack"}'can be passed through the 'Parameter' parameter'. The custom parameter will automatically replace the variable value 'name' to get a new command that actually executes 'echo Jack '.
               
               The number of custom parameters ranges from 0 to 10, and you need to pay attention:
               - The key is not allowed to be an empty string and supports a maximum of 64 characters.
               - The value is allowed to be an empty string.
               - After the custom parameters and the original command content are encoded in Base64, if the command is saved, the size of the command content after Base64 encoding cannot exceed 18KB. If the command is not saved, the size of the command content after Base64 encoding cannot exceed 24KB. You can set whether to keep the command through 'KeepCommand.
               - The set of custom parameter names must be a subset of the parameter set defined when the command is created. For parameters that are not passed in, you can use an empty string instead.
               
               The default value is empty, which means that the parameter is unset and the custom parameter is disabled.
        :param pulumi.Input[_builtins.str] repeat_mode: Sets the way the command is executed. Value range:
               - Once: Execute the command immediately.
               - Period: executes the command regularly. When the value of this parameter is 'Period', the 'Frequency' parameter must also be specified.
               - NextRebootOnly: Automatically execute the command when the instance is next started.
               - EveryReboot: The command is automatically executed every time the instance is started.
               
               Default:
               - When the'frequency' parameter is not specified, the default value is'once '.
               - When the'frequency' parameter is specified, regardless of whether the parameter value has been set or not, it will be processed according to'period.
        :param pulumi.Input[_builtins.str] termination_mode: The mode when the task is stopped (manually stopped or execution time-out interrupted). Possible values:
               Process: Stops the current script Process.
               ProcessTree: Stops the current process tree (the script process and the collection of all child processes it created)
        :param pulumi.Input[_builtins.int] timeout: The timeout period for command execution. Unit: seconds. A timeout occurs when a command cannot be run due to a process, a missing module, or a missing cloud assistant Agent. After the timeout, the command process is forcibly terminated. Default value: 60.
        :param pulumi.Input[_builtins.str] username: The name of the user who executed the command in the instance. The length must not exceed 255 characters.
               The instance of the Linux system. By default, the root user runs commands.
        :param pulumi.Input[_builtins.str] working_dir: You can customize the command execution path. The default path is as follows:
               Linux instance: the execution path is in the/home directory of the root user by default.
        """
        if command_content is not None:
            pulumi.set(__self__, "command_content", command_content)
        if command_id is not None:
            pulumi.set(__self__, "command_id", command_id)
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_parameter is not None:
            pulumi.set(__self__, "enable_parameter", enable_parameter)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if launcher is not None:
            pulumi.set(__self__, "launcher", launcher)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_id_lists is not None:
            pulumi.set(__self__, "node_id_lists", node_id_lists)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if repeat_mode is not None:
            pulumi.set(__self__, "repeat_mode", repeat_mode)
        if termination_mode is not None:
            pulumi.set(__self__, "termination_mode", termination_mode)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter(name="commandContent")
    def command_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The command content. You need to pay attention:
        - Specify the parameter 'EnableParameter = true' to enable the custom parameter feature in the command content.
        - Define custom parameters in the form of {{}} inclusion, and spaces and line breaks before and after the parameter name in '{{}}' are ignored.
        - The number of custom parameters cannot exceed 20.
        - Custom parameter names can a-zA-Z0-9 a combination of-_. Other characters are not supported. Parameter names are not case-sensitive.
        - A single custom parameter name cannot exceed 64 bytes.
        """
        return pulumi.get(self, "command_content")

    @command_content.setter
    def command_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "command_content", value)

    @_builtins.property
    @pulumi.getter(name="commandId")
    def command_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Command ID
        """
        return pulumi.get(self, "command_id")

    @command_id.setter
    def command_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "command_id", value)

    @_builtins.property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encoding of the script content. Value range:
        - PlainText: no encoding, using PlainText transmission.
        - Base64:Base64 encoding.

        Default value: PlainText. If you fill it randomly or wrongly, the value will be treated as a PlainText.
        """
        return pulumi.get(self, "content_encoding")

    @content_encoding.setter
    def content_encoding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_encoding", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The command description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableParameter")
    def enable_parameter(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether custom parameters are included in the command.
        Default value: false.
        """
        return pulumi.get(self, "enable_parameter")

    @enable_parameter.setter
    def enable_parameter(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_parameter", value)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The execution time of the scheduled execution command. Currently, three scheduled execution methods are supported: fixed interval execution (based on Rate expression), only once at a specified time, and timed execution based on clock (based on Cron expression).
        - Fixed time interval execution: Based on the Rate expression, the command is executed at the set time interval. Time intervals can be selected by seconds (s), minutes (m), hours (h), and days (d), which is suitable for scenarios where tasks are executed at fixed time intervals. The format is rate( ). If the execution is performed every 5 minutes, the format is rate(5m). Executing with a fixed time interval has the following limitations:
        - The set time interval is no more than 7 days and no less than 60 seconds, and must be greater than the timeout period of the scheduled task.
        - The execution interval is based only on a fixed frequency, independent of the time the task actually takes to execute. For example, if the command is executed every 5 minutes and the task takes 2 minutes to complete, the next round will be executed 3 minutes after the task is completed.
        - The task is not executed immediately when it is created. For example, if a command is executed every 5 minutes, the command is not executed immediately when a task is created, but is executed 5 minutes after the task is created.
        - Execute only once at the specified time: Execute the command once according to the set time zone and execution time point. The format is at(yyyy-MM-dd HH:mm:ss ), that is, at (year-month-day time: minute: Second ). If you do not specify a time zone, the default is the UTC time zone. Time zones can be in the following three formats: the full name of the time zone, such as Asia/Shanghai (China/Shanghai time), America/los_angles (United States/Los Angeles time), and so on. The offset of the time zone relative to Greenwich Mean Time: E.G. GMT +8:00 (East Zone 8), GMT-7 (West Zone 7), etc. When using the GMT format, the hour bit does not support adding leading zeros. Time zone abbreviation: Only UTC (Coordinated Universal Time) is supported.
        If it is specified to be executed once 13:15:30 June 06, 2022, China/Shanghai time, the format is at (Asia/Shanghai, 2022-06-06 13:15:30); If it is specified to be executed once 13:15:30 June 06, 2022, the format is at(2022-06-06 13:15:30 GMT-7:00).
        - Timing based on clock (based on Cron expression): Based on Cron expression, commands are executed according to the set timing task. The format is        , that is,  . In the specified time zone, calculate the execution time of the scheduled task based on the Cron expression and execute it. If no time zone is specified, the default time zone is the internal time zone of the scheduled task instance. For more information about Cron expressions, see Cron Expressions. Time zones support the following three forms:
        - Full time zone name: such as Asia/Shanghai (China/Shanghai time), America/los_angles (US/Los Angeles time), etc.
        - The offset of the time zone relative to Greenwich Mean Time: E.G. GMT +8:00 (East Zone 8), GMT-7 (West Zone 7), etc. When using the GMT format, the hour bit does not support adding leading zeros.
        - Time zone abbreviation: Only UTC (Coordinated Universal Time) is supported.

        For example, in China/Shanghai time, the command will be executed once every day at 10:15 am in 2022 in the format 0 15 10? * * 2022 Asia/Shanghai; In the eastern 8th District time, it will be executed every half hour from 10:00 a.m. to 11:30 a.m. every day in 2022, in the format of 0 0/30 10-11 * *? 2022 GMT +8:00; In UTC time, starting from 2022, it will be executed every 5 minutes from 14:00 P.M. to 14:55 p. M. Every two years in October, in the format of 0 0/5 14*10? 2022/2 UTC.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter
    def launcher(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bootstrapper for script execution. The length cannot exceed 1KB.
        """
        return pulumi.get(self, "launcher")

    @launcher.setter
    def launcher(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launcher", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The command name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeIdLists")
    def node_id_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of nodes.
        """
        return pulumi.get(self, "node_id_lists")

    @node_id_lists.setter
    def node_id_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_id_lists", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        When the command contains custom parameters, the key-value pair of the custom parameters passed in when the command is executed. For example, if the command content is 'echo {{name}}', the key-value pair'{"name":"Jack"}'can be passed through the 'Parameter' parameter'. The custom parameter will automatically replace the variable value 'name' to get a new command that actually executes 'echo Jack '.

        The number of custom parameters ranges from 0 to 10, and you need to pay attention:
        - The key is not allowed to be an empty string and supports a maximum of 64 characters.
        - The value is allowed to be an empty string.
        - After the custom parameters and the original command content are encoded in Base64, if the command is saved, the size of the command content after Base64 encoding cannot exceed 18KB. If the command is not saved, the size of the command content after Base64 encoding cannot exceed 24KB. You can set whether to keep the command through 'KeepCommand.
        - The set of custom parameter names must be a subset of the parameter set defined when the command is created. For parameters that are not passed in, you can use an empty string instead.

        The default value is empty, which means that the parameter is unset and the custom parameter is disabled.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="repeatMode")
    def repeat_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the way the command is executed. Value range:
        - Once: Execute the command immediately.
        - Period: executes the command regularly. When the value of this parameter is 'Period', the 'Frequency' parameter must also be specified.
        - NextRebootOnly: Automatically execute the command when the instance is next started.
        - EveryReboot: The command is automatically executed every time the instance is started.

        Default:
        - When the'frequency' parameter is not specified, the default value is'once '.
        - When the'frequency' parameter is specified, regardless of whether the parameter value has been set or not, it will be processed according to'period.
        """
        return pulumi.get(self, "repeat_mode")

    @repeat_mode.setter
    def repeat_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repeat_mode", value)

    @_builtins.property
    @pulumi.getter(name="terminationMode")
    def termination_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode when the task is stopped (manually stopped or execution time-out interrupted). Possible values:
        Process: Stops the current script Process.
        ProcessTree: Stops the current process tree (the script process and the collection of all child processes it created)
        """
        return pulumi.get(self, "termination_mode")

    @termination_mode.setter
    def termination_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "termination_mode", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout period for command execution. Unit: seconds. A timeout occurs when a command cannot be run due to a process, a missing module, or a missing cloud assistant Agent. After the timeout, the command process is forcibly terminated. Default value: 60.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the user who executed the command in the instance. The length must not exceed 255 characters.
        The instance of the Linux system. By default, the root user runs commands.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        You can customize the command execution path. The default path is as follows:
        Linux instance: the execution path is in the/home directory of the root user by default.
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "working_dir", value)


@pulumi.type_token("alicloud:eflo/invocation:Invocation")
class Invocation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 command_content: Optional[pulumi.Input[_builtins.str]] = None,
                 command_id: Optional[pulumi.Input[_builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_parameter: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 launcher: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 repeat_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 termination_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 working_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Eflo Invocation can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eflo/invocation:Invocation example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] command_content: The command content. You need to pay attention:
               - Specify the parameter 'EnableParameter = true' to enable the custom parameter feature in the command content.
               - Define custom parameters in the form of {{}} inclusion, and spaces and line breaks before and after the parameter name in '{{}}' are ignored.
               - The number of custom parameters cannot exceed 20.
               - Custom parameter names can a-zA-Z0-9 a combination of-_. Other characters are not supported. Parameter names are not case-sensitive.
               - A single custom parameter name cannot exceed 64 bytes.
        :param pulumi.Input[_builtins.str] command_id: Command ID
        :param pulumi.Input[_builtins.str] content_encoding: The encoding of the script content. Value range:
               - PlainText: no encoding, using PlainText transmission.
               - Base64:Base64 encoding.
               
               Default value: PlainText. If you fill it randomly or wrongly, the value will be treated as a PlainText.
        :param pulumi.Input[_builtins.str] description: The command description.
        :param pulumi.Input[_builtins.bool] enable_parameter: Whether custom parameters are included in the command.
               Default value: false.
        :param pulumi.Input[_builtins.str] frequency: The execution time of the scheduled execution command. Currently, three scheduled execution methods are supported: fixed interval execution (based on Rate expression), only once at a specified time, and timed execution based on clock (based on Cron expression).
               - Fixed time interval execution: Based on the Rate expression, the command is executed at the set time interval. Time intervals can be selected by seconds (s), minutes (m), hours (h), and days (d), which is suitable for scenarios where tasks are executed at fixed time intervals. The format is rate( ). If the execution is performed every 5 minutes, the format is rate(5m). Executing with a fixed time interval has the following limitations:
               - The set time interval is no more than 7 days and no less than 60 seconds, and must be greater than the timeout period of the scheduled task.
               - The execution interval is based only on a fixed frequency, independent of the time the task actually takes to execute. For example, if the command is executed every 5 minutes and the task takes 2 minutes to complete, the next round will be executed 3 minutes after the task is completed.
               - The task is not executed immediately when it is created. For example, if a command is executed every 5 minutes, the command is not executed immediately when a task is created, but is executed 5 minutes after the task is created.
               - Execute only once at the specified time: Execute the command once according to the set time zone and execution time point. The format is at(yyyy-MM-dd HH:mm:ss ), that is, at (year-month-day time: minute: Second ). If you do not specify a time zone, the default is the UTC time zone. Time zones can be in the following three formats: the full name of the time zone, such as Asia/Shanghai (China/Shanghai time), America/los_angles (United States/Los Angeles time), and so on. The offset of the time zone relative to Greenwich Mean Time: E.G. GMT +8:00 (East Zone 8), GMT-7 (West Zone 7), etc. When using the GMT format, the hour bit does not support adding leading zeros. Time zone abbreviation: Only UTC (Coordinated Universal Time) is supported.
               If it is specified to be executed once 13:15:30 June 06, 2022, China/Shanghai time, the format is at (Asia/Shanghai, 2022-06-06 13:15:30); If it is specified to be executed once 13:15:30 June 06, 2022, the format is at(2022-06-06 13:15:30 GMT-7:00).
               - Timing based on clock (based on Cron expression): Based on Cron expression, commands are executed according to the set timing task. The format is        , that is,  . In the specified time zone, calculate the execution time of the scheduled task based on the Cron expression and execute it. If no time zone is specified, the default time zone is the internal time zone of the scheduled task instance. For more information about Cron expressions, see Cron Expressions. Time zones support the following three forms:
               - Full time zone name: such as Asia/Shanghai (China/Shanghai time), America/los_angles (US/Los Angeles time), etc.
               - The offset of the time zone relative to Greenwich Mean Time: E.G. GMT +8:00 (East Zone 8), GMT-7 (West Zone 7), etc. When using the GMT format, the hour bit does not support adding leading zeros.
               - Time zone abbreviation: Only UTC (Coordinated Universal Time) is supported.
               
               For example, in China/Shanghai time, the command will be executed once every day at 10:15 am in 2022 in the format 0 15 10? * * 2022 Asia/Shanghai; In the eastern 8th District time, it will be executed every half hour from 10:00 a.m. to 11:30 a.m. every day in 2022, in the format of 0 0/30 10-11 * *? 2022 GMT +8:00; In UTC time, starting from 2022, it will be executed every 5 minutes from 14:00 P.M. to 14:55 p. M. Every two years in October, in the format of 0 0/5 14*10? 2022/2 UTC.
        :param pulumi.Input[_builtins.str] launcher: The bootstrapper for script execution. The length cannot exceed 1KB.
        :param pulumi.Input[_builtins.str] name: The command name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_id_lists: A list of nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: When the command contains custom parameters, the key-value pair of the custom parameters passed in when the command is executed. For example, if the command content is 'echo {{name}}', the key-value pair'{"name":"Jack"}'can be passed through the 'Parameter' parameter'. The custom parameter will automatically replace the variable value 'name' to get a new command that actually executes 'echo Jack '.
               
               The number of custom parameters ranges from 0 to 10, and you need to pay attention:
               - The key is not allowed to be an empty string and supports a maximum of 64 characters.
               - The value is allowed to be an empty string.
               - After the custom parameters and the original command content are encoded in Base64, if the command is saved, the size of the command content after Base64 encoding cannot exceed 18KB. If the command is not saved, the size of the command content after Base64 encoding cannot exceed 24KB. You can set whether to keep the command through 'KeepCommand.
               - The set of custom parameter names must be a subset of the parameter set defined when the command is created. For parameters that are not passed in, you can use an empty string instead.
               
               The default value is empty, which means that the parameter is unset and the custom parameter is disabled.
        :param pulumi.Input[_builtins.str] repeat_mode: Sets the way the command is executed. Value range:
               - Once: Execute the command immediately.
               - Period: executes the command regularly. When the value of this parameter is 'Period', the 'Frequency' parameter must also be specified.
               - NextRebootOnly: Automatically execute the command when the instance is next started.
               - EveryReboot: The command is automatically executed every time the instance is started.
               
               Default:
               - When the'frequency' parameter is not specified, the default value is'once '.
               - When the'frequency' parameter is specified, regardless of whether the parameter value has been set or not, it will be processed according to'period.
        :param pulumi.Input[_builtins.str] termination_mode: The mode when the task is stopped (manually stopped or execution time-out interrupted). Possible values:
               Process: Stops the current script Process.
               ProcessTree: Stops the current process tree (the script process and the collection of all child processes it created)
        :param pulumi.Input[_builtins.int] timeout: The timeout period for command execution. Unit: seconds. A timeout occurs when a command cannot be run due to a process, a missing module, or a missing cloud assistant Agent. After the timeout, the command process is forcibly terminated. Default value: 60.
        :param pulumi.Input[_builtins.str] username: The name of the user who executed the command in the instance. The length must not exceed 255 characters.
               The instance of the Linux system. By default, the root user runs commands.
        :param pulumi.Input[_builtins.str] working_dir: You can customize the command execution path. The default path is as follows:
               Linux instance: the execution path is in the/home directory of the root user by default.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InvocationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Eflo Invocation can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eflo/invocation:Invocation example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InvocationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InvocationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 command_content: Optional[pulumi.Input[_builtins.str]] = None,
                 command_id: Optional[pulumi.Input[_builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_parameter: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 launcher: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 repeat_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 termination_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 working_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InvocationArgs.__new__(InvocationArgs)

            __props__.__dict__["command_content"] = command_content
            __props__.__dict__["command_id"] = command_id
            __props__.__dict__["content_encoding"] = content_encoding
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_parameter"] = enable_parameter
            __props__.__dict__["frequency"] = frequency
            __props__.__dict__["launcher"] = launcher
            __props__.__dict__["name"] = name
            __props__.__dict__["node_id_lists"] = node_id_lists
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["repeat_mode"] = repeat_mode
            __props__.__dict__["termination_mode"] = termination_mode
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["username"] = username
            __props__.__dict__["working_dir"] = working_dir
        super(Invocation, __self__).__init__(
            'alicloud:eflo/invocation:Invocation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            command_content: Optional[pulumi.Input[_builtins.str]] = None,
            command_id: Optional[pulumi.Input[_builtins.str]] = None,
            content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enable_parameter: Optional[pulumi.Input[_builtins.bool]] = None,
            frequency: Optional[pulumi.Input[_builtins.str]] = None,
            launcher: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            repeat_mode: Optional[pulumi.Input[_builtins.str]] = None,
            termination_mode: Optional[pulumi.Input[_builtins.str]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None,
            working_dir: Optional[pulumi.Input[_builtins.str]] = None) -> 'Invocation':
        """
        Get an existing Invocation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] command_content: The command content. You need to pay attention:
               - Specify the parameter 'EnableParameter = true' to enable the custom parameter feature in the command content.
               - Define custom parameters in the form of {{}} inclusion, and spaces and line breaks before and after the parameter name in '{{}}' are ignored.
               - The number of custom parameters cannot exceed 20.
               - Custom parameter names can a-zA-Z0-9 a combination of-_. Other characters are not supported. Parameter names are not case-sensitive.
               - A single custom parameter name cannot exceed 64 bytes.
        :param pulumi.Input[_builtins.str] command_id: Command ID
        :param pulumi.Input[_builtins.str] content_encoding: The encoding of the script content. Value range:
               - PlainText: no encoding, using PlainText transmission.
               - Base64:Base64 encoding.
               
               Default value: PlainText. If you fill it randomly or wrongly, the value will be treated as a PlainText.
        :param pulumi.Input[_builtins.str] description: The command description.
        :param pulumi.Input[_builtins.bool] enable_parameter: Whether custom parameters are included in the command.
               Default value: false.
        :param pulumi.Input[_builtins.str] frequency: The execution time of the scheduled execution command. Currently, three scheduled execution methods are supported: fixed interval execution (based on Rate expression), only once at a specified time, and timed execution based on clock (based on Cron expression).
               - Fixed time interval execution: Based on the Rate expression, the command is executed at the set time interval. Time intervals can be selected by seconds (s), minutes (m), hours (h), and days (d), which is suitable for scenarios where tasks are executed at fixed time intervals. The format is rate( ). If the execution is performed every 5 minutes, the format is rate(5m). Executing with a fixed time interval has the following limitations:
               - The set time interval is no more than 7 days and no less than 60 seconds, and must be greater than the timeout period of the scheduled task.
               - The execution interval is based only on a fixed frequency, independent of the time the task actually takes to execute. For example, if the command is executed every 5 minutes and the task takes 2 minutes to complete, the next round will be executed 3 minutes after the task is completed.
               - The task is not executed immediately when it is created. For example, if a command is executed every 5 minutes, the command is not executed immediately when a task is created, but is executed 5 minutes after the task is created.
               - Execute only once at the specified time: Execute the command once according to the set time zone and execution time point. The format is at(yyyy-MM-dd HH:mm:ss ), that is, at (year-month-day time: minute: Second ). If you do not specify a time zone, the default is the UTC time zone. Time zones can be in the following three formats: the full name of the time zone, such as Asia/Shanghai (China/Shanghai time), America/los_angles (United States/Los Angeles time), and so on. The offset of the time zone relative to Greenwich Mean Time: E.G. GMT +8:00 (East Zone 8), GMT-7 (West Zone 7), etc. When using the GMT format, the hour bit does not support adding leading zeros. Time zone abbreviation: Only UTC (Coordinated Universal Time) is supported.
               If it is specified to be executed once 13:15:30 June 06, 2022, China/Shanghai time, the format is at (Asia/Shanghai, 2022-06-06 13:15:30); If it is specified to be executed once 13:15:30 June 06, 2022, the format is at(2022-06-06 13:15:30 GMT-7:00).
               - Timing based on clock (based on Cron expression): Based on Cron expression, commands are executed according to the set timing task. The format is        , that is,  . In the specified time zone, calculate the execution time of the scheduled task based on the Cron expression and execute it. If no time zone is specified, the default time zone is the internal time zone of the scheduled task instance. For more information about Cron expressions, see Cron Expressions. Time zones support the following three forms:
               - Full time zone name: such as Asia/Shanghai (China/Shanghai time), America/los_angles (US/Los Angeles time), etc.
               - The offset of the time zone relative to Greenwich Mean Time: E.G. GMT +8:00 (East Zone 8), GMT-7 (West Zone 7), etc. When using the GMT format, the hour bit does not support adding leading zeros.
               - Time zone abbreviation: Only UTC (Coordinated Universal Time) is supported.
               
               For example, in China/Shanghai time, the command will be executed once every day at 10:15 am in 2022 in the format 0 15 10? * * 2022 Asia/Shanghai; In the eastern 8th District time, it will be executed every half hour from 10:00 a.m. to 11:30 a.m. every day in 2022, in the format of 0 0/30 10-11 * *? 2022 GMT +8:00; In UTC time, starting from 2022, it will be executed every 5 minutes from 14:00 P.M. to 14:55 p. M. Every two years in October, in the format of 0 0/5 14*10? 2022/2 UTC.
        :param pulumi.Input[_builtins.str] launcher: The bootstrapper for script execution. The length cannot exceed 1KB.
        :param pulumi.Input[_builtins.str] name: The command name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_id_lists: A list of nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: When the command contains custom parameters, the key-value pair of the custom parameters passed in when the command is executed. For example, if the command content is 'echo {{name}}', the key-value pair'{"name":"Jack"}'can be passed through the 'Parameter' parameter'. The custom parameter will automatically replace the variable value 'name' to get a new command that actually executes 'echo Jack '.
               
               The number of custom parameters ranges from 0 to 10, and you need to pay attention:
               - The key is not allowed to be an empty string and supports a maximum of 64 characters.
               - The value is allowed to be an empty string.
               - After the custom parameters and the original command content are encoded in Base64, if the command is saved, the size of the command content after Base64 encoding cannot exceed 18KB. If the command is not saved, the size of the command content after Base64 encoding cannot exceed 24KB. You can set whether to keep the command through 'KeepCommand.
               - The set of custom parameter names must be a subset of the parameter set defined when the command is created. For parameters that are not passed in, you can use an empty string instead.
               
               The default value is empty, which means that the parameter is unset and the custom parameter is disabled.
        :param pulumi.Input[_builtins.str] repeat_mode: Sets the way the command is executed. Value range:
               - Once: Execute the command immediately.
               - Period: executes the command regularly. When the value of this parameter is 'Period', the 'Frequency' parameter must also be specified.
               - NextRebootOnly: Automatically execute the command when the instance is next started.
               - EveryReboot: The command is automatically executed every time the instance is started.
               
               Default:
               - When the'frequency' parameter is not specified, the default value is'once '.
               - When the'frequency' parameter is specified, regardless of whether the parameter value has been set or not, it will be processed according to'period.
        :param pulumi.Input[_builtins.str] termination_mode: The mode when the task is stopped (manually stopped or execution time-out interrupted). Possible values:
               Process: Stops the current script Process.
               ProcessTree: Stops the current process tree (the script process and the collection of all child processes it created)
        :param pulumi.Input[_builtins.int] timeout: The timeout period for command execution. Unit: seconds. A timeout occurs when a command cannot be run due to a process, a missing module, or a missing cloud assistant Agent. After the timeout, the command process is forcibly terminated. Default value: 60.
        :param pulumi.Input[_builtins.str] username: The name of the user who executed the command in the instance. The length must not exceed 255 characters.
               The instance of the Linux system. By default, the root user runs commands.
        :param pulumi.Input[_builtins.str] working_dir: You can customize the command execution path. The default path is as follows:
               Linux instance: the execution path is in the/home directory of the root user by default.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InvocationState.__new__(_InvocationState)

        __props__.__dict__["command_content"] = command_content
        __props__.__dict__["command_id"] = command_id
        __props__.__dict__["content_encoding"] = content_encoding
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_parameter"] = enable_parameter
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["launcher"] = launcher
        __props__.__dict__["name"] = name
        __props__.__dict__["node_id_lists"] = node_id_lists
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["repeat_mode"] = repeat_mode
        __props__.__dict__["termination_mode"] = termination_mode
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["username"] = username
        __props__.__dict__["working_dir"] = working_dir
        return Invocation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="commandContent")
    def command_content(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The command content. You need to pay attention:
        - Specify the parameter 'EnableParameter = true' to enable the custom parameter feature in the command content.
        - Define custom parameters in the form of {{}} inclusion, and spaces and line breaks before and after the parameter name in '{{}}' are ignored.
        - The number of custom parameters cannot exceed 20.
        - Custom parameter names can a-zA-Z0-9 a combination of-_. Other characters are not supported. Parameter names are not case-sensitive.
        - A single custom parameter name cannot exceed 64 bytes.
        """
        return pulumi.get(self, "command_content")

    @_builtins.property
    @pulumi.getter(name="commandId")
    def command_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Command ID
        """
        return pulumi.get(self, "command_id")

    @_builtins.property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The encoding of the script content. Value range:
        - PlainText: no encoding, using PlainText transmission.
        - Base64:Base64 encoding.

        Default value: PlainText. If you fill it randomly or wrongly, the value will be treated as a PlainText.
        """
        return pulumi.get(self, "content_encoding")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The command description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableParameter")
    def enable_parameter(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether custom parameters are included in the command.
        Default value: false.
        """
        return pulumi.get(self, "enable_parameter")

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The execution time of the scheduled execution command. Currently, three scheduled execution methods are supported: fixed interval execution (based on Rate expression), only once at a specified time, and timed execution based on clock (based on Cron expression).
        - Fixed time interval execution: Based on the Rate expression, the command is executed at the set time interval. Time intervals can be selected by seconds (s), minutes (m), hours (h), and days (d), which is suitable for scenarios where tasks are executed at fixed time intervals. The format is rate( ). If the execution is performed every 5 minutes, the format is rate(5m). Executing with a fixed time interval has the following limitations:
        - The set time interval is no more than 7 days and no less than 60 seconds, and must be greater than the timeout period of the scheduled task.
        - The execution interval is based only on a fixed frequency, independent of the time the task actually takes to execute. For example, if the command is executed every 5 minutes and the task takes 2 minutes to complete, the next round will be executed 3 minutes after the task is completed.
        - The task is not executed immediately when it is created. For example, if a command is executed every 5 minutes, the command is not executed immediately when a task is created, but is executed 5 minutes after the task is created.
        - Execute only once at the specified time: Execute the command once according to the set time zone and execution time point. The format is at(yyyy-MM-dd HH:mm:ss ), that is, at (year-month-day time: minute: Second ). If you do not specify a time zone, the default is the UTC time zone. Time zones can be in the following three formats: the full name of the time zone, such as Asia/Shanghai (China/Shanghai time), America/los_angles (United States/Los Angeles time), and so on. The offset of the time zone relative to Greenwich Mean Time: E.G. GMT +8:00 (East Zone 8), GMT-7 (West Zone 7), etc. When using the GMT format, the hour bit does not support adding leading zeros. Time zone abbreviation: Only UTC (Coordinated Universal Time) is supported.
        If it is specified to be executed once 13:15:30 June 06, 2022, China/Shanghai time, the format is at (Asia/Shanghai, 2022-06-06 13:15:30); If it is specified to be executed once 13:15:30 June 06, 2022, the format is at(2022-06-06 13:15:30 GMT-7:00).
        - Timing based on clock (based on Cron expression): Based on Cron expression, commands are executed according to the set timing task. The format is        , that is,  . In the specified time zone, calculate the execution time of the scheduled task based on the Cron expression and execute it. If no time zone is specified, the default time zone is the internal time zone of the scheduled task instance. For more information about Cron expressions, see Cron Expressions. Time zones support the following three forms:
        - Full time zone name: such as Asia/Shanghai (China/Shanghai time), America/los_angles (US/Los Angeles time), etc.
        - The offset of the time zone relative to Greenwich Mean Time: E.G. GMT +8:00 (East Zone 8), GMT-7 (West Zone 7), etc. When using the GMT format, the hour bit does not support adding leading zeros.
        - Time zone abbreviation: Only UTC (Coordinated Universal Time) is supported.

        For example, in China/Shanghai time, the command will be executed once every day at 10:15 am in 2022 in the format 0 15 10? * * 2022 Asia/Shanghai; In the eastern 8th District time, it will be executed every half hour from 10:00 a.m. to 11:30 a.m. every day in 2022, in the format of 0 0/30 10-11 * *? 2022 GMT +8:00; In UTC time, starting from 2022, it will be executed every 5 minutes from 14:00 P.M. to 14:55 p. M. Every two years in October, in the format of 0 0/5 14*10? 2022/2 UTC.
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter
    def launcher(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The bootstrapper for script execution. The length cannot exceed 1KB.
        """
        return pulumi.get(self, "launcher")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The command name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeIdLists")
    def node_id_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of nodes.
        """
        return pulumi.get(self, "node_id_lists")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        When the command contains custom parameters, the key-value pair of the custom parameters passed in when the command is executed. For example, if the command content is 'echo {{name}}', the key-value pair'{"name":"Jack"}'can be passed through the 'Parameter' parameter'. The custom parameter will automatically replace the variable value 'name' to get a new command that actually executes 'echo Jack '.

        The number of custom parameters ranges from 0 to 10, and you need to pay attention:
        - The key is not allowed to be an empty string and supports a maximum of 64 characters.
        - The value is allowed to be an empty string.
        - After the custom parameters and the original command content are encoded in Base64, if the command is saved, the size of the command content after Base64 encoding cannot exceed 18KB. If the command is not saved, the size of the command content after Base64 encoding cannot exceed 24KB. You can set whether to keep the command through 'KeepCommand.
        - The set of custom parameter names must be a subset of the parameter set defined when the command is created. For parameters that are not passed in, you can use an empty string instead.

        The default value is empty, which means that the parameter is unset and the custom parameter is disabled.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="repeatMode")
    def repeat_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Sets the way the command is executed. Value range:
        - Once: Execute the command immediately.
        - Period: executes the command regularly. When the value of this parameter is 'Period', the 'Frequency' parameter must also be specified.
        - NextRebootOnly: Automatically execute the command when the instance is next started.
        - EveryReboot: The command is automatically executed every time the instance is started.

        Default:
        - When the'frequency' parameter is not specified, the default value is'once '.
        - When the'frequency' parameter is specified, regardless of whether the parameter value has been set or not, it will be processed according to'period.
        """
        return pulumi.get(self, "repeat_mode")

    @_builtins.property
    @pulumi.getter(name="terminationMode")
    def termination_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The mode when the task is stopped (manually stopped or execution time-out interrupted). Possible values:
        Process: Stops the current script Process.
        ProcessTree: Stops the current process tree (the script process and the collection of all child processes it created)
        """
        return pulumi.get(self, "termination_mode")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The timeout period for command execution. Unit: seconds. A timeout occurs when a command cannot be run due to a process, a missing module, or a missing cloud assistant Agent. After the timeout, the command process is forcibly terminated. Default value: 60.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the user who executed the command in the instance. The length must not exceed 255 characters.
        The instance of the Linux system. By default, the root user runs commands.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        You can customize the command execution path. The default path is as follows:
        Linux instance: the execution path is in the/home directory of the root user by default.
        """
        return pulumi.get(self, "working_dir")

