# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SubnetArgs', 'Subnet']

@pulumi.input_type
class SubnetArgs:
    def __init__(__self__, *,
                 cidr: pulumi.Input[_builtins.str],
                 subnet_name: pulumi.Input[_builtins.str],
                 vpd_id: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Subnet resource.
        :param pulumi.Input[_builtins.str] cidr: CIDR network segment.
        :param pulumi.Input[_builtins.str] subnet_name: The Subnet name.
        :param pulumi.Input[_builtins.str] vpd_id: The Eflo VPD ID.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID  of the resource.
        :param pulumi.Input[_builtins.str] type: Eflo subnet usage type. optional value:
               - General type is not filled in
               - OOB:OOB type
               - LB: LB type
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "subnet_name", subnet_name)
        pulumi.set(__self__, "vpd_id", vpd_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> pulumi.Input[_builtins.str]:
        """
        CIDR network segment.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Subnet name.
        """
        return pulumi.get(self, "subnet_name")

    @subnet_name.setter
    def subnet_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_name", value)

    @_builtins.property
    @pulumi.getter(name="vpdId")
    def vpd_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Eflo VPD ID.
        """
        return pulumi.get(self, "vpd_id")

    @vpd_id.setter
    def vpd_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpd_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The zone ID  of the resource.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Eflo subnet usage type. optional value:
        - General type is not filled in
        - OOB:OOB type
        - LB: LB type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _SubnetState:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 gmt_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpd_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Subnet resources.
        :param pulumi.Input[_builtins.str] cidr: CIDR network segment.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] gmt_modified: Modification time.
        :param pulumi.Input[_builtins.str] message: Error message.
        :param pulumi.Input[_builtins.str] resource_group_id: Resource Group ID.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.str] subnet_id: The id of the subnet.
        :param pulumi.Input[_builtins.str] subnet_name: The Subnet name.
        :param pulumi.Input[_builtins.str] type: Eflo subnet usage type. optional value:
               - General type is not filled in
               - OOB:OOB type
               - LB: LB type
        :param pulumi.Input[_builtins.str] vpd_id: The Eflo VPD ID.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID  of the resource.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if gmt_modified is not None:
            pulumi.set(__self__, "gmt_modified", gmt_modified)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if subnet_name is not None:
            pulumi.set(__self__, "subnet_name", subnet_name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vpd_id is not None:
            pulumi.set(__self__, "vpd_id", vpd_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CIDR network segment.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="gmtModified")
    def gmt_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Modification time.
        """
        return pulumi.get(self, "gmt_modified")

    @gmt_modified.setter
    def gmt_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gmt_modified", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Error message.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Subnet name.
        """
        return pulumi.get(self, "subnet_name")

    @subnet_name.setter
    def subnet_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Eflo subnet usage type. optional value:
        - General type is not filled in
        - OOB:OOB type
        - LB: LB type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="vpdId")
    def vpd_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Eflo VPD ID.
        """
        return pulumi.get(self, "vpd_id")

    @vpd_id.setter
    def vpd_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpd_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID  of the resource.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:eflo/subnet:Subnet")
class Subnet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpd_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Eflo Subnet resource.

        For information about Eflo Subnet and how to use it, see [What is Subnet](https://www.alibabacloud.com/help/en/pai/user-guide/overview-of-intelligent-computing-lingjun).

        > **NOTE:** Available since v1.204.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_zones()
        default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
        default_vpd = alicloud.eflo.Vpd("default",
            cidr="10.0.0.0/8",
            vpd_name=name,
            resource_group_id=default_get_resource_groups.groups[0].id)
        default_subnet = alicloud.eflo.Subnet("default",
            subnet_name=name,
            zone_id=default.zones[0].id,
            cidr="10.0.0.0/16",
            vpd_id=default_vpd.id)
        ```

        ## Import

        Eflo Subnet can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eflo/subnet:Subnet example <vpd_id>:<subnet_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cidr: CIDR network segment.
        :param pulumi.Input[_builtins.str] subnet_name: The Subnet name.
        :param pulumi.Input[_builtins.str] type: Eflo subnet usage type. optional value:
               - General type is not filled in
               - OOB:OOB type
               - LB: LB type
        :param pulumi.Input[_builtins.str] vpd_id: The Eflo VPD ID.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID  of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubnetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Eflo Subnet resource.

        For information about Eflo Subnet and how to use it, see [What is Subnet](https://www.alibabacloud.com/help/en/pai/user-guide/overview-of-intelligent-computing-lingjun).

        > **NOTE:** Available since v1.204.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_zones()
        default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
        default_vpd = alicloud.eflo.Vpd("default",
            cidr="10.0.0.0/8",
            vpd_name=name,
            resource_group_id=default_get_resource_groups.groups[0].id)
        default_subnet = alicloud.eflo.Subnet("default",
            subnet_name=name,
            zone_id=default.zones[0].id,
            cidr="10.0.0.0/16",
            vpd_id=default_vpd.id)
        ```

        ## Import

        Eflo Subnet can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eflo/subnet:Subnet example <vpd_id>:<subnet_id>
        ```

        :param str resource_name: The name of the resource.
        :param SubnetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubnetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpd_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubnetArgs.__new__(SubnetArgs)

            if cidr is None and not opts.urn:
                raise TypeError("Missing required property 'cidr'")
            __props__.__dict__["cidr"] = cidr
            if subnet_name is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_name'")
            __props__.__dict__["subnet_name"] = subnet_name
            __props__.__dict__["type"] = type
            if vpd_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpd_id'")
            __props__.__dict__["vpd_id"] = vpd_id
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["gmt_modified"] = None
            __props__.__dict__["message"] = None
            __props__.__dict__["resource_group_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["subnet_id"] = None
        super(Subnet, __self__).__init__(
            'alicloud:eflo/subnet:Subnet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidr: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            gmt_modified: Optional[pulumi.Input[_builtins.str]] = None,
            message: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_name: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            vpd_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Subnet':
        """
        Get an existing Subnet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cidr: CIDR network segment.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] gmt_modified: Modification time.
        :param pulumi.Input[_builtins.str] message: Error message.
        :param pulumi.Input[_builtins.str] resource_group_id: Resource Group ID.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.str] subnet_id: The id of the subnet.
        :param pulumi.Input[_builtins.str] subnet_name: The Subnet name.
        :param pulumi.Input[_builtins.str] type: Eflo subnet usage type. optional value:
               - General type is not filled in
               - OOB:OOB type
               - LB: LB type
        :param pulumi.Input[_builtins.str] vpd_id: The Eflo VPD ID.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID  of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubnetState.__new__(_SubnetState)

        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["gmt_modified"] = gmt_modified
        __props__.__dict__["message"] = message
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["subnet_name"] = subnet_name
        __props__.__dict__["type"] = type
        __props__.__dict__["vpd_id"] = vpd_id
        __props__.__dict__["zone_id"] = zone_id
        return Subnet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[_builtins.str]:
        """
        CIDR network segment.
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="gmtModified")
    def gmt_modified(self) -> pulumi.Output[_builtins.str]:
        """
        Modification time.
        """
        return pulumi.get(self, "gmt_modified")

    @_builtins.property
    @pulumi.getter
    def message(self) -> pulumi.Output[_builtins.str]:
        """
        Error message.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Resource Group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the subnet.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Subnet name.
        """
        return pulumi.get(self, "subnet_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Eflo subnet usage type. optional value:
        - General type is not filled in
        - OOB:OOB type
        - LB: LB type
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vpdId")
    def vpd_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Eflo VPD ID.
        """
        return pulumi.get(self, "vpd_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The zone ID  of the resource.
        """
        return pulumi.get(self, "zone_id")

