# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[_builtins.str],
                 compute_count: pulumi.Input[_builtins.int],
                 compute_instance_type: pulumi.Input[_builtins.str],
                 login_count: pulumi.Input[_builtins.int],
                 login_instance_type: pulumi.Input[_builtins.str],
                 manager_instance_type: pulumi.Input[_builtins.str],
                 os_tag: pulumi.Input[_builtins.str],
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 additional_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAdditionalVolumeArgs']]]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterApplicationArgs']]]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 client_version: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_enable_ht: Optional[pulumi.Input[_builtins.bool]] = None,
                 compute_spot_price_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 deploy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 ecs_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ehpc_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_owner_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 input_file_url: Optional[pulumi.Input[_builtins.str]] = None,
                 is_compute_ess: Optional[pulumi.Input[_builtins.bool]] = None,
                 job_queue: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_count: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin: Optional[pulumi.Input[_builtins.str]] = None,
                 post_install_scripts: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPostInstallScriptArgs']]]] = None,
                 ram_node_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 release_instance: Optional[pulumi.Input[_builtins.bool]] = None,
                 remote_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_vis_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scc_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_level: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_mount_option: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_mountpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 without_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 without_elastic_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the cluster. The name must be `2` to `64` characters in length.
        :param pulumi.Input[_builtins.int] compute_count: The number of the compute nodes. Valid values: `1` to `99`.
        :param pulumi.Input[_builtins.str] compute_instance_type: The instance type of the compute nodes.
        :param pulumi.Input[_builtins.int] login_count: The number of the logon nodes. Valid values: `1`.
        :param pulumi.Input[_builtins.str] login_instance_type: The instance type of the logon nodes.
        :param pulumi.Input[_builtins.str] manager_instance_type: The instance type of the management nodes.
        :param pulumi.Input[_builtins.str] os_tag: The image tag of the operating system.
        :param pulumi.Input[_builtins.str] account_type: The type of the domain account service. Valid values: `nis`, `ldap`. Default value: `nis`
        :param pulumi.Input[Sequence[pulumi.Input['ClusterAdditionalVolumeArgs']]] additional_volumes: The additional volumes. See `additional_volumes` below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterApplicationArgs']]] applications: The application. See `application` below.
        :param pulumi.Input[_builtins.bool] auto_renew: Specifies whether to enable auto-renewal for the subscription. Default value: `false`.
        :param pulumi.Input[_builtins.int] auto_renew_period: The auto-renewal period of the subscription compute nodes. The parameter takes effect when AutoRenew is set to true.
        :param pulumi.Input[_builtins.str] client_version: The version of the E-HPC client. By default, the parameter is set to the latest version number.
        :param pulumi.Input[_builtins.str] cluster_version: The version of the cluster. Default value: `1.0`.
        :param pulumi.Input[_builtins.bool] compute_enable_ht: Specifies whether the compute nodes support hyper-threading. Default value: `true`.
        :param pulumi.Input[_builtins.str] compute_spot_price_limit: The maximum hourly price of the compute nodes. A maximum of three decimal places can be used in the value of the parameter. The parameter is valid only when the ComputeSpotStrategy parameter is set to SpotWithPriceLimit.
        :param pulumi.Input[_builtins.str] compute_spot_strategy: The bidding method of the compute nodes. Default value: `NoSpot`. Valid values:
               - `NoSpot`: The compute nodes are pay-as-you-go instances.
               - `SpotWithPriceLimit`: The compute nodes are preemptible instances that have a user-defined maximum hourly price.
               - `SpotAsPriceGo`: The compute nodes are preemptible instances for which the market price at the time of purchase is used as the bid price.
        :param pulumi.Input[_builtins.str] deploy_mode: The mode in which the cluster is deployed. Valid values: `Standard`, `Simple`, `Tiny`. Default value: Standard.
               - `Standard`: An account node, a scheduling node, a logon node, and multiple compute nodes are separately deployed.
               - `Simple`: A management node, a logon node, and multiple compute nodes are deployed. The management node consists of an account node and a scheduling node. The logon node and compute nodes are separately deployed.
               - `Tiny`: A management node and multiple compute nodes are deployed. The management node consists of an account node, a scheduling node, and a logon node. The compute nodes are separately deployed.
        :param pulumi.Input[_builtins.str] description: The description of the cluster. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] domain: The domain name of the on-premises cluster. This parameter takes effect only when the AccoutType parameter is set to Idap.
        :param pulumi.Input[_builtins.str] ecs_charge_type: The billing method of the nodes.
        :param pulumi.Input[_builtins.str] ehpc_version: The version of E-HPC. By default, the parameter is set to the latest version number.
        :param pulumi.Input[_builtins.bool] ha_enable: Specifies whether to enable the high availability feature. Default value: `false`.  **Note:** If high availability is enabled, a primary management node and a secondary management node are used.
        :param pulumi.Input[_builtins.str] image_id: The ID of the image.
        :param pulumi.Input[_builtins.str] image_owner_alias: The type of the image. Valid values: `others`, `self`, `system`, `marketplace`. Default value: `system`.
        :param pulumi.Input[_builtins.str] input_file_url: The URL of the job files that are uploaded to an Object Storage Service (OSS) bucket.
        :param pulumi.Input[_builtins.bool] is_compute_ess: Specifies whether to enable auto scaling. Default value: `false`.
        :param pulumi.Input[_builtins.str] job_queue: The queue to which the compute nodes are added.
        :param pulumi.Input[_builtins.str] key_pair_name: The name of the AccessKey pair.
        :param pulumi.Input[_builtins.int] manager_count: The number of the management nodes. Valid values: 1 and 2.
        :param pulumi.Input[_builtins.str] password: The root password of the logon node. The password must be 8 to 30 characters in length and contain at least three of the following items: uppercase letters, lowercase letters, digits, and special characters. The password can contain the following special characters: `( ) ~ ! @ # $ % ^ & * - + = { } [ ] : ; ‘ < > , . ? /`. You must specify either `password` or `key_pair_name`. If both are specified, the Password parameter prevails.
        :param pulumi.Input[_builtins.int] period: The duration of the subscription. The unit of the duration is specified by the `period_unit` parameter. Default value: `1`.
               * If you set PriceUnit to Year, the valid values of the Period parameter are 1, 2, and 3.
               * If you set PriceUnit to Month, the valid values of the Period parameter are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
               * If you set PriceUnit to Hour, the valid value of the Period parameter is 1.
        :param pulumi.Input[_builtins.str] period_unit: The unit of the subscription duration. Valid values: `Year`, `Month`, `Hour`. Default value: `Month`.
        :param pulumi.Input[_builtins.str] plugin: The mode configurations of the plug-in. This parameter takes effect only when the SchedulerType parameter is set to custom. The value must be a JSON string. The parameter contains the following parameters: pluginMod, pluginLocalPath, and pluginOssPath.
               - pluginMod: the mode of the plug-in. The following modes are supported:
               - oss: The plug-in is downloaded and decompressed from OSS to a local path. The local path is specified by the pluginLocalPath parameter.
               - image: By default, the plug-in is stored in a pre-defined local path. The local path is specified by the pluginLocalPath parameter.
               - pluginLocalPath: the local path where the plug-in is stored. We recommend that you select a shared directory in oss mode and a non-shared directory in image mode.
               - pluginOssPath: the remote path where the plug-in is stored in OSS. This parameter takes effect only when the pluginMod parameter is set to oss.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterPostInstallScriptArgs']]] post_install_scripts: The post install script. See `post_install_script` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ram_node_types: The node of the RAM role.
        :param pulumi.Input[_builtins.str] ram_role_name: The name of the Resource Access Management (RAM) role.
        :param pulumi.Input[_builtins.bool] release_instance: The release instance. Valid values: `true`.
        :param pulumi.Input[_builtins.str] remote_directory: The remote directory to which the file system is mounted.
        :param pulumi.Input[_builtins.bool] remote_vis_enable: Specifies whether to enable Virtual Network Computing (VNC). Default value: `false`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] scc_cluster_id: The ID of the Super Computing Cluster (SCC) instance. If you specify the parameter, the SCC instance is moved to a new SCC cluster.
        :param pulumi.Input[_builtins.str] scheduler_type: The type of the scheduler. Valid values: `pbs`, `slurm`, `opengridscheduler` and `deadline`. Default value: `pbs`.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the cluster belongs.
        :param pulumi.Input[_builtins.str] security_group_name: If you do not use an existing security group, set the parameter to the name of a new security group. A default policy is applied to the new security group.
        :param pulumi.Input[_builtins.str] system_disk_level: The performance level of the ESSD that is used as the system disk. Default value: `PL1` For more information, see [ESSDs](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/essds). Valid values:
               * `PL0`: A single ESSD can deliver up to 10,000 random read/write IOPS.
               * `PL1`: A single ESSD can deliver up to 50,000 random read/write IOPS.
               * `PL2`: A single ESSD can deliver up to 100,000 random read/write IOPS.
               * `PL3`: A single ESSD can deliver up to 1,000,000 random read/write IOPS.
        :param pulumi.Input[_builtins.int] system_disk_size: The size of the system disk. Unit: `GB`. Valid values: `40` to `500`. Default value: `40`.
        :param pulumi.Input[_builtins.str] system_disk_type: The type of the system disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd` or `cloud`. Default value: `cloud_ssd`.
        :param pulumi.Input[_builtins.str] volume_id: The ID of the file system. If you leave the parameter empty, a Performance NAS file system is created by default.
        :param pulumi.Input[_builtins.str] volume_mount_option: The mount options of the file system.
        :param pulumi.Input[_builtins.str] volume_mountpoint: The mount target of the file system. Take note of the following information:
               - If you do not specify the VolumeId parameter, you can leave the VolumeMountpoint parameter empty. A mount target is created by default.
               - If you specify the VolumeId parameter, the VolumeMountpoint parameter is required.
        :param pulumi.Input[_builtins.str] volume_protocol: The type of the protocol that is used by the file system. Valid values: `NFS`, `SMB`. Default value: `NFS`.
        :param pulumi.Input[_builtins.str] volume_type: The type of the shared storage. Only Apsara File Storage NAS file systems are supported.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC) to which the cluster belongs.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch. E-HPC supports only VPC networks.
        :param pulumi.Input[_builtins.bool] without_agent: Specifies whether not to install the agent. Default value: `false`.
        :param pulumi.Input[_builtins.bool] without_elastic_ip: Specifies whether the logon node uses an elastic IP address (EIP). Default value: `false`.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "compute_count", compute_count)
        pulumi.set(__self__, "compute_instance_type", compute_instance_type)
        pulumi.set(__self__, "login_count", login_count)
        pulumi.set(__self__, "login_instance_type", login_instance_type)
        pulumi.set(__self__, "manager_instance_type", manager_instance_type)
        pulumi.set(__self__, "os_tag", os_tag)
        if account_type is not None:
            pulumi.set(__self__, "account_type", account_type)
        if additional_volumes is not None:
            pulumi.set(__self__, "additional_volumes", additional_volumes)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if client_version is not None:
            pulumi.set(__self__, "client_version", client_version)
        if cluster_version is not None:
            pulumi.set(__self__, "cluster_version", cluster_version)
        if compute_enable_ht is not None:
            pulumi.set(__self__, "compute_enable_ht", compute_enable_ht)
        if compute_spot_price_limit is not None:
            pulumi.set(__self__, "compute_spot_price_limit", compute_spot_price_limit)
        if compute_spot_strategy is not None:
            pulumi.set(__self__, "compute_spot_strategy", compute_spot_strategy)
        if deploy_mode is not None:
            pulumi.set(__self__, "deploy_mode", deploy_mode)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if ecs_charge_type is not None:
            pulumi.set(__self__, "ecs_charge_type", ecs_charge_type)
        if ehpc_version is not None:
            pulumi.set(__self__, "ehpc_version", ehpc_version)
        if ha_enable is not None:
            pulumi.set(__self__, "ha_enable", ha_enable)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_owner_alias is not None:
            pulumi.set(__self__, "image_owner_alias", image_owner_alias)
        if input_file_url is not None:
            pulumi.set(__self__, "input_file_url", input_file_url)
        if is_compute_ess is not None:
            pulumi.set(__self__, "is_compute_ess", is_compute_ess)
        if job_queue is not None:
            pulumi.set(__self__, "job_queue", job_queue)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if manager_count is not None:
            pulumi.set(__self__, "manager_count", manager_count)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if plugin is not None:
            pulumi.set(__self__, "plugin", plugin)
        if post_install_scripts is not None:
            pulumi.set(__self__, "post_install_scripts", post_install_scripts)
        if ram_node_types is not None:
            pulumi.set(__self__, "ram_node_types", ram_node_types)
        if ram_role_name is not None:
            pulumi.set(__self__, "ram_role_name", ram_role_name)
        if release_instance is not None:
            pulumi.set(__self__, "release_instance", release_instance)
        if remote_directory is not None:
            pulumi.set(__self__, "remote_directory", remote_directory)
        if remote_vis_enable is not None:
            pulumi.set(__self__, "remote_vis_enable", remote_vis_enable)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scc_cluster_id is not None:
            pulumi.set(__self__, "scc_cluster_id", scc_cluster_id)
        if scheduler_type is not None:
            pulumi.set(__self__, "scheduler_type", scheduler_type)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_name is not None:
            pulumi.set(__self__, "security_group_name", security_group_name)
        if system_disk_level is not None:
            pulumi.set(__self__, "system_disk_level", system_disk_level)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if system_disk_type is not None:
            pulumi.set(__self__, "system_disk_type", system_disk_type)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if volume_mount_option is not None:
            pulumi.set(__self__, "volume_mount_option", volume_mount_option)
        if volume_mountpoint is not None:
            pulumi.set(__self__, "volume_mountpoint", volume_mountpoint)
        if volume_protocol is not None:
            pulumi.set(__self__, "volume_protocol", volume_protocol)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if without_agent is not None:
            pulumi.set(__self__, "without_agent", without_agent)
        if without_elastic_ip is not None:
            pulumi.set(__self__, "without_elastic_ip", without_elastic_ip)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the cluster. The name must be `2` to `64` characters in length.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> pulumi.Input[_builtins.int]:
        """
        The number of the compute nodes. Valid values: `1` to `99`.
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "compute_count", value)

    @_builtins.property
    @pulumi.getter(name="computeInstanceType")
    def compute_instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        The instance type of the compute nodes.
        """
        return pulumi.get(self, "compute_instance_type")

    @compute_instance_type.setter
    def compute_instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compute_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="loginCount")
    def login_count(self) -> pulumi.Input[_builtins.int]:
        """
        The number of the logon nodes. Valid values: `1`.
        """
        return pulumi.get(self, "login_count")

    @login_count.setter
    def login_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "login_count", value)

    @_builtins.property
    @pulumi.getter(name="loginInstanceType")
    def login_instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        The instance type of the logon nodes.
        """
        return pulumi.get(self, "login_instance_type")

    @login_instance_type.setter
    def login_instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "login_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="managerInstanceType")
    def manager_instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        The instance type of the management nodes.
        """
        return pulumi.get(self, "manager_instance_type")

    @manager_instance_type.setter
    def manager_instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "manager_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="osTag")
    def os_tag(self) -> pulumi.Input[_builtins.str]:
        """
        The image tag of the operating system.
        """
        return pulumi.get(self, "os_tag")

    @os_tag.setter
    def os_tag(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "os_tag", value)

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the domain account service. Valid values: `nis`, `ldap`. Default value: `nis`
        """
        return pulumi.get(self, "account_type")

    @account_type.setter
    def account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_type", value)

    @_builtins.property
    @pulumi.getter(name="additionalVolumes")
    def additional_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAdditionalVolumeArgs']]]]:
        """
        The additional volumes. See `additional_volumes` below.
        """
        return pulumi.get(self, "additional_volumes")

    @additional_volumes.setter
    def additional_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAdditionalVolumeArgs']]]]):
        pulumi.set(self, "additional_volumes", value)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterApplicationArgs']]]]:
        """
        The application. See `application` below.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterApplicationArgs']]]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable auto-renewal for the subscription. Default value: `false`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The auto-renewal period of the subscription compute nodes. The parameter takes effect when AutoRenew is set to true.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the E-HPC client. By default, the parameter is set to the latest version number.
        """
        return pulumi.get(self, "client_version")

    @client_version.setter
    def client_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_version", value)

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the cluster. Default value: `1.0`.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_version", value)

    @_builtins.property
    @pulumi.getter(name="computeEnableHt")
    def compute_enable_ht(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the compute nodes support hyper-threading. Default value: `true`.
        """
        return pulumi.get(self, "compute_enable_ht")

    @compute_enable_ht.setter
    def compute_enable_ht(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "compute_enable_ht", value)

    @_builtins.property
    @pulumi.getter(name="computeSpotPriceLimit")
    def compute_spot_price_limit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum hourly price of the compute nodes. A maximum of three decimal places can be used in the value of the parameter. The parameter is valid only when the ComputeSpotStrategy parameter is set to SpotWithPriceLimit.
        """
        return pulumi.get(self, "compute_spot_price_limit")

    @compute_spot_price_limit.setter
    def compute_spot_price_limit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_spot_price_limit", value)

    @_builtins.property
    @pulumi.getter(name="computeSpotStrategy")
    def compute_spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bidding method of the compute nodes. Default value: `NoSpot`. Valid values:
        - `NoSpot`: The compute nodes are pay-as-you-go instances.
        - `SpotWithPriceLimit`: The compute nodes are preemptible instances that have a user-defined maximum hourly price.
        - `SpotAsPriceGo`: The compute nodes are preemptible instances for which the market price at the time of purchase is used as the bid price.
        """
        return pulumi.get(self, "compute_spot_strategy")

    @compute_spot_strategy.setter
    def compute_spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_spot_strategy", value)

    @_builtins.property
    @pulumi.getter(name="deployMode")
    def deploy_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode in which the cluster is deployed. Valid values: `Standard`, `Simple`, `Tiny`. Default value: Standard.
        - `Standard`: An account node, a scheduling node, a logon node, and multiple compute nodes are separately deployed.
        - `Simple`: A management node, a logon node, and multiple compute nodes are deployed. The management node consists of an account node and a scheduling node. The logon node and compute nodes are separately deployed.
        - `Tiny`: A management node and multiple compute nodes are deployed. The management node consists of an account node, a scheduling node, and a logon node. The compute nodes are separately deployed.
        """
        return pulumi.get(self, "deploy_mode")

    @deploy_mode.setter
    def deploy_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deploy_mode", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the cluster. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name of the on-premises cluster. This parameter takes effect only when the AccoutType parameter is set to Idap.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="ecsChargeType")
    def ecs_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the nodes.
        """
        return pulumi.get(self, "ecs_charge_type")

    @ecs_charge_type.setter
    def ecs_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ecs_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="ehpcVersion")
    def ehpc_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of E-HPC. By default, the parameter is set to the latest version number.
        """
        return pulumi.get(self, "ehpc_version")

    @ehpc_version.setter
    def ehpc_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ehpc_version", value)

    @_builtins.property
    @pulumi.getter(name="haEnable")
    def ha_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the high availability feature. Default value: `false`.  **Note:** If high availability is enabled, a primary management node and a secondary management node are used.
        """
        return pulumi.get(self, "ha_enable")

    @ha_enable.setter
    def ha_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ha_enable", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the image.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="imageOwnerAlias")
    def image_owner_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the image. Valid values: `others`, `self`, `system`, `marketplace`. Default value: `system`.
        """
        return pulumi.get(self, "image_owner_alias")

    @image_owner_alias.setter
    def image_owner_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_owner_alias", value)

    @_builtins.property
    @pulumi.getter(name="inputFileUrl")
    def input_file_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the job files that are uploaded to an Object Storage Service (OSS) bucket.
        """
        return pulumi.get(self, "input_file_url")

    @input_file_url.setter
    def input_file_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "input_file_url", value)

    @_builtins.property
    @pulumi.getter(name="isComputeEss")
    def is_compute_ess(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable auto scaling. Default value: `false`.
        """
        return pulumi.get(self, "is_compute_ess")

    @is_compute_ess.setter
    def is_compute_ess(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_compute_ess", value)

    @_builtins.property
    @pulumi.getter(name="jobQueue")
    def job_queue(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The queue to which the compute nodes are added.
        """
        return pulumi.get(self, "job_queue")

    @job_queue.setter
    def job_queue(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_queue", value)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the AccessKey pair.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter(name="managerCount")
    def manager_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of the management nodes. Valid values: 1 and 2.
        """
        return pulumi.get(self, "manager_count")

    @manager_count.setter
    def manager_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "manager_count", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The root password of the logon node. The password must be 8 to 30 characters in length and contain at least three of the following items: uppercase letters, lowercase letters, digits, and special characters. The password can contain the following special characters: `( ) ~ ! @ # $ % ^ & * - + = { } [ ] : ; ‘ < > , . ? /`. You must specify either `password` or `key_pair_name`. If both are specified, the Password parameter prevails.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration of the subscription. The unit of the duration is specified by the `period_unit` parameter. Default value: `1`.
        * If you set PriceUnit to Year, the valid values of the Period parameter are 1, 2, and 3.
        * If you set PriceUnit to Month, the valid values of the Period parameter are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
        * If you set PriceUnit to Hour, the valid value of the Period parameter is 1.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of the subscription duration. Valid values: `Year`, `Month`, `Hour`. Default value: `Month`.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def plugin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode configurations of the plug-in. This parameter takes effect only when the SchedulerType parameter is set to custom. The value must be a JSON string. The parameter contains the following parameters: pluginMod, pluginLocalPath, and pluginOssPath.
        - pluginMod: the mode of the plug-in. The following modes are supported:
        - oss: The plug-in is downloaded and decompressed from OSS to a local path. The local path is specified by the pluginLocalPath parameter.
        - image: By default, the plug-in is stored in a pre-defined local path. The local path is specified by the pluginLocalPath parameter.
        - pluginLocalPath: the local path where the plug-in is stored. We recommend that you select a shared directory in oss mode and a non-shared directory in image mode.
        - pluginOssPath: the remote path where the plug-in is stored in OSS. This parameter takes effect only when the pluginMod parameter is set to oss.
        """
        return pulumi.get(self, "plugin")

    @plugin.setter
    def plugin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin", value)

    @_builtins.property
    @pulumi.getter(name="postInstallScripts")
    def post_install_scripts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPostInstallScriptArgs']]]]:
        """
        The post install script. See `post_install_script` below.
        """
        return pulumi.get(self, "post_install_scripts")

    @post_install_scripts.setter
    def post_install_scripts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPostInstallScriptArgs']]]]):
        pulumi.set(self, "post_install_scripts", value)

    @_builtins.property
    @pulumi.getter(name="ramNodeTypes")
    def ram_node_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The node of the RAM role.
        """
        return pulumi.get(self, "ram_node_types")

    @ram_node_types.setter
    def ram_node_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ram_node_types", value)

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Access Management (RAM) role.
        """
        return pulumi.get(self, "ram_role_name")

    @ram_role_name.setter
    def ram_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ram_role_name", value)

    @_builtins.property
    @pulumi.getter(name="releaseInstance")
    def release_instance(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The release instance. Valid values: `true`.
        """
        return pulumi.get(self, "release_instance")

    @release_instance.setter
    def release_instance(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "release_instance", value)

    @_builtins.property
    @pulumi.getter(name="remoteDirectory")
    def remote_directory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The remote directory to which the file system is mounted.
        """
        return pulumi.get(self, "remote_directory")

    @remote_directory.setter
    def remote_directory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_directory", value)

    @_builtins.property
    @pulumi.getter(name="remoteVisEnable")
    def remote_vis_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable Virtual Network Computing (VNC). Default value: `false`.
        """
        return pulumi.get(self, "remote_vis_enable")

    @remote_vis_enable.setter
    def remote_vis_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remote_vis_enable", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sccClusterId")
    def scc_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Super Computing Cluster (SCC) instance. If you specify the parameter, the SCC instance is moved to a new SCC cluster.
        """
        return pulumi.get(self, "scc_cluster_id")

    @scc_cluster_id.setter
    def scc_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scc_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="schedulerType")
    def scheduler_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the scheduler. Valid values: `pbs`, `slurm`, `opengridscheduler` and `deadline`. Default value: `pbs`.
        """
        return pulumi.get(self, "scheduler_type")

    @scheduler_type.setter
    def scheduler_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduler_type", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the security group to which the cluster belongs.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupName")
    def security_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If you do not use an existing security group, set the parameter to the name of a new security group. A default policy is applied to the new security group.
        """
        return pulumi.get(self, "security_group_name")

    @security_group_name.setter
    def security_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_name", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskLevel")
    def system_disk_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The performance level of the ESSD that is used as the system disk. Default value: `PL1` For more information, see [ESSDs](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/essds). Valid values:
        * `PL0`: A single ESSD can deliver up to 10,000 random read/write IOPS.
        * `PL1`: A single ESSD can deliver up to 50,000 random read/write IOPS.
        * `PL2`: A single ESSD can deliver up to 100,000 random read/write IOPS.
        * `PL3`: A single ESSD can deliver up to 1,000,000 random read/write IOPS.
        """
        return pulumi.get(self, "system_disk_level")

    @system_disk_level.setter
    def system_disk_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_level", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the system disk. Unit: `GB`. Valid values: `40` to `500`. Default value: `40`.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskType")
    def system_disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the system disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd` or `cloud`. Default value: `cloud_ssd`.
        """
        return pulumi.get(self, "system_disk_type")

    @system_disk_type.setter
    def system_disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_type", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the file system. If you leave the parameter empty, a Performance NAS file system is created by default.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_id", value)

    @_builtins.property
    @pulumi.getter(name="volumeMountOption")
    def volume_mount_option(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mount options of the file system.
        """
        return pulumi.get(self, "volume_mount_option")

    @volume_mount_option.setter
    def volume_mount_option(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_mount_option", value)

    @_builtins.property
    @pulumi.getter(name="volumeMountpoint")
    def volume_mountpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mount target of the file system. Take note of the following information:
        - If you do not specify the VolumeId parameter, you can leave the VolumeMountpoint parameter empty. A mount target is created by default.
        - If you specify the VolumeId parameter, the VolumeMountpoint parameter is required.
        """
        return pulumi.get(self, "volume_mountpoint")

    @volume_mountpoint.setter
    def volume_mountpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_mountpoint", value)

    @_builtins.property
    @pulumi.getter(name="volumeProtocol")
    def volume_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the protocol that is used by the file system. Valid values: `NFS`, `SMB`. Default value: `NFS`.
        """
        return pulumi.get(self, "volume_protocol")

    @volume_protocol.setter
    def volume_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_protocol", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the shared storage. Only Apsara File Storage NAS file systems are supported.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_type", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the virtual private cloud (VPC) to which the cluster belongs.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the vSwitch. E-HPC supports only VPC networks.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="withoutAgent")
    def without_agent(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether not to install the agent. Default value: `false`.
        """
        return pulumi.get(self, "without_agent")

    @without_agent.setter
    def without_agent(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "without_agent", value)

    @_builtins.property
    @pulumi.getter(name="withoutElasticIp")
    def without_elastic_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the logon node uses an elastic IP address (EIP). Default value: `false`.
        """
        return pulumi.get(self, "without_elastic_ip")

    @without_elastic_ip.setter
    def without_elastic_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "without_elastic_ip", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 additional_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAdditionalVolumeArgs']]]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterApplicationArgs']]]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 client_version: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_count: Optional[pulumi.Input[_builtins.int]] = None,
                 compute_enable_ht: Optional[pulumi.Input[_builtins.bool]] = None,
                 compute_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_spot_price_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 deploy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 ecs_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ehpc_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_owner_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 input_file_url: Optional[pulumi.Input[_builtins.str]] = None,
                 is_compute_ess: Optional[pulumi.Input[_builtins.bool]] = None,
                 job_queue: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 login_count: Optional[pulumi.Input[_builtins.int]] = None,
                 login_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_count: Optional[pulumi.Input[_builtins.int]] = None,
                 manager_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 os_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin: Optional[pulumi.Input[_builtins.str]] = None,
                 post_install_scripts: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPostInstallScriptArgs']]]] = None,
                 ram_node_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 release_instance: Optional[pulumi.Input[_builtins.bool]] = None,
                 remote_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_vis_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scc_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_level: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_mount_option: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_mountpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 without_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 without_elastic_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[_builtins.str] account_type: The type of the domain account service. Valid values: `nis`, `ldap`. Default value: `nis`
        :param pulumi.Input[Sequence[pulumi.Input['ClusterAdditionalVolumeArgs']]] additional_volumes: The additional volumes. See `additional_volumes` below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterApplicationArgs']]] applications: The application. See `application` below.
        :param pulumi.Input[_builtins.bool] auto_renew: Specifies whether to enable auto-renewal for the subscription. Default value: `false`.
        :param pulumi.Input[_builtins.int] auto_renew_period: The auto-renewal period of the subscription compute nodes. The parameter takes effect when AutoRenew is set to true.
        :param pulumi.Input[_builtins.str] client_version: The version of the E-HPC client. By default, the parameter is set to the latest version number.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the cluster. The name must be `2` to `64` characters in length.
        :param pulumi.Input[_builtins.str] cluster_version: The version of the cluster. Default value: `1.0`.
        :param pulumi.Input[_builtins.int] compute_count: The number of the compute nodes. Valid values: `1` to `99`.
        :param pulumi.Input[_builtins.bool] compute_enable_ht: Specifies whether the compute nodes support hyper-threading. Default value: `true`.
        :param pulumi.Input[_builtins.str] compute_instance_type: The instance type of the compute nodes.
        :param pulumi.Input[_builtins.str] compute_spot_price_limit: The maximum hourly price of the compute nodes. A maximum of three decimal places can be used in the value of the parameter. The parameter is valid only when the ComputeSpotStrategy parameter is set to SpotWithPriceLimit.
        :param pulumi.Input[_builtins.str] compute_spot_strategy: The bidding method of the compute nodes. Default value: `NoSpot`. Valid values:
               - `NoSpot`: The compute nodes are pay-as-you-go instances.
               - `SpotWithPriceLimit`: The compute nodes are preemptible instances that have a user-defined maximum hourly price.
               - `SpotAsPriceGo`: The compute nodes are preemptible instances for which the market price at the time of purchase is used as the bid price.
        :param pulumi.Input[_builtins.str] deploy_mode: The mode in which the cluster is deployed. Valid values: `Standard`, `Simple`, `Tiny`. Default value: Standard.
               - `Standard`: An account node, a scheduling node, a logon node, and multiple compute nodes are separately deployed.
               - `Simple`: A management node, a logon node, and multiple compute nodes are deployed. The management node consists of an account node and a scheduling node. The logon node and compute nodes are separately deployed.
               - `Tiny`: A management node and multiple compute nodes are deployed. The management node consists of an account node, a scheduling node, and a logon node. The compute nodes are separately deployed.
        :param pulumi.Input[_builtins.str] description: The description of the cluster. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] domain: The domain name of the on-premises cluster. This parameter takes effect only when the AccoutType parameter is set to Idap.
        :param pulumi.Input[_builtins.str] ecs_charge_type: The billing method of the nodes.
        :param pulumi.Input[_builtins.str] ehpc_version: The version of E-HPC. By default, the parameter is set to the latest version number.
        :param pulumi.Input[_builtins.bool] ha_enable: Specifies whether to enable the high availability feature. Default value: `false`.  **Note:** If high availability is enabled, a primary management node and a secondary management node are used.
        :param pulumi.Input[_builtins.str] image_id: The ID of the image.
        :param pulumi.Input[_builtins.str] image_owner_alias: The type of the image. Valid values: `others`, `self`, `system`, `marketplace`. Default value: `system`.
        :param pulumi.Input[_builtins.str] input_file_url: The URL of the job files that are uploaded to an Object Storage Service (OSS) bucket.
        :param pulumi.Input[_builtins.bool] is_compute_ess: Specifies whether to enable auto scaling. Default value: `false`.
        :param pulumi.Input[_builtins.str] job_queue: The queue to which the compute nodes are added.
        :param pulumi.Input[_builtins.str] key_pair_name: The name of the AccessKey pair.
        :param pulumi.Input[_builtins.int] login_count: The number of the logon nodes. Valid values: `1`.
        :param pulumi.Input[_builtins.str] login_instance_type: The instance type of the logon nodes.
        :param pulumi.Input[_builtins.int] manager_count: The number of the management nodes. Valid values: 1 and 2.
        :param pulumi.Input[_builtins.str] manager_instance_type: The instance type of the management nodes.
        :param pulumi.Input[_builtins.str] os_tag: The image tag of the operating system.
        :param pulumi.Input[_builtins.str] password: The root password of the logon node. The password must be 8 to 30 characters in length and contain at least three of the following items: uppercase letters, lowercase letters, digits, and special characters. The password can contain the following special characters: `( ) ~ ! @ # $ % ^ & * - + = { } [ ] : ; ‘ < > , . ? /`. You must specify either `password` or `key_pair_name`. If both are specified, the Password parameter prevails.
        :param pulumi.Input[_builtins.int] period: The duration of the subscription. The unit of the duration is specified by the `period_unit` parameter. Default value: `1`.
               * If you set PriceUnit to Year, the valid values of the Period parameter are 1, 2, and 3.
               * If you set PriceUnit to Month, the valid values of the Period parameter are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
               * If you set PriceUnit to Hour, the valid value of the Period parameter is 1.
        :param pulumi.Input[_builtins.str] period_unit: The unit of the subscription duration. Valid values: `Year`, `Month`, `Hour`. Default value: `Month`.
        :param pulumi.Input[_builtins.str] plugin: The mode configurations of the plug-in. This parameter takes effect only when the SchedulerType parameter is set to custom. The value must be a JSON string. The parameter contains the following parameters: pluginMod, pluginLocalPath, and pluginOssPath.
               - pluginMod: the mode of the plug-in. The following modes are supported:
               - oss: The plug-in is downloaded and decompressed from OSS to a local path. The local path is specified by the pluginLocalPath parameter.
               - image: By default, the plug-in is stored in a pre-defined local path. The local path is specified by the pluginLocalPath parameter.
               - pluginLocalPath: the local path where the plug-in is stored. We recommend that you select a shared directory in oss mode and a non-shared directory in image mode.
               - pluginOssPath: the remote path where the plug-in is stored in OSS. This parameter takes effect only when the pluginMod parameter is set to oss.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterPostInstallScriptArgs']]] post_install_scripts: The post install script. See `post_install_script` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ram_node_types: The node of the RAM role.
        :param pulumi.Input[_builtins.str] ram_role_name: The name of the Resource Access Management (RAM) role.
        :param pulumi.Input[_builtins.bool] release_instance: The release instance. Valid values: `true`.
        :param pulumi.Input[_builtins.str] remote_directory: The remote directory to which the file system is mounted.
        :param pulumi.Input[_builtins.bool] remote_vis_enable: Specifies whether to enable Virtual Network Computing (VNC). Default value: `false`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] scc_cluster_id: The ID of the Super Computing Cluster (SCC) instance. If you specify the parameter, the SCC instance is moved to a new SCC cluster.
        :param pulumi.Input[_builtins.str] scheduler_type: The type of the scheduler. Valid values: `pbs`, `slurm`, `opengridscheduler` and `deadline`. Default value: `pbs`.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the cluster belongs.
        :param pulumi.Input[_builtins.str] security_group_name: If you do not use an existing security group, set the parameter to the name of a new security group. A default policy is applied to the new security group.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.str] system_disk_level: The performance level of the ESSD that is used as the system disk. Default value: `PL1` For more information, see [ESSDs](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/essds). Valid values:
               * `PL0`: A single ESSD can deliver up to 10,000 random read/write IOPS.
               * `PL1`: A single ESSD can deliver up to 50,000 random read/write IOPS.
               * `PL2`: A single ESSD can deliver up to 100,000 random read/write IOPS.
               * `PL3`: A single ESSD can deliver up to 1,000,000 random read/write IOPS.
        :param pulumi.Input[_builtins.int] system_disk_size: The size of the system disk. Unit: `GB`. Valid values: `40` to `500`. Default value: `40`.
        :param pulumi.Input[_builtins.str] system_disk_type: The type of the system disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd` or `cloud`. Default value: `cloud_ssd`.
        :param pulumi.Input[_builtins.str] volume_id: The ID of the file system. If you leave the parameter empty, a Performance NAS file system is created by default.
        :param pulumi.Input[_builtins.str] volume_mount_option: The mount options of the file system.
        :param pulumi.Input[_builtins.str] volume_mountpoint: The mount target of the file system. Take note of the following information:
               - If you do not specify the VolumeId parameter, you can leave the VolumeMountpoint parameter empty. A mount target is created by default.
               - If you specify the VolumeId parameter, the VolumeMountpoint parameter is required.
        :param pulumi.Input[_builtins.str] volume_protocol: The type of the protocol that is used by the file system. Valid values: `NFS`, `SMB`. Default value: `NFS`.
        :param pulumi.Input[_builtins.str] volume_type: The type of the shared storage. Only Apsara File Storage NAS file systems are supported.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC) to which the cluster belongs.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch. E-HPC supports only VPC networks.
        :param pulumi.Input[_builtins.bool] without_agent: Specifies whether not to install the agent. Default value: `false`.
        :param pulumi.Input[_builtins.bool] without_elastic_ip: Specifies whether the logon node uses an elastic IP address (EIP). Default value: `false`.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone.
        """
        if account_type is not None:
            pulumi.set(__self__, "account_type", account_type)
        if additional_volumes is not None:
            pulumi.set(__self__, "additional_volumes", additional_volumes)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if client_version is not None:
            pulumi.set(__self__, "client_version", client_version)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_version is not None:
            pulumi.set(__self__, "cluster_version", cluster_version)
        if compute_count is not None:
            pulumi.set(__self__, "compute_count", compute_count)
        if compute_enable_ht is not None:
            pulumi.set(__self__, "compute_enable_ht", compute_enable_ht)
        if compute_instance_type is not None:
            pulumi.set(__self__, "compute_instance_type", compute_instance_type)
        if compute_spot_price_limit is not None:
            pulumi.set(__self__, "compute_spot_price_limit", compute_spot_price_limit)
        if compute_spot_strategy is not None:
            pulumi.set(__self__, "compute_spot_strategy", compute_spot_strategy)
        if deploy_mode is not None:
            pulumi.set(__self__, "deploy_mode", deploy_mode)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if ecs_charge_type is not None:
            pulumi.set(__self__, "ecs_charge_type", ecs_charge_type)
        if ehpc_version is not None:
            pulumi.set(__self__, "ehpc_version", ehpc_version)
        if ha_enable is not None:
            pulumi.set(__self__, "ha_enable", ha_enable)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_owner_alias is not None:
            pulumi.set(__self__, "image_owner_alias", image_owner_alias)
        if input_file_url is not None:
            pulumi.set(__self__, "input_file_url", input_file_url)
        if is_compute_ess is not None:
            pulumi.set(__self__, "is_compute_ess", is_compute_ess)
        if job_queue is not None:
            pulumi.set(__self__, "job_queue", job_queue)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if login_count is not None:
            pulumi.set(__self__, "login_count", login_count)
        if login_instance_type is not None:
            pulumi.set(__self__, "login_instance_type", login_instance_type)
        if manager_count is not None:
            pulumi.set(__self__, "manager_count", manager_count)
        if manager_instance_type is not None:
            pulumi.set(__self__, "manager_instance_type", manager_instance_type)
        if os_tag is not None:
            pulumi.set(__self__, "os_tag", os_tag)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if plugin is not None:
            pulumi.set(__self__, "plugin", plugin)
        if post_install_scripts is not None:
            pulumi.set(__self__, "post_install_scripts", post_install_scripts)
        if ram_node_types is not None:
            pulumi.set(__self__, "ram_node_types", ram_node_types)
        if ram_role_name is not None:
            pulumi.set(__self__, "ram_role_name", ram_role_name)
        if release_instance is not None:
            pulumi.set(__self__, "release_instance", release_instance)
        if remote_directory is not None:
            pulumi.set(__self__, "remote_directory", remote_directory)
        if remote_vis_enable is not None:
            pulumi.set(__self__, "remote_vis_enable", remote_vis_enable)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scc_cluster_id is not None:
            pulumi.set(__self__, "scc_cluster_id", scc_cluster_id)
        if scheduler_type is not None:
            pulumi.set(__self__, "scheduler_type", scheduler_type)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_name is not None:
            pulumi.set(__self__, "security_group_name", security_group_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_disk_level is not None:
            pulumi.set(__self__, "system_disk_level", system_disk_level)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if system_disk_type is not None:
            pulumi.set(__self__, "system_disk_type", system_disk_type)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if volume_mount_option is not None:
            pulumi.set(__self__, "volume_mount_option", volume_mount_option)
        if volume_mountpoint is not None:
            pulumi.set(__self__, "volume_mountpoint", volume_mountpoint)
        if volume_protocol is not None:
            pulumi.set(__self__, "volume_protocol", volume_protocol)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if without_agent is not None:
            pulumi.set(__self__, "without_agent", without_agent)
        if without_elastic_ip is not None:
            pulumi.set(__self__, "without_elastic_ip", without_elastic_ip)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the domain account service. Valid values: `nis`, `ldap`. Default value: `nis`
        """
        return pulumi.get(self, "account_type")

    @account_type.setter
    def account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_type", value)

    @_builtins.property
    @pulumi.getter(name="additionalVolumes")
    def additional_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAdditionalVolumeArgs']]]]:
        """
        The additional volumes. See `additional_volumes` below.
        """
        return pulumi.get(self, "additional_volumes")

    @additional_volumes.setter
    def additional_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAdditionalVolumeArgs']]]]):
        pulumi.set(self, "additional_volumes", value)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterApplicationArgs']]]]:
        """
        The application. See `application` below.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterApplicationArgs']]]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable auto-renewal for the subscription. Default value: `false`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The auto-renewal period of the subscription compute nodes. The parameter takes effect when AutoRenew is set to true.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the E-HPC client. By default, the parameter is set to the latest version number.
        """
        return pulumi.get(self, "client_version")

    @client_version.setter
    def client_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_version", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the cluster. The name must be `2` to `64` characters in length.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the cluster. Default value: `1.0`.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_version", value)

    @_builtins.property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of the compute nodes. Valid values: `1` to `99`.
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "compute_count", value)

    @_builtins.property
    @pulumi.getter(name="computeEnableHt")
    def compute_enable_ht(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the compute nodes support hyper-threading. Default value: `true`.
        """
        return pulumi.get(self, "compute_enable_ht")

    @compute_enable_ht.setter
    def compute_enable_ht(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "compute_enable_ht", value)

    @_builtins.property
    @pulumi.getter(name="computeInstanceType")
    def compute_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance type of the compute nodes.
        """
        return pulumi.get(self, "compute_instance_type")

    @compute_instance_type.setter
    def compute_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="computeSpotPriceLimit")
    def compute_spot_price_limit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum hourly price of the compute nodes. A maximum of three decimal places can be used in the value of the parameter. The parameter is valid only when the ComputeSpotStrategy parameter is set to SpotWithPriceLimit.
        """
        return pulumi.get(self, "compute_spot_price_limit")

    @compute_spot_price_limit.setter
    def compute_spot_price_limit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_spot_price_limit", value)

    @_builtins.property
    @pulumi.getter(name="computeSpotStrategy")
    def compute_spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bidding method of the compute nodes. Default value: `NoSpot`. Valid values:
        - `NoSpot`: The compute nodes are pay-as-you-go instances.
        - `SpotWithPriceLimit`: The compute nodes are preemptible instances that have a user-defined maximum hourly price.
        - `SpotAsPriceGo`: The compute nodes are preemptible instances for which the market price at the time of purchase is used as the bid price.
        """
        return pulumi.get(self, "compute_spot_strategy")

    @compute_spot_strategy.setter
    def compute_spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_spot_strategy", value)

    @_builtins.property
    @pulumi.getter(name="deployMode")
    def deploy_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode in which the cluster is deployed. Valid values: `Standard`, `Simple`, `Tiny`. Default value: Standard.
        - `Standard`: An account node, a scheduling node, a logon node, and multiple compute nodes are separately deployed.
        - `Simple`: A management node, a logon node, and multiple compute nodes are deployed. The management node consists of an account node and a scheduling node. The logon node and compute nodes are separately deployed.
        - `Tiny`: A management node and multiple compute nodes are deployed. The management node consists of an account node, a scheduling node, and a logon node. The compute nodes are separately deployed.
        """
        return pulumi.get(self, "deploy_mode")

    @deploy_mode.setter
    def deploy_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deploy_mode", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the cluster. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name of the on-premises cluster. This parameter takes effect only when the AccoutType parameter is set to Idap.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="ecsChargeType")
    def ecs_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the nodes.
        """
        return pulumi.get(self, "ecs_charge_type")

    @ecs_charge_type.setter
    def ecs_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ecs_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="ehpcVersion")
    def ehpc_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of E-HPC. By default, the parameter is set to the latest version number.
        """
        return pulumi.get(self, "ehpc_version")

    @ehpc_version.setter
    def ehpc_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ehpc_version", value)

    @_builtins.property
    @pulumi.getter(name="haEnable")
    def ha_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the high availability feature. Default value: `false`.  **Note:** If high availability is enabled, a primary management node and a secondary management node are used.
        """
        return pulumi.get(self, "ha_enable")

    @ha_enable.setter
    def ha_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ha_enable", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the image.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="imageOwnerAlias")
    def image_owner_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the image. Valid values: `others`, `self`, `system`, `marketplace`. Default value: `system`.
        """
        return pulumi.get(self, "image_owner_alias")

    @image_owner_alias.setter
    def image_owner_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_owner_alias", value)

    @_builtins.property
    @pulumi.getter(name="inputFileUrl")
    def input_file_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the job files that are uploaded to an Object Storage Service (OSS) bucket.
        """
        return pulumi.get(self, "input_file_url")

    @input_file_url.setter
    def input_file_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "input_file_url", value)

    @_builtins.property
    @pulumi.getter(name="isComputeEss")
    def is_compute_ess(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable auto scaling. Default value: `false`.
        """
        return pulumi.get(self, "is_compute_ess")

    @is_compute_ess.setter
    def is_compute_ess(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_compute_ess", value)

    @_builtins.property
    @pulumi.getter(name="jobQueue")
    def job_queue(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The queue to which the compute nodes are added.
        """
        return pulumi.get(self, "job_queue")

    @job_queue.setter
    def job_queue(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_queue", value)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the AccessKey pair.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter(name="loginCount")
    def login_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of the logon nodes. Valid values: `1`.
        """
        return pulumi.get(self, "login_count")

    @login_count.setter
    def login_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "login_count", value)

    @_builtins.property
    @pulumi.getter(name="loginInstanceType")
    def login_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance type of the logon nodes.
        """
        return pulumi.get(self, "login_instance_type")

    @login_instance_type.setter
    def login_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="managerCount")
    def manager_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of the management nodes. Valid values: 1 and 2.
        """
        return pulumi.get(self, "manager_count")

    @manager_count.setter
    def manager_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "manager_count", value)

    @_builtins.property
    @pulumi.getter(name="managerInstanceType")
    def manager_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance type of the management nodes.
        """
        return pulumi.get(self, "manager_instance_type")

    @manager_instance_type.setter
    def manager_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manager_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="osTag")
    def os_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The image tag of the operating system.
        """
        return pulumi.get(self, "os_tag")

    @os_tag.setter
    def os_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_tag", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The root password of the logon node. The password must be 8 to 30 characters in length and contain at least three of the following items: uppercase letters, lowercase letters, digits, and special characters. The password can contain the following special characters: `( ) ~ ! @ # $ % ^ & * - + = { } [ ] : ; ‘ < > , . ? /`. You must specify either `password` or `key_pair_name`. If both are specified, the Password parameter prevails.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration of the subscription. The unit of the duration is specified by the `period_unit` parameter. Default value: `1`.
        * If you set PriceUnit to Year, the valid values of the Period parameter are 1, 2, and 3.
        * If you set PriceUnit to Month, the valid values of the Period parameter are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
        * If you set PriceUnit to Hour, the valid value of the Period parameter is 1.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of the subscription duration. Valid values: `Year`, `Month`, `Hour`. Default value: `Month`.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def plugin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode configurations of the plug-in. This parameter takes effect only when the SchedulerType parameter is set to custom. The value must be a JSON string. The parameter contains the following parameters: pluginMod, pluginLocalPath, and pluginOssPath.
        - pluginMod: the mode of the plug-in. The following modes are supported:
        - oss: The plug-in is downloaded and decompressed from OSS to a local path. The local path is specified by the pluginLocalPath parameter.
        - image: By default, the plug-in is stored in a pre-defined local path. The local path is specified by the pluginLocalPath parameter.
        - pluginLocalPath: the local path where the plug-in is stored. We recommend that you select a shared directory in oss mode and a non-shared directory in image mode.
        - pluginOssPath: the remote path where the plug-in is stored in OSS. This parameter takes effect only when the pluginMod parameter is set to oss.
        """
        return pulumi.get(self, "plugin")

    @plugin.setter
    def plugin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin", value)

    @_builtins.property
    @pulumi.getter(name="postInstallScripts")
    def post_install_scripts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPostInstallScriptArgs']]]]:
        """
        The post install script. See `post_install_script` below.
        """
        return pulumi.get(self, "post_install_scripts")

    @post_install_scripts.setter
    def post_install_scripts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPostInstallScriptArgs']]]]):
        pulumi.set(self, "post_install_scripts", value)

    @_builtins.property
    @pulumi.getter(name="ramNodeTypes")
    def ram_node_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The node of the RAM role.
        """
        return pulumi.get(self, "ram_node_types")

    @ram_node_types.setter
    def ram_node_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ram_node_types", value)

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Access Management (RAM) role.
        """
        return pulumi.get(self, "ram_role_name")

    @ram_role_name.setter
    def ram_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ram_role_name", value)

    @_builtins.property
    @pulumi.getter(name="releaseInstance")
    def release_instance(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The release instance. Valid values: `true`.
        """
        return pulumi.get(self, "release_instance")

    @release_instance.setter
    def release_instance(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "release_instance", value)

    @_builtins.property
    @pulumi.getter(name="remoteDirectory")
    def remote_directory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The remote directory to which the file system is mounted.
        """
        return pulumi.get(self, "remote_directory")

    @remote_directory.setter
    def remote_directory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_directory", value)

    @_builtins.property
    @pulumi.getter(name="remoteVisEnable")
    def remote_vis_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable Virtual Network Computing (VNC). Default value: `false`.
        """
        return pulumi.get(self, "remote_vis_enable")

    @remote_vis_enable.setter
    def remote_vis_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remote_vis_enable", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sccClusterId")
    def scc_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Super Computing Cluster (SCC) instance. If you specify the parameter, the SCC instance is moved to a new SCC cluster.
        """
        return pulumi.get(self, "scc_cluster_id")

    @scc_cluster_id.setter
    def scc_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scc_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="schedulerType")
    def scheduler_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the scheduler. Valid values: `pbs`, `slurm`, `opengridscheduler` and `deadline`. Default value: `pbs`.
        """
        return pulumi.get(self, "scheduler_type")

    @scheduler_type.setter
    def scheduler_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduler_type", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the security group to which the cluster belongs.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupName")
    def security_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If you do not use an existing security group, set the parameter to the name of a new security group. A default policy is applied to the new security group.
        """
        return pulumi.get(self, "security_group_name")

    @security_group_name.setter
    def security_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskLevel")
    def system_disk_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The performance level of the ESSD that is used as the system disk. Default value: `PL1` For more information, see [ESSDs](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/essds). Valid values:
        * `PL0`: A single ESSD can deliver up to 10,000 random read/write IOPS.
        * `PL1`: A single ESSD can deliver up to 50,000 random read/write IOPS.
        * `PL2`: A single ESSD can deliver up to 100,000 random read/write IOPS.
        * `PL3`: A single ESSD can deliver up to 1,000,000 random read/write IOPS.
        """
        return pulumi.get(self, "system_disk_level")

    @system_disk_level.setter
    def system_disk_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_level", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the system disk. Unit: `GB`. Valid values: `40` to `500`. Default value: `40`.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskType")
    def system_disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the system disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd` or `cloud`. Default value: `cloud_ssd`.
        """
        return pulumi.get(self, "system_disk_type")

    @system_disk_type.setter
    def system_disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_type", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the file system. If you leave the parameter empty, a Performance NAS file system is created by default.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_id", value)

    @_builtins.property
    @pulumi.getter(name="volumeMountOption")
    def volume_mount_option(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mount options of the file system.
        """
        return pulumi.get(self, "volume_mount_option")

    @volume_mount_option.setter
    def volume_mount_option(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_mount_option", value)

    @_builtins.property
    @pulumi.getter(name="volumeMountpoint")
    def volume_mountpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mount target of the file system. Take note of the following information:
        - If you do not specify the VolumeId parameter, you can leave the VolumeMountpoint parameter empty. A mount target is created by default.
        - If you specify the VolumeId parameter, the VolumeMountpoint parameter is required.
        """
        return pulumi.get(self, "volume_mountpoint")

    @volume_mountpoint.setter
    def volume_mountpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_mountpoint", value)

    @_builtins.property
    @pulumi.getter(name="volumeProtocol")
    def volume_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the protocol that is used by the file system. Valid values: `NFS`, `SMB`. Default value: `NFS`.
        """
        return pulumi.get(self, "volume_protocol")

    @volume_protocol.setter
    def volume_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_protocol", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the shared storage. Only Apsara File Storage NAS file systems are supported.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_type", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the virtual private cloud (VPC) to which the cluster belongs.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the vSwitch. E-HPC supports only VPC networks.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="withoutAgent")
    def without_agent(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether not to install the agent. Default value: `false`.
        """
        return pulumi.get(self, "without_agent")

    @without_agent.setter
    def without_agent(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "without_agent", value)

    @_builtins.property
    @pulumi.getter(name="withoutElasticIp")
    def without_elastic_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the logon node uses an elastic IP address (EIP). Default value: `false`.
        """
        return pulumi.get(self, "without_elastic_ip")

    @without_elastic_ip.setter
    def without_elastic_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "without_elastic_ip", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:ehpc/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 additional_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterAdditionalVolumeArgs', 'ClusterAdditionalVolumeArgsDict']]]]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterApplicationArgs', 'ClusterApplicationArgsDict']]]]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 client_version: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_count: Optional[pulumi.Input[_builtins.int]] = None,
                 compute_enable_ht: Optional[pulumi.Input[_builtins.bool]] = None,
                 compute_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_spot_price_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 deploy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 ecs_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ehpc_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_owner_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 input_file_url: Optional[pulumi.Input[_builtins.str]] = None,
                 is_compute_ess: Optional[pulumi.Input[_builtins.bool]] = None,
                 job_queue: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 login_count: Optional[pulumi.Input[_builtins.int]] = None,
                 login_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_count: Optional[pulumi.Input[_builtins.int]] = None,
                 manager_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 os_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin: Optional[pulumi.Input[_builtins.str]] = None,
                 post_install_scripts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPostInstallScriptArgs', 'ClusterPostInstallScriptArgsDict']]]]] = None,
                 ram_node_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 release_instance: Optional[pulumi.Input[_builtins.bool]] = None,
                 remote_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_vis_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scc_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_level: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_mount_option: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_mountpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 without_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 without_elastic_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Ehpc Cluster resource.

        For information about Ehpc Cluster and how to use it, see [What is Cluster](https://www.alibabacloud.com/help/en/e-hpc/developer-reference/api-ehpc-2018-04-12-createcluster).

        > **NOTE:** Available since v1.173.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_get_images = alicloud.ecs.get_images(name_regex="^centos_7_6_x64*",
            owners="system")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id)
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.1.0.0/16",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_file_system = alicloud.nas.FileSystem("default",
            storage_type="Performance",
            protocol_type="NFS")
        default_mount_target = alicloud.nas.MountTarget("default",
            file_system_id=default_file_system.id,
            access_group_name="DEFAULT_VPC_GROUP_NAME",
            vswitch_id=default_switch.id)
        default_cluster = alicloud.ehpc.Cluster("default",
            cluster_name=name,
            deploy_mode="Simple",
            description=name,
            ha_enable=False,
            image_id=default_get_images.images[0].id,
            image_owner_alias="system",
            volume_protocol="nfs",
            volume_id=default_file_system.id,
            volume_mountpoint=default_mount_target.mount_target_domain,
            compute_count=1,
            compute_instance_type=default_get_instance_types.instance_types[0].id,
            login_count=1,
            login_instance_type=default_get_instance_types.instance_types[0].id,
            manager_count=1,
            manager_instance_type=default_get_instance_types.instance_types[0].id,
            os_tag="CentOS_7.6_64",
            scheduler_type="pbs",
            password="your-password123",
            vswitch_id=default_switch.id,
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        ```

        ## Import

        Ehpc Cluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ehpc/cluster:Cluster example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_type: The type of the domain account service. Valid values: `nis`, `ldap`. Default value: `nis`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterAdditionalVolumeArgs', 'ClusterAdditionalVolumeArgsDict']]]] additional_volumes: The additional volumes. See `additional_volumes` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterApplicationArgs', 'ClusterApplicationArgsDict']]]] applications: The application. See `application` below.
        :param pulumi.Input[_builtins.bool] auto_renew: Specifies whether to enable auto-renewal for the subscription. Default value: `false`.
        :param pulumi.Input[_builtins.int] auto_renew_period: The auto-renewal period of the subscription compute nodes. The parameter takes effect when AutoRenew is set to true.
        :param pulumi.Input[_builtins.str] client_version: The version of the E-HPC client. By default, the parameter is set to the latest version number.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the cluster. The name must be `2` to `64` characters in length.
        :param pulumi.Input[_builtins.str] cluster_version: The version of the cluster. Default value: `1.0`.
        :param pulumi.Input[_builtins.int] compute_count: The number of the compute nodes. Valid values: `1` to `99`.
        :param pulumi.Input[_builtins.bool] compute_enable_ht: Specifies whether the compute nodes support hyper-threading. Default value: `true`.
        :param pulumi.Input[_builtins.str] compute_instance_type: The instance type of the compute nodes.
        :param pulumi.Input[_builtins.str] compute_spot_price_limit: The maximum hourly price of the compute nodes. A maximum of three decimal places can be used in the value of the parameter. The parameter is valid only when the ComputeSpotStrategy parameter is set to SpotWithPriceLimit.
        :param pulumi.Input[_builtins.str] compute_spot_strategy: The bidding method of the compute nodes. Default value: `NoSpot`. Valid values:
               - `NoSpot`: The compute nodes are pay-as-you-go instances.
               - `SpotWithPriceLimit`: The compute nodes are preemptible instances that have a user-defined maximum hourly price.
               - `SpotAsPriceGo`: The compute nodes are preemptible instances for which the market price at the time of purchase is used as the bid price.
        :param pulumi.Input[_builtins.str] deploy_mode: The mode in which the cluster is deployed. Valid values: `Standard`, `Simple`, `Tiny`. Default value: Standard.
               - `Standard`: An account node, a scheduling node, a logon node, and multiple compute nodes are separately deployed.
               - `Simple`: A management node, a logon node, and multiple compute nodes are deployed. The management node consists of an account node and a scheduling node. The logon node and compute nodes are separately deployed.
               - `Tiny`: A management node and multiple compute nodes are deployed. The management node consists of an account node, a scheduling node, and a logon node. The compute nodes are separately deployed.
        :param pulumi.Input[_builtins.str] description: The description of the cluster. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] domain: The domain name of the on-premises cluster. This parameter takes effect only when the AccoutType parameter is set to Idap.
        :param pulumi.Input[_builtins.str] ecs_charge_type: The billing method of the nodes.
        :param pulumi.Input[_builtins.str] ehpc_version: The version of E-HPC. By default, the parameter is set to the latest version number.
        :param pulumi.Input[_builtins.bool] ha_enable: Specifies whether to enable the high availability feature. Default value: `false`.  **Note:** If high availability is enabled, a primary management node and a secondary management node are used.
        :param pulumi.Input[_builtins.str] image_id: The ID of the image.
        :param pulumi.Input[_builtins.str] image_owner_alias: The type of the image. Valid values: `others`, `self`, `system`, `marketplace`. Default value: `system`.
        :param pulumi.Input[_builtins.str] input_file_url: The URL of the job files that are uploaded to an Object Storage Service (OSS) bucket.
        :param pulumi.Input[_builtins.bool] is_compute_ess: Specifies whether to enable auto scaling. Default value: `false`.
        :param pulumi.Input[_builtins.str] job_queue: The queue to which the compute nodes are added.
        :param pulumi.Input[_builtins.str] key_pair_name: The name of the AccessKey pair.
        :param pulumi.Input[_builtins.int] login_count: The number of the logon nodes. Valid values: `1`.
        :param pulumi.Input[_builtins.str] login_instance_type: The instance type of the logon nodes.
        :param pulumi.Input[_builtins.int] manager_count: The number of the management nodes. Valid values: 1 and 2.
        :param pulumi.Input[_builtins.str] manager_instance_type: The instance type of the management nodes.
        :param pulumi.Input[_builtins.str] os_tag: The image tag of the operating system.
        :param pulumi.Input[_builtins.str] password: The root password of the logon node. The password must be 8 to 30 characters in length and contain at least three of the following items: uppercase letters, lowercase letters, digits, and special characters. The password can contain the following special characters: `( ) ~ ! @ # $ % ^ & * - + = { } [ ] : ; ‘ < > , . ? /`. You must specify either `password` or `key_pair_name`. If both are specified, the Password parameter prevails.
        :param pulumi.Input[_builtins.int] period: The duration of the subscription. The unit of the duration is specified by the `period_unit` parameter. Default value: `1`.
               * If you set PriceUnit to Year, the valid values of the Period parameter are 1, 2, and 3.
               * If you set PriceUnit to Month, the valid values of the Period parameter are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
               * If you set PriceUnit to Hour, the valid value of the Period parameter is 1.
        :param pulumi.Input[_builtins.str] period_unit: The unit of the subscription duration. Valid values: `Year`, `Month`, `Hour`. Default value: `Month`.
        :param pulumi.Input[_builtins.str] plugin: The mode configurations of the plug-in. This parameter takes effect only when the SchedulerType parameter is set to custom. The value must be a JSON string. The parameter contains the following parameters: pluginMod, pluginLocalPath, and pluginOssPath.
               - pluginMod: the mode of the plug-in. The following modes are supported:
               - oss: The plug-in is downloaded and decompressed from OSS to a local path. The local path is specified by the pluginLocalPath parameter.
               - image: By default, the plug-in is stored in a pre-defined local path. The local path is specified by the pluginLocalPath parameter.
               - pluginLocalPath: the local path where the plug-in is stored. We recommend that you select a shared directory in oss mode and a non-shared directory in image mode.
               - pluginOssPath: the remote path where the plug-in is stored in OSS. This parameter takes effect only when the pluginMod parameter is set to oss.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterPostInstallScriptArgs', 'ClusterPostInstallScriptArgsDict']]]] post_install_scripts: The post install script. See `post_install_script` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ram_node_types: The node of the RAM role.
        :param pulumi.Input[_builtins.str] ram_role_name: The name of the Resource Access Management (RAM) role.
        :param pulumi.Input[_builtins.bool] release_instance: The release instance. Valid values: `true`.
        :param pulumi.Input[_builtins.str] remote_directory: The remote directory to which the file system is mounted.
        :param pulumi.Input[_builtins.bool] remote_vis_enable: Specifies whether to enable Virtual Network Computing (VNC). Default value: `false`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] scc_cluster_id: The ID of the Super Computing Cluster (SCC) instance. If you specify the parameter, the SCC instance is moved to a new SCC cluster.
        :param pulumi.Input[_builtins.str] scheduler_type: The type of the scheduler. Valid values: `pbs`, `slurm`, `opengridscheduler` and `deadline`. Default value: `pbs`.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the cluster belongs.
        :param pulumi.Input[_builtins.str] security_group_name: If you do not use an existing security group, set the parameter to the name of a new security group. A default policy is applied to the new security group.
        :param pulumi.Input[_builtins.str] system_disk_level: The performance level of the ESSD that is used as the system disk. Default value: `PL1` For more information, see [ESSDs](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/essds). Valid values:
               * `PL0`: A single ESSD can deliver up to 10,000 random read/write IOPS.
               * `PL1`: A single ESSD can deliver up to 50,000 random read/write IOPS.
               * `PL2`: A single ESSD can deliver up to 100,000 random read/write IOPS.
               * `PL3`: A single ESSD can deliver up to 1,000,000 random read/write IOPS.
        :param pulumi.Input[_builtins.int] system_disk_size: The size of the system disk. Unit: `GB`. Valid values: `40` to `500`. Default value: `40`.
        :param pulumi.Input[_builtins.str] system_disk_type: The type of the system disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd` or `cloud`. Default value: `cloud_ssd`.
        :param pulumi.Input[_builtins.str] volume_id: The ID of the file system. If you leave the parameter empty, a Performance NAS file system is created by default.
        :param pulumi.Input[_builtins.str] volume_mount_option: The mount options of the file system.
        :param pulumi.Input[_builtins.str] volume_mountpoint: The mount target of the file system. Take note of the following information:
               - If you do not specify the VolumeId parameter, you can leave the VolumeMountpoint parameter empty. A mount target is created by default.
               - If you specify the VolumeId parameter, the VolumeMountpoint parameter is required.
        :param pulumi.Input[_builtins.str] volume_protocol: The type of the protocol that is used by the file system. Valid values: `NFS`, `SMB`. Default value: `NFS`.
        :param pulumi.Input[_builtins.str] volume_type: The type of the shared storage. Only Apsara File Storage NAS file systems are supported.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC) to which the cluster belongs.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch. E-HPC supports only VPC networks.
        :param pulumi.Input[_builtins.bool] without_agent: Specifies whether not to install the agent. Default value: `false`.
        :param pulumi.Input[_builtins.bool] without_elastic_ip: Specifies whether the logon node uses an elastic IP address (EIP). Default value: `false`.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Ehpc Cluster resource.

        For information about Ehpc Cluster and how to use it, see [What is Cluster](https://www.alibabacloud.com/help/en/e-hpc/developer-reference/api-ehpc-2018-04-12-createcluster).

        > **NOTE:** Available since v1.173.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_get_images = alicloud.ecs.get_images(name_regex="^centos_7_6_x64*",
            owners="system")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id)
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.1.0.0/16",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_file_system = alicloud.nas.FileSystem("default",
            storage_type="Performance",
            protocol_type="NFS")
        default_mount_target = alicloud.nas.MountTarget("default",
            file_system_id=default_file_system.id,
            access_group_name="DEFAULT_VPC_GROUP_NAME",
            vswitch_id=default_switch.id)
        default_cluster = alicloud.ehpc.Cluster("default",
            cluster_name=name,
            deploy_mode="Simple",
            description=name,
            ha_enable=False,
            image_id=default_get_images.images[0].id,
            image_owner_alias="system",
            volume_protocol="nfs",
            volume_id=default_file_system.id,
            volume_mountpoint=default_mount_target.mount_target_domain,
            compute_count=1,
            compute_instance_type=default_get_instance_types.instance_types[0].id,
            login_count=1,
            login_instance_type=default_get_instance_types.instance_types[0].id,
            manager_count=1,
            manager_instance_type=default_get_instance_types.instance_types[0].id,
            os_tag="CentOS_7.6_64",
            scheduler_type="pbs",
            password="your-password123",
            vswitch_id=default_switch.id,
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        ```

        ## Import

        Ehpc Cluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ehpc/cluster:Cluster example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 additional_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterAdditionalVolumeArgs', 'ClusterAdditionalVolumeArgsDict']]]]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterApplicationArgs', 'ClusterApplicationArgsDict']]]]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 client_version: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_count: Optional[pulumi.Input[_builtins.int]] = None,
                 compute_enable_ht: Optional[pulumi.Input[_builtins.bool]] = None,
                 compute_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_spot_price_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 deploy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 ecs_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ehpc_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_owner_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 input_file_url: Optional[pulumi.Input[_builtins.str]] = None,
                 is_compute_ess: Optional[pulumi.Input[_builtins.bool]] = None,
                 job_queue: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 login_count: Optional[pulumi.Input[_builtins.int]] = None,
                 login_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_count: Optional[pulumi.Input[_builtins.int]] = None,
                 manager_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 os_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin: Optional[pulumi.Input[_builtins.str]] = None,
                 post_install_scripts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPostInstallScriptArgs', 'ClusterPostInstallScriptArgsDict']]]]] = None,
                 ram_node_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 release_instance: Optional[pulumi.Input[_builtins.bool]] = None,
                 remote_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_vis_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scc_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_level: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_mount_option: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_mountpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 without_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 without_elastic_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["account_type"] = account_type
            __props__.__dict__["additional_volumes"] = additional_volumes
            __props__.__dict__["applications"] = applications
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["client_version"] = client_version
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["cluster_version"] = cluster_version
            if compute_count is None and not opts.urn:
                raise TypeError("Missing required property 'compute_count'")
            __props__.__dict__["compute_count"] = compute_count
            __props__.__dict__["compute_enable_ht"] = compute_enable_ht
            if compute_instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'compute_instance_type'")
            __props__.__dict__["compute_instance_type"] = compute_instance_type
            __props__.__dict__["compute_spot_price_limit"] = compute_spot_price_limit
            __props__.__dict__["compute_spot_strategy"] = compute_spot_strategy
            __props__.__dict__["deploy_mode"] = deploy_mode
            __props__.__dict__["description"] = description
            __props__.__dict__["domain"] = domain
            __props__.__dict__["ecs_charge_type"] = ecs_charge_type
            __props__.__dict__["ehpc_version"] = ehpc_version
            __props__.__dict__["ha_enable"] = ha_enable
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["image_owner_alias"] = image_owner_alias
            __props__.__dict__["input_file_url"] = input_file_url
            __props__.__dict__["is_compute_ess"] = is_compute_ess
            __props__.__dict__["job_queue"] = job_queue
            __props__.__dict__["key_pair_name"] = key_pair_name
            if login_count is None and not opts.urn:
                raise TypeError("Missing required property 'login_count'")
            __props__.__dict__["login_count"] = login_count
            if login_instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'login_instance_type'")
            __props__.__dict__["login_instance_type"] = login_instance_type
            __props__.__dict__["manager_count"] = manager_count
            if manager_instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'manager_instance_type'")
            __props__.__dict__["manager_instance_type"] = manager_instance_type
            if os_tag is None and not opts.urn:
                raise TypeError("Missing required property 'os_tag'")
            __props__.__dict__["os_tag"] = os_tag
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["plugin"] = plugin
            __props__.__dict__["post_install_scripts"] = post_install_scripts
            __props__.__dict__["ram_node_types"] = ram_node_types
            __props__.__dict__["ram_role_name"] = ram_role_name
            __props__.__dict__["release_instance"] = release_instance
            __props__.__dict__["remote_directory"] = remote_directory
            __props__.__dict__["remote_vis_enable"] = remote_vis_enable
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["scc_cluster_id"] = scc_cluster_id
            __props__.__dict__["scheduler_type"] = scheduler_type
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["security_group_name"] = security_group_name
            __props__.__dict__["system_disk_level"] = system_disk_level
            __props__.__dict__["system_disk_size"] = system_disk_size
            __props__.__dict__["system_disk_type"] = system_disk_type
            __props__.__dict__["volume_id"] = volume_id
            __props__.__dict__["volume_mount_option"] = volume_mount_option
            __props__.__dict__["volume_mountpoint"] = volume_mountpoint
            __props__.__dict__["volume_protocol"] = volume_protocol
            __props__.__dict__["volume_type"] = volume_type
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["without_agent"] = without_agent
            __props__.__dict__["without_elastic_ip"] = without_elastic_ip
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Cluster, __self__).__init__(
            'alicloud:ehpc/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_type: Optional[pulumi.Input[_builtins.str]] = None,
            additional_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterAdditionalVolumeArgs', 'ClusterAdditionalVolumeArgsDict']]]]] = None,
            applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterApplicationArgs', 'ClusterApplicationArgsDict']]]]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
            client_version: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
            compute_count: Optional[pulumi.Input[_builtins.int]] = None,
            compute_enable_ht: Optional[pulumi.Input[_builtins.bool]] = None,
            compute_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            compute_spot_price_limit: Optional[pulumi.Input[_builtins.str]] = None,
            compute_spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            deploy_mode: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            ecs_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            ehpc_version: Optional[pulumi.Input[_builtins.str]] = None,
            ha_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            image_owner_alias: Optional[pulumi.Input[_builtins.str]] = None,
            input_file_url: Optional[pulumi.Input[_builtins.str]] = None,
            is_compute_ess: Optional[pulumi.Input[_builtins.bool]] = None,
            job_queue: Optional[pulumi.Input[_builtins.str]] = None,
            key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
            login_count: Optional[pulumi.Input[_builtins.int]] = None,
            login_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            manager_count: Optional[pulumi.Input[_builtins.int]] = None,
            manager_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            os_tag: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            plugin: Optional[pulumi.Input[_builtins.str]] = None,
            post_install_scripts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPostInstallScriptArgs', 'ClusterPostInstallScriptArgsDict']]]]] = None,
            ram_node_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            release_instance: Optional[pulumi.Input[_builtins.bool]] = None,
            remote_directory: Optional[pulumi.Input[_builtins.str]] = None,
            remote_vis_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            scc_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            scheduler_type: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_level: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
            system_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
            volume_id: Optional[pulumi.Input[_builtins.str]] = None,
            volume_mount_option: Optional[pulumi.Input[_builtins.str]] = None,
            volume_mountpoint: Optional[pulumi.Input[_builtins.str]] = None,
            volume_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            volume_type: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            without_agent: Optional[pulumi.Input[_builtins.bool]] = None,
            without_elastic_ip: Optional[pulumi.Input[_builtins.bool]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_type: The type of the domain account service. Valid values: `nis`, `ldap`. Default value: `nis`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterAdditionalVolumeArgs', 'ClusterAdditionalVolumeArgsDict']]]] additional_volumes: The additional volumes. See `additional_volumes` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterApplicationArgs', 'ClusterApplicationArgsDict']]]] applications: The application. See `application` below.
        :param pulumi.Input[_builtins.bool] auto_renew: Specifies whether to enable auto-renewal for the subscription. Default value: `false`.
        :param pulumi.Input[_builtins.int] auto_renew_period: The auto-renewal period of the subscription compute nodes. The parameter takes effect when AutoRenew is set to true.
        :param pulumi.Input[_builtins.str] client_version: The version of the E-HPC client. By default, the parameter is set to the latest version number.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the cluster. The name must be `2` to `64` characters in length.
        :param pulumi.Input[_builtins.str] cluster_version: The version of the cluster. Default value: `1.0`.
        :param pulumi.Input[_builtins.int] compute_count: The number of the compute nodes. Valid values: `1` to `99`.
        :param pulumi.Input[_builtins.bool] compute_enable_ht: Specifies whether the compute nodes support hyper-threading. Default value: `true`.
        :param pulumi.Input[_builtins.str] compute_instance_type: The instance type of the compute nodes.
        :param pulumi.Input[_builtins.str] compute_spot_price_limit: The maximum hourly price of the compute nodes. A maximum of three decimal places can be used in the value of the parameter. The parameter is valid only when the ComputeSpotStrategy parameter is set to SpotWithPriceLimit.
        :param pulumi.Input[_builtins.str] compute_spot_strategy: The bidding method of the compute nodes. Default value: `NoSpot`. Valid values:
               - `NoSpot`: The compute nodes are pay-as-you-go instances.
               - `SpotWithPriceLimit`: The compute nodes are preemptible instances that have a user-defined maximum hourly price.
               - `SpotAsPriceGo`: The compute nodes are preemptible instances for which the market price at the time of purchase is used as the bid price.
        :param pulumi.Input[_builtins.str] deploy_mode: The mode in which the cluster is deployed. Valid values: `Standard`, `Simple`, `Tiny`. Default value: Standard.
               - `Standard`: An account node, a scheduling node, a logon node, and multiple compute nodes are separately deployed.
               - `Simple`: A management node, a logon node, and multiple compute nodes are deployed. The management node consists of an account node and a scheduling node. The logon node and compute nodes are separately deployed.
               - `Tiny`: A management node and multiple compute nodes are deployed. The management node consists of an account node, a scheduling node, and a logon node. The compute nodes are separately deployed.
        :param pulumi.Input[_builtins.str] description: The description of the cluster. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] domain: The domain name of the on-premises cluster. This parameter takes effect only when the AccoutType parameter is set to Idap.
        :param pulumi.Input[_builtins.str] ecs_charge_type: The billing method of the nodes.
        :param pulumi.Input[_builtins.str] ehpc_version: The version of E-HPC. By default, the parameter is set to the latest version number.
        :param pulumi.Input[_builtins.bool] ha_enable: Specifies whether to enable the high availability feature. Default value: `false`.  **Note:** If high availability is enabled, a primary management node and a secondary management node are used.
        :param pulumi.Input[_builtins.str] image_id: The ID of the image.
        :param pulumi.Input[_builtins.str] image_owner_alias: The type of the image. Valid values: `others`, `self`, `system`, `marketplace`. Default value: `system`.
        :param pulumi.Input[_builtins.str] input_file_url: The URL of the job files that are uploaded to an Object Storage Service (OSS) bucket.
        :param pulumi.Input[_builtins.bool] is_compute_ess: Specifies whether to enable auto scaling. Default value: `false`.
        :param pulumi.Input[_builtins.str] job_queue: The queue to which the compute nodes are added.
        :param pulumi.Input[_builtins.str] key_pair_name: The name of the AccessKey pair.
        :param pulumi.Input[_builtins.int] login_count: The number of the logon nodes. Valid values: `1`.
        :param pulumi.Input[_builtins.str] login_instance_type: The instance type of the logon nodes.
        :param pulumi.Input[_builtins.int] manager_count: The number of the management nodes. Valid values: 1 and 2.
        :param pulumi.Input[_builtins.str] manager_instance_type: The instance type of the management nodes.
        :param pulumi.Input[_builtins.str] os_tag: The image tag of the operating system.
        :param pulumi.Input[_builtins.str] password: The root password of the logon node. The password must be 8 to 30 characters in length and contain at least three of the following items: uppercase letters, lowercase letters, digits, and special characters. The password can contain the following special characters: `( ) ~ ! @ # $ % ^ & * - + = { } [ ] : ; ‘ < > , . ? /`. You must specify either `password` or `key_pair_name`. If both are specified, the Password parameter prevails.
        :param pulumi.Input[_builtins.int] period: The duration of the subscription. The unit of the duration is specified by the `period_unit` parameter. Default value: `1`.
               * If you set PriceUnit to Year, the valid values of the Period parameter are 1, 2, and 3.
               * If you set PriceUnit to Month, the valid values of the Period parameter are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
               * If you set PriceUnit to Hour, the valid value of the Period parameter is 1.
        :param pulumi.Input[_builtins.str] period_unit: The unit of the subscription duration. Valid values: `Year`, `Month`, `Hour`. Default value: `Month`.
        :param pulumi.Input[_builtins.str] plugin: The mode configurations of the plug-in. This parameter takes effect only when the SchedulerType parameter is set to custom. The value must be a JSON string. The parameter contains the following parameters: pluginMod, pluginLocalPath, and pluginOssPath.
               - pluginMod: the mode of the plug-in. The following modes are supported:
               - oss: The plug-in is downloaded and decompressed from OSS to a local path. The local path is specified by the pluginLocalPath parameter.
               - image: By default, the plug-in is stored in a pre-defined local path. The local path is specified by the pluginLocalPath parameter.
               - pluginLocalPath: the local path where the plug-in is stored. We recommend that you select a shared directory in oss mode and a non-shared directory in image mode.
               - pluginOssPath: the remote path where the plug-in is stored in OSS. This parameter takes effect only when the pluginMod parameter is set to oss.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterPostInstallScriptArgs', 'ClusterPostInstallScriptArgsDict']]]] post_install_scripts: The post install script. See `post_install_script` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ram_node_types: The node of the RAM role.
        :param pulumi.Input[_builtins.str] ram_role_name: The name of the Resource Access Management (RAM) role.
        :param pulumi.Input[_builtins.bool] release_instance: The release instance. Valid values: `true`.
        :param pulumi.Input[_builtins.str] remote_directory: The remote directory to which the file system is mounted.
        :param pulumi.Input[_builtins.bool] remote_vis_enable: Specifies whether to enable Virtual Network Computing (VNC). Default value: `false`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] scc_cluster_id: The ID of the Super Computing Cluster (SCC) instance. If you specify the parameter, the SCC instance is moved to a new SCC cluster.
        :param pulumi.Input[_builtins.str] scheduler_type: The type of the scheduler. Valid values: `pbs`, `slurm`, `opengridscheduler` and `deadline`. Default value: `pbs`.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the cluster belongs.
        :param pulumi.Input[_builtins.str] security_group_name: If you do not use an existing security group, set the parameter to the name of a new security group. A default policy is applied to the new security group.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.str] system_disk_level: The performance level of the ESSD that is used as the system disk. Default value: `PL1` For more information, see [ESSDs](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/essds). Valid values:
               * `PL0`: A single ESSD can deliver up to 10,000 random read/write IOPS.
               * `PL1`: A single ESSD can deliver up to 50,000 random read/write IOPS.
               * `PL2`: A single ESSD can deliver up to 100,000 random read/write IOPS.
               * `PL3`: A single ESSD can deliver up to 1,000,000 random read/write IOPS.
        :param pulumi.Input[_builtins.int] system_disk_size: The size of the system disk. Unit: `GB`. Valid values: `40` to `500`. Default value: `40`.
        :param pulumi.Input[_builtins.str] system_disk_type: The type of the system disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd` or `cloud`. Default value: `cloud_ssd`.
        :param pulumi.Input[_builtins.str] volume_id: The ID of the file system. If you leave the parameter empty, a Performance NAS file system is created by default.
        :param pulumi.Input[_builtins.str] volume_mount_option: The mount options of the file system.
        :param pulumi.Input[_builtins.str] volume_mountpoint: The mount target of the file system. Take note of the following information:
               - If you do not specify the VolumeId parameter, you can leave the VolumeMountpoint parameter empty. A mount target is created by default.
               - If you specify the VolumeId parameter, the VolumeMountpoint parameter is required.
        :param pulumi.Input[_builtins.str] volume_protocol: The type of the protocol that is used by the file system. Valid values: `NFS`, `SMB`. Default value: `NFS`.
        :param pulumi.Input[_builtins.str] volume_type: The type of the shared storage. Only Apsara File Storage NAS file systems are supported.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC) to which the cluster belongs.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch. E-HPC supports only VPC networks.
        :param pulumi.Input[_builtins.bool] without_agent: Specifies whether not to install the agent. Default value: `false`.
        :param pulumi.Input[_builtins.bool] without_elastic_ip: Specifies whether the logon node uses an elastic IP address (EIP). Default value: `false`.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["account_type"] = account_type
        __props__.__dict__["additional_volumes"] = additional_volumes
        __props__.__dict__["applications"] = applications
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["client_version"] = client_version
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["cluster_version"] = cluster_version
        __props__.__dict__["compute_count"] = compute_count
        __props__.__dict__["compute_enable_ht"] = compute_enable_ht
        __props__.__dict__["compute_instance_type"] = compute_instance_type
        __props__.__dict__["compute_spot_price_limit"] = compute_spot_price_limit
        __props__.__dict__["compute_spot_strategy"] = compute_spot_strategy
        __props__.__dict__["deploy_mode"] = deploy_mode
        __props__.__dict__["description"] = description
        __props__.__dict__["domain"] = domain
        __props__.__dict__["ecs_charge_type"] = ecs_charge_type
        __props__.__dict__["ehpc_version"] = ehpc_version
        __props__.__dict__["ha_enable"] = ha_enable
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["image_owner_alias"] = image_owner_alias
        __props__.__dict__["input_file_url"] = input_file_url
        __props__.__dict__["is_compute_ess"] = is_compute_ess
        __props__.__dict__["job_queue"] = job_queue
        __props__.__dict__["key_pair_name"] = key_pair_name
        __props__.__dict__["login_count"] = login_count
        __props__.__dict__["login_instance_type"] = login_instance_type
        __props__.__dict__["manager_count"] = manager_count
        __props__.__dict__["manager_instance_type"] = manager_instance_type
        __props__.__dict__["os_tag"] = os_tag
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["plugin"] = plugin
        __props__.__dict__["post_install_scripts"] = post_install_scripts
        __props__.__dict__["ram_node_types"] = ram_node_types
        __props__.__dict__["ram_role_name"] = ram_role_name
        __props__.__dict__["release_instance"] = release_instance
        __props__.__dict__["remote_directory"] = remote_directory
        __props__.__dict__["remote_vis_enable"] = remote_vis_enable
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["scc_cluster_id"] = scc_cluster_id
        __props__.__dict__["scheduler_type"] = scheduler_type
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["security_group_name"] = security_group_name
        __props__.__dict__["status"] = status
        __props__.__dict__["system_disk_level"] = system_disk_level
        __props__.__dict__["system_disk_size"] = system_disk_size
        __props__.__dict__["system_disk_type"] = system_disk_type
        __props__.__dict__["volume_id"] = volume_id
        __props__.__dict__["volume_mount_option"] = volume_mount_option
        __props__.__dict__["volume_mountpoint"] = volume_mountpoint
        __props__.__dict__["volume_protocol"] = volume_protocol
        __props__.__dict__["volume_type"] = volume_type
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["without_agent"] = without_agent
        __props__.__dict__["without_elastic_ip"] = without_elastic_ip
        __props__.__dict__["zone_id"] = zone_id
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the domain account service. Valid values: `nis`, `ldap`. Default value: `nis`
        """
        return pulumi.get(self, "account_type")

    @_builtins.property
    @pulumi.getter(name="additionalVolumes")
    def additional_volumes(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterAdditionalVolume']]]:
        """
        The additional volumes. See `additional_volumes` below.
        """
        return pulumi.get(self, "additional_volumes")

    @_builtins.property
    @pulumi.getter
    def applications(self) -> pulumi.Output[Sequence['outputs.ClusterApplication']]:
        """
        The application. See `application` below.
        """
        return pulumi.get(self, "applications")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable auto-renewal for the subscription. Default value: `false`.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The auto-renewal period of the subscription compute nodes. The parameter takes effect when AutoRenew is set to true.
        """
        return pulumi.get(self, "auto_renew_period")

    @_builtins.property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the E-HPC client. By default, the parameter is set to the latest version number.
        """
        return pulumi.get(self, "client_version")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the cluster. The name must be `2` to `64` characters in length.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the cluster. Default value: `1.0`.
        """
        return pulumi.get(self, "cluster_version")

    @_builtins.property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of the compute nodes. Valid values: `1` to `99`.
        """
        return pulumi.get(self, "compute_count")

    @_builtins.property
    @pulumi.getter(name="computeEnableHt")
    def compute_enable_ht(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the compute nodes support hyper-threading. Default value: `true`.
        """
        return pulumi.get(self, "compute_enable_ht")

    @_builtins.property
    @pulumi.getter(name="computeInstanceType")
    def compute_instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The instance type of the compute nodes.
        """
        return pulumi.get(self, "compute_instance_type")

    @_builtins.property
    @pulumi.getter(name="computeSpotPriceLimit")
    def compute_spot_price_limit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The maximum hourly price of the compute nodes. A maximum of three decimal places can be used in the value of the parameter. The parameter is valid only when the ComputeSpotStrategy parameter is set to SpotWithPriceLimit.
        """
        return pulumi.get(self, "compute_spot_price_limit")

    @_builtins.property
    @pulumi.getter(name="computeSpotStrategy")
    def compute_spot_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The bidding method of the compute nodes. Default value: `NoSpot`. Valid values:
        - `NoSpot`: The compute nodes are pay-as-you-go instances.
        - `SpotWithPriceLimit`: The compute nodes are preemptible instances that have a user-defined maximum hourly price.
        - `SpotAsPriceGo`: The compute nodes are preemptible instances for which the market price at the time of purchase is used as the bid price.
        """
        return pulumi.get(self, "compute_spot_strategy")

    @_builtins.property
    @pulumi.getter(name="deployMode")
    def deploy_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The mode in which the cluster is deployed. Valid values: `Standard`, `Simple`, `Tiny`. Default value: Standard.
        - `Standard`: An account node, a scheduling node, a logon node, and multiple compute nodes are separately deployed.
        - `Simple`: A management node, a logon node, and multiple compute nodes are deployed. The management node consists of an account node and a scheduling node. The logon node and compute nodes are separately deployed.
        - `Tiny`: A management node and multiple compute nodes are deployed. The management node consists of an account node, a scheduling node, and a logon node. The compute nodes are separately deployed.
        """
        return pulumi.get(self, "deploy_mode")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the cluster. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The domain name of the on-premises cluster. This parameter takes effect only when the AccoutType parameter is set to Idap.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="ecsChargeType")
    def ecs_charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        The billing method of the nodes.
        """
        return pulumi.get(self, "ecs_charge_type")

    @_builtins.property
    @pulumi.getter(name="ehpcVersion")
    def ehpc_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of E-HPC. By default, the parameter is set to the latest version number.
        """
        return pulumi.get(self, "ehpc_version")

    @_builtins.property
    @pulumi.getter(name="haEnable")
    def ha_enable(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable the high availability feature. Default value: `false`.  **Note:** If high availability is enabled, a primary management node and a secondary management node are used.
        """
        return pulumi.get(self, "ha_enable")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the image.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="imageOwnerAlias")
    def image_owner_alias(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the image. Valid values: `others`, `self`, `system`, `marketplace`. Default value: `system`.
        """
        return pulumi.get(self, "image_owner_alias")

    @_builtins.property
    @pulumi.getter(name="inputFileUrl")
    def input_file_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URL of the job files that are uploaded to an Object Storage Service (OSS) bucket.
        """
        return pulumi.get(self, "input_file_url")

    @_builtins.property
    @pulumi.getter(name="isComputeEss")
    def is_compute_ess(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable auto scaling. Default value: `false`.
        """
        return pulumi.get(self, "is_compute_ess")

    @_builtins.property
    @pulumi.getter(name="jobQueue")
    def job_queue(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The queue to which the compute nodes are added.
        """
        return pulumi.get(self, "job_queue")

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the AccessKey pair.
        """
        return pulumi.get(self, "key_pair_name")

    @_builtins.property
    @pulumi.getter(name="loginCount")
    def login_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of the logon nodes. Valid values: `1`.
        """
        return pulumi.get(self, "login_count")

    @_builtins.property
    @pulumi.getter(name="loginInstanceType")
    def login_instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The instance type of the logon nodes.
        """
        return pulumi.get(self, "login_instance_type")

    @_builtins.property
    @pulumi.getter(name="managerCount")
    def manager_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of the management nodes. Valid values: 1 and 2.
        """
        return pulumi.get(self, "manager_count")

    @_builtins.property
    @pulumi.getter(name="managerInstanceType")
    def manager_instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The instance type of the management nodes.
        """
        return pulumi.get(self, "manager_instance_type")

    @_builtins.property
    @pulumi.getter(name="osTag")
    def os_tag(self) -> pulumi.Output[_builtins.str]:
        """
        The image tag of the operating system.
        """
        return pulumi.get(self, "os_tag")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The root password of the logon node. The password must be 8 to 30 characters in length and contain at least three of the following items: uppercase letters, lowercase letters, digits, and special characters. The password can contain the following special characters: `( ) ~ ! @ # $ % ^ & * - + = { } [ ] : ; ‘ < > , . ? /`. You must specify either `password` or `key_pair_name`. If both are specified, the Password parameter prevails.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The duration of the subscription. The unit of the duration is specified by the `period_unit` parameter. Default value: `1`.
        * If you set PriceUnit to Year, the valid values of the Period parameter are 1, 2, and 3.
        * If you set PriceUnit to Month, the valid values of the Period parameter are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
        * If you set PriceUnit to Hour, the valid value of the Period parameter is 1.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unit of the subscription duration. Valid values: `Year`, `Month`, `Hour`. Default value: `Month`.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter
    def plugin(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The mode configurations of the plug-in. This parameter takes effect only when the SchedulerType parameter is set to custom. The value must be a JSON string. The parameter contains the following parameters: pluginMod, pluginLocalPath, and pluginOssPath.
        - pluginMod: the mode of the plug-in. The following modes are supported:
        - oss: The plug-in is downloaded and decompressed from OSS to a local path. The local path is specified by the pluginLocalPath parameter.
        - image: By default, the plug-in is stored in a pre-defined local path. The local path is specified by the pluginLocalPath parameter.
        - pluginLocalPath: the local path where the plug-in is stored. We recommend that you select a shared directory in oss mode and a non-shared directory in image mode.
        - pluginOssPath: the remote path where the plug-in is stored in OSS. This parameter takes effect only when the pluginMod parameter is set to oss.
        """
        return pulumi.get(self, "plugin")

    @_builtins.property
    @pulumi.getter(name="postInstallScripts")
    def post_install_scripts(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterPostInstallScript']]]:
        """
        The post install script. See `post_install_script` below.
        """
        return pulumi.get(self, "post_install_scripts")

    @_builtins.property
    @pulumi.getter(name="ramNodeTypes")
    def ram_node_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The node of the RAM role.
        """
        return pulumi.get(self, "ram_node_types")

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the Resource Access Management (RAM) role.
        """
        return pulumi.get(self, "ram_role_name")

    @_builtins.property
    @pulumi.getter(name="releaseInstance")
    def release_instance(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The release instance. Valid values: `true`.
        """
        return pulumi.get(self, "release_instance")

    @_builtins.property
    @pulumi.getter(name="remoteDirectory")
    def remote_directory(self) -> pulumi.Output[_builtins.str]:
        """
        The remote directory to which the file system is mounted.
        """
        return pulumi.get(self, "remote_directory")

    @_builtins.property
    @pulumi.getter(name="remoteVisEnable")
    def remote_vis_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable Virtual Network Computing (VNC). Default value: `false`.
        """
        return pulumi.get(self, "remote_vis_enable")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="sccClusterId")
    def scc_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Super Computing Cluster (SCC) instance. If you specify the parameter, the SCC instance is moved to a new SCC cluster.
        """
        return pulumi.get(self, "scc_cluster_id")

    @_builtins.property
    @pulumi.getter(name="schedulerType")
    def scheduler_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the scheduler. Valid values: `pbs`, `slurm`, `opengridscheduler` and `deadline`. Default value: `pbs`.
        """
        return pulumi.get(self, "scheduler_type")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the security group to which the cluster belongs.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupName")
    def security_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If you do not use an existing security group, set the parameter to the name of a new security group. A default policy is applied to the new security group.
        """
        return pulumi.get(self, "security_group_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="systemDiskLevel")
    def system_disk_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The performance level of the ESSD that is used as the system disk. Default value: `PL1` For more information, see [ESSDs](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/essds). Valid values:
        * `PL0`: A single ESSD can deliver up to 10,000 random read/write IOPS.
        * `PL1`: A single ESSD can deliver up to 50,000 random read/write IOPS.
        * `PL2`: A single ESSD can deliver up to 100,000 random read/write IOPS.
        * `PL3`: A single ESSD can deliver up to 1,000,000 random read/write IOPS.
        """
        return pulumi.get(self, "system_disk_level")

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The size of the system disk. Unit: `GB`. Valid values: `40` to `500`. Default value: `40`.
        """
        return pulumi.get(self, "system_disk_size")

    @_builtins.property
    @pulumi.getter(name="systemDiskType")
    def system_disk_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the system disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd` or `cloud`. Default value: `cloud_ssd`.
        """
        return pulumi.get(self, "system_disk_type")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the file system. If you leave the parameter empty, a Performance NAS file system is created by default.
        """
        return pulumi.get(self, "volume_id")

    @_builtins.property
    @pulumi.getter(name="volumeMountOption")
    def volume_mount_option(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The mount options of the file system.
        """
        return pulumi.get(self, "volume_mount_option")

    @_builtins.property
    @pulumi.getter(name="volumeMountpoint")
    def volume_mountpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The mount target of the file system. Take note of the following information:
        - If you do not specify the VolumeId parameter, you can leave the VolumeMountpoint parameter empty. A mount target is created by default.
        - If you specify the VolumeId parameter, the VolumeMountpoint parameter is required.
        """
        return pulumi.get(self, "volume_mountpoint")

    @_builtins.property
    @pulumi.getter(name="volumeProtocol")
    def volume_protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the protocol that is used by the file system. Valid values: `NFS`, `SMB`. Default value: `NFS`.
        """
        return pulumi.get(self, "volume_protocol")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the shared storage. Only Apsara File Storage NAS file systems are supported.
        """
        return pulumi.get(self, "volume_type")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the virtual private cloud (VPC) to which the cluster belongs.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the vSwitch. E-HPC supports only VPC networks.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="withoutAgent")
    def without_agent(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether not to install the agent. Default value: `false`.
        """
        return pulumi.get(self, "without_agent")

    @_builtins.property
    @pulumi.getter(name="withoutElasticIp")
    def without_elastic_ip(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the logon node uses an elastic IP address (EIP). Default value: `false`.
        """
        return pulumi.get(self, "without_elastic_ip")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "zone_id")

