# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EdgeContainerAppArgs', 'EdgeContainerApp']

@pulumi.input_type
class EdgeContainerAppArgs:
    def __init__(__self__, *,
                 edge_container_app_name: pulumi.Input[_builtins.str],
                 service_port: pulumi.Input[_builtins.int],
                 target_port: pulumi.Input[_builtins.int],
                 health_check_fail_times: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_host: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_http_code: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_method: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_succ_times: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_type: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 remarks: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EdgeContainerApp resource.
        :param pulumi.Input[_builtins.str] edge_container_app_name: The application name must start with a lowercase letter. Lowercase letters, numbers, and bars are supported. The length is limited to 6 to 128 characters.
        :param pulumi.Input[_builtins.int] service_port: The name of the application. The name must start with a lowercase letter and can contain lowercase letters, digits, and hyphens (-). The name must be 6 to 128 characters in length.
        :param pulumi.Input[_builtins.int] target_port: The server port. Valid values: 1 to 65535.
        :param pulumi.Input[_builtins.int] health_check_fail_times: The number of consecutive successful health checks required for an application to be considered as healthy. Valid values: 1 to 10. Default value: 2.
        :param pulumi.Input[_builtins.str] health_check_host: The health check type. By default, this parameter is left empty.
               
               Valid values:
        :param pulumi.Input[_builtins.str] health_check_http_code: The domain name that is used for health checks. This parameter is empty by default.
        :param pulumi.Input[_builtins.int] health_check_interval: The timeout period of a health check response. If a backend ECS instance does not respond within the specified timeout period, the ECS instance fails the health check. Unit: seconds.
               Valid values: `1` to `100`.
               Default value: `3`.
        :param pulumi.Input[_builtins.str] health_check_method: The HTTP status code returned for a successful health check. Valid values:
               
               - **http\\_2xx** (default)
               - **http\\_3xx**
        :param pulumi.Input[_builtins.int] health_check_port: The URI used for health checks. The URI must be `1` to `80` characters in length. Default value: "/".
        :param pulumi.Input[_builtins.int] health_check_succ_times: The interval between two consecutive health checks. Unit: seconds. Valid values: `1` to `50`. Default value: `5`.
        :param pulumi.Input[_builtins.int] health_check_timeout: The port used for health checks. Valid values: 1 to 65535. Default value: 80.
        :param pulumi.Input[_builtins.str] health_check_type: The remarks. This parameter is empty by default.
        :param pulumi.Input[_builtins.str] health_check_uri: The HTTP request method for health checks. Valid values:
               
               - `HEAD` (default): requests the headers of the resource.
               - `GET`: requests the specified resource and returns both the headers and entity body.
        :param pulumi.Input[_builtins.str] remarks: The backend port, which is also the service port of the application. Valid values: 1 to 65535.
        """
        pulumi.set(__self__, "edge_container_app_name", edge_container_app_name)
        pulumi.set(__self__, "service_port", service_port)
        pulumi.set(__self__, "target_port", target_port)
        if health_check_fail_times is not None:
            pulumi.set(__self__, "health_check_fail_times", health_check_fail_times)
        if health_check_host is not None:
            pulumi.set(__self__, "health_check_host", health_check_host)
        if health_check_http_code is not None:
            pulumi.set(__self__, "health_check_http_code", health_check_http_code)
        if health_check_interval is not None:
            pulumi.set(__self__, "health_check_interval", health_check_interval)
        if health_check_method is not None:
            pulumi.set(__self__, "health_check_method", health_check_method)
        if health_check_port is not None:
            pulumi.set(__self__, "health_check_port", health_check_port)
        if health_check_succ_times is not None:
            pulumi.set(__self__, "health_check_succ_times", health_check_succ_times)
        if health_check_timeout is not None:
            pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if health_check_uri is not None:
            pulumi.set(__self__, "health_check_uri", health_check_uri)
        if remarks is not None:
            pulumi.set(__self__, "remarks", remarks)

    @_builtins.property
    @pulumi.getter(name="edgeContainerAppName")
    def edge_container_app_name(self) -> pulumi.Input[_builtins.str]:
        """
        The application name must start with a lowercase letter. Lowercase letters, numbers, and bars are supported. The length is limited to 6 to 128 characters.
        """
        return pulumi.get(self, "edge_container_app_name")

    @edge_container_app_name.setter
    def edge_container_app_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "edge_container_app_name", value)

    @_builtins.property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> pulumi.Input[_builtins.int]:
        """
        The name of the application. The name must start with a lowercase letter and can contain lowercase letters, digits, and hyphens (-). The name must be 6 to 128 characters in length.
        """
        return pulumi.get(self, "service_port")

    @service_port.setter
    def service_port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "service_port", value)

    @_builtins.property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> pulumi.Input[_builtins.int]:
        """
        The server port. Valid values: 1 to 65535.
        """
        return pulumi.get(self, "target_port")

    @target_port.setter
    def target_port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "target_port", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckFailTimes")
    def health_check_fail_times(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive successful health checks required for an application to be considered as healthy. Valid values: 1 to 10. Default value: 2.
        """
        return pulumi.get(self, "health_check_fail_times")

    @health_check_fail_times.setter
    def health_check_fail_times(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_fail_times", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckHost")
    def health_check_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The health check type. By default, this parameter is left empty.

        Valid values:
        """
        return pulumi.get(self, "health_check_host")

    @health_check_host.setter
    def health_check_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_host", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckHttpCode")
    def health_check_http_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name that is used for health checks. This parameter is empty by default.
        """
        return pulumi.get(self, "health_check_http_code")

    @health_check_http_code.setter
    def health_check_http_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_http_code", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout period of a health check response. If a backend ECS instance does not respond within the specified timeout period, the ECS instance fails the health check. Unit: seconds.
        Valid values: `1` to `100`.
        Default value: `3`.
        """
        return pulumi.get(self, "health_check_interval")

    @health_check_interval.setter
    def health_check_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_interval", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckMethod")
    def health_check_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP status code returned for a successful health check. Valid values:

        - **http\\_2xx** (default)
        - **http\\_3xx**
        """
        return pulumi.get(self, "health_check_method")

    @health_check_method.setter
    def health_check_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_method", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The URI used for health checks. The URI must be `1` to `80` characters in length. Default value: "/".
        """
        return pulumi.get(self, "health_check_port")

    @health_check_port.setter
    def health_check_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_port", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckSuccTimes")
    def health_check_succ_times(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The interval between two consecutive health checks. Unit: seconds. Valid values: `1` to `50`. Default value: `5`.
        """
        return pulumi.get(self, "health_check_succ_times")

    @health_check_succ_times.setter
    def health_check_succ_times(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_succ_times", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port used for health checks. Valid values: 1 to 65535. Default value: 80.
        """
        return pulumi.get(self, "health_check_timeout")

    @health_check_timeout.setter
    def health_check_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_timeout", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The remarks. This parameter is empty by default.
        """
        return pulumi.get(self, "health_check_type")

    @health_check_type.setter
    def health_check_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_type", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckUri")
    def health_check_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP request method for health checks. Valid values:

        - `HEAD` (default): requests the headers of the resource.
        - `GET`: requests the specified resource and returns both the headers and entity body.
        """
        return pulumi.get(self, "health_check_uri")

    @health_check_uri.setter
    def health_check_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_uri", value)

    @_builtins.property
    @pulumi.getter
    def remarks(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backend port, which is also the service port of the application. Valid values: 1 to 65535.
        """
        return pulumi.get(self, "remarks")

    @remarks.setter
    def remarks(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remarks", value)


@pulumi.input_type
class _EdgeContainerAppState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_container_app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_fail_times: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_host: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_http_code: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_method: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_succ_times: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_type: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 remarks: Optional[pulumi.Input[_builtins.str]] = None,
                 service_port: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 target_port: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering EdgeContainerApp resources.
        :param pulumi.Input[_builtins.str] create_time: The time when the application was created.
        :param pulumi.Input[_builtins.str] edge_container_app_name: The application name must start with a lowercase letter. Lowercase letters, numbers, and bars are supported. The length is limited to 6 to 128 characters.
        :param pulumi.Input[_builtins.int] health_check_fail_times: The number of consecutive successful health checks required for an application to be considered as healthy. Valid values: 1 to 10. Default value: 2.
        :param pulumi.Input[_builtins.str] health_check_host: The health check type. By default, this parameter is left empty.
               
               Valid values:
        :param pulumi.Input[_builtins.str] health_check_http_code: The domain name that is used for health checks. This parameter is empty by default.
        :param pulumi.Input[_builtins.int] health_check_interval: The timeout period of a health check response. If a backend ECS instance does not respond within the specified timeout period, the ECS instance fails the health check. Unit: seconds.
               Valid values: `1` to `100`.
               Default value: `3`.
        :param pulumi.Input[_builtins.str] health_check_method: The HTTP status code returned for a successful health check. Valid values:
               
               - **http\\_2xx** (default)
               - **http\\_3xx**
        :param pulumi.Input[_builtins.int] health_check_port: The URI used for health checks. The URI must be `1` to `80` characters in length. Default value: "/".
        :param pulumi.Input[_builtins.int] health_check_succ_times: The interval between two consecutive health checks. Unit: seconds. Valid values: `1` to `50`. Default value: `5`.
        :param pulumi.Input[_builtins.int] health_check_timeout: The port used for health checks. Valid values: 1 to 65535. Default value: 80.
        :param pulumi.Input[_builtins.str] health_check_type: The remarks. This parameter is empty by default.
        :param pulumi.Input[_builtins.str] health_check_uri: The HTTP request method for health checks. Valid values:
               
               - `HEAD` (default): requests the headers of the resource.
               - `GET`: requests the specified resource and returns both the headers and entity body.
        :param pulumi.Input[_builtins.str] remarks: The backend port, which is also the service port of the application. Valid values: 1 to 65535.
        :param pulumi.Input[_builtins.int] service_port: The name of the application. The name must start with a lowercase letter and can contain lowercase letters, digits, and hyphens (-). The name must be 6 to 128 characters in length.
        :param pulumi.Input[_builtins.str] status: The status of the application.
        :param pulumi.Input[_builtins.int] target_port: The server port. Valid values: 1 to 65535.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if edge_container_app_name is not None:
            pulumi.set(__self__, "edge_container_app_name", edge_container_app_name)
        if health_check_fail_times is not None:
            pulumi.set(__self__, "health_check_fail_times", health_check_fail_times)
        if health_check_host is not None:
            pulumi.set(__self__, "health_check_host", health_check_host)
        if health_check_http_code is not None:
            pulumi.set(__self__, "health_check_http_code", health_check_http_code)
        if health_check_interval is not None:
            pulumi.set(__self__, "health_check_interval", health_check_interval)
        if health_check_method is not None:
            pulumi.set(__self__, "health_check_method", health_check_method)
        if health_check_port is not None:
            pulumi.set(__self__, "health_check_port", health_check_port)
        if health_check_succ_times is not None:
            pulumi.set(__self__, "health_check_succ_times", health_check_succ_times)
        if health_check_timeout is not None:
            pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if health_check_uri is not None:
            pulumi.set(__self__, "health_check_uri", health_check_uri)
        if remarks is not None:
            pulumi.set(__self__, "remarks", remarks)
        if service_port is not None:
            pulumi.set(__self__, "service_port", service_port)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_port is not None:
            pulumi.set(__self__, "target_port", target_port)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the application was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="edgeContainerAppName")
    def edge_container_app_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application name must start with a lowercase letter. Lowercase letters, numbers, and bars are supported. The length is limited to 6 to 128 characters.
        """
        return pulumi.get(self, "edge_container_app_name")

    @edge_container_app_name.setter
    def edge_container_app_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_container_app_name", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckFailTimes")
    def health_check_fail_times(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive successful health checks required for an application to be considered as healthy. Valid values: 1 to 10. Default value: 2.
        """
        return pulumi.get(self, "health_check_fail_times")

    @health_check_fail_times.setter
    def health_check_fail_times(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_fail_times", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckHost")
    def health_check_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The health check type. By default, this parameter is left empty.

        Valid values:
        """
        return pulumi.get(self, "health_check_host")

    @health_check_host.setter
    def health_check_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_host", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckHttpCode")
    def health_check_http_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name that is used for health checks. This parameter is empty by default.
        """
        return pulumi.get(self, "health_check_http_code")

    @health_check_http_code.setter
    def health_check_http_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_http_code", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout period of a health check response. If a backend ECS instance does not respond within the specified timeout period, the ECS instance fails the health check. Unit: seconds.
        Valid values: `1` to `100`.
        Default value: `3`.
        """
        return pulumi.get(self, "health_check_interval")

    @health_check_interval.setter
    def health_check_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_interval", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckMethod")
    def health_check_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP status code returned for a successful health check. Valid values:

        - **http\\_2xx** (default)
        - **http\\_3xx**
        """
        return pulumi.get(self, "health_check_method")

    @health_check_method.setter
    def health_check_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_method", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The URI used for health checks. The URI must be `1` to `80` characters in length. Default value: "/".
        """
        return pulumi.get(self, "health_check_port")

    @health_check_port.setter
    def health_check_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_port", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckSuccTimes")
    def health_check_succ_times(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The interval between two consecutive health checks. Unit: seconds. Valid values: `1` to `50`. Default value: `5`.
        """
        return pulumi.get(self, "health_check_succ_times")

    @health_check_succ_times.setter
    def health_check_succ_times(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_succ_times", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port used for health checks. Valid values: 1 to 65535. Default value: 80.
        """
        return pulumi.get(self, "health_check_timeout")

    @health_check_timeout.setter
    def health_check_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_timeout", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The remarks. This parameter is empty by default.
        """
        return pulumi.get(self, "health_check_type")

    @health_check_type.setter
    def health_check_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_type", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckUri")
    def health_check_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP request method for health checks. Valid values:

        - `HEAD` (default): requests the headers of the resource.
        - `GET`: requests the specified resource and returns both the headers and entity body.
        """
        return pulumi.get(self, "health_check_uri")

    @health_check_uri.setter
    def health_check_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_uri", value)

    @_builtins.property
    @pulumi.getter
    def remarks(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backend port, which is also the service port of the application. Valid values: 1 to 65535.
        """
        return pulumi.get(self, "remarks")

    @remarks.setter
    def remarks(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remarks", value)

    @_builtins.property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The name of the application. The name must start with a lowercase letter and can contain lowercase letters, digits, and hyphens (-). The name must be 6 to 128 characters in length.
        """
        return pulumi.get(self, "service_port")

    @service_port.setter
    def service_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "service_port", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the application.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The server port. Valid values: 1 to 65535.
        """
        return pulumi.get(self, "target_port")

    @target_port.setter
    def target_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "target_port", value)


@pulumi.type_token("alicloud:esa/edgeContainerApp:EdgeContainerApp")
class EdgeContainerApp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 edge_container_app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_fail_times: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_host: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_http_code: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_method: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_succ_times: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_type: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 remarks: Optional[pulumi.Input[_builtins.str]] = None,
                 service_port: Optional[pulumi.Input[_builtins.int]] = None,
                 target_port: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a ESA Edge Container App resource.

        For information about ESA Edge Container App and how to use it, see [What is Edge Container App](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateEdgeContainerApp).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tfexample"
        default = alicloud.esa.EdgeContainerApp("default",
            target_port=3000,
            health_check_host="example.com",
            remarks=name,
            health_check_port=80,
            health_check_uri="/",
            health_check_timeout=3,
            health_check_method="HEAD",
            health_check_http_code="http_2xx",
            health_check_fail_times=5,
            service_port=80,
            health_check_interval=5,
            health_check_succ_times=2,
            edge_container_app_name=name,
            health_check_type="l7")
        ```

        ## Import

        ESA Edge Container App can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/edgeContainerApp:EdgeContainerApp example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] edge_container_app_name: The application name must start with a lowercase letter. Lowercase letters, numbers, and bars are supported. The length is limited to 6 to 128 characters.
        :param pulumi.Input[_builtins.int] health_check_fail_times: The number of consecutive successful health checks required for an application to be considered as healthy. Valid values: 1 to 10. Default value: 2.
        :param pulumi.Input[_builtins.str] health_check_host: The health check type. By default, this parameter is left empty.
               
               Valid values:
        :param pulumi.Input[_builtins.str] health_check_http_code: The domain name that is used for health checks. This parameter is empty by default.
        :param pulumi.Input[_builtins.int] health_check_interval: The timeout period of a health check response. If a backend ECS instance does not respond within the specified timeout period, the ECS instance fails the health check. Unit: seconds.
               Valid values: `1` to `100`.
               Default value: `3`.
        :param pulumi.Input[_builtins.str] health_check_method: The HTTP status code returned for a successful health check. Valid values:
               
               - **http\\_2xx** (default)
               - **http\\_3xx**
        :param pulumi.Input[_builtins.int] health_check_port: The URI used for health checks. The URI must be `1` to `80` characters in length. Default value: "/".
        :param pulumi.Input[_builtins.int] health_check_succ_times: The interval between two consecutive health checks. Unit: seconds. Valid values: `1` to `50`. Default value: `5`.
        :param pulumi.Input[_builtins.int] health_check_timeout: The port used for health checks. Valid values: 1 to 65535. Default value: 80.
        :param pulumi.Input[_builtins.str] health_check_type: The remarks. This parameter is empty by default.
        :param pulumi.Input[_builtins.str] health_check_uri: The HTTP request method for health checks. Valid values:
               
               - `HEAD` (default): requests the headers of the resource.
               - `GET`: requests the specified resource and returns both the headers and entity body.
        :param pulumi.Input[_builtins.str] remarks: The backend port, which is also the service port of the application. Valid values: 1 to 65535.
        :param pulumi.Input[_builtins.int] service_port: The name of the application. The name must start with a lowercase letter and can contain lowercase letters, digits, and hyphens (-). The name must be 6 to 128 characters in length.
        :param pulumi.Input[_builtins.int] target_port: The server port. Valid values: 1 to 65535.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeContainerAppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Edge Container App resource.

        For information about ESA Edge Container App and how to use it, see [What is Edge Container App](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateEdgeContainerApp).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tfexample"
        default = alicloud.esa.EdgeContainerApp("default",
            target_port=3000,
            health_check_host="example.com",
            remarks=name,
            health_check_port=80,
            health_check_uri="/",
            health_check_timeout=3,
            health_check_method="HEAD",
            health_check_http_code="http_2xx",
            health_check_fail_times=5,
            service_port=80,
            health_check_interval=5,
            health_check_succ_times=2,
            edge_container_app_name=name,
            health_check_type="l7")
        ```

        ## Import

        ESA Edge Container App can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/edgeContainerApp:EdgeContainerApp example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EdgeContainerAppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeContainerAppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 edge_container_app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_fail_times: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_host: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_http_code: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_method: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_succ_times: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_type: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 remarks: Optional[pulumi.Input[_builtins.str]] = None,
                 service_port: Optional[pulumi.Input[_builtins.int]] = None,
                 target_port: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeContainerAppArgs.__new__(EdgeContainerAppArgs)

            if edge_container_app_name is None and not opts.urn:
                raise TypeError("Missing required property 'edge_container_app_name'")
            __props__.__dict__["edge_container_app_name"] = edge_container_app_name
            __props__.__dict__["health_check_fail_times"] = health_check_fail_times
            __props__.__dict__["health_check_host"] = health_check_host
            __props__.__dict__["health_check_http_code"] = health_check_http_code
            __props__.__dict__["health_check_interval"] = health_check_interval
            __props__.__dict__["health_check_method"] = health_check_method
            __props__.__dict__["health_check_port"] = health_check_port
            __props__.__dict__["health_check_succ_times"] = health_check_succ_times
            __props__.__dict__["health_check_timeout"] = health_check_timeout
            __props__.__dict__["health_check_type"] = health_check_type
            __props__.__dict__["health_check_uri"] = health_check_uri
            __props__.__dict__["remarks"] = remarks
            if service_port is None and not opts.urn:
                raise TypeError("Missing required property 'service_port'")
            __props__.__dict__["service_port"] = service_port
            if target_port is None and not opts.urn:
                raise TypeError("Missing required property 'target_port'")
            __props__.__dict__["target_port"] = target_port
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(EdgeContainerApp, __self__).__init__(
            'alicloud:esa/edgeContainerApp:EdgeContainerApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            edge_container_app_name: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_fail_times: Optional[pulumi.Input[_builtins.int]] = None,
            health_check_host: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_http_code: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_interval: Optional[pulumi.Input[_builtins.int]] = None,
            health_check_method: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_port: Optional[pulumi.Input[_builtins.int]] = None,
            health_check_succ_times: Optional[pulumi.Input[_builtins.int]] = None,
            health_check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            health_check_type: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_uri: Optional[pulumi.Input[_builtins.str]] = None,
            remarks: Optional[pulumi.Input[_builtins.str]] = None,
            service_port: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            target_port: Optional[pulumi.Input[_builtins.int]] = None) -> 'EdgeContainerApp':
        """
        Get an existing EdgeContainerApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The time when the application was created.
        :param pulumi.Input[_builtins.str] edge_container_app_name: The application name must start with a lowercase letter. Lowercase letters, numbers, and bars are supported. The length is limited to 6 to 128 characters.
        :param pulumi.Input[_builtins.int] health_check_fail_times: The number of consecutive successful health checks required for an application to be considered as healthy. Valid values: 1 to 10. Default value: 2.
        :param pulumi.Input[_builtins.str] health_check_host: The health check type. By default, this parameter is left empty.
               
               Valid values:
        :param pulumi.Input[_builtins.str] health_check_http_code: The domain name that is used for health checks. This parameter is empty by default.
        :param pulumi.Input[_builtins.int] health_check_interval: The timeout period of a health check response. If a backend ECS instance does not respond within the specified timeout period, the ECS instance fails the health check. Unit: seconds.
               Valid values: `1` to `100`.
               Default value: `3`.
        :param pulumi.Input[_builtins.str] health_check_method: The HTTP status code returned for a successful health check. Valid values:
               
               - **http\\_2xx** (default)
               - **http\\_3xx**
        :param pulumi.Input[_builtins.int] health_check_port: The URI used for health checks. The URI must be `1` to `80` characters in length. Default value: "/".
        :param pulumi.Input[_builtins.int] health_check_succ_times: The interval between two consecutive health checks. Unit: seconds. Valid values: `1` to `50`. Default value: `5`.
        :param pulumi.Input[_builtins.int] health_check_timeout: The port used for health checks. Valid values: 1 to 65535. Default value: 80.
        :param pulumi.Input[_builtins.str] health_check_type: The remarks. This parameter is empty by default.
        :param pulumi.Input[_builtins.str] health_check_uri: The HTTP request method for health checks. Valid values:
               
               - `HEAD` (default): requests the headers of the resource.
               - `GET`: requests the specified resource and returns both the headers and entity body.
        :param pulumi.Input[_builtins.str] remarks: The backend port, which is also the service port of the application. Valid values: 1 to 65535.
        :param pulumi.Input[_builtins.int] service_port: The name of the application. The name must start with a lowercase letter and can contain lowercase letters, digits, and hyphens (-). The name must be 6 to 128 characters in length.
        :param pulumi.Input[_builtins.str] status: The status of the application.
        :param pulumi.Input[_builtins.int] target_port: The server port. Valid values: 1 to 65535.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeContainerAppState.__new__(_EdgeContainerAppState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["edge_container_app_name"] = edge_container_app_name
        __props__.__dict__["health_check_fail_times"] = health_check_fail_times
        __props__.__dict__["health_check_host"] = health_check_host
        __props__.__dict__["health_check_http_code"] = health_check_http_code
        __props__.__dict__["health_check_interval"] = health_check_interval
        __props__.__dict__["health_check_method"] = health_check_method
        __props__.__dict__["health_check_port"] = health_check_port
        __props__.__dict__["health_check_succ_times"] = health_check_succ_times
        __props__.__dict__["health_check_timeout"] = health_check_timeout
        __props__.__dict__["health_check_type"] = health_check_type
        __props__.__dict__["health_check_uri"] = health_check_uri
        __props__.__dict__["remarks"] = remarks
        __props__.__dict__["service_port"] = service_port
        __props__.__dict__["status"] = status
        __props__.__dict__["target_port"] = target_port
        return EdgeContainerApp(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the application was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="edgeContainerAppName")
    def edge_container_app_name(self) -> pulumi.Output[_builtins.str]:
        """
        The application name must start with a lowercase letter. Lowercase letters, numbers, and bars are supported. The length is limited to 6 to 128 characters.
        """
        return pulumi.get(self, "edge_container_app_name")

    @_builtins.property
    @pulumi.getter(name="healthCheckFailTimes")
    def health_check_fail_times(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of consecutive successful health checks required for an application to be considered as healthy. Valid values: 1 to 10. Default value: 2.
        """
        return pulumi.get(self, "health_check_fail_times")

    @_builtins.property
    @pulumi.getter(name="healthCheckHost")
    def health_check_host(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The health check type. By default, this parameter is left empty.

        Valid values:
        """
        return pulumi.get(self, "health_check_host")

    @_builtins.property
    @pulumi.getter(name="healthCheckHttpCode")
    def health_check_http_code(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name that is used for health checks. This parameter is empty by default.
        """
        return pulumi.get(self, "health_check_http_code")

    @_builtins.property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> pulumi.Output[_builtins.int]:
        """
        The timeout period of a health check response. If a backend ECS instance does not respond within the specified timeout period, the ECS instance fails the health check. Unit: seconds.
        Valid values: `1` to `100`.
        Default value: `3`.
        """
        return pulumi.get(self, "health_check_interval")

    @_builtins.property
    @pulumi.getter(name="healthCheckMethod")
    def health_check_method(self) -> pulumi.Output[_builtins.str]:
        """
        The HTTP status code returned for a successful health check. Valid values:

        - **http\\_2xx** (default)
        - **http\\_3xx**
        """
        return pulumi.get(self, "health_check_method")

    @_builtins.property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> pulumi.Output[_builtins.int]:
        """
        The URI used for health checks. The URI must be `1` to `80` characters in length. Default value: "/".
        """
        return pulumi.get(self, "health_check_port")

    @_builtins.property
    @pulumi.getter(name="healthCheckSuccTimes")
    def health_check_succ_times(self) -> pulumi.Output[_builtins.int]:
        """
        The interval between two consecutive health checks. Unit: seconds. Valid values: `1` to `50`. Default value: `5`.
        """
        return pulumi.get(self, "health_check_succ_times")

    @_builtins.property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The port used for health checks. Valid values: 1 to 65535. Default value: 80.
        """
        return pulumi.get(self, "health_check_timeout")

    @_builtins.property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> pulumi.Output[_builtins.str]:
        """
        The remarks. This parameter is empty by default.
        """
        return pulumi.get(self, "health_check_type")

    @_builtins.property
    @pulumi.getter(name="healthCheckUri")
    def health_check_uri(self) -> pulumi.Output[_builtins.str]:
        """
        The HTTP request method for health checks. Valid values:

        - `HEAD` (default): requests the headers of the resource.
        - `GET`: requests the specified resource and returns both the headers and entity body.
        """
        return pulumi.get(self, "health_check_uri")

    @_builtins.property
    @pulumi.getter
    def remarks(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The backend port, which is also the service port of the application. Valid values: 1 to 65535.
        """
        return pulumi.get(self, "remarks")

    @_builtins.property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> pulumi.Output[_builtins.int]:
        """
        The name of the application. The name must start with a lowercase letter and can contain lowercase letters, digits, and hyphens (-). The name must be 6 to 128 characters in length.
        """
        return pulumi.get(self, "service_port")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the application.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> pulumi.Output[_builtins.int]:
        """
        The server port. Valid values: 1 to 65535.
        """
        return pulumi.get(self, "target_port")

