# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HttpsApplicationConfigurationArgs', 'HttpsApplicationConfiguration']

@pulumi.input_type
class HttpsApplicationConfigurationArgs:
    def __init__(__self__, *,
                 site_id: pulumi.Input[_builtins.int],
                 alt_svc: Optional[pulumi.Input[_builtins.str]] = None,
                 alt_svc_clear: Optional[pulumi.Input[_builtins.str]] = None,
                 alt_svc_ma: Optional[pulumi.Input[_builtins.str]] = None,
                 alt_svc_persist: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts_include_subdomains: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts_max_age: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts_preload: Optional[pulumi.Input[_builtins.str]] = None,
                 https_force: Optional[pulumi.Input[_builtins.str]] = None,
                 https_force_code: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a HttpsApplicationConfiguration resource.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.str] alt_svc: Function switch, default off. Value range:
        :param pulumi.Input[_builtins.str] alt_svc_clear: Alt-Svc whether The header contains the clear parameter. This parameter is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] alt_svc_ma: The effective time of the Alt-Svc, in seconds. The default value is 86400 seconds.
        :param pulumi.Input[_builtins.str] alt_svc_persist: Alt-Svc whether The header contains the persist parameter. This parameter is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] hsts: Whether to enable HSTS. It is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] hsts_include_subdomains: Whether to include subdomains in HSTS is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] hsts_max_age: The expiration time of HSTS, in seconds.
        :param pulumi.Input[_builtins.str] hsts_preload: Whether to enable HSTS preloading. It is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] https_force: Whether to enable forced HTTPS. It is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] https_force_code: Forced HTTPS jump status code, value range:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               - Match all incoming requests: value set to true
               - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        pulumi.set(__self__, "site_id", site_id)
        if alt_svc is not None:
            pulumi.set(__self__, "alt_svc", alt_svc)
        if alt_svc_clear is not None:
            pulumi.set(__self__, "alt_svc_clear", alt_svc_clear)
        if alt_svc_ma is not None:
            pulumi.set(__self__, "alt_svc_ma", alt_svc_ma)
        if alt_svc_persist is not None:
            pulumi.set(__self__, "alt_svc_persist", alt_svc_persist)
        if hsts is not None:
            pulumi.set(__self__, "hsts", hsts)
        if hsts_include_subdomains is not None:
            pulumi.set(__self__, "hsts_include_subdomains", hsts_include_subdomains)
        if hsts_max_age is not None:
            pulumi.set(__self__, "hsts_max_age", hsts_max_age)
        if hsts_preload is not None:
            pulumi.set(__self__, "hsts_preload", hsts_preload)
        if https_force is not None:
            pulumi.set(__self__, "https_force", https_force)
        if https_force_code is not None:
            pulumi.set(__self__, "https_force_code", https_force_code)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if rule_enable is not None:
            pulumi.set(__self__, "rule_enable", rule_enable)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        The site ID, which can be obtained by calling the ListSites API.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="altSvc")
    def alt_svc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Function switch, default off. Value range:
        """
        return pulumi.get(self, "alt_svc")

    @alt_svc.setter
    def alt_svc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alt_svc", value)

    @_builtins.property
    @pulumi.getter(name="altSvcClear")
    def alt_svc_clear(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alt-Svc whether The header contains the clear parameter. This parameter is disabled by default. Value range:
        """
        return pulumi.get(self, "alt_svc_clear")

    @alt_svc_clear.setter
    def alt_svc_clear(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alt_svc_clear", value)

    @_builtins.property
    @pulumi.getter(name="altSvcMa")
    def alt_svc_ma(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The effective time of the Alt-Svc, in seconds. The default value is 86400 seconds.
        """
        return pulumi.get(self, "alt_svc_ma")

    @alt_svc_ma.setter
    def alt_svc_ma(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alt_svc_ma", value)

    @_builtins.property
    @pulumi.getter(name="altSvcPersist")
    def alt_svc_persist(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alt-Svc whether The header contains the persist parameter. This parameter is disabled by default. Value range:
        """
        return pulumi.get(self, "alt_svc_persist")

    @alt_svc_persist.setter
    def alt_svc_persist(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alt_svc_persist", value)

    @_builtins.property
    @pulumi.getter
    def hsts(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable HSTS. It is disabled by default. Value range:
        """
        return pulumi.get(self, "hsts")

    @hsts.setter
    def hsts(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hsts", value)

    @_builtins.property
    @pulumi.getter(name="hstsIncludeSubdomains")
    def hsts_include_subdomains(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to include subdomains in HSTS is disabled by default. Value range:
        """
        return pulumi.get(self, "hsts_include_subdomains")

    @hsts_include_subdomains.setter
    def hsts_include_subdomains(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hsts_include_subdomains", value)

    @_builtins.property
    @pulumi.getter(name="hstsMaxAge")
    def hsts_max_age(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration time of HSTS, in seconds.
        """
        return pulumi.get(self, "hsts_max_age")

    @hsts_max_age.setter
    def hsts_max_age(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hsts_max_age", value)

    @_builtins.property
    @pulumi.getter(name="hstsPreload")
    def hsts_preload(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable HSTS preloading. It is disabled by default. Value range:
        """
        return pulumi.get(self, "hsts_preload")

    @hsts_preload.setter
    def hsts_preload(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hsts_preload", value)

    @_builtins.property
    @pulumi.getter(name="httpsForce")
    def https_force(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable forced HTTPS. It is disabled by default. Value range:
        """
        return pulumi.get(self, "https_force")

    @https_force.setter
    def https_force(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https_force", value)

    @_builtins.property
    @pulumi.getter(name="httpsForceCode")
    def https_force_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Forced HTTPS jump status code, value range:
        """
        return pulumi.get(self, "https_force_code")

    @https_force_code.setter
    def https_force_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https_force_code", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        - Match all incoming requests: value set to true
        - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        """
        return pulumi.get(self, "rule_enable")

    @rule_enable.setter
    def rule_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_enable", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)


@pulumi.input_type
class _HttpsApplicationConfigurationState:
    def __init__(__self__, *,
                 alt_svc: Optional[pulumi.Input[_builtins.str]] = None,
                 alt_svc_clear: Optional[pulumi.Input[_builtins.str]] = None,
                 alt_svc_ma: Optional[pulumi.Input[_builtins.str]] = None,
                 alt_svc_persist: Optional[pulumi.Input[_builtins.str]] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 hsts: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts_include_subdomains: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts_max_age: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts_preload: Optional[pulumi.Input[_builtins.str]] = None,
                 https_force: Optional[pulumi.Input[_builtins.str]] = None,
                 https_force_code: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering HttpsApplicationConfiguration resources.
        :param pulumi.Input[_builtins.str] alt_svc: Function switch, default off. Value range:
        :param pulumi.Input[_builtins.str] alt_svc_clear: Alt-Svc whether The header contains the clear parameter. This parameter is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] alt_svc_ma: The effective time of the Alt-Svc, in seconds. The default value is 86400 seconds.
        :param pulumi.Input[_builtins.str] alt_svc_persist: Alt-Svc whether The header contains the persist parameter. This parameter is disabled by default. Value range:
        :param pulumi.Input[_builtins.int] config_id: Config Id
        :param pulumi.Input[_builtins.str] hsts: Whether to enable HSTS. It is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] hsts_include_subdomains: Whether to include subdomains in HSTS is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] hsts_max_age: The expiration time of HSTS, in seconds.
        :param pulumi.Input[_builtins.str] hsts_preload: Whether to enable HSTS preloading. It is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] https_force: Whether to enable forced HTTPS. It is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] https_force_code: Forced HTTPS jump status code, value range:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               - Match all incoming requests: value set to true
               - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        if alt_svc is not None:
            pulumi.set(__self__, "alt_svc", alt_svc)
        if alt_svc_clear is not None:
            pulumi.set(__self__, "alt_svc_clear", alt_svc_clear)
        if alt_svc_ma is not None:
            pulumi.set(__self__, "alt_svc_ma", alt_svc_ma)
        if alt_svc_persist is not None:
            pulumi.set(__self__, "alt_svc_persist", alt_svc_persist)
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if hsts is not None:
            pulumi.set(__self__, "hsts", hsts)
        if hsts_include_subdomains is not None:
            pulumi.set(__self__, "hsts_include_subdomains", hsts_include_subdomains)
        if hsts_max_age is not None:
            pulumi.set(__self__, "hsts_max_age", hsts_max_age)
        if hsts_preload is not None:
            pulumi.set(__self__, "hsts_preload", hsts_preload)
        if https_force is not None:
            pulumi.set(__self__, "https_force", https_force)
        if https_force_code is not None:
            pulumi.set(__self__, "https_force_code", https_force_code)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if rule_enable is not None:
            pulumi.set(__self__, "rule_enable", rule_enable)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)

    @_builtins.property
    @pulumi.getter(name="altSvc")
    def alt_svc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Function switch, default off. Value range:
        """
        return pulumi.get(self, "alt_svc")

    @alt_svc.setter
    def alt_svc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alt_svc", value)

    @_builtins.property
    @pulumi.getter(name="altSvcClear")
    def alt_svc_clear(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alt-Svc whether The header contains the clear parameter. This parameter is disabled by default. Value range:
        """
        return pulumi.get(self, "alt_svc_clear")

    @alt_svc_clear.setter
    def alt_svc_clear(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alt_svc_clear", value)

    @_builtins.property
    @pulumi.getter(name="altSvcMa")
    def alt_svc_ma(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The effective time of the Alt-Svc, in seconds. The default value is 86400 seconds.
        """
        return pulumi.get(self, "alt_svc_ma")

    @alt_svc_ma.setter
    def alt_svc_ma(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alt_svc_ma", value)

    @_builtins.property
    @pulumi.getter(name="altSvcPersist")
    def alt_svc_persist(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alt-Svc whether The header contains the persist parameter. This parameter is disabled by default. Value range:
        """
        return pulumi.get(self, "alt_svc_persist")

    @alt_svc_persist.setter
    def alt_svc_persist(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alt_svc_persist", value)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Config Id
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter
    def hsts(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable HSTS. It is disabled by default. Value range:
        """
        return pulumi.get(self, "hsts")

    @hsts.setter
    def hsts(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hsts", value)

    @_builtins.property
    @pulumi.getter(name="hstsIncludeSubdomains")
    def hsts_include_subdomains(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to include subdomains in HSTS is disabled by default. Value range:
        """
        return pulumi.get(self, "hsts_include_subdomains")

    @hsts_include_subdomains.setter
    def hsts_include_subdomains(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hsts_include_subdomains", value)

    @_builtins.property
    @pulumi.getter(name="hstsMaxAge")
    def hsts_max_age(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration time of HSTS, in seconds.
        """
        return pulumi.get(self, "hsts_max_age")

    @hsts_max_age.setter
    def hsts_max_age(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hsts_max_age", value)

    @_builtins.property
    @pulumi.getter(name="hstsPreload")
    def hsts_preload(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable HSTS preloading. It is disabled by default. Value range:
        """
        return pulumi.get(self, "hsts_preload")

    @hsts_preload.setter
    def hsts_preload(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hsts_preload", value)

    @_builtins.property
    @pulumi.getter(name="httpsForce")
    def https_force(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable forced HTTPS. It is disabled by default. Value range:
        """
        return pulumi.get(self, "https_force")

    @https_force.setter
    def https_force(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https_force", value)

    @_builtins.property
    @pulumi.getter(name="httpsForceCode")
    def https_force_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Forced HTTPS jump status code, value range:
        """
        return pulumi.get(self, "https_force_code")

    @https_force_code.setter
    def https_force_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https_force_code", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        - Match all incoming requests: value set to true
        - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        """
        return pulumi.get(self, "rule_enable")

    @rule_enable.setter
    def rule_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_enable", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The site ID, which can be obtained by calling the ListSites API.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)


@pulumi.type_token("alicloud:esa/httpsApplicationConfiguration:HttpsApplicationConfiguration")
class HttpsApplicationConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alt_svc: Optional[pulumi.Input[_builtins.str]] = None,
                 alt_svc_clear: Optional[pulumi.Input[_builtins.str]] = None,
                 alt_svc_ma: Optional[pulumi.Input[_builtins.str]] = None,
                 alt_svc_persist: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts_include_subdomains: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts_max_age: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts_preload: Optional[pulumi.Input[_builtins.str]] = None,
                 https_force: Optional[pulumi.Input[_builtins.str]] = None,
                 https_force_code: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a ESA Https Application Configuration resource.

        For information about ESA Https Application Configuration and how to use it, see [What is Https Application Configuration](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateHttpsApplicationConfiguration).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name="httpsapplicationconfiguration.example.com",
            instance_id=default.sites[0].instance_id,
            coverage="domestic",
            access_type="NS")
        default_https_application_configuration = alicloud.esa.HttpsApplicationConfiguration("default",
            hsts_max_age="31536000",
            alt_svc_clear="off",
            rule="http.host eq \\"video.example.com\\"",
            https_force="off",
            alt_svc_ma="86400",
            hsts="off",
            rule_name="rule_example",
            rule_enable="off",
            site_id=default_site.id,
            alt_svc_persist="off",
            hsts_preload="off",
            hsts_include_subdomains="off",
            alt_svc="off",
            https_force_code="301",
            site_version=0)
        ```

        ## Import

        ESA Https Application Configuration can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/httpsApplicationConfiguration:HttpsApplicationConfiguration example <site_id>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alt_svc: Function switch, default off. Value range:
        :param pulumi.Input[_builtins.str] alt_svc_clear: Alt-Svc whether The header contains the clear parameter. This parameter is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] alt_svc_ma: The effective time of the Alt-Svc, in seconds. The default value is 86400 seconds.
        :param pulumi.Input[_builtins.str] alt_svc_persist: Alt-Svc whether The header contains the persist parameter. This parameter is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] hsts: Whether to enable HSTS. It is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] hsts_include_subdomains: Whether to include subdomains in HSTS is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] hsts_max_age: The expiration time of HSTS, in seconds.
        :param pulumi.Input[_builtins.str] hsts_preload: Whether to enable HSTS preloading. It is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] https_force: Whether to enable forced HTTPS. It is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] https_force_code: Forced HTTPS jump status code, value range:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               - Match all incoming requests: value set to true
               - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HttpsApplicationConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Https Application Configuration resource.

        For information about ESA Https Application Configuration and how to use it, see [What is Https Application Configuration](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateHttpsApplicationConfiguration).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name="httpsapplicationconfiguration.example.com",
            instance_id=default.sites[0].instance_id,
            coverage="domestic",
            access_type="NS")
        default_https_application_configuration = alicloud.esa.HttpsApplicationConfiguration("default",
            hsts_max_age="31536000",
            alt_svc_clear="off",
            rule="http.host eq \\"video.example.com\\"",
            https_force="off",
            alt_svc_ma="86400",
            hsts="off",
            rule_name="rule_example",
            rule_enable="off",
            site_id=default_site.id,
            alt_svc_persist="off",
            hsts_preload="off",
            hsts_include_subdomains="off",
            alt_svc="off",
            https_force_code="301",
            site_version=0)
        ```

        ## Import

        ESA Https Application Configuration can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/httpsApplicationConfiguration:HttpsApplicationConfiguration example <site_id>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param HttpsApplicationConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HttpsApplicationConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alt_svc: Optional[pulumi.Input[_builtins.str]] = None,
                 alt_svc_clear: Optional[pulumi.Input[_builtins.str]] = None,
                 alt_svc_ma: Optional[pulumi.Input[_builtins.str]] = None,
                 alt_svc_persist: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts_include_subdomains: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts_max_age: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts_preload: Optional[pulumi.Input[_builtins.str]] = None,
                 https_force: Optional[pulumi.Input[_builtins.str]] = None,
                 https_force_code: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HttpsApplicationConfigurationArgs.__new__(HttpsApplicationConfigurationArgs)

            __props__.__dict__["alt_svc"] = alt_svc
            __props__.__dict__["alt_svc_clear"] = alt_svc_clear
            __props__.__dict__["alt_svc_ma"] = alt_svc_ma
            __props__.__dict__["alt_svc_persist"] = alt_svc_persist
            __props__.__dict__["hsts"] = hsts
            __props__.__dict__["hsts_include_subdomains"] = hsts_include_subdomains
            __props__.__dict__["hsts_max_age"] = hsts_max_age
            __props__.__dict__["hsts_preload"] = hsts_preload
            __props__.__dict__["https_force"] = https_force
            __props__.__dict__["https_force_code"] = https_force_code
            __props__.__dict__["rule"] = rule
            __props__.__dict__["rule_enable"] = rule_enable
            __props__.__dict__["rule_name"] = rule_name
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["site_version"] = site_version
            __props__.__dict__["config_id"] = None
        super(HttpsApplicationConfiguration, __self__).__init__(
            'alicloud:esa/httpsApplicationConfiguration:HttpsApplicationConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alt_svc: Optional[pulumi.Input[_builtins.str]] = None,
            alt_svc_clear: Optional[pulumi.Input[_builtins.str]] = None,
            alt_svc_ma: Optional[pulumi.Input[_builtins.str]] = None,
            alt_svc_persist: Optional[pulumi.Input[_builtins.str]] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            hsts: Optional[pulumi.Input[_builtins.str]] = None,
            hsts_include_subdomains: Optional[pulumi.Input[_builtins.str]] = None,
            hsts_max_age: Optional[pulumi.Input[_builtins.str]] = None,
            hsts_preload: Optional[pulumi.Input[_builtins.str]] = None,
            https_force: Optional[pulumi.Input[_builtins.str]] = None,
            https_force_code: Optional[pulumi.Input[_builtins.str]] = None,
            rule: Optional[pulumi.Input[_builtins.str]] = None,
            rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
            rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            site_version: Optional[pulumi.Input[_builtins.int]] = None) -> 'HttpsApplicationConfiguration':
        """
        Get an existing HttpsApplicationConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alt_svc: Function switch, default off. Value range:
        :param pulumi.Input[_builtins.str] alt_svc_clear: Alt-Svc whether The header contains the clear parameter. This parameter is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] alt_svc_ma: The effective time of the Alt-Svc, in seconds. The default value is 86400 seconds.
        :param pulumi.Input[_builtins.str] alt_svc_persist: Alt-Svc whether The header contains the persist parameter. This parameter is disabled by default. Value range:
        :param pulumi.Input[_builtins.int] config_id: Config Id
        :param pulumi.Input[_builtins.str] hsts: Whether to enable HSTS. It is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] hsts_include_subdomains: Whether to include subdomains in HSTS is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] hsts_max_age: The expiration time of HSTS, in seconds.
        :param pulumi.Input[_builtins.str] hsts_preload: Whether to enable HSTS preloading. It is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] https_force: Whether to enable forced HTTPS. It is disabled by default. Value range:
        :param pulumi.Input[_builtins.str] https_force_code: Forced HTTPS jump status code, value range:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               - Match all incoming requests: value set to true
               - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HttpsApplicationConfigurationState.__new__(_HttpsApplicationConfigurationState)

        __props__.__dict__["alt_svc"] = alt_svc
        __props__.__dict__["alt_svc_clear"] = alt_svc_clear
        __props__.__dict__["alt_svc_ma"] = alt_svc_ma
        __props__.__dict__["alt_svc_persist"] = alt_svc_persist
        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["hsts"] = hsts
        __props__.__dict__["hsts_include_subdomains"] = hsts_include_subdomains
        __props__.__dict__["hsts_max_age"] = hsts_max_age
        __props__.__dict__["hsts_preload"] = hsts_preload
        __props__.__dict__["https_force"] = https_force
        __props__.__dict__["https_force_code"] = https_force_code
        __props__.__dict__["rule"] = rule
        __props__.__dict__["rule_enable"] = rule_enable
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["site_version"] = site_version
        return HttpsApplicationConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="altSvc")
    def alt_svc(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Function switch, default off. Value range:
        """
        return pulumi.get(self, "alt_svc")

    @_builtins.property
    @pulumi.getter(name="altSvcClear")
    def alt_svc_clear(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Alt-Svc whether The header contains the clear parameter. This parameter is disabled by default. Value range:
        """
        return pulumi.get(self, "alt_svc_clear")

    @_builtins.property
    @pulumi.getter(name="altSvcMa")
    def alt_svc_ma(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The effective time of the Alt-Svc, in seconds. The default value is 86400 seconds.
        """
        return pulumi.get(self, "alt_svc_ma")

    @_builtins.property
    @pulumi.getter(name="altSvcPersist")
    def alt_svc_persist(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Alt-Svc whether The header contains the persist parameter. This parameter is disabled by default. Value range:
        """
        return pulumi.get(self, "alt_svc_persist")

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        Config Id
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter
    def hsts(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to enable HSTS. It is disabled by default. Value range:
        """
        return pulumi.get(self, "hsts")

    @_builtins.property
    @pulumi.getter(name="hstsIncludeSubdomains")
    def hsts_include_subdomains(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to include subdomains in HSTS is disabled by default. Value range:
        """
        return pulumi.get(self, "hsts_include_subdomains")

    @_builtins.property
    @pulumi.getter(name="hstsMaxAge")
    def hsts_max_age(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The expiration time of HSTS, in seconds.
        """
        return pulumi.get(self, "hsts_max_age")

    @_builtins.property
    @pulumi.getter(name="hstsPreload")
    def hsts_preload(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to enable HSTS preloading. It is disabled by default. Value range:
        """
        return pulumi.get(self, "hsts_preload")

    @_builtins.property
    @pulumi.getter(name="httpsForce")
    def https_force(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to enable forced HTTPS. It is disabled by default. Value range:
        """
        return pulumi.get(self, "https_force")

    @_builtins.property
    @pulumi.getter(name="httpsForceCode")
    def https_force_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Forced HTTPS jump status code, value range:
        """
        return pulumi.get(self, "https_force_code")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        - Match all incoming requests: value set to true
        - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        """
        return pulumi.get(self, "rule_enable")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The site ID, which can be obtained by calling the ListSites API.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        return pulumi.get(self, "site_version")

