# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RedirectRuleArgs', 'RedirectRule']

@pulumi.input_type
class RedirectRuleArgs:
    def __init__(__self__, *,
                 reserve_query_string: pulumi.Input[_builtins.str],
                 site_id: pulumi.Input[_builtins.int],
                 status_code: pulumi.Input[_builtins.str],
                 target_url: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a RedirectRule resource.
        :param pulumi.Input[_builtins.str] reserve_query_string: Indicates whether the feature of retaining the query string is enabled. Valid values:
               
               - on
               - off
        :param pulumi.Input[_builtins.int] site_id: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.str] status_code: The response code that you want to use to indicate URL redirection. Valid values:
               
               - 301
               - 302
               - 303
               - 307
               - 308
        :param pulumi.Input[_builtins.str] target_url: The destination URL to which requests are redirected.
        :param pulumi.Input[_builtins.str] type: The redirect type. Valid value:
               
               - static
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               ● Match all incoming requests: value set to true
               ● Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        pulumi.set(__self__, "reserve_query_string", reserve_query_string)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "status_code", status_code)
        pulumi.set(__self__, "target_url", target_url)
        pulumi.set(__self__, "type", type)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if rule_enable is not None:
            pulumi.set(__self__, "rule_enable", rule_enable)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)

    @_builtins.property
    @pulumi.getter(name="reserveQueryString")
    def reserve_query_string(self) -> pulumi.Input[_builtins.str]:
        """
        Indicates whether the feature of retaining the query string is enabled. Valid values:

        - on
        - off
        """
        return pulumi.get(self, "reserve_query_string")

    @reserve_query_string.setter
    def reserve_query_string(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "reserve_query_string", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Input[_builtins.str]:
        """
        The response code that you want to use to indicate URL redirection. Valid values:

        - 301
        - 302
        - 303
        - 307
        - 308
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "status_code", value)

    @_builtins.property
    @pulumi.getter(name="targetUrl")
    def target_url(self) -> pulumi.Input[_builtins.str]:
        """
        The destination URL to which requests are redirected.
        """
        return pulumi.get(self, "target_url")

    @target_url.setter
    def target_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_url", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The redirect type. Valid value:

        - static
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        ● Match all incoming requests: value set to true
        ● Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        """
        return pulumi.get(self, "rule_enable")

    @rule_enable.setter
    def rule_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_enable", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)


@pulumi.input_type
class _RedirectRuleState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 reserve_query_string: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 status_code: Optional[pulumi.Input[_builtins.str]] = None,
                 target_url: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RedirectRule resources.
        :param pulumi.Input[_builtins.int] config_id: Config Id
        :param pulumi.Input[_builtins.str] reserve_query_string: Indicates whether the feature of retaining the query string is enabled. Valid values:
               
               - on
               - off
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               ● Match all incoming requests: value set to true
               ● Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] site_id: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        :param pulumi.Input[_builtins.str] status_code: The response code that you want to use to indicate URL redirection. Valid values:
               
               - 301
               - 302
               - 303
               - 307
               - 308
        :param pulumi.Input[_builtins.str] target_url: The destination URL to which requests are redirected.
        :param pulumi.Input[_builtins.str] type: The redirect type. Valid value:
               
               - static
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if reserve_query_string is not None:
            pulumi.set(__self__, "reserve_query_string", reserve_query_string)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if rule_enable is not None:
            pulumi.set(__self__, "rule_enable", rule_enable)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)
        if target_url is not None:
            pulumi.set(__self__, "target_url", target_url)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Config Id
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="reserveQueryString")
    def reserve_query_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the feature of retaining the query string is enabled. Valid values:

        - on
        - off
        """
        return pulumi.get(self, "reserve_query_string")

    @reserve_query_string.setter
    def reserve_query_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reserve_query_string", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        ● Match all incoming requests: value set to true
        ● Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        """
        return pulumi.get(self, "rule_enable")

    @rule_enable.setter
    def rule_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_enable", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The response code that you want to use to indicate URL redirection. Valid values:

        - 301
        - 302
        - 303
        - 307
        - 308
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_code", value)

    @_builtins.property
    @pulumi.getter(name="targetUrl")
    def target_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination URL to which requests are redirected.
        """
        return pulumi.get(self, "target_url")

    @target_url.setter
    def target_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_url", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The redirect type. Valid value:

        - static
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("alicloud:esa/redirectRule:RedirectRule")
class RedirectRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 reserve_query_string: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 status_code: Optional[pulumi.Input[_builtins.str]] = None,
                 target_url: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Redirect Rule resource.

        For information about ESA Redirect Rule and how to use it, see [What is Redirect Rule](https://www.alibabacloud.com/help/en/edge-security-acceleration/esa/api-esa-2024-09-10-createredirectrule).

        > **NOTE:** Available since v1.243.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        resource_redirect_rule_example = alicloud.esa.RatePlanInstance("resource_RedirectRule_example",
            type="NS",
            auto_renew=False,
            period=1,
            payment_type="Subscription",
            coverage="overseas",
            auto_pay=True,
            plan_name="high")
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        resource_site_redirect_rule_example = alicloud.esa.Site("resource_Site_RedirectRule_example",
            site_name=f"gositecdn-{default['result']}.cn",
            instance_id=resource_redirect_rule_example.id,
            coverage="overseas",
            access_type="NS")
        default_redirect_rule = alicloud.esa.RedirectRule("default",
            status_code="301",
            rule_name="example",
            site_id=resource_site_redirect_rule_example.id,
            type="static",
            reserve_query_string="on",
            target_url="http://www.exapmle.com/index.html",
            rule_enable="on",
            site_version=0,
            rule="(http.host eq \\"video.example.com\\")")
        ```

        ## Import

        ESA Redirect Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/redirectRule:RedirectRule example <site_id>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] reserve_query_string: Indicates whether the feature of retaining the query string is enabled. Valid values:
               
               - on
               - off
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               ● Match all incoming requests: value set to true
               ● Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] site_id: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        :param pulumi.Input[_builtins.str] status_code: The response code that you want to use to indicate URL redirection. Valid values:
               
               - 301
               - 302
               - 303
               - 307
               - 308
        :param pulumi.Input[_builtins.str] target_url: The destination URL to which requests are redirected.
        :param pulumi.Input[_builtins.str] type: The redirect type. Valid value:
               
               - static
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RedirectRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Redirect Rule resource.

        For information about ESA Redirect Rule and how to use it, see [What is Redirect Rule](https://www.alibabacloud.com/help/en/edge-security-acceleration/esa/api-esa-2024-09-10-createredirectrule).

        > **NOTE:** Available since v1.243.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        resource_redirect_rule_example = alicloud.esa.RatePlanInstance("resource_RedirectRule_example",
            type="NS",
            auto_renew=False,
            period=1,
            payment_type="Subscription",
            coverage="overseas",
            auto_pay=True,
            plan_name="high")
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        resource_site_redirect_rule_example = alicloud.esa.Site("resource_Site_RedirectRule_example",
            site_name=f"gositecdn-{default['result']}.cn",
            instance_id=resource_redirect_rule_example.id,
            coverage="overseas",
            access_type="NS")
        default_redirect_rule = alicloud.esa.RedirectRule("default",
            status_code="301",
            rule_name="example",
            site_id=resource_site_redirect_rule_example.id,
            type="static",
            reserve_query_string="on",
            target_url="http://www.exapmle.com/index.html",
            rule_enable="on",
            site_version=0,
            rule="(http.host eq \\"video.example.com\\")")
        ```

        ## Import

        ESA Redirect Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/redirectRule:RedirectRule example <site_id>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param RedirectRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RedirectRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 reserve_query_string: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 status_code: Optional[pulumi.Input[_builtins.str]] = None,
                 target_url: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RedirectRuleArgs.__new__(RedirectRuleArgs)

            if reserve_query_string is None and not opts.urn:
                raise TypeError("Missing required property 'reserve_query_string'")
            __props__.__dict__["reserve_query_string"] = reserve_query_string
            __props__.__dict__["rule"] = rule
            __props__.__dict__["rule_enable"] = rule_enable
            __props__.__dict__["rule_name"] = rule_name
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["site_version"] = site_version
            if status_code is None and not opts.urn:
                raise TypeError("Missing required property 'status_code'")
            __props__.__dict__["status_code"] = status_code
            if target_url is None and not opts.urn:
                raise TypeError("Missing required property 'target_url'")
            __props__.__dict__["target_url"] = target_url
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["config_id"] = None
        super(RedirectRule, __self__).__init__(
            'alicloud:esa/redirectRule:RedirectRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            reserve_query_string: Optional[pulumi.Input[_builtins.str]] = None,
            rule: Optional[pulumi.Input[_builtins.str]] = None,
            rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
            rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            site_version: Optional[pulumi.Input[_builtins.int]] = None,
            status_code: Optional[pulumi.Input[_builtins.str]] = None,
            target_url: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'RedirectRule':
        """
        Get an existing RedirectRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_id: Config Id
        :param pulumi.Input[_builtins.str] reserve_query_string: Indicates whether the feature of retaining the query string is enabled. Valid values:
               
               - on
               - off
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               ● Match all incoming requests: value set to true
               ● Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] site_id: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        :param pulumi.Input[_builtins.str] status_code: The response code that you want to use to indicate URL redirection. Valid values:
               
               - 301
               - 302
               - 303
               - 307
               - 308
        :param pulumi.Input[_builtins.str] target_url: The destination URL to which requests are redirected.
        :param pulumi.Input[_builtins.str] type: The redirect type. Valid value:
               
               - static
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RedirectRuleState.__new__(_RedirectRuleState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["reserve_query_string"] = reserve_query_string
        __props__.__dict__["rule"] = rule
        __props__.__dict__["rule_enable"] = rule_enable
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["site_version"] = site_version
        __props__.__dict__["status_code"] = status_code
        __props__.__dict__["target_url"] = target_url
        __props__.__dict__["type"] = type
        return RedirectRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        Config Id
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="reserveQueryString")
    def reserve_query_string(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates whether the feature of retaining the query string is enabled. Valid values:

        - on
        - off
        """
        return pulumi.get(self, "reserve_query_string")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        ● Match all incoming requests: value set to true
        ● Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        """
        return pulumi.get(self, "rule_enable")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        return pulumi.get(self, "site_version")

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Output[_builtins.str]:
        """
        The response code that you want to use to indicate URL redirection. Valid values:

        - 301
        - 302
        - 303
        - 307
        - 308
        """
        return pulumi.get(self, "status_code")

    @_builtins.property
    @pulumi.getter(name="targetUrl")
    def target_url(self) -> pulumi.Output[_builtins.str]:
        """
        The destination URL to which requests are redirected.
        """
        return pulumi.get(self, "target_url")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The redirect type. Valid value:

        - static
        """
        return pulumi.get(self, "type")

