# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RewriteUrlRuleArgs', 'RewriteUrlRule']

@pulumi.input_type
class RewriteUrlRuleArgs:
    def __init__(__self__, *,
                 site_id: pulumi.Input[_builtins.int],
                 query_string: Optional[pulumi.Input[_builtins.str]] = None,
                 rewrite_query_string_type: Optional[pulumi.Input[_builtins.str]] = None,
                 rewrite_uri_type: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RewriteUrlRule resource.
        :param pulumi.Input[_builtins.int] site_id: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.str] query_string: The desired query string to which you want to rewrite the query string in the original request.
        :param pulumi.Input[_builtins.str] rewrite_query_string_type: Query string rewrite type. Value range:
        :param pulumi.Input[_builtins.str] rewrite_uri_type: URI rewrite type. Value range:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               ● Match all incoming requests: value set to true
               ● Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Indicates whether the rule is enabled. Valid values:
               
               - on
               - off
        :param pulumi.Input[_builtins.str] rule_name: The rule name. You do not need to set this parameter when adding a global configuration.
        :param pulumi.Input[_builtins.int] site_version: Version number of the site configuration. For a site with configuration version management enabled, you can use this parameter to specify the site version in which the configuration takes effect. The default version is 0.
        :param pulumi.Input[_builtins.str] uri: The desired URI to which you want to rewrite the path in the original request.
        """
        pulumi.set(__self__, "site_id", site_id)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if rewrite_query_string_type is not None:
            pulumi.set(__self__, "rewrite_query_string_type", rewrite_query_string_type)
        if rewrite_uri_type is not None:
            pulumi.set(__self__, "rewrite_uri_type", rewrite_uri_type)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if rule_enable is not None:
            pulumi.set(__self__, "rule_enable", rule_enable)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired query string to which you want to rewrite the query string in the original request.
        """
        return pulumi.get(self, "query_string")

    @query_string.setter
    def query_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_string", value)

    @_builtins.property
    @pulumi.getter(name="rewriteQueryStringType")
    def rewrite_query_string_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Query string rewrite type. Value range:
        """
        return pulumi.get(self, "rewrite_query_string_type")

    @rewrite_query_string_type.setter
    def rewrite_query_string_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rewrite_query_string_type", value)

    @_builtins.property
    @pulumi.getter(name="rewriteUriType")
    def rewrite_uri_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI rewrite type. Value range:
        """
        return pulumi.get(self, "rewrite_uri_type")

    @rewrite_uri_type.setter
    def rewrite_uri_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rewrite_uri_type", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        ● Match all incoming requests: value set to true
        ● Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the rule is enabled. Valid values:

        - on
        - off
        """
        return pulumi.get(self, "rule_enable")

    @rule_enable.setter
    def rule_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_enable", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule name. You do not need to set this parameter when adding a global configuration.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Version number of the site configuration. For a site with configuration version management enabled, you can use this parameter to specify the site version in which the configuration takes effect. The default version is 0.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired URI to which you want to rewrite the path in the original request.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class _RewriteUrlRuleState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 query_string: Optional[pulumi.Input[_builtins.str]] = None,
                 rewrite_query_string_type: Optional[pulumi.Input[_builtins.str]] = None,
                 rewrite_uri_type: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RewriteUrlRule resources.
        :param pulumi.Input[_builtins.int] config_id: ConfigId
        :param pulumi.Input[_builtins.str] query_string: The desired query string to which you want to rewrite the query string in the original request.
        :param pulumi.Input[_builtins.str] rewrite_query_string_type: Query string rewrite type. Value range:
        :param pulumi.Input[_builtins.str] rewrite_uri_type: URI rewrite type. Value range:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               ● Match all incoming requests: value set to true
               ● Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Indicates whether the rule is enabled. Valid values:
               
               - on
               - off
        :param pulumi.Input[_builtins.str] rule_name: The rule name. You do not need to set this parameter when adding a global configuration.
        :param pulumi.Input[_builtins.int] site_id: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.int] site_version: Version number of the site configuration. For a site with configuration version management enabled, you can use this parameter to specify the site version in which the configuration takes effect. The default version is 0.
        :param pulumi.Input[_builtins.str] uri: The desired URI to which you want to rewrite the path in the original request.
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if rewrite_query_string_type is not None:
            pulumi.set(__self__, "rewrite_query_string_type", rewrite_query_string_type)
        if rewrite_uri_type is not None:
            pulumi.set(__self__, "rewrite_uri_type", rewrite_uri_type)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if rule_enable is not None:
            pulumi.set(__self__, "rule_enable", rule_enable)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        ConfigId
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired query string to which you want to rewrite the query string in the original request.
        """
        return pulumi.get(self, "query_string")

    @query_string.setter
    def query_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_string", value)

    @_builtins.property
    @pulumi.getter(name="rewriteQueryStringType")
    def rewrite_query_string_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Query string rewrite type. Value range:
        """
        return pulumi.get(self, "rewrite_query_string_type")

    @rewrite_query_string_type.setter
    def rewrite_query_string_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rewrite_query_string_type", value)

    @_builtins.property
    @pulumi.getter(name="rewriteUriType")
    def rewrite_uri_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI rewrite type. Value range:
        """
        return pulumi.get(self, "rewrite_uri_type")

    @rewrite_uri_type.setter
    def rewrite_uri_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rewrite_uri_type", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        ● Match all incoming requests: value set to true
        ● Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the rule is enabled. Valid values:

        - on
        - off
        """
        return pulumi.get(self, "rule_enable")

    @rule_enable.setter
    def rule_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_enable", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule name. You do not need to set this parameter when adding a global configuration.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Version number of the site configuration. For a site with configuration version management enabled, you can use this parameter to specify the site version in which the configuration takes effect. The default version is 0.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired URI to which you want to rewrite the path in the original request.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uri", value)


@pulumi.type_token("alicloud:esa/rewriteUrlRule:RewriteUrlRule")
class RewriteUrlRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 query_string: Optional[pulumi.Input[_builtins.str]] = None,
                 rewrite_query_string_type: Optional[pulumi.Input[_builtins.str]] = None,
                 rewrite_uri_type: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Rewrite Url Rule resource.

        For information about ESA Rewrite Url Rule and how to use it, see [What is Rewrite Url Rule](https://www.alibabacloud.com/help/en/edge-security-acceleration/esa/api-esa-2024-09-10-createrewriteurlrule).

        > **NOTE:** Available since v1.243.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        resource_rewrite_url_rule_rate_plan_instance_example = alicloud.esa.RatePlanInstance("resource_RewriteUrlRule_RatePlanInstance_example",
            type="NS",
            auto_renew=False,
            period=1,
            payment_type="Subscription",
            coverage="overseas",
            auto_pay=True,
            plan_name="high")
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        resource_rewrite_url_rule_site_example = alicloud.esa.Site("resource_RewriteUrlRule_Site_example",
            site_name=f"gositecdn-{default['result']}.cn",
            instance_id=resource_rewrite_url_rule_rate_plan_instance_example.id,
            coverage="overseas",
            access_type="NS")
        default_rewrite_url_rule = alicloud.esa.RewriteUrlRule("default",
            rewrite_uri_type="static",
            rewrite_query_string_type="static",
            site_id=resource_rewrite_url_rule_site_example.id,
            rule_name="example",
            rule_enable="on",
            query_string="example=123",
            site_version=0,
            rule="http.host eq \\"video.example.com\\"",
            uri="/image/example.jpg")
        ```

        ## Import

        ESA Rewrite Url Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/rewriteUrlRule:RewriteUrlRule example <site_id>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] query_string: The desired query string to which you want to rewrite the query string in the original request.
        :param pulumi.Input[_builtins.str] rewrite_query_string_type: Query string rewrite type. Value range:
        :param pulumi.Input[_builtins.str] rewrite_uri_type: URI rewrite type. Value range:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               ● Match all incoming requests: value set to true
               ● Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Indicates whether the rule is enabled. Valid values:
               
               - on
               - off
        :param pulumi.Input[_builtins.str] rule_name: The rule name. You do not need to set this parameter when adding a global configuration.
        :param pulumi.Input[_builtins.int] site_id: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.int] site_version: Version number of the site configuration. For a site with configuration version management enabled, you can use this parameter to specify the site version in which the configuration takes effect. The default version is 0.
        :param pulumi.Input[_builtins.str] uri: The desired URI to which you want to rewrite the path in the original request.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RewriteUrlRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Rewrite Url Rule resource.

        For information about ESA Rewrite Url Rule and how to use it, see [What is Rewrite Url Rule](https://www.alibabacloud.com/help/en/edge-security-acceleration/esa/api-esa-2024-09-10-createrewriteurlrule).

        > **NOTE:** Available since v1.243.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        resource_rewrite_url_rule_rate_plan_instance_example = alicloud.esa.RatePlanInstance("resource_RewriteUrlRule_RatePlanInstance_example",
            type="NS",
            auto_renew=False,
            period=1,
            payment_type="Subscription",
            coverage="overseas",
            auto_pay=True,
            plan_name="high")
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        resource_rewrite_url_rule_site_example = alicloud.esa.Site("resource_RewriteUrlRule_Site_example",
            site_name=f"gositecdn-{default['result']}.cn",
            instance_id=resource_rewrite_url_rule_rate_plan_instance_example.id,
            coverage="overseas",
            access_type="NS")
        default_rewrite_url_rule = alicloud.esa.RewriteUrlRule("default",
            rewrite_uri_type="static",
            rewrite_query_string_type="static",
            site_id=resource_rewrite_url_rule_site_example.id,
            rule_name="example",
            rule_enable="on",
            query_string="example=123",
            site_version=0,
            rule="http.host eq \\"video.example.com\\"",
            uri="/image/example.jpg")
        ```

        ## Import

        ESA Rewrite Url Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/rewriteUrlRule:RewriteUrlRule example <site_id>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param RewriteUrlRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RewriteUrlRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 query_string: Optional[pulumi.Input[_builtins.str]] = None,
                 rewrite_query_string_type: Optional[pulumi.Input[_builtins.str]] = None,
                 rewrite_uri_type: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RewriteUrlRuleArgs.__new__(RewriteUrlRuleArgs)

            __props__.__dict__["query_string"] = query_string
            __props__.__dict__["rewrite_query_string_type"] = rewrite_query_string_type
            __props__.__dict__["rewrite_uri_type"] = rewrite_uri_type
            __props__.__dict__["rule"] = rule
            __props__.__dict__["rule_enable"] = rule_enable
            __props__.__dict__["rule_name"] = rule_name
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["site_version"] = site_version
            __props__.__dict__["uri"] = uri
            __props__.__dict__["config_id"] = None
        super(RewriteUrlRule, __self__).__init__(
            'alicloud:esa/rewriteUrlRule:RewriteUrlRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            query_string: Optional[pulumi.Input[_builtins.str]] = None,
            rewrite_query_string_type: Optional[pulumi.Input[_builtins.str]] = None,
            rewrite_uri_type: Optional[pulumi.Input[_builtins.str]] = None,
            rule: Optional[pulumi.Input[_builtins.str]] = None,
            rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
            rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            site_version: Optional[pulumi.Input[_builtins.int]] = None,
            uri: Optional[pulumi.Input[_builtins.str]] = None) -> 'RewriteUrlRule':
        """
        Get an existing RewriteUrlRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_id: ConfigId
        :param pulumi.Input[_builtins.str] query_string: The desired query string to which you want to rewrite the query string in the original request.
        :param pulumi.Input[_builtins.str] rewrite_query_string_type: Query string rewrite type. Value range:
        :param pulumi.Input[_builtins.str] rewrite_uri_type: URI rewrite type. Value range:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               ● Match all incoming requests: value set to true
               ● Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Indicates whether the rule is enabled. Valid values:
               
               - on
               - off
        :param pulumi.Input[_builtins.str] rule_name: The rule name. You do not need to set this parameter when adding a global configuration.
        :param pulumi.Input[_builtins.int] site_id: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.int] site_version: Version number of the site configuration. For a site with configuration version management enabled, you can use this parameter to specify the site version in which the configuration takes effect. The default version is 0.
        :param pulumi.Input[_builtins.str] uri: The desired URI to which you want to rewrite the path in the original request.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RewriteUrlRuleState.__new__(_RewriteUrlRuleState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["query_string"] = query_string
        __props__.__dict__["rewrite_query_string_type"] = rewrite_query_string_type
        __props__.__dict__["rewrite_uri_type"] = rewrite_uri_type
        __props__.__dict__["rule"] = rule
        __props__.__dict__["rule_enable"] = rule_enable
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["site_version"] = site_version
        __props__.__dict__["uri"] = uri
        return RewriteUrlRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        ConfigId
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="queryString")
    def query_string(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The desired query string to which you want to rewrite the query string in the original request.
        """
        return pulumi.get(self, "query_string")

    @_builtins.property
    @pulumi.getter(name="rewriteQueryStringType")
    def rewrite_query_string_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Query string rewrite type. Value range:
        """
        return pulumi.get(self, "rewrite_query_string_type")

    @_builtins.property
    @pulumi.getter(name="rewriteUriType")
    def rewrite_uri_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URI rewrite type. Value range:
        """
        return pulumi.get(self, "rewrite_uri_type")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        ● Match all incoming requests: value set to true
        ● Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates whether the rule is enabled. Valid values:

        - on
        - off
        """
        return pulumi.get(self, "rule_enable")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The rule name. You do not need to set this parameter when adding a global configuration.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Version number of the site configuration. For a site with configuration version management enabled, you can use this parameter to specify the site version in which the configuration takes effect. The default version is 0.
        """
        return pulumi.get(self, "site_version")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The desired URI to which you want to rewrite the path in the original request.
        """
        return pulumi.get(self, "uri")

