# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetScalingConfigurationsResult',
    'AwaitableGetScalingConfigurationsResult',
    'get_scaling_configurations',
    'get_scaling_configurations_output',
]

@pulumi.output_type
class GetScalingConfigurationsResult:
    """
    A collection of values returned by getScalingConfigurations.
    """
    def __init__(__self__, configurations=None, id=None, ids=None, name_regex=None, names=None, output_file=None, scaling_group_id=None):
        if configurations and not isinstance(configurations, list):
            raise TypeError("Expected argument 'configurations' to be a list")
        pulumi.set(__self__, "configurations", configurations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if scaling_group_id and not isinstance(scaling_group_id, str):
            raise TypeError("Expected argument 'scaling_group_id' to be a str")
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetScalingConfigurationsConfigurationResult']:
        """
        A list of scaling rules. Each element contains the following attributes:
        """
        return pulumi.get(self, "configurations")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of scaling configuration ids.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of scaling configuration names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[_builtins.str]:
        """
        ID of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")


class AwaitableGetScalingConfigurationsResult(GetScalingConfigurationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScalingConfigurationsResult(
            configurations=self.configurations,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            scaling_group_id=self.scaling_group_id)


def get_scaling_configurations(ids: Optional[Sequence[_builtins.str]] = None,
                               name_regex: Optional[_builtins.str] = None,
                               output_file: Optional[_builtins.str] = None,
                               scaling_group_id: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScalingConfigurationsResult:
    """
    This data source provides available scaling configuration resources.

    > **NOTE:** Available since v1.240.0

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_random as random

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default_integer = random.index.Integer("default",
        min=10000,
        max=99999)
    my_name = f"{name}-{default_integer['result']}"
    default = alicloud.get_zones(available_disk_category="cloud_efficiency",
        available_resource_creation="VSwitch")
    default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
        cpu_core_count=2,
        memory_size=4)
    default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
        most_recent=True,
        owners="system")
    default_network = alicloud.vpc.Network("default",
        vpc_name=my_name,
        cidr_block="172.16.0.0/16")
    default_switch = alicloud.vpc.Switch("default",
        vpc_id=default_network.id,
        cidr_block="172.16.0.0/24",
        zone_id=default.zones[0].id,
        vswitch_name=my_name)
    default_security_group = alicloud.ecs.SecurityGroup("default",
        security_group_name=my_name,
        vpc_id=default_network.id)
    default_security_group_rule = alicloud.ecs.SecurityGroupRule("default",
        type="ingress",
        ip_protocol="tcp",
        nic_type="intranet",
        policy="accept",
        port_range="22/22",
        priority=1,
        security_group_id=default_security_group.id,
        cidr_ip="172.16.0.0/24")
    default_scaling_group = alicloud.ess.ScalingGroup("default",
        min_size=1,
        max_size=1,
        scaling_group_name=my_name,
        removal_policies=[
            "OldestInstance",
            "NewestInstance",
        ],
        vswitch_ids=[default_switch.id])
    default_scaling_configuration = alicloud.ess.ScalingConfiguration("default",
        scaling_group_id=default_scaling_group.id,
        image_id=default_get_images.images[0].id,
        instance_type=default_get_instance_types.instance_types[0].id,
        security_group_id=default_security_group.id,
        force_delete=True,
        active=True,
        scaling_configuration_name="scaling_configuration_name")
    scalingconfigurations_ds = alicloud.ess.get_scaling_configurations_output(scaling_group_id=default_scaling_group.id,
        ids=[default_scaling_configuration.id],
        name_regex="scaling_configuration_name")
    pulumi.export("firstScalingConfiguration", scalingconfigurations_ds.configurations[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of scaling configuration IDs.
    :param _builtins.str name_regex: A regex string to filter resulting scaling configurations by name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str scaling_group_id: Scaling group id the scaling configurations belong to.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['scalingGroupId'] = scaling_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ess/getScalingConfigurations:getScalingConfigurations', __args__, opts=opts, typ=GetScalingConfigurationsResult).value

    return AwaitableGetScalingConfigurationsResult(
        configurations=pulumi.get(__ret__, 'configurations'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        scaling_group_id=pulumi.get(__ret__, 'scaling_group_id'))
def get_scaling_configurations_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                      name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      scaling_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetScalingConfigurationsResult]:
    """
    This data source provides available scaling configuration resources.

    > **NOTE:** Available since v1.240.0

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_random as random

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default_integer = random.index.Integer("default",
        min=10000,
        max=99999)
    my_name = f"{name}-{default_integer['result']}"
    default = alicloud.get_zones(available_disk_category="cloud_efficiency",
        available_resource_creation="VSwitch")
    default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
        cpu_core_count=2,
        memory_size=4)
    default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
        most_recent=True,
        owners="system")
    default_network = alicloud.vpc.Network("default",
        vpc_name=my_name,
        cidr_block="172.16.0.0/16")
    default_switch = alicloud.vpc.Switch("default",
        vpc_id=default_network.id,
        cidr_block="172.16.0.0/24",
        zone_id=default.zones[0].id,
        vswitch_name=my_name)
    default_security_group = alicloud.ecs.SecurityGroup("default",
        security_group_name=my_name,
        vpc_id=default_network.id)
    default_security_group_rule = alicloud.ecs.SecurityGroupRule("default",
        type="ingress",
        ip_protocol="tcp",
        nic_type="intranet",
        policy="accept",
        port_range="22/22",
        priority=1,
        security_group_id=default_security_group.id,
        cidr_ip="172.16.0.0/24")
    default_scaling_group = alicloud.ess.ScalingGroup("default",
        min_size=1,
        max_size=1,
        scaling_group_name=my_name,
        removal_policies=[
            "OldestInstance",
            "NewestInstance",
        ],
        vswitch_ids=[default_switch.id])
    default_scaling_configuration = alicloud.ess.ScalingConfiguration("default",
        scaling_group_id=default_scaling_group.id,
        image_id=default_get_images.images[0].id,
        instance_type=default_get_instance_types.instance_types[0].id,
        security_group_id=default_security_group.id,
        force_delete=True,
        active=True,
        scaling_configuration_name="scaling_configuration_name")
    scalingconfigurations_ds = alicloud.ess.get_scaling_configurations_output(scaling_group_id=default_scaling_group.id,
        ids=[default_scaling_configuration.id],
        name_regex="scaling_configuration_name")
    pulumi.export("firstScalingConfiguration", scalingconfigurations_ds.configurations[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of scaling configuration IDs.
    :param _builtins.str name_regex: A regex string to filter resulting scaling configurations by name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str scaling_group_id: Scaling group id the scaling configurations belong to.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['scalingGroupId'] = scaling_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ess/getScalingConfigurations:getScalingConfigurations', __args__, opts=opts, typ=GetScalingConfigurationsResult)
    return __ret__.apply(lambda __response__: GetScalingConfigurationsResult(
        configurations=pulumi.get(__response__, 'configurations'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        scaling_group_id=pulumi.get(__response__, 'scaling_group_id')))
