# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouterInterfaceArgs', 'RouterInterface']

@pulumi.input_type
class RouterInterfaceArgs:
    def __init__(__self__, *,
                 opposite_region_id: pulumi.Input[_builtins.str],
                 role: pulumi.Input[_builtins.str],
                 router_id: pulumi.Input[_builtins.str],
                 router_type: pulumi.Input[_builtins.str],
                 spec: pulumi.Input[_builtins.str],
                 access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_health_check_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 hc_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 hc_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_source_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_target_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_interface_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_router_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 router_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 router_interface_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RouterInterface resource.
        :param pulumi.Input[_builtins.str] opposite_region_id: The geographical ID of the location of the receiving end of the connection.
        :param pulumi.Input[_builtins.str] role: The role of the router interface. Valid Values: `InitiatingSide`, `AcceptingSide`.
        :param pulumi.Input[_builtins.str] router_id: The router id associated with the router interface.
        :param pulumi.Input[_builtins.str] router_type: The type of router associated with the router interface. Valid Values: `VRouter`, `VBR`.
        :param pulumi.Input[_builtins.str] spec: The specification of the router interface. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
        :param pulumi.Input[_builtins.str] access_point_id: The access point ID to which the VBR belongs.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically, value:-**false** (default): automatic payment is not enabled. After generating an order, you need to complete the payment at the order center.-**true**: Enable automatic payment to automatically pay for orders.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        :param pulumi.Input[_builtins.bool] delete_health_check_ip: Whether to delete the health check IP address configured on the router interface. Value:-**true**: deletes the health check IP address.-**false** (default): does not delete the health check IP address.
        :param pulumi.Input[_builtins.str] description: The description of the router interface. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.int] hc_rate: The health check rate. Unit: seconds. The recommended value is 2. This indicates the interval between successive probe messages sent during the specified health check.
        :param pulumi.Input[_builtins.str] hc_threshold: The health check thresholds. Unit: pcs. The recommended value is 8. This indicates the number of probe messages to be sent during the specified health check.
        :param pulumi.Input[_builtins.str] health_check_source_ip: The health check source IP address, must be an unused IP within the local VPC.
        :param pulumi.Input[_builtins.str] health_check_target_ip: The IP address for health screening purposes.
        :param pulumi.Input[_builtins.str] opposite_access_point_id: The Access point ID to which the other end belongs.
        :param pulumi.Input[_builtins.str] opposite_interface_id: The Interface ID of the router at the other end.
        :param pulumi.Input[_builtins.str] opposite_interface_owner_id: The AliCloud account ID of the owner of the router interface on the other end.
        :param pulumi.Input[_builtins.str] opposite_router_id: The id of the router at the other end.
        :param pulumi.Input[_builtins.str] opposite_router_type: The opposite router type of the router on the other side. Valid Values: `VRouter`, `VBR`.
        :param pulumi.Input[_builtins.str] payment_type: The payment methods for router interfaces. Valid Values: `PayAsYouGo`, `Subscription`.
        :param pulumi.Input[_builtins.int] period: Purchase duration, value:-When you choose to pay on a monthly basis, the value range is **1 to 9 * *.-When you choose to pay per year, the value range is **1 to 3 * *.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the prepaid fee. Valid values:-**Month** (default): monthly payment.-**Year**: Pay per Year.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        :param pulumi.Input[_builtins.str] router_interface_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] router_interface_name: The name of the resource.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
        """
        pulumi.set(__self__, "opposite_region_id", opposite_region_id)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "router_id", router_id)
        pulumi.set(__self__, "router_type", router_type)
        pulumi.set(__self__, "spec", spec)
        if access_point_id is not None:
            pulumi.set(__self__, "access_point_id", access_point_id)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if delete_health_check_ip is not None:
            pulumi.set(__self__, "delete_health_check_ip", delete_health_check_ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hc_rate is not None:
            pulumi.set(__self__, "hc_rate", hc_rate)
        if hc_threshold is not None:
            pulumi.set(__self__, "hc_threshold", hc_threshold)
        if health_check_source_ip is not None:
            pulumi.set(__self__, "health_check_source_ip", health_check_source_ip)
        if health_check_target_ip is not None:
            pulumi.set(__self__, "health_check_target_ip", health_check_target_ip)
        if opposite_access_point_id is not None:
            pulumi.set(__self__, "opposite_access_point_id", opposite_access_point_id)
        if opposite_interface_id is not None:
            pulumi.set(__self__, "opposite_interface_id", opposite_interface_id)
        if opposite_interface_owner_id is not None:
            pulumi.set(__self__, "opposite_interface_owner_id", opposite_interface_owner_id)
        if opposite_router_id is not None:
            pulumi.set(__self__, "opposite_router_id", opposite_router_id)
        if opposite_router_type is not None:
            pulumi.set(__self__, "opposite_router_type", opposite_router_type)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if router_interface_id is not None:
            pulumi.set(__self__, "router_interface_id", router_interface_id)
        if router_interface_name is not None:
            pulumi.set(__self__, "router_interface_name", router_interface_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="oppositeRegionId")
    def opposite_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The geographical ID of the location of the receiving end of the connection.
        """
        return pulumi.get(self, "opposite_region_id")

    @opposite_region_id.setter
    def opposite_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "opposite_region_id", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        The role of the router interface. Valid Values: `InitiatingSide`, `AcceptingSide`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="routerId")
    def router_id(self) -> pulumi.Input[_builtins.str]:
        """
        The router id associated with the router interface.
        """
        return pulumi.get(self, "router_id")

    @router_id.setter
    def router_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "router_id", value)

    @_builtins.property
    @pulumi.getter(name="routerType")
    def router_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of router associated with the router interface. Valid Values: `VRouter`, `VBR`.
        """
        return pulumi.get(self, "router_type")

    @router_type.setter
    def router_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "router_type", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> pulumi.Input[_builtins.str]:
        """
        The specification of the router interface. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access point ID to which the VBR belongs.
        """
        return pulumi.get(self, "access_point_id")

    @access_point_id.setter
    def access_point_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_point_id", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to pay automatically, value:-**false** (default): automatic payment is not enabled. After generating an order, you need to complete the payment at the order center.-**true**: Enable automatic payment to automatically pay for orders.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="deleteHealthCheckIp")
    def delete_health_check_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to delete the health check IP address configured on the router interface. Value:-**true**: deletes the health check IP address.-**false** (default): does not delete the health check IP address.
        """
        return pulumi.get(self, "delete_health_check_ip")

    @delete_health_check_ip.setter
    def delete_health_check_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_health_check_ip", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the router interface. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="hcRate")
    def hc_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The health check rate. Unit: seconds. The recommended value is 2. This indicates the interval between successive probe messages sent during the specified health check.
        """
        return pulumi.get(self, "hc_rate")

    @hc_rate.setter
    def hc_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hc_rate", value)

    @_builtins.property
    @pulumi.getter(name="hcThreshold")
    def hc_threshold(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The health check thresholds. Unit: pcs. The recommended value is 8. This indicates the number of probe messages to be sent during the specified health check.
        """
        return pulumi.get(self, "hc_threshold")

    @hc_threshold.setter
    def hc_threshold(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hc_threshold", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckSourceIp")
    def health_check_source_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The health check source IP address, must be an unused IP within the local VPC.
        """
        return pulumi.get(self, "health_check_source_ip")

    @health_check_source_ip.setter
    def health_check_source_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_source_ip", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckTargetIp")
    def health_check_target_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address for health screening purposes.
        """
        return pulumi.get(self, "health_check_target_ip")

    @health_check_target_ip.setter
    def health_check_target_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_target_ip", value)

    @_builtins.property
    @pulumi.getter(name="oppositeAccessPointId")
    def opposite_access_point_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Access point ID to which the other end belongs.
        """
        return pulumi.get(self, "opposite_access_point_id")

    @opposite_access_point_id.setter
    def opposite_access_point_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_access_point_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceId")
    def opposite_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Interface ID of the router at the other end.
        """
        return pulumi.get(self, "opposite_interface_id")

    @opposite_interface_id.setter
    def opposite_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceOwnerId")
    def opposite_interface_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AliCloud account ID of the owner of the router interface on the other end.
        """
        return pulumi.get(self, "opposite_interface_owner_id")

    @opposite_interface_owner_id.setter
    def opposite_interface_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_interface_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeRouterId")
    def opposite_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the router at the other end.
        """
        return pulumi.get(self, "opposite_router_id")

    @opposite_router_id.setter
    def opposite_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_router_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeRouterType")
    def opposite_router_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The opposite router type of the router on the other side. Valid Values: `VRouter`, `VBR`.
        """
        return pulumi.get(self, "opposite_router_type")

    @opposite_router_type.setter
    def opposite_router_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_router_type", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment methods for router interfaces. Valid Values: `PayAsYouGo`, `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Purchase duration, value:-When you choose to pay on a monthly basis, the value range is **1 to 9 * *.-When you choose to pay per year, the value range is **1 to 3 * *.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing cycle of the prepaid fee. Valid values:-**Month** (default): monthly payment.-**Year**: Pay per Year.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="routerInterfaceId")
    def router_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "router_interface_id")

    @router_interface_id.setter
    def router_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "router_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="routerInterfaceName")
    def router_interface_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "router_interface_name")

    @router_interface_name.setter
    def router_interface_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "router_interface_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _RouterInterfaceState:
    def __init__(__self__, *,
                 access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 business_status: Optional[pulumi.Input[_builtins.str]] = None,
                 connected_time: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_border: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_health_check_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 has_reservation_data: Optional[pulumi.Input[_builtins.str]] = None,
                 hc_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 hc_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_source_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_target_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 opposite_interface_business_status: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_interface_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_interface_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_interface_status: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_router_type: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_vpc_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_active_time: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_order_type: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 router_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 router_interface_name: Optional[pulumi.Input[_builtins.str]] = None,
                 router_type: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_instance_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RouterInterface resources.
        :param pulumi.Input[_builtins.str] access_point_id: The access point ID to which the VBR belongs.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically, value:-**false** (default): automatic payment is not enabled. After generating an order, you need to complete the payment at the order center.-**true**: Enable automatic payment to automatically pay for orders.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth of the resource.
        :param pulumi.Input[_builtins.str] business_status: The businessStatus of the resource. Valid Values: `Normal`, `FinancialLocked`, `SecurityLocked`.
        :param pulumi.Input[_builtins.str] connected_time: The connected time of the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.bool] cross_border: The cross border of the resource.
        :param pulumi.Input[_builtins.bool] delete_health_check_ip: Whether to delete the health check IP address configured on the router interface. Value:-**true**: deletes the health check IP address.-**false** (default): does not delete the health check IP address.
        :param pulumi.Input[_builtins.str] description: The description of the router interface. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] end_time: The end time of the resource.
        :param pulumi.Input[_builtins.str] has_reservation_data: The has reservation data of the resource.
        :param pulumi.Input[_builtins.int] hc_rate: The health check rate. Unit: seconds. The recommended value is 2. This indicates the interval between successive probe messages sent during the specified health check.
        :param pulumi.Input[_builtins.str] hc_threshold: The health check thresholds. Unit: pcs. The recommended value is 8. This indicates the number of probe messages to be sent during the specified health check.
        :param pulumi.Input[_builtins.str] health_check_source_ip: The health check source IP address, must be an unused IP within the local VPC.
        :param pulumi.Input[_builtins.str] health_check_target_ip: The IP address for health screening purposes.
        :param pulumi.Input[_builtins.str] opposite_access_point_id: The Access point ID to which the other end belongs.
        :param pulumi.Input[_builtins.int] opposite_bandwidth: The opposite bandwidth of the router on the other side.
        :param pulumi.Input[_builtins.str] opposite_interface_business_status: The opposite interface business status of the router on the other side. Valid Values: `Normal`, `FinancialLocked`, `SecurityLocked`.
        :param pulumi.Input[_builtins.str] opposite_interface_id: The Interface ID of the router at the other end.
        :param pulumi.Input[_builtins.str] opposite_interface_owner_id: The AliCloud account ID of the owner of the router interface on the other end.
        :param pulumi.Input[_builtins.str] opposite_interface_spec: The opposite interface spec of the router on the other side. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
        :param pulumi.Input[_builtins.str] opposite_interface_status: The opposite interface status of the router on the other side. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
        :param pulumi.Input[_builtins.str] opposite_region_id: The geographical ID of the location of the receiving end of the connection.
        :param pulumi.Input[_builtins.str] opposite_router_id: The id of the router at the other end.
        :param pulumi.Input[_builtins.str] opposite_router_type: The opposite router type of the router on the other side. Valid Values: `VRouter`, `VBR`.
        :param pulumi.Input[_builtins.str] opposite_vpc_instance_id: The opposite vpc instance id of the router on the other side.
        :param pulumi.Input[_builtins.str] payment_type: The payment methods for router interfaces. Valid Values: `PayAsYouGo`, `Subscription`.
        :param pulumi.Input[_builtins.int] period: Purchase duration, value:-When you choose to pay on a monthly basis, the value range is **1 to 9 * *.-When you choose to pay per year, the value range is **1 to 3 * *.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the prepaid fee. Valid values:-**Month** (default): monthly payment.-**Year**: Pay per Year.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        :param pulumi.Input[_builtins.str] reservation_active_time: The reservation active time of the resource.
        :param pulumi.Input[_builtins.str] reservation_bandwidth: The reservation bandwidth of the resource.
        :param pulumi.Input[_builtins.str] reservation_internet_charge_type: The reservation internet charge type of the resource.
        :param pulumi.Input[_builtins.str] reservation_order_type: The reservation order type of the resource.
        :param pulumi.Input[_builtins.str] role: The role of the router interface. Valid Values: `InitiatingSide`, `AcceptingSide`.
        :param pulumi.Input[_builtins.str] router_id: The router id associated with the router interface.
        :param pulumi.Input[_builtins.str] router_interface_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] router_interface_name: The name of the resource.
        :param pulumi.Input[_builtins.str] router_type: The type of router associated with the router interface. Valid Values: `VRouter`, `VBR`.
        :param pulumi.Input[_builtins.str] spec: The specification of the router interface. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
        :param pulumi.Input[_builtins.str] vpc_instance_id: The vpc instance id of the resource.
        """
        if access_point_id is not None:
            pulumi.set(__self__, "access_point_id", access_point_id)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if business_status is not None:
            pulumi.set(__self__, "business_status", business_status)
        if connected_time is not None:
            pulumi.set(__self__, "connected_time", connected_time)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if cross_border is not None:
            pulumi.set(__self__, "cross_border", cross_border)
        if delete_health_check_ip is not None:
            pulumi.set(__self__, "delete_health_check_ip", delete_health_check_ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if has_reservation_data is not None:
            pulumi.set(__self__, "has_reservation_data", has_reservation_data)
        if hc_rate is not None:
            pulumi.set(__self__, "hc_rate", hc_rate)
        if hc_threshold is not None:
            pulumi.set(__self__, "hc_threshold", hc_threshold)
        if health_check_source_ip is not None:
            pulumi.set(__self__, "health_check_source_ip", health_check_source_ip)
        if health_check_target_ip is not None:
            pulumi.set(__self__, "health_check_target_ip", health_check_target_ip)
        if opposite_access_point_id is not None:
            pulumi.set(__self__, "opposite_access_point_id", opposite_access_point_id)
        if opposite_bandwidth is not None:
            pulumi.set(__self__, "opposite_bandwidth", opposite_bandwidth)
        if opposite_interface_business_status is not None:
            pulumi.set(__self__, "opposite_interface_business_status", opposite_interface_business_status)
        if opposite_interface_id is not None:
            pulumi.set(__self__, "opposite_interface_id", opposite_interface_id)
        if opposite_interface_owner_id is not None:
            pulumi.set(__self__, "opposite_interface_owner_id", opposite_interface_owner_id)
        if opposite_interface_spec is not None:
            pulumi.set(__self__, "opposite_interface_spec", opposite_interface_spec)
        if opposite_interface_status is not None:
            pulumi.set(__self__, "opposite_interface_status", opposite_interface_status)
        if opposite_region_id is not None:
            pulumi.set(__self__, "opposite_region_id", opposite_region_id)
        if opposite_router_id is not None:
            pulumi.set(__self__, "opposite_router_id", opposite_router_id)
        if opposite_router_type is not None:
            pulumi.set(__self__, "opposite_router_type", opposite_router_type)
        if opposite_vpc_instance_id is not None:
            pulumi.set(__self__, "opposite_vpc_instance_id", opposite_vpc_instance_id)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if reservation_active_time is not None:
            pulumi.set(__self__, "reservation_active_time", reservation_active_time)
        if reservation_bandwidth is not None:
            pulumi.set(__self__, "reservation_bandwidth", reservation_bandwidth)
        if reservation_internet_charge_type is not None:
            pulumi.set(__self__, "reservation_internet_charge_type", reservation_internet_charge_type)
        if reservation_order_type is not None:
            pulumi.set(__self__, "reservation_order_type", reservation_order_type)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if router_id is not None:
            pulumi.set(__self__, "router_id", router_id)
        if router_interface_id is not None:
            pulumi.set(__self__, "router_interface_id", router_interface_id)
        if router_interface_name is not None:
            pulumi.set(__self__, "router_interface_name", router_interface_name)
        if router_type is not None:
            pulumi.set(__self__, "router_type", router_type)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_instance_id is not None:
            pulumi.set(__self__, "vpc_instance_id", vpc_instance_id)

    @_builtins.property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access point ID to which the VBR belongs.
        """
        return pulumi.get(self, "access_point_id")

    @access_point_id.setter
    def access_point_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_point_id", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to pay automatically, value:-**false** (default): automatic payment is not enabled. After generating an order, you need to complete the payment at the order center.-**true**: Enable automatic payment to automatically pay for orders.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth of the resource.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The businessStatus of the resource. Valid Values: `Normal`, `FinancialLocked`, `SecurityLocked`.
        """
        return pulumi.get(self, "business_status")

    @business_status.setter
    def business_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "business_status", value)

    @_builtins.property
    @pulumi.getter(name="connectedTime")
    def connected_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connected time of the resource.
        """
        return pulumi.get(self, "connected_time")

    @connected_time.setter
    def connected_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connected_time", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="crossBorder")
    def cross_border(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The cross border of the resource.
        """
        return pulumi.get(self, "cross_border")

    @cross_border.setter
    def cross_border(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cross_border", value)

    @_builtins.property
    @pulumi.getter(name="deleteHealthCheckIp")
    def delete_health_check_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to delete the health check IP address configured on the router interface. Value:-**true**: deletes the health check IP address.-**false** (default): does not delete the health check IP address.
        """
        return pulumi.get(self, "delete_health_check_ip")

    @delete_health_check_ip.setter
    def delete_health_check_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_health_check_ip", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the router interface. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end time of the resource.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="hasReservationData")
    def has_reservation_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The has reservation data of the resource.
        """
        return pulumi.get(self, "has_reservation_data")

    @has_reservation_data.setter
    def has_reservation_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "has_reservation_data", value)

    @_builtins.property
    @pulumi.getter(name="hcRate")
    def hc_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The health check rate. Unit: seconds. The recommended value is 2. This indicates the interval between successive probe messages sent during the specified health check.
        """
        return pulumi.get(self, "hc_rate")

    @hc_rate.setter
    def hc_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hc_rate", value)

    @_builtins.property
    @pulumi.getter(name="hcThreshold")
    def hc_threshold(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The health check thresholds. Unit: pcs. The recommended value is 8. This indicates the number of probe messages to be sent during the specified health check.
        """
        return pulumi.get(self, "hc_threshold")

    @hc_threshold.setter
    def hc_threshold(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hc_threshold", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckSourceIp")
    def health_check_source_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The health check source IP address, must be an unused IP within the local VPC.
        """
        return pulumi.get(self, "health_check_source_ip")

    @health_check_source_ip.setter
    def health_check_source_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_source_ip", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckTargetIp")
    def health_check_target_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address for health screening purposes.
        """
        return pulumi.get(self, "health_check_target_ip")

    @health_check_target_ip.setter
    def health_check_target_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_target_ip", value)

    @_builtins.property
    @pulumi.getter(name="oppositeAccessPointId")
    def opposite_access_point_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Access point ID to which the other end belongs.
        """
        return pulumi.get(self, "opposite_access_point_id")

    @opposite_access_point_id.setter
    def opposite_access_point_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_access_point_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeBandwidth")
    def opposite_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The opposite bandwidth of the router on the other side.
        """
        return pulumi.get(self, "opposite_bandwidth")

    @opposite_bandwidth.setter
    def opposite_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "opposite_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceBusinessStatus")
    def opposite_interface_business_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The opposite interface business status of the router on the other side. Valid Values: `Normal`, `FinancialLocked`, `SecurityLocked`.
        """
        return pulumi.get(self, "opposite_interface_business_status")

    @opposite_interface_business_status.setter
    def opposite_interface_business_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_interface_business_status", value)

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceId")
    def opposite_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Interface ID of the router at the other end.
        """
        return pulumi.get(self, "opposite_interface_id")

    @opposite_interface_id.setter
    def opposite_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceOwnerId")
    def opposite_interface_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AliCloud account ID of the owner of the router interface on the other end.
        """
        return pulumi.get(self, "opposite_interface_owner_id")

    @opposite_interface_owner_id.setter
    def opposite_interface_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_interface_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceSpec")
    def opposite_interface_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The opposite interface spec of the router on the other side. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
        """
        return pulumi.get(self, "opposite_interface_spec")

    @opposite_interface_spec.setter
    def opposite_interface_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_interface_spec", value)

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceStatus")
    def opposite_interface_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The opposite interface status of the router on the other side. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
        """
        return pulumi.get(self, "opposite_interface_status")

    @opposite_interface_status.setter
    def opposite_interface_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_interface_status", value)

    @_builtins.property
    @pulumi.getter(name="oppositeRegionId")
    def opposite_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The geographical ID of the location of the receiving end of the connection.
        """
        return pulumi.get(self, "opposite_region_id")

    @opposite_region_id.setter
    def opposite_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_region_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeRouterId")
    def opposite_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the router at the other end.
        """
        return pulumi.get(self, "opposite_router_id")

    @opposite_router_id.setter
    def opposite_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_router_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeRouterType")
    def opposite_router_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The opposite router type of the router on the other side. Valid Values: `VRouter`, `VBR`.
        """
        return pulumi.get(self, "opposite_router_type")

    @opposite_router_type.setter
    def opposite_router_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_router_type", value)

    @_builtins.property
    @pulumi.getter(name="oppositeVpcInstanceId")
    def opposite_vpc_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The opposite vpc instance id of the router on the other side.
        """
        return pulumi.get(self, "opposite_vpc_instance_id")

    @opposite_vpc_instance_id.setter
    def opposite_vpc_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_vpc_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment methods for router interfaces. Valid Values: `PayAsYouGo`, `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Purchase duration, value:-When you choose to pay on a monthly basis, the value range is **1 to 9 * *.-When you choose to pay per year, the value range is **1 to 3 * *.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing cycle of the prepaid fee. Valid values:-**Month** (default): monthly payment.-**Year**: Pay per Year.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="reservationActiveTime")
    def reservation_active_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reservation active time of the resource.
        """
        return pulumi.get(self, "reservation_active_time")

    @reservation_active_time.setter
    def reservation_active_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reservation_active_time", value)

    @_builtins.property
    @pulumi.getter(name="reservationBandwidth")
    def reservation_bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reservation bandwidth of the resource.
        """
        return pulumi.get(self, "reservation_bandwidth")

    @reservation_bandwidth.setter
    def reservation_bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reservation_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="reservationInternetChargeType")
    def reservation_internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reservation internet charge type of the resource.
        """
        return pulumi.get(self, "reservation_internet_charge_type")

    @reservation_internet_charge_type.setter
    def reservation_internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reservation_internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="reservationOrderType")
    def reservation_order_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reservation order type of the resource.
        """
        return pulumi.get(self, "reservation_order_type")

    @reservation_order_type.setter
    def reservation_order_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reservation_order_type", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role of the router interface. Valid Values: `InitiatingSide`, `AcceptingSide`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="routerId")
    def router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The router id associated with the router interface.
        """
        return pulumi.get(self, "router_id")

    @router_id.setter
    def router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "router_id", value)

    @_builtins.property
    @pulumi.getter(name="routerInterfaceId")
    def router_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "router_interface_id")

    @router_interface_id.setter
    def router_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "router_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="routerInterfaceName")
    def router_interface_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "router_interface_name")

    @router_interface_name.setter
    def router_interface_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "router_interface_name", value)

    @_builtins.property
    @pulumi.getter(name="routerType")
    def router_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of router associated with the router interface. Valid Values: `VRouter`, `VBR`.
        """
        return pulumi.get(self, "router_type")

    @router_type.setter
    def router_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "router_type", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specification of the router interface. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpcInstanceId")
    def vpc_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vpc instance id of the resource.
        """
        return pulumi.get(self, "vpc_instance_id")

    @vpc_instance_id.setter
    def vpc_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_instance_id", value)


@pulumi.type_token("alicloud:expressconnect/routerInterface:RouterInterface")
class RouterInterface(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_health_check_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 hc_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 hc_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_source_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_target_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_interface_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_router_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 router_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 router_interface_name: Optional[pulumi.Input[_builtins.str]] = None,
                 router_type: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Express Connect Router Interface resource.

        For information about Express Connect Router Interface and how to use it, see What is Router Interface.

        > **NOTE:** Available since v1.199.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.vpc.get_networks(name_regex="default-NODELETING")
        default_get_regions = alicloud.get_regions(current=True)
        default_router_interface = alicloud.expressconnect.RouterInterface("default",
            description=name,
            opposite_region_id=default_get_regions.regions[0].id,
            router_id=default.vpcs[0].router_id,
            role="InitiatingSide",
            router_type="VRouter",
            payment_type="PayAsYouGo",
            router_interface_name=name,
            spec="Mini.2")
        ```

        ## Import

        Express Connect Router Interface can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/routerInterface:RouterInterface example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_point_id: The access point ID to which the VBR belongs.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically, value:-**false** (default): automatic payment is not enabled. After generating an order, you need to complete the payment at the order center.-**true**: Enable automatic payment to automatically pay for orders.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        :param pulumi.Input[_builtins.bool] delete_health_check_ip: Whether to delete the health check IP address configured on the router interface. Value:-**true**: deletes the health check IP address.-**false** (default): does not delete the health check IP address.
        :param pulumi.Input[_builtins.str] description: The description of the router interface. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.int] hc_rate: The health check rate. Unit: seconds. The recommended value is 2. This indicates the interval between successive probe messages sent during the specified health check.
        :param pulumi.Input[_builtins.str] hc_threshold: The health check thresholds. Unit: pcs. The recommended value is 8. This indicates the number of probe messages to be sent during the specified health check.
        :param pulumi.Input[_builtins.str] health_check_source_ip: The health check source IP address, must be an unused IP within the local VPC.
        :param pulumi.Input[_builtins.str] health_check_target_ip: The IP address for health screening purposes.
        :param pulumi.Input[_builtins.str] opposite_access_point_id: The Access point ID to which the other end belongs.
        :param pulumi.Input[_builtins.str] opposite_interface_id: The Interface ID of the router at the other end.
        :param pulumi.Input[_builtins.str] opposite_interface_owner_id: The AliCloud account ID of the owner of the router interface on the other end.
        :param pulumi.Input[_builtins.str] opposite_region_id: The geographical ID of the location of the receiving end of the connection.
        :param pulumi.Input[_builtins.str] opposite_router_id: The id of the router at the other end.
        :param pulumi.Input[_builtins.str] opposite_router_type: The opposite router type of the router on the other side. Valid Values: `VRouter`, `VBR`.
        :param pulumi.Input[_builtins.str] payment_type: The payment methods for router interfaces. Valid Values: `PayAsYouGo`, `Subscription`.
        :param pulumi.Input[_builtins.int] period: Purchase duration, value:-When you choose to pay on a monthly basis, the value range is **1 to 9 * *.-When you choose to pay per year, the value range is **1 to 3 * *.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the prepaid fee. Valid values:-**Month** (default): monthly payment.-**Year**: Pay per Year.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        :param pulumi.Input[_builtins.str] role: The role of the router interface. Valid Values: `InitiatingSide`, `AcceptingSide`.
        :param pulumi.Input[_builtins.str] router_id: The router id associated with the router interface.
        :param pulumi.Input[_builtins.str] router_interface_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] router_interface_name: The name of the resource.
        :param pulumi.Input[_builtins.str] router_type: The type of router associated with the router interface. Valid Values: `VRouter`, `VBR`.
        :param pulumi.Input[_builtins.str] spec: The specification of the router interface. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouterInterfaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Express Connect Router Interface resource.

        For information about Express Connect Router Interface and how to use it, see What is Router Interface.

        > **NOTE:** Available since v1.199.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.vpc.get_networks(name_regex="default-NODELETING")
        default_get_regions = alicloud.get_regions(current=True)
        default_router_interface = alicloud.expressconnect.RouterInterface("default",
            description=name,
            opposite_region_id=default_get_regions.regions[0].id,
            router_id=default.vpcs[0].router_id,
            role="InitiatingSide",
            router_type="VRouter",
            payment_type="PayAsYouGo",
            router_interface_name=name,
            spec="Mini.2")
        ```

        ## Import

        Express Connect Router Interface can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/routerInterface:RouterInterface example <id>
        ```

        :param str resource_name: The name of the resource.
        :param RouterInterfaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouterInterfaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_health_check_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 hc_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 hc_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_source_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_target_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_interface_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_router_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 router_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 router_interface_name: Optional[pulumi.Input[_builtins.str]] = None,
                 router_type: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouterInterfaceArgs.__new__(RouterInterfaceArgs)

            __props__.__dict__["access_point_id"] = access_point_id
            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["delete_health_check_ip"] = delete_health_check_ip
            __props__.__dict__["description"] = description
            __props__.__dict__["hc_rate"] = hc_rate
            __props__.__dict__["hc_threshold"] = hc_threshold
            __props__.__dict__["health_check_source_ip"] = health_check_source_ip
            __props__.__dict__["health_check_target_ip"] = health_check_target_ip
            __props__.__dict__["opposite_access_point_id"] = opposite_access_point_id
            __props__.__dict__["opposite_interface_id"] = opposite_interface_id
            __props__.__dict__["opposite_interface_owner_id"] = opposite_interface_owner_id
            if opposite_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'opposite_region_id'")
            __props__.__dict__["opposite_region_id"] = opposite_region_id
            __props__.__dict__["opposite_router_id"] = opposite_router_id
            __props__.__dict__["opposite_router_type"] = opposite_router_type
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["pricing_cycle"] = pricing_cycle
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            if router_id is None and not opts.urn:
                raise TypeError("Missing required property 'router_id'")
            __props__.__dict__["router_id"] = router_id
            __props__.__dict__["router_interface_id"] = router_interface_id
            __props__.__dict__["router_interface_name"] = router_interface_name
            if router_type is None and not opts.urn:
                raise TypeError("Missing required property 'router_type'")
            __props__.__dict__["router_type"] = router_type
            if spec is None and not opts.urn:
                raise TypeError("Missing required property 'spec'")
            __props__.__dict__["spec"] = spec
            __props__.__dict__["status"] = status
            __props__.__dict__["bandwidth"] = None
            __props__.__dict__["business_status"] = None
            __props__.__dict__["connected_time"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["cross_border"] = None
            __props__.__dict__["end_time"] = None
            __props__.__dict__["has_reservation_data"] = None
            __props__.__dict__["opposite_bandwidth"] = None
            __props__.__dict__["opposite_interface_business_status"] = None
            __props__.__dict__["opposite_interface_spec"] = None
            __props__.__dict__["opposite_interface_status"] = None
            __props__.__dict__["opposite_vpc_instance_id"] = None
            __props__.__dict__["reservation_active_time"] = None
            __props__.__dict__["reservation_bandwidth"] = None
            __props__.__dict__["reservation_internet_charge_type"] = None
            __props__.__dict__["reservation_order_type"] = None
            __props__.__dict__["vpc_instance_id"] = None
        super(RouterInterface, __self__).__init__(
            'alicloud:expressconnect/routerInterface:RouterInterface',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
            auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
            bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            business_status: Optional[pulumi.Input[_builtins.str]] = None,
            connected_time: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            cross_border: Optional[pulumi.Input[_builtins.bool]] = None,
            delete_health_check_ip: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            end_time: Optional[pulumi.Input[_builtins.str]] = None,
            has_reservation_data: Optional[pulumi.Input[_builtins.str]] = None,
            hc_rate: Optional[pulumi.Input[_builtins.int]] = None,
            hc_threshold: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_source_ip: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_target_ip: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            opposite_interface_business_status: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_interface_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_interface_spec: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_interface_status: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_router_id: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_router_type: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_vpc_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
            reservation_active_time: Optional[pulumi.Input[_builtins.str]] = None,
            reservation_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
            reservation_internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            reservation_order_type: Optional[pulumi.Input[_builtins.str]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            router_id: Optional[pulumi.Input[_builtins.str]] = None,
            router_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
            router_interface_name: Optional[pulumi.Input[_builtins.str]] = None,
            router_type: Optional[pulumi.Input[_builtins.str]] = None,
            spec: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_instance_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RouterInterface':
        """
        Get an existing RouterInterface resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_point_id: The access point ID to which the VBR belongs.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically, value:-**false** (default): automatic payment is not enabled. After generating an order, you need to complete the payment at the order center.-**true**: Enable automatic payment to automatically pay for orders.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth of the resource.
        :param pulumi.Input[_builtins.str] business_status: The businessStatus of the resource. Valid Values: `Normal`, `FinancialLocked`, `SecurityLocked`.
        :param pulumi.Input[_builtins.str] connected_time: The connected time of the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.bool] cross_border: The cross border of the resource.
        :param pulumi.Input[_builtins.bool] delete_health_check_ip: Whether to delete the health check IP address configured on the router interface. Value:-**true**: deletes the health check IP address.-**false** (default): does not delete the health check IP address.
        :param pulumi.Input[_builtins.str] description: The description of the router interface. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] end_time: The end time of the resource.
        :param pulumi.Input[_builtins.str] has_reservation_data: The has reservation data of the resource.
        :param pulumi.Input[_builtins.int] hc_rate: The health check rate. Unit: seconds. The recommended value is 2. This indicates the interval between successive probe messages sent during the specified health check.
        :param pulumi.Input[_builtins.str] hc_threshold: The health check thresholds. Unit: pcs. The recommended value is 8. This indicates the number of probe messages to be sent during the specified health check.
        :param pulumi.Input[_builtins.str] health_check_source_ip: The health check source IP address, must be an unused IP within the local VPC.
        :param pulumi.Input[_builtins.str] health_check_target_ip: The IP address for health screening purposes.
        :param pulumi.Input[_builtins.str] opposite_access_point_id: The Access point ID to which the other end belongs.
        :param pulumi.Input[_builtins.int] opposite_bandwidth: The opposite bandwidth of the router on the other side.
        :param pulumi.Input[_builtins.str] opposite_interface_business_status: The opposite interface business status of the router on the other side. Valid Values: `Normal`, `FinancialLocked`, `SecurityLocked`.
        :param pulumi.Input[_builtins.str] opposite_interface_id: The Interface ID of the router at the other end.
        :param pulumi.Input[_builtins.str] opposite_interface_owner_id: The AliCloud account ID of the owner of the router interface on the other end.
        :param pulumi.Input[_builtins.str] opposite_interface_spec: The opposite interface spec of the router on the other side. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
        :param pulumi.Input[_builtins.str] opposite_interface_status: The opposite interface status of the router on the other side. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
        :param pulumi.Input[_builtins.str] opposite_region_id: The geographical ID of the location of the receiving end of the connection.
        :param pulumi.Input[_builtins.str] opposite_router_id: The id of the router at the other end.
        :param pulumi.Input[_builtins.str] opposite_router_type: The opposite router type of the router on the other side. Valid Values: `VRouter`, `VBR`.
        :param pulumi.Input[_builtins.str] opposite_vpc_instance_id: The opposite vpc instance id of the router on the other side.
        :param pulumi.Input[_builtins.str] payment_type: The payment methods for router interfaces. Valid Values: `PayAsYouGo`, `Subscription`.
        :param pulumi.Input[_builtins.int] period: Purchase duration, value:-When you choose to pay on a monthly basis, the value range is **1 to 9 * *.-When you choose to pay per year, the value range is **1 to 3 * *.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the prepaid fee. Valid values:-**Month** (default): monthly payment.-**Year**: Pay per Year.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        :param pulumi.Input[_builtins.str] reservation_active_time: The reservation active time of the resource.
        :param pulumi.Input[_builtins.str] reservation_bandwidth: The reservation bandwidth of the resource.
        :param pulumi.Input[_builtins.str] reservation_internet_charge_type: The reservation internet charge type of the resource.
        :param pulumi.Input[_builtins.str] reservation_order_type: The reservation order type of the resource.
        :param pulumi.Input[_builtins.str] role: The role of the router interface. Valid Values: `InitiatingSide`, `AcceptingSide`.
        :param pulumi.Input[_builtins.str] router_id: The router id associated with the router interface.
        :param pulumi.Input[_builtins.str] router_interface_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] router_interface_name: The name of the resource.
        :param pulumi.Input[_builtins.str] router_type: The type of router associated with the router interface. Valid Values: `VRouter`, `VBR`.
        :param pulumi.Input[_builtins.str] spec: The specification of the router interface. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
        :param pulumi.Input[_builtins.str] vpc_instance_id: The vpc instance id of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouterInterfaceState.__new__(_RouterInterfaceState)

        __props__.__dict__["access_point_id"] = access_point_id
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["business_status"] = business_status
        __props__.__dict__["connected_time"] = connected_time
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["cross_border"] = cross_border
        __props__.__dict__["delete_health_check_ip"] = delete_health_check_ip
        __props__.__dict__["description"] = description
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["has_reservation_data"] = has_reservation_data
        __props__.__dict__["hc_rate"] = hc_rate
        __props__.__dict__["hc_threshold"] = hc_threshold
        __props__.__dict__["health_check_source_ip"] = health_check_source_ip
        __props__.__dict__["health_check_target_ip"] = health_check_target_ip
        __props__.__dict__["opposite_access_point_id"] = opposite_access_point_id
        __props__.__dict__["opposite_bandwidth"] = opposite_bandwidth
        __props__.__dict__["opposite_interface_business_status"] = opposite_interface_business_status
        __props__.__dict__["opposite_interface_id"] = opposite_interface_id
        __props__.__dict__["opposite_interface_owner_id"] = opposite_interface_owner_id
        __props__.__dict__["opposite_interface_spec"] = opposite_interface_spec
        __props__.__dict__["opposite_interface_status"] = opposite_interface_status
        __props__.__dict__["opposite_region_id"] = opposite_region_id
        __props__.__dict__["opposite_router_id"] = opposite_router_id
        __props__.__dict__["opposite_router_type"] = opposite_router_type
        __props__.__dict__["opposite_vpc_instance_id"] = opposite_vpc_instance_id
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["pricing_cycle"] = pricing_cycle
        __props__.__dict__["reservation_active_time"] = reservation_active_time
        __props__.__dict__["reservation_bandwidth"] = reservation_bandwidth
        __props__.__dict__["reservation_internet_charge_type"] = reservation_internet_charge_type
        __props__.__dict__["reservation_order_type"] = reservation_order_type
        __props__.__dict__["role"] = role
        __props__.__dict__["router_id"] = router_id
        __props__.__dict__["router_interface_id"] = router_interface_id
        __props__.__dict__["router_interface_name"] = router_interface_name
        __props__.__dict__["router_type"] = router_type
        __props__.__dict__["spec"] = spec
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_instance_id"] = vpc_instance_id
        return RouterInterface(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The access point ID to which the VBR belongs.
        """
        return pulumi.get(self, "access_point_id")

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to pay automatically, value:-**false** (default): automatic payment is not enabled. After generating an order, you need to complete the payment at the order center.-**true**: Enable automatic payment to automatically pay for orders.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        """
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[_builtins.int]:
        """
        The bandwidth of the resource.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> pulumi.Output[_builtins.str]:
        """
        The businessStatus of the resource. Valid Values: `Normal`, `FinancialLocked`, `SecurityLocked`.
        """
        return pulumi.get(self, "business_status")

    @_builtins.property
    @pulumi.getter(name="connectedTime")
    def connected_time(self) -> pulumi.Output[_builtins.str]:
        """
        The connected time of the resource.
        """
        return pulumi.get(self, "connected_time")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="crossBorder")
    def cross_border(self) -> pulumi.Output[_builtins.bool]:
        """
        The cross border of the resource.
        """
        return pulumi.get(self, "cross_border")

    @_builtins.property
    @pulumi.getter(name="deleteHealthCheckIp")
    def delete_health_check_ip(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to delete the health check IP address configured on the router interface. Value:-**true**: deletes the health check IP address.-**false** (default): does not delete the health check IP address.
        """
        return pulumi.get(self, "delete_health_check_ip")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the router interface. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[_builtins.str]:
        """
        The end time of the resource.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="hasReservationData")
    def has_reservation_data(self) -> pulumi.Output[_builtins.str]:
        """
        The has reservation data of the resource.
        """
        return pulumi.get(self, "has_reservation_data")

    @_builtins.property
    @pulumi.getter(name="hcRate")
    def hc_rate(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The health check rate. Unit: seconds. The recommended value is 2. This indicates the interval between successive probe messages sent during the specified health check.
        """
        return pulumi.get(self, "hc_rate")

    @_builtins.property
    @pulumi.getter(name="hcThreshold")
    def hc_threshold(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The health check thresholds. Unit: pcs. The recommended value is 8. This indicates the number of probe messages to be sent during the specified health check.
        """
        return pulumi.get(self, "hc_threshold")

    @_builtins.property
    @pulumi.getter(name="healthCheckSourceIp")
    def health_check_source_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The health check source IP address, must be an unused IP within the local VPC.
        """
        return pulumi.get(self, "health_check_source_ip")

    @_builtins.property
    @pulumi.getter(name="healthCheckTargetIp")
    def health_check_target_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IP address for health screening purposes.
        """
        return pulumi.get(self, "health_check_target_ip")

    @_builtins.property
    @pulumi.getter(name="oppositeAccessPointId")
    def opposite_access_point_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Access point ID to which the other end belongs.
        """
        return pulumi.get(self, "opposite_access_point_id")

    @_builtins.property
    @pulumi.getter(name="oppositeBandwidth")
    def opposite_bandwidth(self) -> pulumi.Output[_builtins.int]:
        """
        The opposite bandwidth of the router on the other side.
        """
        return pulumi.get(self, "opposite_bandwidth")

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceBusinessStatus")
    def opposite_interface_business_status(self) -> pulumi.Output[_builtins.str]:
        """
        The opposite interface business status of the router on the other side. Valid Values: `Normal`, `FinancialLocked`, `SecurityLocked`.
        """
        return pulumi.get(self, "opposite_interface_business_status")

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceId")
    def opposite_interface_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Interface ID of the router at the other end.
        """
        return pulumi.get(self, "opposite_interface_id")

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceOwnerId")
    def opposite_interface_owner_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The AliCloud account ID of the owner of the router interface on the other end.
        """
        return pulumi.get(self, "opposite_interface_owner_id")

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceSpec")
    def opposite_interface_spec(self) -> pulumi.Output[_builtins.str]:
        """
        The opposite interface spec of the router on the other side. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
        """
        return pulumi.get(self, "opposite_interface_spec")

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceStatus")
    def opposite_interface_status(self) -> pulumi.Output[_builtins.str]:
        """
        The opposite interface status of the router on the other side. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
        """
        return pulumi.get(self, "opposite_interface_status")

    @_builtins.property
    @pulumi.getter(name="oppositeRegionId")
    def opposite_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The geographical ID of the location of the receiving end of the connection.
        """
        return pulumi.get(self, "opposite_region_id")

    @_builtins.property
    @pulumi.getter(name="oppositeRouterId")
    def opposite_router_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The id of the router at the other end.
        """
        return pulumi.get(self, "opposite_router_id")

    @_builtins.property
    @pulumi.getter(name="oppositeRouterType")
    def opposite_router_type(self) -> pulumi.Output[_builtins.str]:
        """
        The opposite router type of the router on the other side. Valid Values: `VRouter`, `VBR`.
        """
        return pulumi.get(self, "opposite_router_type")

    @_builtins.property
    @pulumi.getter(name="oppositeVpcInstanceId")
    def opposite_vpc_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The opposite vpc instance id of the router on the other side.
        """
        return pulumi.get(self, "opposite_vpc_instance_id")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The payment methods for router interfaces. Valid Values: `PayAsYouGo`, `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Purchase duration, value:-When you choose to pay on a monthly basis, the value range is **1 to 9 * *.-When you choose to pay per year, the value range is **1 to 3 * *.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The billing cycle of the prepaid fee. Valid values:-**Month** (default): monthly payment.-**Year**: Pay per Year.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
        """
        return pulumi.get(self, "pricing_cycle")

    @_builtins.property
    @pulumi.getter(name="reservationActiveTime")
    def reservation_active_time(self) -> pulumi.Output[_builtins.str]:
        """
        The reservation active time of the resource.
        """
        return pulumi.get(self, "reservation_active_time")

    @_builtins.property
    @pulumi.getter(name="reservationBandwidth")
    def reservation_bandwidth(self) -> pulumi.Output[_builtins.str]:
        """
        The reservation bandwidth of the resource.
        """
        return pulumi.get(self, "reservation_bandwidth")

    @_builtins.property
    @pulumi.getter(name="reservationInternetChargeType")
    def reservation_internet_charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        The reservation internet charge type of the resource.
        """
        return pulumi.get(self, "reservation_internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="reservationOrderType")
    def reservation_order_type(self) -> pulumi.Output[_builtins.str]:
        """
        The reservation order type of the resource.
        """
        return pulumi.get(self, "reservation_order_type")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[_builtins.str]:
        """
        The role of the router interface. Valid Values: `InitiatingSide`, `AcceptingSide`.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="routerId")
    def router_id(self) -> pulumi.Output[_builtins.str]:
        """
        The router id associated with the router interface.
        """
        return pulumi.get(self, "router_id")

    @_builtins.property
    @pulumi.getter(name="routerInterfaceId")
    def router_interface_id(self) -> pulumi.Output[_builtins.str]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "router_interface_id")

    @_builtins.property
    @pulumi.getter(name="routerInterfaceName")
    def router_interface_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "router_interface_name")

    @_builtins.property
    @pulumi.getter(name="routerType")
    def router_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of router associated with the router interface. Valid Values: `VRouter`, `VBR`.
        """
        return pulumi.get(self, "router_type")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> pulumi.Output[_builtins.str]:
        """
        The specification of the router interface. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcInstanceId")
    def vpc_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The vpc instance id of the resource.
        """
        return pulumi.get(self, "vpc_instance_id")

