# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouterTrAssociationArgs', 'RouterTrAssociation']

@pulumi.input_type
class RouterTrAssociationArgs:
    def __init__(__self__, *,
                 association_region_id: pulumi.Input[_builtins.str],
                 ecr_id: pulumi.Input[_builtins.str],
                 allowed_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_owner_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a RouterTrAssociation resource.
        :param pulumi.Input[_builtins.str] association_region_id: The region to which the VPC or TR belongs.
        :param pulumi.Input[_builtins.str] ecr_id: The ID of the leased line gateway instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_prefixes: List of allowed route prefixes.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the forwarding router instance.
        :param pulumi.Input[_builtins.int] transit_router_owner_id: The ID of the Alibaba Cloud account to which the forwarding router belongs.
        """
        pulumi.set(__self__, "association_region_id", association_region_id)
        pulumi.set(__self__, "ecr_id", ecr_id)
        if allowed_prefixes is not None:
            pulumi.set(__self__, "allowed_prefixes", allowed_prefixes)
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)
        if transit_router_owner_id is not None:
            pulumi.set(__self__, "transit_router_owner_id", transit_router_owner_id)

    @_builtins.property
    @pulumi.getter(name="associationRegionId")
    def association_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The region to which the VPC or TR belongs.
        """
        return pulumi.get(self, "association_region_id")

    @association_region_id.setter
    def association_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "association_region_id", value)

    @_builtins.property
    @pulumi.getter(name="ecrId")
    def ecr_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the leased line gateway instance.
        """
        return pulumi.get(self, "ecr_id")

    @ecr_id.setter
    def ecr_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ecr_id", value)

    @_builtins.property
    @pulumi.getter(name="allowedPrefixes")
    def allowed_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed route prefixes.
        """
        return pulumi.get(self, "allowed_prefixes")

    @allowed_prefixes.setter
    def allowed_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_prefixes", value)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the forwarding router instance.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_id", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterOwnerId")
    def transit_router_owner_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Alibaba Cloud account to which the forwarding router belongs.
        """
        return pulumi.get(self, "transit_router_owner_id")

    @transit_router_owner_id.setter
    def transit_router_owner_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "transit_router_owner_id", value)


@pulumi.input_type
class _RouterTrAssociationState:
    def __init__(__self__, *,
                 allowed_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 association_id: Optional[pulumi.Input[_builtins.str]] = None,
                 association_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 ecr_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_owner_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering RouterTrAssociation resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_prefixes: List of allowed route prefixes.
        :param pulumi.Input[_builtins.str] association_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] association_region_id: The region to which the VPC or TR belongs.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] ecr_id: The ID of the leased line gateway instance.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the forwarding router instance.
        :param pulumi.Input[_builtins.int] transit_router_owner_id: The ID of the Alibaba Cloud account to which the forwarding router belongs.
        """
        if allowed_prefixes is not None:
            pulumi.set(__self__, "allowed_prefixes", allowed_prefixes)
        if association_id is not None:
            pulumi.set(__self__, "association_id", association_id)
        if association_region_id is not None:
            pulumi.set(__self__, "association_region_id", association_region_id)
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if ecr_id is not None:
            pulumi.set(__self__, "ecr_id", ecr_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)
        if transit_router_owner_id is not None:
            pulumi.set(__self__, "transit_router_owner_id", transit_router_owner_id)

    @_builtins.property
    @pulumi.getter(name="allowedPrefixes")
    def allowed_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed route prefixes.
        """
        return pulumi.get(self, "allowed_prefixes")

    @allowed_prefixes.setter
    def allowed_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_prefixes", value)

    @_builtins.property
    @pulumi.getter(name="associationId")
    def association_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "association_id")

    @association_id.setter
    def association_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "association_id", value)

    @_builtins.property
    @pulumi.getter(name="associationRegionId")
    def association_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to which the VPC or TR belongs.
        """
        return pulumi.get(self, "association_region_id")

    @association_region_id.setter
    def association_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "association_region_id", value)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="ecrId")
    def ecr_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the leased line gateway instance.
        """
        return pulumi.get(self, "ecr_id")

    @ecr_id.setter
    def ecr_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ecr_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the forwarding router instance.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_id", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterOwnerId")
    def transit_router_owner_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Alibaba Cloud account to which the forwarding router belongs.
        """
        return pulumi.get(self, "transit_router_owner_id")

    @transit_router_owner_id.setter
    def transit_router_owner_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "transit_router_owner_id", value)


@pulumi.type_token("alicloud:expressconnect/routerTrAssociation:RouterTrAssociation")
class RouterTrAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 association_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ecr_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_owner_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Express Connect Router Express Connect Router Tr Association resource. Leased line gateway and TR binding relationship object.

        For information about Express Connect Router Express Connect Router Tr Association and how to use it, see [What is Express Connect Router Tr Association](https://next.api.alibabacloud.com/api/ExpressConnectRouter/2023-09-01/CreateExpressConnectRouterAssociation).

        > **NOTE:** Available since v1.224.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        alowprefix1 = config.get("alowprefix1")
        if alowprefix1 is None:
            alowprefix1 = "10.0.0.0/24"
        allowprefix2 = config.get("allowprefix2")
        if allowprefix2 is None:
            allowprefix2 = "10.0.1.0/24"
        allowprefix3 = config.get("allowprefix3")
        if allowprefix3 is None:
            allowprefix3 = "10.0.2.0/24"
        allowprefix4 = config.get("allowprefix4")
        if allowprefix4 is None:
            allowprefix4 = "10.0.3.0/24"
        asn = config.get("asn")
        if asn is None:
            asn = "4200001003"
        defaultp_x0_kl_c = alicloud.expressconnect.RouterExpressConnectRouter("defaultpX0KlC", alibaba_side_asn=asn)
        default418_dc9 = alicloud.cen.Instance("default418DC9", cen_instance_name=name)
        default_r_ycjsc = alicloud.cen.TransitRouter("defaultRYcjsc", cen_id=default418_dc9.id)
        current = alicloud.get_account()
        default = alicloud.expressconnect.RouterTrAssociation("default",
            ecr_id=defaultp_x0_kl_c.id,
            cen_id=default418_dc9.id,
            transit_router_owner_id=current.id,
            allowed_prefixes=[
                alowprefix1,
                allowprefix3,
                allowprefix2,
            ],
            transit_router_id=default_r_ycjsc.transit_router_id,
            association_region_id="cn-hangzhou")
        ```

        ## Import

        Express Connect Router Express Connect Router Tr Association can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/routerTrAssociation:RouterTrAssociation example <ecr_id>:<association_id>:<transit_router_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_prefixes: List of allowed route prefixes.
        :param pulumi.Input[_builtins.str] association_region_id: The region to which the VPC or TR belongs.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] ecr_id: The ID of the leased line gateway instance.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the forwarding router instance.
        :param pulumi.Input[_builtins.int] transit_router_owner_id: The ID of the Alibaba Cloud account to which the forwarding router belongs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouterTrAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Express Connect Router Express Connect Router Tr Association resource. Leased line gateway and TR binding relationship object.

        For information about Express Connect Router Express Connect Router Tr Association and how to use it, see [What is Express Connect Router Tr Association](https://next.api.alibabacloud.com/api/ExpressConnectRouter/2023-09-01/CreateExpressConnectRouterAssociation).

        > **NOTE:** Available since v1.224.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        alowprefix1 = config.get("alowprefix1")
        if alowprefix1 is None:
            alowprefix1 = "10.0.0.0/24"
        allowprefix2 = config.get("allowprefix2")
        if allowprefix2 is None:
            allowprefix2 = "10.0.1.0/24"
        allowprefix3 = config.get("allowprefix3")
        if allowprefix3 is None:
            allowprefix3 = "10.0.2.0/24"
        allowprefix4 = config.get("allowprefix4")
        if allowprefix4 is None:
            allowprefix4 = "10.0.3.0/24"
        asn = config.get("asn")
        if asn is None:
            asn = "4200001003"
        defaultp_x0_kl_c = alicloud.expressconnect.RouterExpressConnectRouter("defaultpX0KlC", alibaba_side_asn=asn)
        default418_dc9 = alicloud.cen.Instance("default418DC9", cen_instance_name=name)
        default_r_ycjsc = alicloud.cen.TransitRouter("defaultRYcjsc", cen_id=default418_dc9.id)
        current = alicloud.get_account()
        default = alicloud.expressconnect.RouterTrAssociation("default",
            ecr_id=defaultp_x0_kl_c.id,
            cen_id=default418_dc9.id,
            transit_router_owner_id=current.id,
            allowed_prefixes=[
                alowprefix1,
                allowprefix3,
                allowprefix2,
            ],
            transit_router_id=default_r_ycjsc.transit_router_id,
            association_region_id="cn-hangzhou")
        ```

        ## Import

        Express Connect Router Express Connect Router Tr Association can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/routerTrAssociation:RouterTrAssociation example <ecr_id>:<association_id>:<transit_router_id>
        ```

        :param str resource_name: The name of the resource.
        :param RouterTrAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouterTrAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 association_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ecr_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_owner_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouterTrAssociationArgs.__new__(RouterTrAssociationArgs)

            __props__.__dict__["allowed_prefixes"] = allowed_prefixes
            if association_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'association_region_id'")
            __props__.__dict__["association_region_id"] = association_region_id
            __props__.__dict__["cen_id"] = cen_id
            if ecr_id is None and not opts.urn:
                raise TypeError("Missing required property 'ecr_id'")
            __props__.__dict__["ecr_id"] = ecr_id
            __props__.__dict__["transit_router_id"] = transit_router_id
            __props__.__dict__["transit_router_owner_id"] = transit_router_owner_id
            __props__.__dict__["association_id"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(RouterTrAssociation, __self__).__init__(
            'alicloud:expressconnect/routerTrAssociation:RouterTrAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            association_id: Optional[pulumi.Input[_builtins.str]] = None,
            association_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            cen_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            ecr_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_owner_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'RouterTrAssociation':
        """
        Get an existing RouterTrAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_prefixes: List of allowed route prefixes.
        :param pulumi.Input[_builtins.str] association_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] association_region_id: The region to which the VPC or TR belongs.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] ecr_id: The ID of the leased line gateway instance.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the forwarding router instance.
        :param pulumi.Input[_builtins.int] transit_router_owner_id: The ID of the Alibaba Cloud account to which the forwarding router belongs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouterTrAssociationState.__new__(_RouterTrAssociationState)

        __props__.__dict__["allowed_prefixes"] = allowed_prefixes
        __props__.__dict__["association_id"] = association_id
        __props__.__dict__["association_region_id"] = association_region_id
        __props__.__dict__["cen_id"] = cen_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["ecr_id"] = ecr_id
        __props__.__dict__["status"] = status
        __props__.__dict__["transit_router_id"] = transit_router_id
        __props__.__dict__["transit_router_owner_id"] = transit_router_owner_id
        return RouterTrAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedPrefixes")
    def allowed_prefixes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of allowed route prefixes.
        """
        return pulumi.get(self, "allowed_prefixes")

    @_builtins.property
    @pulumi.getter(name="associationId")
    def association_id(self) -> pulumi.Output[_builtins.str]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "association_id")

    @_builtins.property
    @pulumi.getter(name="associationRegionId")
    def association_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region to which the VPC or TR belongs.
        """
        return pulumi.get(self, "association_region_id")

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="ecrId")
    def ecr_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the leased line gateway instance.
        """
        return pulumi.get(self, "ecr_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the forwarding router instance.
        """
        return pulumi.get(self, "transit_router_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterOwnerId")
    def transit_router_owner_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The ID of the Alibaba Cloud account to which the forwarding router belongs.
        """
        return pulumi.get(self, "transit_router_owner_id")

