# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VirtualBorderRouterArgs', 'VirtualBorderRouter']

@pulumi.input_type
class VirtualBorderRouterArgs:
    def __init__(__self__, *,
                 local_gateway_ip: pulumi.Input[_builtins.str],
                 peer_gateway_ip: pulumi.Input[_builtins.str],
                 peering_subnet_mask: pulumi.Input[_builtins.str],
                 physical_connection_id: pulumi.Input[_builtins.str],
                 vlan_id: pulumi.Input[_builtins.int],
                 associated_physical_connections: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 circuit_code: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detect_multiplier: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_cross_account_vbr: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_ipv6_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 min_rx_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 min_tx_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 peer_ipv6_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_ipv6_subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vbr_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_border_router_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VirtualBorderRouter resource.
        :param pulumi.Input[_builtins.str] local_gateway_ip: Alibaba Cloud-Connected IPv4 address.
        :param pulumi.Input[_builtins.str] peer_gateway_ip: The Client-Side Interconnection IPv4 Address.
        :param pulumi.Input[_builtins.str] peering_subnet_mask: Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
        :param pulumi.Input[_builtins.str] physical_connection_id: The ID of the Physical Connection to Which the ID.
        :param pulumi.Input[_builtins.int] vlan_id: The VLAN ID of the VBR. Value range: 0~2999.
        :param pulumi.Input[_builtins.str] associated_physical_connections: The associated physical connections.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth.
        :param pulumi.Input[_builtins.str] circuit_code: Operators for physical connection circuit provided coding.
        :param pulumi.Input[_builtins.str] description: The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
        :param pulumi.Input[_builtins.int] detect_multiplier: Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
        :param pulumi.Input[_builtins.bool] enable_ipv6: Whether to Enable IPv6. Valid values: `false`, `true`.
        :param pulumi.Input[_builtins.bool] include_cross_account_vbr: Whether cross account border routers are included. Valid values: `false`, `true`. Default: `true`.
        :param pulumi.Input[_builtins.str] local_ipv6_gateway_ip: Alibaba Cloud-Connected IPv6 Address.
        :param pulumi.Input[_builtins.int] min_rx_interval: Configure BFD packet reception interval of values include: 200~1000, unit: ms.
        :param pulumi.Input[_builtins.int] min_tx_interval: Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
        :param pulumi.Input[_builtins.str] peer_ipv6_gateway_ip: The Client-Side Interconnection IPv6 Address.
        :param pulumi.Input[_builtins.str] peering_ipv6_subnet_mask: Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
        :param pulumi.Input[_builtins.str] status: The instance state. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
        :param pulumi.Input[_builtins.str] vbr_owner_id: The vbr owner id.
        :param pulumi.Input[_builtins.str] virtual_border_router_name: The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
        """
        pulumi.set(__self__, "local_gateway_ip", local_gateway_ip)
        pulumi.set(__self__, "peer_gateway_ip", peer_gateway_ip)
        pulumi.set(__self__, "peering_subnet_mask", peering_subnet_mask)
        pulumi.set(__self__, "physical_connection_id", physical_connection_id)
        pulumi.set(__self__, "vlan_id", vlan_id)
        if associated_physical_connections is not None:
            pulumi.set(__self__, "associated_physical_connections", associated_physical_connections)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if circuit_code is not None:
            pulumi.set(__self__, "circuit_code", circuit_code)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detect_multiplier is not None:
            pulumi.set(__self__, "detect_multiplier", detect_multiplier)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if include_cross_account_vbr is not None:
            pulumi.set(__self__, "include_cross_account_vbr", include_cross_account_vbr)
        if local_ipv6_gateway_ip is not None:
            pulumi.set(__self__, "local_ipv6_gateway_ip", local_ipv6_gateway_ip)
        if min_rx_interval is not None:
            pulumi.set(__self__, "min_rx_interval", min_rx_interval)
        if min_tx_interval is not None:
            pulumi.set(__self__, "min_tx_interval", min_tx_interval)
        if peer_ipv6_gateway_ip is not None:
            pulumi.set(__self__, "peer_ipv6_gateway_ip", peer_ipv6_gateway_ip)
        if peering_ipv6_subnet_mask is not None:
            pulumi.set(__self__, "peering_ipv6_subnet_mask", peering_ipv6_subnet_mask)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vbr_owner_id is not None:
            pulumi.set(__self__, "vbr_owner_id", vbr_owner_id)
        if virtual_border_router_name is not None:
            pulumi.set(__self__, "virtual_border_router_name", virtual_border_router_name)

    @_builtins.property
    @pulumi.getter(name="localGatewayIp")
    def local_gateway_ip(self) -> pulumi.Input[_builtins.str]:
        """
        Alibaba Cloud-Connected IPv4 address.
        """
        return pulumi.get(self, "local_gateway_ip")

    @local_gateway_ip.setter
    def local_gateway_ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "local_gateway_ip", value)

    @_builtins.property
    @pulumi.getter(name="peerGatewayIp")
    def peer_gateway_ip(self) -> pulumi.Input[_builtins.str]:
        """
        The Client-Side Interconnection IPv4 Address.
        """
        return pulumi.get(self, "peer_gateway_ip")

    @peer_gateway_ip.setter
    def peer_gateway_ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "peer_gateway_ip", value)

    @_builtins.property
    @pulumi.getter(name="peeringSubnetMask")
    def peering_subnet_mask(self) -> pulumi.Input[_builtins.str]:
        """
        Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
        """
        return pulumi.get(self, "peering_subnet_mask")

    @peering_subnet_mask.setter
    def peering_subnet_mask(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "peering_subnet_mask", value)

    @_builtins.property
    @pulumi.getter(name="physicalConnectionId")
    def physical_connection_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Physical Connection to Which the ID.
        """
        return pulumi.get(self, "physical_connection_id")

    @physical_connection_id.setter
    def physical_connection_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "physical_connection_id", value)

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Input[_builtins.int]:
        """
        The VLAN ID of the VBR. Value range: 0~2999.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "vlan_id", value)

    @_builtins.property
    @pulumi.getter(name="associatedPhysicalConnections")
    def associated_physical_connections(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The associated physical connections.
        """
        return pulumi.get(self, "associated_physical_connections")

    @associated_physical_connections.setter
    def associated_physical_connections(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "associated_physical_connections", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="circuitCode")
    def circuit_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operators for physical connection circuit provided coding.
        """
        return pulumi.get(self, "circuit_code")

    @circuit_code.setter
    def circuit_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "circuit_code", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="detectMultiplier")
    def detect_multiplier(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
        """
        return pulumi.get(self, "detect_multiplier")

    @detect_multiplier.setter
    def detect_multiplier(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "detect_multiplier", value)

    @_builtins.property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to Enable IPv6. Valid values: `false`, `true`.
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @_builtins.property
    @pulumi.getter(name="includeCrossAccountVbr")
    def include_cross_account_vbr(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether cross account border routers are included. Valid values: `false`, `true`. Default: `true`.
        """
        return pulumi.get(self, "include_cross_account_vbr")

    @include_cross_account_vbr.setter
    def include_cross_account_vbr(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_cross_account_vbr", value)

    @_builtins.property
    @pulumi.getter(name="localIpv6GatewayIp")
    def local_ipv6_gateway_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alibaba Cloud-Connected IPv6 Address.
        """
        return pulumi.get(self, "local_ipv6_gateway_ip")

    @local_ipv6_gateway_ip.setter
    def local_ipv6_gateway_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_ipv6_gateway_ip", value)

    @_builtins.property
    @pulumi.getter(name="minRxInterval")
    def min_rx_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configure BFD packet reception interval of values include: 200~1000, unit: ms.
        """
        return pulumi.get(self, "min_rx_interval")

    @min_rx_interval.setter
    def min_rx_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_rx_interval", value)

    @_builtins.property
    @pulumi.getter(name="minTxInterval")
    def min_tx_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
        """
        return pulumi.get(self, "min_tx_interval")

    @min_tx_interval.setter
    def min_tx_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_tx_interval", value)

    @_builtins.property
    @pulumi.getter(name="peerIpv6GatewayIp")
    def peer_ipv6_gateway_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client-Side Interconnection IPv6 Address.
        """
        return pulumi.get(self, "peer_ipv6_gateway_ip")

    @peer_ipv6_gateway_ip.setter
    def peer_ipv6_gateway_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_ipv6_gateway_ip", value)

    @_builtins.property
    @pulumi.getter(name="peeringIpv6SubnetMask")
    def peering_ipv6_subnet_mask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
        """
        return pulumi.get(self, "peering_ipv6_subnet_mask")

    @peering_ipv6_subnet_mask.setter
    def peering_ipv6_subnet_mask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peering_ipv6_subnet_mask", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance state. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vbrOwnerId")
    def vbr_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vbr owner id.
        """
        return pulumi.get(self, "vbr_owner_id")

    @vbr_owner_id.setter
    def vbr_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vbr_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="virtualBorderRouterName")
    def virtual_border_router_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
        """
        return pulumi.get(self, "virtual_border_router_name")

    @virtual_border_router_name.setter
    def virtual_border_router_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_border_router_name", value)


@pulumi.input_type
class _VirtualBorderRouterState:
    def __init__(__self__, *,
                 associated_physical_connections: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 circuit_code: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detect_multiplier: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_cross_account_vbr: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 local_ipv6_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 min_rx_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 min_tx_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 peer_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_ipv6_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_ipv6_subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
                 physical_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vbr_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_border_router_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering VirtualBorderRouter resources.
        :param pulumi.Input[_builtins.str] associated_physical_connections: The associated physical connections.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth.
        :param pulumi.Input[_builtins.str] circuit_code: Operators for physical connection circuit provided coding.
        :param pulumi.Input[_builtins.str] description: The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
        :param pulumi.Input[_builtins.int] detect_multiplier: Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
        :param pulumi.Input[_builtins.bool] enable_ipv6: Whether to Enable IPv6. Valid values: `false`, `true`.
        :param pulumi.Input[_builtins.bool] include_cross_account_vbr: Whether cross account border routers are included. Valid values: `false`, `true`. Default: `true`.
        :param pulumi.Input[_builtins.str] local_gateway_ip: Alibaba Cloud-Connected IPv4 address.
        :param pulumi.Input[_builtins.str] local_ipv6_gateway_ip: Alibaba Cloud-Connected IPv6 Address.
        :param pulumi.Input[_builtins.int] min_rx_interval: Configure BFD packet reception interval of values include: 200~1000, unit: ms.
        :param pulumi.Input[_builtins.int] min_tx_interval: Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
        :param pulumi.Input[_builtins.str] peer_gateway_ip: The Client-Side Interconnection IPv4 Address.
        :param pulumi.Input[_builtins.str] peer_ipv6_gateway_ip: The Client-Side Interconnection IPv6 Address.
        :param pulumi.Input[_builtins.str] peering_ipv6_subnet_mask: Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
        :param pulumi.Input[_builtins.str] peering_subnet_mask: Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
        :param pulumi.Input[_builtins.str] physical_connection_id: The ID of the Physical Connection to Which the ID.
        :param pulumi.Input[_builtins.str] route_table_id: (Available since v1.166.0) The Route Table ID Of the Virtual Border Router.
        :param pulumi.Input[_builtins.str] status: The instance state. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
        :param pulumi.Input[_builtins.str] vbr_owner_id: The vbr owner id.
        :param pulumi.Input[_builtins.str] virtual_border_router_name: The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
        :param pulumi.Input[_builtins.int] vlan_id: The VLAN ID of the VBR. Value range: 0~2999.
        """
        if associated_physical_connections is not None:
            pulumi.set(__self__, "associated_physical_connections", associated_physical_connections)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if circuit_code is not None:
            pulumi.set(__self__, "circuit_code", circuit_code)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detect_multiplier is not None:
            pulumi.set(__self__, "detect_multiplier", detect_multiplier)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if include_cross_account_vbr is not None:
            pulumi.set(__self__, "include_cross_account_vbr", include_cross_account_vbr)
        if local_gateway_ip is not None:
            pulumi.set(__self__, "local_gateway_ip", local_gateway_ip)
        if local_ipv6_gateway_ip is not None:
            pulumi.set(__self__, "local_ipv6_gateway_ip", local_ipv6_gateway_ip)
        if min_rx_interval is not None:
            pulumi.set(__self__, "min_rx_interval", min_rx_interval)
        if min_tx_interval is not None:
            pulumi.set(__self__, "min_tx_interval", min_tx_interval)
        if peer_gateway_ip is not None:
            pulumi.set(__self__, "peer_gateway_ip", peer_gateway_ip)
        if peer_ipv6_gateway_ip is not None:
            pulumi.set(__self__, "peer_ipv6_gateway_ip", peer_ipv6_gateway_ip)
        if peering_ipv6_subnet_mask is not None:
            pulumi.set(__self__, "peering_ipv6_subnet_mask", peering_ipv6_subnet_mask)
        if peering_subnet_mask is not None:
            pulumi.set(__self__, "peering_subnet_mask", peering_subnet_mask)
        if physical_connection_id is not None:
            pulumi.set(__self__, "physical_connection_id", physical_connection_id)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vbr_owner_id is not None:
            pulumi.set(__self__, "vbr_owner_id", vbr_owner_id)
        if virtual_border_router_name is not None:
            pulumi.set(__self__, "virtual_border_router_name", virtual_border_router_name)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @_builtins.property
    @pulumi.getter(name="associatedPhysicalConnections")
    def associated_physical_connections(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The associated physical connections.
        """
        return pulumi.get(self, "associated_physical_connections")

    @associated_physical_connections.setter
    def associated_physical_connections(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "associated_physical_connections", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="circuitCode")
    def circuit_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operators for physical connection circuit provided coding.
        """
        return pulumi.get(self, "circuit_code")

    @circuit_code.setter
    def circuit_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "circuit_code", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="detectMultiplier")
    def detect_multiplier(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
        """
        return pulumi.get(self, "detect_multiplier")

    @detect_multiplier.setter
    def detect_multiplier(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "detect_multiplier", value)

    @_builtins.property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to Enable IPv6. Valid values: `false`, `true`.
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @_builtins.property
    @pulumi.getter(name="includeCrossAccountVbr")
    def include_cross_account_vbr(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether cross account border routers are included. Valid values: `false`, `true`. Default: `true`.
        """
        return pulumi.get(self, "include_cross_account_vbr")

    @include_cross_account_vbr.setter
    def include_cross_account_vbr(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_cross_account_vbr", value)

    @_builtins.property
    @pulumi.getter(name="localGatewayIp")
    def local_gateway_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alibaba Cloud-Connected IPv4 address.
        """
        return pulumi.get(self, "local_gateway_ip")

    @local_gateway_ip.setter
    def local_gateway_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_gateway_ip", value)

    @_builtins.property
    @pulumi.getter(name="localIpv6GatewayIp")
    def local_ipv6_gateway_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alibaba Cloud-Connected IPv6 Address.
        """
        return pulumi.get(self, "local_ipv6_gateway_ip")

    @local_ipv6_gateway_ip.setter
    def local_ipv6_gateway_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_ipv6_gateway_ip", value)

    @_builtins.property
    @pulumi.getter(name="minRxInterval")
    def min_rx_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configure BFD packet reception interval of values include: 200~1000, unit: ms.
        """
        return pulumi.get(self, "min_rx_interval")

    @min_rx_interval.setter
    def min_rx_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_rx_interval", value)

    @_builtins.property
    @pulumi.getter(name="minTxInterval")
    def min_tx_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
        """
        return pulumi.get(self, "min_tx_interval")

    @min_tx_interval.setter
    def min_tx_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_tx_interval", value)

    @_builtins.property
    @pulumi.getter(name="peerGatewayIp")
    def peer_gateway_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client-Side Interconnection IPv4 Address.
        """
        return pulumi.get(self, "peer_gateway_ip")

    @peer_gateway_ip.setter
    def peer_gateway_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_gateway_ip", value)

    @_builtins.property
    @pulumi.getter(name="peerIpv6GatewayIp")
    def peer_ipv6_gateway_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client-Side Interconnection IPv6 Address.
        """
        return pulumi.get(self, "peer_ipv6_gateway_ip")

    @peer_ipv6_gateway_ip.setter
    def peer_ipv6_gateway_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_ipv6_gateway_ip", value)

    @_builtins.property
    @pulumi.getter(name="peeringIpv6SubnetMask")
    def peering_ipv6_subnet_mask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
        """
        return pulumi.get(self, "peering_ipv6_subnet_mask")

    @peering_ipv6_subnet_mask.setter
    def peering_ipv6_subnet_mask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peering_ipv6_subnet_mask", value)

    @_builtins.property
    @pulumi.getter(name="peeringSubnetMask")
    def peering_subnet_mask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
        """
        return pulumi.get(self, "peering_subnet_mask")

    @peering_subnet_mask.setter
    def peering_subnet_mask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peering_subnet_mask", value)

    @_builtins.property
    @pulumi.getter(name="physicalConnectionId")
    def physical_connection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Physical Connection to Which the ID.
        """
        return pulumi.get(self, "physical_connection_id")

    @physical_connection_id.setter
    def physical_connection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "physical_connection_id", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.166.0) The Route Table ID Of the Virtual Border Router.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance state. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vbrOwnerId")
    def vbr_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vbr owner id.
        """
        return pulumi.get(self, "vbr_owner_id")

    @vbr_owner_id.setter
    def vbr_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vbr_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="virtualBorderRouterName")
    def virtual_border_router_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
        """
        return pulumi.get(self, "virtual_border_router_name")

    @virtual_border_router_name.setter
    def virtual_border_router_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_border_router_name", value)

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The VLAN ID of the VBR. Value range: 0~2999.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vlan_id", value)


@pulumi.type_token("alicloud:expressconnect/virtualBorderRouter:VirtualBorderRouter")
class VirtualBorderRouter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_physical_connections: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 circuit_code: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detect_multiplier: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_cross_account_vbr: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 local_ipv6_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 min_rx_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 min_tx_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 peer_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_ipv6_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_ipv6_subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
                 physical_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vbr_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_border_router_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Express Connect Virtual Border Router resource.

        For information about Express Connect Virtual Border Router and how to use it, see [What is Virtual Border Router](https://www.alibabacloud.com/help/en/doc-detail/44854.htm).

        > **NOTE:** Available since v1.134.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        example = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
        vlan_id = random.index.Integer("vlan_id",
            max=2999,
            min=1)
        example_virtual_border_router = alicloud.expressconnect.VirtualBorderRouter("example",
            local_gateway_ip="10.0.0.1",
            peer_gateway_ip="10.0.0.2",
            peering_subnet_mask="255.255.255.252",
            physical_connection_id=example.connections[0].id,
            virtual_border_router_name=name,
            vlan_id=vlan_id["id"],
            min_rx_interval=1000,
            min_tx_interval=1000,
            detect_multiplier=10)
        ```

        ## Import

        Express Connect Virtual Border Router can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/virtualBorderRouter:VirtualBorderRouter example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] associated_physical_connections: The associated physical connections.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth.
        :param pulumi.Input[_builtins.str] circuit_code: Operators for physical connection circuit provided coding.
        :param pulumi.Input[_builtins.str] description: The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
        :param pulumi.Input[_builtins.int] detect_multiplier: Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
        :param pulumi.Input[_builtins.bool] enable_ipv6: Whether to Enable IPv6. Valid values: `false`, `true`.
        :param pulumi.Input[_builtins.bool] include_cross_account_vbr: Whether cross account border routers are included. Valid values: `false`, `true`. Default: `true`.
        :param pulumi.Input[_builtins.str] local_gateway_ip: Alibaba Cloud-Connected IPv4 address.
        :param pulumi.Input[_builtins.str] local_ipv6_gateway_ip: Alibaba Cloud-Connected IPv6 Address.
        :param pulumi.Input[_builtins.int] min_rx_interval: Configure BFD packet reception interval of values include: 200~1000, unit: ms.
        :param pulumi.Input[_builtins.int] min_tx_interval: Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
        :param pulumi.Input[_builtins.str] peer_gateway_ip: The Client-Side Interconnection IPv4 Address.
        :param pulumi.Input[_builtins.str] peer_ipv6_gateway_ip: The Client-Side Interconnection IPv6 Address.
        :param pulumi.Input[_builtins.str] peering_ipv6_subnet_mask: Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
        :param pulumi.Input[_builtins.str] peering_subnet_mask: Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
        :param pulumi.Input[_builtins.str] physical_connection_id: The ID of the Physical Connection to Which the ID.
        :param pulumi.Input[_builtins.str] status: The instance state. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
        :param pulumi.Input[_builtins.str] vbr_owner_id: The vbr owner id.
        :param pulumi.Input[_builtins.str] virtual_border_router_name: The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
        :param pulumi.Input[_builtins.int] vlan_id: The VLAN ID of the VBR. Value range: 0~2999.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualBorderRouterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Express Connect Virtual Border Router resource.

        For information about Express Connect Virtual Border Router and how to use it, see [What is Virtual Border Router](https://www.alibabacloud.com/help/en/doc-detail/44854.htm).

        > **NOTE:** Available since v1.134.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        example = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
        vlan_id = random.index.Integer("vlan_id",
            max=2999,
            min=1)
        example_virtual_border_router = alicloud.expressconnect.VirtualBorderRouter("example",
            local_gateway_ip="10.0.0.1",
            peer_gateway_ip="10.0.0.2",
            peering_subnet_mask="255.255.255.252",
            physical_connection_id=example.connections[0].id,
            virtual_border_router_name=name,
            vlan_id=vlan_id["id"],
            min_rx_interval=1000,
            min_tx_interval=1000,
            detect_multiplier=10)
        ```

        ## Import

        Express Connect Virtual Border Router can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/virtualBorderRouter:VirtualBorderRouter example <id>
        ```

        :param str resource_name: The name of the resource.
        :param VirtualBorderRouterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualBorderRouterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_physical_connections: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 circuit_code: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detect_multiplier: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_cross_account_vbr: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 local_ipv6_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 min_rx_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 min_tx_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 peer_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_ipv6_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_ipv6_subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
                 physical_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vbr_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_border_router_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualBorderRouterArgs.__new__(VirtualBorderRouterArgs)

            __props__.__dict__["associated_physical_connections"] = associated_physical_connections
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["circuit_code"] = circuit_code
            __props__.__dict__["description"] = description
            __props__.__dict__["detect_multiplier"] = detect_multiplier
            __props__.__dict__["enable_ipv6"] = enable_ipv6
            __props__.__dict__["include_cross_account_vbr"] = include_cross_account_vbr
            if local_gateway_ip is None and not opts.urn:
                raise TypeError("Missing required property 'local_gateway_ip'")
            __props__.__dict__["local_gateway_ip"] = local_gateway_ip
            __props__.__dict__["local_ipv6_gateway_ip"] = local_ipv6_gateway_ip
            __props__.__dict__["min_rx_interval"] = min_rx_interval
            __props__.__dict__["min_tx_interval"] = min_tx_interval
            if peer_gateway_ip is None and not opts.urn:
                raise TypeError("Missing required property 'peer_gateway_ip'")
            __props__.__dict__["peer_gateway_ip"] = peer_gateway_ip
            __props__.__dict__["peer_ipv6_gateway_ip"] = peer_ipv6_gateway_ip
            __props__.__dict__["peering_ipv6_subnet_mask"] = peering_ipv6_subnet_mask
            if peering_subnet_mask is None and not opts.urn:
                raise TypeError("Missing required property 'peering_subnet_mask'")
            __props__.__dict__["peering_subnet_mask"] = peering_subnet_mask
            if physical_connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'physical_connection_id'")
            __props__.__dict__["physical_connection_id"] = physical_connection_id
            __props__.__dict__["status"] = status
            __props__.__dict__["vbr_owner_id"] = vbr_owner_id
            __props__.__dict__["virtual_border_router_name"] = virtual_border_router_name
            if vlan_id is None and not opts.urn:
                raise TypeError("Missing required property 'vlan_id'")
            __props__.__dict__["vlan_id"] = vlan_id
            __props__.__dict__["route_table_id"] = None
        super(VirtualBorderRouter, __self__).__init__(
            'alicloud:expressconnect/virtualBorderRouter:VirtualBorderRouter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associated_physical_connections: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            circuit_code: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            detect_multiplier: Optional[pulumi.Input[_builtins.int]] = None,
            enable_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
            include_cross_account_vbr: Optional[pulumi.Input[_builtins.bool]] = None,
            local_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
            local_ipv6_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
            min_rx_interval: Optional[pulumi.Input[_builtins.int]] = None,
            min_tx_interval: Optional[pulumi.Input[_builtins.int]] = None,
            peer_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
            peer_ipv6_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
            peering_ipv6_subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
            peering_subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
            physical_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
            route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vbr_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_border_router_name: Optional[pulumi.Input[_builtins.str]] = None,
            vlan_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'VirtualBorderRouter':
        """
        Get an existing VirtualBorderRouter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] associated_physical_connections: The associated physical connections.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth.
        :param pulumi.Input[_builtins.str] circuit_code: Operators for physical connection circuit provided coding.
        :param pulumi.Input[_builtins.str] description: The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
        :param pulumi.Input[_builtins.int] detect_multiplier: Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
        :param pulumi.Input[_builtins.bool] enable_ipv6: Whether to Enable IPv6. Valid values: `false`, `true`.
        :param pulumi.Input[_builtins.bool] include_cross_account_vbr: Whether cross account border routers are included. Valid values: `false`, `true`. Default: `true`.
        :param pulumi.Input[_builtins.str] local_gateway_ip: Alibaba Cloud-Connected IPv4 address.
        :param pulumi.Input[_builtins.str] local_ipv6_gateway_ip: Alibaba Cloud-Connected IPv6 Address.
        :param pulumi.Input[_builtins.int] min_rx_interval: Configure BFD packet reception interval of values include: 200~1000, unit: ms.
        :param pulumi.Input[_builtins.int] min_tx_interval: Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
        :param pulumi.Input[_builtins.str] peer_gateway_ip: The Client-Side Interconnection IPv4 Address.
        :param pulumi.Input[_builtins.str] peer_ipv6_gateway_ip: The Client-Side Interconnection IPv6 Address.
        :param pulumi.Input[_builtins.str] peering_ipv6_subnet_mask: Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
        :param pulumi.Input[_builtins.str] peering_subnet_mask: Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
        :param pulumi.Input[_builtins.str] physical_connection_id: The ID of the Physical Connection to Which the ID.
        :param pulumi.Input[_builtins.str] route_table_id: (Available since v1.166.0) The Route Table ID Of the Virtual Border Router.
        :param pulumi.Input[_builtins.str] status: The instance state. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
        :param pulumi.Input[_builtins.str] vbr_owner_id: The vbr owner id.
        :param pulumi.Input[_builtins.str] virtual_border_router_name: The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
        :param pulumi.Input[_builtins.int] vlan_id: The VLAN ID of the VBR. Value range: 0~2999.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualBorderRouterState.__new__(_VirtualBorderRouterState)

        __props__.__dict__["associated_physical_connections"] = associated_physical_connections
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["circuit_code"] = circuit_code
        __props__.__dict__["description"] = description
        __props__.__dict__["detect_multiplier"] = detect_multiplier
        __props__.__dict__["enable_ipv6"] = enable_ipv6
        __props__.__dict__["include_cross_account_vbr"] = include_cross_account_vbr
        __props__.__dict__["local_gateway_ip"] = local_gateway_ip
        __props__.__dict__["local_ipv6_gateway_ip"] = local_ipv6_gateway_ip
        __props__.__dict__["min_rx_interval"] = min_rx_interval
        __props__.__dict__["min_tx_interval"] = min_tx_interval
        __props__.__dict__["peer_gateway_ip"] = peer_gateway_ip
        __props__.__dict__["peer_ipv6_gateway_ip"] = peer_ipv6_gateway_ip
        __props__.__dict__["peering_ipv6_subnet_mask"] = peering_ipv6_subnet_mask
        __props__.__dict__["peering_subnet_mask"] = peering_subnet_mask
        __props__.__dict__["physical_connection_id"] = physical_connection_id
        __props__.__dict__["route_table_id"] = route_table_id
        __props__.__dict__["status"] = status
        __props__.__dict__["vbr_owner_id"] = vbr_owner_id
        __props__.__dict__["virtual_border_router_name"] = virtual_border_router_name
        __props__.__dict__["vlan_id"] = vlan_id
        return VirtualBorderRouter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="associatedPhysicalConnections")
    def associated_physical_connections(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The associated physical connections.
        """
        return pulumi.get(self, "associated_physical_connections")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[_builtins.int]:
        """
        The bandwidth.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="circuitCode")
    def circuit_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Operators for physical connection circuit provided coding.
        """
        return pulumi.get(self, "circuit_code")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="detectMultiplier")
    def detect_multiplier(self) -> pulumi.Output[_builtins.int]:
        """
        Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
        """
        return pulumi.get(self, "detect_multiplier")

    @_builtins.property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to Enable IPv6. Valid values: `false`, `true`.
        """
        return pulumi.get(self, "enable_ipv6")

    @_builtins.property
    @pulumi.getter(name="includeCrossAccountVbr")
    def include_cross_account_vbr(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether cross account border routers are included. Valid values: `false`, `true`. Default: `true`.
        """
        return pulumi.get(self, "include_cross_account_vbr")

    @_builtins.property
    @pulumi.getter(name="localGatewayIp")
    def local_gateway_ip(self) -> pulumi.Output[_builtins.str]:
        """
        Alibaba Cloud-Connected IPv4 address.
        """
        return pulumi.get(self, "local_gateway_ip")

    @_builtins.property
    @pulumi.getter(name="localIpv6GatewayIp")
    def local_ipv6_gateway_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Alibaba Cloud-Connected IPv6 Address.
        """
        return pulumi.get(self, "local_ipv6_gateway_ip")

    @_builtins.property
    @pulumi.getter(name="minRxInterval")
    def min_rx_interval(self) -> pulumi.Output[_builtins.int]:
        """
        Configure BFD packet reception interval of values include: 200~1000, unit: ms.
        """
        return pulumi.get(self, "min_rx_interval")

    @_builtins.property
    @pulumi.getter(name="minTxInterval")
    def min_tx_interval(self) -> pulumi.Output[_builtins.int]:
        """
        Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
        """
        return pulumi.get(self, "min_tx_interval")

    @_builtins.property
    @pulumi.getter(name="peerGatewayIp")
    def peer_gateway_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The Client-Side Interconnection IPv4 Address.
        """
        return pulumi.get(self, "peer_gateway_ip")

    @_builtins.property
    @pulumi.getter(name="peerIpv6GatewayIp")
    def peer_ipv6_gateway_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Client-Side Interconnection IPv6 Address.
        """
        return pulumi.get(self, "peer_ipv6_gateway_ip")

    @_builtins.property
    @pulumi.getter(name="peeringIpv6SubnetMask")
    def peering_ipv6_subnet_mask(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
        """
        return pulumi.get(self, "peering_ipv6_subnet_mask")

    @_builtins.property
    @pulumi.getter(name="peeringSubnetMask")
    def peering_subnet_mask(self) -> pulumi.Output[_builtins.str]:
        """
        Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
        """
        return pulumi.get(self, "peering_subnet_mask")

    @_builtins.property
    @pulumi.getter(name="physicalConnectionId")
    def physical_connection_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Physical Connection to Which the ID.
        """
        return pulumi.get(self, "physical_connection_id")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.166.0) The Route Table ID Of the Virtual Border Router.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The instance state. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vbrOwnerId")
    def vbr_owner_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The vbr owner id.
        """
        return pulumi.get(self, "vbr_owner_id")

    @_builtins.property
    @pulumi.getter(name="virtualBorderRouterName")
    def virtual_border_router_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
        """
        return pulumi.get(self, "virtual_border_router_name")

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Output[_builtins.int]:
        """
        The VLAN ID of the VBR. Value range: 0~2999.
        """
        return pulumi.get(self, "vlan_id")

