# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['V3AsyncInvokeConfigArgs', 'V3AsyncInvokeConfig']

@pulumi.input_type
class V3AsyncInvokeConfigArgs:
    def __init__(__self__, *,
                 function_name: pulumi.Input[_builtins.str],
                 async_task: Optional[pulumi.Input[_builtins.bool]] = None,
                 destination_config: Optional[pulumi.Input['V3AsyncInvokeConfigDestinationConfigArgs']] = None,
                 max_async_event_age_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 max_async_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a V3AsyncInvokeConfig resource.
        :param pulumi.Input[_builtins.str] function_name: Function Name
        :param pulumi.Input[_builtins.bool] async_task: Whether to enable an asynchronous task
        :param pulumi.Input['V3AsyncInvokeConfigDestinationConfigArgs'] destination_config: Target Configuration See `destination_config` below.
        :param pulumi.Input[_builtins.int] max_async_event_age_in_seconds: Event maximum survival time
        :param pulumi.Input[_builtins.int] max_async_retry_attempts: Number of Asynchronous call retries
        :param pulumi.Input[_builtins.str] qualifier: Function version or alias
        """
        pulumi.set(__self__, "function_name", function_name)
        if async_task is not None:
            pulumi.set(__self__, "async_task", async_task)
        if destination_config is not None:
            pulumi.set(__self__, "destination_config", destination_config)
        if max_async_event_age_in_seconds is not None:
            pulumi.set(__self__, "max_async_event_age_in_seconds", max_async_event_age_in_seconds)
        if max_async_retry_attempts is not None:
            pulumi.set(__self__, "max_async_retry_attempts", max_async_retry_attempts)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[_builtins.str]:
        """
        Function Name
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter(name="asyncTask")
    def async_task(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable an asynchronous task
        """
        return pulumi.get(self, "async_task")

    @async_task.setter
    def async_task(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "async_task", value)

    @_builtins.property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> Optional[pulumi.Input['V3AsyncInvokeConfigDestinationConfigArgs']]:
        """
        Target Configuration See `destination_config` below.
        """
        return pulumi.get(self, "destination_config")

    @destination_config.setter
    def destination_config(self, value: Optional[pulumi.Input['V3AsyncInvokeConfigDestinationConfigArgs']]):
        pulumi.set(self, "destination_config", value)

    @_builtins.property
    @pulumi.getter(name="maxAsyncEventAgeInSeconds")
    def max_async_event_age_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Event maximum survival time
        """
        return pulumi.get(self, "max_async_event_age_in_seconds")

    @max_async_event_age_in_seconds.setter
    def max_async_event_age_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_async_event_age_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="maxAsyncRetryAttempts")
    def max_async_retry_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of Asynchronous call retries
        """
        return pulumi.get(self, "max_async_retry_attempts")

    @max_async_retry_attempts.setter
    def max_async_retry_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_async_retry_attempts", value)

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Function version or alias
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualifier", value)


@pulumi.input_type
class _V3AsyncInvokeConfigState:
    def __init__(__self__, *,
                 async_task: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_config: Optional[pulumi.Input['V3AsyncInvokeConfigDestinationConfigArgs']] = None,
                 function_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modified_time: Optional[pulumi.Input[_builtins.str]] = None,
                 max_async_event_age_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 max_async_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering V3AsyncInvokeConfig resources.
        :param pulumi.Input[_builtins.bool] async_task: Whether to enable an asynchronous task
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input['V3AsyncInvokeConfigDestinationConfigArgs'] destination_config: Target Configuration See `destination_config` below.
        :param pulumi.Input[_builtins.str] function_arn: (Available since v1.234.0) Function resource identification
        :param pulumi.Input[_builtins.str] function_name: Function Name
        :param pulumi.Input[_builtins.str] last_modified_time: (Available since v1.234.0) Last modification time
        :param pulumi.Input[_builtins.int] max_async_event_age_in_seconds: Event maximum survival time
        :param pulumi.Input[_builtins.int] max_async_retry_attempts: Number of Asynchronous call retries
        :param pulumi.Input[_builtins.str] qualifier: Function version or alias
        """
        if async_task is not None:
            pulumi.set(__self__, "async_task", async_task)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if destination_config is not None:
            pulumi.set(__self__, "destination_config", destination_config)
        if function_arn is not None:
            pulumi.set(__self__, "function_arn", function_arn)
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if max_async_event_age_in_seconds is not None:
            pulumi.set(__self__, "max_async_event_age_in_seconds", max_async_event_age_in_seconds)
        if max_async_retry_attempts is not None:
            pulumi.set(__self__, "max_async_retry_attempts", max_async_retry_attempts)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)

    @_builtins.property
    @pulumi.getter(name="asyncTask")
    def async_task(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable an asynchronous task
        """
        return pulumi.get(self, "async_task")

    @async_task.setter
    def async_task(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "async_task", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> Optional[pulumi.Input['V3AsyncInvokeConfigDestinationConfigArgs']]:
        """
        Target Configuration See `destination_config` below.
        """
        return pulumi.get(self, "destination_config")

    @destination_config.setter
    def destination_config(self, value: Optional[pulumi.Input['V3AsyncInvokeConfigDestinationConfigArgs']]):
        pulumi.set(self, "destination_config", value)

    @_builtins.property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.234.0) Function resource identification
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_arn", value)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Function Name
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.234.0) Last modification time
        """
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified_time", value)

    @_builtins.property
    @pulumi.getter(name="maxAsyncEventAgeInSeconds")
    def max_async_event_age_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Event maximum survival time
        """
        return pulumi.get(self, "max_async_event_age_in_seconds")

    @max_async_event_age_in_seconds.setter
    def max_async_event_age_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_async_event_age_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="maxAsyncRetryAttempts")
    def max_async_retry_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of Asynchronous call retries
        """
        return pulumi.get(self, "max_async_retry_attempts")

    @max_async_retry_attempts.setter
    def max_async_retry_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_async_retry_attempts", value)

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Function version or alias
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualifier", value)


@pulumi.type_token("alicloud:fc/v3AsyncInvokeConfig:V3AsyncInvokeConfig")
class V3AsyncInvokeConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 async_task: Optional[pulumi.Input[_builtins.bool]] = None,
                 destination_config: Optional[pulumi.Input[Union['V3AsyncInvokeConfigDestinationConfigArgs', 'V3AsyncInvokeConfigDestinationConfigArgsDict']]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_async_event_age_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 max_async_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a FCV3 Async Invoke Config resource.

        Function Asynchronous Configuration.

        For information about FCV3 Async Invoke Config and how to use it, see [What is Async Invoke Config](https://www.alibabacloud.com/help/en/functioncompute/developer-reference/api-fc-2023-03-30-getasyncinvokeconfig).

        > **NOTE:** Available since v1.228.0.

        ## Import

        FCV3 Async Invoke Config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:fc/v3AsyncInvokeConfig:V3AsyncInvokeConfig example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] async_task: Whether to enable an asynchronous task
        :param pulumi.Input[Union['V3AsyncInvokeConfigDestinationConfigArgs', 'V3AsyncInvokeConfigDestinationConfigArgsDict']] destination_config: Target Configuration See `destination_config` below.
        :param pulumi.Input[_builtins.str] function_name: Function Name
        :param pulumi.Input[_builtins.int] max_async_event_age_in_seconds: Event maximum survival time
        :param pulumi.Input[_builtins.int] max_async_retry_attempts: Number of Asynchronous call retries
        :param pulumi.Input[_builtins.str] qualifier: Function version or alias
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: V3AsyncInvokeConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a FCV3 Async Invoke Config resource.

        Function Asynchronous Configuration.

        For information about FCV3 Async Invoke Config and how to use it, see [What is Async Invoke Config](https://www.alibabacloud.com/help/en/functioncompute/developer-reference/api-fc-2023-03-30-getasyncinvokeconfig).

        > **NOTE:** Available since v1.228.0.

        ## Import

        FCV3 Async Invoke Config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:fc/v3AsyncInvokeConfig:V3AsyncInvokeConfig example <id>
        ```

        :param str resource_name: The name of the resource.
        :param V3AsyncInvokeConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V3AsyncInvokeConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 async_task: Optional[pulumi.Input[_builtins.bool]] = None,
                 destination_config: Optional[pulumi.Input[Union['V3AsyncInvokeConfigDestinationConfigArgs', 'V3AsyncInvokeConfigDestinationConfigArgsDict']]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_async_event_age_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 max_async_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V3AsyncInvokeConfigArgs.__new__(V3AsyncInvokeConfigArgs)

            __props__.__dict__["async_task"] = async_task
            __props__.__dict__["destination_config"] = destination_config
            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            __props__.__dict__["max_async_event_age_in_seconds"] = max_async_event_age_in_seconds
            __props__.__dict__["max_async_retry_attempts"] = max_async_retry_attempts
            __props__.__dict__["qualifier"] = qualifier
            __props__.__dict__["create_time"] = None
            __props__.__dict__["function_arn"] = None
            __props__.__dict__["last_modified_time"] = None
        super(V3AsyncInvokeConfig, __self__).__init__(
            'alicloud:fc/v3AsyncInvokeConfig:V3AsyncInvokeConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            async_task: Optional[pulumi.Input[_builtins.bool]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            destination_config: Optional[pulumi.Input[Union['V3AsyncInvokeConfigDestinationConfigArgs', 'V3AsyncInvokeConfigDestinationConfigArgsDict']]] = None,
            function_arn: Optional[pulumi.Input[_builtins.str]] = None,
            function_name: Optional[pulumi.Input[_builtins.str]] = None,
            last_modified_time: Optional[pulumi.Input[_builtins.str]] = None,
            max_async_event_age_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            max_async_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
            qualifier: Optional[pulumi.Input[_builtins.str]] = None) -> 'V3AsyncInvokeConfig':
        """
        Get an existing V3AsyncInvokeConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] async_task: Whether to enable an asynchronous task
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[Union['V3AsyncInvokeConfigDestinationConfigArgs', 'V3AsyncInvokeConfigDestinationConfigArgsDict']] destination_config: Target Configuration See `destination_config` below.
        :param pulumi.Input[_builtins.str] function_arn: (Available since v1.234.0) Function resource identification
        :param pulumi.Input[_builtins.str] function_name: Function Name
        :param pulumi.Input[_builtins.str] last_modified_time: (Available since v1.234.0) Last modification time
        :param pulumi.Input[_builtins.int] max_async_event_age_in_seconds: Event maximum survival time
        :param pulumi.Input[_builtins.int] max_async_retry_attempts: Number of Asynchronous call retries
        :param pulumi.Input[_builtins.str] qualifier: Function version or alias
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V3AsyncInvokeConfigState.__new__(_V3AsyncInvokeConfigState)

        __props__.__dict__["async_task"] = async_task
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["destination_config"] = destination_config
        __props__.__dict__["function_arn"] = function_arn
        __props__.__dict__["function_name"] = function_name
        __props__.__dict__["last_modified_time"] = last_modified_time
        __props__.__dict__["max_async_event_age_in_seconds"] = max_async_event_age_in_seconds
        __props__.__dict__["max_async_retry_attempts"] = max_async_retry_attempts
        __props__.__dict__["qualifier"] = qualifier
        return V3AsyncInvokeConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="asyncTask")
    def async_task(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable an asynchronous task
        """
        return pulumi.get(self, "async_task")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> pulumi.Output[Optional['outputs.V3AsyncInvokeConfigDestinationConfig']]:
        """
        Target Configuration See `destination_config` below.
        """
        return pulumi.get(self, "destination_config")

    @_builtins.property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.234.0) Function resource identification
        """
        return pulumi.get(self, "function_arn")

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[_builtins.str]:
        """
        Function Name
        """
        return pulumi.get(self, "function_name")

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.234.0) Last modification time
        """
        return pulumi.get(self, "last_modified_time")

    @_builtins.property
    @pulumi.getter(name="maxAsyncEventAgeInSeconds")
    def max_async_event_age_in_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Event maximum survival time
        """
        return pulumi.get(self, "max_async_event_age_in_seconds")

    @_builtins.property
    @pulumi.getter(name="maxAsyncRetryAttempts")
    def max_async_retry_attempts(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of Asynchronous call retries
        """
        return pulumi.get(self, "max_async_retry_attempts")

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Function version or alias
        """
        return pulumi.get(self, "qualifier")

