# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AcceleratorArgs', 'Accelerator']

@pulumi.input_type
class AcceleratorArgs:
    def __init__(__self__, *,
                 accelerator_name: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_use_coupon: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth_billing_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_border_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_border_status: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Accelerator resource.
        :param pulumi.Input[_builtins.str] accelerator_name: The Name of the GA instance.
        :param pulumi.Input[_builtins.int] auto_renew_duration: Auto renewal period of an instance, in the unit of month. The value range is 1-12.
        :param pulumi.Input[_builtins.bool] auto_use_coupon: Use coupons to pay bills automatically. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] bandwidth_billing_type: The bandwidth billing method. Default value: `BandwidthPackage`. Valid values:
               - `BandwidthPackage`: billed based on bandwidth plans.
               - `CDT`: billed based on data transfer.
        :param pulumi.Input[_builtins.str] cross_border_mode: The type of cross-border acceleration. Default value: `bgpPro`. Valid values: `bgpPro`, `private`. **NOTE:** `cross_border_mode` is valid only when `cross_border_status` is set to `true`.
        :param pulumi.Input[_builtins.bool] cross_border_status: Indicates whether cross-border acceleration is enabled. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] description: Descriptive information of the global acceleration instance.
        :param pulumi.Input[_builtins.int] duration: The subscription duration.
               * If the `pricing_cycle` parameter is set to `Month`, the valid values for the `duration` parameter are 1 to 9.
               * If the `pricing_cycle` parameter is set to `Year`, the valid values for the `duration` parameter are 1 to 3.
        :param pulumi.Input[_builtins.str] payment_type: The payment type. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the GA instance. Default value: `Month`. Valid values:
               - `Month`: billed on a monthly basis.
               - `Year`: billed on an annual basis.
        :param pulumi.Input[_builtins.str] promotion_option_no: The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
        :param pulumi.Input[_builtins.str] renewal_status: Whether to renew an accelerator automatically or not. Default value: `Normal`. Valid values:
               - `AutoRenewal`: Enable auto renewal.
               - `Normal`: Disable auto renewal.
               - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param pulumi.Input[_builtins.str] spec: The instance type of the GA instance. Specification of global acceleration instance. Valid values:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if accelerator_name is not None:
            pulumi.set(__self__, "accelerator_name", accelerator_name)
        if auto_renew_duration is not None:
            pulumi.set(__self__, "auto_renew_duration", auto_renew_duration)
        if auto_use_coupon is not None:
            pulumi.set(__self__, "auto_use_coupon", auto_use_coupon)
        if bandwidth_billing_type is not None:
            pulumi.set(__self__, "bandwidth_billing_type", bandwidth_billing_type)
        if cross_border_mode is not None:
            pulumi.set(__self__, "cross_border_mode", cross_border_mode)
        if cross_border_status is not None:
            pulumi.set(__self__, "cross_border_status", cross_border_status)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if promotion_option_no is not None:
            pulumi.set(__self__, "promotion_option_no", promotion_option_no)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="acceleratorName")
    def accelerator_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the GA instance.
        """
        return pulumi.get(self, "accelerator_name")

    @accelerator_name.setter
    def accelerator_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accelerator_name", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Auto renewal period of an instance, in the unit of month. The value range is 1-12.
        """
        return pulumi.get(self, "auto_renew_duration")

    @auto_renew_duration.setter
    def auto_renew_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_duration", value)

    @_builtins.property
    @pulumi.getter(name="autoUseCoupon")
    def auto_use_coupon(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use coupons to pay bills automatically. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "auto_use_coupon")

    @auto_use_coupon.setter
    def auto_use_coupon(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_use_coupon", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthBillingType")
    def bandwidth_billing_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bandwidth billing method. Default value: `BandwidthPackage`. Valid values:
        - `BandwidthPackage`: billed based on bandwidth plans.
        - `CDT`: billed based on data transfer.
        """
        return pulumi.get(self, "bandwidth_billing_type")

    @bandwidth_billing_type.setter
    def bandwidth_billing_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_billing_type", value)

    @_builtins.property
    @pulumi.getter(name="crossBorderMode")
    def cross_border_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of cross-border acceleration. Default value: `bgpPro`. Valid values: `bgpPro`, `private`. **NOTE:** `cross_border_mode` is valid only when `cross_border_status` is set to `true`.
        """
        return pulumi.get(self, "cross_border_mode")

    @cross_border_mode.setter
    def cross_border_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_border_mode", value)

    @_builtins.property
    @pulumi.getter(name="crossBorderStatus")
    def cross_border_status(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether cross-border acceleration is enabled. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "cross_border_status")

    @cross_border_status.setter
    def cross_border_status(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cross_border_status", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Descriptive information of the global acceleration instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The subscription duration.
        * If the `pricing_cycle` parameter is set to `Month`, the valid values for the `duration` parameter are 1 to 9.
        * If the `pricing_cycle` parameter is set to `Year`, the valid values for the `duration` parameter are 1 to 3.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing cycle of the GA instance. Default value: `Month`. Valid values:
        - `Month`: billed on a monthly basis.
        - `Year`: billed on an annual basis.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="promotionOptionNo")
    def promotion_option_no(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
        """
        return pulumi.get(self, "promotion_option_no")

    @promotion_option_no.setter
    def promotion_option_no(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "promotion_option_no", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to renew an accelerator automatically or not. Default value: `Normal`. Valid values:
        - `AutoRenewal`: Enable auto renewal.
        - `Normal`: Disable auto renewal.
        - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance type of the GA instance. Specification of global acceleration instance. Valid values:
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AcceleratorState:
    def __init__(__self__, *,
                 accelerator_name: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_use_coupon: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth_billing_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_border_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_border_status: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Accelerator resources.
        :param pulumi.Input[_builtins.str] accelerator_name: The Name of the GA instance.
        :param pulumi.Input[_builtins.int] auto_renew_duration: Auto renewal period of an instance, in the unit of month. The value range is 1-12.
        :param pulumi.Input[_builtins.bool] auto_use_coupon: Use coupons to pay bills automatically. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] bandwidth_billing_type: The bandwidth billing method. Default value: `BandwidthPackage`. Valid values:
               - `BandwidthPackage`: billed based on bandwidth plans.
               - `CDT`: billed based on data transfer.
        :param pulumi.Input[_builtins.str] cross_border_mode: The type of cross-border acceleration. Default value: `bgpPro`. Valid values: `bgpPro`, `private`. **NOTE:** `cross_border_mode` is valid only when `cross_border_status` is set to `true`.
        :param pulumi.Input[_builtins.bool] cross_border_status: Indicates whether cross-border acceleration is enabled. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] description: Descriptive information of the global acceleration instance.
        :param pulumi.Input[_builtins.int] duration: The subscription duration.
               * If the `pricing_cycle` parameter is set to `Month`, the valid values for the `duration` parameter are 1 to 9.
               * If the `pricing_cycle` parameter is set to `Year`, the valid values for the `duration` parameter are 1 to 3.
        :param pulumi.Input[_builtins.str] payment_type: The payment type. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the GA instance. Default value: `Month`. Valid values:
               - `Month`: billed on a monthly basis.
               - `Year`: billed on an annual basis.
        :param pulumi.Input[_builtins.str] promotion_option_no: The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
        :param pulumi.Input[_builtins.str] renewal_status: Whether to renew an accelerator automatically or not. Default value: `Normal`. Valid values:
               - `AutoRenewal`: Enable auto renewal.
               - `Normal`: Disable auto renewal.
               - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param pulumi.Input[_builtins.str] spec: The instance type of the GA instance. Specification of global acceleration instance. Valid values:
        :param pulumi.Input[_builtins.str] status: The status of the GA instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if accelerator_name is not None:
            pulumi.set(__self__, "accelerator_name", accelerator_name)
        if auto_renew_duration is not None:
            pulumi.set(__self__, "auto_renew_duration", auto_renew_duration)
        if auto_use_coupon is not None:
            pulumi.set(__self__, "auto_use_coupon", auto_use_coupon)
        if bandwidth_billing_type is not None:
            pulumi.set(__self__, "bandwidth_billing_type", bandwidth_billing_type)
        if cross_border_mode is not None:
            pulumi.set(__self__, "cross_border_mode", cross_border_mode)
        if cross_border_status is not None:
            pulumi.set(__self__, "cross_border_status", cross_border_status)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if promotion_option_no is not None:
            pulumi.set(__self__, "promotion_option_no", promotion_option_no)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="acceleratorName")
    def accelerator_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the GA instance.
        """
        return pulumi.get(self, "accelerator_name")

    @accelerator_name.setter
    def accelerator_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accelerator_name", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Auto renewal period of an instance, in the unit of month. The value range is 1-12.
        """
        return pulumi.get(self, "auto_renew_duration")

    @auto_renew_duration.setter
    def auto_renew_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_duration", value)

    @_builtins.property
    @pulumi.getter(name="autoUseCoupon")
    def auto_use_coupon(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use coupons to pay bills automatically. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "auto_use_coupon")

    @auto_use_coupon.setter
    def auto_use_coupon(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_use_coupon", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthBillingType")
    def bandwidth_billing_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bandwidth billing method. Default value: `BandwidthPackage`. Valid values:
        - `BandwidthPackage`: billed based on bandwidth plans.
        - `CDT`: billed based on data transfer.
        """
        return pulumi.get(self, "bandwidth_billing_type")

    @bandwidth_billing_type.setter
    def bandwidth_billing_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_billing_type", value)

    @_builtins.property
    @pulumi.getter(name="crossBorderMode")
    def cross_border_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of cross-border acceleration. Default value: `bgpPro`. Valid values: `bgpPro`, `private`. **NOTE:** `cross_border_mode` is valid only when `cross_border_status` is set to `true`.
        """
        return pulumi.get(self, "cross_border_mode")

    @cross_border_mode.setter
    def cross_border_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_border_mode", value)

    @_builtins.property
    @pulumi.getter(name="crossBorderStatus")
    def cross_border_status(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether cross-border acceleration is enabled. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "cross_border_status")

    @cross_border_status.setter
    def cross_border_status(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cross_border_status", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Descriptive information of the global acceleration instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The subscription duration.
        * If the `pricing_cycle` parameter is set to `Month`, the valid values for the `duration` parameter are 1 to 9.
        * If the `pricing_cycle` parameter is set to `Year`, the valid values for the `duration` parameter are 1 to 3.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing cycle of the GA instance. Default value: `Month`. Valid values:
        - `Month`: billed on a monthly basis.
        - `Year`: billed on an annual basis.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="promotionOptionNo")
    def promotion_option_no(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
        """
        return pulumi.get(self, "promotion_option_no")

    @promotion_option_no.setter
    def promotion_option_no(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "promotion_option_no", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to renew an accelerator automatically or not. Default value: `Normal`. Valid values:
        - `AutoRenewal`: Enable auto renewal.
        - `Normal`: Disable auto renewal.
        - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance type of the GA instance. Specification of global acceleration instance. Valid values:
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the GA instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:ga/accelerator:Accelerator")
class Accelerator(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_name: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_use_coupon: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth_billing_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_border_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_border_status: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Global Accelerator (GA) Accelerator resource.

        For information about Global Accelerator (GA) Accelerator and how to use it, see [What is Accelerator](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createaccelerator).

        > **NOTE:** Available since v1.111.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.ga.Accelerator("example",
            duration=1,
            auto_use_coupon=True,
            spec="1")
        ```

        ## Import

        Ga Accelerator can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ga/accelerator:Accelerator example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accelerator_name: The Name of the GA instance.
        :param pulumi.Input[_builtins.int] auto_renew_duration: Auto renewal period of an instance, in the unit of month. The value range is 1-12.
        :param pulumi.Input[_builtins.bool] auto_use_coupon: Use coupons to pay bills automatically. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] bandwidth_billing_type: The bandwidth billing method. Default value: `BandwidthPackage`. Valid values:
               - `BandwidthPackage`: billed based on bandwidth plans.
               - `CDT`: billed based on data transfer.
        :param pulumi.Input[_builtins.str] cross_border_mode: The type of cross-border acceleration. Default value: `bgpPro`. Valid values: `bgpPro`, `private`. **NOTE:** `cross_border_mode` is valid only when `cross_border_status` is set to `true`.
        :param pulumi.Input[_builtins.bool] cross_border_status: Indicates whether cross-border acceleration is enabled. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] description: Descriptive information of the global acceleration instance.
        :param pulumi.Input[_builtins.int] duration: The subscription duration.
               * If the `pricing_cycle` parameter is set to `Month`, the valid values for the `duration` parameter are 1 to 9.
               * If the `pricing_cycle` parameter is set to `Year`, the valid values for the `duration` parameter are 1 to 3.
        :param pulumi.Input[_builtins.str] payment_type: The payment type. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the GA instance. Default value: `Month`. Valid values:
               - `Month`: billed on a monthly basis.
               - `Year`: billed on an annual basis.
        :param pulumi.Input[_builtins.str] promotion_option_no: The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
        :param pulumi.Input[_builtins.str] renewal_status: Whether to renew an accelerator automatically or not. Default value: `Normal`. Valid values:
               - `AutoRenewal`: Enable auto renewal.
               - `Normal`: Disable auto renewal.
               - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param pulumi.Input[_builtins.str] spec: The instance type of the GA instance. Specification of global acceleration instance. Valid values:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AcceleratorArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Global Accelerator (GA) Accelerator resource.

        For information about Global Accelerator (GA) Accelerator and how to use it, see [What is Accelerator](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createaccelerator).

        > **NOTE:** Available since v1.111.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.ga.Accelerator("example",
            duration=1,
            auto_use_coupon=True,
            spec="1")
        ```

        ## Import

        Ga Accelerator can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ga/accelerator:Accelerator example <id>
        ```

        :param str resource_name: The name of the resource.
        :param AcceleratorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AcceleratorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_name: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_use_coupon: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth_billing_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_border_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_border_status: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AcceleratorArgs.__new__(AcceleratorArgs)

            __props__.__dict__["accelerator_name"] = accelerator_name
            __props__.__dict__["auto_renew_duration"] = auto_renew_duration
            __props__.__dict__["auto_use_coupon"] = auto_use_coupon
            __props__.__dict__["bandwidth_billing_type"] = bandwidth_billing_type
            __props__.__dict__["cross_border_mode"] = cross_border_mode
            __props__.__dict__["cross_border_status"] = cross_border_status
            __props__.__dict__["description"] = description
            __props__.__dict__["duration"] = duration
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["pricing_cycle"] = pricing_cycle
            __props__.__dict__["promotion_option_no"] = promotion_option_no
            __props__.__dict__["renewal_status"] = renewal_status
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["spec"] = spec
            __props__.__dict__["tags"] = tags
            __props__.__dict__["status"] = None
        super(Accelerator, __self__).__init__(
            'alicloud:ga/accelerator:Accelerator',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accelerator_name: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew_duration: Optional[pulumi.Input[_builtins.int]] = None,
            auto_use_coupon: Optional[pulumi.Input[_builtins.bool]] = None,
            bandwidth_billing_type: Optional[pulumi.Input[_builtins.str]] = None,
            cross_border_mode: Optional[pulumi.Input[_builtins.str]] = None,
            cross_border_status: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            duration: Optional[pulumi.Input[_builtins.int]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
            promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
            renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            spec: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Accelerator':
        """
        Get an existing Accelerator resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accelerator_name: The Name of the GA instance.
        :param pulumi.Input[_builtins.int] auto_renew_duration: Auto renewal period of an instance, in the unit of month. The value range is 1-12.
        :param pulumi.Input[_builtins.bool] auto_use_coupon: Use coupons to pay bills automatically. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] bandwidth_billing_type: The bandwidth billing method. Default value: `BandwidthPackage`. Valid values:
               - `BandwidthPackage`: billed based on bandwidth plans.
               - `CDT`: billed based on data transfer.
        :param pulumi.Input[_builtins.str] cross_border_mode: The type of cross-border acceleration. Default value: `bgpPro`. Valid values: `bgpPro`, `private`. **NOTE:** `cross_border_mode` is valid only when `cross_border_status` is set to `true`.
        :param pulumi.Input[_builtins.bool] cross_border_status: Indicates whether cross-border acceleration is enabled. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] description: Descriptive information of the global acceleration instance.
        :param pulumi.Input[_builtins.int] duration: The subscription duration.
               * If the `pricing_cycle` parameter is set to `Month`, the valid values for the `duration` parameter are 1 to 9.
               * If the `pricing_cycle` parameter is set to `Year`, the valid values for the `duration` parameter are 1 to 3.
        :param pulumi.Input[_builtins.str] payment_type: The payment type. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the GA instance. Default value: `Month`. Valid values:
               - `Month`: billed on a monthly basis.
               - `Year`: billed on an annual basis.
        :param pulumi.Input[_builtins.str] promotion_option_no: The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
        :param pulumi.Input[_builtins.str] renewal_status: Whether to renew an accelerator automatically or not. Default value: `Normal`. Valid values:
               - `AutoRenewal`: Enable auto renewal.
               - `Normal`: Disable auto renewal.
               - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param pulumi.Input[_builtins.str] spec: The instance type of the GA instance. Specification of global acceleration instance. Valid values:
        :param pulumi.Input[_builtins.str] status: The status of the GA instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AcceleratorState.__new__(_AcceleratorState)

        __props__.__dict__["accelerator_name"] = accelerator_name
        __props__.__dict__["auto_renew_duration"] = auto_renew_duration
        __props__.__dict__["auto_use_coupon"] = auto_use_coupon
        __props__.__dict__["bandwidth_billing_type"] = bandwidth_billing_type
        __props__.__dict__["cross_border_mode"] = cross_border_mode
        __props__.__dict__["cross_border_status"] = cross_border_status
        __props__.__dict__["description"] = description
        __props__.__dict__["duration"] = duration
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["pricing_cycle"] = pricing_cycle
        __props__.__dict__["promotion_option_no"] = promotion_option_no
        __props__.__dict__["renewal_status"] = renewal_status
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["spec"] = spec
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return Accelerator(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acceleratorName")
    def accelerator_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Name of the GA instance.
        """
        return pulumi.get(self, "accelerator_name")

    @_builtins.property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> pulumi.Output[_builtins.int]:
        """
        Auto renewal period of an instance, in the unit of month. The value range is 1-12.
        """
        return pulumi.get(self, "auto_renew_duration")

    @_builtins.property
    @pulumi.getter(name="autoUseCoupon")
    def auto_use_coupon(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Use coupons to pay bills automatically. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "auto_use_coupon")

    @_builtins.property
    @pulumi.getter(name="bandwidthBillingType")
    def bandwidth_billing_type(self) -> pulumi.Output[_builtins.str]:
        """
        The bandwidth billing method. Default value: `BandwidthPackage`. Valid values:
        - `BandwidthPackage`: billed based on bandwidth plans.
        - `CDT`: billed based on data transfer.
        """
        return pulumi.get(self, "bandwidth_billing_type")

    @_builtins.property
    @pulumi.getter(name="crossBorderMode")
    def cross_border_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The type of cross-border acceleration. Default value: `bgpPro`. Valid values: `bgpPro`, `private`. **NOTE:** `cross_border_mode` is valid only when `cross_border_status` is set to `true`.
        """
        return pulumi.get(self, "cross_border_mode")

    @_builtins.property
    @pulumi.getter(name="crossBorderStatus")
    def cross_border_status(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether cross-border acceleration is enabled. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "cross_border_status")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Descriptive information of the global acceleration instance.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The subscription duration.
        * If the `pricing_cycle` parameter is set to `Month`, the valid values for the `duration` parameter are 1 to 9.
        * If the `pricing_cycle` parameter is set to `Year`, the valid values for the `duration` parameter are 1 to 3.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The billing cycle of the GA instance. Default value: `Month`. Valid values:
        - `Month`: billed on a monthly basis.
        - `Year`: billed on an annual basis.
        """
        return pulumi.get(self, "pricing_cycle")

    @_builtins.property
    @pulumi.getter(name="promotionOptionNo")
    def promotion_option_no(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
        """
        return pulumi.get(self, "promotion_option_no")

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> pulumi.Output[_builtins.str]:
        """
        Whether to renew an accelerator automatically or not. Default value: `Normal`. Valid values:
        - `AutoRenewal`: Enable auto renewal.
        - `Normal`: Disable auto renewal.
        - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        """
        return pulumi.get(self, "renewal_status")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The instance type of the GA instance. Specification of global acceleration instance. Valid values:
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the GA instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

