# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BandwidthPackageArgs', 'BandwidthPackage']

@pulumi.input_type
class BandwidthPackageArgs:
    def __init__(__self__, *,
                 bandwidth: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.str],
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_use_coupon: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth_package_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cbn_geographic_region_ida: Optional[pulumi.Input[_builtins.str]] = None,
                 cbn_geographic_region_idb: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
                 ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a BandwidthPackage resource.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth value of bandwidth packet.
        :param pulumi.Input[_builtins.str] type: The type of the bandwidth packet. China station only supports return to basic. Valid values: `Basic`, `CrossDomain`.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. Valid values:
        :param pulumi.Input[_builtins.int] auto_renew_duration: Auto renewal period of a bandwidth packet, in the unit of month. Valid values: `1` to `12`.
        :param pulumi.Input[_builtins.bool] auto_use_coupon: Whether use vouchers. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] bandwidth_package_name: The name of the bandwidth packet.
        :param pulumi.Input[_builtins.str] bandwidth_type: The bandwidth type of the bandwidth. Valid values: `Advanced`, `Basic`, `Enhanced`. If `type` is set to `Basic`, this parameter is required.
               > **NOTE:** At present, only basic can be configured to enhanced, but not enhanced and advanced to other types of accelerated bandwidth.
        :param pulumi.Input[_builtins.str] billing_type: The billing type. Valid values: `PayBy95`, `PayByTraffic`. **NOTE:** `billing_type` is valid only when `payment_type` is set to `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] cbn_geographic_region_ida: Interworking area A of cross domain acceleration package. Only international stations support returning this parameter. Default value: `China-mainland`.
        :param pulumi.Input[_builtins.str] cbn_geographic_region_idb: Interworking area B of cross domain acceleration package. Only international stations support returning this parameter. Default value: `Global`.
        :param pulumi.Input[_builtins.str] description: The description of bandwidth package.
        :param pulumi.Input[_builtins.str] duration: The subscription duration. **NOTE:** The ForceNew attribute has be removed from version 1.148.0. If `payment_type` is set to `Subscription`, this parameter is required.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the bandwidth. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
        :param pulumi.Input[_builtins.str] promotion_option_no: The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
        :param pulumi.Input[_builtins.int] ratio: The minimum percentage for the pay-by-95th-percentile metering method. Valid values: `30` to `100`. **NOTE:** `ratio` is valid only when `billing_type` is set to `PayBy95`.
        :param pulumi.Input[_builtins.str] renewal_status: Whether to renew a bandwidth packet. automatically or not. Valid values:
               - `AutoRenewal`: Enable auto renewal.
               - `Normal`: Disable auto renewal.
               - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "type", type)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew_duration is not None:
            pulumi.set(__self__, "auto_renew_duration", auto_renew_duration)
        if auto_use_coupon is not None:
            pulumi.set(__self__, "auto_use_coupon", auto_use_coupon)
        if bandwidth_package_name is not None:
            pulumi.set(__self__, "bandwidth_package_name", bandwidth_package_name)
        if bandwidth_type is not None:
            pulumi.set(__self__, "bandwidth_type", bandwidth_type)
        if billing_type is not None:
            pulumi.set(__self__, "billing_type", billing_type)
        if cbn_geographic_region_ida is not None:
            pulumi.set(__self__, "cbn_geographic_region_ida", cbn_geographic_region_ida)
        if cbn_geographic_region_idb is not None:
            pulumi.set(__self__, "cbn_geographic_region_idb", cbn_geographic_region_idb)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if promotion_option_no is not None:
            pulumi.set(__self__, "promotion_option_no", promotion_option_no)
        if ratio is not None:
            pulumi.set(__self__, "ratio", ratio)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Input[_builtins.int]:
        """
        The bandwidth value of bandwidth packet.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the bandwidth packet. China station only supports return to basic. Valid values: `Basic`, `CrossDomain`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to pay automatically. Valid values:
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Auto renewal period of a bandwidth packet, in the unit of month. Valid values: `1` to `12`.
        """
        return pulumi.get(self, "auto_renew_duration")

    @auto_renew_duration.setter
    def auto_renew_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_duration", value)

    @_builtins.property
    @pulumi.getter(name="autoUseCoupon")
    def auto_use_coupon(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether use vouchers. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "auto_use_coupon")

    @auto_use_coupon.setter
    def auto_use_coupon(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_use_coupon", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageName")
    def bandwidth_package_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bandwidth packet.
        """
        return pulumi.get(self, "bandwidth_package_name")

    @bandwidth_package_name.setter
    def bandwidth_package_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_package_name", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthType")
    def bandwidth_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bandwidth type of the bandwidth. Valid values: `Advanced`, `Basic`, `Enhanced`. If `type` is set to `Basic`, this parameter is required.
        > **NOTE:** At present, only basic can be configured to enhanced, but not enhanced and advanced to other types of accelerated bandwidth.
        """
        return pulumi.get(self, "bandwidth_type")

    @bandwidth_type.setter
    def bandwidth_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_type", value)

    @_builtins.property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing type. Valid values: `PayBy95`, `PayByTraffic`. **NOTE:** `billing_type` is valid only when `payment_type` is set to `PayAsYouGo`.
        """
        return pulumi.get(self, "billing_type")

    @billing_type.setter
    def billing_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "billing_type", value)

    @_builtins.property
    @pulumi.getter(name="cbnGeographicRegionIda")
    def cbn_geographic_region_ida(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interworking area A of cross domain acceleration package. Only international stations support returning this parameter. Default value: `China-mainland`.
        """
        return pulumi.get(self, "cbn_geographic_region_ida")

    @cbn_geographic_region_ida.setter
    def cbn_geographic_region_ida(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cbn_geographic_region_ida", value)

    @_builtins.property
    @pulumi.getter(name="cbnGeographicRegionIdb")
    def cbn_geographic_region_idb(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interworking area B of cross domain acceleration package. Only international stations support returning this parameter. Default value: `Global`.
        """
        return pulumi.get(self, "cbn_geographic_region_idb")

    @cbn_geographic_region_idb.setter
    def cbn_geographic_region_idb(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cbn_geographic_region_idb", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of bandwidth package.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription duration. **NOTE:** The ForceNew attribute has be removed from version 1.148.0. If `payment_type` is set to `Subscription`, this parameter is required.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the bandwidth. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="promotionOptionNo")
    def promotion_option_no(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
        """
        return pulumi.get(self, "promotion_option_no")

    @promotion_option_no.setter
    def promotion_option_no(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "promotion_option_no", value)

    @_builtins.property
    @pulumi.getter
    def ratio(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum percentage for the pay-by-95th-percentile metering method. Valid values: `30` to `100`. **NOTE:** `ratio` is valid only when `billing_type` is set to `PayBy95`.
        """
        return pulumi.get(self, "ratio")

    @ratio.setter
    def ratio(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ratio", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to renew a bandwidth packet. automatically or not. Valid values:
        - `AutoRenewal`: Enable auto renewal.
        - `Normal`: Disable auto renewal.
        - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _BandwidthPackageState:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_use_coupon: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 bandwidth_package_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cbn_geographic_region_ida: Optional[pulumi.Input[_builtins.str]] = None,
                 cbn_geographic_region_idb: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
                 ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BandwidthPackage resources.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. Valid values:
        :param pulumi.Input[_builtins.int] auto_renew_duration: Auto renewal period of a bandwidth packet, in the unit of month. Valid values: `1` to `12`.
        :param pulumi.Input[_builtins.bool] auto_use_coupon: Whether use vouchers. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth value of bandwidth packet.
        :param pulumi.Input[_builtins.str] bandwidth_package_name: The name of the bandwidth packet.
        :param pulumi.Input[_builtins.str] bandwidth_type: The bandwidth type of the bandwidth. Valid values: `Advanced`, `Basic`, `Enhanced`. If `type` is set to `Basic`, this parameter is required.
               > **NOTE:** At present, only basic can be configured to enhanced, but not enhanced and advanced to other types of accelerated bandwidth.
        :param pulumi.Input[_builtins.str] billing_type: The billing type. Valid values: `PayBy95`, `PayByTraffic`. **NOTE:** `billing_type` is valid only when `payment_type` is set to `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] cbn_geographic_region_ida: Interworking area A of cross domain acceleration package. Only international stations support returning this parameter. Default value: `China-mainland`.
        :param pulumi.Input[_builtins.str] cbn_geographic_region_idb: Interworking area B of cross domain acceleration package. Only international stations support returning this parameter. Default value: `Global`.
        :param pulumi.Input[_builtins.str] description: The description of bandwidth package.
        :param pulumi.Input[_builtins.str] duration: The subscription duration. **NOTE:** The ForceNew attribute has be removed from version 1.148.0. If `payment_type` is set to `Subscription`, this parameter is required.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the bandwidth. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
        :param pulumi.Input[_builtins.str] promotion_option_no: The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
        :param pulumi.Input[_builtins.int] ratio: The minimum percentage for the pay-by-95th-percentile metering method. Valid values: `30` to `100`. **NOTE:** `ratio` is valid only when `billing_type` is set to `PayBy95`.
        :param pulumi.Input[_builtins.str] renewal_status: Whether to renew a bandwidth packet. automatically or not. Valid values:
               - `AutoRenewal`: Enable auto renewal.
               - `Normal`: Disable auto renewal.
               - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param pulumi.Input[_builtins.str] status: The status of the Bandwidth Package.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The type of the bandwidth packet. China station only supports return to basic. Valid values: `Basic`, `CrossDomain`.
        """
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew_duration is not None:
            pulumi.set(__self__, "auto_renew_duration", auto_renew_duration)
        if auto_use_coupon is not None:
            pulumi.set(__self__, "auto_use_coupon", auto_use_coupon)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if bandwidth_package_name is not None:
            pulumi.set(__self__, "bandwidth_package_name", bandwidth_package_name)
        if bandwidth_type is not None:
            pulumi.set(__self__, "bandwidth_type", bandwidth_type)
        if billing_type is not None:
            pulumi.set(__self__, "billing_type", billing_type)
        if cbn_geographic_region_ida is not None:
            pulumi.set(__self__, "cbn_geographic_region_ida", cbn_geographic_region_ida)
        if cbn_geographic_region_idb is not None:
            pulumi.set(__self__, "cbn_geographic_region_idb", cbn_geographic_region_idb)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if promotion_option_no is not None:
            pulumi.set(__self__, "promotion_option_no", promotion_option_no)
        if ratio is not None:
            pulumi.set(__self__, "ratio", ratio)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to pay automatically. Valid values:
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Auto renewal period of a bandwidth packet, in the unit of month. Valid values: `1` to `12`.
        """
        return pulumi.get(self, "auto_renew_duration")

    @auto_renew_duration.setter
    def auto_renew_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_duration", value)

    @_builtins.property
    @pulumi.getter(name="autoUseCoupon")
    def auto_use_coupon(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether use vouchers. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "auto_use_coupon")

    @auto_use_coupon.setter
    def auto_use_coupon(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_use_coupon", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth value of bandwidth packet.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageName")
    def bandwidth_package_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bandwidth packet.
        """
        return pulumi.get(self, "bandwidth_package_name")

    @bandwidth_package_name.setter
    def bandwidth_package_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_package_name", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthType")
    def bandwidth_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bandwidth type of the bandwidth. Valid values: `Advanced`, `Basic`, `Enhanced`. If `type` is set to `Basic`, this parameter is required.
        > **NOTE:** At present, only basic can be configured to enhanced, but not enhanced and advanced to other types of accelerated bandwidth.
        """
        return pulumi.get(self, "bandwidth_type")

    @bandwidth_type.setter
    def bandwidth_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_type", value)

    @_builtins.property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing type. Valid values: `PayBy95`, `PayByTraffic`. **NOTE:** `billing_type` is valid only when `payment_type` is set to `PayAsYouGo`.
        """
        return pulumi.get(self, "billing_type")

    @billing_type.setter
    def billing_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "billing_type", value)

    @_builtins.property
    @pulumi.getter(name="cbnGeographicRegionIda")
    def cbn_geographic_region_ida(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interworking area A of cross domain acceleration package. Only international stations support returning this parameter. Default value: `China-mainland`.
        """
        return pulumi.get(self, "cbn_geographic_region_ida")

    @cbn_geographic_region_ida.setter
    def cbn_geographic_region_ida(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cbn_geographic_region_ida", value)

    @_builtins.property
    @pulumi.getter(name="cbnGeographicRegionIdb")
    def cbn_geographic_region_idb(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interworking area B of cross domain acceleration package. Only international stations support returning this parameter. Default value: `Global`.
        """
        return pulumi.get(self, "cbn_geographic_region_idb")

    @cbn_geographic_region_idb.setter
    def cbn_geographic_region_idb(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cbn_geographic_region_idb", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of bandwidth package.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription duration. **NOTE:** The ForceNew attribute has be removed from version 1.148.0. If `payment_type` is set to `Subscription`, this parameter is required.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the bandwidth. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="promotionOptionNo")
    def promotion_option_no(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
        """
        return pulumi.get(self, "promotion_option_no")

    @promotion_option_no.setter
    def promotion_option_no(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "promotion_option_no", value)

    @_builtins.property
    @pulumi.getter
    def ratio(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum percentage for the pay-by-95th-percentile metering method. Valid values: `30` to `100`. **NOTE:** `ratio` is valid only when `billing_type` is set to `PayBy95`.
        """
        return pulumi.get(self, "ratio")

    @ratio.setter
    def ratio(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ratio", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to renew a bandwidth packet. automatically or not. Valid values:
        - `AutoRenewal`: Enable auto renewal.
        - `Normal`: Disable auto renewal.
        - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Bandwidth Package.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the bandwidth packet. China station only supports return to basic. Valid values: `Basic`, `CrossDomain`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("alicloud:ga/bandwidthPackage:BandwidthPackage")
class BandwidthPackage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_use_coupon: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 bandwidth_package_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cbn_geographic_region_ida: Optional[pulumi.Input[_builtins.str]] = None,
                 cbn_geographic_region_idb: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
                 ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Global Accelerator (GA) Bandwidth Package resource.

        For information about Global Accelerator (GA) Bandwidth Package and how to use it, see [What is Bandwidth Package](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createbandwidthpackage).

        > **NOTE:** At present, The `ga.BandwidthPackage` created with `Subscription` cannot be deleted. you need to wait until the resource is outdated and released automatically.

        > **NOTE:** Available since v1.112.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.ga.BandwidthPackage("example",
            bandwidth=20,
            type="Basic",
            bandwidth_type="Basic",
            duration="1",
            auto_pay=True)
        ```

        ## Import

        Ga Bandwidth Package can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ga/bandwidthPackage:BandwidthPackage example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. Valid values:
        :param pulumi.Input[_builtins.int] auto_renew_duration: Auto renewal period of a bandwidth packet, in the unit of month. Valid values: `1` to `12`.
        :param pulumi.Input[_builtins.bool] auto_use_coupon: Whether use vouchers. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth value of bandwidth packet.
        :param pulumi.Input[_builtins.str] bandwidth_package_name: The name of the bandwidth packet.
        :param pulumi.Input[_builtins.str] bandwidth_type: The bandwidth type of the bandwidth. Valid values: `Advanced`, `Basic`, `Enhanced`. If `type` is set to `Basic`, this parameter is required.
               > **NOTE:** At present, only basic can be configured to enhanced, but not enhanced and advanced to other types of accelerated bandwidth.
        :param pulumi.Input[_builtins.str] billing_type: The billing type. Valid values: `PayBy95`, `PayByTraffic`. **NOTE:** `billing_type` is valid only when `payment_type` is set to `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] cbn_geographic_region_ida: Interworking area A of cross domain acceleration package. Only international stations support returning this parameter. Default value: `China-mainland`.
        :param pulumi.Input[_builtins.str] cbn_geographic_region_idb: Interworking area B of cross domain acceleration package. Only international stations support returning this parameter. Default value: `Global`.
        :param pulumi.Input[_builtins.str] description: The description of bandwidth package.
        :param pulumi.Input[_builtins.str] duration: The subscription duration. **NOTE:** The ForceNew attribute has be removed from version 1.148.0. If `payment_type` is set to `Subscription`, this parameter is required.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the bandwidth. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
        :param pulumi.Input[_builtins.str] promotion_option_no: The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
        :param pulumi.Input[_builtins.int] ratio: The minimum percentage for the pay-by-95th-percentile metering method. Valid values: `30` to `100`. **NOTE:** `ratio` is valid only when `billing_type` is set to `PayBy95`.
        :param pulumi.Input[_builtins.str] renewal_status: Whether to renew a bandwidth packet. automatically or not. Valid values:
               - `AutoRenewal`: Enable auto renewal.
               - `Normal`: Disable auto renewal.
               - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The type of the bandwidth packet. China station only supports return to basic. Valid values: `Basic`, `CrossDomain`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BandwidthPackageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Global Accelerator (GA) Bandwidth Package resource.

        For information about Global Accelerator (GA) Bandwidth Package and how to use it, see [What is Bandwidth Package](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createbandwidthpackage).

        > **NOTE:** At present, The `ga.BandwidthPackage` created with `Subscription` cannot be deleted. you need to wait until the resource is outdated and released automatically.

        > **NOTE:** Available since v1.112.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.ga.BandwidthPackage("example",
            bandwidth=20,
            type="Basic",
            bandwidth_type="Basic",
            duration="1",
            auto_pay=True)
        ```

        ## Import

        Ga Bandwidth Package can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ga/bandwidthPackage:BandwidthPackage example <id>
        ```

        :param str resource_name: The name of the resource.
        :param BandwidthPackageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BandwidthPackageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_use_coupon: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 bandwidth_package_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cbn_geographic_region_ida: Optional[pulumi.Input[_builtins.str]] = None,
                 cbn_geographic_region_idb: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
                 ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BandwidthPackageArgs.__new__(BandwidthPackageArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew_duration"] = auto_renew_duration
            __props__.__dict__["auto_use_coupon"] = auto_use_coupon
            if bandwidth is None and not opts.urn:
                raise TypeError("Missing required property 'bandwidth'")
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["bandwidth_package_name"] = bandwidth_package_name
            __props__.__dict__["bandwidth_type"] = bandwidth_type
            __props__.__dict__["billing_type"] = billing_type
            __props__.__dict__["cbn_geographic_region_ida"] = cbn_geographic_region_ida
            __props__.__dict__["cbn_geographic_region_idb"] = cbn_geographic_region_idb
            __props__.__dict__["description"] = description
            __props__.__dict__["duration"] = duration
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["promotion_option_no"] = promotion_option_no
            __props__.__dict__["ratio"] = ratio
            __props__.__dict__["renewal_status"] = renewal_status
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["status"] = None
        super(BandwidthPackage, __self__).__init__(
            'alicloud:ga/bandwidthPackage:BandwidthPackage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_renew_duration: Optional[pulumi.Input[_builtins.int]] = None,
            auto_use_coupon: Optional[pulumi.Input[_builtins.bool]] = None,
            bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            bandwidth_package_name: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth_type: Optional[pulumi.Input[_builtins.str]] = None,
            billing_type: Optional[pulumi.Input[_builtins.str]] = None,
            cbn_geographic_region_ida: Optional[pulumi.Input[_builtins.str]] = None,
            cbn_geographic_region_idb: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            duration: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
            ratio: Optional[pulumi.Input[_builtins.int]] = None,
            renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'BandwidthPackage':
        """
        Get an existing BandwidthPackage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. Valid values:
        :param pulumi.Input[_builtins.int] auto_renew_duration: Auto renewal period of a bandwidth packet, in the unit of month. Valid values: `1` to `12`.
        :param pulumi.Input[_builtins.bool] auto_use_coupon: Whether use vouchers. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth value of bandwidth packet.
        :param pulumi.Input[_builtins.str] bandwidth_package_name: The name of the bandwidth packet.
        :param pulumi.Input[_builtins.str] bandwidth_type: The bandwidth type of the bandwidth. Valid values: `Advanced`, `Basic`, `Enhanced`. If `type` is set to `Basic`, this parameter is required.
               > **NOTE:** At present, only basic can be configured to enhanced, but not enhanced and advanced to other types of accelerated bandwidth.
        :param pulumi.Input[_builtins.str] billing_type: The billing type. Valid values: `PayBy95`, `PayByTraffic`. **NOTE:** `billing_type` is valid only when `payment_type` is set to `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] cbn_geographic_region_ida: Interworking area A of cross domain acceleration package. Only international stations support returning this parameter. Default value: `China-mainland`.
        :param pulumi.Input[_builtins.str] cbn_geographic_region_idb: Interworking area B of cross domain acceleration package. Only international stations support returning this parameter. Default value: `Global`.
        :param pulumi.Input[_builtins.str] description: The description of bandwidth package.
        :param pulumi.Input[_builtins.str] duration: The subscription duration. **NOTE:** The ForceNew attribute has be removed from version 1.148.0. If `payment_type` is set to `Subscription`, this parameter is required.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the bandwidth. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
        :param pulumi.Input[_builtins.str] promotion_option_no: The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
        :param pulumi.Input[_builtins.int] ratio: The minimum percentage for the pay-by-95th-percentile metering method. Valid values: `30` to `100`. **NOTE:** `ratio` is valid only when `billing_type` is set to `PayBy95`.
        :param pulumi.Input[_builtins.str] renewal_status: Whether to renew a bandwidth packet. automatically or not. Valid values:
               - `AutoRenewal`: Enable auto renewal.
               - `Normal`: Disable auto renewal.
               - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param pulumi.Input[_builtins.str] status: The status of the Bandwidth Package.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The type of the bandwidth packet. China station only supports return to basic. Valid values: `Basic`, `CrossDomain`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BandwidthPackageState.__new__(_BandwidthPackageState)

        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew_duration"] = auto_renew_duration
        __props__.__dict__["auto_use_coupon"] = auto_use_coupon
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["bandwidth_package_name"] = bandwidth_package_name
        __props__.__dict__["bandwidth_type"] = bandwidth_type
        __props__.__dict__["billing_type"] = billing_type
        __props__.__dict__["cbn_geographic_region_ida"] = cbn_geographic_region_ida
        __props__.__dict__["cbn_geographic_region_idb"] = cbn_geographic_region_idb
        __props__.__dict__["description"] = description
        __props__.__dict__["duration"] = duration
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["promotion_option_no"] = promotion_option_no
        __props__.__dict__["ratio"] = ratio
        __props__.__dict__["renewal_status"] = renewal_status
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        return BandwidthPackage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to pay automatically. Valid values:
        """
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> pulumi.Output[_builtins.int]:
        """
        Auto renewal period of a bandwidth packet, in the unit of month. Valid values: `1` to `12`.
        """
        return pulumi.get(self, "auto_renew_duration")

    @_builtins.property
    @pulumi.getter(name="autoUseCoupon")
    def auto_use_coupon(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether use vouchers. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "auto_use_coupon")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[_builtins.int]:
        """
        The bandwidth value of bandwidth packet.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageName")
    def bandwidth_package_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the bandwidth packet.
        """
        return pulumi.get(self, "bandwidth_package_name")

    @_builtins.property
    @pulumi.getter(name="bandwidthType")
    def bandwidth_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The bandwidth type of the bandwidth. Valid values: `Advanced`, `Basic`, `Enhanced`. If `type` is set to `Basic`, this parameter is required.
        > **NOTE:** At present, only basic can be configured to enhanced, but not enhanced and advanced to other types of accelerated bandwidth.
        """
        return pulumi.get(self, "bandwidth_type")

    @_builtins.property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The billing type. Valid values: `PayBy95`, `PayByTraffic`. **NOTE:** `billing_type` is valid only when `payment_type` is set to `PayAsYouGo`.
        """
        return pulumi.get(self, "billing_type")

    @_builtins.property
    @pulumi.getter(name="cbnGeographicRegionIda")
    def cbn_geographic_region_ida(self) -> pulumi.Output[_builtins.str]:
        """
        Interworking area A of cross domain acceleration package. Only international stations support returning this parameter. Default value: `China-mainland`.
        """
        return pulumi.get(self, "cbn_geographic_region_ida")

    @_builtins.property
    @pulumi.getter(name="cbnGeographicRegionIdb")
    def cbn_geographic_region_idb(self) -> pulumi.Output[_builtins.str]:
        """
        Interworking area B of cross domain acceleration package. Only international stations support returning this parameter. Default value: `Global`.
        """
        return pulumi.get(self, "cbn_geographic_region_idb")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of bandwidth package.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The subscription duration. **NOTE:** The ForceNew attribute has be removed from version 1.148.0. If `payment_type` is set to `Subscription`, this parameter is required.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The payment type of the bandwidth. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="promotionOptionNo")
    def promotion_option_no(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
        """
        return pulumi.get(self, "promotion_option_no")

    @_builtins.property
    @pulumi.getter
    def ratio(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The minimum percentage for the pay-by-95th-percentile metering method. Valid values: `30` to `100`. **NOTE:** `ratio` is valid only when `billing_type` is set to `PayBy95`.
        """
        return pulumi.get(self, "ratio")

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> pulumi.Output[_builtins.str]:
        """
        Whether to renew a bandwidth packet. automatically or not. Valid values:
        - `AutoRenewal`: Enable auto renewal.
        - `Normal`: Disable auto renewal.
        - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        """
        return pulumi.get(self, "renewal_status")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Bandwidth Package.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the bandwidth packet. China station only supports return to basic. Valid values: `Basic`, `CrossDomain`.
        """
        return pulumi.get(self, "type")

