# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BasicAccelerateIpEndpointRelationArgs', 'BasicAccelerateIpEndpointRelation']

@pulumi.input_type
class BasicAccelerateIpEndpointRelationArgs:
    def __init__(__self__, *,
                 accelerate_ip_id: pulumi.Input[_builtins.str],
                 accelerator_id: pulumi.Input[_builtins.str],
                 endpoint_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a BasicAccelerateIpEndpointRelation resource.
        :param pulumi.Input[_builtins.str] accelerate_ip_id: The ID of the Basic Accelerate IP.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the Basic GA instance.
        :param pulumi.Input[_builtins.str] endpoint_id: The ID of the Basic Endpoint.
        """
        pulumi.set(__self__, "accelerate_ip_id", accelerate_ip_id)
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "endpoint_id", endpoint_id)

    @_builtins.property
    @pulumi.getter(name="accelerateIpId")
    def accelerate_ip_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Basic Accelerate IP.
        """
        return pulumi.get(self, "accelerate_ip_id")

    @accelerate_ip_id.setter
    def accelerate_ip_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "accelerate_ip_id", value)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Basic GA instance.
        """
        return pulumi.get(self, "accelerator_id")

    @accelerator_id.setter
    def accelerator_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "accelerator_id", value)

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Basic Endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint_id", value)


@pulumi.input_type
class _BasicAccelerateIpEndpointRelationState:
    def __init__(__self__, *,
                 accelerate_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BasicAccelerateIpEndpointRelation resources.
        :param pulumi.Input[_builtins.str] accelerate_ip_id: The ID of the Basic Accelerate IP.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the Basic GA instance.
        :param pulumi.Input[_builtins.str] endpoint_id: The ID of the Basic Endpoint.
        :param pulumi.Input[_builtins.str] status: The status of the Basic Accelerate Ip Endpoint Relation.
        """
        if accelerate_ip_id is not None:
            pulumi.set(__self__, "accelerate_ip_id", accelerate_ip_id)
        if accelerator_id is not None:
            pulumi.set(__self__, "accelerator_id", accelerator_id)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accelerateIpId")
    def accelerate_ip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Basic Accelerate IP.
        """
        return pulumi.get(self, "accelerate_ip_id")

    @accelerate_ip_id.setter
    def accelerate_ip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accelerate_ip_id", value)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Basic GA instance.
        """
        return pulumi.get(self, "accelerator_id")

    @accelerator_id.setter
    def accelerator_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accelerator_id", value)

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Basic Endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Basic Accelerate Ip Endpoint Relation.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:ga/basicAccelerateIpEndpointRelation:BasicAccelerateIpEndpointRelation")
class BasicAccelerateIpEndpointRelation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerate_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Global Accelerator (GA) Basic Accelerate Ip Endpoint Relation resource.

        For information about Global Accelerator (GA) Basic Accelerate Ip Endpoint Relation and how to use it, see [What is Basic Accelerate Ip Endpoint Relation](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createbasicaccelerateipendpointrelation).

        > **NOTE:** Available since v1.194.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-shenzhen"
        endpoint_region = config.get("endpointRegion")
        if endpoint_region is None:
            endpoint_region = "cn-hangzhou"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name="terraform-example",
            cidr_block="172.17.3.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            vpc_id=default_network.id,
            name="terraform-example")
        default_ecs_network_interface = alicloud.ecs.EcsNetworkInterface("default",
            vswitch_id=default_switch.id,
            security_group_ids=[default_security_group.id])
        default_basic_accelerator = alicloud.ga.BasicAccelerator("default",
            duration=1,
            basic_accelerator_name="terraform-example",
            description="terraform-example",
            bandwidth_billing_type="CDT",
            auto_use_coupon="true",
            auto_pay=True)
        default_basic_ip_set = alicloud.ga.BasicIpSet("default",
            accelerator_id=default_basic_accelerator.id,
            accelerate_region_id=endpoint_region,
            isp_type="BGP",
            bandwidth=5)
        default_basic_accelerate_ip = alicloud.ga.BasicAccelerateIp("default",
            accelerator_id=default_basic_accelerator.id,
            ip_set_id=default_basic_ip_set.id)
        default_basic_endpoint_group = alicloud.ga.BasicEndpointGroup("default",
            accelerator_id=default_basic_accelerator.id,
            endpoint_group_region=region,
            basic_endpoint_group_name="terraform-example",
            description="terraform-example")
        default_basic_endpoint = alicloud.ga.BasicEndpoint("default",
            accelerator_id=default_basic_accelerator.id,
            endpoint_group_id=default_basic_endpoint_group.id,
            endpoint_type="ENI",
            endpoint_address=default_ecs_network_interface.id,
            endpoint_sub_address_type="primary",
            endpoint_sub_address="192.168.0.1",
            basic_endpoint_name="terraform-example")
        default_basic_accelerate_ip_endpoint_relation = alicloud.ga.BasicAccelerateIpEndpointRelation("default",
            accelerator_id=default_basic_accelerate_ip.accelerator_id,
            accelerate_ip_id=default_basic_accelerate_ip.id,
            endpoint_id=default_basic_endpoint.endpoint_id)
        ```

        ## Import

        Global Accelerator (GA) Basic Accelerate Ip Endpoint Relation can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ga/basicAccelerateIpEndpointRelation:BasicAccelerateIpEndpointRelation example <accelerator_id>:<accelerate_ip_id>:<endpoint_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accelerate_ip_id: The ID of the Basic Accelerate IP.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the Basic GA instance.
        :param pulumi.Input[_builtins.str] endpoint_id: The ID of the Basic Endpoint.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BasicAccelerateIpEndpointRelationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Global Accelerator (GA) Basic Accelerate Ip Endpoint Relation resource.

        For information about Global Accelerator (GA) Basic Accelerate Ip Endpoint Relation and how to use it, see [What is Basic Accelerate Ip Endpoint Relation](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createbasicaccelerateipendpointrelation).

        > **NOTE:** Available since v1.194.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-shenzhen"
        endpoint_region = config.get("endpointRegion")
        if endpoint_region is None:
            endpoint_region = "cn-hangzhou"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name="terraform-example",
            cidr_block="172.17.3.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            vpc_id=default_network.id,
            name="terraform-example")
        default_ecs_network_interface = alicloud.ecs.EcsNetworkInterface("default",
            vswitch_id=default_switch.id,
            security_group_ids=[default_security_group.id])
        default_basic_accelerator = alicloud.ga.BasicAccelerator("default",
            duration=1,
            basic_accelerator_name="terraform-example",
            description="terraform-example",
            bandwidth_billing_type="CDT",
            auto_use_coupon="true",
            auto_pay=True)
        default_basic_ip_set = alicloud.ga.BasicIpSet("default",
            accelerator_id=default_basic_accelerator.id,
            accelerate_region_id=endpoint_region,
            isp_type="BGP",
            bandwidth=5)
        default_basic_accelerate_ip = alicloud.ga.BasicAccelerateIp("default",
            accelerator_id=default_basic_accelerator.id,
            ip_set_id=default_basic_ip_set.id)
        default_basic_endpoint_group = alicloud.ga.BasicEndpointGroup("default",
            accelerator_id=default_basic_accelerator.id,
            endpoint_group_region=region,
            basic_endpoint_group_name="terraform-example",
            description="terraform-example")
        default_basic_endpoint = alicloud.ga.BasicEndpoint("default",
            accelerator_id=default_basic_accelerator.id,
            endpoint_group_id=default_basic_endpoint_group.id,
            endpoint_type="ENI",
            endpoint_address=default_ecs_network_interface.id,
            endpoint_sub_address_type="primary",
            endpoint_sub_address="192.168.0.1",
            basic_endpoint_name="terraform-example")
        default_basic_accelerate_ip_endpoint_relation = alicloud.ga.BasicAccelerateIpEndpointRelation("default",
            accelerator_id=default_basic_accelerate_ip.accelerator_id,
            accelerate_ip_id=default_basic_accelerate_ip.id,
            endpoint_id=default_basic_endpoint.endpoint_id)
        ```

        ## Import

        Global Accelerator (GA) Basic Accelerate Ip Endpoint Relation can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ga/basicAccelerateIpEndpointRelation:BasicAccelerateIpEndpointRelation example <accelerator_id>:<accelerate_ip_id>:<endpoint_id>
        ```

        :param str resource_name: The name of the resource.
        :param BasicAccelerateIpEndpointRelationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BasicAccelerateIpEndpointRelationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerate_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BasicAccelerateIpEndpointRelationArgs.__new__(BasicAccelerateIpEndpointRelationArgs)

            if accelerate_ip_id is None and not opts.urn:
                raise TypeError("Missing required property 'accelerate_ip_id'")
            __props__.__dict__["accelerate_ip_id"] = accelerate_ip_id
            if accelerator_id is None and not opts.urn:
                raise TypeError("Missing required property 'accelerator_id'")
            __props__.__dict__["accelerator_id"] = accelerator_id
            if endpoint_id is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_id'")
            __props__.__dict__["endpoint_id"] = endpoint_id
            __props__.__dict__["status"] = None
        super(BasicAccelerateIpEndpointRelation, __self__).__init__(
            'alicloud:ga/basicAccelerateIpEndpointRelation:BasicAccelerateIpEndpointRelation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accelerate_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
            accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'BasicAccelerateIpEndpointRelation':
        """
        Get an existing BasicAccelerateIpEndpointRelation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accelerate_ip_id: The ID of the Basic Accelerate IP.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the Basic GA instance.
        :param pulumi.Input[_builtins.str] endpoint_id: The ID of the Basic Endpoint.
        :param pulumi.Input[_builtins.str] status: The status of the Basic Accelerate Ip Endpoint Relation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BasicAccelerateIpEndpointRelationState.__new__(_BasicAccelerateIpEndpointRelationState)

        __props__.__dict__["accelerate_ip_id"] = accelerate_ip_id
        __props__.__dict__["accelerator_id"] = accelerator_id
        __props__.__dict__["endpoint_id"] = endpoint_id
        __props__.__dict__["status"] = status
        return BasicAccelerateIpEndpointRelation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accelerateIpId")
    def accelerate_ip_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Basic Accelerate IP.
        """
        return pulumi.get(self, "accelerate_ip_id")

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Basic GA instance.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Basic Endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Basic Accelerate Ip Endpoint Relation.
        """
        return pulumi.get(self, "status")

