# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EndpointGroupArgs', 'EndpointGroup']

@pulumi.input_type
class EndpointGroupArgs:
    def __init__(__self__, *,
                 accelerator_id: pulumi.Input[_builtins.str],
                 endpoint_configurations: pulumi.Input[Sequence[pulumi.Input['EndpointGroupEndpointConfigurationArgs']]],
                 endpoint_group_region: pulumi.Input[_builtins.str],
                 listener_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_protocol_version: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_request_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_path: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_overrides: Optional[pulumi.Input['EndpointGroupPortOverridesArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 threshold_count: Optional[pulumi.Input[_builtins.int]] = None,
                 traffic_percentage: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a EndpointGroup resource.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the Global Accelerator instance to which the endpoint group will be added.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointGroupEndpointConfigurationArgs']]] endpoint_configurations: The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
        :param pulumi.Input[_builtins.str] endpoint_group_region: The ID of the region where the endpoint group is deployed.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the listener that is associated with the endpoint group.
        :param pulumi.Input[_builtins.str] description: The description of the endpoint group.
        :param pulumi.Input[_builtins.str] endpoint_group_type: The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
               > **NOTE:** Currently, only `HTTP` or `HTTPS` protocol listener can directly create a `virtual` Endpoint Group. If it is `TCP` protocol listener, and you want to create a `virtual` Endpoint Group, please ensure that the `default` Endpoint Group has been created.
        :param pulumi.Input[_builtins.str] endpoint_protocol_version: The backend service protocol of the endpoint that is associated with the intelligent routing listener. Valid values: `HTTP1.1`, `HTTP2`.
               > **NOTE:** `endpoint_protocol_version` is valid only when `endpoint_request_protocol` is set to `HTTPS`.
        :param pulumi.Input[_builtins.str] endpoint_request_protocol: The protocol that is used by the backend server. Valid values: `HTTP`, `HTTPS`.
               > **NOTE:** `endpoint_request_protocol` can be specified only if the listener that is associated with the endpoint group uses `HTTP` or `HTTPS`. For the listener of `HTTP` protocol, `endpoint_request_protocol` can only be set to `HTTP`.
        :param pulumi.Input[_builtins.bool] health_check_enabled: Specifies whether to enable the health check feature. Valid values:
        :param pulumi.Input[_builtins.int] health_check_interval_seconds: The interval between two consecutive health checks. Unit: seconds.
        :param pulumi.Input[_builtins.str] health_check_path: The path specified as the destination of the targets for health checks.
        :param pulumi.Input[_builtins.int] health_check_port: The port that is used for health checks.
        :param pulumi.Input[_builtins.str] health_check_protocol: The protocol that is used to connect to the targets for health checks. Valid values:
               - `TCP` or `tcp`: TCP protocol.
               - `HTTP` or `http`: HTTP protocol.
               - `HTTPS` or `https`: HTTPS protocol.
               > **NOTE:** From version 1.223.0, `health_check_protocol` can be set to `TCP`, `HTTP`, `HTTPS`.
        :param pulumi.Input[_builtins.str] name: The name of the endpoint group.
        :param pulumi.Input['EndpointGroupPortOverridesArgs'] port_overrides: Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
               > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] threshold_count: The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy. Default value: `3`.
        :param pulumi.Input[_builtins.int] traffic_percentage: The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
        """
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "endpoint_configurations", endpoint_configurations)
        pulumi.set(__self__, "endpoint_group_region", endpoint_group_region)
        pulumi.set(__self__, "listener_id", listener_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint_group_type is not None:
            pulumi.set(__self__, "endpoint_group_type", endpoint_group_type)
        if endpoint_protocol_version is not None:
            pulumi.set(__self__, "endpoint_protocol_version", endpoint_protocol_version)
        if endpoint_request_protocol is not None:
            pulumi.set(__self__, "endpoint_request_protocol", endpoint_request_protocol)
        if health_check_enabled is not None:
            pulumi.set(__self__, "health_check_enabled", health_check_enabled)
        if health_check_interval_seconds is not None:
            pulumi.set(__self__, "health_check_interval_seconds", health_check_interval_seconds)
        if health_check_path is not None:
            pulumi.set(__self__, "health_check_path", health_check_path)
        if health_check_port is not None:
            pulumi.set(__self__, "health_check_port", health_check_port)
        if health_check_protocol is not None:
            pulumi.set(__self__, "health_check_protocol", health_check_protocol)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port_overrides is not None:
            pulumi.set(__self__, "port_overrides", port_overrides)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threshold_count is not None:
            pulumi.set(__self__, "threshold_count", threshold_count)
        if traffic_percentage is not None:
            pulumi.set(__self__, "traffic_percentage", traffic_percentage)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Global Accelerator instance to which the endpoint group will be added.
        """
        return pulumi.get(self, "accelerator_id")

    @accelerator_id.setter
    def accelerator_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "accelerator_id", value)

    @_builtins.property
    @pulumi.getter(name="endpointConfigurations")
    def endpoint_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['EndpointGroupEndpointConfigurationArgs']]]:
        """
        The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
        """
        return pulumi.get(self, "endpoint_configurations")

    @endpoint_configurations.setter
    def endpoint_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['EndpointGroupEndpointConfigurationArgs']]]):
        pulumi.set(self, "endpoint_configurations", value)

    @_builtins.property
    @pulumi.getter(name="endpointGroupRegion")
    def endpoint_group_region(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the region where the endpoint group is deployed.
        """
        return pulumi.get(self, "endpoint_group_region")

    @endpoint_group_region.setter
    def endpoint_group_region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint_group_region", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the listener that is associated with the endpoint group.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the endpoint group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="endpointGroupType")
    def endpoint_group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
        > **NOTE:** Currently, only `HTTP` or `HTTPS` protocol listener can directly create a `virtual` Endpoint Group. If it is `TCP` protocol listener, and you want to create a `virtual` Endpoint Group, please ensure that the `default` Endpoint Group has been created.
        """
        return pulumi.get(self, "endpoint_group_type")

    @endpoint_group_type.setter
    def endpoint_group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_group_type", value)

    @_builtins.property
    @pulumi.getter(name="endpointProtocolVersion")
    def endpoint_protocol_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backend service protocol of the endpoint that is associated with the intelligent routing listener. Valid values: `HTTP1.1`, `HTTP2`.
        > **NOTE:** `endpoint_protocol_version` is valid only when `endpoint_request_protocol` is set to `HTTPS`.
        """
        return pulumi.get(self, "endpoint_protocol_version")

    @endpoint_protocol_version.setter
    def endpoint_protocol_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_protocol_version", value)

    @_builtins.property
    @pulumi.getter(name="endpointRequestProtocol")
    def endpoint_request_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol that is used by the backend server. Valid values: `HTTP`, `HTTPS`.
        > **NOTE:** `endpoint_request_protocol` can be specified only if the listener that is associated with the endpoint group uses `HTTP` or `HTTPS`. For the listener of `HTTP` protocol, `endpoint_request_protocol` can only be set to `HTTP`.
        """
        return pulumi.get(self, "endpoint_request_protocol")

    @endpoint_request_protocol.setter
    def endpoint_request_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_request_protocol", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckEnabled")
    def health_check_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the health check feature. Valid values:
        """
        return pulumi.get(self, "health_check_enabled")

    @health_check_enabled.setter
    def health_check_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "health_check_enabled", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckIntervalSeconds")
    def health_check_interval_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The interval between two consecutive health checks. Unit: seconds.
        """
        return pulumi.get(self, "health_check_interval_seconds")

    @health_check_interval_seconds.setter
    def health_check_interval_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_interval_seconds", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path specified as the destination of the targets for health checks.
        """
        return pulumi.get(self, "health_check_path")

    @health_check_path.setter
    def health_check_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_path", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port that is used for health checks.
        """
        return pulumi.get(self, "health_check_port")

    @health_check_port.setter
    def health_check_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_port", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol that is used to connect to the targets for health checks. Valid values:
        - `TCP` or `tcp`: TCP protocol.
        - `HTTP` or `http`: HTTP protocol.
        - `HTTPS` or `https`: HTTPS protocol.
        > **NOTE:** From version 1.223.0, `health_check_protocol` can be set to `TCP`, `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "health_check_protocol")

    @health_check_protocol.setter
    def health_check_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_protocol", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the endpoint group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="portOverrides")
    def port_overrides(self) -> Optional[pulumi.Input['EndpointGroupPortOverridesArgs']]:
        """
        Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
        > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
        """
        return pulumi.get(self, "port_overrides")

    @port_overrides.setter
    def port_overrides(self, value: Optional[pulumi.Input['EndpointGroupPortOverridesArgs']]):
        pulumi.set(self, "port_overrides", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="thresholdCount")
    def threshold_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy. Default value: `3`.
        """
        return pulumi.get(self, "threshold_count")

    @threshold_count.setter
    def threshold_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "threshold_count", value)

    @_builtins.property
    @pulumi.getter(name="trafficPercentage")
    def traffic_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
        """
        return pulumi.get(self, "traffic_percentage")

    @traffic_percentage.setter
    def traffic_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "traffic_percentage", value)


@pulumi.input_type
class _EndpointGroupState:
    def __init__(__self__, *,
                 accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointGroupEndpointConfigurationArgs']]]] = None,
                 endpoint_group_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 endpoint_group_region: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_protocol_version: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_request_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_path: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_overrides: Optional[pulumi.Input['EndpointGroupPortOverridesArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 threshold_count: Optional[pulumi.Input[_builtins.int]] = None,
                 traffic_percentage: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering EndpointGroup resources.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the Global Accelerator instance to which the endpoint group will be added.
        :param pulumi.Input[_builtins.str] description: The description of the endpoint group.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointGroupEndpointConfigurationArgs']]] endpoint_configurations: The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_group_ip_lists: (Available since v1.213.0) The active endpoint IP addresses of the endpoint group. `endpoint_group_ip_list` will change with the growth of network traffic. You can run `pulumi up` to query the latest CIDR blocks and IP addresses.
        :param pulumi.Input[_builtins.str] endpoint_group_region: The ID of the region where the endpoint group is deployed.
        :param pulumi.Input[_builtins.str] endpoint_group_type: The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
               > **NOTE:** Currently, only `HTTP` or `HTTPS` protocol listener can directly create a `virtual` Endpoint Group. If it is `TCP` protocol listener, and you want to create a `virtual` Endpoint Group, please ensure that the `default` Endpoint Group has been created.
        :param pulumi.Input[_builtins.str] endpoint_protocol_version: The backend service protocol of the endpoint that is associated with the intelligent routing listener. Valid values: `HTTP1.1`, `HTTP2`.
               > **NOTE:** `endpoint_protocol_version` is valid only when `endpoint_request_protocol` is set to `HTTPS`.
        :param pulumi.Input[_builtins.str] endpoint_request_protocol: The protocol that is used by the backend server. Valid values: `HTTP`, `HTTPS`.
               > **NOTE:** `endpoint_request_protocol` can be specified only if the listener that is associated with the endpoint group uses `HTTP` or `HTTPS`. For the listener of `HTTP` protocol, `endpoint_request_protocol` can only be set to `HTTP`.
        :param pulumi.Input[_builtins.bool] health_check_enabled: Specifies whether to enable the health check feature. Valid values:
        :param pulumi.Input[_builtins.int] health_check_interval_seconds: The interval between two consecutive health checks. Unit: seconds.
        :param pulumi.Input[_builtins.str] health_check_path: The path specified as the destination of the targets for health checks.
        :param pulumi.Input[_builtins.int] health_check_port: The port that is used for health checks.
        :param pulumi.Input[_builtins.str] health_check_protocol: The protocol that is used to connect to the targets for health checks. Valid values:
               - `TCP` or `tcp`: TCP protocol.
               - `HTTP` or `http`: HTTP protocol.
               - `HTTPS` or `https`: HTTPS protocol.
               > **NOTE:** From version 1.223.0, `health_check_protocol` can be set to `TCP`, `HTTP`, `HTTPS`.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the listener that is associated with the endpoint group.
        :param pulumi.Input[_builtins.str] name: The name of the endpoint group.
        :param pulumi.Input['EndpointGroupPortOverridesArgs'] port_overrides: Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
               > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
        :param pulumi.Input[_builtins.str] status: The status of the endpoint group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] threshold_count: The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy. Default value: `3`.
        :param pulumi.Input[_builtins.int] traffic_percentage: The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
        """
        if accelerator_id is not None:
            pulumi.set(__self__, "accelerator_id", accelerator_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint_configurations is not None:
            pulumi.set(__self__, "endpoint_configurations", endpoint_configurations)
        if endpoint_group_ip_lists is not None:
            pulumi.set(__self__, "endpoint_group_ip_lists", endpoint_group_ip_lists)
        if endpoint_group_region is not None:
            pulumi.set(__self__, "endpoint_group_region", endpoint_group_region)
        if endpoint_group_type is not None:
            pulumi.set(__self__, "endpoint_group_type", endpoint_group_type)
        if endpoint_protocol_version is not None:
            pulumi.set(__self__, "endpoint_protocol_version", endpoint_protocol_version)
        if endpoint_request_protocol is not None:
            pulumi.set(__self__, "endpoint_request_protocol", endpoint_request_protocol)
        if health_check_enabled is not None:
            pulumi.set(__self__, "health_check_enabled", health_check_enabled)
        if health_check_interval_seconds is not None:
            pulumi.set(__self__, "health_check_interval_seconds", health_check_interval_seconds)
        if health_check_path is not None:
            pulumi.set(__self__, "health_check_path", health_check_path)
        if health_check_port is not None:
            pulumi.set(__self__, "health_check_port", health_check_port)
        if health_check_protocol is not None:
            pulumi.set(__self__, "health_check_protocol", health_check_protocol)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port_overrides is not None:
            pulumi.set(__self__, "port_overrides", port_overrides)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threshold_count is not None:
            pulumi.set(__self__, "threshold_count", threshold_count)
        if traffic_percentage is not None:
            pulumi.set(__self__, "traffic_percentage", traffic_percentage)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Global Accelerator instance to which the endpoint group will be added.
        """
        return pulumi.get(self, "accelerator_id")

    @accelerator_id.setter
    def accelerator_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accelerator_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the endpoint group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="endpointConfigurations")
    def endpoint_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointGroupEndpointConfigurationArgs']]]]:
        """
        The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
        """
        return pulumi.get(self, "endpoint_configurations")

    @endpoint_configurations.setter
    def endpoint_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointGroupEndpointConfigurationArgs']]]]):
        pulumi.set(self, "endpoint_configurations", value)

    @_builtins.property
    @pulumi.getter(name="endpointGroupIpLists")
    def endpoint_group_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Available since v1.213.0) The active endpoint IP addresses of the endpoint group. `endpoint_group_ip_list` will change with the growth of network traffic. You can run `pulumi up` to query the latest CIDR blocks and IP addresses.
        """
        return pulumi.get(self, "endpoint_group_ip_lists")

    @endpoint_group_ip_lists.setter
    def endpoint_group_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "endpoint_group_ip_lists", value)

    @_builtins.property
    @pulumi.getter(name="endpointGroupRegion")
    def endpoint_group_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region where the endpoint group is deployed.
        """
        return pulumi.get(self, "endpoint_group_region")

    @endpoint_group_region.setter
    def endpoint_group_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_group_region", value)

    @_builtins.property
    @pulumi.getter(name="endpointGroupType")
    def endpoint_group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
        > **NOTE:** Currently, only `HTTP` or `HTTPS` protocol listener can directly create a `virtual` Endpoint Group. If it is `TCP` protocol listener, and you want to create a `virtual` Endpoint Group, please ensure that the `default` Endpoint Group has been created.
        """
        return pulumi.get(self, "endpoint_group_type")

    @endpoint_group_type.setter
    def endpoint_group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_group_type", value)

    @_builtins.property
    @pulumi.getter(name="endpointProtocolVersion")
    def endpoint_protocol_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backend service protocol of the endpoint that is associated with the intelligent routing listener. Valid values: `HTTP1.1`, `HTTP2`.
        > **NOTE:** `endpoint_protocol_version` is valid only when `endpoint_request_protocol` is set to `HTTPS`.
        """
        return pulumi.get(self, "endpoint_protocol_version")

    @endpoint_protocol_version.setter
    def endpoint_protocol_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_protocol_version", value)

    @_builtins.property
    @pulumi.getter(name="endpointRequestProtocol")
    def endpoint_request_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol that is used by the backend server. Valid values: `HTTP`, `HTTPS`.
        > **NOTE:** `endpoint_request_protocol` can be specified only if the listener that is associated with the endpoint group uses `HTTP` or `HTTPS`. For the listener of `HTTP` protocol, `endpoint_request_protocol` can only be set to `HTTP`.
        """
        return pulumi.get(self, "endpoint_request_protocol")

    @endpoint_request_protocol.setter
    def endpoint_request_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_request_protocol", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckEnabled")
    def health_check_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the health check feature. Valid values:
        """
        return pulumi.get(self, "health_check_enabled")

    @health_check_enabled.setter
    def health_check_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "health_check_enabled", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckIntervalSeconds")
    def health_check_interval_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The interval between two consecutive health checks. Unit: seconds.
        """
        return pulumi.get(self, "health_check_interval_seconds")

    @health_check_interval_seconds.setter
    def health_check_interval_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_interval_seconds", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path specified as the destination of the targets for health checks.
        """
        return pulumi.get(self, "health_check_path")

    @health_check_path.setter
    def health_check_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_path", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port that is used for health checks.
        """
        return pulumi.get(self, "health_check_port")

    @health_check_port.setter
    def health_check_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_port", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol that is used to connect to the targets for health checks. Valid values:
        - `TCP` or `tcp`: TCP protocol.
        - `HTTP` or `http`: HTTP protocol.
        - `HTTPS` or `https`: HTTPS protocol.
        > **NOTE:** From version 1.223.0, `health_check_protocol` can be set to `TCP`, `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "health_check_protocol")

    @health_check_protocol.setter
    def health_check_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_protocol", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the listener that is associated with the endpoint group.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the endpoint group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="portOverrides")
    def port_overrides(self) -> Optional[pulumi.Input['EndpointGroupPortOverridesArgs']]:
        """
        Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
        > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
        """
        return pulumi.get(self, "port_overrides")

    @port_overrides.setter
    def port_overrides(self, value: Optional[pulumi.Input['EndpointGroupPortOverridesArgs']]):
        pulumi.set(self, "port_overrides", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the endpoint group.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="thresholdCount")
    def threshold_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy. Default value: `3`.
        """
        return pulumi.get(self, "threshold_count")

    @threshold_count.setter
    def threshold_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "threshold_count", value)

    @_builtins.property
    @pulumi.getter(name="trafficPercentage")
    def traffic_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
        """
        return pulumi.get(self, "traffic_percentage")

    @traffic_percentage.setter
    def traffic_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "traffic_percentage", value)


@pulumi.type_token("alicloud:ga/endpointGroup:EndpointGroup")
class EndpointGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointGroupEndpointConfigurationArgs', 'EndpointGroupEndpointConfigurationArgsDict']]]]] = None,
                 endpoint_group_region: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_protocol_version: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_request_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_path: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_overrides: Optional[pulumi.Input[Union['EndpointGroupPortOverridesArgs', 'EndpointGroupPortOverridesArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 threshold_count: Optional[pulumi.Input[_builtins.int]] = None,
                 traffic_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        default = alicloud.ga.Accelerator("default",
            duration=1,
            auto_use_coupon=True,
            spec="1")
        default_bandwidth_package = alicloud.ga.BandwidthPackage("default",
            bandwidth=100,
            type="Basic",
            bandwidth_type="Basic",
            payment_type="PayAsYouGo",
            billing_type="PayBy95",
            ratio=30)
        default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("default",
            accelerator_id=default.id,
            bandwidth_package_id=default_bandwidth_package.id)
        default_listener = alicloud.ga.Listener("default",
            accelerator_id=default_bandwidth_package_attachment.accelerator_id,
            port_ranges=[{
                "from_port": 60,
                "to_port": 70,
            }],
            client_affinity="SOURCE_IP",
            protocol="UDP",
            name="terraform-example")
        default_eip_address = []
        for range in [{"value": i} for i in range(0, 2)]:
            default_eip_address.append(alicloud.ecs.EipAddress(f"default-{range['value']}",
                bandwidth="10",
                internet_charge_type="PayByBandwidth",
                address_name="terraform-example"))
        default_endpoint_group = alicloud.ga.EndpointGroup("default",
            accelerator_id=default.id,
            endpoint_configurations=[
                {
                    "endpoint": default_eip_address[0].ip_address,
                    "type": "PublicIp",
                    "weight": 20,
                },
                {
                    "endpoint": default_eip_address[1].ip_address,
                    "type": "PublicIp",
                    "weight": 20,
                },
            ],
            endpoint_group_region=region,
            listener_id=default_listener.id)
        ```

        ## Import

        Ga Endpoint Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ga/endpointGroup:EndpointGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the Global Accelerator instance to which the endpoint group will be added.
        :param pulumi.Input[_builtins.str] description: The description of the endpoint group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndpointGroupEndpointConfigurationArgs', 'EndpointGroupEndpointConfigurationArgsDict']]]] endpoint_configurations: The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
        :param pulumi.Input[_builtins.str] endpoint_group_region: The ID of the region where the endpoint group is deployed.
        :param pulumi.Input[_builtins.str] endpoint_group_type: The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
               > **NOTE:** Currently, only `HTTP` or `HTTPS` protocol listener can directly create a `virtual` Endpoint Group. If it is `TCP` protocol listener, and you want to create a `virtual` Endpoint Group, please ensure that the `default` Endpoint Group has been created.
        :param pulumi.Input[_builtins.str] endpoint_protocol_version: The backend service protocol of the endpoint that is associated with the intelligent routing listener. Valid values: `HTTP1.1`, `HTTP2`.
               > **NOTE:** `endpoint_protocol_version` is valid only when `endpoint_request_protocol` is set to `HTTPS`.
        :param pulumi.Input[_builtins.str] endpoint_request_protocol: The protocol that is used by the backend server. Valid values: `HTTP`, `HTTPS`.
               > **NOTE:** `endpoint_request_protocol` can be specified only if the listener that is associated with the endpoint group uses `HTTP` or `HTTPS`. For the listener of `HTTP` protocol, `endpoint_request_protocol` can only be set to `HTTP`.
        :param pulumi.Input[_builtins.bool] health_check_enabled: Specifies whether to enable the health check feature. Valid values:
        :param pulumi.Input[_builtins.int] health_check_interval_seconds: The interval between two consecutive health checks. Unit: seconds.
        :param pulumi.Input[_builtins.str] health_check_path: The path specified as the destination of the targets for health checks.
        :param pulumi.Input[_builtins.int] health_check_port: The port that is used for health checks.
        :param pulumi.Input[_builtins.str] health_check_protocol: The protocol that is used to connect to the targets for health checks. Valid values:
               - `TCP` or `tcp`: TCP protocol.
               - `HTTP` or `http`: HTTP protocol.
               - `HTTPS` or `https`: HTTPS protocol.
               > **NOTE:** From version 1.223.0, `health_check_protocol` can be set to `TCP`, `HTTP`, `HTTPS`.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the listener that is associated with the endpoint group.
        :param pulumi.Input[_builtins.str] name: The name of the endpoint group.
        :param pulumi.Input[Union['EndpointGroupPortOverridesArgs', 'EndpointGroupPortOverridesArgsDict']] port_overrides: Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
               > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] threshold_count: The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy. Default value: `3`.
        :param pulumi.Input[_builtins.int] traffic_percentage: The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        default = alicloud.ga.Accelerator("default",
            duration=1,
            auto_use_coupon=True,
            spec="1")
        default_bandwidth_package = alicloud.ga.BandwidthPackage("default",
            bandwidth=100,
            type="Basic",
            bandwidth_type="Basic",
            payment_type="PayAsYouGo",
            billing_type="PayBy95",
            ratio=30)
        default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("default",
            accelerator_id=default.id,
            bandwidth_package_id=default_bandwidth_package.id)
        default_listener = alicloud.ga.Listener("default",
            accelerator_id=default_bandwidth_package_attachment.accelerator_id,
            port_ranges=[{
                "from_port": 60,
                "to_port": 70,
            }],
            client_affinity="SOURCE_IP",
            protocol="UDP",
            name="terraform-example")
        default_eip_address = []
        for range in [{"value": i} for i in range(0, 2)]:
            default_eip_address.append(alicloud.ecs.EipAddress(f"default-{range['value']}",
                bandwidth="10",
                internet_charge_type="PayByBandwidth",
                address_name="terraform-example"))
        default_endpoint_group = alicloud.ga.EndpointGroup("default",
            accelerator_id=default.id,
            endpoint_configurations=[
                {
                    "endpoint": default_eip_address[0].ip_address,
                    "type": "PublicIp",
                    "weight": 20,
                },
                {
                    "endpoint": default_eip_address[1].ip_address,
                    "type": "PublicIp",
                    "weight": 20,
                },
            ],
            endpoint_group_region=region,
            listener_id=default_listener.id)
        ```

        ## Import

        Ga Endpoint Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ga/endpointGroup:EndpointGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EndpointGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointGroupEndpointConfigurationArgs', 'EndpointGroupEndpointConfigurationArgsDict']]]]] = None,
                 endpoint_group_region: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_protocol_version: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_request_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_path: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_overrides: Optional[pulumi.Input[Union['EndpointGroupPortOverridesArgs', 'EndpointGroupPortOverridesArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 threshold_count: Optional[pulumi.Input[_builtins.int]] = None,
                 traffic_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointGroupArgs.__new__(EndpointGroupArgs)

            if accelerator_id is None and not opts.urn:
                raise TypeError("Missing required property 'accelerator_id'")
            __props__.__dict__["accelerator_id"] = accelerator_id
            __props__.__dict__["description"] = description
            if endpoint_configurations is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_configurations'")
            __props__.__dict__["endpoint_configurations"] = endpoint_configurations
            if endpoint_group_region is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_group_region'")
            __props__.__dict__["endpoint_group_region"] = endpoint_group_region
            __props__.__dict__["endpoint_group_type"] = endpoint_group_type
            __props__.__dict__["endpoint_protocol_version"] = endpoint_protocol_version
            __props__.__dict__["endpoint_request_protocol"] = endpoint_request_protocol
            __props__.__dict__["health_check_enabled"] = health_check_enabled
            __props__.__dict__["health_check_interval_seconds"] = health_check_interval_seconds
            __props__.__dict__["health_check_path"] = health_check_path
            __props__.__dict__["health_check_port"] = health_check_port
            __props__.__dict__["health_check_protocol"] = health_check_protocol
            if listener_id is None and not opts.urn:
                raise TypeError("Missing required property 'listener_id'")
            __props__.__dict__["listener_id"] = listener_id
            __props__.__dict__["name"] = name
            __props__.__dict__["port_overrides"] = port_overrides
            __props__.__dict__["tags"] = tags
            __props__.__dict__["threshold_count"] = threshold_count
            __props__.__dict__["traffic_percentage"] = traffic_percentage
            __props__.__dict__["endpoint_group_ip_lists"] = None
            __props__.__dict__["status"] = None
        super(EndpointGroup, __self__).__init__(
            'alicloud:ga/endpointGroup:EndpointGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointGroupEndpointConfigurationArgs', 'EndpointGroupEndpointConfigurationArgsDict']]]]] = None,
            endpoint_group_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            endpoint_group_region: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_group_type: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_protocol_version: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_request_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            health_check_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            health_check_path: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_port: Optional[pulumi.Input[_builtins.int]] = None,
            health_check_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            listener_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            port_overrides: Optional[pulumi.Input[Union['EndpointGroupPortOverridesArgs', 'EndpointGroupPortOverridesArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            threshold_count: Optional[pulumi.Input[_builtins.int]] = None,
            traffic_percentage: Optional[pulumi.Input[_builtins.int]] = None) -> 'EndpointGroup':
        """
        Get an existing EndpointGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the Global Accelerator instance to which the endpoint group will be added.
        :param pulumi.Input[_builtins.str] description: The description of the endpoint group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndpointGroupEndpointConfigurationArgs', 'EndpointGroupEndpointConfigurationArgsDict']]]] endpoint_configurations: The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_group_ip_lists: (Available since v1.213.0) The active endpoint IP addresses of the endpoint group. `endpoint_group_ip_list` will change with the growth of network traffic. You can run `pulumi up` to query the latest CIDR blocks and IP addresses.
        :param pulumi.Input[_builtins.str] endpoint_group_region: The ID of the region where the endpoint group is deployed.
        :param pulumi.Input[_builtins.str] endpoint_group_type: The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
               > **NOTE:** Currently, only `HTTP` or `HTTPS` protocol listener can directly create a `virtual` Endpoint Group. If it is `TCP` protocol listener, and you want to create a `virtual` Endpoint Group, please ensure that the `default` Endpoint Group has been created.
        :param pulumi.Input[_builtins.str] endpoint_protocol_version: The backend service protocol of the endpoint that is associated with the intelligent routing listener. Valid values: `HTTP1.1`, `HTTP2`.
               > **NOTE:** `endpoint_protocol_version` is valid only when `endpoint_request_protocol` is set to `HTTPS`.
        :param pulumi.Input[_builtins.str] endpoint_request_protocol: The protocol that is used by the backend server. Valid values: `HTTP`, `HTTPS`.
               > **NOTE:** `endpoint_request_protocol` can be specified only if the listener that is associated with the endpoint group uses `HTTP` or `HTTPS`. For the listener of `HTTP` protocol, `endpoint_request_protocol` can only be set to `HTTP`.
        :param pulumi.Input[_builtins.bool] health_check_enabled: Specifies whether to enable the health check feature. Valid values:
        :param pulumi.Input[_builtins.int] health_check_interval_seconds: The interval between two consecutive health checks. Unit: seconds.
        :param pulumi.Input[_builtins.str] health_check_path: The path specified as the destination of the targets for health checks.
        :param pulumi.Input[_builtins.int] health_check_port: The port that is used for health checks.
        :param pulumi.Input[_builtins.str] health_check_protocol: The protocol that is used to connect to the targets for health checks. Valid values:
               - `TCP` or `tcp`: TCP protocol.
               - `HTTP` or `http`: HTTP protocol.
               - `HTTPS` or `https`: HTTPS protocol.
               > **NOTE:** From version 1.223.0, `health_check_protocol` can be set to `TCP`, `HTTP`, `HTTPS`.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the listener that is associated with the endpoint group.
        :param pulumi.Input[_builtins.str] name: The name of the endpoint group.
        :param pulumi.Input[Union['EndpointGroupPortOverridesArgs', 'EndpointGroupPortOverridesArgsDict']] port_overrides: Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
               > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
        :param pulumi.Input[_builtins.str] status: The status of the endpoint group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] threshold_count: The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy. Default value: `3`.
        :param pulumi.Input[_builtins.int] traffic_percentage: The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointGroupState.__new__(_EndpointGroupState)

        __props__.__dict__["accelerator_id"] = accelerator_id
        __props__.__dict__["description"] = description
        __props__.__dict__["endpoint_configurations"] = endpoint_configurations
        __props__.__dict__["endpoint_group_ip_lists"] = endpoint_group_ip_lists
        __props__.__dict__["endpoint_group_region"] = endpoint_group_region
        __props__.__dict__["endpoint_group_type"] = endpoint_group_type
        __props__.__dict__["endpoint_protocol_version"] = endpoint_protocol_version
        __props__.__dict__["endpoint_request_protocol"] = endpoint_request_protocol
        __props__.__dict__["health_check_enabled"] = health_check_enabled
        __props__.__dict__["health_check_interval_seconds"] = health_check_interval_seconds
        __props__.__dict__["health_check_path"] = health_check_path
        __props__.__dict__["health_check_port"] = health_check_port
        __props__.__dict__["health_check_protocol"] = health_check_protocol
        __props__.__dict__["listener_id"] = listener_id
        __props__.__dict__["name"] = name
        __props__.__dict__["port_overrides"] = port_overrides
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["threshold_count"] = threshold_count
        __props__.__dict__["traffic_percentage"] = traffic_percentage
        return EndpointGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Global Accelerator instance to which the endpoint group will be added.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the endpoint group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="endpointConfigurations")
    def endpoint_configurations(self) -> pulumi.Output[Sequence['outputs.EndpointGroupEndpointConfiguration']]:
        """
        The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
        """
        return pulumi.get(self, "endpoint_configurations")

    @_builtins.property
    @pulumi.getter(name="endpointGroupIpLists")
    def endpoint_group_ip_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Available since v1.213.0) The active endpoint IP addresses of the endpoint group. `endpoint_group_ip_list` will change with the growth of network traffic. You can run `pulumi up` to query the latest CIDR blocks and IP addresses.
        """
        return pulumi.get(self, "endpoint_group_ip_lists")

    @_builtins.property
    @pulumi.getter(name="endpointGroupRegion")
    def endpoint_group_region(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region where the endpoint group is deployed.
        """
        return pulumi.get(self, "endpoint_group_region")

    @_builtins.property
    @pulumi.getter(name="endpointGroupType")
    def endpoint_group_type(self) -> pulumi.Output[_builtins.str]:
        """
        The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
        > **NOTE:** Currently, only `HTTP` or `HTTPS` protocol listener can directly create a `virtual` Endpoint Group. If it is `TCP` protocol listener, and you want to create a `virtual` Endpoint Group, please ensure that the `default` Endpoint Group has been created.
        """
        return pulumi.get(self, "endpoint_group_type")

    @_builtins.property
    @pulumi.getter(name="endpointProtocolVersion")
    def endpoint_protocol_version(self) -> pulumi.Output[_builtins.str]:
        """
        The backend service protocol of the endpoint that is associated with the intelligent routing listener. Valid values: `HTTP1.1`, `HTTP2`.
        > **NOTE:** `endpoint_protocol_version` is valid only when `endpoint_request_protocol` is set to `HTTPS`.
        """
        return pulumi.get(self, "endpoint_protocol_version")

    @_builtins.property
    @pulumi.getter(name="endpointRequestProtocol")
    def endpoint_request_protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The protocol that is used by the backend server. Valid values: `HTTP`, `HTTPS`.
        > **NOTE:** `endpoint_request_protocol` can be specified only if the listener that is associated with the endpoint group uses `HTTP` or `HTTPS`. For the listener of `HTTP` protocol, `endpoint_request_protocol` can only be set to `HTTP`.
        """
        return pulumi.get(self, "endpoint_request_protocol")

    @_builtins.property
    @pulumi.getter(name="healthCheckEnabled")
    def health_check_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the health check feature. Valid values:
        """
        return pulumi.get(self, "health_check_enabled")

    @_builtins.property
    @pulumi.getter(name="healthCheckIntervalSeconds")
    def health_check_interval_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The interval between two consecutive health checks. Unit: seconds.
        """
        return pulumi.get(self, "health_check_interval_seconds")

    @_builtins.property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path specified as the destination of the targets for health checks.
        """
        return pulumi.get(self, "health_check_path")

    @_builtins.property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The port that is used for health checks.
        """
        return pulumi.get(self, "health_check_port")

    @_builtins.property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The protocol that is used to connect to the targets for health checks. Valid values:
        - `TCP` or `tcp`: TCP protocol.
        - `HTTP` or `http`: HTTP protocol.
        - `HTTPS` or `https`: HTTPS protocol.
        > **NOTE:** From version 1.223.0, `health_check_protocol` can be set to `TCP`, `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "health_check_protocol")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the listener that is associated with the endpoint group.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the endpoint group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="portOverrides")
    def port_overrides(self) -> pulumi.Output[Optional['outputs.EndpointGroupPortOverrides']]:
        """
        Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
        > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
        """
        return pulumi.get(self, "port_overrides")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the endpoint group.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="thresholdCount")
    def threshold_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy. Default value: `3`.
        """
        return pulumi.get(self, "threshold_count")

    @_builtins.property
    @pulumi.getter(name="trafficPercentage")
    def traffic_percentage(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
        """
        return pulumi.get(self, "traffic_percentage")

