# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DbInstanceIpArrayArgs', 'DbInstanceIpArray']

@pulumi.input_type
class DbInstanceIpArrayArgs:
    def __init__(__self__, *,
                 db_instance_id: pulumi.Input[_builtins.str],
                 db_instance_ip_array_name: pulumi.Input[_builtins.str],
                 security_ip_lists: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 db_instance_ip_array_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DbInstanceIpArray resource.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
               
               > **NOTE:**  You can call the [DescribeDBInstances](https://www.alibabacloud.com/help/en/doc-detail/86911.html) operation to query details about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        :param pulumi.Input[_builtins.str] db_instance_ip_array_name: The name of the IP address whitelist. If you do not specify this parameter, the default whitelist is queried.
               
               > **NOTE:**   Each instance supports up to 50 IP address whitelists.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ip_lists: The IP address whitelist contains a maximum of 1000 IP addresses separated by commas in the following three formats:
               - 0.0.0.0/0
               - 10.23.12.24(IP)
               - 10.23.12.24/24(CIDR mode, Classless Inter-Domain Routing, '/24' indicates the length of the prefix in the address, and the range is '[1,32]')
        :param pulumi.Input[_builtins.str] db_instance_ip_array_attribute: The default is empty. To distinguish between different attribute values, the console does not display groups with the 'hidden' attribute.
        :param pulumi.Input[_builtins.str] modify_mode: The method of modification. Valid values:
               
               - `Cover`: overwrites the whitelist.
               - `Append`: appends data to the whitelist.
               - `Delete`: deletes the whitelist.
        """
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "db_instance_ip_array_name", db_instance_ip_array_name)
        pulumi.set(__self__, "security_ip_lists", security_ip_lists)
        if db_instance_ip_array_attribute is not None:
            pulumi.set(__self__, "db_instance_ip_array_attribute", db_instance_ip_array_attribute)
        if modify_mode is not None:
            pulumi.set(__self__, "modify_mode", modify_mode)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The instance ID.

        > **NOTE:**  You can call the [DescribeDBInstances](https://www.alibabacloud.com/help/en/doc-detail/86911.html) operation to query details about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceIpArrayName")
    def db_instance_ip_array_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the IP address whitelist. If you do not specify this parameter, the default whitelist is queried.

        > **NOTE:**   Each instance supports up to 50 IP address whitelists.
        """
        return pulumi.get(self, "db_instance_ip_array_name")

    @db_instance_ip_array_name.setter
    def db_instance_ip_array_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_ip_array_name", value)

    @_builtins.property
    @pulumi.getter(name="securityIpLists")
    def security_ip_lists(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The IP address whitelist contains a maximum of 1000 IP addresses separated by commas in the following three formats:
        - 0.0.0.0/0
        - 10.23.12.24(IP)
        - 10.23.12.24/24(CIDR mode, Classless Inter-Domain Routing, '/24' indicates the length of the prefix in the address, and the range is '[1,32]')
        """
        return pulumi.get(self, "security_ip_lists")

    @security_ip_lists.setter
    def security_ip_lists(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "security_ip_lists", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceIpArrayAttribute")
    def db_instance_ip_array_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default is empty. To distinguish between different attribute values, the console does not display groups with the 'hidden' attribute.
        """
        return pulumi.get(self, "db_instance_ip_array_attribute")

    @db_instance_ip_array_attribute.setter
    def db_instance_ip_array_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_ip_array_attribute", value)

    @_builtins.property
    @pulumi.getter(name="modifyMode")
    def modify_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method of modification. Valid values:

        - `Cover`: overwrites the whitelist.
        - `Append`: appends data to the whitelist.
        - `Delete`: deletes the whitelist.
        """
        return pulumi.get(self, "modify_mode")

    @modify_mode.setter
    def modify_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_mode", value)


@pulumi.input_type
class _DbInstanceIpArrayState:
    def __init__(__self__, *,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ip_array_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ip_array_name: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DbInstanceIpArray resources.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
               
               > **NOTE:**  You can call the [DescribeDBInstances](https://www.alibabacloud.com/help/en/doc-detail/86911.html) operation to query details about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        :param pulumi.Input[_builtins.str] db_instance_ip_array_attribute: The default is empty. To distinguish between different attribute values, the console does not display groups with the 'hidden' attribute.
        :param pulumi.Input[_builtins.str] db_instance_ip_array_name: The name of the IP address whitelist. If you do not specify this parameter, the default whitelist is queried.
               
               > **NOTE:**   Each instance supports up to 50 IP address whitelists.
        :param pulumi.Input[_builtins.str] modify_mode: The method of modification. Valid values:
               
               - `Cover`: overwrites the whitelist.
               - `Append`: appends data to the whitelist.
               - `Delete`: deletes the whitelist.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ip_lists: The IP address whitelist contains a maximum of 1000 IP addresses separated by commas in the following three formats:
               - 0.0.0.0/0
               - 10.23.12.24(IP)
               - 10.23.12.24/24(CIDR mode, Classless Inter-Domain Routing, '/24' indicates the length of the prefix in the address, and the range is '[1,32]')
        """
        if db_instance_id is not None:
            pulumi.set(__self__, "db_instance_id", db_instance_id)
        if db_instance_ip_array_attribute is not None:
            pulumi.set(__self__, "db_instance_ip_array_attribute", db_instance_ip_array_attribute)
        if db_instance_ip_array_name is not None:
            pulumi.set(__self__, "db_instance_ip_array_name", db_instance_ip_array_name)
        if modify_mode is not None:
            pulumi.set(__self__, "modify_mode", modify_mode)
        if security_ip_lists is not None:
            pulumi.set(__self__, "security_ip_lists", security_ip_lists)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance ID.

        > **NOTE:**  You can call the [DescribeDBInstances](https://www.alibabacloud.com/help/en/doc-detail/86911.html) operation to query details about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceIpArrayAttribute")
    def db_instance_ip_array_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default is empty. To distinguish between different attribute values, the console does not display groups with the 'hidden' attribute.
        """
        return pulumi.get(self, "db_instance_ip_array_attribute")

    @db_instance_ip_array_attribute.setter
    def db_instance_ip_array_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_ip_array_attribute", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceIpArrayName")
    def db_instance_ip_array_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IP address whitelist. If you do not specify this parameter, the default whitelist is queried.

        > **NOTE:**   Each instance supports up to 50 IP address whitelists.
        """
        return pulumi.get(self, "db_instance_ip_array_name")

    @db_instance_ip_array_name.setter
    def db_instance_ip_array_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_ip_array_name", value)

    @_builtins.property
    @pulumi.getter(name="modifyMode")
    def modify_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method of modification. Valid values:

        - `Cover`: overwrites the whitelist.
        - `Append`: appends data to the whitelist.
        - `Delete`: deletes the whitelist.
        """
        return pulumi.get(self, "modify_mode")

    @modify_mode.setter
    def modify_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_mode", value)

    @_builtins.property
    @pulumi.getter(name="securityIpLists")
    def security_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IP address whitelist contains a maximum of 1000 IP addresses separated by commas in the following three formats:
        - 0.0.0.0/0
        - 10.23.12.24(IP)
        - 10.23.12.24/24(CIDR mode, Classless Inter-Domain Routing, '/24' indicates the length of the prefix in the address, and the range is '[1,32]')
        """
        return pulumi.get(self, "security_ip_lists")

    @security_ip_lists.setter
    def security_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_ip_lists", value)


@pulumi.type_token("alicloud:gpdb/dbInstanceIpArray:DbInstanceIpArray")
class DbInstanceIpArray(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ip_array_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ip_array_name: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a GPDB DB Instance IP Array resource.

        Whitelist IP Group.

        For information about GPDB DB Instance IP Array and how to use it, see [What is DB Instance IP Array](https://www.alibabacloud.com/help/en/).

        > **NOTE:** Available since v1.231.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_np_l_ra1 = alicloud.vpc.Network("defaultNpLRa1", cidr_block="192.168.0.0/16")
        defaultw_la5v4 = alicloud.vpc.Switch("defaultwLA5v4",
            vpc_id=default_np_l_ra1.id,
            zone_id="cn-beijing-h",
            cidr_block="192.168.1.0/24")
        default_h_kd_ds3 = alicloud.gpdb.Instance("defaultHKdDs3",
            instance_spec="2C8G",
            seg_node_num=2,
            seg_storage_type="cloud_essd",
            instance_network_type="VPC",
            db_instance_category="Basic",
            payment_type="PayAsYouGo",
            ssl_enabled=0,
            engine_version="6.0",
            zone_id="cn-beijing-h",
            vswitch_id=defaultw_la5v4.id,
            storage_size=50,
            master_cu=4,
            vpc_id=default_np_l_ra1.id,
            db_instance_mode="StorageElastic",
            engine="gpdb",
            description=name)
        default_db_instance_ip_array = alicloud.gpdb.DbInstanceIpArray("default",
            db_instance_ip_array_attribute="taffyFish",
            security_ip_lists=[
                "12.34.56.78",
                "11.45.14.0",
                "19.19.81.0",
            ],
            db_instance_ip_array_name="taffy",
            db_instance_id=default_h_kd_ds3.id)
        ```

        ## Import

        GPDB DB Instance IP Array can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/dbInstanceIpArray:DbInstanceIpArray example <db_instance_id>:<db_instance_ip_array_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
               
               > **NOTE:**  You can call the [DescribeDBInstances](https://www.alibabacloud.com/help/en/doc-detail/86911.html) operation to query details about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        :param pulumi.Input[_builtins.str] db_instance_ip_array_attribute: The default is empty. To distinguish between different attribute values, the console does not display groups with the 'hidden' attribute.
        :param pulumi.Input[_builtins.str] db_instance_ip_array_name: The name of the IP address whitelist. If you do not specify this parameter, the default whitelist is queried.
               
               > **NOTE:**   Each instance supports up to 50 IP address whitelists.
        :param pulumi.Input[_builtins.str] modify_mode: The method of modification. Valid values:
               
               - `Cover`: overwrites the whitelist.
               - `Append`: appends data to the whitelist.
               - `Delete`: deletes the whitelist.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ip_lists: The IP address whitelist contains a maximum of 1000 IP addresses separated by commas in the following three formats:
               - 0.0.0.0/0
               - 10.23.12.24(IP)
               - 10.23.12.24/24(CIDR mode, Classless Inter-Domain Routing, '/24' indicates the length of the prefix in the address, and the range is '[1,32]')
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbInstanceIpArrayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a GPDB DB Instance IP Array resource.

        Whitelist IP Group.

        For information about GPDB DB Instance IP Array and how to use it, see [What is DB Instance IP Array](https://www.alibabacloud.com/help/en/).

        > **NOTE:** Available since v1.231.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_np_l_ra1 = alicloud.vpc.Network("defaultNpLRa1", cidr_block="192.168.0.0/16")
        defaultw_la5v4 = alicloud.vpc.Switch("defaultwLA5v4",
            vpc_id=default_np_l_ra1.id,
            zone_id="cn-beijing-h",
            cidr_block="192.168.1.0/24")
        default_h_kd_ds3 = alicloud.gpdb.Instance("defaultHKdDs3",
            instance_spec="2C8G",
            seg_node_num=2,
            seg_storage_type="cloud_essd",
            instance_network_type="VPC",
            db_instance_category="Basic",
            payment_type="PayAsYouGo",
            ssl_enabled=0,
            engine_version="6.0",
            zone_id="cn-beijing-h",
            vswitch_id=defaultw_la5v4.id,
            storage_size=50,
            master_cu=4,
            vpc_id=default_np_l_ra1.id,
            db_instance_mode="StorageElastic",
            engine="gpdb",
            description=name)
        default_db_instance_ip_array = alicloud.gpdb.DbInstanceIpArray("default",
            db_instance_ip_array_attribute="taffyFish",
            security_ip_lists=[
                "12.34.56.78",
                "11.45.14.0",
                "19.19.81.0",
            ],
            db_instance_ip_array_name="taffy",
            db_instance_id=default_h_kd_ds3.id)
        ```

        ## Import

        GPDB DB Instance IP Array can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/dbInstanceIpArray:DbInstanceIpArray example <db_instance_id>:<db_instance_ip_array_name>
        ```

        :param str resource_name: The name of the resource.
        :param DbInstanceIpArrayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbInstanceIpArrayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ip_array_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ip_array_name: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbInstanceIpArrayArgs.__new__(DbInstanceIpArrayArgs)

            if db_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_id'")
            __props__.__dict__["db_instance_id"] = db_instance_id
            __props__.__dict__["db_instance_ip_array_attribute"] = db_instance_ip_array_attribute
            if db_instance_ip_array_name is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_ip_array_name'")
            __props__.__dict__["db_instance_ip_array_name"] = db_instance_ip_array_name
            __props__.__dict__["modify_mode"] = modify_mode
            if security_ip_lists is None and not opts.urn:
                raise TypeError("Missing required property 'security_ip_lists'")
            __props__.__dict__["security_ip_lists"] = security_ip_lists
        super(DbInstanceIpArray, __self__).__init__(
            'alicloud:gpdb/dbInstanceIpArray:DbInstanceIpArray',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_ip_array_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_ip_array_name: Optional[pulumi.Input[_builtins.str]] = None,
            modify_mode: Optional[pulumi.Input[_builtins.str]] = None,
            security_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'DbInstanceIpArray':
        """
        Get an existing DbInstanceIpArray resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
               
               > **NOTE:**  You can call the [DescribeDBInstances](https://www.alibabacloud.com/help/en/doc-detail/86911.html) operation to query details about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        :param pulumi.Input[_builtins.str] db_instance_ip_array_attribute: The default is empty. To distinguish between different attribute values, the console does not display groups with the 'hidden' attribute.
        :param pulumi.Input[_builtins.str] db_instance_ip_array_name: The name of the IP address whitelist. If you do not specify this parameter, the default whitelist is queried.
               
               > **NOTE:**   Each instance supports up to 50 IP address whitelists.
        :param pulumi.Input[_builtins.str] modify_mode: The method of modification. Valid values:
               
               - `Cover`: overwrites the whitelist.
               - `Append`: appends data to the whitelist.
               - `Delete`: deletes the whitelist.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ip_lists: The IP address whitelist contains a maximum of 1000 IP addresses separated by commas in the following three formats:
               - 0.0.0.0/0
               - 10.23.12.24(IP)
               - 10.23.12.24/24(CIDR mode, Classless Inter-Domain Routing, '/24' indicates the length of the prefix in the address, and the range is '[1,32]')
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbInstanceIpArrayState.__new__(_DbInstanceIpArrayState)

        __props__.__dict__["db_instance_id"] = db_instance_id
        __props__.__dict__["db_instance_ip_array_attribute"] = db_instance_ip_array_attribute
        __props__.__dict__["db_instance_ip_array_name"] = db_instance_ip_array_name
        __props__.__dict__["modify_mode"] = modify_mode
        __props__.__dict__["security_ip_lists"] = security_ip_lists
        return DbInstanceIpArray(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The instance ID.

        > **NOTE:**  You can call the [DescribeDBInstances](https://www.alibabacloud.com/help/en/doc-detail/86911.html) operation to query details about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter(name="dbInstanceIpArrayAttribute")
    def db_instance_ip_array_attribute(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The default is empty. To distinguish between different attribute values, the console does not display groups with the 'hidden' attribute.
        """
        return pulumi.get(self, "db_instance_ip_array_attribute")

    @_builtins.property
    @pulumi.getter(name="dbInstanceIpArrayName")
    def db_instance_ip_array_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the IP address whitelist. If you do not specify this parameter, the default whitelist is queried.

        > **NOTE:**   Each instance supports up to 50 IP address whitelists.
        """
        return pulumi.get(self, "db_instance_ip_array_name")

    @_builtins.property
    @pulumi.getter(name="modifyMode")
    def modify_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The method of modification. Valid values:

        - `Cover`: overwrites the whitelist.
        - `Append`: appends data to the whitelist.
        - `Delete`: deletes the whitelist.
        """
        return pulumi.get(self, "modify_mode")

    @_builtins.property
    @pulumi.getter(name="securityIpLists")
    def security_ip_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The IP address whitelist contains a maximum of 1000 IP addresses separated by commas in the following three formats:
        - 0.0.0.0/0
        - 10.23.12.24(IP)
        - 10.23.12.24/24(CIDR mode, Classless Inter-Domain Routing, '/24' indicates the length of the prefix in the address, and the range is '[1,32]')
        """
        return pulumi.get(self, "security_ip_lists")

