# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDataBackupsResult',
    'AwaitableGetDataBackupsResult',
    'get_data_backups',
    'get_data_backups_output',
]

@pulumi.output_type
class GetDataBackupsResult:
    """
    A collection of values returned by getDataBackups.
    """
    def __init__(__self__, backup_mode=None, backups=None, data_backup_id=None, data_type=None, db_instance_id=None, end_time=None, id=None, ids=None, output_file=None, page_number=None, page_size=None, start_time=None, status=None):
        if backup_mode and not isinstance(backup_mode, str):
            raise TypeError("Expected argument 'backup_mode' to be a str")
        pulumi.set(__self__, "backup_mode", backup_mode)
        if backups and not isinstance(backups, list):
            raise TypeError("Expected argument 'backups' to be a list")
        pulumi.set(__self__, "backups", backups)
        if data_backup_id and not isinstance(data_backup_id, str):
            raise TypeError("Expected argument 'data_backup_id' to be a str")
        pulumi.set(__self__, "data_backup_id", data_backup_id)
        if data_type and not isinstance(data_type, str):
            raise TypeError("Expected argument 'data_type' to be a str")
        pulumi.set(__self__, "data_type", data_type)
        if db_instance_id and not isinstance(db_instance_id, str):
            raise TypeError("Expected argument 'db_instance_id' to be a str")
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        if end_time and not isinstance(end_time, str):
            raise TypeError("Expected argument 'end_time' to be a str")
        pulumi.set(__self__, "end_time", end_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if start_time and not isinstance(start_time, str):
            raise TypeError("Expected argument 'start_time' to be a str")
        pulumi.set(__self__, "start_time", start_time)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="backupMode")
    def backup_mode(self) -> Optional[_builtins.str]:
        """
        Backup mode.Full Backup Value Description:-**Automated**: The system is automatically backed up.-**Manual**: Manual backup.Recovery point value description:-**Automated**: The recovery point after a full backup.-**Manual**: The recovery point triggered manually by the user.-**Period**: The recovery point triggered periodically because of the backup policy.
        """
        return pulumi.get(self, "backup_mode")

    @_builtins.property
    @pulumi.getter
    def backups(self) -> Sequence['outputs.GetDataBackupsBackupResult']:
        """
        A list of Data Backup Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "backups")

    @_builtins.property
    @pulumi.getter(name="dataBackupId")
    def data_backup_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "data_backup_id")

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[_builtins.str]:
        """
        The backup type. Value Description:-**DATA**: Full backup.-**RESTOREPOI**: Recoverable point.
        """
        return pulumi.get(self, "data_type")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> _builtins.str:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Data Backup IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Backup set status. Value Description:-Success: The backup has been completed.-Failed: Backup Failed.If not, return all.
        """
        return pulumi.get(self, "status")


class AwaitableGetDataBackupsResult(GetDataBackupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataBackupsResult(
            backup_mode=self.backup_mode,
            backups=self.backups,
            data_backup_id=self.data_backup_id,
            data_type=self.data_type,
            db_instance_id=self.db_instance_id,
            end_time=self.end_time,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            start_time=self.start_time,
            status=self.status)


def get_data_backups(backup_mode: Optional[_builtins.str] = None,
                     data_backup_id: Optional[_builtins.str] = None,
                     data_type: Optional[_builtins.str] = None,
                     db_instance_id: Optional[_builtins.str] = None,
                     end_time: Optional[_builtins.str] = None,
                     ids: Optional[Sequence[_builtins.str]] = None,
                     output_file: Optional[_builtins.str] = None,
                     page_number: Optional[_builtins.int] = None,
                     page_size: Optional[_builtins.int] = None,
                     start_time: Optional[_builtins.str] = None,
                     status: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataBackupsResult:
    """
    This data source provides Gpdb Data Backup available to the user.[What is Data Backup](https://www.alibabacloud.com/help/en/)

    > **NOTE:** Available since v1.231.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.gpdb.get_instances(name_regex="^default-NODELETING$")
    default_get_data_backups = alicloud.gpdb.get_data_backups(db_instance_id=default.ids[0])
    pulumi.export("alicloudGpdbDataBackupExampleId", default_get_data_backups.backups[0].db_instance_id)
    ```


    :param _builtins.str backup_mode: Backup mode.Full Backup Value Description:-**Automated**: The system is automatically backed up.-**Manual**: Manual backup.Recovery point value description:-**Automated**: The recovery point after a full backup.-**Manual**: The recovery point triggered manually by the user.-**Period**: The recovery point triggered periodically because of the backup policy.
    :param _builtins.str data_backup_id: The first ID of the resource
    :param _builtins.str data_type: The backup type. Value Description:-**DATA**: Full backup.-**RESTOREPOI**: Recoverable point.
    :param _builtins.str db_instance_id: The instance ID.
    :param _builtins.str end_time: The query end time, which must be greater than the query start time. Format: yyyy-MM-ddTHH:mmZ(UTC time).
    :param Sequence[_builtins.str] ids: A list of Databackup IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.int page_number: Current page number.
    :param _builtins.int page_size: Number of records per page.
    :param _builtins.str start_time: The query start time. Format: yyyy-MM-ddTHH:mmZ(UTC time).
    :param _builtins.str status: Backup set status. Value Description:-Success: The backup has been completed.-Failed: Backup Failed.If not, return all.
    """
    __args__ = dict()
    __args__['backupMode'] = backup_mode
    __args__['dataBackupId'] = data_backup_id
    __args__['dataType'] = data_type
    __args__['dbInstanceId'] = db_instance_id
    __args__['endTime'] = end_time
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['startTime'] = start_time
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:gpdb/getDataBackups:getDataBackups', __args__, opts=opts, typ=GetDataBackupsResult).value

    return AwaitableGetDataBackupsResult(
        backup_mode=pulumi.get(__ret__, 'backup_mode'),
        backups=pulumi.get(__ret__, 'backups'),
        data_backup_id=pulumi.get(__ret__, 'data_backup_id'),
        data_type=pulumi.get(__ret__, 'data_type'),
        db_instance_id=pulumi.get(__ret__, 'db_instance_id'),
        end_time=pulumi.get(__ret__, 'end_time'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        start_time=pulumi.get(__ret__, 'start_time'),
        status=pulumi.get(__ret__, 'status'))
def get_data_backups_output(backup_mode: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            data_backup_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            data_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                            end_time: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                            output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                            page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                            start_time: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDataBackupsResult]:
    """
    This data source provides Gpdb Data Backup available to the user.[What is Data Backup](https://www.alibabacloud.com/help/en/)

    > **NOTE:** Available since v1.231.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.gpdb.get_instances(name_regex="^default-NODELETING$")
    default_get_data_backups = alicloud.gpdb.get_data_backups(db_instance_id=default.ids[0])
    pulumi.export("alicloudGpdbDataBackupExampleId", default_get_data_backups.backups[0].db_instance_id)
    ```


    :param _builtins.str backup_mode: Backup mode.Full Backup Value Description:-**Automated**: The system is automatically backed up.-**Manual**: Manual backup.Recovery point value description:-**Automated**: The recovery point after a full backup.-**Manual**: The recovery point triggered manually by the user.-**Period**: The recovery point triggered periodically because of the backup policy.
    :param _builtins.str data_backup_id: The first ID of the resource
    :param _builtins.str data_type: The backup type. Value Description:-**DATA**: Full backup.-**RESTOREPOI**: Recoverable point.
    :param _builtins.str db_instance_id: The instance ID.
    :param _builtins.str end_time: The query end time, which must be greater than the query start time. Format: yyyy-MM-ddTHH:mmZ(UTC time).
    :param Sequence[_builtins.str] ids: A list of Databackup IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.int page_number: Current page number.
    :param _builtins.int page_size: Number of records per page.
    :param _builtins.str start_time: The query start time. Format: yyyy-MM-ddTHH:mmZ(UTC time).
    :param _builtins.str status: Backup set status. Value Description:-Success: The backup has been completed.-Failed: Backup Failed.If not, return all.
    """
    __args__ = dict()
    __args__['backupMode'] = backup_mode
    __args__['dataBackupId'] = data_backup_id
    __args__['dataType'] = data_type
    __args__['dbInstanceId'] = db_instance_id
    __args__['endTime'] = end_time
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['startTime'] = start_time
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:gpdb/getDataBackups:getDataBackups', __args__, opts=opts, typ=GetDataBackupsResult)
    return __ret__.apply(lambda __response__: GetDataBackupsResult(
        backup_mode=pulumi.get(__response__, 'backup_mode'),
        backups=pulumi.get(__response__, 'backups'),
        data_backup_id=pulumi.get(__response__, 'data_backup_id'),
        data_type=pulumi.get(__response__, 'data_type'),
        db_instance_id=pulumi.get(__response__, 'db_instance_id'),
        end_time=pulumi.get(__response__, 'end_time'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        start_time=pulumi.get(__response__, 'start_time'),
        status=pulumi.get(__response__, 'status')))
