# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['StreamingDataSourceArgs', 'StreamingDataSource']

@pulumi.input_type
class StreamingDataSourceArgs:
    def __init__(__self__, *,
                 data_source_config: pulumi.Input[_builtins.str],
                 data_source_name: pulumi.Input[_builtins.str],
                 data_source_type: pulumi.Input[_builtins.str],
                 db_instance_id: pulumi.Input[_builtins.str],
                 service_id: pulumi.Input[_builtins.int],
                 data_source_description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StreamingDataSource resource.
        :param pulumi.Input[_builtins.str] data_source_config: The configurations of the data source.
        :param pulumi.Input[_builtins.str] data_source_name: Data Source Name
        :param pulumi.Input[_builtins.str] data_source_type: Data Source Type
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
               
               > **NOTE:**   You can call the [DescribeDBInstances](https://www.alibabacloud.com/help/en/doc-detail/196830.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        :param pulumi.Input[_builtins.int] service_id: The real-time data service ID.
        :param pulumi.Input[_builtins.str] data_source_description: The description of the data source.
        """
        pulumi.set(__self__, "data_source_config", data_source_config)
        pulumi.set(__self__, "data_source_name", data_source_name)
        pulumi.set(__self__, "data_source_type", data_source_type)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "service_id", service_id)
        if data_source_description is not None:
            pulumi.set(__self__, "data_source_description", data_source_description)

    @_builtins.property
    @pulumi.getter(name="dataSourceConfig")
    def data_source_config(self) -> pulumi.Input[_builtins.str]:
        """
        The configurations of the data source.
        """
        return pulumi.get(self, "data_source_config")

    @data_source_config.setter
    def data_source_config(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_source_config", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> pulumi.Input[_builtins.str]:
        """
        Data Source Name
        """
        return pulumi.get(self, "data_source_name")

    @data_source_name.setter
    def data_source_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_source_name", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> pulumi.Input[_builtins.str]:
        """
        Data Source Type
        """
        return pulumi.get(self, "data_source_type")

    @data_source_type.setter
    def data_source_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_source_type", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The instance ID.

        > **NOTE:**   You can call the [DescribeDBInstances](https://www.alibabacloud.com/help/en/doc-detail/196830.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[_builtins.int]:
        """
        The real-time data service ID.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "service_id", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceDescription")
    def data_source_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the data source.
        """
        return pulumi.get(self, "data_source_description")

    @data_source_description.setter
    def data_source_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_description", value)


@pulumi.input_type
class _StreamingDataSourceState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_config: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_description: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StreamingDataSource resources.
        :param pulumi.Input[_builtins.str] create_time: Creation time
        :param pulumi.Input[_builtins.str] data_source_config: The configurations of the data source.
        :param pulumi.Input[_builtins.str] data_source_description: The description of the data source.
        :param pulumi.Input[_builtins.str] data_source_id: The data source ID.
        :param pulumi.Input[_builtins.str] data_source_name: Data Source Name
        :param pulumi.Input[_builtins.str] data_source_type: Data Source Type
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
               
               > **NOTE:**   You can call the [DescribeDBInstances](https://www.alibabacloud.com/help/en/doc-detail/196830.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        :param pulumi.Input[_builtins.int] service_id: The real-time data service ID.
        :param pulumi.Input[_builtins.str] status: Service Status:
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_source_config is not None:
            pulumi.set(__self__, "data_source_config", data_source_config)
        if data_source_description is not None:
            pulumi.set(__self__, "data_source_description", data_source_description)
        if data_source_id is not None:
            pulumi.set(__self__, "data_source_id", data_source_id)
        if data_source_name is not None:
            pulumi.set(__self__, "data_source_name", data_source_name)
        if data_source_type is not None:
            pulumi.set(__self__, "data_source_type", data_source_type)
        if db_instance_id is not None:
            pulumi.set(__self__, "db_instance_id", db_instance_id)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation time
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceConfig")
    def data_source_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configurations of the data source.
        """
        return pulumi.get(self, "data_source_config")

    @data_source_config.setter
    def data_source_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_config", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceDescription")
    def data_source_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the data source.
        """
        return pulumi.get(self, "data_source_description")

    @data_source_description.setter
    def data_source_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_description", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data source ID.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_id", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Source Name
        """
        return pulumi.get(self, "data_source_name")

    @data_source_name.setter
    def data_source_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_name", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Source Type
        """
        return pulumi.get(self, "data_source_type")

    @data_source_type.setter
    def data_source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_type", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance ID.

        > **NOTE:**   You can call the [DescribeDBInstances](https://www.alibabacloud.com/help/en/doc-detail/196830.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The real-time data service ID.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "service_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service Status:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:gpdb/streamingDataSource:StreamingDataSource")
class StreamingDataSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_source_config: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_description: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a GPDB Streaming Data Source resource.

        Real-time data source.

        For information about GPDB Streaming Data Source and how to use it, see [What is Streaming Data Source](https://www.alibabacloud.com/help/en/analyticdb/analyticdb-for-postgresql/developer-reference/api-gpdb-2016-05-03-createstreamingdatasource).

        > **NOTE:** Available since v1.227.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        kafka_config_modify = config.get("kafka-config-modify")
        if kafka_config_modify is None:
            kafka_config_modify = \"\"\"{
            "brokers": "alikafka-post-cn-g4t3t4eod004-1-vpc.alikafka.aliyuncs.com:9092,alikafka-post-cn-g4t3t4eod004-2-vpc.alikafka.aliyuncs.com:9092,alikafka-post-cn-g4t3t4eod004-3-vpc.alikafka.aliyuncs.com:9092",
            "delimiter": "#",
            "format": "delimited",
            "topic": "ziyuan_example"
        }
        \"\"\"
        kafka_config = config.get("kafka-config")
        if kafka_config is None:
            kafka_config = \"\"\"{
            "brokers": "alikafka-post-cn-g4t3t4eod004-1-vpc.alikafka.aliyuncs.com:9092,alikafka-post-cn-g4t3t4eod004-2-vpc.alikafka.aliyuncs.com:9092,alikafka-post-cn-g4t3t4eod004-3-vpc.alikafka.aliyuncs.com:9092",
            "delimiter": "|",
            "format": "delimited",
            "topic": "ziyuan_example"
        }
        \"\"\"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_dfk_yor = alicloud.vpc.Network("defaultDfkYOR", cidr_block="192.168.0.0/16")
        default59_zqy_d = alicloud.vpc.Switch("default59ZqyD",
            vpc_id=default_dfk_yor.id,
            zone_id="cn-beijing-h",
            cidr_block="192.168.1.0/24")
        default7m_x6ld = alicloud.gpdb.Instance("default7mX6ld",
            instance_spec="2C8G",
            description=name,
            seg_node_num=2,
            seg_storage_type="cloud_essd",
            instance_network_type="VPC",
            db_instance_category="Basic",
            payment_type="PayAsYouGo",
            ssl_enabled=0,
            engine_version="6.0",
            zone_id="cn-beijing-h",
            vswitch_id=default59_zqy_d.id,
            storage_size=50,
            master_cu=4,
            vpc_id=default_dfk_yor.id,
            db_instance_mode="StorageElastic",
            engine="gpdb")
        defaultwruvdv = alicloud.gpdb.StreamingDataService("defaultwruvdv",
            service_name="example",
            db_instance_id=default7m_x6ld.id,
            service_description="example",
            service_spec="8")
        default_streaming_data_source = alicloud.gpdb.StreamingDataSource("default",
            db_instance_id=default7m_x6ld.id,
            data_source_name="example-kafka3",
            data_source_config=kafka_config,
            data_source_type="kafka",
            data_source_description="example-kafka",
            service_id=defaultwruvdv.service_id)
        ```

        ## Import

        GPDB Streaming Data Source can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/streamingDataSource:StreamingDataSource example <db_instance_id>:<data_source_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_source_config: The configurations of the data source.
        :param pulumi.Input[_builtins.str] data_source_description: The description of the data source.
        :param pulumi.Input[_builtins.str] data_source_name: Data Source Name
        :param pulumi.Input[_builtins.str] data_source_type: Data Source Type
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
               
               > **NOTE:**   You can call the [DescribeDBInstances](https://www.alibabacloud.com/help/en/doc-detail/196830.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        :param pulumi.Input[_builtins.int] service_id: The real-time data service ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamingDataSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a GPDB Streaming Data Source resource.

        Real-time data source.

        For information about GPDB Streaming Data Source and how to use it, see [What is Streaming Data Source](https://www.alibabacloud.com/help/en/analyticdb/analyticdb-for-postgresql/developer-reference/api-gpdb-2016-05-03-createstreamingdatasource).

        > **NOTE:** Available since v1.227.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        kafka_config_modify = config.get("kafka-config-modify")
        if kafka_config_modify is None:
            kafka_config_modify = \"\"\"{
            "brokers": "alikafka-post-cn-g4t3t4eod004-1-vpc.alikafka.aliyuncs.com:9092,alikafka-post-cn-g4t3t4eod004-2-vpc.alikafka.aliyuncs.com:9092,alikafka-post-cn-g4t3t4eod004-3-vpc.alikafka.aliyuncs.com:9092",
            "delimiter": "#",
            "format": "delimited",
            "topic": "ziyuan_example"
        }
        \"\"\"
        kafka_config = config.get("kafka-config")
        if kafka_config is None:
            kafka_config = \"\"\"{
            "brokers": "alikafka-post-cn-g4t3t4eod004-1-vpc.alikafka.aliyuncs.com:9092,alikafka-post-cn-g4t3t4eod004-2-vpc.alikafka.aliyuncs.com:9092,alikafka-post-cn-g4t3t4eod004-3-vpc.alikafka.aliyuncs.com:9092",
            "delimiter": "|",
            "format": "delimited",
            "topic": "ziyuan_example"
        }
        \"\"\"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_dfk_yor = alicloud.vpc.Network("defaultDfkYOR", cidr_block="192.168.0.0/16")
        default59_zqy_d = alicloud.vpc.Switch("default59ZqyD",
            vpc_id=default_dfk_yor.id,
            zone_id="cn-beijing-h",
            cidr_block="192.168.1.0/24")
        default7m_x6ld = alicloud.gpdb.Instance("default7mX6ld",
            instance_spec="2C8G",
            description=name,
            seg_node_num=2,
            seg_storage_type="cloud_essd",
            instance_network_type="VPC",
            db_instance_category="Basic",
            payment_type="PayAsYouGo",
            ssl_enabled=0,
            engine_version="6.0",
            zone_id="cn-beijing-h",
            vswitch_id=default59_zqy_d.id,
            storage_size=50,
            master_cu=4,
            vpc_id=default_dfk_yor.id,
            db_instance_mode="StorageElastic",
            engine="gpdb")
        defaultwruvdv = alicloud.gpdb.StreamingDataService("defaultwruvdv",
            service_name="example",
            db_instance_id=default7m_x6ld.id,
            service_description="example",
            service_spec="8")
        default_streaming_data_source = alicloud.gpdb.StreamingDataSource("default",
            db_instance_id=default7m_x6ld.id,
            data_source_name="example-kafka3",
            data_source_config=kafka_config,
            data_source_type="kafka",
            data_source_description="example-kafka",
            service_id=defaultwruvdv.service_id)
        ```

        ## Import

        GPDB Streaming Data Source can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/streamingDataSource:StreamingDataSource example <db_instance_id>:<data_source_id>
        ```

        :param str resource_name: The name of the resource.
        :param StreamingDataSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamingDataSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_source_config: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_description: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamingDataSourceArgs.__new__(StreamingDataSourceArgs)

            if data_source_config is None and not opts.urn:
                raise TypeError("Missing required property 'data_source_config'")
            __props__.__dict__["data_source_config"] = data_source_config
            __props__.__dict__["data_source_description"] = data_source_description
            if data_source_name is None and not opts.urn:
                raise TypeError("Missing required property 'data_source_name'")
            __props__.__dict__["data_source_name"] = data_source_name
            if data_source_type is None and not opts.urn:
                raise TypeError("Missing required property 'data_source_type'")
            __props__.__dict__["data_source_type"] = data_source_type
            if db_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_id'")
            __props__.__dict__["db_instance_id"] = db_instance_id
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["data_source_id"] = None
            __props__.__dict__["status"] = None
        super(StreamingDataSource, __self__).__init__(
            'alicloud:gpdb/streamingDataSource:StreamingDataSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            data_source_config: Optional[pulumi.Input[_builtins.str]] = None,
            data_source_description: Optional[pulumi.Input[_builtins.str]] = None,
            data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
            data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
            data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_id: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'StreamingDataSource':
        """
        Get an existing StreamingDataSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Creation time
        :param pulumi.Input[_builtins.str] data_source_config: The configurations of the data source.
        :param pulumi.Input[_builtins.str] data_source_description: The description of the data source.
        :param pulumi.Input[_builtins.str] data_source_id: The data source ID.
        :param pulumi.Input[_builtins.str] data_source_name: Data Source Name
        :param pulumi.Input[_builtins.str] data_source_type: Data Source Type
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
               
               > **NOTE:**   You can call the [DescribeDBInstances](https://www.alibabacloud.com/help/en/doc-detail/196830.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        :param pulumi.Input[_builtins.int] service_id: The real-time data service ID.
        :param pulumi.Input[_builtins.str] status: Service Status:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamingDataSourceState.__new__(_StreamingDataSourceState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_source_config"] = data_source_config
        __props__.__dict__["data_source_description"] = data_source_description
        __props__.__dict__["data_source_id"] = data_source_id
        __props__.__dict__["data_source_name"] = data_source_name
        __props__.__dict__["data_source_type"] = data_source_type
        __props__.__dict__["db_instance_id"] = db_instance_id
        __props__.__dict__["service_id"] = service_id
        __props__.__dict__["status"] = status
        return StreamingDataSource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Creation time
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dataSourceConfig")
    def data_source_config(self) -> pulumi.Output[_builtins.str]:
        """
        The configurations of the data source.
        """
        return pulumi.get(self, "data_source_config")

    @_builtins.property
    @pulumi.getter(name="dataSourceDescription")
    def data_source_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the data source.
        """
        return pulumi.get(self, "data_source_description")

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Output[_builtins.str]:
        """
        The data source ID.
        """
        return pulumi.get(self, "data_source_id")

    @_builtins.property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> pulumi.Output[_builtins.str]:
        """
        Data Source Name
        """
        return pulumi.get(self, "data_source_name")

    @_builtins.property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> pulumi.Output[_builtins.str]:
        """
        Data Source Type
        """
        return pulumi.get(self, "data_source_type")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The instance ID.

        > **NOTE:**   You can call the [DescribeDBInstances](https://www.alibabacloud.com/help/en/doc-detail/196830.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[_builtins.int]:
        """
        The real-time data service ID.
        """
        return pulumi.get(self, "service_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Service Status:
        """
        return pulumi.get(self, "status")

