# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'OtsBackupPlanOtsDetailArgs',
    'OtsBackupPlanOtsDetailArgsDict',
    'OtsBackupPlanRuleArgs',
    'OtsBackupPlanRuleArgsDict',
    'PolicyBindingAdvancedOptionsArgs',
    'PolicyBindingAdvancedOptionsArgsDict',
    'PolicyBindingAdvancedOptionsUdmDetailArgs',
    'PolicyBindingAdvancedOptionsUdmDetailArgsDict',
    'PolicyRuleArgs',
    'PolicyRuleArgsDict',
    'PolicyRuleRetentionRuleArgs',
    'PolicyRuleRetentionRuleArgsDict',
    'RestoreJobOtsDetailArgs',
    'RestoreJobOtsDetailArgsDict',
    'ServerBackupPlanDetailArgs',
    'ServerBackupPlanDetailArgsDict',
    'GetBackupJobsFilterArgs',
    'GetBackupJobsFilterArgsDict',
    'GetServerBackupPlansFilterArgs',
    'GetServerBackupPlansFilterArgsDict',
]

MYPY = False

if not MYPY:
    class OtsBackupPlanOtsDetailArgsDict(TypedDict):
        table_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The names of the destination tables in the Tablestore instance. **Note:** Required while source_type equals `OTS_TABLE`.
        """
elif False:
    OtsBackupPlanOtsDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OtsBackupPlanOtsDetailArgs:
    def __init__(__self__, *,
                 table_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] table_names: The names of the destination tables in the Tablestore instance. **Note:** Required while source_type equals `OTS_TABLE`.
        """
        if table_names is not None:
            pulumi.set(__self__, "table_names", table_names)

    @_builtins.property
    @pulumi.getter(name="tableNames")
    def table_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The names of the destination tables in the Tablestore instance. **Note:** Required while source_type equals `OTS_TABLE`.
        """
        return pulumi.get(self, "table_names")

    @table_names.setter
    def table_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "table_names", value)


if not MYPY:
    class OtsBackupPlanRuleArgsDict(TypedDict):
        backup_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Backup type. Valid values: `COMPLETE`.
        """
        disabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
        """
        retention: NotRequired[pulumi.Input[_builtins.str]]
        """
        Backup retention days, the minimum is 1.
        """
        rule_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the backup rule.**Note:** Required while source_type equals `OTS_TABLE`. `rule_name` should be unique for the specific user.
        """
        schedule: NotRequired[pulumi.Input[_builtins.str]]
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        - `startTime` Backup start time, UNIX time seconds.
        """
elif False:
    OtsBackupPlanRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OtsBackupPlanRuleArgs:
    def __init__(__self__, *,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 retention: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] backup_type: Backup type. Valid values: `COMPLETE`.
        :param pulumi.Input[_builtins.bool] disabled: Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
        :param pulumi.Input[_builtins.str] retention: Backup retention days, the minimum is 1.
        :param pulumi.Input[_builtins.str] rule_name: The name of the backup rule.**Note:** Required while source_type equals `OTS_TABLE`. `rule_name` should be unique for the specific user.
        :param pulumi.Input[_builtins.str] schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
               - `startTime` Backup start time, UNIX time seconds.
        """
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_type", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the backup rule.**Note:** Required while source_type equals `OTS_TABLE`. `rule_name` should be unique for the specific user.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        - `startTime` Backup start time, UNIX time seconds.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule", value)


if not MYPY:
    class PolicyBindingAdvancedOptionsArgsDict(TypedDict):
        udm_detail: NotRequired[pulumi.Input['PolicyBindingAdvancedOptionsUdmDetailArgsDict']]
        """
        ECS Backup Advanced options. See `udm_detail` below.
        """
elif False:
    PolicyBindingAdvancedOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyBindingAdvancedOptionsArgs:
    def __init__(__self__, *,
                 udm_detail: Optional[pulumi.Input['PolicyBindingAdvancedOptionsUdmDetailArgs']] = None):
        """
        :param pulumi.Input['PolicyBindingAdvancedOptionsUdmDetailArgs'] udm_detail: ECS Backup Advanced options. See `udm_detail` below.
        """
        if udm_detail is not None:
            pulumi.set(__self__, "udm_detail", udm_detail)

    @_builtins.property
    @pulumi.getter(name="udmDetail")
    def udm_detail(self) -> Optional[pulumi.Input['PolicyBindingAdvancedOptionsUdmDetailArgs']]:
        """
        ECS Backup Advanced options. See `udm_detail` below.
        """
        return pulumi.get(self, "udm_detail")

    @udm_detail.setter
    def udm_detail(self, value: Optional[pulumi.Input['PolicyBindingAdvancedOptionsUdmDetailArgs']]):
        pulumi.set(self, "udm_detail", value)


if not MYPY:
    class PolicyBindingAdvancedOptionsUdmDetailArgsDict(TypedDict):
        destination_kms_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Custom KMS key ID of encrypted copy.
        """
        disk_id_lists: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The list of backup disks. If it is empty, all disks are backed up.
        """
        exclude_disk_id_lists: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of cloud disk IDs that are not backed up.
        """
elif False:
    PolicyBindingAdvancedOptionsUdmDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyBindingAdvancedOptionsUdmDetailArgs:
    def __init__(__self__, *,
                 destination_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 exclude_disk_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] destination_kms_key_id: Custom KMS key ID of encrypted copy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disk_id_lists: The list of backup disks. If it is empty, all disks are backed up.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_disk_id_lists: List of cloud disk IDs that are not backed up.
        """
        if destination_kms_key_id is not None:
            pulumi.set(__self__, "destination_kms_key_id", destination_kms_key_id)
        if disk_id_lists is not None:
            pulumi.set(__self__, "disk_id_lists", disk_id_lists)
        if exclude_disk_id_lists is not None:
            pulumi.set(__self__, "exclude_disk_id_lists", exclude_disk_id_lists)

    @_builtins.property
    @pulumi.getter(name="destinationKmsKeyId")
    def destination_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom KMS key ID of encrypted copy.
        """
        return pulumi.get(self, "destination_kms_key_id")

    @destination_kms_key_id.setter
    def destination_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="diskIdLists")
    def disk_id_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of backup disks. If it is empty, all disks are backed up.
        """
        return pulumi.get(self, "disk_id_lists")

    @disk_id_lists.setter
    def disk_id_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "disk_id_lists", value)

    @_builtins.property
    @pulumi.getter(name="excludeDiskIdLists")
    def exclude_disk_id_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of cloud disk IDs that are not backed up.
        """
        return pulumi.get(self, "exclude_disk_id_lists")

    @exclude_disk_id_lists.setter
    def exclude_disk_id_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "exclude_disk_id_lists", value)


if not MYPY:
    class PolicyRuleArgsDict(TypedDict):
        rule_type: pulumi.Input[_builtins.str]
        """
        Rule Type.
        """
        archive_days: NotRequired[pulumi.Input[_builtins.int]]
        """
        This parameter is required only when the value of `RuleType` is **TRANSITION. The minimum value is 30, and the Retention-ArchiveDays needs to be greater than or equal to 60.
        """
        backup_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        This parameter is required only when the `RuleType` value is **BACKUP. Backup Type.
        """
        keep_latest_snapshots: NotRequired[pulumi.Input[_builtins.int]]
        """
        This parameter is required only when `RuleType` is set to `BACKUP`.
        """
        replication_region_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Only when the `RuleType` value is.
        """
        retention: NotRequired[pulumi.Input[_builtins.int]]
        """
        Retention time, in days.
        """
        retention_rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['PolicyRuleRetentionRuleArgsDict']]]]
        """
        This parameter is required only when the value of `RuleType` is `TRANSITION`. See `retention_rules` below.
        """
        rule_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Rule ID.
        """
        schedule: NotRequired[pulumi.Input[_builtins.str]]
        """
        This parameter is required only if you set the `RuleType` parameter to `BACKUP`. This parameter specifies the backup schedule settings. Format: `I|{startTime}|{interval}`. The system runs the first backup job at a point in time that is specified in the {startTime} parameter and the subsequent backup jobs at an interval that is specified in the {interval} parameter. The system does not run a backup job before the specified point in time. Each backup job, except the first one, starts only after the previous backup job is complete. For example, `I|1631685600|P1D` specifies that the system runs the first backup job at 14:00:00 on September 15, 2021 and the subsequent backup jobs once a day.  *   startTime: the time at which the system starts to run a backup job. The time must follow the UNIX time format. Unit: seconds. *   interval: the interval at which the system runs a backup job. The interval must follow the ISO 8601 standard. For example, PT1H specifies an interval of one hour. P1D specifies an interval of one day.
        """
        vault_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Vault ID.
        """
elif False:
    PolicyRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyRuleArgs:
    def __init__(__self__, *,
                 rule_type: pulumi.Input[_builtins.str],
                 archive_days: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 keep_latest_snapshots: Optional[pulumi.Input[_builtins.int]] = None,
                 replication_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retention: Optional[pulumi.Input[_builtins.int]] = None,
                 retention_rules: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyRuleRetentionRuleArgs']]]] = None,
                 rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] rule_type: Rule Type.
        :param pulumi.Input[_builtins.int] archive_days: This parameter is required only when the value of `RuleType` is **TRANSITION. The minimum value is 30, and the Retention-ArchiveDays needs to be greater than or equal to 60.
        :param pulumi.Input[_builtins.str] backup_type: This parameter is required only when the `RuleType` value is **BACKUP. Backup Type.
        :param pulumi.Input[_builtins.int] keep_latest_snapshots: This parameter is required only when `RuleType` is set to `BACKUP`.
        :param pulumi.Input[_builtins.str] replication_region_id: Only when the `RuleType` value is.
        :param pulumi.Input[_builtins.int] retention: Retention time, in days.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyRuleRetentionRuleArgs']]] retention_rules: This parameter is required only when the value of `RuleType` is `TRANSITION`. See `retention_rules` below.
        :param pulumi.Input[_builtins.str] rule_id: Rule ID.
        :param pulumi.Input[_builtins.str] schedule: This parameter is required only if you set the `RuleType` parameter to `BACKUP`. This parameter specifies the backup schedule settings. Format: `I|{startTime}|{interval}`. The system runs the first backup job at a point in time that is specified in the {startTime} parameter and the subsequent backup jobs at an interval that is specified in the {interval} parameter. The system does not run a backup job before the specified point in time. Each backup job, except the first one, starts only after the previous backup job is complete. For example, `I|1631685600|P1D` specifies that the system runs the first backup job at 14:00:00 on September 15, 2021 and the subsequent backup jobs once a day.  *   startTime: the time at which the system starts to run a backup job. The time must follow the UNIX time format. Unit: seconds. *   interval: the interval at which the system runs a backup job. The interval must follow the ISO 8601 standard. For example, PT1H specifies an interval of one hour. P1D specifies an interval of one day.
        :param pulumi.Input[_builtins.str] vault_id: Vault ID.
        """
        pulumi.set(__self__, "rule_type", rule_type)
        if archive_days is not None:
            pulumi.set(__self__, "archive_days", archive_days)
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if keep_latest_snapshots is not None:
            pulumi.set(__self__, "keep_latest_snapshots", keep_latest_snapshots)
        if replication_region_id is not None:
            pulumi.set(__self__, "replication_region_id", replication_region_id)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if retention_rules is not None:
            pulumi.set(__self__, "retention_rules", retention_rules)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Input[_builtins.str]:
        """
        Rule Type.
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_type", value)

    @_builtins.property
    @pulumi.getter(name="archiveDays")
    def archive_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        This parameter is required only when the value of `RuleType` is **TRANSITION. The minimum value is 30, and the Retention-ArchiveDays needs to be greater than or equal to 60.
        """
        return pulumi.get(self, "archive_days")

    @archive_days.setter
    def archive_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "archive_days", value)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is required only when the `RuleType` value is **BACKUP. Backup Type.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_type", value)

    @_builtins.property
    @pulumi.getter(name="keepLatestSnapshots")
    def keep_latest_snapshots(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        This parameter is required only when `RuleType` is set to `BACKUP`.
        """
        return pulumi.get(self, "keep_latest_snapshots")

    @keep_latest_snapshots.setter
    def keep_latest_snapshots(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "keep_latest_snapshots", value)

    @_builtins.property
    @pulumi.getter(name="replicationRegionId")
    def replication_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Only when the `RuleType` value is.
        """
        return pulumi.get(self, "replication_region_id")

    @replication_region_id.setter
    def replication_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_region_id", value)

    @_builtins.property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Retention time, in days.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention", value)

    @_builtins.property
    @pulumi.getter(name="retentionRules")
    def retention_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyRuleRetentionRuleArgs']]]]:
        """
        This parameter is required only when the value of `RuleType` is `TRANSITION`. See `retention_rules` below.
        """
        return pulumi.get(self, "retention_rules")

    @retention_rules.setter
    def retention_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyRuleRetentionRuleArgs']]]]):
        pulumi.set(self, "retention_rules", value)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule ID.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_id", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is required only if you set the `RuleType` parameter to `BACKUP`. This parameter specifies the backup schedule settings. Format: `I|{startTime}|{interval}`. The system runs the first backup job at a point in time that is specified in the {startTime} parameter and the subsequent backup jobs at an interval that is specified in the {interval} parameter. The system does not run a backup job before the specified point in time. Each backup job, except the first one, starts only after the previous backup job is complete. For example, `I|1631685600|P1D` specifies that the system runs the first backup job at 14:00:00 on September 15, 2021 and the subsequent backup jobs once a day.  *   startTime: the time at which the system starts to run a backup job. The time must follow the UNIX time format. Unit: seconds. *   interval: the interval at which the system runs a backup job. The interval must follow the ISO 8601 standard. For example, PT1H specifies an interval of one hour. P1D specifies an interval of one day.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vault ID.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_id", value)


if not MYPY:
    class PolicyRuleRetentionRuleArgsDict(TypedDict):
        advanced_retention_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Valid values: `annually`, `MONTHLY`, and `WEEKLY`:- `annually`: the first backup of each year. - `MONTHLY`: The first backup of the month. - `WEEKLY`: The first backup of the week. - `DAILY`: The first backup of the day.
        """
        retention: NotRequired[pulumi.Input[_builtins.int]]
        """
        Retention time, in days.
        """
elif False:
    PolicyRuleRetentionRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyRuleRetentionRuleArgs:
    def __init__(__self__, *,
                 advanced_retention_type: Optional[pulumi.Input[_builtins.str]] = None,
                 retention: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] advanced_retention_type: Valid values: `annually`, `MONTHLY`, and `WEEKLY`:- `annually`: the first backup of each year. - `MONTHLY`: The first backup of the month. - `WEEKLY`: The first backup of the week. - `DAILY`: The first backup of the day.
        :param pulumi.Input[_builtins.int] retention: Retention time, in days.
        """
        if advanced_retention_type is not None:
            pulumi.set(__self__, "advanced_retention_type", advanced_retention_type)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)

    @_builtins.property
    @pulumi.getter(name="advancedRetentionType")
    def advanced_retention_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values: `annually`, `MONTHLY`, and `WEEKLY`:- `annually`: the first backup of each year. - `MONTHLY`: The first backup of the month. - `WEEKLY`: The first backup of the week. - `DAILY`: The first backup of the day.
        """
        return pulumi.get(self, "advanced_retention_type")

    @advanced_retention_type.setter
    def advanced_retention_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "advanced_retention_type", value)

    @_builtins.property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Retention time, in days.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention", value)


if not MYPY:
    class RestoreJobOtsDetailArgsDict(TypedDict):
        overwrite_existing: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to overwrite the existing table storage recovery task. Valid values: `true`, `false`.
        """
elif False:
    RestoreJobOtsDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestoreJobOtsDetailArgs:
    def __init__(__self__, *,
                 overwrite_existing: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] overwrite_existing: Whether to overwrite the existing table storage recovery task. Valid values: `true`, `false`.
        """
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)

    @_builtins.property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to overwrite the existing table storage recovery task. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "overwrite_existing")

    @overwrite_existing.setter
    def overwrite_existing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "overwrite_existing", value)


if not MYPY:
    class ServerBackupPlanDetailArgsDict(TypedDict):
        app_consistent: pulumi.Input[_builtins.bool]
        """
        Whether to turn on application consistency. The application consistency snapshot backs up memory data and ongoing database transactions at the time of snapshot creation to ensure the consistency of application system data and database transactions. By applying consistent snapshots, there is no data damage or loss, so as to avoid log rollback during database startup and ensure that the application is in a consistent startup state. Valid values: `true`, `false`.
        """
        snapshot_group: pulumi.Input[_builtins.bool]
        """
        Whether to turn on file system consistency. If SnapshotGroup is true, when AppConsistent is true but the relevant conditions are not met or AppConsistent is false, the resulting snapshot will be a file system consistency snapshot. The file system consistency ensures that the file system memory and disk information are synchronized at the time of snapshot creation, and the file system write operation is frozen to make the file system in a consistent state. The file system consistency snapshot can prevent the operating system from performing disk inspection and repair operations such as CHKDSK or fsck after restart. Valid values: `true`, `false`.
        """
        destination_region_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Only vaild when DoCopy is true. The destination region ID when replicating to another region. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        destination_retention: NotRequired[pulumi.Input[_builtins.int]]
        """
        Only vaild when DoCopy is true. The retention days of the destination backup. When not specified, the destination backup will be saved permanently. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        disk_id_lists: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The list of cloud disks to be backed up in the ECS instance. When not specified, a snapshot is executed for all the disks on the ECS instance.
        """
        do_copy: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether replicate to another region. Valid values: `true`, `false`.
        """
        enable_fs_freeze: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Only the Linux system is valid. Whether to use the Linux FsFreeze mechanism to ensure that the file system is read-only consistent before creating a storage snapshot. The default is True. Valid values: `true`, `false`.
        """
        post_script_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        Only vaild for the linux system when AppConsistent is true. The application thaw script path (e.g. /tmp/postscript.sh). The postscript.sh script must meet the following conditions: in terms of permissions, only the root user as the owner has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        """
        pre_script_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        Only vaild for the linux system when AppConsistent is true. Apply the freeze script path (e.g. /tmp/prescript.sh). prescript.sh scripts must meet the following conditions: in terms of permissions, only root, as the owner, has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        """
        timeout_in_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        Only the Linux system is valid, and the IO freeze timeout period. The default is 30 seconds.
        """
elif False:
    ServerBackupPlanDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerBackupPlanDetailArgs:
    def __init__(__self__, *,
                 app_consistent: pulumi.Input[_builtins.bool],
                 snapshot_group: pulumi.Input[_builtins.bool],
                 destination_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 do_copy: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_fs_freeze: Optional[pulumi.Input[_builtins.bool]] = None,
                 post_script_path: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_script_path: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.bool] app_consistent: Whether to turn on application consistency. The application consistency snapshot backs up memory data and ongoing database transactions at the time of snapshot creation to ensure the consistency of application system data and database transactions. By applying consistent snapshots, there is no data damage or loss, so as to avoid log rollback during database startup and ensure that the application is in a consistent startup state. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] snapshot_group: Whether to turn on file system consistency. If SnapshotGroup is true, when AppConsistent is true but the relevant conditions are not met or AppConsistent is false, the resulting snapshot will be a file system consistency snapshot. The file system consistency ensures that the file system memory and disk information are synchronized at the time of snapshot creation, and the file system write operation is frozen to make the file system in a consistent state. The file system consistency snapshot can prevent the operating system from performing disk inspection and repair operations such as CHKDSK or fsck after restart. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] destination_region_id: Only vaild when DoCopy is true. The destination region ID when replicating to another region. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param pulumi.Input[_builtins.int] destination_retention: Only vaild when DoCopy is true. The retention days of the destination backup. When not specified, the destination backup will be saved permanently. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disk_id_lists: The list of cloud disks to be backed up in the ECS instance. When not specified, a snapshot is executed for all the disks on the ECS instance.
        :param pulumi.Input[_builtins.bool] do_copy: Whether replicate to another region. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] enable_fs_freeze: Only the Linux system is valid. Whether to use the Linux FsFreeze mechanism to ensure that the file system is read-only consistent before creating a storage snapshot. The default is True. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] post_script_path: Only vaild for the linux system when AppConsistent is true. The application thaw script path (e.g. /tmp/postscript.sh). The postscript.sh script must meet the following conditions: in terms of permissions, only the root user as the owner has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        :param pulumi.Input[_builtins.str] pre_script_path: Only vaild for the linux system when AppConsistent is true. Apply the freeze script path (e.g. /tmp/prescript.sh). prescript.sh scripts must meet the following conditions: in terms of permissions, only root, as the owner, has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        :param pulumi.Input[_builtins.int] timeout_in_seconds: Only the Linux system is valid, and the IO freeze timeout period. The default is 30 seconds.
        """
        pulumi.set(__self__, "app_consistent", app_consistent)
        pulumi.set(__self__, "snapshot_group", snapshot_group)
        if destination_region_id is not None:
            pulumi.set(__self__, "destination_region_id", destination_region_id)
        if destination_retention is not None:
            pulumi.set(__self__, "destination_retention", destination_retention)
        if disk_id_lists is not None:
            pulumi.set(__self__, "disk_id_lists", disk_id_lists)
        if do_copy is not None:
            pulumi.set(__self__, "do_copy", do_copy)
        if enable_fs_freeze is not None:
            pulumi.set(__self__, "enable_fs_freeze", enable_fs_freeze)
        if post_script_path is not None:
            pulumi.set(__self__, "post_script_path", post_script_path)
        if pre_script_path is not None:
            pulumi.set(__self__, "pre_script_path", pre_script_path)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @_builtins.property
    @pulumi.getter(name="appConsistent")
    def app_consistent(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to turn on application consistency. The application consistency snapshot backs up memory data and ongoing database transactions at the time of snapshot creation to ensure the consistency of application system data and database transactions. By applying consistent snapshots, there is no data damage or loss, so as to avoid log rollback during database startup and ensure that the application is in a consistent startup state. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "app_consistent")

    @app_consistent.setter
    def app_consistent(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "app_consistent", value)

    @_builtins.property
    @pulumi.getter(name="snapshotGroup")
    def snapshot_group(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to turn on file system consistency. If SnapshotGroup is true, when AppConsistent is true but the relevant conditions are not met or AppConsistent is false, the resulting snapshot will be a file system consistency snapshot. The file system consistency ensures that the file system memory and disk information are synchronized at the time of snapshot creation, and the file system write operation is frozen to make the file system in a consistent state. The file system consistency snapshot can prevent the operating system from performing disk inspection and repair operations such as CHKDSK or fsck after restart. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "snapshot_group")

    @snapshot_group.setter
    def snapshot_group(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "snapshot_group", value)

    @_builtins.property
    @pulumi.getter(name="destinationRegionId")
    def destination_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Only vaild when DoCopy is true. The destination region ID when replicating to another region. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "destination_region_id")

    @destination_region_id.setter
    def destination_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_region_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationRetention")
    def destination_retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Only vaild when DoCopy is true. The retention days of the destination backup. When not specified, the destination backup will be saved permanently. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "destination_retention")

    @destination_retention.setter
    def destination_retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "destination_retention", value)

    @_builtins.property
    @pulumi.getter(name="diskIdLists")
    def disk_id_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of cloud disks to be backed up in the ECS instance. When not specified, a snapshot is executed for all the disks on the ECS instance.
        """
        return pulumi.get(self, "disk_id_lists")

    @disk_id_lists.setter
    def disk_id_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "disk_id_lists", value)

    @_builtins.property
    @pulumi.getter(name="doCopy")
    def do_copy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether replicate to another region. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "do_copy")

    @do_copy.setter
    def do_copy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "do_copy", value)

    @_builtins.property
    @pulumi.getter(name="enableFsFreeze")
    def enable_fs_freeze(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Only the Linux system is valid. Whether to use the Linux FsFreeze mechanism to ensure that the file system is read-only consistent before creating a storage snapshot. The default is True. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_fs_freeze")

    @enable_fs_freeze.setter
    def enable_fs_freeze(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_fs_freeze", value)

    @_builtins.property
    @pulumi.getter(name="postScriptPath")
    def post_script_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Only vaild for the linux system when AppConsistent is true. The application thaw script path (e.g. /tmp/postscript.sh). The postscript.sh script must meet the following conditions: in terms of permissions, only the root user as the owner has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        """
        return pulumi.get(self, "post_script_path")

    @post_script_path.setter
    def post_script_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "post_script_path", value)

    @_builtins.property
    @pulumi.getter(name="preScriptPath")
    def pre_script_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Only vaild for the linux system when AppConsistent is true. Apply the freeze script path (e.g. /tmp/prescript.sh). prescript.sh scripts must meet the following conditions: in terms of permissions, only root, as the owner, has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        """
        return pulumi.get(self, "pre_script_path")

    @pre_script_path.setter
    def pre_script_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pre_script_path", value)

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Only the Linux system is valid, and the IO freeze timeout period. The default is 30 seconds.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_in_seconds", value)


if not MYPY:
    class GetBackupJobsFilterArgsDict(TypedDict):
        key: NotRequired[_builtins.str]
        """
        The key of the field to filter. Valid values: `PlanId`, `VaultId`, `InstanceId`, `Bucket`, `FileSystemId`, `CompleteTime`.
        """
        operator: NotRequired[_builtins.str]
        """
        The operator of the field to filter. Valid values: `EQUAL`, `NOT_EQUAL`, `GREATER_THAN`, `GREATER_THAN_OR_EQUAL`, `LESS_THAN`, `LESS_THAN_OR_EQUAL`, `BETWEEN`, `IN`.
        """
        values: NotRequired[Sequence[_builtins.str]]
        """
        Set of values that are accepted for the given field.

        > **NOTE:** Numeric types such as `CompleteTime` do not support `IN` operations for the time being.
        """
elif False:
    GetBackupJobsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetBackupJobsFilterArgs:
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 operator: Optional[_builtins.str] = None,
                 values: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str key: The key of the field to filter. Valid values: `PlanId`, `VaultId`, `InstanceId`, `Bucket`, `FileSystemId`, `CompleteTime`.
        :param _builtins.str operator: The operator of the field to filter. Valid values: `EQUAL`, `NOT_EQUAL`, `GREATER_THAN`, `GREATER_THAN_OR_EQUAL`, `LESS_THAN`, `LESS_THAN_OR_EQUAL`, `BETWEEN`, `IN`.
        :param Sequence[_builtins.str] values: Set of values that are accepted for the given field.
               
               > **NOTE:** Numeric types such as `CompleteTime` do not support `IN` operations for the time being.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The key of the field to filter. Valid values: `PlanId`, `VaultId`, `InstanceId`, `Bucket`, `FileSystemId`, `CompleteTime`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[_builtins.str]:
        """
        The operator of the field to filter. Valid values: `EQUAL`, `NOT_EQUAL`, `GREATER_THAN`, `GREATER_THAN_OR_EQUAL`, `LESS_THAN`, `LESS_THAN_OR_EQUAL`, `BETWEEN`, `IN`.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[_builtins.str]):
        pulumi.set(self, "operator", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        """
        Set of values that are accepted for the given field.

        > **NOTE:** Numeric types such as `CompleteTime` do not support `IN` operations for the time being.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[Sequence[_builtins.str]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetServerBackupPlansFilterArgsDict(TypedDict):
        key: NotRequired[_builtins.str]
        """
        The key of the field to filter. Valid values: `planId`, `instanceId`, `planName`.
        """
        values: NotRequired[Sequence[_builtins.str]]
        """
        Set of values that are accepted for the given field.
        """
elif False:
    GetServerBackupPlansFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetServerBackupPlansFilterArgs:
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 values: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str key: The key of the field to filter. Valid values: `planId`, `instanceId`, `planName`.
        :param Sequence[_builtins.str] values: Set of values that are accepted for the given field.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The key of the field to filter. Valid values: `planId`, `instanceId`, `planName`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        """
        Set of values that are accepted for the given field.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[Sequence[_builtins.str]]):
        pulumi.set(self, "values", value)


