# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RestoreJobArgs', 'RestoreJob']

@pulumi.input_type
class RestoreJobArgs:
    def __init__(__self__, *,
                 restore_type: pulumi.Input[_builtins.str],
                 snapshot_hash: pulumi.Input[_builtins.str],
                 snapshot_id: pulumi.Input[_builtins.str],
                 source_type: pulumi.Input[_builtins.str],
                 vault_id: pulumi.Input[_builtins.str],
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 exclude: Optional[pulumi.Input[_builtins.str]] = None,
                 include: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 ots_detail: Optional[pulumi.Input['RestoreJobOtsDetailArgs']] = None,
                 restore_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 target_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 target_data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_path: Optional[pulumi.Input[_builtins.str]] = None,
                 target_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 target_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_time: Optional[pulumi.Input[_builtins.str]] = None,
                 udm_detail: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RestoreJob resource.
        :param pulumi.Input[_builtins.str] restore_type: The type of recovery destination. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS_ROLLBACK`. **Note**: Currently, there is a one-to-one correspondence between the data source type with the recovery destination type.
        :param pulumi.Input[_builtins.str] snapshot_hash: The hashcode of Snapshot.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of Snapshot.
        :param pulumi.Input[_builtins.str] source_type: The type of data source. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS`.
        :param pulumi.Input[_builtins.str] vault_id: The ID of backup vault.
        :param pulumi.Input[_builtins.str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
        :param pulumi.Input[_builtins.str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[_builtins.int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[_builtins.str] exclude: The exclude path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/excludePath]`, up to 255 characters. **WARNING:** If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        :param pulumi.Input[_builtins.str] include: The include path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/includePath"]`, Up to 255 characters. **WARNING:** The field is required while source_type equals `OTS_TABLE` which means source table name. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        :param pulumi.Input[_builtins.str] options: Recovery options. **NOTE:** Required while source_type equals `OSS` or `NAS`, invalid while source_type equals `ECS_FILE`. It's a json string with format:`"{"includes":[],"excludes":[]}",`. Recovery options. When restores OTS_TABLE and real target time is the rangEnd time of the snapshot, it should be a string with format: `{"UI_TargetTime":1650032529018}`.
        :param pulumi.Input['RestoreJobOtsDetailArgs'] ots_detail: The details about the Tablestore instance. See the following `Block ots_detail`.
        :param pulumi.Input[_builtins.str] restore_job_id: Restore Job ID. It's the unique key of this resource, if you want to set this argument by yourself, you must specify a unique keyword that never appears.
        :param pulumi.Input[_builtins.str] target_bucket: The target name of OSS bucket. **NOTE:** Required while source_type equals `OSS`,
        :param pulumi.Input[_builtins.str] target_client_id: The target client ID.
        :param pulumi.Input[_builtins.str] target_create_time: The creation time of destination File System. **NOTE:** While source_type equals `NAS`, this parameter must be set. **Note:** The time format of the API adopts the ISO 8601 format, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
        :param pulumi.Input[_builtins.str] target_data_source_id: The target data source ID.
        :param pulumi.Input[_builtins.str] target_file_system_id: The ID of destination File System. **NOTE:** Required while source_type equals `NAS`
        :param pulumi.Input[_builtins.str] target_instance_id: The target ID of ECS instance. **NOTE:** Required while source_type equals `ECS_FILE`
        :param pulumi.Input[_builtins.str] target_instance_name: The name of the Table store instance to which you want to restore data.**WARNING:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[_builtins.str] target_path: The target file path of (ECS) instance. **WARNING:** Required while source_type equals `NAS` or `ECS_FILE`, If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        :param pulumi.Input[_builtins.str] target_prefix: The target prefix of the OSS object. **WARNING:** Required while source_type equals `OSS`. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        :param pulumi.Input[_builtins.str] target_table_name: The name of the table that stores the restored data. **WARNING:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[_builtins.str] target_time: The time when data is restored to the Table store instance. This value is a UNIX timestamp. Unit: seconds. **WARNING:** Required while source_type equals `OTS_TABLE`. **Note:** The time when data is restored to the Tablestore instance. It should be 0 if restores data at the End time of the snapshot.
        :param pulumi.Input[_builtins.str] udm_detail: The full machine backup details.
        """
        pulumi.set(__self__, "restore_type", restore_type)
        pulumi.set(__self__, "snapshot_hash", snapshot_hash)
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "vault_id", vault_id)
        if cross_account_role_name is not None:
            pulumi.set(__self__, "cross_account_role_name", cross_account_role_name)
        if cross_account_type is not None:
            pulumi.set(__self__, "cross_account_type", cross_account_type)
        if cross_account_user_id is not None:
            pulumi.set(__self__, "cross_account_user_id", cross_account_user_id)
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if ots_detail is not None:
            pulumi.set(__self__, "ots_detail", ots_detail)
        if restore_job_id is not None:
            pulumi.set(__self__, "restore_job_id", restore_job_id)
        if target_bucket is not None:
            pulumi.set(__self__, "target_bucket", target_bucket)
        if target_client_id is not None:
            pulumi.set(__self__, "target_client_id", target_client_id)
        if target_create_time is not None:
            pulumi.set(__self__, "target_create_time", target_create_time)
        if target_data_source_id is not None:
            pulumi.set(__self__, "target_data_source_id", target_data_source_id)
        if target_file_system_id is not None:
            pulumi.set(__self__, "target_file_system_id", target_file_system_id)
        if target_instance_id is not None:
            pulumi.set(__self__, "target_instance_id", target_instance_id)
        if target_instance_name is not None:
            pulumi.set(__self__, "target_instance_name", target_instance_name)
        if target_path is not None:
            pulumi.set(__self__, "target_path", target_path)
        if target_prefix is not None:
            pulumi.set(__self__, "target_prefix", target_prefix)
        if target_table_name is not None:
            pulumi.set(__self__, "target_table_name", target_table_name)
        if target_time is not None:
            pulumi.set(__self__, "target_time", target_time)
        if udm_detail is not None:
            pulumi.set(__self__, "udm_detail", udm_detail)

    @_builtins.property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of recovery destination. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS_ROLLBACK`. **Note**: Currently, there is a one-to-one correspondence between the data source type with the recovery destination type.
        """
        return pulumi.get(self, "restore_type")

    @restore_type.setter
    def restore_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "restore_type", value)

    @_builtins.property
    @pulumi.getter(name="snapshotHash")
    def snapshot_hash(self) -> pulumi.Input[_builtins.str]:
        """
        The hashcode of Snapshot.
        """
        return pulumi.get(self, "snapshot_hash")

    @snapshot_hash.setter
    def snapshot_hash(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "snapshot_hash", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of Snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of data source. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS`.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_id", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role name created in the original account RAM backup by the cross account managed by the current account.
        """
        return pulumi.get(self, "cross_account_role_name")

    @cross_account_role_name.setter
    def cross_account_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_role_name", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        """
        return pulumi.get(self, "cross_account_type")

    @cross_account_type.setter
    def cross_account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_type", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The original account ID of the cross account backup managed by the current account.
        """
        return pulumi.get(self, "cross_account_user_id")

    @cross_account_user_id.setter
    def cross_account_user_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cross_account_user_id", value)

    @_builtins.property
    @pulumi.getter
    def exclude(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The exclude path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/excludePath]`, up to 255 characters. **WARNING:** If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        """
        return pulumi.get(self, "exclude")

    @exclude.setter
    def exclude(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclude", value)

    @_builtins.property
    @pulumi.getter
    def include(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The include path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/includePath"]`, Up to 255 characters. **WARNING:** The field is required while source_type equals `OTS_TABLE` which means source table name. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        """
        return pulumi.get(self, "include")

    @include.setter
    def include(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Recovery options. **NOTE:** Required while source_type equals `OSS` or `NAS`, invalid while source_type equals `ECS_FILE`. It's a json string with format:`"{"includes":[],"excludes":[]}",`. Recovery options. When restores OTS_TABLE and real target time is the rangEnd time of the snapshot, it should be a string with format: `{"UI_TargetTime":1650032529018}`.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="otsDetail")
    def ots_detail(self) -> Optional[pulumi.Input['RestoreJobOtsDetailArgs']]:
        """
        The details about the Tablestore instance. See the following `Block ots_detail`.
        """
        return pulumi.get(self, "ots_detail")

    @ots_detail.setter
    def ots_detail(self, value: Optional[pulumi.Input['RestoreJobOtsDetailArgs']]):
        pulumi.set(self, "ots_detail", value)

    @_builtins.property
    @pulumi.getter(name="restoreJobId")
    def restore_job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Restore Job ID. It's the unique key of this resource, if you want to set this argument by yourself, you must specify a unique keyword that never appears.
        """
        return pulumi.get(self, "restore_job_id")

    @restore_job_id.setter
    def restore_job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_job_id", value)

    @_builtins.property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target name of OSS bucket. **NOTE:** Required while source_type equals `OSS`,
        """
        return pulumi.get(self, "target_bucket")

    @target_bucket.setter
    def target_bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_bucket", value)

    @_builtins.property
    @pulumi.getter(name="targetClientId")
    def target_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target client ID.
        """
        return pulumi.get(self, "target_client_id")

    @target_client_id.setter
    def target_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_client_id", value)

    @_builtins.property
    @pulumi.getter(name="targetCreateTime")
    def target_create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of destination File System. **NOTE:** While source_type equals `NAS`, this parameter must be set. **Note:** The time format of the API adopts the ISO 8601 format, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
        """
        return pulumi.get(self, "target_create_time")

    @target_create_time.setter
    def target_create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_create_time", value)

    @_builtins.property
    @pulumi.getter(name="targetDataSourceId")
    def target_data_source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target data source ID.
        """
        return pulumi.get(self, "target_data_source_id")

    @target_data_source_id.setter
    def target_data_source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_data_source_id", value)

    @_builtins.property
    @pulumi.getter(name="targetFileSystemId")
    def target_file_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of destination File System. **NOTE:** Required while source_type equals `NAS`
        """
        return pulumi.get(self, "target_file_system_id")

    @target_file_system_id.setter
    def target_file_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="targetInstanceId")
    def target_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target ID of ECS instance. **NOTE:** Required while source_type equals `ECS_FILE`
        """
        return pulumi.get(self, "target_instance_id")

    @target_instance_id.setter
    def target_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="targetInstanceName")
    def target_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Table store instance to which you want to restore data.**WARNING:** Required while source_type equals `OTS_TABLE`.
        """
        return pulumi.get(self, "target_instance_name")

    @target_instance_name.setter
    def target_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="targetPath")
    def target_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target file path of (ECS) instance. **WARNING:** Required while source_type equals `NAS` or `ECS_FILE`, If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        """
        return pulumi.get(self, "target_path")

    @target_path.setter
    def target_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_path", value)

    @_builtins.property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target prefix of the OSS object. **WARNING:** Required while source_type equals `OSS`. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        """
        return pulumi.get(self, "target_prefix")

    @target_prefix.setter
    def target_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_prefix", value)

    @_builtins.property
    @pulumi.getter(name="targetTableName")
    def target_table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the table that stores the restored data. **WARNING:** Required while source_type equals `OTS_TABLE`.
        """
        return pulumi.get(self, "target_table_name")

    @target_table_name.setter
    def target_table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_table_name", value)

    @_builtins.property
    @pulumi.getter(name="targetTime")
    def target_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when data is restored to the Table store instance. This value is a UNIX timestamp. Unit: seconds. **WARNING:** Required while source_type equals `OTS_TABLE`. **Note:** The time when data is restored to the Tablestore instance. It should be 0 if restores data at the End time of the snapshot.
        """
        return pulumi.get(self, "target_time")

    @target_time.setter
    def target_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_time", value)

    @_builtins.property
    @pulumi.getter(name="udmDetail")
    def udm_detail(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full machine backup details.
        """
        return pulumi.get(self, "udm_detail")

    @udm_detail.setter
    def udm_detail(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "udm_detail", value)


@pulumi.input_type
class _RestoreJobState:
    def __init__(__self__, *,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 exclude: Optional[pulumi.Input[_builtins.str]] = None,
                 include: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 ots_detail: Optional[pulumi.Input['RestoreJobOtsDetailArgs']] = None,
                 restore_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_type: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 target_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 target_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 target_data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_path: Optional[pulumi.Input[_builtins.str]] = None,
                 target_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 target_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_time: Optional[pulumi.Input[_builtins.str]] = None,
                 udm_detail: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RestoreJob resources.
        :param pulumi.Input[_builtins.str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
        :param pulumi.Input[_builtins.str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[_builtins.int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[_builtins.str] exclude: The exclude path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/excludePath]`, up to 255 characters. **WARNING:** If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        :param pulumi.Input[_builtins.str] include: The include path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/includePath"]`, Up to 255 characters. **WARNING:** The field is required while source_type equals `OTS_TABLE` which means source table name. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        :param pulumi.Input[_builtins.str] options: Recovery options. **NOTE:** Required while source_type equals `OSS` or `NAS`, invalid while source_type equals `ECS_FILE`. It's a json string with format:`"{"includes":[],"excludes":[]}",`. Recovery options. When restores OTS_TABLE and real target time is the rangEnd time of the snapshot, it should be a string with format: `{"UI_TargetTime":1650032529018}`.
        :param pulumi.Input['RestoreJobOtsDetailArgs'] ots_detail: The details about the Tablestore instance. See the following `Block ots_detail`.
        :param pulumi.Input[_builtins.str] restore_job_id: Restore Job ID. It's the unique key of this resource, if you want to set this argument by yourself, you must specify a unique keyword that never appears.
        :param pulumi.Input[_builtins.str] restore_type: The type of recovery destination. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS_ROLLBACK`. **Note**: Currently, there is a one-to-one correspondence between the data source type with the recovery destination type.
        :param pulumi.Input[_builtins.str] snapshot_hash: The hashcode of Snapshot.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of Snapshot.
        :param pulumi.Input[_builtins.str] source_type: The type of data source. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS`.
        :param pulumi.Input[_builtins.str] status: The Restore Job Status.
        :param pulumi.Input[_builtins.str] target_bucket: The target name of OSS bucket. **NOTE:** Required while source_type equals `OSS`,
        :param pulumi.Input[_builtins.str] target_client_id: The target client ID.
        :param pulumi.Input[_builtins.str] target_create_time: The creation time of destination File System. **NOTE:** While source_type equals `NAS`, this parameter must be set. **Note:** The time format of the API adopts the ISO 8601 format, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
        :param pulumi.Input[_builtins.str] target_data_source_id: The target data source ID.
        :param pulumi.Input[_builtins.str] target_file_system_id: The ID of destination File System. **NOTE:** Required while source_type equals `NAS`
        :param pulumi.Input[_builtins.str] target_instance_id: The target ID of ECS instance. **NOTE:** Required while source_type equals `ECS_FILE`
        :param pulumi.Input[_builtins.str] target_instance_name: The name of the Table store instance to which you want to restore data.**WARNING:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[_builtins.str] target_path: The target file path of (ECS) instance. **WARNING:** Required while source_type equals `NAS` or `ECS_FILE`, If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        :param pulumi.Input[_builtins.str] target_prefix: The target prefix of the OSS object. **WARNING:** Required while source_type equals `OSS`. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        :param pulumi.Input[_builtins.str] target_table_name: The name of the table that stores the restored data. **WARNING:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[_builtins.str] target_time: The time when data is restored to the Table store instance. This value is a UNIX timestamp. Unit: seconds. **WARNING:** Required while source_type equals `OTS_TABLE`. **Note:** The time when data is restored to the Tablestore instance. It should be 0 if restores data at the End time of the snapshot.
        :param pulumi.Input[_builtins.str] udm_detail: The full machine backup details.
        :param pulumi.Input[_builtins.str] vault_id: The ID of backup vault.
        """
        if cross_account_role_name is not None:
            pulumi.set(__self__, "cross_account_role_name", cross_account_role_name)
        if cross_account_type is not None:
            pulumi.set(__self__, "cross_account_type", cross_account_type)
        if cross_account_user_id is not None:
            pulumi.set(__self__, "cross_account_user_id", cross_account_user_id)
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if ots_detail is not None:
            pulumi.set(__self__, "ots_detail", ots_detail)
        if restore_job_id is not None:
            pulumi.set(__self__, "restore_job_id", restore_job_id)
        if restore_type is not None:
            pulumi.set(__self__, "restore_type", restore_type)
        if snapshot_hash is not None:
            pulumi.set(__self__, "snapshot_hash", snapshot_hash)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_bucket is not None:
            pulumi.set(__self__, "target_bucket", target_bucket)
        if target_client_id is not None:
            pulumi.set(__self__, "target_client_id", target_client_id)
        if target_create_time is not None:
            pulumi.set(__self__, "target_create_time", target_create_time)
        if target_data_source_id is not None:
            pulumi.set(__self__, "target_data_source_id", target_data_source_id)
        if target_file_system_id is not None:
            pulumi.set(__self__, "target_file_system_id", target_file_system_id)
        if target_instance_id is not None:
            pulumi.set(__self__, "target_instance_id", target_instance_id)
        if target_instance_name is not None:
            pulumi.set(__self__, "target_instance_name", target_instance_name)
        if target_path is not None:
            pulumi.set(__self__, "target_path", target_path)
        if target_prefix is not None:
            pulumi.set(__self__, "target_prefix", target_prefix)
        if target_table_name is not None:
            pulumi.set(__self__, "target_table_name", target_table_name)
        if target_time is not None:
            pulumi.set(__self__, "target_time", target_time)
        if udm_detail is not None:
            pulumi.set(__self__, "udm_detail", udm_detail)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role name created in the original account RAM backup by the cross account managed by the current account.
        """
        return pulumi.get(self, "cross_account_role_name")

    @cross_account_role_name.setter
    def cross_account_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_role_name", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        """
        return pulumi.get(self, "cross_account_type")

    @cross_account_type.setter
    def cross_account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_type", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The original account ID of the cross account backup managed by the current account.
        """
        return pulumi.get(self, "cross_account_user_id")

    @cross_account_user_id.setter
    def cross_account_user_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cross_account_user_id", value)

    @_builtins.property
    @pulumi.getter
    def exclude(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The exclude path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/excludePath]`, up to 255 characters. **WARNING:** If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        """
        return pulumi.get(self, "exclude")

    @exclude.setter
    def exclude(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclude", value)

    @_builtins.property
    @pulumi.getter
    def include(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The include path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/includePath"]`, Up to 255 characters. **WARNING:** The field is required while source_type equals `OTS_TABLE` which means source table name. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        """
        return pulumi.get(self, "include")

    @include.setter
    def include(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Recovery options. **NOTE:** Required while source_type equals `OSS` or `NAS`, invalid while source_type equals `ECS_FILE`. It's a json string with format:`"{"includes":[],"excludes":[]}",`. Recovery options. When restores OTS_TABLE and real target time is the rangEnd time of the snapshot, it should be a string with format: `{"UI_TargetTime":1650032529018}`.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="otsDetail")
    def ots_detail(self) -> Optional[pulumi.Input['RestoreJobOtsDetailArgs']]:
        """
        The details about the Tablestore instance. See the following `Block ots_detail`.
        """
        return pulumi.get(self, "ots_detail")

    @ots_detail.setter
    def ots_detail(self, value: Optional[pulumi.Input['RestoreJobOtsDetailArgs']]):
        pulumi.set(self, "ots_detail", value)

    @_builtins.property
    @pulumi.getter(name="restoreJobId")
    def restore_job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Restore Job ID. It's the unique key of this resource, if you want to set this argument by yourself, you must specify a unique keyword that never appears.
        """
        return pulumi.get(self, "restore_job_id")

    @restore_job_id.setter
    def restore_job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_job_id", value)

    @_builtins.property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of recovery destination. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS_ROLLBACK`. **Note**: Currently, there is a one-to-one correspondence between the data source type with the recovery destination type.
        """
        return pulumi.get(self, "restore_type")

    @restore_type.setter
    def restore_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_type", value)

    @_builtins.property
    @pulumi.getter(name="snapshotHash")
    def snapshot_hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hashcode of Snapshot.
        """
        return pulumi.get(self, "snapshot_hash")

    @snapshot_hash.setter
    def snapshot_hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_hash", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of Snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of data source. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS`.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Restore Job Status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target name of OSS bucket. **NOTE:** Required while source_type equals `OSS`,
        """
        return pulumi.get(self, "target_bucket")

    @target_bucket.setter
    def target_bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_bucket", value)

    @_builtins.property
    @pulumi.getter(name="targetClientId")
    def target_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target client ID.
        """
        return pulumi.get(self, "target_client_id")

    @target_client_id.setter
    def target_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_client_id", value)

    @_builtins.property
    @pulumi.getter(name="targetCreateTime")
    def target_create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of destination File System. **NOTE:** While source_type equals `NAS`, this parameter must be set. **Note:** The time format of the API adopts the ISO 8601 format, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
        """
        return pulumi.get(self, "target_create_time")

    @target_create_time.setter
    def target_create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_create_time", value)

    @_builtins.property
    @pulumi.getter(name="targetDataSourceId")
    def target_data_source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target data source ID.
        """
        return pulumi.get(self, "target_data_source_id")

    @target_data_source_id.setter
    def target_data_source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_data_source_id", value)

    @_builtins.property
    @pulumi.getter(name="targetFileSystemId")
    def target_file_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of destination File System. **NOTE:** Required while source_type equals `NAS`
        """
        return pulumi.get(self, "target_file_system_id")

    @target_file_system_id.setter
    def target_file_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="targetInstanceId")
    def target_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target ID of ECS instance. **NOTE:** Required while source_type equals `ECS_FILE`
        """
        return pulumi.get(self, "target_instance_id")

    @target_instance_id.setter
    def target_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="targetInstanceName")
    def target_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Table store instance to which you want to restore data.**WARNING:** Required while source_type equals `OTS_TABLE`.
        """
        return pulumi.get(self, "target_instance_name")

    @target_instance_name.setter
    def target_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="targetPath")
    def target_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target file path of (ECS) instance. **WARNING:** Required while source_type equals `NAS` or `ECS_FILE`, If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        """
        return pulumi.get(self, "target_path")

    @target_path.setter
    def target_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_path", value)

    @_builtins.property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target prefix of the OSS object. **WARNING:** Required while source_type equals `OSS`. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        """
        return pulumi.get(self, "target_prefix")

    @target_prefix.setter
    def target_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_prefix", value)

    @_builtins.property
    @pulumi.getter(name="targetTableName")
    def target_table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the table that stores the restored data. **WARNING:** Required while source_type equals `OTS_TABLE`.
        """
        return pulumi.get(self, "target_table_name")

    @target_table_name.setter
    def target_table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_table_name", value)

    @_builtins.property
    @pulumi.getter(name="targetTime")
    def target_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when data is restored to the Table store instance. This value is a UNIX timestamp. Unit: seconds. **WARNING:** Required while source_type equals `OTS_TABLE`. **Note:** The time when data is restored to the Tablestore instance. It should be 0 if restores data at the End time of the snapshot.
        """
        return pulumi.get(self, "target_time")

    @target_time.setter
    def target_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_time", value)

    @_builtins.property
    @pulumi.getter(name="udmDetail")
    def udm_detail(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full machine backup details.
        """
        return pulumi.get(self, "udm_detail")

    @udm_detail.setter
    def udm_detail(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "udm_detail", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.type_token("alicloud:hbr/restoreJob:RestoreJob")
class RestoreJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 exclude: Optional[pulumi.Input[_builtins.str]] = None,
                 include: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 ots_detail: Optional[pulumi.Input[Union['RestoreJobOtsDetailArgs', 'RestoreJobOtsDetailArgsDict']]] = None,
                 restore_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_type: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 target_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 target_data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_path: Optional[pulumi.Input[_builtins.str]] = None,
                 target_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 target_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_time: Optional[pulumi.Input[_builtins.str]] = None,
                 udm_detail: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Hybrid Backup Recovery (HBR) Restore Job resource.

        For information about Hybrid Backup Recovery (HBR) Restore Job and how to use it, see [What is Restore Job](https://www.alibabacloud.com/help/doc-detail/186575.htm).

        > **NOTE:** Available since v1.133.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.hbr.get_ecs_backup_plans(name_regex="plan-tf-used-dont-delete")
        default_get_oss_backup_plans = alicloud.hbr.get_oss_backup_plans(name_regex="plan-tf-used-dont-delete")
        default_get_nas_backup_plans = alicloud.hbr.get_nas_backup_plans(name_regex="plan-tf-used-dont-delete")
        ecs_snapshots = alicloud.hbr.get_snapshots(source_type="ECS_FILE",
            vault_id=default.plans[0].vault_id,
            instance_id=default.plans[0].instance_id)
        oss_snapshots = alicloud.hbr.get_snapshots(source_type="OSS",
            vault_id=default_get_oss_backup_plans.plans[0].vault_id,
            bucket=default_get_oss_backup_plans.plans[0].bucket)
        nas_snapshots = alicloud.hbr.get_snapshots(source_type="NAS",
            vault_id=default_get_nas_backup_plans.plans[0].vault_id,
            file_system_id=default_get_nas_backup_plans.plans[0].file_system_id,
            create_time=default_get_nas_backup_plans.plans[0].create_time)
        nas_job = alicloud.hbr.RestoreJob("nasJob",
            snapshot_hash=nas_snapshots.snapshots[0].snapshot_hash,
            vault_id=default_get_nas_backup_plans.plans[0].vault_id,
            source_type="NAS",
            restore_type="NAS",
            snapshot_id=nas_snapshots.snapshots[0].snapshot_id,
            target_file_system_id=default_get_nas_backup_plans.plans[0].file_system_id,
            target_create_time=default_get_nas_backup_plans.plans[0].create_time,
            target_path="/",
            options="    {\\"includes\\":[], \\"excludes\\":[]}\\n")
        oss_job = alicloud.hbr.RestoreJob("ossJob",
            snapshot_hash=oss_snapshots.snapshots[0].snapshot_hash,
            vault_id=default_get_oss_backup_plans.plans[0].vault_id,
            source_type="OSS",
            restore_type="OSS",
            snapshot_id=oss_snapshots.snapshots[0].snapshot_id,
            target_bucket=default_get_oss_backup_plans.plans[0].bucket,
            target_prefix="",
            options="    {\\"includes\\":[], \\"excludes\\":[]}\\n")
        ecs_job = alicloud.hbr.RestoreJob("ecsJob",
            snapshot_hash=ecs_snapshots.snapshots[0].snapshot_hash,
            vault_id=default.plans[0].vault_id,
            source_type="ECS_FILE",
            restore_type="ECS_FILE",
            snapshot_id=ecs_snapshots.snapshots[0].snapshot_id,
            target_instance_id=default.plans[0].instance_id,
            target_path="/")
        ```

        > **NOTE:** This resource can only be created, cannot be modified or deleted. Therefore, any modification of the resource attribute will not affect exist resource.

        ## Import

        Hybrid Backup Recovery (HBR) Restore Job can be imported using the id. Format to `<restore_job_id>:<restore_type>`, e.g.

        ```sh
        $ pulumi import alicloud:hbr/restoreJob:RestoreJob example your_restore_job_id:your_restore_type
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
        :param pulumi.Input[_builtins.str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[_builtins.int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[_builtins.str] exclude: The exclude path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/excludePath]`, up to 255 characters. **WARNING:** If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        :param pulumi.Input[_builtins.str] include: The include path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/includePath"]`, Up to 255 characters. **WARNING:** The field is required while source_type equals `OTS_TABLE` which means source table name. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        :param pulumi.Input[_builtins.str] options: Recovery options. **NOTE:** Required while source_type equals `OSS` or `NAS`, invalid while source_type equals `ECS_FILE`. It's a json string with format:`"{"includes":[],"excludes":[]}",`. Recovery options. When restores OTS_TABLE and real target time is the rangEnd time of the snapshot, it should be a string with format: `{"UI_TargetTime":1650032529018}`.
        :param pulumi.Input[Union['RestoreJobOtsDetailArgs', 'RestoreJobOtsDetailArgsDict']] ots_detail: The details about the Tablestore instance. See the following `Block ots_detail`.
        :param pulumi.Input[_builtins.str] restore_job_id: Restore Job ID. It's the unique key of this resource, if you want to set this argument by yourself, you must specify a unique keyword that never appears.
        :param pulumi.Input[_builtins.str] restore_type: The type of recovery destination. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS_ROLLBACK`. **Note**: Currently, there is a one-to-one correspondence between the data source type with the recovery destination type.
        :param pulumi.Input[_builtins.str] snapshot_hash: The hashcode of Snapshot.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of Snapshot.
        :param pulumi.Input[_builtins.str] source_type: The type of data source. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS`.
        :param pulumi.Input[_builtins.str] target_bucket: The target name of OSS bucket. **NOTE:** Required while source_type equals `OSS`,
        :param pulumi.Input[_builtins.str] target_client_id: The target client ID.
        :param pulumi.Input[_builtins.str] target_create_time: The creation time of destination File System. **NOTE:** While source_type equals `NAS`, this parameter must be set. **Note:** The time format of the API adopts the ISO 8601 format, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
        :param pulumi.Input[_builtins.str] target_data_source_id: The target data source ID.
        :param pulumi.Input[_builtins.str] target_file_system_id: The ID of destination File System. **NOTE:** Required while source_type equals `NAS`
        :param pulumi.Input[_builtins.str] target_instance_id: The target ID of ECS instance. **NOTE:** Required while source_type equals `ECS_FILE`
        :param pulumi.Input[_builtins.str] target_instance_name: The name of the Table store instance to which you want to restore data.**WARNING:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[_builtins.str] target_path: The target file path of (ECS) instance. **WARNING:** Required while source_type equals `NAS` or `ECS_FILE`, If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        :param pulumi.Input[_builtins.str] target_prefix: The target prefix of the OSS object. **WARNING:** Required while source_type equals `OSS`. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        :param pulumi.Input[_builtins.str] target_table_name: The name of the table that stores the restored data. **WARNING:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[_builtins.str] target_time: The time when data is restored to the Table store instance. This value is a UNIX timestamp. Unit: seconds. **WARNING:** Required while source_type equals `OTS_TABLE`. **Note:** The time when data is restored to the Tablestore instance. It should be 0 if restores data at the End time of the snapshot.
        :param pulumi.Input[_builtins.str] udm_detail: The full machine backup details.
        :param pulumi.Input[_builtins.str] vault_id: The ID of backup vault.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RestoreJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Hybrid Backup Recovery (HBR) Restore Job resource.

        For information about Hybrid Backup Recovery (HBR) Restore Job and how to use it, see [What is Restore Job](https://www.alibabacloud.com/help/doc-detail/186575.htm).

        > **NOTE:** Available since v1.133.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.hbr.get_ecs_backup_plans(name_regex="plan-tf-used-dont-delete")
        default_get_oss_backup_plans = alicloud.hbr.get_oss_backup_plans(name_regex="plan-tf-used-dont-delete")
        default_get_nas_backup_plans = alicloud.hbr.get_nas_backup_plans(name_regex="plan-tf-used-dont-delete")
        ecs_snapshots = alicloud.hbr.get_snapshots(source_type="ECS_FILE",
            vault_id=default.plans[0].vault_id,
            instance_id=default.plans[0].instance_id)
        oss_snapshots = alicloud.hbr.get_snapshots(source_type="OSS",
            vault_id=default_get_oss_backup_plans.plans[0].vault_id,
            bucket=default_get_oss_backup_plans.plans[0].bucket)
        nas_snapshots = alicloud.hbr.get_snapshots(source_type="NAS",
            vault_id=default_get_nas_backup_plans.plans[0].vault_id,
            file_system_id=default_get_nas_backup_plans.plans[0].file_system_id,
            create_time=default_get_nas_backup_plans.plans[0].create_time)
        nas_job = alicloud.hbr.RestoreJob("nasJob",
            snapshot_hash=nas_snapshots.snapshots[0].snapshot_hash,
            vault_id=default_get_nas_backup_plans.plans[0].vault_id,
            source_type="NAS",
            restore_type="NAS",
            snapshot_id=nas_snapshots.snapshots[0].snapshot_id,
            target_file_system_id=default_get_nas_backup_plans.plans[0].file_system_id,
            target_create_time=default_get_nas_backup_plans.plans[0].create_time,
            target_path="/",
            options="    {\\"includes\\":[], \\"excludes\\":[]}\\n")
        oss_job = alicloud.hbr.RestoreJob("ossJob",
            snapshot_hash=oss_snapshots.snapshots[0].snapshot_hash,
            vault_id=default_get_oss_backup_plans.plans[0].vault_id,
            source_type="OSS",
            restore_type="OSS",
            snapshot_id=oss_snapshots.snapshots[0].snapshot_id,
            target_bucket=default_get_oss_backup_plans.plans[0].bucket,
            target_prefix="",
            options="    {\\"includes\\":[], \\"excludes\\":[]}\\n")
        ecs_job = alicloud.hbr.RestoreJob("ecsJob",
            snapshot_hash=ecs_snapshots.snapshots[0].snapshot_hash,
            vault_id=default.plans[0].vault_id,
            source_type="ECS_FILE",
            restore_type="ECS_FILE",
            snapshot_id=ecs_snapshots.snapshots[0].snapshot_id,
            target_instance_id=default.plans[0].instance_id,
            target_path="/")
        ```

        > **NOTE:** This resource can only be created, cannot be modified or deleted. Therefore, any modification of the resource attribute will not affect exist resource.

        ## Import

        Hybrid Backup Recovery (HBR) Restore Job can be imported using the id. Format to `<restore_job_id>:<restore_type>`, e.g.

        ```sh
        $ pulumi import alicloud:hbr/restoreJob:RestoreJob example your_restore_job_id:your_restore_type
        ```

        :param str resource_name: The name of the resource.
        :param RestoreJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RestoreJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 exclude: Optional[pulumi.Input[_builtins.str]] = None,
                 include: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 ots_detail: Optional[pulumi.Input[Union['RestoreJobOtsDetailArgs', 'RestoreJobOtsDetailArgsDict']]] = None,
                 restore_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_type: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 target_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 target_data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_path: Optional[pulumi.Input[_builtins.str]] = None,
                 target_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 target_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_time: Optional[pulumi.Input[_builtins.str]] = None,
                 udm_detail: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RestoreJobArgs.__new__(RestoreJobArgs)

            __props__.__dict__["cross_account_role_name"] = cross_account_role_name
            __props__.__dict__["cross_account_type"] = cross_account_type
            __props__.__dict__["cross_account_user_id"] = cross_account_user_id
            __props__.__dict__["exclude"] = exclude
            __props__.__dict__["include"] = include
            __props__.__dict__["options"] = options
            __props__.__dict__["ots_detail"] = ots_detail
            __props__.__dict__["restore_job_id"] = restore_job_id
            if restore_type is None and not opts.urn:
                raise TypeError("Missing required property 'restore_type'")
            __props__.__dict__["restore_type"] = restore_type
            if snapshot_hash is None and not opts.urn:
                raise TypeError("Missing required property 'snapshot_hash'")
            __props__.__dict__["snapshot_hash"] = snapshot_hash
            if snapshot_id is None and not opts.urn:
                raise TypeError("Missing required property 'snapshot_id'")
            __props__.__dict__["snapshot_id"] = snapshot_id
            if source_type is None and not opts.urn:
                raise TypeError("Missing required property 'source_type'")
            __props__.__dict__["source_type"] = source_type
            __props__.__dict__["target_bucket"] = target_bucket
            __props__.__dict__["target_client_id"] = target_client_id
            __props__.__dict__["target_create_time"] = target_create_time
            __props__.__dict__["target_data_source_id"] = target_data_source_id
            __props__.__dict__["target_file_system_id"] = target_file_system_id
            __props__.__dict__["target_instance_id"] = target_instance_id
            __props__.__dict__["target_instance_name"] = target_instance_name
            __props__.__dict__["target_path"] = target_path
            __props__.__dict__["target_prefix"] = target_prefix
            __props__.__dict__["target_table_name"] = target_table_name
            __props__.__dict__["target_time"] = target_time
            __props__.__dict__["udm_detail"] = udm_detail
            if vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'vault_id'")
            __props__.__dict__["vault_id"] = vault_id
            __props__.__dict__["status"] = None
        super(RestoreJob, __self__).__init__(
            'alicloud:hbr/restoreJob:RestoreJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
            cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
            exclude: Optional[pulumi.Input[_builtins.str]] = None,
            include: Optional[pulumi.Input[_builtins.str]] = None,
            options: Optional[pulumi.Input[_builtins.str]] = None,
            ots_detail: Optional[pulumi.Input[Union['RestoreJobOtsDetailArgs', 'RestoreJobOtsDetailArgsDict']]] = None,
            restore_job_id: Optional[pulumi.Input[_builtins.str]] = None,
            restore_type: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_hash: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_type: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            target_bucket: Optional[pulumi.Input[_builtins.str]] = None,
            target_client_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_create_time: Optional[pulumi.Input[_builtins.str]] = None,
            target_data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            target_path: Optional[pulumi.Input[_builtins.str]] = None,
            target_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            target_table_name: Optional[pulumi.Input[_builtins.str]] = None,
            target_time: Optional[pulumi.Input[_builtins.str]] = None,
            udm_detail: Optional[pulumi.Input[_builtins.str]] = None,
            vault_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RestoreJob':
        """
        Get an existing RestoreJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
        :param pulumi.Input[_builtins.str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[_builtins.int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[_builtins.str] exclude: The exclude path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/excludePath]`, up to 255 characters. **WARNING:** If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        :param pulumi.Input[_builtins.str] include: The include path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/includePath"]`, Up to 255 characters. **WARNING:** The field is required while source_type equals `OTS_TABLE` which means source table name. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        :param pulumi.Input[_builtins.str] options: Recovery options. **NOTE:** Required while source_type equals `OSS` or `NAS`, invalid while source_type equals `ECS_FILE`. It's a json string with format:`"{"includes":[],"excludes":[]}",`. Recovery options. When restores OTS_TABLE and real target time is the rangEnd time of the snapshot, it should be a string with format: `{"UI_TargetTime":1650032529018}`.
        :param pulumi.Input[Union['RestoreJobOtsDetailArgs', 'RestoreJobOtsDetailArgsDict']] ots_detail: The details about the Tablestore instance. See the following `Block ots_detail`.
        :param pulumi.Input[_builtins.str] restore_job_id: Restore Job ID. It's the unique key of this resource, if you want to set this argument by yourself, you must specify a unique keyword that never appears.
        :param pulumi.Input[_builtins.str] restore_type: The type of recovery destination. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS_ROLLBACK`. **Note**: Currently, there is a one-to-one correspondence between the data source type with the recovery destination type.
        :param pulumi.Input[_builtins.str] snapshot_hash: The hashcode of Snapshot.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of Snapshot.
        :param pulumi.Input[_builtins.str] source_type: The type of data source. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS`.
        :param pulumi.Input[_builtins.str] status: The Restore Job Status.
        :param pulumi.Input[_builtins.str] target_bucket: The target name of OSS bucket. **NOTE:** Required while source_type equals `OSS`,
        :param pulumi.Input[_builtins.str] target_client_id: The target client ID.
        :param pulumi.Input[_builtins.str] target_create_time: The creation time of destination File System. **NOTE:** While source_type equals `NAS`, this parameter must be set. **Note:** The time format of the API adopts the ISO 8601 format, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
        :param pulumi.Input[_builtins.str] target_data_source_id: The target data source ID.
        :param pulumi.Input[_builtins.str] target_file_system_id: The ID of destination File System. **NOTE:** Required while source_type equals `NAS`
        :param pulumi.Input[_builtins.str] target_instance_id: The target ID of ECS instance. **NOTE:** Required while source_type equals `ECS_FILE`
        :param pulumi.Input[_builtins.str] target_instance_name: The name of the Table store instance to which you want to restore data.**WARNING:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[_builtins.str] target_path: The target file path of (ECS) instance. **WARNING:** Required while source_type equals `NAS` or `ECS_FILE`, If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        :param pulumi.Input[_builtins.str] target_prefix: The target prefix of the OSS object. **WARNING:** Required while source_type equals `OSS`. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        :param pulumi.Input[_builtins.str] target_table_name: The name of the table that stores the restored data. **WARNING:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[_builtins.str] target_time: The time when data is restored to the Table store instance. This value is a UNIX timestamp. Unit: seconds. **WARNING:** Required while source_type equals `OTS_TABLE`. **Note:** The time when data is restored to the Tablestore instance. It should be 0 if restores data at the End time of the snapshot.
        :param pulumi.Input[_builtins.str] udm_detail: The full machine backup details.
        :param pulumi.Input[_builtins.str] vault_id: The ID of backup vault.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RestoreJobState.__new__(_RestoreJobState)

        __props__.__dict__["cross_account_role_name"] = cross_account_role_name
        __props__.__dict__["cross_account_type"] = cross_account_type
        __props__.__dict__["cross_account_user_id"] = cross_account_user_id
        __props__.__dict__["exclude"] = exclude
        __props__.__dict__["include"] = include
        __props__.__dict__["options"] = options
        __props__.__dict__["ots_detail"] = ots_detail
        __props__.__dict__["restore_job_id"] = restore_job_id
        __props__.__dict__["restore_type"] = restore_type
        __props__.__dict__["snapshot_hash"] = snapshot_hash
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["status"] = status
        __props__.__dict__["target_bucket"] = target_bucket
        __props__.__dict__["target_client_id"] = target_client_id
        __props__.__dict__["target_create_time"] = target_create_time
        __props__.__dict__["target_data_source_id"] = target_data_source_id
        __props__.__dict__["target_file_system_id"] = target_file_system_id
        __props__.__dict__["target_instance_id"] = target_instance_id
        __props__.__dict__["target_instance_name"] = target_instance_name
        __props__.__dict__["target_path"] = target_path
        __props__.__dict__["target_prefix"] = target_prefix
        __props__.__dict__["target_table_name"] = target_table_name
        __props__.__dict__["target_time"] = target_time
        __props__.__dict__["udm_detail"] = udm_detail
        __props__.__dict__["vault_id"] = vault_id
        return RestoreJob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The role name created in the original account RAM backup by the cross account managed by the current account.
        """
        return pulumi.get(self, "cross_account_role_name")

    @_builtins.property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        """
        return pulumi.get(self, "cross_account_type")

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The original account ID of the cross account backup managed by the current account.
        """
        return pulumi.get(self, "cross_account_user_id")

    @_builtins.property
    @pulumi.getter
    def exclude(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The exclude path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/excludePath]`, up to 255 characters. **WARNING:** If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        """
        return pulumi.get(self, "exclude")

    @_builtins.property
    @pulumi.getter
    def include(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The include path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/includePath"]`, Up to 255 characters. **WARNING:** The field is required while source_type equals `OTS_TABLE` which means source table name. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        """
        return pulumi.get(self, "include")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Recovery options. **NOTE:** Required while source_type equals `OSS` or `NAS`, invalid while source_type equals `ECS_FILE`. It's a json string with format:`"{"includes":[],"excludes":[]}",`. Recovery options. When restores OTS_TABLE and real target time is the rangEnd time of the snapshot, it should be a string with format: `{"UI_TargetTime":1650032529018}`.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="otsDetail")
    def ots_detail(self) -> pulumi.Output['outputs.RestoreJobOtsDetail']:
        """
        The details about the Tablestore instance. See the following `Block ots_detail`.
        """
        return pulumi.get(self, "ots_detail")

    @_builtins.property
    @pulumi.getter(name="restoreJobId")
    def restore_job_id(self) -> pulumi.Output[_builtins.str]:
        """
        Restore Job ID. It's the unique key of this resource, if you want to set this argument by yourself, you must specify a unique keyword that never appears.
        """
        return pulumi.get(self, "restore_job_id")

    @_builtins.property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of recovery destination. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS_ROLLBACK`. **Note**: Currently, there is a one-to-one correspondence between the data source type with the recovery destination type.
        """
        return pulumi.get(self, "restore_type")

    @_builtins.property
    @pulumi.getter(name="snapshotHash")
    def snapshot_hash(self) -> pulumi.Output[_builtins.str]:
        """
        The hashcode of Snapshot.
        """
        return pulumi.get(self, "snapshot_hash")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of Snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of data source. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS`.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The Restore Job Status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The target name of OSS bucket. **NOTE:** Required while source_type equals `OSS`,
        """
        return pulumi.get(self, "target_bucket")

    @_builtins.property
    @pulumi.getter(name="targetClientId")
    def target_client_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The target client ID.
        """
        return pulumi.get(self, "target_client_id")

    @_builtins.property
    @pulumi.getter(name="targetCreateTime")
    def target_create_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The creation time of destination File System. **NOTE:** While source_type equals `NAS`, this parameter must be set. **Note:** The time format of the API adopts the ISO 8601 format, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
        """
        return pulumi.get(self, "target_create_time")

    @_builtins.property
    @pulumi.getter(name="targetDataSourceId")
    def target_data_source_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The target data source ID.
        """
        return pulumi.get(self, "target_data_source_id")

    @_builtins.property
    @pulumi.getter(name="targetFileSystemId")
    def target_file_system_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of destination File System. **NOTE:** Required while source_type equals `NAS`
        """
        return pulumi.get(self, "target_file_system_id")

    @_builtins.property
    @pulumi.getter(name="targetInstanceId")
    def target_instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The target ID of ECS instance. **NOTE:** Required while source_type equals `ECS_FILE`
        """
        return pulumi.get(self, "target_instance_id")

    @_builtins.property
    @pulumi.getter(name="targetInstanceName")
    def target_instance_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the Table store instance to which you want to restore data.**WARNING:** Required while source_type equals `OTS_TABLE`.
        """
        return pulumi.get(self, "target_instance_name")

    @_builtins.property
    @pulumi.getter(name="targetPath")
    def target_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The target file path of (ECS) instance. **WARNING:** Required while source_type equals `NAS` or `ECS_FILE`, If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        """
        return pulumi.get(self, "target_path")

    @_builtins.property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The target prefix of the OSS object. **WARNING:** Required while source_type equals `OSS`. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
        """
        return pulumi.get(self, "target_prefix")

    @_builtins.property
    @pulumi.getter(name="targetTableName")
    def target_table_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the table that stores the restored data. **WARNING:** Required while source_type equals `OTS_TABLE`.
        """
        return pulumi.get(self, "target_table_name")

    @_builtins.property
    @pulumi.getter(name="targetTime")
    def target_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The time when data is restored to the Table store instance. This value is a UNIX timestamp. Unit: seconds. **WARNING:** Required while source_type equals `OTS_TABLE`. **Note:** The time when data is restored to the Tablestore instance. It should be 0 if restores data at the End time of the snapshot.
        """
        return pulumi.get(self, "target_time")

    @_builtins.property
    @pulumi.getter(name="udmDetail")
    def udm_detail(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The full machine backup details.
        """
        return pulumi.get(self, "udm_detail")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")

