# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 instance_name: pulumi.Input[_builtins.str],
                 instance_type: pulumi.Input[_builtins.str],
                 payment_type: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 cold_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu: Optional[pulumi.Input[_builtins.int]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]]] = None,
                 gateway_count: Optional[pulumi.Input[_builtins.int]] = None,
                 initial_databases: Optional[pulumi.Input[_builtins.str]] = None,
                 leader_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] instance_name: The name of the resource.
        :param pulumi.Input[_builtins.str] instance_type: The instance type. Value:
               - Standard: Universal.
               - Follower: Read-only slave instance.
               - Warehouse: calculation group type.
               - Shared: Shared.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource.
        :param pulumi.Input[_builtins.str] zone_id: The zone Id. Refer to "Instructions for Use".
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. The default value is true. Value:
               - true: automatic payment
               - false: only generate orders, not pay
               > **NOTE:**  The default value is true. If the balance of your payment method is insufficient, you can set the parameter AutoPay to false, and an unpaid order will be generated. You can log in to the user Center to pay by yourself.
        :param pulumi.Input[_builtins.int] cold_storage_size: Instance low-frequency storage space. Unit: GB.
               > **NOTE:**  PayAsYouGo (PostPaid) instances ignore this parameter.
        :param pulumi.Input[_builtins.int] cpu: Instance specifications. Value:
               - 8 cores 32 GB (number of compute nodes: 1)
               - 16 cores 64 GB (number of compute nodes: 1)
               - 32 core 128 GB (number of compute nodes: 2)
               - 64 core 256 GB (number of compute nodes: 4)
               - 96 core 384 GB (number of computing nodes: 6)
               - 128 core 512 GB (number of compute nodes: 8)
               > **NOTE:** Just fill in the audit number. Please submit a work order application for purchasing 1024 or above specifications. Shared instance types do not need to specify specifications. The specification of - 8 core 32GB (number of computing nodes: 1) is only for experience use and cannot be used for production.
        :param pulumi.Input[_builtins.int] duration: The buying cycle. Buy for 2 months. If the Payment type is PayAsYouGo (PostPaid), you do not need to specify it.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]] endpoints: List of domain names. See `endpoints` below.
        :param pulumi.Input[_builtins.int] gateway_count: Number of gateway nodes.
        :param pulumi.Input[_builtins.str] initial_databases: Initialize the database and split multiple database names ",".
        :param pulumi.Input[_builtins.str] leader_instance_id: The ID of the primary instance.
        :param pulumi.Input[_builtins.str] pricing_cycle: Billing cycle. Value:
               - Month: monthly billing
               - Hour: hourly billing
               > **NOTE:**  Subscription instances (PrePaid) only supports Month. PayAsYouGo instances (PostPaid) only supports Hour. The Shared type is automatically set to Hour without specifying it.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] scale_type: Change matching type. Value:
               - UPGRADE: UPGRADE
               - DOWNGRADE: Downgrading
               > **NOTE:** The upgrade specification cannot be less than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is larger than the original specification. The downgrading specification cannot be greater than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is smaller than the original specification.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.int] storage_size: The standard storage space of the instance. Unit: GB.
               > **NOTE:**  PayAsYouGo instances (PostPaid) ignore this parameter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Instance tag.
        """
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "zone_id", zone_id)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if cold_storage_size is not None:
            pulumi.set(__self__, "cold_storage_size", cold_storage_size)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if gateway_count is not None:
            pulumi.set(__self__, "gateway_count", gateway_count)
        if initial_databases is not None:
            pulumi.set(__self__, "initial_databases", initial_databases)
        if leader_instance_id is not None:
            pulumi.set(__self__, "leader_instance_id", leader_instance_id)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scale_type is not None:
            pulumi.set(__self__, "scale_type", scale_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_size is not None:
            pulumi.set(__self__, "storage_size", storage_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        The instance type. Value:
        - Standard: Universal.
        - Follower: Read-only slave instance.
        - Warehouse: calculation group type.
        - Shared: Shared.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The zone Id. Refer to "Instructions for Use".
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to pay automatically. The default value is true. Value:
        - true: automatic payment
        - false: only generate orders, not pay
        > **NOTE:**  The default value is true. If the balance of your payment method is insufficient, you can set the parameter AutoPay to false, and an unpaid order will be generated. You can log in to the user Center to pay by yourself.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="coldStorageSize")
    def cold_storage_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance low-frequency storage space. Unit: GB.
        > **NOTE:**  PayAsYouGo (PostPaid) instances ignore this parameter.
        """
        return pulumi.get(self, "cold_storage_size")

    @cold_storage_size.setter
    def cold_storage_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cold_storage_size", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance specifications. Value:
        - 8 cores 32 GB (number of compute nodes: 1)
        - 16 cores 64 GB (number of compute nodes: 1)
        - 32 core 128 GB (number of compute nodes: 2)
        - 64 core 256 GB (number of compute nodes: 4)
        - 96 core 384 GB (number of computing nodes: 6)
        - 128 core 512 GB (number of compute nodes: 8)
        > **NOTE:** Just fill in the audit number. Please submit a work order application for purchasing 1024 or above specifications. Shared instance types do not need to specify specifications. The specification of - 8 core 32GB (number of computing nodes: 1) is only for experience use and cannot be used for production.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The buying cycle. Buy for 2 months. If the Payment type is PayAsYouGo (PostPaid), you do not need to specify it.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]]]:
        """
        List of domain names. See `endpoints` below.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @_builtins.property
    @pulumi.getter(name="gatewayCount")
    def gateway_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of gateway nodes.
        """
        return pulumi.get(self, "gateway_count")

    @gateway_count.setter
    def gateway_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "gateway_count", value)

    @_builtins.property
    @pulumi.getter(name="initialDatabases")
    def initial_databases(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Initialize the database and split multiple database names ",".
        """
        return pulumi.get(self, "initial_databases")

    @initial_databases.setter
    def initial_databases(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "initial_databases", value)

    @_builtins.property
    @pulumi.getter(name="leaderInstanceId")
    def leader_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the primary instance.
        """
        return pulumi.get(self, "leader_instance_id")

    @leader_instance_id.setter
    def leader_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "leader_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Billing cycle. Value:
        - Month: monthly billing
        - Hour: hourly billing
        > **NOTE:**  Subscription instances (PrePaid) only supports Month. PayAsYouGo instances (PostPaid) only supports Hour. The Shared type is automatically set to Hour without specifying it.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Change matching type. Value:
        - UPGRADE: UPGRADE
        - DOWNGRADE: Downgrading
        > **NOTE:** The upgrade specification cannot be less than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is larger than the original specification. The downgrading specification cannot be greater than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is smaller than the original specification.
        """
        return pulumi.get(self, "scale_type")

    @scale_type.setter
    def scale_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scale_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The standard storage space of the instance. Unit: GB.
        > **NOTE:**  PayAsYouGo instances (PostPaid) ignore this parameter.
        """
        return pulumi.get(self, "storage_size")

    @storage_size.setter
    def storage_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_size", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Instance tag.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 cold_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu: Optional[pulumi.Input[_builtins.int]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]]] = None,
                 gateway_count: Optional[pulumi.Input[_builtins.int]] = None,
                 initial_databases: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 leader_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. The default value is true. Value:
               - true: automatic payment
               - false: only generate orders, not pay
               > **NOTE:**  The default value is true. If the balance of your payment method is insufficient, you can set the parameter AutoPay to false, and an unpaid order will be generated. You can log in to the user Center to pay by yourself.
        :param pulumi.Input[_builtins.int] cold_storage_size: Instance low-frequency storage space. Unit: GB.
               > **NOTE:**  PayAsYouGo (PostPaid) instances ignore this parameter.
        :param pulumi.Input[_builtins.int] cpu: Instance specifications. Value:
               - 8 cores 32 GB (number of compute nodes: 1)
               - 16 cores 64 GB (number of compute nodes: 1)
               - 32 core 128 GB (number of compute nodes: 2)
               - 64 core 256 GB (number of compute nodes: 4)
               - 96 core 384 GB (number of computing nodes: 6)
               - 128 core 512 GB (number of compute nodes: 8)
               > **NOTE:** Just fill in the audit number. Please submit a work order application for purchasing 1024 or above specifications. Shared instance types do not need to specify specifications. The specification of - 8 core 32GB (number of computing nodes: 1) is only for experience use and cannot be used for production.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.int] duration: The buying cycle. Buy for 2 months. If the Payment type is PayAsYouGo (PostPaid), you do not need to specify it.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]] endpoints: List of domain names. See `endpoints` below.
        :param pulumi.Input[_builtins.int] gateway_count: Number of gateway nodes.
        :param pulumi.Input[_builtins.str] initial_databases: Initialize the database and split multiple database names ",".
        :param pulumi.Input[_builtins.str] instance_name: The name of the resource.
        :param pulumi.Input[_builtins.str] instance_type: The instance type. Value:
               - Standard: Universal.
               - Follower: Read-only slave instance.
               - Warehouse: calculation group type.
               - Shared: Shared.
        :param pulumi.Input[_builtins.str] leader_instance_id: The ID of the primary instance.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource.
        :param pulumi.Input[_builtins.str] pricing_cycle: Billing cycle. Value:
               - Month: monthly billing
               - Hour: hourly billing
               > **NOTE:**  Subscription instances (PrePaid) only supports Month. PayAsYouGo instances (PostPaid) only supports Hour. The Shared type is automatically set to Hour without specifying it.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] scale_type: Change matching type. Value:
               - UPGRADE: UPGRADE
               - DOWNGRADE: Downgrading
               > **NOTE:** The upgrade specification cannot be less than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is larger than the original specification. The downgrading specification cannot be greater than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is smaller than the original specification.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.int] storage_size: The standard storage space of the instance. Unit: GB.
               > **NOTE:**  PayAsYouGo instances (PostPaid) ignore this parameter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Instance tag.
        :param pulumi.Input[_builtins.str] zone_id: The zone Id. Refer to "Instructions for Use".
        """
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if cold_storage_size is not None:
            pulumi.set(__self__, "cold_storage_size", cold_storage_size)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if gateway_count is not None:
            pulumi.set(__self__, "gateway_count", gateway_count)
        if initial_databases is not None:
            pulumi.set(__self__, "initial_databases", initial_databases)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if leader_instance_id is not None:
            pulumi.set(__self__, "leader_instance_id", leader_instance_id)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scale_type is not None:
            pulumi.set(__self__, "scale_type", scale_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_size is not None:
            pulumi.set(__self__, "storage_size", storage_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to pay automatically. The default value is true. Value:
        - true: automatic payment
        - false: only generate orders, not pay
        > **NOTE:**  The default value is true. If the balance of your payment method is insufficient, you can set the parameter AutoPay to false, and an unpaid order will be generated. You can log in to the user Center to pay by yourself.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="coldStorageSize")
    def cold_storage_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance low-frequency storage space. Unit: GB.
        > **NOTE:**  PayAsYouGo (PostPaid) instances ignore this parameter.
        """
        return pulumi.get(self, "cold_storage_size")

    @cold_storage_size.setter
    def cold_storage_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cold_storage_size", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance specifications. Value:
        - 8 cores 32 GB (number of compute nodes: 1)
        - 16 cores 64 GB (number of compute nodes: 1)
        - 32 core 128 GB (number of compute nodes: 2)
        - 64 core 256 GB (number of compute nodes: 4)
        - 96 core 384 GB (number of computing nodes: 6)
        - 128 core 512 GB (number of compute nodes: 8)
        > **NOTE:** Just fill in the audit number. Please submit a work order application for purchasing 1024 or above specifications. Shared instance types do not need to specify specifications. The specification of - 8 core 32GB (number of computing nodes: 1) is only for experience use and cannot be used for production.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The buying cycle. Buy for 2 months. If the Payment type is PayAsYouGo (PostPaid), you do not need to specify it.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]]]:
        """
        List of domain names. See `endpoints` below.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @_builtins.property
    @pulumi.getter(name="gatewayCount")
    def gateway_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of gateway nodes.
        """
        return pulumi.get(self, "gateway_count")

    @gateway_count.setter
    def gateway_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "gateway_count", value)

    @_builtins.property
    @pulumi.getter(name="initialDatabases")
    def initial_databases(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Initialize the database and split multiple database names ",".
        """
        return pulumi.get(self, "initial_databases")

    @initial_databases.setter
    def initial_databases(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "initial_databases", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance type. Value:
        - Standard: Universal.
        - Follower: Read-only slave instance.
        - Warehouse: calculation group type.
        - Shared: Shared.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="leaderInstanceId")
    def leader_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the primary instance.
        """
        return pulumi.get(self, "leader_instance_id")

    @leader_instance_id.setter
    def leader_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "leader_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Billing cycle. Value:
        - Month: monthly billing
        - Hour: hourly billing
        > **NOTE:**  Subscription instances (PrePaid) only supports Month. PayAsYouGo instances (PostPaid) only supports Hour. The Shared type is automatically set to Hour without specifying it.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Change matching type. Value:
        - UPGRADE: UPGRADE
        - DOWNGRADE: Downgrading
        > **NOTE:** The upgrade specification cannot be less than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is larger than the original specification. The downgrading specification cannot be greater than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is smaller than the original specification.
        """
        return pulumi.get(self, "scale_type")

    @scale_type.setter
    def scale_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scale_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The standard storage space of the instance. Unit: GB.
        > **NOTE:**  PayAsYouGo instances (PostPaid) ignore this parameter.
        """
        return pulumi.get(self, "storage_size")

    @storage_size.setter
    def storage_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_size", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Instance tag.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone Id. Refer to "Instructions for Use".
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:hologram/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 cold_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu: Optional[pulumi.Input[_builtins.int]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEndpointArgs', 'InstanceEndpointArgsDict']]]]] = None,
                 gateway_count: Optional[pulumi.Input[_builtins.int]] = None,
                 initial_databases: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 leader_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Hologram Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:hologram/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. The default value is true. Value:
               - true: automatic payment
               - false: only generate orders, not pay
               > **NOTE:**  The default value is true. If the balance of your payment method is insufficient, you can set the parameter AutoPay to false, and an unpaid order will be generated. You can log in to the user Center to pay by yourself.
        :param pulumi.Input[_builtins.int] cold_storage_size: Instance low-frequency storage space. Unit: GB.
               > **NOTE:**  PayAsYouGo (PostPaid) instances ignore this parameter.
        :param pulumi.Input[_builtins.int] cpu: Instance specifications. Value:
               - 8 cores 32 GB (number of compute nodes: 1)
               - 16 cores 64 GB (number of compute nodes: 1)
               - 32 core 128 GB (number of compute nodes: 2)
               - 64 core 256 GB (number of compute nodes: 4)
               - 96 core 384 GB (number of computing nodes: 6)
               - 128 core 512 GB (number of compute nodes: 8)
               > **NOTE:** Just fill in the audit number. Please submit a work order application for purchasing 1024 or above specifications. Shared instance types do not need to specify specifications. The specification of - 8 core 32GB (number of computing nodes: 1) is only for experience use and cannot be used for production.
        :param pulumi.Input[_builtins.int] duration: The buying cycle. Buy for 2 months. If the Payment type is PayAsYouGo (PostPaid), you do not need to specify it.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceEndpointArgs', 'InstanceEndpointArgsDict']]]] endpoints: List of domain names. See `endpoints` below.
        :param pulumi.Input[_builtins.int] gateway_count: Number of gateway nodes.
        :param pulumi.Input[_builtins.str] initial_databases: Initialize the database and split multiple database names ",".
        :param pulumi.Input[_builtins.str] instance_name: The name of the resource.
        :param pulumi.Input[_builtins.str] instance_type: The instance type. Value:
               - Standard: Universal.
               - Follower: Read-only slave instance.
               - Warehouse: calculation group type.
               - Shared: Shared.
        :param pulumi.Input[_builtins.str] leader_instance_id: The ID of the primary instance.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource.
        :param pulumi.Input[_builtins.str] pricing_cycle: Billing cycle. Value:
               - Month: monthly billing
               - Hour: hourly billing
               > **NOTE:**  Subscription instances (PrePaid) only supports Month. PayAsYouGo instances (PostPaid) only supports Hour. The Shared type is automatically set to Hour without specifying it.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] scale_type: Change matching type. Value:
               - UPGRADE: UPGRADE
               - DOWNGRADE: Downgrading
               > **NOTE:** The upgrade specification cannot be less than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is larger than the original specification. The downgrading specification cannot be greater than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is smaller than the original specification.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.int] storage_size: The standard storage space of the instance. Unit: GB.
               > **NOTE:**  PayAsYouGo instances (PostPaid) ignore this parameter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Instance tag.
        :param pulumi.Input[_builtins.str] zone_id: The zone Id. Refer to "Instructions for Use".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Hologram Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:hologram/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 cold_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu: Optional[pulumi.Input[_builtins.int]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEndpointArgs', 'InstanceEndpointArgsDict']]]]] = None,
                 gateway_count: Optional[pulumi.Input[_builtins.int]] = None,
                 initial_databases: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 leader_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["cold_storage_size"] = cold_storage_size
            __props__.__dict__["cpu"] = cpu
            __props__.__dict__["duration"] = duration
            __props__.__dict__["endpoints"] = endpoints
            __props__.__dict__["gateway_count"] = gateway_count
            __props__.__dict__["initial_databases"] = initial_databases
            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["leader_instance_id"] = leader_instance_id
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["pricing_cycle"] = pricing_cycle
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["scale_type"] = scale_type
            __props__.__dict__["status"] = status
            __props__.__dict__["storage_size"] = storage_size
            __props__.__dict__["tags"] = tags
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["create_time"] = None
        super(Instance, __self__).__init__(
            'alicloud:hologram/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
            cold_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
            cpu: Optional[pulumi.Input[_builtins.int]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            duration: Optional[pulumi.Input[_builtins.int]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEndpointArgs', 'InstanceEndpointArgsDict']]]]] = None,
            gateway_count: Optional[pulumi.Input[_builtins.int]] = None,
            initial_databases: Optional[pulumi.Input[_builtins.str]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            leader_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            scale_type: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_size: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. The default value is true. Value:
               - true: automatic payment
               - false: only generate orders, not pay
               > **NOTE:**  The default value is true. If the balance of your payment method is insufficient, you can set the parameter AutoPay to false, and an unpaid order will be generated. You can log in to the user Center to pay by yourself.
        :param pulumi.Input[_builtins.int] cold_storage_size: Instance low-frequency storage space. Unit: GB.
               > **NOTE:**  PayAsYouGo (PostPaid) instances ignore this parameter.
        :param pulumi.Input[_builtins.int] cpu: Instance specifications. Value:
               - 8 cores 32 GB (number of compute nodes: 1)
               - 16 cores 64 GB (number of compute nodes: 1)
               - 32 core 128 GB (number of compute nodes: 2)
               - 64 core 256 GB (number of compute nodes: 4)
               - 96 core 384 GB (number of computing nodes: 6)
               - 128 core 512 GB (number of compute nodes: 8)
               > **NOTE:** Just fill in the audit number. Please submit a work order application for purchasing 1024 or above specifications. Shared instance types do not need to specify specifications. The specification of - 8 core 32GB (number of computing nodes: 1) is only for experience use and cannot be used for production.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.int] duration: The buying cycle. Buy for 2 months. If the Payment type is PayAsYouGo (PostPaid), you do not need to specify it.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceEndpointArgs', 'InstanceEndpointArgsDict']]]] endpoints: List of domain names. See `endpoints` below.
        :param pulumi.Input[_builtins.int] gateway_count: Number of gateway nodes.
        :param pulumi.Input[_builtins.str] initial_databases: Initialize the database and split multiple database names ",".
        :param pulumi.Input[_builtins.str] instance_name: The name of the resource.
        :param pulumi.Input[_builtins.str] instance_type: The instance type. Value:
               - Standard: Universal.
               - Follower: Read-only slave instance.
               - Warehouse: calculation group type.
               - Shared: Shared.
        :param pulumi.Input[_builtins.str] leader_instance_id: The ID of the primary instance.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource.
        :param pulumi.Input[_builtins.str] pricing_cycle: Billing cycle. Value:
               - Month: monthly billing
               - Hour: hourly billing
               > **NOTE:**  Subscription instances (PrePaid) only supports Month. PayAsYouGo instances (PostPaid) only supports Hour. The Shared type is automatically set to Hour without specifying it.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] scale_type: Change matching type. Value:
               - UPGRADE: UPGRADE
               - DOWNGRADE: Downgrading
               > **NOTE:** The upgrade specification cannot be less than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is larger than the original specification. The downgrading specification cannot be greater than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is smaller than the original specification.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.int] storage_size: The standard storage space of the instance. Unit: GB.
               > **NOTE:**  PayAsYouGo instances (PostPaid) ignore this parameter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Instance tag.
        :param pulumi.Input[_builtins.str] zone_id: The zone Id. Refer to "Instructions for Use".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["cold_storage_size"] = cold_storage_size
        __props__.__dict__["cpu"] = cpu
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["duration"] = duration
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["gateway_count"] = gateway_count
        __props__.__dict__["initial_databases"] = initial_databases
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["leader_instance_id"] = leader_instance_id
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["pricing_cycle"] = pricing_cycle
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["scale_type"] = scale_type
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_size"] = storage_size
        __props__.__dict__["tags"] = tags
        __props__.__dict__["zone_id"] = zone_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to pay automatically. The default value is true. Value:
        - true: automatic payment
        - false: only generate orders, not pay
        > **NOTE:**  The default value is true. If the balance of your payment method is insufficient, you can set the parameter AutoPay to false, and an unpaid order will be generated. You can log in to the user Center to pay by yourself.
        """
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="coldStorageSize")
    def cold_storage_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Instance low-frequency storage space. Unit: GB.
        > **NOTE:**  PayAsYouGo (PostPaid) instances ignore this parameter.
        """
        return pulumi.get(self, "cold_storage_size")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> pulumi.Output[_builtins.int]:
        """
        Instance specifications. Value:
        - 8 cores 32 GB (number of compute nodes: 1)
        - 16 cores 64 GB (number of compute nodes: 1)
        - 32 core 128 GB (number of compute nodes: 2)
        - 64 core 256 GB (number of compute nodes: 4)
        - 96 core 384 GB (number of computing nodes: 6)
        - 128 core 512 GB (number of compute nodes: 8)
        > **NOTE:** Just fill in the audit number. Please submit a work order application for purchasing 1024 or above specifications. Shared instance types do not need to specify specifications. The specification of - 8 core 32GB (number of computing nodes: 1) is only for experience use and cannot be used for production.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The buying cycle. Buy for 2 months. If the Payment type is PayAsYouGo (PostPaid), you do not need to specify it.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.InstanceEndpoint']]:
        """
        List of domain names. See `endpoints` below.
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter(name="gatewayCount")
    def gateway_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of gateway nodes.
        """
        return pulumi.get(self, "gateway_count")

    @_builtins.property
    @pulumi.getter(name="initialDatabases")
    def initial_databases(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Initialize the database and split multiple database names ",".
        """
        return pulumi.get(self, "initial_databases")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The instance type. Value:
        - Standard: Universal.
        - Follower: Read-only slave instance.
        - Warehouse: calculation group type.
        - Shared: Shared.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="leaderInstanceId")
    def leader_instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the primary instance.
        """
        return pulumi.get(self, "leader_instance_id")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Billing cycle. Value:
        - Month: monthly billing
        - Hour: hourly billing
        > **NOTE:**  Subscription instances (PrePaid) only supports Month. PayAsYouGo instances (PostPaid) only supports Hour. The Shared type is automatically set to Hour without specifying it.
        """
        return pulumi.get(self, "pricing_cycle")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Change matching type. Value:
        - UPGRADE: UPGRADE
        - DOWNGRADE: Downgrading
        > **NOTE:** The upgrade specification cannot be less than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is larger than the original specification. The downgrading specification cannot be greater than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is smaller than the original specification.
        """
        return pulumi.get(self, "scale_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The standard storage space of the instance. Unit: GB.
        > **NOTE:**  PayAsYouGo instances (PostPaid) ignore this parameter.
        """
        return pulumi.get(self, "storage_size")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Instance tag.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The zone Id. Refer to "Instructions for Use".
        """
        return pulumi.get(self, "zone_id")

